/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.Traces.ParCatsLib
{
    /// <summary>
    ///     The Dimension class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Dimension : IEquatable<Dimension>
    {
        /// <summary>
        ///     Sets the order in which categories in this dimension appear. Only has an
        ///     effect if <c>categoryorder</c> is set to <c>array</c>. Used with <c>categoryorder</c>.
        /// </summary>
        [JsonPropertyName(@"categoryarray")]
        public IList<object> CategoryArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>categoryarray</c>.
        /// </summary>
        [JsonPropertyName(@"categoryarraysrc")]
        public string CategoryArraySrc { get; set;} 

        /// <summary>
        ///     Specifies the ordering logic for the categories in the dimension. By default,
        ///     plotly uses <c>trace</c>, which specifies the order that is present in the
        ///     data supplied. Set <c>categoryorder</c> to &#39;category ascending&#39;
        ///     or &#39;category descending&#39; if order should be determined by the alphanumerical
        ///     order of the category names. Set <c>categoryorder</c> to <c>array</c> to
        ///     derive the ordering from the attribute <c>categoryarray</c>. If a category
        ///     is not found in the <c>categoryarray</c> array, the sorting behavior for
        ///     that attribute will be identical to the <c>trace</c> mode. The unspecified
        ///     categories will follow the categories in <c>categoryarray</c>.
        /// </summary>
        [JsonPropertyName(@"categoryorder")]
        public Plotly.Blazor.Traces.ParCatsLib.DimensionLib.CategoryOrderEnum? CategoryOrder { get; set;} 

        /// <summary>
        ///     The display index of dimension, from left to right, zero indexed, defaults
        ///     to dimension index.
        /// </summary>
        [JsonPropertyName(@"displayindex")]
        public int? DisplayIndex { get; set;} 

        /// <summary>
        ///     The shown name of the dimension.
        /// </summary>
        [JsonPropertyName(@"label")]
        public string Label { get; set;} 

        /// <summary>
        ///     Sets alternative tick labels for the categories in this dimension. Only
        ///     has an effect if <c>categoryorder</c> is set to <c>array</c>. Should be
        ///     an array the same length as <c>categoryarray</c> Used with <c>categoryorder</c>.
        /// </summary>
        [JsonPropertyName(@"ticktext")]
        public IList<object> TickText { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>ticktext</c>.
        /// </summary>
        [JsonPropertyName(@"ticktextsrc")]
        public string TickTextSrc { get; set;} 

        /// <summary>
        ///     Dimension values. <c>values[n]</c> represents the category value of the
        ///     <c>n</c>th point in the dataset, therefore the <c>values</c> vector for
        ///     all dimensions must be the same (longer vectors will be truncated).
        /// </summary>
        [JsonPropertyName(@"values")]
        public IList<object> Values { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>values</c>.
        /// </summary>
        [JsonPropertyName(@"valuessrc")]
        public string ValuesSrc { get; set;} 

        /// <summary>
        ///     Shows the dimension when set to <c>true</c> (the default). Hides the dimension
        ///     for <c>false</c>.
        /// </summary>
        [JsonPropertyName(@"visible")]
        public bool? Visible { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Dimension other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Dimension other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Equals(CategoryArray, other.CategoryArray) ||
                    CategoryArray != null && other.CategoryArray != null &&
                    CategoryArray.SequenceEqual(other.CategoryArray)
                ) &&
                (
                    CategoryArraySrc == other.CategoryArraySrc ||
                    CategoryArraySrc != null &&
                    CategoryArraySrc.Equals(other.CategoryArraySrc)
                ) && 
                (
                    CategoryOrder == other.CategoryOrder ||
                    CategoryOrder != null &&
                    CategoryOrder.Equals(other.CategoryOrder)
                ) && 
                (
                    DisplayIndex == other.DisplayIndex ||
                    DisplayIndex != null &&
                    DisplayIndex.Equals(other.DisplayIndex)
                ) && 
                (
                    Label == other.Label ||
                    Label != null &&
                    Label.Equals(other.Label)
                ) && 
                (
                    Equals(TickText, other.TickText) ||
                    TickText != null && other.TickText != null &&
                    TickText.SequenceEqual(other.TickText)
                ) &&
                (
                    TickTextSrc == other.TickTextSrc ||
                    TickTextSrc != null &&
                    TickTextSrc.Equals(other.TickTextSrc)
                ) && 
                (
                    Equals(Values, other.Values) ||
                    Values != null && other.Values != null &&
                    Values.SequenceEqual(other.Values)
                ) &&
                (
                    ValuesSrc == other.ValuesSrc ||
                    ValuesSrc != null &&
                    ValuesSrc.Equals(other.ValuesSrc)
                ) && 
                (
                    Visible == other.Visible ||
                    Visible != null &&
                    Visible.Equals(other.Visible)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (CategoryArray != null) hashCode = hashCode * 59 + CategoryArray.GetHashCode();
                if (CategoryArraySrc != null) hashCode = hashCode * 59 + CategoryArraySrc.GetHashCode();
                if (CategoryOrder != null) hashCode = hashCode * 59 + CategoryOrder.GetHashCode();
                if (DisplayIndex != null) hashCode = hashCode * 59 + DisplayIndex.GetHashCode();
                if (Label != null) hashCode = hashCode * 59 + Label.GetHashCode();
                if (TickText != null) hashCode = hashCode * 59 + TickText.GetHashCode();
                if (TickTextSrc != null) hashCode = hashCode * 59 + TickTextSrc.GetHashCode();
                if (Values != null) hashCode = hashCode * 59 + Values.GetHashCode();
                if (ValuesSrc != null) hashCode = hashCode * 59 + ValuesSrc.GetHashCode();
                if (Visible != null) hashCode = hashCode * 59 + Visible.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Dimension and the right Dimension.
        /// </summary>
        /// <param name="left">Left Dimension.</param>
        /// <param name="right">Right Dimension.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Dimension left, Dimension right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Dimension and the right Dimension.
        /// </summary>
        /// <param name="left">Left Dimension.</param>
        /// <param name="right">Right Dimension.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Dimension left, Dimension right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Dimension</returns>
        public Dimension DeepClone()
        {
            return this.Copy();
        }
    }
}