/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.Traces.IcicleLib
{
    /// <summary>
    ///     The Tiling class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Tiling : IEquatable<Tiling>
    {
        /// <summary>
        ///     Determines if the positions obtained from solver are flipped on each axis.
        /// </summary>
        [JsonPropertyName(@"flip")]
        public Plotly.Blazor.Traces.IcicleLib.TilingLib.FlipFlag? Flip { get; set;} 

        /// <summary>
        ///     When set in conjunction with <c>tiling.flip</c>, determines on which side
        ///     the root nodes are drawn in the chart. If <c>tiling.orientation</c> is <c>v</c>
        ///     and <c>tiling.flip</c> is *&#39;, the root nodes appear at the top. If <c>tiling.orientation</c>
        ///     is <c>v</c> and <c>tiling.flip</c> is <c>y</c>, the root nodes appear at
        ///     the bottom. If <c>tiling.orientation</c> is <c>h</c> and <c>tiling.flip</c>
        ///     is &#39;*, the root nodes appear at the left. If <c>tiling.orientation</c>
        ///     is <c>h</c> and <c>tiling.flip</c> is <c>x</c>, the root nodes appear at
        ///     the right.
        /// </summary>
        [JsonPropertyName(@"orientation")]
        public Plotly.Blazor.Traces.IcicleLib.TilingLib.OrientationEnum? Orientation { get; set;} 

        /// <summary>
        ///     Sets the inner padding (in px).
        /// </summary>
        [JsonPropertyName(@"pad")]
        public decimal? Pad { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Tiling other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Tiling other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Flip == other.Flip ||
                    Flip != null &&
                    Flip.Equals(other.Flip)
                ) && 
                (
                    Orientation == other.Orientation ||
                    Orientation != null &&
                    Orientation.Equals(other.Orientation)
                ) && 
                (
                    Pad == other.Pad ||
                    Pad != null &&
                    Pad.Equals(other.Pad)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Flip != null) hashCode = hashCode * 59 + Flip.GetHashCode();
                if (Orientation != null) hashCode = hashCode * 59 + Orientation.GetHashCode();
                if (Pad != null) hashCode = hashCode * 59 + Pad.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Tiling and the right Tiling.
        /// </summary>
        /// <param name="left">Left Tiling.</param>
        /// <param name="right">Right Tiling.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Tiling left, Tiling right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Tiling and the right Tiling.
        /// </summary>
        /// <param name="left">Left Tiling.</param>
        /// <param name="right">Right Tiling.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Tiling left, Tiling right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Tiling</returns>
        public Tiling DeepClone()
        {
            return this.Copy();
        }
    }
}