/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.LayoutLib
{
    /// <summary>
    ///     The Title class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Title : IEquatable<Title>
    {
        /// <summary>
        ///     Determines whether the title can automatically push the figure margins.
        ///     If <c>yref=<c>paper</c></c> then the margin will expand to ensure that the
        ///     title doesn’t overlap with the edges of the container. If <c>yref=<c>container</c></c>
        ///     then the margins will ensure that the title doesn’t overlap with the plot
        ///     area, tick labels, and axis titles. If <c>automargin=true</c> and the margins
        ///     need to be expanded, then y will be set to a default 1 and yanchor will
        ///     be set to an appropriate default to ensure that minimal margin space is
        ///     needed. Note that when <c>yref=<c>paper</c></c>, only 1 or 0 are allowed
        ///     y values. Invalid values will be reset to the default 1.
        /// </summary>
        [JsonPropertyName(@"automargin")]
        public bool? AutoMargin { get; set;} 

        /// <summary>
        ///     Sets the title font. Note that the title&#39;s font used to be customized
        ///     by the now deprecated <c>titlefont</c> attribute.
        /// </summary>
        [JsonPropertyName(@"font")]
        public Plotly.Blazor.LayoutLib.TitleLib.Font Font { get; set;} 

        /// <summary>
        ///     Sets the padding of the title. Each padding value only applies when the
        ///     corresponding <c>xanchor</c>/<c>yanchor</c> value is set accordingly. E.g.
        ///     for left padding to take effect, <c>xanchor</c> must be set to <c>left</c>.
        ///     The same rule applies if <c>xanchor</c>/<c>yanchor</c> is determined automatically.
        ///     Padding is muted if the respective anchor value is <c>middle</c>/<c>center</c>.
        /// </summary>
        [JsonPropertyName(@"pad")]
        public Plotly.Blazor.LayoutLib.TitleLib.Pad Pad { get; set;} 

        /// <summary>
        ///     Gets or sets the Subtitle.
        /// </summary>
        [JsonPropertyName(@"subtitle")]
        public Plotly.Blazor.LayoutLib.TitleLib.Subtitle Subtitle { get; set;} 

        /// <summary>
        ///     Sets the plot&#39;s title. Note that before the existence of <c>title.text</c>,
        ///     the title&#39;s contents used to be defined as the <c>title</c> attribute
        ///     itself. This behavior has been deprecated.
        /// </summary>
        [JsonPropertyName(@"text")]
        public string Text { get; set;} 

        /// <summary>
        ///     Sets the x position with respect to <c>xref</c> in normalized coordinates
        ///     from <c>0</c> (left) to <c>1</c> (right).
        /// </summary>
        [JsonPropertyName(@"x")]
        public decimal? X { get; set;} 

        /// <summary>
        ///     Sets the title&#39;s horizontal alignment with respect to its x position.
        ///     <c>left</c> means that the title starts at x, <c>right</c> means that the
        ///     title ends at x and <c>center</c> means that the title&#39;s center is at
        ///     x. <c>auto</c> divides <c>xref</c> by three and calculates the <c>xanchor</c>
        ///     value automatically based on the value of <c>x</c>.
        /// </summary>
        [JsonPropertyName(@"xanchor")]
        public Plotly.Blazor.LayoutLib.TitleLib.XAnchorEnum? XAnchor { get; set;} 

        /// <summary>
        ///     Sets the container <c>x</c> refers to. <c>container</c> spans the entire
        ///     <c>width</c> of the plot. <c>paper</c> refers to the width of the plotting
        ///     area only.
        /// </summary>
        [JsonPropertyName(@"xref")]
        public Plotly.Blazor.LayoutLib.TitleLib.XRefEnum? XRef { get; set;} 

        /// <summary>
        ///     Sets the y position with respect to <c>yref</c> in normalized coordinates
        ///     from <c>0</c> (bottom) to <c>1</c> (top). <c>auto</c> places the baseline
        ///     of the title onto the vertical center of the top margin.
        /// </summary>
        [JsonPropertyName(@"y")]
        public decimal? Y { get; set;} 

        /// <summary>
        ///     Sets the title&#39;s vertical alignment with respect to its y position.
        ///     <c>top</c> means that the title&#39;s cap line is at y, <c>bottom</c> means
        ///     that the title&#39;s baseline is at y and <c>middle</c> means that the title&#39;s
        ///     midline is at y. <c>auto</c> divides <c>yref</c> by three and calculates
        ///     the <c>yanchor</c> value automatically based on the value of <c>y</c>.
        /// </summary>
        [JsonPropertyName(@"yanchor")]
        public Plotly.Blazor.LayoutLib.TitleLib.YAnchorEnum? YAnchor { get; set;} 

        /// <summary>
        ///     Sets the container <c>y</c> refers to. <c>container</c> spans the entire
        ///     <c>height</c> of the plot. <c>paper</c> refers to the height of the plotting
        ///     area only.
        /// </summary>
        [JsonPropertyName(@"yref")]
        public Plotly.Blazor.LayoutLib.TitleLib.YRefEnum? YRef { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Title other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Title other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    AutoMargin == other.AutoMargin ||
                    AutoMargin != null &&
                    AutoMargin.Equals(other.AutoMargin)
                ) && 
                (
                    Font == other.Font ||
                    Font != null &&
                    Font.Equals(other.Font)
                ) && 
                (
                    Pad == other.Pad ||
                    Pad != null &&
                    Pad.Equals(other.Pad)
                ) && 
                (
                    Subtitle == other.Subtitle ||
                    Subtitle != null &&
                    Subtitle.Equals(other.Subtitle)
                ) && 
                (
                    Text == other.Text ||
                    Text != null &&
                    Text.Equals(other.Text)
                ) && 
                (
                    X == other.X ||
                    X != null &&
                    X.Equals(other.X)
                ) && 
                (
                    XAnchor == other.XAnchor ||
                    XAnchor != null &&
                    XAnchor.Equals(other.XAnchor)
                ) && 
                (
                    XRef == other.XRef ||
                    XRef != null &&
                    XRef.Equals(other.XRef)
                ) && 
                (
                    Y == other.Y ||
                    Y != null &&
                    Y.Equals(other.Y)
                ) && 
                (
                    YAnchor == other.YAnchor ||
                    YAnchor != null &&
                    YAnchor.Equals(other.YAnchor)
                ) && 
                (
                    YRef == other.YRef ||
                    YRef != null &&
                    YRef.Equals(other.YRef)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (AutoMargin != null) hashCode = hashCode * 59 + AutoMargin.GetHashCode();
                if (Font != null) hashCode = hashCode * 59 + Font.GetHashCode();
                if (Pad != null) hashCode = hashCode * 59 + Pad.GetHashCode();
                if (Subtitle != null) hashCode = hashCode * 59 + Subtitle.GetHashCode();
                if (Text != null) hashCode = hashCode * 59 + Text.GetHashCode();
                if (X != null) hashCode = hashCode * 59 + X.GetHashCode();
                if (XAnchor != null) hashCode = hashCode * 59 + XAnchor.GetHashCode();
                if (XRef != null) hashCode = hashCode * 59 + XRef.GetHashCode();
                if (Y != null) hashCode = hashCode * 59 + Y.GetHashCode();
                if (YAnchor != null) hashCode = hashCode * 59 + YAnchor.GetHashCode();
                if (YRef != null) hashCode = hashCode * 59 + YRef.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Title and the right Title.
        /// </summary>
        /// <param name="left">Left Title.</param>
        /// <param name="right">Right Title.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Title left, Title right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Title and the right Title.
        /// </summary>
        /// <param name="left">Left Title.</param>
        /// <param name="right">Right Title.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Title left, Title right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Title</returns>
        public Title DeepClone()
        {
            return this.Copy();
        }
    }
}