/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.LayoutLib.SceneLib
{
    /// <summary>
    ///     The Annotation class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Annotation : IEquatable<Annotation>
    {
        /// <summary>
        ///     Sets the horizontal alignment of the <c>text</c> within the box. Has an
        ///     effect only if <c>text</c> spans two or more lines (i.e. <c>text</c> contains
        ///     one or more &lt;br&gt; HTML tags) or if an explicit width is set to override
        ///     the text width.
        /// </summary>
        [JsonPropertyName(@"align")]
        public Plotly.Blazor.LayoutLib.SceneLib.AnnotationLib.AlignEnum? Align { get; set;} 

        /// <summary>
        ///     Sets the color of the annotation arrow.
        /// </summary>
        [JsonPropertyName(@"arrowcolor")]
        public object ArrowColor { get; set;} 

        /// <summary>
        ///     Sets the end annotation arrow head style.
        /// </summary>
        [JsonPropertyName(@"arrowhead")]
        public int? Arrowhead { get; set;} 

        /// <summary>
        ///     Sets the annotation arrow head position.
        /// </summary>
        [JsonPropertyName(@"arrowside")]
        public Plotly.Blazor.LayoutLib.SceneLib.AnnotationLib.ArrowSideFlag? ArrowSide { get; set;} 

        /// <summary>
        ///     Sets the size of the end annotation arrow head, relative to <c>arrowwidth</c>.
        ///     A value of 1 (default) gives a head about 3x as wide as the line.
        /// </summary>
        [JsonPropertyName(@"arrowsize")]
        public decimal? ArrowSize { get; set;} 

        /// <summary>
        ///     Sets the width (in px) of annotation arrow line.
        /// </summary>
        [JsonPropertyName(@"arrowwidth")]
        public decimal? ArrowWidth { get; set;} 

        /// <summary>
        ///     Sets the x component of the arrow tail about the arrow head (in pixels).
        /// </summary>
        [JsonPropertyName(@"ax")]
        public decimal? Ax { get; set;} 

        /// <summary>
        ///     Sets the y component of the arrow tail about the arrow head (in pixels).
        /// </summary>
        [JsonPropertyName(@"ay")]
        public decimal? Ay { get; set;} 

        /// <summary>
        ///     Sets the background color of the annotation.
        /// </summary>
        [JsonPropertyName(@"bgcolor")]
        public object BgColor { get; set;} 

        /// <summary>
        ///     Sets the color of the border enclosing the annotation <c>text</c>.
        /// </summary>
        [JsonPropertyName(@"bordercolor")]
        public object BorderColor { get; set;} 

        /// <summary>
        ///     Sets the padding (in px) between the <c>text</c> and the enclosing border.
        /// </summary>
        [JsonPropertyName(@"borderpad")]
        public decimal? BorderPad { get; set;} 

        /// <summary>
        ///     Sets the width (in px) of the border enclosing the annotation <c>text</c>.
        /// </summary>
        [JsonPropertyName(@"borderwidth")]
        public decimal? BorderWidth { get; set;} 

        /// <summary>
        ///     Determines whether the annotation text box captures mouse move and click
        ///     events, or allows those events to pass through to data points in the plot
        ///     that may be behind the annotation. By default <c>captureevents</c> is <c>false</c>
        ///     unless <c>hovertext</c> is provided. If you use the event <c>plotly_clickannotation</c>
        ///     without <c>hovertext</c> you must explicitly enable <c>captureevents</c>.
        /// </summary>
        [JsonPropertyName(@"captureevents")]
        public bool? CaptureEvents { get; set;} 

        /// <summary>
        ///     Sets the annotation text font.
        /// </summary>
        [JsonPropertyName(@"font")]
        public Plotly.Blazor.LayoutLib.SceneLib.AnnotationLib.Font Font { get; set;} 

        /// <summary>
        ///     Sets an explicit height for the text box. null (default) lets the text set
        ///     the box height. Taller text will be clipped.
        /// </summary>
        [JsonPropertyName(@"height")]
        public decimal? Height { get; set;} 

        /// <summary>
        ///     Gets or sets the HoverLabel.
        /// </summary>
        [JsonPropertyName(@"hoverlabel")]
        public Plotly.Blazor.LayoutLib.SceneLib.AnnotationLib.HoverLabel HoverLabel { get; set;} 

        /// <summary>
        ///     Sets text to appear when hovering over this annotation. If omitted or blank,
        ///     no hover label will appear.
        /// </summary>
        [JsonPropertyName(@"hovertext")]
        public string HoverText { get; set;} 

        /// <summary>
        ///     When used in a template, named items are created in the output figure in
        ///     addition to any items the figure already has in this array. You can modify
        ///     these items in the output figure by making your own item with <c>templateitemname</c>
        ///     matching this <c>name</c> alongside your modifications (including &#39;visible:
        ///     false&#39; or &#39;enabled: false&#39; to hide it). Has no effect outside
        ///     of a template.
        /// </summary>
        [JsonPropertyName(@"name")]
        public string Name { get; set;} 

        /// <summary>
        ///     Sets the opacity of the annotation (text + arrow).
        /// </summary>
        [JsonPropertyName(@"opacity")]
        public decimal? Opacity { get; set;} 

        /// <summary>
        ///     Determines whether or not the annotation is drawn with an arrow. If <c>true</c>,
        ///     <c>text</c> is placed near the arrow&#39;s tail. If <c>false</c>, <c>text</c>
        ///     lines up with the <c>x</c> and <c>y</c> provided.
        /// </summary>
        [JsonPropertyName(@"showarrow")]
        public bool? ShowArrow { get; set;} 

        /// <summary>
        ///     Sets a distance, in pixels, to move the end arrowhead away from the position
        ///     it is pointing at, for example to point at the edge of a marker independent
        ///     of zoom. Note that this shortens the arrow from the <c>ax</c> / <c>ay</c>
        ///     vector, in contrast to <c>xshift</c> / <c>yshift</c> which moves everything
        ///     by this amount.
        /// </summary>
        [JsonPropertyName(@"standoff")]
        public decimal? Standoff { get; set;} 

        /// <summary>
        ///     Sets the start annotation arrow head style.
        /// </summary>
        [JsonPropertyName(@"startarrowhead")]
        public int? StartArrowhead { get; set;} 

        /// <summary>
        ///     Sets the size of the start annotation arrow head, relative to <c>arrowwidth</c>.
        ///     A value of 1 (default) gives a head about 3x as wide as the line.
        /// </summary>
        [JsonPropertyName(@"startarrowsize")]
        public decimal? StartArrowSize { get; set;} 

        /// <summary>
        ///     Sets a distance, in pixels, to move the start arrowhead away from the position
        ///     it is pointing at, for example to point at the edge of a marker independent
        ///     of zoom. Note that this shortens the arrow from the <c>ax</c> / <c>ay</c>
        ///     vector, in contrast to <c>xshift</c> / <c>yshift</c> which moves everything
        ///     by this amount.
        /// </summary>
        [JsonPropertyName(@"startstandoff")]
        public decimal? StartStandoff { get; set;} 

        /// <summary>
        ///     Used to refer to a named item in this array in the template. Named items
        ///     from the template will be created even without a matching item in the input
        ///     figure, but you can modify one by making an item with <c>templateitemname</c>
        ///     matching its <c>name</c>, alongside your modifications (including &#39;visible:
        ///     false&#39; or &#39;enabled: false&#39; to hide it). If there is no template
        ///     or no matching item, this item will be hidden unless you explicitly show
        ///     it with &#39;visible: true&#39;.
        /// </summary>
        [JsonPropertyName(@"templateitemname")]
        public string TemplateItemName { get; set;} 

        /// <summary>
        ///     Sets the text associated with this annotation. Plotly uses a subset of HTML
        ///     tags to do things like newline (&lt;br&gt;), bold (&lt;b&gt;&lt;/b&gt;),
        ///     italics (&lt;i&gt;&lt;/i&gt;), hyperlinks (&lt;a href=<c>...</c>&gt;&lt;/a&gt;).
        ///     Tags &lt;em&gt;, &lt;sup&gt;, &lt;sub&gt;, &lt;s&gt;, &lt;u&gt; &lt;span&gt;
        ///     are also supported.
        /// </summary>
        [JsonPropertyName(@"text")]
        public string Text { get; set;} 

        /// <summary>
        ///     Sets the angle at which the <c>text</c> is drawn with respect to the horizontal.
        /// </summary>
        [JsonPropertyName(@"textangle")]
        public decimal? TextAngle { get; set;} 

        /// <summary>
        ///     Sets the vertical alignment of the <c>text</c> within the box. Has an effect
        ///     only if an explicit height is set to override the text height.
        /// </summary>
        [JsonPropertyName(@"valign")]
        public Plotly.Blazor.LayoutLib.SceneLib.AnnotationLib.VAlignEnum? VAlign { get; set;} 

        /// <summary>
        ///     Determines whether or not this annotation is visible.
        /// </summary>
        [JsonPropertyName(@"visible")]
        public bool? Visible { get; set;} 

        /// <summary>
        ///     Sets an explicit width for the text box. null (default) lets the text set
        ///     the box width. Wider text will be clipped. There is no automatic wrapping;
        ///     use &lt;br&gt; to start a new line.
        /// </summary>
        [JsonPropertyName(@"width")]
        public decimal? Width { get; set;} 

        /// <summary>
        ///     Sets the annotation&#39;s x position.
        /// </summary>
        [JsonPropertyName(@"x")]
        public object X { get; set;} 

        /// <summary>
        ///     Sets the text box&#39;s horizontal position anchor This anchor binds the
        ///     <c>x</c> position to the <c>left</c>, <c>center</c> or <c>right</c> of the
        ///     annotation. For example, if <c>x</c> is set to 1, <c>xref</c> to <c>paper</c>
        ///     and <c>xanchor</c> to <c>right</c> then the right-most portion of the annotation
        ///     lines up with the right-most edge of the plotting area. If <c>auto</c>,
        ///     the anchor is equivalent to <c>center</c> for data-referenced annotations
        ///     or if there is an arrow, whereas for paper-referenced with no arrow, the
        ///     anchor picked corresponds to the closest side.
        /// </summary>
        [JsonPropertyName(@"xanchor")]
        public Plotly.Blazor.LayoutLib.SceneLib.AnnotationLib.XAnchorEnum? XAnchor { get; set;} 

        /// <summary>
        ///     Shifts the position of the whole annotation and arrow to the right (positive)
        ///     or left (negative) by this many pixels.
        /// </summary>
        [JsonPropertyName(@"xshift")]
        public decimal? XShift { get; set;} 

        /// <summary>
        ///     Sets the annotation&#39;s y position.
        /// </summary>
        [JsonPropertyName(@"y")]
        public object Y { get; set;} 

        /// <summary>
        ///     Sets the text box&#39;s vertical position anchor This anchor binds the <c>y</c>
        ///     position to the <c>top</c>, <c>middle</c> or <c>bottom</c> of the annotation.
        ///     For example, if <c>y</c> is set to 1, <c>yref</c> to <c>paper</c> and <c>yanchor</c>
        ///     to <c>top</c> then the top-most portion of the annotation lines up with
        ///     the top-most edge of the plotting area. If <c>auto</c>, the anchor is equivalent
        ///     to <c>middle</c> for data-referenced annotations or if there is an arrow,
        ///     whereas for paper-referenced with no arrow, the anchor picked corresponds
        ///     to the closest side.
        /// </summary>
        [JsonPropertyName(@"yanchor")]
        public Plotly.Blazor.LayoutLib.SceneLib.AnnotationLib.YAnchorEnum? YAnchor { get; set;} 

        /// <summary>
        ///     Shifts the position of the whole annotation and arrow up (positive) or down
        ///     (negative) by this many pixels.
        /// </summary>
        [JsonPropertyName(@"yshift")]
        public decimal? YShift { get; set;} 

        /// <summary>
        ///     Sets the annotation&#39;s z position.
        /// </summary>
        [JsonPropertyName(@"z")]
        public object Z { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Annotation other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Annotation other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Align == other.Align ||
                    Align != null &&
                    Align.Equals(other.Align)
                ) && 
                (
                    ArrowColor == other.ArrowColor ||
                    ArrowColor != null &&
                    ArrowColor.Equals(other.ArrowColor)
                ) && 
                (
                    Arrowhead == other.Arrowhead ||
                    Arrowhead != null &&
                    Arrowhead.Equals(other.Arrowhead)
                ) && 
                (
                    ArrowSide == other.ArrowSide ||
                    ArrowSide != null &&
                    ArrowSide.Equals(other.ArrowSide)
                ) && 
                (
                    ArrowSize == other.ArrowSize ||
                    ArrowSize != null &&
                    ArrowSize.Equals(other.ArrowSize)
                ) && 
                (
                    ArrowWidth == other.ArrowWidth ||
                    ArrowWidth != null &&
                    ArrowWidth.Equals(other.ArrowWidth)
                ) && 
                (
                    Ax == other.Ax ||
                    Ax != null &&
                    Ax.Equals(other.Ax)
                ) && 
                (
                    Ay == other.Ay ||
                    Ay != null &&
                    Ay.Equals(other.Ay)
                ) && 
                (
                    BgColor == other.BgColor ||
                    BgColor != null &&
                    BgColor.Equals(other.BgColor)
                ) && 
                (
                    BorderColor == other.BorderColor ||
                    BorderColor != null &&
                    BorderColor.Equals(other.BorderColor)
                ) && 
                (
                    BorderPad == other.BorderPad ||
                    BorderPad != null &&
                    BorderPad.Equals(other.BorderPad)
                ) && 
                (
                    BorderWidth == other.BorderWidth ||
                    BorderWidth != null &&
                    BorderWidth.Equals(other.BorderWidth)
                ) && 
                (
                    CaptureEvents == other.CaptureEvents ||
                    CaptureEvents != null &&
                    CaptureEvents.Equals(other.CaptureEvents)
                ) && 
                (
                    Font == other.Font ||
                    Font != null &&
                    Font.Equals(other.Font)
                ) && 
                (
                    Height == other.Height ||
                    Height != null &&
                    Height.Equals(other.Height)
                ) && 
                (
                    HoverLabel == other.HoverLabel ||
                    HoverLabel != null &&
                    HoverLabel.Equals(other.HoverLabel)
                ) && 
                (
                    HoverText == other.HoverText ||
                    HoverText != null &&
                    HoverText.Equals(other.HoverText)
                ) && 
                (
                    Name == other.Name ||
                    Name != null &&
                    Name.Equals(other.Name)
                ) && 
                (
                    Opacity == other.Opacity ||
                    Opacity != null &&
                    Opacity.Equals(other.Opacity)
                ) && 
                (
                    ShowArrow == other.ShowArrow ||
                    ShowArrow != null &&
                    ShowArrow.Equals(other.ShowArrow)
                ) && 
                (
                    Standoff == other.Standoff ||
                    Standoff != null &&
                    Standoff.Equals(other.Standoff)
                ) && 
                (
                    StartArrowhead == other.StartArrowhead ||
                    StartArrowhead != null &&
                    StartArrowhead.Equals(other.StartArrowhead)
                ) && 
                (
                    StartArrowSize == other.StartArrowSize ||
                    StartArrowSize != null &&
                    StartArrowSize.Equals(other.StartArrowSize)
                ) && 
                (
                    StartStandoff == other.StartStandoff ||
                    StartStandoff != null &&
                    StartStandoff.Equals(other.StartStandoff)
                ) && 
                (
                    TemplateItemName == other.TemplateItemName ||
                    TemplateItemName != null &&
                    TemplateItemName.Equals(other.TemplateItemName)
                ) && 
                (
                    Text == other.Text ||
                    Text != null &&
                    Text.Equals(other.Text)
                ) && 
                (
                    TextAngle == other.TextAngle ||
                    TextAngle != null &&
                    TextAngle.Equals(other.TextAngle)
                ) && 
                (
                    VAlign == other.VAlign ||
                    VAlign != null &&
                    VAlign.Equals(other.VAlign)
                ) && 
                (
                    Visible == other.Visible ||
                    Visible != null &&
                    Visible.Equals(other.Visible)
                ) && 
                (
                    Width == other.Width ||
                    Width != null &&
                    Width.Equals(other.Width)
                ) && 
                (
                    X == other.X ||
                    X != null &&
                    X.Equals(other.X)
                ) && 
                (
                    XAnchor == other.XAnchor ||
                    XAnchor != null &&
                    XAnchor.Equals(other.XAnchor)
                ) && 
                (
                    XShift == other.XShift ||
                    XShift != null &&
                    XShift.Equals(other.XShift)
                ) && 
                (
                    Y == other.Y ||
                    Y != null &&
                    Y.Equals(other.Y)
                ) && 
                (
                    YAnchor == other.YAnchor ||
                    YAnchor != null &&
                    YAnchor.Equals(other.YAnchor)
                ) && 
                (
                    YShift == other.YShift ||
                    YShift != null &&
                    YShift.Equals(other.YShift)
                ) && 
                (
                    Z == other.Z ||
                    Z != null &&
                    Z.Equals(other.Z)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Align != null) hashCode = hashCode * 59 + Align.GetHashCode();
                if (ArrowColor != null) hashCode = hashCode * 59 + ArrowColor.GetHashCode();
                if (Arrowhead != null) hashCode = hashCode * 59 + Arrowhead.GetHashCode();
                if (ArrowSide != null) hashCode = hashCode * 59 + ArrowSide.GetHashCode();
                if (ArrowSize != null) hashCode = hashCode * 59 + ArrowSize.GetHashCode();
                if (ArrowWidth != null) hashCode = hashCode * 59 + ArrowWidth.GetHashCode();
                if (Ax != null) hashCode = hashCode * 59 + Ax.GetHashCode();
                if (Ay != null) hashCode = hashCode * 59 + Ay.GetHashCode();
                if (BgColor != null) hashCode = hashCode * 59 + BgColor.GetHashCode();
                if (BorderColor != null) hashCode = hashCode * 59 + BorderColor.GetHashCode();
                if (BorderPad != null) hashCode = hashCode * 59 + BorderPad.GetHashCode();
                if (BorderWidth != null) hashCode = hashCode * 59 + BorderWidth.GetHashCode();
                if (CaptureEvents != null) hashCode = hashCode * 59 + CaptureEvents.GetHashCode();
                if (Font != null) hashCode = hashCode * 59 + Font.GetHashCode();
                if (Height != null) hashCode = hashCode * 59 + Height.GetHashCode();
                if (HoverLabel != null) hashCode = hashCode * 59 + HoverLabel.GetHashCode();
                if (HoverText != null) hashCode = hashCode * 59 + HoverText.GetHashCode();
                if (Name != null) hashCode = hashCode * 59 + Name.GetHashCode();
                if (Opacity != null) hashCode = hashCode * 59 + Opacity.GetHashCode();
                if (ShowArrow != null) hashCode = hashCode * 59 + ShowArrow.GetHashCode();
                if (Standoff != null) hashCode = hashCode * 59 + Standoff.GetHashCode();
                if (StartArrowhead != null) hashCode = hashCode * 59 + StartArrowhead.GetHashCode();
                if (StartArrowSize != null) hashCode = hashCode * 59 + StartArrowSize.GetHashCode();
                if (StartStandoff != null) hashCode = hashCode * 59 + StartStandoff.GetHashCode();
                if (TemplateItemName != null) hashCode = hashCode * 59 + TemplateItemName.GetHashCode();
                if (Text != null) hashCode = hashCode * 59 + Text.GetHashCode();
                if (TextAngle != null) hashCode = hashCode * 59 + TextAngle.GetHashCode();
                if (VAlign != null) hashCode = hashCode * 59 + VAlign.GetHashCode();
                if (Visible != null) hashCode = hashCode * 59 + Visible.GetHashCode();
                if (Width != null) hashCode = hashCode * 59 + Width.GetHashCode();
                if (X != null) hashCode = hashCode * 59 + X.GetHashCode();
                if (XAnchor != null) hashCode = hashCode * 59 + XAnchor.GetHashCode();
                if (XShift != null) hashCode = hashCode * 59 + XShift.GetHashCode();
                if (Y != null) hashCode = hashCode * 59 + Y.GetHashCode();
                if (YAnchor != null) hashCode = hashCode * 59 + YAnchor.GetHashCode();
                if (YShift != null) hashCode = hashCode * 59 + YShift.GetHashCode();
                if (Z != null) hashCode = hashCode * 59 + Z.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Annotation and the right Annotation.
        /// </summary>
        /// <param name="left">Left Annotation.</param>
        /// <param name="right">Right Annotation.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Annotation left, Annotation right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Annotation and the right Annotation.
        /// </summary>
        /// <param name="left">Left Annotation.</param>
        /// <param name="right">Right Annotation.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Annotation left, Annotation right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Annotation</returns>
        public Annotation DeepClone()
        {
            return this.Copy();
        }
    }
}