/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.LayoutLib.PolarLib.RadialAxisLib
{
    /// <summary>
    ///     The AutoRangeOptions class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [JsonConverter(typeof(PlotlyConverter))]
    [Serializable]
    public class AutoRangeOptions : IEquatable<AutoRangeOptions>
    {
        /// <summary>
        ///     Clip autorange maximum if it goes beyond this value. Has no effect when
        ///     <c>autorangeoptions.maxallowed</c> is provided.
        /// </summary>
        [JsonPropertyName(@"clipmax")]
        public object ClipMax { get; set;} 

        /// <summary>
        ///     Clip autorange minimum if it goes beyond this value. Has no effect when
        ///     <c>autorangeoptions.minallowed</c> is provided.
        /// </summary>
        [JsonPropertyName(@"clipmin")]
        public object ClipMin { get; set;} 

        /// <summary>
        ///     Ensure this value is included in autorange.
        /// </summary>
        [JsonPropertyName(@"include")]
        public object Include { get; set;} 

        /// <summary>
        ///     Ensure this value is included in autorange.
        /// </summary>
        [JsonPropertyName(@"include")]
        [Array]
        public IList<object> IncludeArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>include</c>.
        /// </summary>
        [JsonPropertyName(@"includesrc")]
        public string IncludeSrc { get; set;} 

        /// <summary>
        ///     Use this value exactly as autorange maximum.
        /// </summary>
        [JsonPropertyName(@"maxallowed")]
        public object MaxAllowed { get; set;} 

        /// <summary>
        ///     Use this value exactly as autorange minimum.
        /// </summary>
        [JsonPropertyName(@"minallowed")]
        public object MinAllowed { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is AutoRangeOptions other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] AutoRangeOptions other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    ClipMax == other.ClipMax ||
                    ClipMax != null &&
                    ClipMax.Equals(other.ClipMax)
                ) && 
                (
                    ClipMin == other.ClipMin ||
                    ClipMin != null &&
                    ClipMin.Equals(other.ClipMin)
                ) && 
                (
                    Include == other.Include ||
                    Include != null &&
                    Include.Equals(other.Include)
                ) && 
                (
                    Equals(IncludeArray, other.IncludeArray) ||
                    IncludeArray != null && other.IncludeArray != null &&
                    IncludeArray.SequenceEqual(other.IncludeArray)
                ) &&
                (
                    IncludeSrc == other.IncludeSrc ||
                    IncludeSrc != null &&
                    IncludeSrc.Equals(other.IncludeSrc)
                ) && 
                (
                    MaxAllowed == other.MaxAllowed ||
                    MaxAllowed != null &&
                    MaxAllowed.Equals(other.MaxAllowed)
                ) && 
                (
                    MinAllowed == other.MinAllowed ||
                    MinAllowed != null &&
                    MinAllowed.Equals(other.MinAllowed)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (ClipMax != null) hashCode = hashCode * 59 + ClipMax.GetHashCode();
                if (ClipMin != null) hashCode = hashCode * 59 + ClipMin.GetHashCode();
                if (Include != null) hashCode = hashCode * 59 + Include.GetHashCode();
                if (IncludeArray != null) hashCode = hashCode * 59 + IncludeArray.GetHashCode();
                if (IncludeSrc != null) hashCode = hashCode * 59 + IncludeSrc.GetHashCode();
                if (MaxAllowed != null) hashCode = hashCode * 59 + MaxAllowed.GetHashCode();
                if (MinAllowed != null) hashCode = hashCode * 59 + MinAllowed.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left AutoRangeOptions and the right AutoRangeOptions.
        /// </summary>
        /// <param name="left">Left AutoRangeOptions.</param>
        /// <param name="right">Right AutoRangeOptions.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (AutoRangeOptions left, AutoRangeOptions right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left AutoRangeOptions and the right AutoRangeOptions.
        /// </summary>
        /// <param name="left">Left AutoRangeOptions.</param>
        /// <param name="right">Right AutoRangeOptions.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (AutoRangeOptions left, AutoRangeOptions right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>AutoRangeOptions</returns>
        public AutoRangeOptions DeepClone()
        {
            return this.Copy();
        }
    }
}