/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.LayoutLib
{
    /// <summary>
    ///     The Polar class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Polar : IEquatable<Polar>
    {
        /// <summary>
        ///     Gets or sets the AngularAxis.
        /// </summary>
        [JsonPropertyName(@"angularaxis")]
        public Plotly.Blazor.LayoutLib.PolarLib.AngularAxis AngularAxis { get; set;} 

        /// <summary>
        ///     Set the background color of the subplot
        /// </summary>
        [JsonPropertyName(@"bgcolor")]
        public object BgColor { get; set;} 

        /// <summary>
        ///     Gets or sets the Domain.
        /// </summary>
        [JsonPropertyName(@"domain")]
        public Plotly.Blazor.LayoutLib.PolarLib.Domain Domain { get; set;} 

        /// <summary>
        ///     Determines if the radial axis grid lines and angular axis line are drawn
        ///     as <c>circular</c> sectors or as <c>linear</c> (polygon) sectors. Has an
        ///     effect only when the angular axis has <c>type</c> <c>category</c>. Note
        ///     that <c>radialaxis.angle</c> is snapped to the angle of the closest vertex
        ///     when <c>gridshape</c> is <c>circular</c> (so that radial axis scale is the
        ///     same as the data scale).
        /// </summary>
        [JsonPropertyName(@"gridshape")]
        public Plotly.Blazor.LayoutLib.PolarLib.GridShapeEnum? GridShape { get; set;} 

        /// <summary>
        ///     Sets the fraction of the radius to cut out of the polar subplot.
        /// </summary>
        [JsonPropertyName(@"hole")]
        public decimal? Hole { get; set;} 

        /// <summary>
        ///     Gets or sets the RadialAxis.
        /// </summary>
        [JsonPropertyName(@"radialaxis")]
        public Plotly.Blazor.LayoutLib.PolarLib.RadialAxis RadialAxis { get; set;} 

        /// <summary>
        ///     Sets angular span of this polar subplot with two angles (in degrees). Sector
        ///     are assumed to be spanned in the counterclockwise direction with <c>0</c>
        ///     corresponding to rightmost limit of the polar subplot.
        /// </summary>
        [JsonPropertyName(@"sector")]
        public IList<object> Sector { get; set;} 

        /// <summary>
        ///     Controls persistence of user-driven changes in axis attributes, if not overridden
        ///     in the individual axes. Defaults to <c>layout.uirevision</c>.
        /// </summary>
        [JsonPropertyName(@"uirevision")]
        public object UiRevision { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Polar other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Polar other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    AngularAxis == other.AngularAxis ||
                    AngularAxis != null &&
                    AngularAxis.Equals(other.AngularAxis)
                ) && 
                (
                    BgColor == other.BgColor ||
                    BgColor != null &&
                    BgColor.Equals(other.BgColor)
                ) && 
                (
                    Domain == other.Domain ||
                    Domain != null &&
                    Domain.Equals(other.Domain)
                ) && 
                (
                    GridShape == other.GridShape ||
                    GridShape != null &&
                    GridShape.Equals(other.GridShape)
                ) && 
                (
                    Hole == other.Hole ||
                    Hole != null &&
                    Hole.Equals(other.Hole)
                ) && 
                (
                    RadialAxis == other.RadialAxis ||
                    RadialAxis != null &&
                    RadialAxis.Equals(other.RadialAxis)
                ) && 
                (
                    Equals(Sector, other.Sector) ||
                    Sector != null && other.Sector != null &&
                    Sector.SequenceEqual(other.Sector)
                ) &&
                (
                    UiRevision == other.UiRevision ||
                    UiRevision != null &&
                    UiRevision.Equals(other.UiRevision)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (AngularAxis != null) hashCode = hashCode * 59 + AngularAxis.GetHashCode();
                if (BgColor != null) hashCode = hashCode * 59 + BgColor.GetHashCode();
                if (Domain != null) hashCode = hashCode * 59 + Domain.GetHashCode();
                if (GridShape != null) hashCode = hashCode * 59 + GridShape.GetHashCode();
                if (Hole != null) hashCode = hashCode * 59 + Hole.GetHashCode();
                if (RadialAxis != null) hashCode = hashCode * 59 + RadialAxis.GetHashCode();
                if (Sector != null) hashCode = hashCode * 59 + Sector.GetHashCode();
                if (UiRevision != null) hashCode = hashCode * 59 + UiRevision.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Polar and the right Polar.
        /// </summary>
        /// <param name="left">Left Polar.</param>
        /// <param name="right">Right Polar.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Polar left, Polar right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Polar and the right Polar.
        /// </summary>
        /// <param name="left">Left Polar.</param>
        /// <param name="right">Right Polar.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Polar left, Polar right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Polar</returns>
        public Polar DeepClone()
        {
            return this.Copy();
        }
    }
}