/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.LayoutLib.MapLib
{
    /// <summary>
    ///     The Layer class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Layer : IEquatable<Layer>
    {
        /// <summary>
        ///     Determines if the layer will be inserted before the layer with the specified
        ///     ID. If omitted or set to &#39;&#39;, the layer will be inserted above every
        ///     existing layer.
        /// </summary>
        [JsonPropertyName(@"below")]
        public string Below { get; set;} 

        /// <summary>
        ///     Gets or sets the Circle.
        /// </summary>
        [JsonPropertyName(@"circle")]
        public Plotly.Blazor.LayoutLib.MapLib.LayerLib.Circle Circle { get; set;} 

        /// <summary>
        ///     Sets the primary layer color. If <c>type</c> is <c>circle</c>, color corresponds
        ///     to the circle color (map.layer.paint.circle-color) If <c>type</c> is <c>line</c>,
        ///     color corresponds to the line color (map.layer.paint.line-color) If <c>type</c>
        ///     is <c>fill</c>, color corresponds to the fill color (map.layer.paint.fill-color)
        ///     If <c>type</c> is <c>symbol</c>, color corresponds to the icon color (map.layer.paint.icon-color)
        /// </summary>
        [JsonPropertyName(@"color")]
        public object Color { get; set;} 

        /// <summary>
        ///     Sets the coordinates array contains [longitude, latitude] pairs for the
        ///     image corners listed in clockwise order: top left, top right, bottom right,
        ///     bottom left. Only has an effect for <c>image</c> <c>sourcetype</c>.
        /// </summary>
        [JsonPropertyName(@"coordinates")]
        public object Coordinates { get; set;} 

        /// <summary>
        ///     Gets or sets the Fill.
        /// </summary>
        [JsonPropertyName(@"fill")]
        public Plotly.Blazor.LayoutLib.MapLib.LayerLib.Fill Fill { get; set;} 

        /// <summary>
        ///     Gets or sets the Line.
        /// </summary>
        [JsonPropertyName(@"line")]
        public Plotly.Blazor.LayoutLib.MapLib.LayerLib.Line Line { get; set;} 

        /// <summary>
        ///     Sets the maximum zoom level (map.layer.maxzoom). At zoom levels equal to
        ///     or greater than the maxzoom, the layer will be hidden.
        /// </summary>
        [JsonPropertyName(@"maxzoom")]
        public decimal? MaxZoom { get; set;} 

        /// <summary>
        ///     Sets the minimum zoom level (map.layer.minzoom). At zoom levels less than
        ///     the minzoom, the layer will be hidden.
        /// </summary>
        [JsonPropertyName(@"minzoom")]
        public decimal? MinZoom { get; set;} 

        /// <summary>
        ///     When used in a template, named items are created in the output figure in
        ///     addition to any items the figure already has in this array. You can modify
        ///     these items in the output figure by making your own item with <c>templateitemname</c>
        ///     matching this <c>name</c> alongside your modifications (including &#39;visible:
        ///     false&#39; or &#39;enabled: false&#39; to hide it). Has no effect outside
        ///     of a template.
        /// </summary>
        [JsonPropertyName(@"name")]
        public string Name { get; set;} 

        /// <summary>
        ///     Sets the opacity of the layer. If <c>type</c> is <c>circle</c>, opacity
        ///     corresponds to the circle opacity (map.layer.paint.circle-opacity) If <c>type</c>
        ///     is <c>line</c>, opacity corresponds to the line opacity (map.layer.paint.line-opacity)
        ///     If <c>type</c> is <c>fill</c>, opacity corresponds to the fill opacity (map.layer.paint.fill-opacity)
        ///     If <c>type</c> is <c>symbol</c>, opacity corresponds to the icon/text opacity
        ///     (map.layer.paint.text-opacity)
        /// </summary>
        [JsonPropertyName(@"opacity")]
        public decimal? Opacity { get; set;} 

        /// <summary>
        ///     Sets the source data for this layer (map.layer.source). When <c>sourcetype</c>
        ///     is set to <c>geojson</c>, <c>source</c> can be a URL to a GeoJSON or a GeoJSON
        ///     object. When <c>sourcetype</c> is set to <c>vector</c> or <c>raster</c>,
        ///     <c>source</c> can be a URL or an array of tile URLs. When <c>sourcetype</c>
        ///     is set to <c>image</c>, <c>source</c> can be a URL to an image.
        /// </summary>
        [JsonPropertyName(@"source")]
        public object Source { get; set;} 

        /// <summary>
        ///     Sets the attribution for this source.
        /// </summary>
        [JsonPropertyName(@"sourceattribution")]
        public string SourceAttribution { get; set;} 

        /// <summary>
        ///     Specifies the layer to use from a vector tile source (map.layer.source-layer).
        ///     Required for <c>vector</c> source type that supports multiple layers.
        /// </summary>
        [JsonPropertyName(@"sourcelayer")]
        public string SourceLayer { get; set;} 

        /// <summary>
        ///     Sets the source type for this layer, that is the type of the layer data.
        /// </summary>
        [JsonPropertyName(@"sourcetype")]
        public Plotly.Blazor.LayoutLib.MapLib.LayerLib.SourceTypeEnum? SourceType { get; set;} 

        /// <summary>
        ///     Gets or sets the Symbol.
        /// </summary>
        [JsonPropertyName(@"symbol")]
        public Plotly.Blazor.LayoutLib.MapLib.LayerLib.Symbol Symbol { get; set;} 

        /// <summary>
        ///     Used to refer to a named item in this array in the template. Named items
        ///     from the template will be created even without a matching item in the input
        ///     figure, but you can modify one by making an item with <c>templateitemname</c>
        ///     matching its <c>name</c>, alongside your modifications (including &#39;visible:
        ///     false&#39; or &#39;enabled: false&#39; to hide it). If there is no template
        ///     or no matching item, this item will be hidden unless you explicitly show
        ///     it with &#39;visible: true&#39;.
        /// </summary>
        [JsonPropertyName(@"templateitemname")]
        public string TemplateItemName { get; set;} 

        /// <summary>
        ///     Sets the layer type, that is the how the layer data set in <c>source</c>
        ///     will be rendered With <c>sourcetype</c> set to <c>geojson</c>, the following
        ///     values are allowed: <c>circle</c>, <c>line</c>, <c>fill</c> and <c>symbol</c>.
        ///     but note that <c>line</c> and <c>fill</c> are not compatible with Point
        ///     GeoJSON geometries. With <c>sourcetype</c> set to <c>vector</c>, the following
        ///     values are allowed:  <c>circle</c>, <c>line</c>, <c>fill</c> and <c>symbol</c>.
        ///     With <c>sourcetype</c> set to <c>raster</c> or <c><c>image</c></c>, only
        ///     the <c>raster</c> value is allowed.
        /// </summary>
        [JsonPropertyName(@"type")]
        public Plotly.Blazor.LayoutLib.MapLib.LayerLib.TypeEnum? Type { get; set;} 

        /// <summary>
        ///     Determines whether this layer is displayed
        /// </summary>
        [JsonPropertyName(@"visible")]
        public bool? Visible { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Layer other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Layer other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Below == other.Below ||
                    Below != null &&
                    Below.Equals(other.Below)
                ) && 
                (
                    Circle == other.Circle ||
                    Circle != null &&
                    Circle.Equals(other.Circle)
                ) && 
                (
                    Color == other.Color ||
                    Color != null &&
                    Color.Equals(other.Color)
                ) && 
                (
                    Coordinates == other.Coordinates ||
                    Coordinates != null &&
                    Coordinates.Equals(other.Coordinates)
                ) && 
                (
                    Fill == other.Fill ||
                    Fill != null &&
                    Fill.Equals(other.Fill)
                ) && 
                (
                    Line == other.Line ||
                    Line != null &&
                    Line.Equals(other.Line)
                ) && 
                (
                    MaxZoom == other.MaxZoom ||
                    MaxZoom != null &&
                    MaxZoom.Equals(other.MaxZoom)
                ) && 
                (
                    MinZoom == other.MinZoom ||
                    MinZoom != null &&
                    MinZoom.Equals(other.MinZoom)
                ) && 
                (
                    Name == other.Name ||
                    Name != null &&
                    Name.Equals(other.Name)
                ) && 
                (
                    Opacity == other.Opacity ||
                    Opacity != null &&
                    Opacity.Equals(other.Opacity)
                ) && 
                (
                    Source == other.Source ||
                    Source != null &&
                    Source.Equals(other.Source)
                ) && 
                (
                    SourceAttribution == other.SourceAttribution ||
                    SourceAttribution != null &&
                    SourceAttribution.Equals(other.SourceAttribution)
                ) && 
                (
                    SourceLayer == other.SourceLayer ||
                    SourceLayer != null &&
                    SourceLayer.Equals(other.SourceLayer)
                ) && 
                (
                    SourceType == other.SourceType ||
                    SourceType != null &&
                    SourceType.Equals(other.SourceType)
                ) && 
                (
                    Symbol == other.Symbol ||
                    Symbol != null &&
                    Symbol.Equals(other.Symbol)
                ) && 
                (
                    TemplateItemName == other.TemplateItemName ||
                    TemplateItemName != null &&
                    TemplateItemName.Equals(other.TemplateItemName)
                ) && 
                (
                    Type == other.Type ||
                    Type != null &&
                    Type.Equals(other.Type)
                ) && 
                (
                    Visible == other.Visible ||
                    Visible != null &&
                    Visible.Equals(other.Visible)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Below != null) hashCode = hashCode * 59 + Below.GetHashCode();
                if (Circle != null) hashCode = hashCode * 59 + Circle.GetHashCode();
                if (Color != null) hashCode = hashCode * 59 + Color.GetHashCode();
                if (Coordinates != null) hashCode = hashCode * 59 + Coordinates.GetHashCode();
                if (Fill != null) hashCode = hashCode * 59 + Fill.GetHashCode();
                if (Line != null) hashCode = hashCode * 59 + Line.GetHashCode();
                if (MaxZoom != null) hashCode = hashCode * 59 + MaxZoom.GetHashCode();
                if (MinZoom != null) hashCode = hashCode * 59 + MinZoom.GetHashCode();
                if (Name != null) hashCode = hashCode * 59 + Name.GetHashCode();
                if (Opacity != null) hashCode = hashCode * 59 + Opacity.GetHashCode();
                if (Source != null) hashCode = hashCode * 59 + Source.GetHashCode();
                if (SourceAttribution != null) hashCode = hashCode * 59 + SourceAttribution.GetHashCode();
                if (SourceLayer != null) hashCode = hashCode * 59 + SourceLayer.GetHashCode();
                if (SourceType != null) hashCode = hashCode * 59 + SourceType.GetHashCode();
                if (Symbol != null) hashCode = hashCode * 59 + Symbol.GetHashCode();
                if (TemplateItemName != null) hashCode = hashCode * 59 + TemplateItemName.GetHashCode();
                if (Type != null) hashCode = hashCode * 59 + Type.GetHashCode();
                if (Visible != null) hashCode = hashCode * 59 + Visible.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Layer and the right Layer.
        /// </summary>
        /// <param name="left">Left Layer.</param>
        /// <param name="right">Right Layer.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Layer left, Layer right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Layer and the right Layer.
        /// </summary>
        /// <param name="left">Left Layer.</param>
        /// <param name="right">Right Layer.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Layer left, Layer right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Layer</returns>
        public Layer DeepClone()
        {
            return this.Copy();
        }
    }
}