/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.LayoutLib.MapBoxLib.LayerLib
{
    /// <summary>
    ///     The Line class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Line : IEquatable<Line>
    {
        /// <summary>
        ///     Sets the length of dashes and gaps (mapbox.layer.paint.line-dasharray).
        ///     Has an effect only when <c>type</c> is set to <c>line</c>.
        /// </summary>
        [JsonPropertyName(@"dash")]
        public IList<object> Dash { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>dash</c>.
        /// </summary>
        [JsonPropertyName(@"dashsrc")]
        public string DashSrc { get; set;} 

        /// <summary>
        ///     Sets the line width (mapbox.layer.paint.line-width). Has an effect only
        ///     when <c>type</c> is set to <c>line</c>.
        /// </summary>
        [JsonPropertyName(@"width")]
        public decimal? Width { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Line other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Line other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Equals(Dash, other.Dash) ||
                    Dash != null && other.Dash != null &&
                    Dash.SequenceEqual(other.Dash)
                ) &&
                (
                    DashSrc == other.DashSrc ||
                    DashSrc != null &&
                    DashSrc.Equals(other.DashSrc)
                ) && 
                (
                    Width == other.Width ||
                    Width != null &&
                    Width.Equals(other.Width)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Dash != null) hashCode = hashCode * 59 + Dash.GetHashCode();
                if (DashSrc != null) hashCode = hashCode * 59 + DashSrc.GetHashCode();
                if (Width != null) hashCode = hashCode * 59 + Width.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Line and the right Line.
        /// </summary>
        /// <param name="left">Left Line.</param>
        /// <param name="right">Right Line.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Line left, Line right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Line and the right Line.
        /// </summary>
        /// <param name="left">Left Line.</param>
        /// <param name="right">Right Line.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Line left, Line right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Line</returns>
        public Line DeepClone()
        {
            return this.Copy();
        }
    }
}