/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.LayoutLib
{
    /// <summary>
    ///     The Map class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Map : IEquatable<Map>
    {
        /// <summary>
        ///     Sets the bearing angle of the map in degrees counter-clockwise from North
        ///     (map.bearing).
        /// </summary>
        [JsonPropertyName(@"bearing")]
        public decimal? Bearing { get; set;} 

        /// <summary>
        ///     Gets or sets the Bounds.
        /// </summary>
        [JsonPropertyName(@"bounds")]
        public Plotly.Blazor.LayoutLib.MapLib.Bounds Bounds { get; set;} 

        /// <summary>
        ///     Gets or sets the Center.
        /// </summary>
        [JsonPropertyName(@"center")]
        public Plotly.Blazor.LayoutLib.MapLib.Center Center { get; set;} 

        /// <summary>
        ///     Gets or sets the Domain.
        /// </summary>
        [JsonPropertyName(@"domain")]
        public Plotly.Blazor.LayoutLib.MapLib.Domain Domain { get; set;} 

        /// <summary>
        ///     Gets or sets the Layers.
        /// </summary>
        [JsonPropertyName(@"layers")]
        public IList<Plotly.Blazor.LayoutLib.MapLib.Layer> Layers { get; set;} 

        /// <summary>
        ///     Sets the pitch angle of the map (in degrees, where <c>0</c> means perpendicular
        ///     to the surface of the map) (map.pitch).
        /// </summary>
        [JsonPropertyName(@"pitch")]
        public decimal? Pitch { get; set;} 

        /// <summary>
        ///     Defines the map layers that are rendered by default below the trace layers
        ///     defined in <c>data</c>, which are themselves by default rendered below the
        ///     layers defined in <c>layout.map.layers</c>.  These layers can be defined
        ///     either explicitly as a Map Style object which can contain multiple layer
        ///     definitions that load data from any public or private Tile Map Service (TMS
        ///     or XYZ) or Web Map Service (WMS) or implicitly by using one of the built-in
        ///     style objects which use WMSes or by using a custom style URL  Map Style
        ///     objects are of the form described in the MapLibre GL JS documentation available
        ///     at https://maplibre.org/maplibre-style-spec/  The built-in plotly.js styles
        ///     objects are: basic, carto-darkmatter, carto-darkmatter-nolabels, carto-positron,
        ///     carto-positron-nolabels, carto-voyager, carto-voyager-nolabels, dark, light,
        ///     open-street-map, outdoors, satellite, satellite-streets, streets, white-bg.
        /// </summary>
        [JsonPropertyName(@"style")]
        public object Style { get; set;} 

        /// <summary>
        ///     Controls persistence of user-driven changes in the view: <c>center</c>,
        ///     <c>zoom</c>, <c>bearing</c>, <c>pitch</c>. Defaults to <c>layout.uirevision</c>.
        /// </summary>
        [JsonPropertyName(@"uirevision")]
        public object UiRevision { get; set;} 

        /// <summary>
        ///     Sets the zoom level of the map (map.zoom).
        /// </summary>
        [JsonPropertyName(@"zoom")]
        public decimal? Zoom { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Map other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Map other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Bearing == other.Bearing ||
                    Bearing != null &&
                    Bearing.Equals(other.Bearing)
                ) && 
                (
                    Bounds == other.Bounds ||
                    Bounds != null &&
                    Bounds.Equals(other.Bounds)
                ) && 
                (
                    Center == other.Center ||
                    Center != null &&
                    Center.Equals(other.Center)
                ) && 
                (
                    Domain == other.Domain ||
                    Domain != null &&
                    Domain.Equals(other.Domain)
                ) && 
                (
                    Equals(Layers, other.Layers) ||
                    Layers != null && other.Layers != null &&
                    Layers.SequenceEqual(other.Layers)
                ) &&
                (
                    Pitch == other.Pitch ||
                    Pitch != null &&
                    Pitch.Equals(other.Pitch)
                ) && 
                (
                    Style == other.Style ||
                    Style != null &&
                    Style.Equals(other.Style)
                ) && 
                (
                    UiRevision == other.UiRevision ||
                    UiRevision != null &&
                    UiRevision.Equals(other.UiRevision)
                ) && 
                (
                    Zoom == other.Zoom ||
                    Zoom != null &&
                    Zoom.Equals(other.Zoom)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Bearing != null) hashCode = hashCode * 59 + Bearing.GetHashCode();
                if (Bounds != null) hashCode = hashCode * 59 + Bounds.GetHashCode();
                if (Center != null) hashCode = hashCode * 59 + Center.GetHashCode();
                if (Domain != null) hashCode = hashCode * 59 + Domain.GetHashCode();
                if (Layers != null) hashCode = hashCode * 59 + Layers.GetHashCode();
                if (Pitch != null) hashCode = hashCode * 59 + Pitch.GetHashCode();
                if (Style != null) hashCode = hashCode * 59 + Style.GetHashCode();
                if (UiRevision != null) hashCode = hashCode * 59 + UiRevision.GetHashCode();
                if (Zoom != null) hashCode = hashCode * 59 + Zoom.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Map and the right Map.
        /// </summary>
        /// <param name="left">Left Map.</param>
        /// <param name="right">Right Map.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Map left, Map right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Map and the right Map.
        /// </summary>
        /// <param name="left">Left Map.</param>
        /// <param name="right">Right Map.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Map left, Map right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Map</returns>
        public Map DeepClone()
        {
            return this.Copy();
        }
    }
}