/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.LayoutLib.GeoLib
{
    /// <summary>
    ///     The Projection class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Projection : IEquatable<Projection>
    {
        /// <summary>
        ///     For satellite projection type only. Sets the distance from the center of
        ///     the sphere to the point of view as a proportion of the sphere’s radius.
        /// </summary>
        [JsonPropertyName(@"distance")]
        public decimal? Distance { get; set;} 

        /// <summary>
        ///     For conic projection types only. Sets the parallels (tangent, secant) where
        ///     the cone intersects the sphere.
        /// </summary>
        [JsonPropertyName(@"parallels")]
        public IList<object> Parallels { get; set;} 

        /// <summary>
        ///     Gets or sets the Rotation.
        /// </summary>
        [JsonPropertyName(@"rotation")]
        public Plotly.Blazor.LayoutLib.GeoLib.ProjectionLib.Rotation Rotation { get; set;} 

        /// <summary>
        ///     Zooms in or out on the map view. A scale of <c>1</c> corresponds to the
        ///     largest zoom level that fits the map&#39;s lon and lat ranges. 
        /// </summary>
        [JsonPropertyName(@"scale")]
        public decimal? Scale { get; set;} 

        /// <summary>
        ///     For satellite projection type only. Sets the tilt angle of perspective projection.
        /// </summary>
        [JsonPropertyName(@"tilt")]
        public decimal? Tilt { get; set;} 

        /// <summary>
        ///     Sets the projection type.
        /// </summary>
        [JsonPropertyName(@"type")]
        public Plotly.Blazor.LayoutLib.GeoLib.ProjectionLib.TypeEnum? Type { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Projection other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Projection other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    Distance == other.Distance ||
                    Distance != null &&
                    Distance.Equals(other.Distance)
                ) && 
                (
                    Equals(Parallels, other.Parallels) ||
                    Parallels != null && other.Parallels != null &&
                    Parallels.SequenceEqual(other.Parallels)
                ) &&
                (
                    Rotation == other.Rotation ||
                    Rotation != null &&
                    Rotation.Equals(other.Rotation)
                ) && 
                (
                    Scale == other.Scale ||
                    Scale != null &&
                    Scale.Equals(other.Scale)
                ) && 
                (
                    Tilt == other.Tilt ||
                    Tilt != null &&
                    Tilt.Equals(other.Tilt)
                ) && 
                (
                    Type == other.Type ||
                    Type != null &&
                    Type.Equals(other.Type)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (Distance != null) hashCode = hashCode * 59 + Distance.GetHashCode();
                if (Parallels != null) hashCode = hashCode * 59 + Parallels.GetHashCode();
                if (Rotation != null) hashCode = hashCode * 59 + Rotation.GetHashCode();
                if (Scale != null) hashCode = hashCode * 59 + Scale.GetHashCode();
                if (Tilt != null) hashCode = hashCode * 59 + Tilt.GetHashCode();
                if (Type != null) hashCode = hashCode * 59 + Type.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Projection and the right Projection.
        /// </summary>
        /// <param name="left">Left Projection.</param>
        /// <param name="right">Right Projection.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Projection left, Projection right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Projection and the right Projection.
        /// </summary>
        /// <param name="left">Left Projection.</param>
        /// <param name="right">Right Projection.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Projection left, Projection right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Projection</returns>
        public Projection DeepClone()
        {
            return this.Copy();
        }
    }
}