/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor.LayoutLib
{
    /// <summary>
    ///     The Geo class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Geo : IEquatable<Geo>
    {
        /// <summary>
        ///     Set the background color of the map
        /// </summary>
        [JsonPropertyName(@"bgcolor")]
        public object BgColor { get; set;} 

        /// <summary>
        ///     Gets or sets the Center.
        /// </summary>
        [JsonPropertyName(@"center")]
        public Plotly.Blazor.LayoutLib.GeoLib.Center Center { get; set;} 

        /// <summary>
        ///     Sets the coastline color.
        /// </summary>
        [JsonPropertyName(@"coastlinecolor")]
        public object CoastlineColor { get; set;} 

        /// <summary>
        ///     Sets the coastline stroke width (in px).
        /// </summary>
        [JsonPropertyName(@"coastlinewidth")]
        public decimal? CoastlineWidth { get; set;} 

        /// <summary>
        ///     Sets line color of the country boundaries.
        /// </summary>
        [JsonPropertyName(@"countrycolor")]
        public object CountryColor { get; set;} 

        /// <summary>
        ///     Sets line width (in px) of the country boundaries.
        /// </summary>
        [JsonPropertyName(@"countrywidth")]
        public decimal? CountryWidth { get; set;} 

        /// <summary>
        ///     Gets or sets the Domain.
        /// </summary>
        [JsonPropertyName(@"domain")]
        public Plotly.Blazor.LayoutLib.GeoLib.Domain Domain { get; set;} 

        /// <summary>
        ///     Determines if this subplot&#39;s view settings are auto-computed to fit
        ///     trace data. On scoped maps, setting <c>fitbounds</c> leads to <c>center.lon</c>
        ///     and <c>center.lat</c> getting auto-filled. On maps with a non-clipped projection,
        ///     setting <c>fitbounds</c> leads to <c>center.lon</c>, <c>center.lat</c>,
        ///     and <c>projection.rotation.lon</c> getting auto-filled. On maps with a clipped
        ///     projection, setting <c>fitbounds</c> leads to <c>center.lon</c>, <c>center.lat</c>,
        ///     <c>projection.rotation.lon</c>, <c>projection.rotation.lat</c>, <c>lonaxis.range</c>
        ///     and <c>lonaxis.range</c> getting auto-filled. If <c>locations</c>, only
        ///     the trace&#39;s visible locations are considered in the <c>fitbounds</c>
        ///     computations. If <c>geojson</c>, the entire trace input <c>geojson</c> (if
        ///     provided) is considered in the <c>fitbounds</c> computations, Defaults to
        ///     <c>false</c>.
        /// </summary>
        [JsonPropertyName(@"fitbounds")]
        public Plotly.Blazor.LayoutLib.GeoLib.FitBoundsEnum? FitBounds { get; set;} 

        /// <summary>
        ///     Sets the color the frame.
        /// </summary>
        [JsonPropertyName(@"framecolor")]
        public object FrameColor { get; set;} 

        /// <summary>
        ///     Sets the stroke width (in px) of the frame.
        /// </summary>
        [JsonPropertyName(@"framewidth")]
        public decimal? FrameWidth { get; set;} 

        /// <summary>
        ///     Sets the color of the lakes.
        /// </summary>
        [JsonPropertyName(@"lakecolor")]
        public object LakeColor { get; set;} 

        /// <summary>
        ///     Sets the land mass color.
        /// </summary>
        [JsonPropertyName(@"landcolor")]
        public object LandColor { get; set;} 

        /// <summary>
        ///     Gets or sets the LaTaxis.
        /// </summary>
        [JsonPropertyName(@"lataxis")]
        public Plotly.Blazor.LayoutLib.GeoLib.LaTaxis LaTaxis { get; set;} 

        /// <summary>
        ///     Gets or sets the LonAxis.
        /// </summary>
        [JsonPropertyName(@"lonaxis")]
        public Plotly.Blazor.LayoutLib.GeoLib.LonAxis LonAxis { get; set;} 

        /// <summary>
        ///     Sets the ocean color
        /// </summary>
        [JsonPropertyName(@"oceancolor")]
        public object OceanColor { get; set;} 

        /// <summary>
        ///     Gets or sets the Projection.
        /// </summary>
        [JsonPropertyName(@"projection")]
        public Plotly.Blazor.LayoutLib.GeoLib.Projection Projection { get; set;} 

        /// <summary>
        ///     Sets the resolution of the base layers. The values have units of km/mm e.g.
        ///     110 corresponds to a scale ratio of 1:110,000,000.
        /// </summary>
        [JsonPropertyName(@"resolution")]
        public Plotly.Blazor.LayoutLib.GeoLib.ResolutionEnum? Resolution { get; set;} 

        /// <summary>
        ///     Sets color of the rivers.
        /// </summary>
        [JsonPropertyName(@"rivercolor")]
        public object RiverColor { get; set;} 

        /// <summary>
        ///     Sets the stroke width (in px) of the rivers.
        /// </summary>
        [JsonPropertyName(@"riverwidth")]
        public decimal? RiverWidth { get; set;} 

        /// <summary>
        ///     Set the scope of the map.
        /// </summary>
        [JsonPropertyName(@"scope")]
        public Plotly.Blazor.LayoutLib.GeoLib.ScopeEnum? Scope { get; set;} 

        /// <summary>
        ///     Sets whether or not the coastlines are drawn.
        /// </summary>
        [JsonPropertyName(@"showcoastlines")]
        public bool? ShowCoastlines { get; set;} 

        /// <summary>
        ///     Sets whether or not country boundaries are drawn.
        /// </summary>
        [JsonPropertyName(@"showcountries")]
        public bool? ShowCountries { get; set;} 

        /// <summary>
        ///     Sets whether or not a frame is drawn around the map.
        /// </summary>
        [JsonPropertyName(@"showframe")]
        public bool? ShowFrame { get; set;} 

        /// <summary>
        ///     Sets whether or not lakes are drawn.
        /// </summary>
        [JsonPropertyName(@"showlakes")]
        public bool? ShowLakes { get; set;} 

        /// <summary>
        ///     Sets whether or not land masses are filled in color.
        /// </summary>
        [JsonPropertyName(@"showland")]
        public bool? ShowLand { get; set;} 

        /// <summary>
        ///     Sets whether or not oceans are filled in color.
        /// </summary>
        [JsonPropertyName(@"showocean")]
        public bool? ShowOcean { get; set;} 

        /// <summary>
        ///     Sets whether or not rivers are drawn.
        /// </summary>
        [JsonPropertyName(@"showrivers")]
        public bool? ShowRivers { get; set;} 

        /// <summary>
        ///     Sets whether or not boundaries of subunits within countries (e.g. states,
        ///     provinces) are drawn.
        /// </summary>
        [JsonPropertyName(@"showsubunits")]
        public bool? ShowSubUnits { get; set;} 

        /// <summary>
        ///     Sets the color of the subunits boundaries.
        /// </summary>
        [JsonPropertyName(@"subunitcolor")]
        public object SubUnitColor { get; set;} 

        /// <summary>
        ///     Sets the stroke width (in px) of the subunits boundaries.
        /// </summary>
        [JsonPropertyName(@"subunitwidth")]
        public decimal? SubUnitWidth { get; set;} 

        /// <summary>
        ///     Controls persistence of user-driven changes in the view (projection and
        ///     center). Defaults to <c>layout.uirevision</c>.
        /// </summary>
        [JsonPropertyName(@"uirevision")]
        public object UiRevision { get; set;} 

        /// <summary>
        ///     Sets the default visibility of the base layers.
        /// </summary>
        [JsonPropertyName(@"visible")]
        public bool? Visible { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Geo other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Geo other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    BgColor == other.BgColor ||
                    BgColor != null &&
                    BgColor.Equals(other.BgColor)
                ) && 
                (
                    Center == other.Center ||
                    Center != null &&
                    Center.Equals(other.Center)
                ) && 
                (
                    CoastlineColor == other.CoastlineColor ||
                    CoastlineColor != null &&
                    CoastlineColor.Equals(other.CoastlineColor)
                ) && 
                (
                    CoastlineWidth == other.CoastlineWidth ||
                    CoastlineWidth != null &&
                    CoastlineWidth.Equals(other.CoastlineWidth)
                ) && 
                (
                    CountryColor == other.CountryColor ||
                    CountryColor != null &&
                    CountryColor.Equals(other.CountryColor)
                ) && 
                (
                    CountryWidth == other.CountryWidth ||
                    CountryWidth != null &&
                    CountryWidth.Equals(other.CountryWidth)
                ) && 
                (
                    Domain == other.Domain ||
                    Domain != null &&
                    Domain.Equals(other.Domain)
                ) && 
                (
                    FitBounds == other.FitBounds ||
                    FitBounds != null &&
                    FitBounds.Equals(other.FitBounds)
                ) && 
                (
                    FrameColor == other.FrameColor ||
                    FrameColor != null &&
                    FrameColor.Equals(other.FrameColor)
                ) && 
                (
                    FrameWidth == other.FrameWidth ||
                    FrameWidth != null &&
                    FrameWidth.Equals(other.FrameWidth)
                ) && 
                (
                    LakeColor == other.LakeColor ||
                    LakeColor != null &&
                    LakeColor.Equals(other.LakeColor)
                ) && 
                (
                    LandColor == other.LandColor ||
                    LandColor != null &&
                    LandColor.Equals(other.LandColor)
                ) && 
                (
                    LaTaxis == other.LaTaxis ||
                    LaTaxis != null &&
                    LaTaxis.Equals(other.LaTaxis)
                ) && 
                (
                    LonAxis == other.LonAxis ||
                    LonAxis != null &&
                    LonAxis.Equals(other.LonAxis)
                ) && 
                (
                    OceanColor == other.OceanColor ||
                    OceanColor != null &&
                    OceanColor.Equals(other.OceanColor)
                ) && 
                (
                    Projection == other.Projection ||
                    Projection != null &&
                    Projection.Equals(other.Projection)
                ) && 
                (
                    Resolution == other.Resolution ||
                    Resolution != null &&
                    Resolution.Equals(other.Resolution)
                ) && 
                (
                    RiverColor == other.RiverColor ||
                    RiverColor != null &&
                    RiverColor.Equals(other.RiverColor)
                ) && 
                (
                    RiverWidth == other.RiverWidth ||
                    RiverWidth != null &&
                    RiverWidth.Equals(other.RiverWidth)
                ) && 
                (
                    Scope == other.Scope ||
                    Scope != null &&
                    Scope.Equals(other.Scope)
                ) && 
                (
                    ShowCoastlines == other.ShowCoastlines ||
                    ShowCoastlines != null &&
                    ShowCoastlines.Equals(other.ShowCoastlines)
                ) && 
                (
                    ShowCountries == other.ShowCountries ||
                    ShowCountries != null &&
                    ShowCountries.Equals(other.ShowCountries)
                ) && 
                (
                    ShowFrame == other.ShowFrame ||
                    ShowFrame != null &&
                    ShowFrame.Equals(other.ShowFrame)
                ) && 
                (
                    ShowLakes == other.ShowLakes ||
                    ShowLakes != null &&
                    ShowLakes.Equals(other.ShowLakes)
                ) && 
                (
                    ShowLand == other.ShowLand ||
                    ShowLand != null &&
                    ShowLand.Equals(other.ShowLand)
                ) && 
                (
                    ShowOcean == other.ShowOcean ||
                    ShowOcean != null &&
                    ShowOcean.Equals(other.ShowOcean)
                ) && 
                (
                    ShowRivers == other.ShowRivers ||
                    ShowRivers != null &&
                    ShowRivers.Equals(other.ShowRivers)
                ) && 
                (
                    ShowSubUnits == other.ShowSubUnits ||
                    ShowSubUnits != null &&
                    ShowSubUnits.Equals(other.ShowSubUnits)
                ) && 
                (
                    SubUnitColor == other.SubUnitColor ||
                    SubUnitColor != null &&
                    SubUnitColor.Equals(other.SubUnitColor)
                ) && 
                (
                    SubUnitWidth == other.SubUnitWidth ||
                    SubUnitWidth != null &&
                    SubUnitWidth.Equals(other.SubUnitWidth)
                ) && 
                (
                    UiRevision == other.UiRevision ||
                    UiRevision != null &&
                    UiRevision.Equals(other.UiRevision)
                ) && 
                (
                    Visible == other.Visible ||
                    Visible != null &&
                    Visible.Equals(other.Visible)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (BgColor != null) hashCode = hashCode * 59 + BgColor.GetHashCode();
                if (Center != null) hashCode = hashCode * 59 + Center.GetHashCode();
                if (CoastlineColor != null) hashCode = hashCode * 59 + CoastlineColor.GetHashCode();
                if (CoastlineWidth != null) hashCode = hashCode * 59 + CoastlineWidth.GetHashCode();
                if (CountryColor != null) hashCode = hashCode * 59 + CountryColor.GetHashCode();
                if (CountryWidth != null) hashCode = hashCode * 59 + CountryWidth.GetHashCode();
                if (Domain != null) hashCode = hashCode * 59 + Domain.GetHashCode();
                if (FitBounds != null) hashCode = hashCode * 59 + FitBounds.GetHashCode();
                if (FrameColor != null) hashCode = hashCode * 59 + FrameColor.GetHashCode();
                if (FrameWidth != null) hashCode = hashCode * 59 + FrameWidth.GetHashCode();
                if (LakeColor != null) hashCode = hashCode * 59 + LakeColor.GetHashCode();
                if (LandColor != null) hashCode = hashCode * 59 + LandColor.GetHashCode();
                if (LaTaxis != null) hashCode = hashCode * 59 + LaTaxis.GetHashCode();
                if (LonAxis != null) hashCode = hashCode * 59 + LonAxis.GetHashCode();
                if (OceanColor != null) hashCode = hashCode * 59 + OceanColor.GetHashCode();
                if (Projection != null) hashCode = hashCode * 59 + Projection.GetHashCode();
                if (Resolution != null) hashCode = hashCode * 59 + Resolution.GetHashCode();
                if (RiverColor != null) hashCode = hashCode * 59 + RiverColor.GetHashCode();
                if (RiverWidth != null) hashCode = hashCode * 59 + RiverWidth.GetHashCode();
                if (Scope != null) hashCode = hashCode * 59 + Scope.GetHashCode();
                if (ShowCoastlines != null) hashCode = hashCode * 59 + ShowCoastlines.GetHashCode();
                if (ShowCountries != null) hashCode = hashCode * 59 + ShowCountries.GetHashCode();
                if (ShowFrame != null) hashCode = hashCode * 59 + ShowFrame.GetHashCode();
                if (ShowLakes != null) hashCode = hashCode * 59 + ShowLakes.GetHashCode();
                if (ShowLand != null) hashCode = hashCode * 59 + ShowLand.GetHashCode();
                if (ShowOcean != null) hashCode = hashCode * 59 + ShowOcean.GetHashCode();
                if (ShowRivers != null) hashCode = hashCode * 59 + ShowRivers.GetHashCode();
                if (ShowSubUnits != null) hashCode = hashCode * 59 + ShowSubUnits.GetHashCode();
                if (SubUnitColor != null) hashCode = hashCode * 59 + SubUnitColor.GetHashCode();
                if (SubUnitWidth != null) hashCode = hashCode * 59 + SubUnitWidth.GetHashCode();
                if (UiRevision != null) hashCode = hashCode * 59 + UiRevision.GetHashCode();
                if (Visible != null) hashCode = hashCode * 59 + Visible.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Geo and the right Geo.
        /// </summary>
        /// <param name="left">Left Geo.</param>
        /// <param name="right">Right Geo.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Geo left, Geo right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Geo and the right Geo.
        /// </summary>
        /// <param name="left">Left Geo.</param>
        /// <param name="right">Right Geo.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Geo left, Geo right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Geo</returns>
        public Geo DeepClone()
        {
            return this.Copy();
        }
    }
}