/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor
{
    /// <summary>
    ///     The Layout class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [JsonConverter(typeof(PlotlyConverter))]
    [Serializable]
    public class Layout : IEquatable<Layout>
    {
        /// <summary>
        ///     Sets the rounding of bar corners. May be an integer number of pixels, or
        ///     a percentage of bar width (as a string ending in %).
        /// </summary>
        [JsonPropertyName(@"barcornerradius")]
        public object BarCornerRadius { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between bars of adjacent location coordinates.
        /// </summary>
        [JsonPropertyName(@"bargap")]
        public decimal? BarGap { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between bars of the same location coordinate.
        /// </summary>
        [JsonPropertyName(@"bargroupgap")]
        public decimal? BarGroupGap { get; set;} 

        /// <summary>
        ///     Determines how bars at the same location coordinate are displayed on the
        ///     graph. With <c>stack</c>, the bars are stacked on top of one another With
        ///     <c>relative</c>, the bars are stacked on top of one another, with negative
        ///     values below the axis, positive values above With <c>group</c>, the bars
        ///     are plotted next to one another centered around the shared location. With
        ///     <c>overlay</c>, the bars are plotted over one another, you might need to
        ///     reduce <c>opacity</c> to see multiple bars.
        /// </summary>
        [JsonPropertyName(@"barmode")]
        public Plotly.Blazor.LayoutLib.BarModeEnum? BarMode { get; set;} 

        /// <summary>
        ///     Sets the normalization for bar traces on the graph. With <c>fraction</c>,
        ///     the value of each bar is divided by the sum of all values at that location
        ///     coordinate. <c>percent</c> is the same but multiplied by 100 to show percentages.
        /// </summary>
        [JsonPropertyName(@"barnorm")]
        public Plotly.Blazor.LayoutLib.BarNormEnum? BarNorm { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between boxes of adjacent location coordinates.
        ///     Has no effect on traces that have <c>width</c> set.
        /// </summary>
        [JsonPropertyName(@"boxgap")]
        public decimal? BoxGap { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between boxes of the same location coordinate.
        ///     Has no effect on traces that have <c>width</c> set.
        /// </summary>
        [JsonPropertyName(@"boxgroupgap")]
        public decimal? BoxGroupGap { get; set;} 

        /// <summary>
        ///     Determines how boxes at the same location coordinate are displayed on the
        ///     graph. If <c>group</c>, the boxes are plotted next to one another centered
        ///     around the shared location. If <c>overlay</c>, the boxes are plotted over
        ///     one another, you might need to set <c>opacity</c> to see them multiple boxes.
        ///     Has no effect on traces that have <c>width</c> set.
        /// </summary>
        [JsonPropertyName(@"boxmode")]
        public Plotly.Blazor.LayoutLib.BoxModeEnum? BoxMode { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between bars of adjacent location coordinates.
        /// </summary>
        [JsonPropertyName(@"funnelgap")]
        public decimal? FunnelGap { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between bars of the same location coordinate.
        /// </summary>
        [JsonPropertyName(@"funnelgroupgap")]
        public decimal? FunnelGroupGap { get; set;} 

        /// <summary>
        ///     Determines how bars at the same location coordinate are displayed on the
        ///     graph. With <c>stack</c>, the bars are stacked on top of one another With
        ///     <c>group</c>, the bars are plotted next to one another centered around the
        ///     shared location. With <c>overlay</c>, the bars are plotted over one another,
        ///     you might need to reduce <c>opacity</c> to see multiple bars.
        /// </summary>
        [JsonPropertyName(@"funnelmode")]
        public Plotly.Blazor.LayoutLib.FunnelModeEnum? FunnelMode { get; set;} 

        /// <summary>
        ///     If <c>true</c>, the funnelarea slice colors (whether given by <c>funnelareacolorway</c>
        ///     or inherited from <c>colorway</c>) will be extended to three times its original
        ///     length by first repeating every color 20% lighter then each color 20% darker.
        ///     This is intended to reduce the likelihood of reusing the same color when
        ///     you have many slices, but you can set <c>false</c> to disable. Colors provided
        ///     in the trace, using <c>marker.colors</c>, are never extended.
        /// </summary>
        [JsonPropertyName(@"extendfunnelareacolors")]
        public bool? ExtendFunnelAreaColors { get; set;} 

        /// <summary>
        ///     Sets the default funnelarea slice colors. Defaults to the main <c>colorway</c>
        ///     used for trace colors. If you specify a new list here it can still be extended
        ///     with lighter and darker colors, see <c>extendfunnelareacolors</c>.
        /// </summary>
        [JsonPropertyName(@"funnelareacolorway")]
        public IList<object> FunnelAreaColorway { get; set;} 

        /// <summary>
        ///     hiddenlabels is the funnelarea &amp; pie chart analog of visible:<c>legendonly</c>
        ///     but it can contain many labels, and can simultaneously hide slices from
        ///     several pies/funnelarea charts
        /// </summary>
        [JsonPropertyName(@"hiddenlabels")]
        public IList<object> HiddenLabels { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>hiddenlabels</c>.
        /// </summary>
        [JsonPropertyName(@"hiddenlabelssrc")]
        public string HiddenLabelsSrc { get; set;} 

        /// <summary>
        ///     If <c>true</c>, the icicle slice colors (whether given by <c>iciclecolorway</c>
        ///     or inherited from <c>colorway</c>) will be extended to three times its original
        ///     length by first repeating every color 20% lighter then each color 20% darker.
        ///     This is intended to reduce the likelihood of reusing the same color when
        ///     you have many slices, but you can set <c>false</c> to disable. Colors provided
        ///     in the trace, using <c>marker.colors</c>, are never extended.
        /// </summary>
        [JsonPropertyName(@"extendiciclecolors")]
        public bool? ExtendIcicleColors { get; set;} 

        /// <summary>
        ///     Sets the default icicle slice colors. Defaults to the main <c>colorway</c>
        ///     used for trace colors. If you specify a new list here it can still be extended
        ///     with lighter and darker colors, see <c>extendiciclecolors</c>.
        /// </summary>
        [JsonPropertyName(@"iciclecolorway")]
        public IList<object> IcicleColorway { get; set;} 

        /// <summary>
        ///     If <c>true</c>, the pie slice colors (whether given by <c>piecolorway</c>
        ///     or inherited from <c>colorway</c>) will be extended to three times its original
        ///     length by first repeating every color 20% lighter then each color 20% darker.
        ///     This is intended to reduce the likelihood of reusing the same color when
        ///     you have many slices, but you can set <c>false</c> to disable. Colors provided
        ///     in the trace, using <c>marker.colors</c>, are never extended.
        /// </summary>
        [JsonPropertyName(@"extendpiecolors")]
        public bool? ExtendPieColors { get; set;} 

        /// <summary>
        ///     Sets the default pie slice colors. Defaults to the main <c>colorway</c>
        ///     used for trace colors. If you specify a new list here it can still be extended
        ///     with lighter and darker colors, see <c>extendpiecolors</c>.
        /// </summary>
        [JsonPropertyName(@"piecolorway")]
        public IList<object> PieColorway { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between scatter points of adjacent location
        ///     coordinates. Defaults to <c>bargap</c>.
        /// </summary>
        [JsonPropertyName(@"scattergap")]
        public decimal? ScatterGap { get; set;} 

        /// <summary>
        ///     Determines how scatter points at the same location coordinate are displayed
        ///     on the graph. With <c>group</c>, the scatter points are plotted next to
        ///     one another centered around the shared location. With <c>overlay</c>, the
        ///     scatter points are plotted over one another, you might need to reduce <c>opacity</c>
        ///     to see multiple scatter points.
        /// </summary>
        [JsonPropertyName(@"scattermode")]
        public Plotly.Blazor.LayoutLib.ScatterModeEnum? ScatterMode { get; set;} 

        /// <summary>
        ///     If <c>true</c>, the sunburst slice colors (whether given by <c>sunburstcolorway</c>
        ///     or inherited from <c>colorway</c>) will be extended to three times its original
        ///     length by first repeating every color 20% lighter then each color 20% darker.
        ///     This is intended to reduce the likelihood of reusing the same color when
        ///     you have many slices, but you can set <c>false</c> to disable. Colors provided
        ///     in the trace, using <c>marker.colors</c>, are never extended.
        /// </summary>
        [JsonPropertyName(@"extendsunburstcolors")]
        public bool? ExtendSunburstColors { get; set;} 

        /// <summary>
        ///     Sets the default sunburst slice colors. Defaults to the main <c>colorway</c>
        ///     used for trace colors. If you specify a new list here it can still be extended
        ///     with lighter and darker colors, see <c>extendsunburstcolors</c>.
        /// </summary>
        [JsonPropertyName(@"sunburstcolorway")]
        public IList<object> SunburstColorway { get; set;} 

        /// <summary>
        ///     If <c>true</c>, the treemap slice colors (whether given by <c>treemapcolorway</c>
        ///     or inherited from <c>colorway</c>) will be extended to three times its original
        ///     length by first repeating every color 20% lighter then each color 20% darker.
        ///     This is intended to reduce the likelihood of reusing the same color when
        ///     you have many slices, but you can set <c>false</c> to disable. Colors provided
        ///     in the trace, using <c>marker.colors</c>, are never extended.
        /// </summary>
        [JsonPropertyName(@"extendtreemapcolors")]
        public bool? ExtendTreeMapColors { get; set;} 

        /// <summary>
        ///     Sets the default treemap slice colors. Defaults to the main <c>colorway</c>
        ///     used for trace colors. If you specify a new list here it can still be extended
        ///     with lighter and darker colors, see <c>extendtreemapcolors</c>.
        /// </summary>
        [JsonPropertyName(@"treemapcolorway")]
        public IList<object> TreeMapColorway { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between violins of adjacent location coordinates.
        ///     Has no effect on traces that have <c>width</c> set.
        /// </summary>
        [JsonPropertyName(@"violingap")]
        public decimal? ViolinGap { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between violins of the same location coordinate.
        ///     Has no effect on traces that have <c>width</c> set.
        /// </summary>
        [JsonPropertyName(@"violingroupgap")]
        public decimal? ViolinGroupGap { get; set;} 

        /// <summary>
        ///     Determines how violins at the same location coordinate are displayed on
        ///     the graph. If <c>group</c>, the violins are plotted next to one another
        ///     centered around the shared location. If <c>overlay</c>, the violins are
        ///     plotted over one another, you might need to set <c>opacity</c> to see them
        ///     multiple violins. Has no effect on traces that have <c>width</c> set.
        /// </summary>
        [JsonPropertyName(@"violinmode")]
        public Plotly.Blazor.LayoutLib.ViolinModeEnum? ViolinMode { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between bars of adjacent location coordinates.
        /// </summary>
        [JsonPropertyName(@"waterfallgap")]
        public decimal? WaterfallGap { get; set;} 

        /// <summary>
        ///     Sets the gap (in plot fraction) between bars of the same location coordinate.
        /// </summary>
        [JsonPropertyName(@"waterfallgroupgap")]
        public decimal? WaterfallGroupGap { get; set;} 

        /// <summary>
        ///     Determines how bars at the same location coordinate are displayed on the
        ///     graph. With <c>group</c>, the bars are plotted next to one another centered
        ///     around the shared location. With <c>overlay</c>, the bars are plotted over
        ///     one another, you might need to reduce <c>opacity</c> to see multiple bars.
        /// </summary>
        [JsonPropertyName(@"waterfallmode")]
        public Plotly.Blazor.LayoutLib.WaterfallModeEnum? WaterfallMode { get; set;} 

        /// <summary>
        ///     Gets or sets the ActiveSelection.
        /// </summary>
        [JsonPropertyName(@"activeselection")]
        public Plotly.Blazor.LayoutLib.ActiveSelection ActiveSelection { get; set;} 

        /// <summary>
        ///     Gets or sets the ActiveShape.
        /// </summary>
        [JsonPropertyName(@"activeshape")]
        public Plotly.Blazor.LayoutLib.ActiveShape ActiveShape { get; set;} 

        /// <summary>
        ///     Gets or sets the Annotations.
        /// </summary>
        [JsonPropertyName(@"annotations")]
        public IList<Plotly.Blazor.LayoutLib.Annotation> Annotations { get; set;} 

        /// <summary>
        ///     Determines whether or not a layout width or height that has been left undefined
        ///     by the user is initialized on each relayout. Note that, regardless of this
        ///     attribute, an undefined layout width or height is always initialized on
        ///     the first call to plot.
        /// </summary>
        [JsonPropertyName(@"autosize")]
        public bool? AutoSize { get; set;} 

        /// <summary>
        ///     Using <c>strict</c> a numeric string in trace data is not converted to a
        ///     number. Using &#39;convert types&#39; a numeric string in trace data may
        ///     be treated as a number during automatic axis <c>type</c> detection. This
        ///     is the default value; however it could be overridden for individual axes.
        /// </summary>
        [JsonPropertyName(@"autotypenumbers")]
        public Plotly.Blazor.LayoutLib.AutoTypeNumbersEnum? AutoTypeNumbers { get; set;} 

        /// <summary>
        ///     Sets the default calendar system to use for interpreting and displaying
        ///     dates throughout the plot.
        /// </summary>
        [JsonPropertyName(@"calendar")]
        public Plotly.Blazor.LayoutLib.CalendarEnum? Calendar { get; set;} 

        /// <summary>
        ///     Determines the mode of single click interactions. <c>event</c> is the default
        ///     value and emits the <c>plotly_click</c> event. In addition this mode emits
        ///     the <c>plotly_selected</c> event in drag modes <c>lasso</c> and <c>select</c>,
        ///     but with no event data attached (kept for compatibility reasons). The <c>select</c>
        ///     flag enables selecting single data points via click. This mode also supports
        ///     persistent selections, meaning that pressing Shift while clicking, adds
        ///     to / subtracts from an existing selection. <c>select</c> with <c>hovermode</c>:
        ///     <c>x</c> can be confusing, consider explicitly setting <c>hovermode</c>:
        ///     <c>closest</c> when using this feature. Selection events are sent accordingly
        ///     as long as <c>event</c> flag is set as well. When the <c>event</c> flag
        ///     is missing, <c>plotly_click</c> and <c>plotly_selected</c> events are not
        ///     fired.
        /// </summary>
        [JsonPropertyName(@"clickmode")]
        public Plotly.Blazor.LayoutLib.ClickModeFlag? ClickMode { get; set;} 

        /// <summary>
        ///     Gets or sets the ColorAxis.
        /// </summary>
        [JsonPropertyName(@"coloraxis")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.ColorAxis> ColorAxis { get; set;} 

        /// <summary>
        ///     Gets or sets the ColorScale.
        /// </summary>
        [JsonPropertyName(@"colorscale")]
        public Plotly.Blazor.LayoutLib.ColorScale ColorScale { get; set;} 

        /// <summary>
        ///     Sets the default trace colors.
        /// </summary>
        [JsonPropertyName(@"colorway")]
        public IList<object> Colorway { get; set;} 

        /// <summary>
        ///     Placeholder for exporting automargin-impacting values namely <c>margin.t</c>,
        ///     <c>margin.b</c>, <c>margin.l</c> and <c>margin.r</c> in <c>full-json</c>
        ///     mode.
        /// </summary>
        [JsonPropertyName(@"computed")]
        public object Computed { get; set;} 

        /// <summary>
        ///     If provided, a changed value tells <c>Plotly.react</c> that one or more
        ///     data arrays has changed. This way you can modify arrays in-place rather
        ///     than making a complete new copy for an incremental change. If NOT provided,
        ///     <c>Plotly.react</c> assumes that data arrays are being treated as immutable,
        ///     thus any data array with a different identity from its predecessor contains
        ///     new data.
        /// </summary>
        [JsonPropertyName(@"datarevision")]
        public object DataRevision { get; set;} 

        /// <summary>
        ///     Determines the mode of drag interactions. <c>select</c> and <c>lasso</c>
        ///     apply only to scatter traces with markers or text. <c>orbit</c> and <c>turntable</c>
        ///     apply only to 3D scenes.
        /// </summary>
        [JsonPropertyName(@"dragmode")]
        public Plotly.Blazor.LayoutLib.DragModeEnum? DragMode { get; set;} 

        /// <summary>
        ///     Controls persistence of user-driven changes in &#39;editable: true&#39;
        ///     configuration, other than trace names and axis titles. Defaults to <c>layout.uirevision</c>.
        /// </summary>
        [JsonPropertyName(@"editrevision")]
        public object EditRevision { get; set;} 

        /// <summary>
        ///     Sets the global font. Note that fonts used in traces and other layout components
        ///     inherit from the global font.
        /// </summary>
        [JsonPropertyName(@"font")]
        public Plotly.Blazor.LayoutLib.Font Font { get; set;} 

        /// <summary>
        ///     Gets or sets the Geo.
        /// </summary>
        [JsonPropertyName(@"geo")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.Geo> Geo { get; set;} 

        /// <summary>
        ///     Gets or sets the Grid.
        /// </summary>
        [JsonPropertyName(@"grid")]
        public Plotly.Blazor.LayoutLib.Grid Grid { get; set;} 

        /// <summary>
        ///     Sets the plot&#39;s height (in px).
        /// </summary>
        [JsonPropertyName(@"height")]
        public decimal? Height { get; set;} 

        /// <summary>
        ///     Determines whether or not a text link citing the data source is placed at
        ///     the bottom-right cored of the figure. Has only an effect only on graphs
        ///     that have been generated via forked graphs from the Chart Studio Cloud (at
        ///     https://chart-studio.plotly.com or on-premise).
        /// </summary>
        [JsonPropertyName(@"hidesources")]
        public bool? HideSources { get; set;} 

        /// <summary>
        ///     Sets the default distance (in pixels) to look for data to add hover labels
        ///     (-1 means no cutoff, 0 means no looking for data). This is only a real distance
        ///     for hovering on point-like objects, like scatter points. For area-like objects
        ///     (bars, scatter fills, etc) hovering is on inside the area and off outside,
        ///     but these objects will not supersede hover on point-like objects in case
        ///     of conflict.
        /// </summary>
        [JsonPropertyName(@"hoverdistance")]
        public int? HoverDistance { get; set;} 

        /// <summary>
        ///     Gets or sets the HoverLabel.
        /// </summary>
        [JsonPropertyName(@"hoverlabel")]
        public Plotly.Blazor.LayoutLib.HoverLabel HoverLabel { get; set;} 

        /// <summary>
        ///     Determines the mode of hover interactions. If <c>closest</c>, a single hoverlabel
        ///     will appear for the <c>closest</c> point within the <c>hoverdistance</c>.
        ///     If <c>x</c> (or <c>y</c>), multiple hoverlabels will appear for multiple
        ///     points at the <c>closest</c> x- (or y-) coordinate within the <c>hoverdistance</c>,
        ///     with the caveat that no more than one hoverlabel will appear per trace.
        ///     If &#39;x unified&#39; (or &#39;y unified&#39;), a single hoverlabel will
        ///     appear multiple points at the closest x- (or y-) coordinate within the <c>hoverdistance</c>
        ///     with the caveat that no more than one hoverlabel will appear per trace.
        ///     In this mode, spikelines are enabled by default perpendicular to the specified
        ///     axis. If false, hover interactions are disabled.
        /// </summary>
        [JsonPropertyName(@"hovermode")]
        public Plotly.Blazor.LayoutLib.HoverModeEnum? HoverMode { get; set;} 

        /// <summary>
        ///     Determines expansion of hover effects to other subplots If <c>single</c>
        ///     just the axis pair of the primary point is included without overlaying subplots.
        ///     If <c>overlaying</c> all subplots using the main axis and occupying the
        ///     same space are included. If <c>axis</c>, also include stacked subplots using
        ///     the same axis when <c>hovermode</c> is set to <c>x</c>, &#39;x unified&#39;,
        ///     <c>y</c> or &#39;y unified&#39;.
        /// </summary>
        [JsonPropertyName(@"hoversubplots")]
        public Plotly.Blazor.LayoutLib.HoverSubplotsEnum? HoverSubplots { get; set;} 

        /// <summary>
        ///     Gets or sets the Images.
        /// </summary>
        [JsonPropertyName(@"images")]
        public IList<Plotly.Blazor.LayoutLib.Image> Images { get; set;} 

        /// <summary>
        ///     Gets or sets the Legend.
        /// </summary>
        [JsonPropertyName(@"legend")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.Legend> Legend { get; set;} 

        /// <summary>
        ///     Gets or sets the Map.
        /// </summary>
        [JsonPropertyName(@"map")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.Map> Map { get; set;} 

        /// <summary>
        ///     Gets or sets the MapBox.
        /// </summary>
        [JsonPropertyName(@"mapbox")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.MapBox> MapBox { get; set;} 

        /// <summary>
        ///     Gets or sets the Margin.
        /// </summary>
        [JsonPropertyName(@"margin")]
        public Plotly.Blazor.LayoutLib.Margin Margin { get; set;} 

        /// <summary>
        ///     Assigns extra meta information that can be used in various <c>text</c> attributes.
        ///     Attributes such as the graph, axis and colorbar <c>title.text</c>, annotation
        ///     <c>text</c> <c>trace.name</c> in legend items, <c>rangeselector</c>, <c>updatemenus</c>
        ///     and <c>sliders</c> <c>label</c> text all support <c>meta</c>. One can access
        ///     <c>meta</c> fields using template strings: <c>%{meta[i]}</c> where <c>i</c>
        ///     is the index of the <c>meta</c> item in question. <c>meta</c> can also be
        ///     an object for example &#39;{key: value}&#39; which can be accessed %{meta[key]}.
        /// </summary>
        [JsonPropertyName(@"meta")]
        public object Meta { get; set;} 

        /// <summary>
        ///     Assigns extra meta information that can be used in various <c>text</c> attributes.
        ///     Attributes such as the graph, axis and colorbar <c>title.text</c>, annotation
        ///     <c>text</c> <c>trace.name</c> in legend items, <c>rangeselector</c>, <c>updatemenus</c>
        ///     and <c>sliders</c> <c>label</c> text all support <c>meta</c>. One can access
        ///     <c>meta</c> fields using template strings: <c>%{meta[i]}</c> where <c>i</c>
        ///     is the index of the <c>meta</c> item in question. <c>meta</c> can also be
        ///     an object for example &#39;{key: value}&#39; which can be accessed %{meta[key]}.
        /// </summary>
        [JsonPropertyName(@"meta")]
        [Array]
        public IList<object> MetaArray { get; set;} 

        /// <summary>
        ///     Sets the source reference on Chart Studio Cloud for <c>meta</c>.
        /// </summary>
        [JsonPropertyName(@"metasrc")]
        public string MetaSrc { get; set;} 

        /// <summary>
        ///     Minimum height of the plot with margin.automargin applied (in px)
        /// </summary>
        [JsonPropertyName(@"minreducedheight")]
        public decimal? MinReducedHeight { get; set;} 

        /// <summary>
        ///     Minimum width of the plot with margin.automargin applied (in px)
        /// </summary>
        [JsonPropertyName(@"minreducedwidth")]
        public decimal? MinReducedWidth { get; set;} 

        /// <summary>
        ///     Gets or sets the ModeBar.
        /// </summary>
        [JsonPropertyName(@"modebar")]
        public Plotly.Blazor.LayoutLib.ModeBar ModeBar { get; set;} 

        /// <summary>
        ///     Gets or sets the NewSelection.
        /// </summary>
        [JsonPropertyName(@"newselection")]
        public Plotly.Blazor.LayoutLib.NewSelection NewSelection { get; set;} 

        /// <summary>
        ///     Gets or sets the NewShape.
        /// </summary>
        [JsonPropertyName(@"newshape")]
        public Plotly.Blazor.LayoutLib.NewShape NewShape { get; set;} 

        /// <summary>
        ///     Sets the background color of the paper where the graph is drawn.
        /// </summary>
        [JsonPropertyName(@"paper_bgcolor")]
        public object PaperBgColor { get; set;} 

        /// <summary>
        ///     Sets the background color of the plotting area in-between x and y axes.
        /// </summary>
        [JsonPropertyName(@"plot_bgcolor")]
        public object PlotBgColor { get; set;} 

        /// <summary>
        ///     Gets or sets the Polar.
        /// </summary>
        [JsonPropertyName(@"polar")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.Polar> Polar { get; set;} 

        /// <summary>
        ///     Gets or sets the Scene.
        /// </summary>
        [JsonPropertyName(@"scene")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.Scene> Scene { get; set;} 

        /// <summary>
        ///     When <c>dragmode</c> is set to <c>select</c>, this limits the selection
        ///     of the drag to horizontal, vertical or diagonal. <c>h</c> only allows horizontal
        ///     selection, <c>v</c> only vertical, <c>d</c> only diagonal and <c>any</c>
        ///     sets no limit.
        /// </summary>
        [JsonPropertyName(@"selectdirection")]
        public Plotly.Blazor.LayoutLib.SelectDirectionEnum? SelectDirection { get; set;} 

        /// <summary>
        ///     Controls persistence of user-driven changes in selected points from all
        ///     traces.
        /// </summary>
        [JsonPropertyName(@"selectionrevision")]
        public object SelectionRevision { get; set;} 

        /// <summary>
        ///     Gets or sets the Selections.
        /// </summary>
        [JsonPropertyName(@"selections")]
        public IList<Plotly.Blazor.LayoutLib.Selection> Selections { get; set;} 

        /// <summary>
        ///     Sets the decimal and thousand separators. For example, &#39;. &#39; puts
        ///     a <c>.</c> before decimals and a space between thousands. In English locales,
        ///     dflt is <c>.,</c> but other locales may alter this default.
        /// </summary>
        [JsonPropertyName(@"separators")]
        public string Separators { get; set;} 

        /// <summary>
        ///     Gets or sets the Shapes.
        /// </summary>
        [JsonPropertyName(@"shapes")]
        public IList<Plotly.Blazor.LayoutLib.Shape> Shapes { get; set;} 

        /// <summary>
        ///     Determines whether or not a legend is drawn. Default is <c>true</c> if there
        ///     is a trace to show and any of these: a) Two or more traces would by default
        ///     be shown in the legend. b) One pie trace is shown in the legend. c) One
        ///     trace is explicitly given with &#39;showlegend: true&#39;.
        /// </summary>
        [JsonPropertyName(@"showlegend")]
        public bool? ShowLegend { get; set;} 

        /// <summary>
        ///     Gets or sets the Sliders.
        /// </summary>
        [JsonPropertyName(@"sliders")]
        public IList<Plotly.Blazor.LayoutLib.Slider> Sliders { get; set;} 

        /// <summary>
        ///     Gets or sets the Smith.
        /// </summary>
        [JsonPropertyName(@"smith")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.Smith> Smith { get; set;} 

        /// <summary>
        ///     Sets the default distance (in pixels) to look for data to draw spikelines
        ///     to (-1 means no cutoff, 0 means no looking for data). As with hoverdistance,
        ///     distance does not apply to area-like objects. In addition, some objects
        ///     can be hovered on but will not generate spikelines, such as scatter fills.
        /// </summary>
        [JsonPropertyName(@"spikedistance")]
        public int? SpikeDistance { get; set;} 

        /// <summary>
        ///     Default attributes to be applied to the plot. Templates can be created from
        ///     existing plots using <c>Plotly.makeTemplate</c>, or created manually. They
        ///     should be objects with format: &#39;{layout: layoutTemplate, data: {[type]:
        ///     [traceTemplate, ...]}, ...}&#39; <c>layoutTemplate</c> and <c>traceTemplate</c>
        ///     are objects matching the attribute structure of <c>layout</c> and a data
        ///     trace.  Trace templates are applied cyclically to traces of each type. Container
        ///     arrays (eg <c>annotations</c>) have special handling: An object ending in
        ///     <c>defaults</c> (eg <c>annotationdefaults</c>) is applied to each array
        ///     item. But if an item has a <c>templateitemname</c> key we look in the template
        ///     array for an item with matching <c>name</c> and apply that instead. If no
        ///     matching <c>name</c> is found we mark the item invisible. Any named template
        ///     item not referenced is appended to the end of the array, so you can use
        ///     this for a watermark annotation or a logo image, for example. To omit one
        ///     of these items on the plot, make an item with matching <c>templateitemname</c>
        ///     and &#39;visible: false&#39;.
        /// </summary>
        [JsonPropertyName(@"template")]
        public object Template { get; set;} 

        /// <summary>
        ///     Gets or sets the Ternary.
        /// </summary>
        [JsonPropertyName(@"ternary")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.Ternary> Ternary { get; set;} 

        /// <summary>
        ///     Gets or sets the Title.
        /// </summary>
        [JsonPropertyName(@"title")]
        public Plotly.Blazor.LayoutLib.Title Title { get; set;} 

        /// <summary>
        ///     Sets transition options used during Plotly.react updates.
        /// </summary>
        [JsonPropertyName(@"transition")]
        public Plotly.Blazor.LayoutLib.Transition Transition { get; set;} 

        /// <summary>
        ///     Used to allow user interactions with the plot to persist after <c>Plotly.react</c>
        ///     calls that are unaware of these interactions. If <c>uirevision</c> is omitted,
        ///     or if it is given and it changed from the previous <c>Plotly.react</c> call,
        ///     the exact new figure is used. If <c>uirevision</c> is truthy and did NOT
        ///     change, any attribute that has been affected by user interactions and did
        ///     not receive a different value in the new figure will keep the interaction
        ///     value. <c>layout.uirevision</c> attribute serves as the default for <c>uirevision</c>
        ///     attributes in various sub-containers. For finer control you can set these
        ///     sub-attributes directly. For example, if your app separately controls the
        ///     data on the x and y axes you might set <c>xaxis.uirevision=<c>time</c></c>
        ///     and <c>yaxis.uirevision=<c>cost</c></c>. Then if only the y data is changed,
        ///     you can update <c>yaxis.uirevision=<c>quantity</c></c> and the y axis range
        ///     will reset but the x axis range will retain any user-driven zoom.
        /// </summary>
        [JsonPropertyName(@"uirevision")]
        public object UiRevision { get; set;} 

        /// <summary>
        ///     Gets or sets the UniformText.
        /// </summary>
        [JsonPropertyName(@"uniformtext")]
        public Plotly.Blazor.LayoutLib.UniformText UniformText { get; set;} 

        /// <summary>
        ///     Gets or sets the UpdateMenus.
        /// </summary>
        [JsonPropertyName(@"updatemenus")]
        public IList<Plotly.Blazor.LayoutLib.UpdateMenu> UpdateMenus { get; set;} 

        /// <summary>
        ///     Sets the plot&#39;s width (in px).
        /// </summary>
        [JsonPropertyName(@"width")]
        public decimal? Width { get; set;} 

        /// <summary>
        ///     Gets or sets the XAxis.
        /// </summary>
        [JsonPropertyName(@"xaxis")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.XAxis> XAxis { get; set;} 

        /// <summary>
        ///     Gets or sets the YAxis.
        /// </summary>
        [JsonPropertyName(@"yaxis")]
        [Subplot]
        public IList<Plotly.Blazor.LayoutLib.YAxis> YAxis { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Layout other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Layout other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    BarCornerRadius == other.BarCornerRadius ||
                    BarCornerRadius != null &&
                    BarCornerRadius.Equals(other.BarCornerRadius)
                ) && 
                (
                    BarGap == other.BarGap ||
                    BarGap != null &&
                    BarGap.Equals(other.BarGap)
                ) && 
                (
                    BarGroupGap == other.BarGroupGap ||
                    BarGroupGap != null &&
                    BarGroupGap.Equals(other.BarGroupGap)
                ) && 
                (
                    BarMode == other.BarMode ||
                    BarMode != null &&
                    BarMode.Equals(other.BarMode)
                ) && 
                (
                    BarNorm == other.BarNorm ||
                    BarNorm != null &&
                    BarNorm.Equals(other.BarNorm)
                ) && 
                (
                    BoxGap == other.BoxGap ||
                    BoxGap != null &&
                    BoxGap.Equals(other.BoxGap)
                ) && 
                (
                    BoxGroupGap == other.BoxGroupGap ||
                    BoxGroupGap != null &&
                    BoxGroupGap.Equals(other.BoxGroupGap)
                ) && 
                (
                    BoxMode == other.BoxMode ||
                    BoxMode != null &&
                    BoxMode.Equals(other.BoxMode)
                ) && 
                (
                    FunnelGap == other.FunnelGap ||
                    FunnelGap != null &&
                    FunnelGap.Equals(other.FunnelGap)
                ) && 
                (
                    FunnelGroupGap == other.FunnelGroupGap ||
                    FunnelGroupGap != null &&
                    FunnelGroupGap.Equals(other.FunnelGroupGap)
                ) && 
                (
                    FunnelMode == other.FunnelMode ||
                    FunnelMode != null &&
                    FunnelMode.Equals(other.FunnelMode)
                ) && 
                (
                    ExtendFunnelAreaColors == other.ExtendFunnelAreaColors ||
                    ExtendFunnelAreaColors != null &&
                    ExtendFunnelAreaColors.Equals(other.ExtendFunnelAreaColors)
                ) && 
                (
                    Equals(FunnelAreaColorway, other.FunnelAreaColorway) ||
                    FunnelAreaColorway != null && other.FunnelAreaColorway != null &&
                    FunnelAreaColorway.SequenceEqual(other.FunnelAreaColorway)
                ) &&
                (
                    Equals(HiddenLabels, other.HiddenLabels) ||
                    HiddenLabels != null && other.HiddenLabels != null &&
                    HiddenLabels.SequenceEqual(other.HiddenLabels)
                ) &&
                (
                    HiddenLabelsSrc == other.HiddenLabelsSrc ||
                    HiddenLabelsSrc != null &&
                    HiddenLabelsSrc.Equals(other.HiddenLabelsSrc)
                ) && 
                (
                    ExtendIcicleColors == other.ExtendIcicleColors ||
                    ExtendIcicleColors != null &&
                    ExtendIcicleColors.Equals(other.ExtendIcicleColors)
                ) && 
                (
                    Equals(IcicleColorway, other.IcicleColorway) ||
                    IcicleColorway != null && other.IcicleColorway != null &&
                    IcicleColorway.SequenceEqual(other.IcicleColorway)
                ) &&
                (
                    ExtendPieColors == other.ExtendPieColors ||
                    ExtendPieColors != null &&
                    ExtendPieColors.Equals(other.ExtendPieColors)
                ) && 
                (
                    Equals(PieColorway, other.PieColorway) ||
                    PieColorway != null && other.PieColorway != null &&
                    PieColorway.SequenceEqual(other.PieColorway)
                ) &&
                (
                    ScatterGap == other.ScatterGap ||
                    ScatterGap != null &&
                    ScatterGap.Equals(other.ScatterGap)
                ) && 
                (
                    ScatterMode == other.ScatterMode ||
                    ScatterMode != null &&
                    ScatterMode.Equals(other.ScatterMode)
                ) && 
                (
                    ExtendSunburstColors == other.ExtendSunburstColors ||
                    ExtendSunburstColors != null &&
                    ExtendSunburstColors.Equals(other.ExtendSunburstColors)
                ) && 
                (
                    Equals(SunburstColorway, other.SunburstColorway) ||
                    SunburstColorway != null && other.SunburstColorway != null &&
                    SunburstColorway.SequenceEqual(other.SunburstColorway)
                ) &&
                (
                    ExtendTreeMapColors == other.ExtendTreeMapColors ||
                    ExtendTreeMapColors != null &&
                    ExtendTreeMapColors.Equals(other.ExtendTreeMapColors)
                ) && 
                (
                    Equals(TreeMapColorway, other.TreeMapColorway) ||
                    TreeMapColorway != null && other.TreeMapColorway != null &&
                    TreeMapColorway.SequenceEqual(other.TreeMapColorway)
                ) &&
                (
                    ViolinGap == other.ViolinGap ||
                    ViolinGap != null &&
                    ViolinGap.Equals(other.ViolinGap)
                ) && 
                (
                    ViolinGroupGap == other.ViolinGroupGap ||
                    ViolinGroupGap != null &&
                    ViolinGroupGap.Equals(other.ViolinGroupGap)
                ) && 
                (
                    ViolinMode == other.ViolinMode ||
                    ViolinMode != null &&
                    ViolinMode.Equals(other.ViolinMode)
                ) && 
                (
                    WaterfallGap == other.WaterfallGap ||
                    WaterfallGap != null &&
                    WaterfallGap.Equals(other.WaterfallGap)
                ) && 
                (
                    WaterfallGroupGap == other.WaterfallGroupGap ||
                    WaterfallGroupGap != null &&
                    WaterfallGroupGap.Equals(other.WaterfallGroupGap)
                ) && 
                (
                    WaterfallMode == other.WaterfallMode ||
                    WaterfallMode != null &&
                    WaterfallMode.Equals(other.WaterfallMode)
                ) && 
                (
                    ActiveSelection == other.ActiveSelection ||
                    ActiveSelection != null &&
                    ActiveSelection.Equals(other.ActiveSelection)
                ) && 
                (
                    ActiveShape == other.ActiveShape ||
                    ActiveShape != null &&
                    ActiveShape.Equals(other.ActiveShape)
                ) && 
                (
                    Equals(Annotations, other.Annotations) ||
                    Annotations != null && other.Annotations != null &&
                    Annotations.SequenceEqual(other.Annotations)
                ) &&
                (
                    AutoSize == other.AutoSize ||
                    AutoSize != null &&
                    AutoSize.Equals(other.AutoSize)
                ) && 
                (
                    AutoTypeNumbers == other.AutoTypeNumbers ||
                    AutoTypeNumbers != null &&
                    AutoTypeNumbers.Equals(other.AutoTypeNumbers)
                ) && 
                (
                    Calendar == other.Calendar ||
                    Calendar != null &&
                    Calendar.Equals(other.Calendar)
                ) && 
                (
                    ClickMode == other.ClickMode ||
                    ClickMode != null &&
                    ClickMode.Equals(other.ClickMode)
                ) && 
                (
                    Equals(ColorAxis, other.ColorAxis) ||
                    ColorAxis != null && other.ColorAxis != null &&
                    ColorAxis.SequenceEqual(other.ColorAxis)
                ) &&
                (
                    ColorScale == other.ColorScale ||
                    ColorScale != null &&
                    ColorScale.Equals(other.ColorScale)
                ) && 
                (
                    Equals(Colorway, other.Colorway) ||
                    Colorway != null && other.Colorway != null &&
                    Colorway.SequenceEqual(other.Colorway)
                ) &&
                (
                    Computed == other.Computed ||
                    Computed != null &&
                    Computed.Equals(other.Computed)
                ) && 
                (
                    DataRevision == other.DataRevision ||
                    DataRevision != null &&
                    DataRevision.Equals(other.DataRevision)
                ) && 
                (
                    DragMode == other.DragMode ||
                    DragMode != null &&
                    DragMode.Equals(other.DragMode)
                ) && 
                (
                    EditRevision == other.EditRevision ||
                    EditRevision != null &&
                    EditRevision.Equals(other.EditRevision)
                ) && 
                (
                    Font == other.Font ||
                    Font != null &&
                    Font.Equals(other.Font)
                ) && 
                (
                    Equals(Geo, other.Geo) ||
                    Geo != null && other.Geo != null &&
                    Geo.SequenceEqual(other.Geo)
                ) &&
                (
                    Grid == other.Grid ||
                    Grid != null &&
                    Grid.Equals(other.Grid)
                ) && 
                (
                    Height == other.Height ||
                    Height != null &&
                    Height.Equals(other.Height)
                ) && 
                (
                    HideSources == other.HideSources ||
                    HideSources != null &&
                    HideSources.Equals(other.HideSources)
                ) && 
                (
                    HoverDistance == other.HoverDistance ||
                    HoverDistance != null &&
                    HoverDistance.Equals(other.HoverDistance)
                ) && 
                (
                    HoverLabel == other.HoverLabel ||
                    HoverLabel != null &&
                    HoverLabel.Equals(other.HoverLabel)
                ) && 
                (
                    HoverMode == other.HoverMode ||
                    HoverMode != null &&
                    HoverMode.Equals(other.HoverMode)
                ) && 
                (
                    HoverSubplots == other.HoverSubplots ||
                    HoverSubplots != null &&
                    HoverSubplots.Equals(other.HoverSubplots)
                ) && 
                (
                    Equals(Images, other.Images) ||
                    Images != null && other.Images != null &&
                    Images.SequenceEqual(other.Images)
                ) &&
                (
                    Equals(Legend, other.Legend) ||
                    Legend != null && other.Legend != null &&
                    Legend.SequenceEqual(other.Legend)
                ) &&
                (
                    Equals(Map, other.Map) ||
                    Map != null && other.Map != null &&
                    Map.SequenceEqual(other.Map)
                ) &&
                (
                    Equals(MapBox, other.MapBox) ||
                    MapBox != null && other.MapBox != null &&
                    MapBox.SequenceEqual(other.MapBox)
                ) &&
                (
                    Margin == other.Margin ||
                    Margin != null &&
                    Margin.Equals(other.Margin)
                ) && 
                (
                    Meta == other.Meta ||
                    Meta != null &&
                    Meta.Equals(other.Meta)
                ) && 
                (
                    Equals(MetaArray, other.MetaArray) ||
                    MetaArray != null && other.MetaArray != null &&
                    MetaArray.SequenceEqual(other.MetaArray)
                ) &&
                (
                    MetaSrc == other.MetaSrc ||
                    MetaSrc != null &&
                    MetaSrc.Equals(other.MetaSrc)
                ) && 
                (
                    MinReducedHeight == other.MinReducedHeight ||
                    MinReducedHeight != null &&
                    MinReducedHeight.Equals(other.MinReducedHeight)
                ) && 
                (
                    MinReducedWidth == other.MinReducedWidth ||
                    MinReducedWidth != null &&
                    MinReducedWidth.Equals(other.MinReducedWidth)
                ) && 
                (
                    ModeBar == other.ModeBar ||
                    ModeBar != null &&
                    ModeBar.Equals(other.ModeBar)
                ) && 
                (
                    NewSelection == other.NewSelection ||
                    NewSelection != null &&
                    NewSelection.Equals(other.NewSelection)
                ) && 
                (
                    NewShape == other.NewShape ||
                    NewShape != null &&
                    NewShape.Equals(other.NewShape)
                ) && 
                (
                    PaperBgColor == other.PaperBgColor ||
                    PaperBgColor != null &&
                    PaperBgColor.Equals(other.PaperBgColor)
                ) && 
                (
                    PlotBgColor == other.PlotBgColor ||
                    PlotBgColor != null &&
                    PlotBgColor.Equals(other.PlotBgColor)
                ) && 
                (
                    Equals(Polar, other.Polar) ||
                    Polar != null && other.Polar != null &&
                    Polar.SequenceEqual(other.Polar)
                ) &&
                (
                    Equals(Scene, other.Scene) ||
                    Scene != null && other.Scene != null &&
                    Scene.SequenceEqual(other.Scene)
                ) &&
                (
                    SelectDirection == other.SelectDirection ||
                    SelectDirection != null &&
                    SelectDirection.Equals(other.SelectDirection)
                ) && 
                (
                    SelectionRevision == other.SelectionRevision ||
                    SelectionRevision != null &&
                    SelectionRevision.Equals(other.SelectionRevision)
                ) && 
                (
                    Equals(Selections, other.Selections) ||
                    Selections != null && other.Selections != null &&
                    Selections.SequenceEqual(other.Selections)
                ) &&
                (
                    Separators == other.Separators ||
                    Separators != null &&
                    Separators.Equals(other.Separators)
                ) && 
                (
                    Equals(Shapes, other.Shapes) ||
                    Shapes != null && other.Shapes != null &&
                    Shapes.SequenceEqual(other.Shapes)
                ) &&
                (
                    ShowLegend == other.ShowLegend ||
                    ShowLegend != null &&
                    ShowLegend.Equals(other.ShowLegend)
                ) && 
                (
                    Equals(Sliders, other.Sliders) ||
                    Sliders != null && other.Sliders != null &&
                    Sliders.SequenceEqual(other.Sliders)
                ) &&
                (
                    Equals(Smith, other.Smith) ||
                    Smith != null && other.Smith != null &&
                    Smith.SequenceEqual(other.Smith)
                ) &&
                (
                    SpikeDistance == other.SpikeDistance ||
                    SpikeDistance != null &&
                    SpikeDistance.Equals(other.SpikeDistance)
                ) && 
                (
                    Template == other.Template ||
                    Template != null &&
                    Template.Equals(other.Template)
                ) && 
                (
                    Equals(Ternary, other.Ternary) ||
                    Ternary != null && other.Ternary != null &&
                    Ternary.SequenceEqual(other.Ternary)
                ) &&
                (
                    Title == other.Title ||
                    Title != null &&
                    Title.Equals(other.Title)
                ) && 
                (
                    Transition == other.Transition ||
                    Transition != null &&
                    Transition.Equals(other.Transition)
                ) && 
                (
                    UiRevision == other.UiRevision ||
                    UiRevision != null &&
                    UiRevision.Equals(other.UiRevision)
                ) && 
                (
                    UniformText == other.UniformText ||
                    UniformText != null &&
                    UniformText.Equals(other.UniformText)
                ) && 
                (
                    Equals(UpdateMenus, other.UpdateMenus) ||
                    UpdateMenus != null && other.UpdateMenus != null &&
                    UpdateMenus.SequenceEqual(other.UpdateMenus)
                ) &&
                (
                    Width == other.Width ||
                    Width != null &&
                    Width.Equals(other.Width)
                ) && 
                (
                    Equals(XAxis, other.XAxis) ||
                    XAxis != null && other.XAxis != null &&
                    XAxis.SequenceEqual(other.XAxis)
                ) &&
                (
                    Equals(YAxis, other.YAxis) ||
                    YAxis != null && other.YAxis != null &&
                    YAxis.SequenceEqual(other.YAxis)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (BarCornerRadius != null) hashCode = hashCode * 59 + BarCornerRadius.GetHashCode();
                if (BarGap != null) hashCode = hashCode * 59 + BarGap.GetHashCode();
                if (BarGroupGap != null) hashCode = hashCode * 59 + BarGroupGap.GetHashCode();
                if (BarMode != null) hashCode = hashCode * 59 + BarMode.GetHashCode();
                if (BarNorm != null) hashCode = hashCode * 59 + BarNorm.GetHashCode();
                if (BoxGap != null) hashCode = hashCode * 59 + BoxGap.GetHashCode();
                if (BoxGroupGap != null) hashCode = hashCode * 59 + BoxGroupGap.GetHashCode();
                if (BoxMode != null) hashCode = hashCode * 59 + BoxMode.GetHashCode();
                if (FunnelGap != null) hashCode = hashCode * 59 + FunnelGap.GetHashCode();
                if (FunnelGroupGap != null) hashCode = hashCode * 59 + FunnelGroupGap.GetHashCode();
                if (FunnelMode != null) hashCode = hashCode * 59 + FunnelMode.GetHashCode();
                if (ExtendFunnelAreaColors != null) hashCode = hashCode * 59 + ExtendFunnelAreaColors.GetHashCode();
                if (FunnelAreaColorway != null) hashCode = hashCode * 59 + FunnelAreaColorway.GetHashCode();
                if (HiddenLabels != null) hashCode = hashCode * 59 + HiddenLabels.GetHashCode();
                if (HiddenLabelsSrc != null) hashCode = hashCode * 59 + HiddenLabelsSrc.GetHashCode();
                if (ExtendIcicleColors != null) hashCode = hashCode * 59 + ExtendIcicleColors.GetHashCode();
                if (IcicleColorway != null) hashCode = hashCode * 59 + IcicleColorway.GetHashCode();
                if (ExtendPieColors != null) hashCode = hashCode * 59 + ExtendPieColors.GetHashCode();
                if (PieColorway != null) hashCode = hashCode * 59 + PieColorway.GetHashCode();
                if (ScatterGap != null) hashCode = hashCode * 59 + ScatterGap.GetHashCode();
                if (ScatterMode != null) hashCode = hashCode * 59 + ScatterMode.GetHashCode();
                if (ExtendSunburstColors != null) hashCode = hashCode * 59 + ExtendSunburstColors.GetHashCode();
                if (SunburstColorway != null) hashCode = hashCode * 59 + SunburstColorway.GetHashCode();
                if (ExtendTreeMapColors != null) hashCode = hashCode * 59 + ExtendTreeMapColors.GetHashCode();
                if (TreeMapColorway != null) hashCode = hashCode * 59 + TreeMapColorway.GetHashCode();
                if (ViolinGap != null) hashCode = hashCode * 59 + ViolinGap.GetHashCode();
                if (ViolinGroupGap != null) hashCode = hashCode * 59 + ViolinGroupGap.GetHashCode();
                if (ViolinMode != null) hashCode = hashCode * 59 + ViolinMode.GetHashCode();
                if (WaterfallGap != null) hashCode = hashCode * 59 + WaterfallGap.GetHashCode();
                if (WaterfallGroupGap != null) hashCode = hashCode * 59 + WaterfallGroupGap.GetHashCode();
                if (WaterfallMode != null) hashCode = hashCode * 59 + WaterfallMode.GetHashCode();
                if (ActiveSelection != null) hashCode = hashCode * 59 + ActiveSelection.GetHashCode();
                if (ActiveShape != null) hashCode = hashCode * 59 + ActiveShape.GetHashCode();
                if (Annotations != null) hashCode = hashCode * 59 + Annotations.GetHashCode();
                if (AutoSize != null) hashCode = hashCode * 59 + AutoSize.GetHashCode();
                if (AutoTypeNumbers != null) hashCode = hashCode * 59 + AutoTypeNumbers.GetHashCode();
                if (Calendar != null) hashCode = hashCode * 59 + Calendar.GetHashCode();
                if (ClickMode != null) hashCode = hashCode * 59 + ClickMode.GetHashCode();
                if (ColorAxis != null) hashCode = hashCode * 59 + ColorAxis.GetHashCode();
                if (ColorScale != null) hashCode = hashCode * 59 + ColorScale.GetHashCode();
                if (Colorway != null) hashCode = hashCode * 59 + Colorway.GetHashCode();
                if (Computed != null) hashCode = hashCode * 59 + Computed.GetHashCode();
                if (DataRevision != null) hashCode = hashCode * 59 + DataRevision.GetHashCode();
                if (DragMode != null) hashCode = hashCode * 59 + DragMode.GetHashCode();
                if (EditRevision != null) hashCode = hashCode * 59 + EditRevision.GetHashCode();
                if (Font != null) hashCode = hashCode * 59 + Font.GetHashCode();
                if (Geo != null) hashCode = hashCode * 59 + Geo.GetHashCode();
                if (Grid != null) hashCode = hashCode * 59 + Grid.GetHashCode();
                if (Height != null) hashCode = hashCode * 59 + Height.GetHashCode();
                if (HideSources != null) hashCode = hashCode * 59 + HideSources.GetHashCode();
                if (HoverDistance != null) hashCode = hashCode * 59 + HoverDistance.GetHashCode();
                if (HoverLabel != null) hashCode = hashCode * 59 + HoverLabel.GetHashCode();
                if (HoverMode != null) hashCode = hashCode * 59 + HoverMode.GetHashCode();
                if (HoverSubplots != null) hashCode = hashCode * 59 + HoverSubplots.GetHashCode();
                if (Images != null) hashCode = hashCode * 59 + Images.GetHashCode();
                if (Legend != null) hashCode = hashCode * 59 + Legend.GetHashCode();
                if (Map != null) hashCode = hashCode * 59 + Map.GetHashCode();
                if (MapBox != null) hashCode = hashCode * 59 + MapBox.GetHashCode();
                if (Margin != null) hashCode = hashCode * 59 + Margin.GetHashCode();
                if (Meta != null) hashCode = hashCode * 59 + Meta.GetHashCode();
                if (MetaArray != null) hashCode = hashCode * 59 + MetaArray.GetHashCode();
                if (MetaSrc != null) hashCode = hashCode * 59 + MetaSrc.GetHashCode();
                if (MinReducedHeight != null) hashCode = hashCode * 59 + MinReducedHeight.GetHashCode();
                if (MinReducedWidth != null) hashCode = hashCode * 59 + MinReducedWidth.GetHashCode();
                if (ModeBar != null) hashCode = hashCode * 59 + ModeBar.GetHashCode();
                if (NewSelection != null) hashCode = hashCode * 59 + NewSelection.GetHashCode();
                if (NewShape != null) hashCode = hashCode * 59 + NewShape.GetHashCode();
                if (PaperBgColor != null) hashCode = hashCode * 59 + PaperBgColor.GetHashCode();
                if (PlotBgColor != null) hashCode = hashCode * 59 + PlotBgColor.GetHashCode();
                if (Polar != null) hashCode = hashCode * 59 + Polar.GetHashCode();
                if (Scene != null) hashCode = hashCode * 59 + Scene.GetHashCode();
                if (SelectDirection != null) hashCode = hashCode * 59 + SelectDirection.GetHashCode();
                if (SelectionRevision != null) hashCode = hashCode * 59 + SelectionRevision.GetHashCode();
                if (Selections != null) hashCode = hashCode * 59 + Selections.GetHashCode();
                if (Separators != null) hashCode = hashCode * 59 + Separators.GetHashCode();
                if (Shapes != null) hashCode = hashCode * 59 + Shapes.GetHashCode();
                if (ShowLegend != null) hashCode = hashCode * 59 + ShowLegend.GetHashCode();
                if (Sliders != null) hashCode = hashCode * 59 + Sliders.GetHashCode();
                if (Smith != null) hashCode = hashCode * 59 + Smith.GetHashCode();
                if (SpikeDistance != null) hashCode = hashCode * 59 + SpikeDistance.GetHashCode();
                if (Template != null) hashCode = hashCode * 59 + Template.GetHashCode();
                if (Ternary != null) hashCode = hashCode * 59 + Ternary.GetHashCode();
                if (Title != null) hashCode = hashCode * 59 + Title.GetHashCode();
                if (Transition != null) hashCode = hashCode * 59 + Transition.GetHashCode();
                if (UiRevision != null) hashCode = hashCode * 59 + UiRevision.GetHashCode();
                if (UniformText != null) hashCode = hashCode * 59 + UniformText.GetHashCode();
                if (UpdateMenus != null) hashCode = hashCode * 59 + UpdateMenus.GetHashCode();
                if (Width != null) hashCode = hashCode * 59 + Width.GetHashCode();
                if (XAxis != null) hashCode = hashCode * 59 + XAxis.GetHashCode();
                if (YAxis != null) hashCode = hashCode * 59 + YAxis.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Layout and the right Layout.
        /// </summary>
        /// <param name="left">Left Layout.</param>
        /// <param name="right">Right Layout.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Layout left, Layout right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Layout and the right Layout.
        /// </summary>
        /// <param name="left">Left Layout.</param>
        /// <param name="right">Right Layout.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Layout left, Layout right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Layout</returns>
        public Layout DeepClone()
        {
            return this.Copy();
        }
    }
}