/*
 * THIS FILE WAS GENERATED BY PLOTLY.BLAZOR.GENERATOR
*/

using System;
using System.Diagnostics.CodeAnalysis;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Json.Serialization;

namespace Plotly.Blazor
{
    /// <summary>
    ///     The Frames class.
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCode("Plotly.Blazor.Generator", null)]
    [Serializable]
    public class Frames : IEquatable<Frames>
    {
        /// <summary>
        ///     The name of the frame into which this frame&#39;s properties are merged
        ///     before applying. This is used to unify properties and avoid needing to specify
        ///     the same values for the same properties in multiple frames.
        /// </summary>
        [JsonPropertyName(@"baseframe")]
        public string BaseFrame { get; set;} 

        /// <summary>
        ///     A list of traces this frame modifies. The format is identical to the normal
        ///     trace definition.
        /// </summary>
        [JsonPropertyName(@"data")]
        public ITrace Data { get; set;} 

        /// <summary>
        ///     An identifier that specifies the group to which the frame belongs, used
        ///     by animate to select a subset of frames.
        /// </summary>
        [JsonPropertyName(@"group")]
        public string Group { get; set;} 

        /// <summary>
        ///     Layout properties which this frame modifies. The format is identical to
        ///     the normal layout definition.
        /// </summary>
        [JsonPropertyName(@"layout")]
        public Layout Layout { get; set;} 

        /// <summary>
        ///     A label by which to identify the frame
        /// </summary>
        [JsonPropertyName(@"name")]
        public string Name { get; set;} 

        /// <summary>
        ///     A list of trace indices that identify the respective traces in the data
        ///     attribute
        /// </summary>
        [JsonPropertyName(@"traces")]
        public object Traces { get; set;} 

        /// <inheritdoc />
        public override bool Equals(object obj)
        {
            if (!(obj is Frames other)) return false;

            return ReferenceEquals(this, obj) || Equals(other);
        }

        /// <inheritdoc />
        public bool Equals([AllowNull] Frames other)
        {
            if (other == null) return false;
            if (ReferenceEquals(this, other)) return true;

            return 
                (
                    BaseFrame == other.BaseFrame ||
                    BaseFrame != null &&
                    BaseFrame.Equals(other.BaseFrame)
                ) && 
                (
                    Data == other.Data ||
                    Data != null &&
                    Data.Equals(other.Data)
                ) && 
                (
                    Group == other.Group ||
                    Group != null &&
                    Group.Equals(other.Group)
                ) && 
                (
                    Layout == other.Layout ||
                    Layout != null &&
                    Layout.Equals(other.Layout)
                ) && 
                (
                    Name == other.Name ||
                    Name != null &&
                    Name.Equals(other.Name)
                ) && 
                (
                    Traces == other.Traces ||
                    Traces != null &&
                    Traces.Equals(other.Traces)
                );
        }

        /// <inheritdoc />
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                var hashCode = 41;
                if (BaseFrame != null) hashCode = hashCode * 59 + BaseFrame.GetHashCode();
                if (Data != null) hashCode = hashCode * 59 + Data.GetHashCode();
                if (Group != null) hashCode = hashCode * 59 + Group.GetHashCode();
                if (Layout != null) hashCode = hashCode * 59 + Layout.GetHashCode();
                if (Name != null) hashCode = hashCode * 59 + Name.GetHashCode();
                if (Traces != null) hashCode = hashCode * 59 + Traces.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        ///     Checks for equality of the left Frames and the right Frames.
        /// </summary>
        /// <param name="left">Left Frames.</param>
        /// <param name="right">Right Frames.</param>
        /// <returns>Boolean</returns>
        public static bool operator == (Frames left, Frames right)
        {
            return Equals(left, right);
        }

        /// <summary>
        ///     Checks for inequality of the left Frames and the right Frames.
        /// </summary>
        /// <param name="left">Left Frames.</param>
        /// <param name="right">Right Frames.</param>
        /// <returns>Boolean</returns>
        public static bool operator != (Frames left, Frames right)
        {
            return !Equals(left, right);
        }

        /// <summary>
        ///     Gets a deep copy of this instance.
        /// </summary>
        /// <returns>Frames</returns>
        public Frames DeepClone()
        {
            return this.Copy();
        }
    }
}