{$POINTERMATH ON}
{$MINENUMSIZE 4} (* use 4-byte enums *)
{$WRITEABLECONST ON}

  (*
    * FF_API_* defines may be placed below to indicate public API that will be
    * dropped at a future version bump. The defines themselves are not part of
    * the public API and may change, break or disappear at any time.
    *
    * @note, when bumping the major version it is recommended to manually
    * disable each FF_API_* in its own commit instead of disabling them all
    * at once through the bump. This improves the git bisect-ability of the change.
  *)
const
{$REGION 'libavutil'}
  LIBAVUTIL_VERSION_MAJOR     = 56;
  LIBAVUTIL_VERSION_MAJOR_STR = '56';
  LIBAVUTIL_VERSION_MINOR     = 31;
  LIBAVUTIL_VERSION_MICRO     = 100;
  FFMPEG_VERSION              = '4.2.2';
  LIBAVUTIL_VERSION_INT     = ((LIBAVUTIL_VERSION_MAJOR shl 16) or (LIBAVUTIL_VERSION_MINOR shl 8) or LIBAVUTIL_VERSION_MICRO);

{$IFNDEF FF_API_VAAPI}
{$IF LIBAVUTIL_VERSION_MAJOR < 57}
{$DEFINE FF_API_VAAPI}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_FRAME_QP}
{$IF LIBAVUTIL_VERSION_MAJOR < 57}
{$DEFINE FF_API_FRAME_QP}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_PLUS1_MINUS1}
{$IF LIBAVUTIL_VERSION_MAJOR < 57}
{$DEFINE FF_API_PLUS1_MINUS1}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_ERROR_FRAME}
{$IF LIBAVUTIL_VERSION_MAJOR < 57}
{$DEFINE FF_API_ERROR_FRAME}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_PKT_PTS}
{$IF LIBAVUTIL_VERSION_MAJOR < 57}
{$DEFINE FF_API_PKT_PTS}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_CRYPTO_SIZE_T}
{$IF LIBAVUTIL_VERSION_MAJOR < 57}
{$DEFINE FF_API_CRYPTO_SIZE_T}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_FRAME_GET_SET}
{$IF LIBAVUTIL_VERSION_MAJOR < 57}
{$DEFINE FF_API_FRAME_GET_SET}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_PSEUDOPAL}
{$IF LIBAVUTIL_VERSION_MAJOR < 57}
{$DEFINE FF_API_PSEUDOPAL} // 
{$ENDIF}
{$ENDIF}
{$ENDREGION}
{$REGION 'libswscale'}
  LIBSWSCALE_VERSION_MAJOR     = 5;
  LIBSWSCALE_VERSION_MAJOR_STR = '5';
  LIBSWSCALE_VERSION_MINOR     = 5;
  LIBSWSCALE_VERSION_MICRO     = 100;
{$ENDREGION}
{$REGION 'libavcodec'}
  LIBAVCODEC_VERSION_MAJOR     = 58;
  LIBAVCODEC_VERSION_MAJOR_STR = '58';
  LIBAVCODEC_VERSION_MINOR     = 54;
  LIBAVCODEC_VERSION_MICRO     = 100;

{$IFNDEF  FF_API_LOWRES}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_LOWRES}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_DEBUG_MV}
{$IF LIBAVCODEC_VERSION_MAJOR < 58}
{$DEFINE FF_API_DEBUG_MV}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_AVCTX_TIMEBASE}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_AVCTX_TIMEBASE}     // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_CODED_FRAME}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_CODED_FRAME}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_SIDEDATA_ONLY_PKT}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_SIDEDATA_ONLY_PKT}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_VDPAU_PROFILE}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_VDPAU_PROFILE}    // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_CONVERGENCE_DURATION}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_CONVERGENCE_DURATION}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_AVPICTURE}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_AVPICTURE}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_AVPACKET_OLD_API}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_AVPACKET_OLD_API}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_RTP_CALLBACK}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_RTP_CALLBACK}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_VBV_DELAY}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_VBV_DELAY}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_CODER_TYPE}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_CODER_TYPE}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_STAT_BITS}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_STAT_BITS}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_PRIVATE_OPT}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_PRIVATE_OPT}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_ASS_TIMING}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_ASS_TIMING}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_OLD_BSF}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_OLD_BSF}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_COPY_CONTEXT}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_COPY_CONTEXT}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_GET_CONTEXT_DEFAULTS}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_GET_CONTEXT_DEFAULTS}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_NVENC_OLD_NAME}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_NVENC_OLD_NAME}    // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_STRUCT_VAAPI_CONTEXT}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_STRUCT_VAAPI_CONTEXT}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_MERGE_SD_API}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_MERGE_SD_API}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_TAG_STRING}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_TAG_STRING}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_GETCHROMA}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_GETCHROMA}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_CODEC_GET_SET}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_CODEC_GET_SET}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_USER_VISIBLE_AVHWACCEL}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_USER_VISIBLE_AVHWACCEL}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_LOCKMGR}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_LOCKMGR}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_NEXT}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_NEXT}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_UNSANITIZED_BITRATES}
{$IF LIBAVCODEC_VERSION_MAJOR < 59}
{$DEFINE FF_API_UNSANITIZED_BITRATES}
{$ENDIF}
{$ENDIF}
{$ENDREGION}
{$REGION 'avdevice'}
  LIBAVDEVICE_VERSION_MAJOR     = 58;
  LIBAVDEVICE_VERSION_MAJOR_STR = '58';
  LIBAVDEVICE_VERSION_MINOR     = 8;
  LIBAVDEVICE_VERSION_MICRO     = 100;
{$ENDREGION}
{$REGION 'avformat'}
  LIBAVFORMAT_VERSION_MAJOR     = 58;
  LIBAVFORMAT_VERSION_MAJOR_STR = '58';
  LIBAVFORMAT_VERSION_MINOR     = 29;
  LIBAVFORMAT_VERSION_MICRO     = 100;

{$IFNDEF FF_API_COMPUTE_PKT_FIELDS2}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_COMPUTE_PKT_FIELDS2} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_OLD_OPEN_CALLBACKS}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_OLD_OPEN_CALLBACKS}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_LAVF_AVCTX}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_LAVF_AVCTX}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_HTTP_USER_AGENT}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_HTTP_USER_AGENT} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_HLS_WRAP}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_HLS_WRAP} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_HLS_USE_LOCALTIME}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_HLS_USE_LOCALTIME} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_LAVF_KEEPSIDE_FLAG}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_LAVF_KEEPSIDE_FLAG} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_OLD_ROTATE_API}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_OLD_ROTATE_API} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_FORMAT_GET_SET}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_FORMAT_GET_SET}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_OLD_AVIO_EOF_0}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_OLD_AVIO_EOF_0} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_LAVF_FFSERVER}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_LAVF_FFSERVER}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_FORMAT_FILENAME}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_FORMAT_FILENAME}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_OLD_RTSP_OPTIONS}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_OLD_RTSP_OPTIONS} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_NEXT}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_NEXT}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_DASH_MIN_SEG_DURATION}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_DASH_MIN_SEG_DURATION} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_LAVF_MP4A_LATM}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_LAVF_MP4A_LATM} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_AVIOFORMAT}
{$IF LIBAVFORMAT_VERSION_MAJOR < 59}
{$DEFINE FF_API_AVIOFORMAT}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_R_FRAME_RATE}
  FF_API_R_FRAME_RATE = 1;
{$ENDIF}
{$ENDREGION}
{$REGION 'postproc'}
  LIBPOSTPROC_VERSION_MAJOR     = 55;
  LIBPOSTPROC_VERSION_MAJOR_STR = '55';
  LIBPOSTPROC_VERSION_MINOR     = 5;
  LIBPOSTPROC_VERSION_MICRO     = 100;
{$ENDREGION}
{$REGION 'swresample.h'}
  LIBSWRESAMPLE_VERSION_MAJOR     = 3;
  LIBSWRESAMPLE_VERSION_MAJOR_STR = '3';
  LIBSWRESAMPLE_VERSION_MINOR     = 5;
  LIBSWRESAMPLE_VERSION_MICRO     = 100;

{$IFNDEF FF_API_SWS_VECTOR}
{$IF LIBSWSCALE_VERSION_MAJOR < 6}
{$DEFINE FF_API_SWS_VECTOR}
{$ENDIF}
{$ENDIF}
{$ENDREGION}
{$REGION 'avfilter.h'}
  LIBAVFILTER_VERSION_MAJOR     = 7;
  LIBAVFILTER_VERSION_MAJOR_STR = '7';
  LIBAVFILTER_VERSION_MINOR     = 57;
  LIBAVFILTER_VERSION_MICRO     = 100;

{$IFNDEF FF_API_OLD_FILTER_OPTS_ERROR}
{$IF LIBAVFILTER_VERSION_MAJOR < 8}
{$DEFINE FF_API_OLD_FILTER_OPTS_ERROR} // 
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_LAVR_OPTS}
{$IF LIBAVFILTER_VERSION_MAJOR < 8}
{$DEFINE FF_API_LAVR_OPTS}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_FILTER_GET_SET}
{$IF LIBAVFILTER_VERSION_MAJOR < 8}
{$DEFINE FF_API_FILTER_GET_SET}
{$ENDIF}
{$ENDIF}
{$IFNDEF FF_API_NEXT}
{$IF LIBAVFILTER_VERSION_MAJOR < 8}
{$DEFINE FF_API_NEXT}
{$ENDIF}
{$ENDIF}
{$DEFINE FF_INTERNAL_FIELDS}
{$ENDREGION}
  swscale_dll    = 'swscale-' + LIBSWSCALE_VERSION_MAJOR_STR + '.dll';
  avutil_dll     = 'avutil-' + LIBAVUTIL_VERSION_MAJOR_STR + '.dll';
  avcodec_dll    = 'avcodec-' + LIBAVCODEC_VERSION_MAJOR_STR + '.dll';
  avdevice_dll   = 'avdevice-' + LIBAVDEVICE_VERSION_MAJOR_STR + '.dll';
  avformat_dll   = 'avformat-' + LIBAVFORMAT_VERSION_MAJOR_STR + '.dll';
  postproc_dll   = 'postproc-' + LIBPOSTPROC_VERSION_MAJOR_STR + '.dll';
  swresample_dll = 'swresample-' + LIBSWRESAMPLE_VERSION_MAJOR_STR + '.dll';
  avfilter_dll   = 'avfilter-' + LIBAVFILTER_VERSION_MAJOR_STR + '.dll';
