// wrapvectors.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "vectors.hpp"
// typemap
#include <vector>
// shroud
#include <cstring>
#include <cstdlib>
#include "wrapvectors.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {


// helper char_len_trim
// Returns the length of character string src with length nsrc,
// ignoring any trailing blanks.
static int ShroudCharLenTrim(const char *src, int nsrc) {
    int i;

    for (i = nsrc - 1; i >= 0; i--) {
        if (src[i] != ' ') {
            break;
        }
    }

    return i + 1;
}


// splicer begin C_definitions
// splicer end C_definitions

// ----------------------------------------
// Function:  int vector_sum
// Statement: c_function_native
// ----------------------------------------
// Argument:  const std::vector<int> &arg
// Statement: c_in_vector<native>&_buf
// start VEC_vector_sum
int VEC_vector_sum(int *arg, size_t SHT_arg_size)
{
    // splicer begin function.vector_sum
    const std::vector<int> SHC_arg_cxx(arg, arg + SHT_arg_size);
    int SHC_rv = vector_sum(SHC_arg_cxx);
    return SHC_rv;
    // splicer end function.vector_sum
}
// end VEC_vector_sum

/**
 * \brief Copy vector into Fortran input array
 *
 */
// ----------------------------------------
// Function:  void vector_iota_out
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +intent(out)
// Statement: c_out_vector<native>&_buf_copy
// start VEC_vector_iota_out
void VEC_vector_iota_out(int *arg, size_t *SHT_arg_size)
{
    // splicer begin function.vector_iota_out
    std::vector<int> SHC_arg_cxx;
    vector_iota_out(SHC_arg_cxx);
    size_t SHC_arg_size = *SHT_arg_size < SHC_arg_cxx.size() ?
        *SHT_arg_size : SHC_arg_cxx.size();
    std::memcpy(arg, SHC_arg_cxx.data(),
        SHC_arg_size*sizeof(SHC_arg_cxx[0]));
    *SHT_arg_size = SHC_arg_size;
    // splicer end function.vector_iota_out
}
// end VEC_vector_iota_out

/**
 * \brief Copy vector into Fortran input array
 *
 */
// ----------------------------------------
// Function:  void vector_iota_out
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +intent(out)
// Statement: f_out_vector<native>&_cdesc
// start VEC_vector_iota_out_bufferify
void VEC_vector_iota_out_bufferify(VEC_SHROUD_array *SHT_arg_cdesc)
{
    // splicer begin function.vector_iota_out_bufferify
    std::vector<int> *SHC_arg_cxx = new std::vector<int>;
    vector_iota_out(*SHC_arg_cxx);
    SHT_arg_cdesc->base_addr = SHC_arg_cxx->empty() ? nullptr : &SHC_arg_cxx->front();
    SHT_arg_cdesc->type = SH_TYPE_INT;
    SHT_arg_cdesc->elem_len = sizeof(int);
    SHT_arg_cdesc->size = SHC_arg_cxx->size();
    SHT_arg_cdesc->rank = 1;
    SHT_arg_cdesc->shape[0] = SHT_arg_cdesc->size;
    // splicer end function.vector_iota_out_bufferify
}
// end VEC_vector_iota_out_bufferify

/**
 * \brief Copy vector into Fortran input array
 *
 * Convert subroutine into a function and
 * return the number of items copied into argument
 * by setting fstatements for both C and Fortran.
 */
// ----------------------------------------
// Function:  void vector_iota_out_with_num
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +intent(out)
// Statement: c_out_vector<native>&_buf_copy
// start VEC_vector_iota_out_with_num
long VEC_vector_iota_out_with_num(int *arg, size_t *SHT_arg_size)
{
    // splicer begin function.vector_iota_out_with_num
    std::vector<int> SHC_arg_cxx;
    vector_iota_out_with_num(SHC_arg_cxx);
    size_t SHC_arg_size = *SHT_arg_size < SHC_arg_cxx.size() ?
        *SHT_arg_size : SHC_arg_cxx.size();
    std::memcpy(arg, SHC_arg_cxx.data(),
        SHC_arg_size*sizeof(SHC_arg_cxx[0]));
    *SHT_arg_size = SHC_arg_size;
    return SHC_arg_size;
    // splicer end function.vector_iota_out_with_num
}
// end VEC_vector_iota_out_with_num

/**
 * \brief Copy vector into Fortran input array
 *
 * Convert subroutine into a function and
 * return the number of items copied into argument
 * by setting fstatements for both C and Fortran.
 */
// ----------------------------------------
// Function:  void vector_iota_out_with_num
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +intent(out)
// Statement: f_out_vector<native>&_cdesc
// start VEC_vector_iota_out_with_num_bufferify
long VEC_vector_iota_out_with_num_bufferify(
    VEC_SHROUD_array *SHT_arg_cdesc)
{
    // splicer begin function.vector_iota_out_with_num_bufferify
    std::vector<int> *SHC_arg_cxx = new std::vector<int>;
    vector_iota_out_with_num(*SHC_arg_cxx);
    SHT_arg_cdesc->base_addr = SHC_arg_cxx->empty() ? nullptr : &SHC_arg_cxx->front();
    SHT_arg_cdesc->type = SH_TYPE_INT;
    SHT_arg_cdesc->elem_len = sizeof(int);
    SHT_arg_cdesc->size = SHC_arg_cxx->size();
    SHT_arg_cdesc->rank = 1;
    SHT_arg_cdesc->shape[0] = SHT_arg_cdesc->size;
    return SHT_arg_cdesc->size;
    // splicer end function.vector_iota_out_with_num_bufferify
}
// end VEC_vector_iota_out_with_num_bufferify

/**
 * \brief Copy vector into Fortran input array
 *
 * Convert subroutine into a function.
 * Return the number of items copied into argument
 * by setting fstatements for the Fortran wrapper only.
 */
// ----------------------------------------
// Function:  void vector_iota_out_with_num2
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +intent(out)
// Statement: c_out_vector<native>&_buf_copy
// start VEC_vector_iota_out_with_num2
void VEC_vector_iota_out_with_num2(int *arg, size_t *SHT_arg_size)
{
    // splicer begin function.vector_iota_out_with_num2
    std::vector<int> SHC_arg_cxx;
    vector_iota_out_with_num2(SHC_arg_cxx);
    size_t SHC_arg_size = *SHT_arg_size < SHC_arg_cxx.size() ?
        *SHT_arg_size : SHC_arg_cxx.size();
    std::memcpy(arg, SHC_arg_cxx.data(),
        SHC_arg_size*sizeof(SHC_arg_cxx[0]));
    *SHT_arg_size = SHC_arg_size;
    // splicer end function.vector_iota_out_with_num2
}
// end VEC_vector_iota_out_with_num2

/**
 * \brief Copy vector into Fortran input array
 *
 * Convert subroutine into a function.
 * Return the number of items copied into argument
 * by setting fstatements for the Fortran wrapper only.
 */
// ----------------------------------------
// Function:  void vector_iota_out_with_num2
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +intent(out)
// Statement: f_out_vector<native>&_cdesc
// start VEC_vector_iota_out_with_num2_bufferify
void VEC_vector_iota_out_with_num2_bufferify(
    VEC_SHROUD_array *SHT_arg_cdesc)
{
    // splicer begin function.vector_iota_out_with_num2_bufferify
    std::vector<int> *SHC_arg_cxx = new std::vector<int>;
    vector_iota_out_with_num2(*SHC_arg_cxx);
    SHT_arg_cdesc->base_addr = SHC_arg_cxx->empty() ? nullptr : &SHC_arg_cxx->front();
    SHT_arg_cdesc->type = SH_TYPE_INT;
    SHT_arg_cdesc->elem_len = sizeof(int);
    SHT_arg_cdesc->size = SHC_arg_cxx->size();
    SHT_arg_cdesc->rank = 1;
    SHT_arg_cdesc->shape[0] = SHT_arg_cdesc->size;
    // splicer end function.vector_iota_out_with_num2_bufferify
}
// end VEC_vector_iota_out_with_num2_bufferify

/**
 * \brief Copy vector into Fortran allocatable array
 *
 */
// ----------------------------------------
// Function:  void vector_iota_out_alloc
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +deref(allocatable)+intent(out)
// Statement: c_out_vector<native>&_buf_malloc
// start VEC_vector_iota_out_alloc
void VEC_vector_iota_out_alloc(int **arg, size_t *SHT_arg_size)
{
    // splicer begin function.vector_iota_out_alloc
    std::vector<int> SHC_arg_cxx;
    vector_iota_out_alloc(SHC_arg_cxx);
    size_t SHC_arg_bytes = SHC_arg_cxx.size()*sizeof(SHC_arg_cxx[0]);
    *arg = static_cast<int *>(std::malloc(SHC_arg_bytes));
    std::memcpy(*arg, SHC_arg_cxx.data(), SHC_arg_bytes);
    *SHT_arg_size = SHC_arg_cxx.size();
    // splicer end function.vector_iota_out_alloc
}
// end VEC_vector_iota_out_alloc

/**
 * \brief Copy vector into Fortran allocatable array
 *
 */
// ----------------------------------------
// Function:  void vector_iota_out_alloc
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +deref(allocatable)+intent(out)
// Statement: f_out_vector<native>&_cdesc_allocatable
// start VEC_vector_iota_out_alloc_bufferify
void VEC_vector_iota_out_alloc_bufferify(
    VEC_SHROUD_array *SHT_arg_cdesc)
{
    // splicer begin function.vector_iota_out_alloc_bufferify
    std::vector<int> *SHC_arg_cxx = new std::vector<int>;
    vector_iota_out_alloc(*SHC_arg_cxx);
    SHT_arg_cdesc->base_addr = SHC_arg_cxx->empty() ? nullptr : &SHC_arg_cxx->front();
    SHT_arg_cdesc->type = SH_TYPE_INT;
    SHT_arg_cdesc->elem_len = sizeof(int);
    SHT_arg_cdesc->size = SHC_arg_cxx->size();
    SHT_arg_cdesc->rank = 1;
    SHT_arg_cdesc->shape[0] = SHT_arg_cdesc->size;
    // splicer end function.vector_iota_out_alloc_bufferify
}
// end VEC_vector_iota_out_alloc_bufferify

/**
 * \brief Copy vector into Fortran allocatable array
 *
 */
// ----------------------------------------
// Function:  void vector_iota_inout_alloc
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +deref(allocatable)+intent(inout)
// Statement: c_inout_vector<native>&_buf_malloc
// start VEC_vector_iota_inout_alloc
void VEC_vector_iota_inout_alloc(int **arg, size_t *SHT_arg_size)
{
    // splicer begin function.vector_iota_inout_alloc
    std::vector<int> SHC_arg_cxx(*arg, *arg + *SHT_arg_size);
    vector_iota_inout_alloc(SHC_arg_cxx);
    size_t SHC_arg_bytes = SHC_arg_cxx.size()*sizeof(SHC_arg_cxx[0]);
    *arg = static_cast<int *>(std::realloc(*arg, SHC_arg_bytes));
    std::memcpy(*arg, SHC_arg_cxx.data(), SHC_arg_bytes);
    *SHT_arg_size = SHC_arg_cxx.size();
    // splicer end function.vector_iota_inout_alloc
}
// end VEC_vector_iota_inout_alloc

/**
 * \brief Copy vector into Fortran allocatable array
 *
 */
// ----------------------------------------
// Function:  void vector_iota_inout_alloc
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +deref(allocatable)+intent(inout)
// Statement: f_inout_vector<native>&_cdesc_allocatable
// start VEC_vector_iota_inout_alloc_bufferify
void VEC_vector_iota_inout_alloc_bufferify(int *arg,
    size_t SHT_arg_size, VEC_SHROUD_array *SHT_arg_cdesc)
{
    // splicer begin function.vector_iota_inout_alloc_bufferify
    std::vector<int> *SHC_arg_cxx = new std::vector<int>(
        arg, arg + SHT_arg_size);
    vector_iota_inout_alloc(*SHC_arg_cxx);
    SHT_arg_cdesc->base_addr = SHC_arg_cxx->empty() ? nullptr : &SHC_arg_cxx->front();
    SHT_arg_cdesc->type = SH_TYPE_INT;
    SHT_arg_cdesc->elem_len = sizeof(int);
    SHT_arg_cdesc->size = SHC_arg_cxx->size();
    SHT_arg_cdesc->rank = 1;
    SHT_arg_cdesc->shape[0] = SHT_arg_cdesc->size;
    // splicer end function.vector_iota_inout_alloc_bufferify
}
// end VEC_vector_iota_inout_alloc_bufferify

#if 0
! Not Implemented
// ----------------------------------------
// Function:  void vector_increment
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg
// Statement: c_inout_vector<native>&_buf_copy
void VEC_vector_increment(int *arg, size_t *SHT_arg_size)
{
    // splicer begin function.vector_increment
    std::vector<int> SHC_arg_cxx(arg, arg + *SHT_arg_size);
    vector_increment(SHC_arg_cxx);
    *SHT_arg_size = SHC_arg_cxx->size()
    // splicer end function.vector_increment
}
#endif

// ----------------------------------------
// Function:  void vector_increment
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg
// Statement: f_inout_vector<native>&_cdesc
void VEC_vector_increment_bufferify(int *arg, size_t SHT_arg_size,
    VEC_SHROUD_array *SHT_arg_cdesc)
{
    // splicer begin function.vector_increment_bufferify
    std::vector<int> *SHC_arg_cxx = new std::vector<int>(
        arg, arg + SHT_arg_size);
    vector_increment(*SHC_arg_cxx);
    SHT_arg_cdesc->base_addr = SHC_arg_cxx->empty() ? nullptr : &SHC_arg_cxx->front();
    SHT_arg_cdesc->type = SH_TYPE_INT;
    SHT_arg_cdesc->elem_len = sizeof(int);
    SHT_arg_cdesc->size = SHC_arg_cxx->size();
    SHT_arg_cdesc->rank = 1;
    SHT_arg_cdesc->shape[0] = SHT_arg_cdesc->size;
    // splicer end function.vector_increment_bufferify
}

/**
 * \brief Copy vector into Fortran input array
 *
 */
// ----------------------------------------
// Function:  void vector_iota_out_d
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::vector<double> &arg +intent(out)
// Statement: c_out_vector<native>&_buf_copy
void VEC_vector_iota_out_d(double *arg, size_t *SHT_arg_size)
{
    // splicer begin function.vector_iota_out_d
    std::vector<double> SHC_arg_cxx;
    vector_iota_out_d(SHC_arg_cxx);
    size_t SHC_arg_size = *SHT_arg_size < SHC_arg_cxx.size() ?
        *SHT_arg_size : SHC_arg_cxx.size();
    std::memcpy(arg, SHC_arg_cxx.data(),
        SHC_arg_size*sizeof(SHC_arg_cxx[0]));
    *SHT_arg_size = SHC_arg_size;
    // splicer end function.vector_iota_out_d
}

/**
 * \brief Copy vector into Fortran input array
 *
 */
// ----------------------------------------
// Function:  void vector_iota_out_d
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::vector<double> &arg +intent(out)
// Statement: f_out_vector<native>&_cdesc
void VEC_vector_iota_out_d_bufferify(VEC_SHROUD_array *SHT_arg_cdesc)
{
    // splicer begin function.vector_iota_out_d_bufferify
    std::vector<double> *SHC_arg_cxx = new std::vector<double>;
    vector_iota_out_d(*SHC_arg_cxx);
    SHT_arg_cdesc->base_addr = SHC_arg_cxx->empty() ? nullptr : &SHC_arg_cxx->front();
    SHT_arg_cdesc->type = SH_TYPE_DOUBLE;
    SHT_arg_cdesc->elem_len = sizeof(double);
    SHT_arg_cdesc->size = SHC_arg_cxx->size();
    SHT_arg_cdesc->rank = 1;
    SHT_arg_cdesc->shape[0] = SHT_arg_cdesc->size;
    // splicer end function.vector_iota_out_d_bufferify
}

/**
 * \brief Fortran 2-d array to vector<const double *>
 *
 */
// ----------------------------------------
// Function:  int vector_of_pointers
// Statement: c_function_native
// ----------------------------------------
// Argument:  std::vector<const double *> &arg1 +intent(in)
// Statement: c_in_vector<native*>&_buf
// ----------------------------------------
// Argument:  int num
// Statement: c_in_native
int VEC_vector_of_pointers(double *arg1, size_t SHT_arg1_len,
    size_t SHT_arg1_size, int num)
{
    // splicer begin function.vector_of_pointers
    std::vector<const double *> SHC_arg1_cxx;
    for (size_t i=0; i < SHT_arg1_size; ++i) {
        SHC_arg1_cxx.push_back(arg1 + (SHT_arg1_len*i));
    }
    int SHC_rv = vector_of_pointers(SHC_arg1_cxx, num);
    return SHC_rv;
    // splicer end function.vector_of_pointers
}

/**
 * \brief count number of underscore in vector of strings
 *
 */
// ----------------------------------------
// Function:  int vector_string_count
// Statement: c_function_native
// ----------------------------------------
// Argument:  const std::vector<std::string> &arg
// Statement: c_in_vector<string>&_buf
int VEC_vector_string_count(const char *arg, size_t SHT_arg_size,
    int SHT_arg_len)
{
    // splicer begin function.vector_string_count
    std::vector<std::string> SHC_arg_cxx;
    {
        const char * SHC_arg_s = arg;
        std::vector<std::string>::size_type
            SHC_arg_i = 0,
            SHC_arg_n = SHT_arg_size;
        for(; SHC_arg_i < SHC_arg_n; SHC_arg_i++) {
            SHC_arg_cxx.push_back(std::string(SHC_arg_s,
                ShroudCharLenTrim(SHC_arg_s, SHT_arg_len)));
            SHC_arg_s += SHT_arg_len;
        }
    }
    int SHC_rv = vector_string_count(SHC_arg_cxx);
    return SHC_rv;
    // splicer end function.vector_string_count
}

#if 0
! Not Implemented
/**
 * \brief Fill in arg with some animal names
 *
 * The C++ function returns void. But the C and Fortran wrappers return
 * an int with the number of items added to arg.
 */
// ----------------------------------------
// Function:  void vector_string_fill
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::vector<std::string> &arg +intent(out)
// Statement: c_out_vector<string>&_buf_copy
void VEC_vector_string_fill(char *arg)
{
    // splicer begin function.vector_string_fill
    vector_string_fill(*arg);
    // splicer end function.vector_string_fill
}
#endif

/**
 * \brief Fill in arg with some animal names
 *
 * The C++ function returns void. But the C and Fortran wrappers return
 * an int with the number of items added to arg.
 */
// ----------------------------------------
// Function:  void vector_string_fill
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::vector<std::string> &arg +intent(out)
// Statement: f_out_vector<string>&_cdesc
void VEC_vector_string_fill_bufferify(VEC_SHROUD_array *SHT_arg_cdesc)
{
    // splicer begin function.vector_string_fill_bufferify
    std::vector<std::string> arg;
    vector_string_fill(arg);
    VEC_ShroudVectorStringOut(SHT_arg_cdesc, arg);
    // splicer end function.vector_string_fill_bufferify
}

#if 0
! Not Implemented
// ----------------------------------------
// Function:  void vector_string_fill_allocatable
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::vector<std::string> &arg +deref(allocatable)+intent(out)
// Statement: c_out_vector<string>&_buf_copy
void VEC_vector_string_fill_allocatable(char *arg)
{
    // splicer begin function.vector_string_fill_allocatable
    vector_string_fill_allocatable(*arg);
    // splicer end function.vector_string_fill_allocatable
}
#endif

// ----------------------------------------
// Function:  void vector_string_fill_allocatable
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::vector<std::string> &arg +deref(allocatable)+intent(out)
// Statement: f_out_vector<string>&_cdesc_allocatable
void VEC_vector_string_fill_allocatable_bufferify(
    VEC_SHROUD_array *SHT_arg_cdesc,
    VEC_SHROUD_capsule_data *SHT_arg_capsule)
{
    // splicer begin function.vector_string_fill_allocatable_bufferify
    std::vector<std::string> *SHC_arg_cxx = new std::vector<std::string>;
    vector_string_fill_allocatable(*SHC_arg_cxx);
    if (0 > 0) {
        SHT_arg_cdesc->elem_len = 0;
    } else {
        SHT_arg_cdesc->elem_len = VEC_ShroudVectorStringOutSize(*SHC_arg_cxx);
    }
    SHT_arg_cdesc->size      = SHC_arg_cxx->size();
    // XXX - Use code from c_mixin_native_capsule_fill
    SHT_arg_capsule->addr  = SHC_arg_cxx;
    SHT_arg_capsule->idtor = 0;
    // splicer end function.vector_string_fill_allocatable_bufferify
}

#if 0
! Not Implemented
// ----------------------------------------
// Function:  void vector_string_fill_allocatable_len
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::vector<std::string> &arg +deref(allocatable)+intent(out)+len(20)
// Statement: c_out_vector<string>&_buf_copy
void VEC_vector_string_fill_allocatable_len(char *arg)
{
    // splicer begin function.vector_string_fill_allocatable_len
    vector_string_fill_allocatable_len(*arg);
    // splicer end function.vector_string_fill_allocatable_len
}
#endif

// ----------------------------------------
// Function:  void vector_string_fill_allocatable_len
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::vector<std::string> &arg +deref(allocatable)+intent(out)+len(20)
// Statement: f_out_vector<string>&_cdesc_allocatable
void VEC_vector_string_fill_allocatable_len_bufferify(
    VEC_SHROUD_array *SHT_arg_cdesc,
    VEC_SHROUD_capsule_data *SHT_arg_capsule)
{
    // splicer begin function.vector_string_fill_allocatable_len_bufferify
    std::vector<std::string> *SHC_arg_cxx = new std::vector<std::string>;
    vector_string_fill_allocatable_len(*SHC_arg_cxx);
    if (20 > 0) {
        SHT_arg_cdesc->elem_len = 20;
    } else {
        SHT_arg_cdesc->elem_len = VEC_ShroudVectorStringOutSize(*SHC_arg_cxx);
    }
    SHT_arg_cdesc->size      = SHC_arg_cxx->size();
    // XXX - Use code from c_mixin_native_capsule_fill
    SHT_arg_capsule->addr  = SHC_arg_cxx;
    SHT_arg_capsule->idtor = 0;
    // splicer end function.vector_string_fill_allocatable_len_bufferify
}

/**
 * Implement iota function.
 * Return a vector as an ALLOCATABLE array.
 * Copy results into the new array.
 */
// ----------------------------------------
// Function:  std::vector<int> ReturnVectorAlloc
// Statement: c_function_vector<native>_malloc
// ----------------------------------------
// Argument:  int n
// Statement: c_in_native
int * VEC_ReturnVectorAlloc(int n, size_t *SHT_rv_size)
{
    // splicer begin function.ReturnVectorAlloc
    std::vector<int> SHC_rv_cxx;
    SHC_rv_cxx = ReturnVectorAlloc(n);
    size_t SHC_rv_bytes = SHC_rv_cxx.size()*sizeof(SHC_rv_cxx[0]);
    int *SHC_rv = static_cast<int *>(std::malloc(SHC_rv_bytes));
    std::memcpy(SHC_rv, SHC_rv_cxx.data(), SHC_rv_bytes);
    *SHT_rv_size = SHC_rv_cxx.size();
    return SHC_rv;
    // splicer end function.ReturnVectorAlloc
}

/**
 * Implement iota function.
 * Return a vector as an ALLOCATABLE array.
 * Copy results into the new array.
 */
// ----------------------------------------
// Function:  std::vector<int> ReturnVectorAlloc
// Statement: f_function_vector<native>_cdesc_allocatable
// ----------------------------------------
// Argument:  int n
// Statement: f_in_native
void VEC_ReturnVectorAlloc_bufferify(int n,
    VEC_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.ReturnVectorAlloc_bufferify
    std::vector<int> *SHC_rv_cxx = new std::vector<int>;
    *SHC_rv_cxx = ReturnVectorAlloc(n);
    SHT_rv_cdesc->base_addr = SHC_rv_cxx->empty() ? nullptr : &SHC_rv_cxx->front();
    SHT_rv_cdesc->type = SH_TYPE_INT;
    SHT_rv_cdesc->elem_len = sizeof(int);
    SHT_rv_cdesc->size = SHC_rv_cxx->size();
    SHT_rv_cdesc->rank = 1;
    SHT_rv_cdesc->shape[0] = SHT_rv_cdesc->size;
    // splicer end function.ReturnVectorAlloc_bufferify
}

// ----------------------------------------
// Function:  int returnDim2
// Statement: c_function_native
// ----------------------------------------
// Argument:  int *arg +intent(in)+rank(2)
// Statement: c_in_native*
// ----------------------------------------
// Argument:  int len +implied(size(arg,2))
// Statement: c_in_native
int VEC_returnDim2(int *arg, int len)
{
    // splicer begin function.returnDim2
    int SHC_rv = returnDim2(arg, len);
    return SHC_rv;
    // splicer end function.returnDim2
}

}  // extern "C"
