! wrapfvectors.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfvectors.f
!! \brief Shroud generated wrapper for vectors library
!<
! splicer begin file_top
! splicer end file_top
module vectors_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! start helper array_context
    ! helper array_context
    type, bind(C) :: VEC_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type VEC_SHROUD_array
    ! end helper array_context

    ! start helper capsule_data_helper
    ! helper capsule_data_helper
    type, bind(C) :: VEC_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type VEC_SHROUD_capsule_data
    ! end helper capsule_data_helper

    ! ----------------------------------------
    ! Function:  int vector_sum
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const std::vector<int> &arg
    ! Statement: f_in_vector<native>&_buf
    ! start c_vector_sum
    interface
        function c_vector_sum(arg, SHT_arg_size) &
                result(SHT_rv) &
                bind(C, name="VEC_vector_sum")
            use iso_c_binding, only : C_INT, C_SIZE_T
            implicit none
            integer(C_INT), intent(IN) :: arg(*)
            integer(C_SIZE_T), intent(IN), value :: SHT_arg_size
            integer(C_INT) :: SHT_rv
        end function c_vector_sum
    end interface
    ! end c_vector_sum

    ! ----------------------------------------
    ! Function:  void vector_iota_out
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +intent(out)
    ! Statement: c_out_vector<native>&_buf_copy
    ! start c_vector_iota_out
    interface
        subroutine c_vector_iota_out(arg, SHT_arg_size) &
                bind(C, name="VEC_vector_iota_out")
            use iso_c_binding, only : C_INT, C_SIZE_T
            implicit none
            integer(C_INT), intent(OUT) :: arg(*)
            integer(C_SIZE_T), intent(OUT) :: SHT_arg_size
        end subroutine c_vector_iota_out
    end interface
    ! end c_vector_iota_out

    ! ----------------------------------------
    ! Function:  void vector_iota_out
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +intent(out)
    ! Statement: f_out_vector<native>&_cdesc
    ! start c_vector_iota_out_bufferify
    interface
        subroutine c_vector_iota_out_bufferify(SHT_arg_cdesc) &
                bind(C, name="VEC_vector_iota_out_bufferify")
            import :: VEC_SHROUD_array
            implicit none
            type(VEC_SHROUD_array), intent(OUT) :: SHT_arg_cdesc
        end subroutine c_vector_iota_out_bufferify
    end interface
    ! end c_vector_iota_out_bufferify

    ! ----------------------------------------
    ! Function:  void vector_iota_out_with_num
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +intent(out)
    ! Statement: c_out_vector<native>&_buf_copy
    ! start c_vector_iota_out_with_num
    interface
        function c_vector_iota_out_with_num(arg, SHT_arg_size) &
                result(num) &
                bind(C, name="VEC_vector_iota_out_with_num")
            use iso_c_binding, only : C_INT, C_LONG, C_SIZE_T
            implicit none
            integer(C_INT), intent(OUT) :: arg(*)
            integer(C_SIZE_T), intent(OUT) :: SHT_arg_size
            integer(C_LONG) :: num
        end function c_vector_iota_out_with_num
    end interface
    ! end c_vector_iota_out_with_num

    ! ----------------------------------------
    ! Function:  void vector_iota_out_with_num
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +intent(out)
    ! Statement: f_out_vector<native>&_cdesc
    ! start c_vector_iota_out_with_num_bufferify
    interface
        function c_vector_iota_out_with_num_bufferify(SHT_arg_cdesc) &
                result(num) &
                bind(C, name="VEC_vector_iota_out_with_num_bufferify")
            use iso_c_binding, only : C_LONG
            import :: VEC_SHROUD_array
            implicit none
            type(VEC_SHROUD_array), intent(OUT) :: SHT_arg_cdesc
            integer(C_LONG) :: num
        end function c_vector_iota_out_with_num_bufferify
    end interface
    ! end c_vector_iota_out_with_num_bufferify

    ! ----------------------------------------
    ! Function:  void vector_iota_out_with_num2
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +intent(out)
    ! Statement: c_out_vector<native>&_buf_copy
    ! start c_vector_iota_out_with_num2
    interface
        subroutine c_vector_iota_out_with_num2(arg, SHT_arg_size) &
                bind(C, name="VEC_vector_iota_out_with_num2")
            use iso_c_binding, only : C_INT, C_SIZE_T
            implicit none
            integer(C_INT), intent(OUT) :: arg(*)
            integer(C_SIZE_T), intent(OUT) :: SHT_arg_size
        end subroutine c_vector_iota_out_with_num2
    end interface
    ! end c_vector_iota_out_with_num2

    ! ----------------------------------------
    ! Function:  void vector_iota_out_with_num2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +intent(out)
    ! Statement: f_out_vector<native>&_cdesc
    ! start c_vector_iota_out_with_num2_bufferify
    interface
        subroutine c_vector_iota_out_with_num2_bufferify(SHT_arg_cdesc) &
                bind(C, name="VEC_vector_iota_out_with_num2_bufferify")
            import :: VEC_SHROUD_array
            implicit none
            type(VEC_SHROUD_array), intent(OUT) :: SHT_arg_cdesc
        end subroutine c_vector_iota_out_with_num2_bufferify
    end interface
    ! end c_vector_iota_out_with_num2_bufferify

    ! ----------------------------------------
    ! Function:  void vector_iota_out_alloc
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +deref(allocatable)+intent(out)
    ! Statement: c_out_vector<native>&_buf_malloc
    ! start c_vector_iota_out_alloc
    interface
        subroutine c_vector_iota_out_alloc(arg, SHT_arg_size) &
                bind(C, name="VEC_vector_iota_out_alloc")
            use iso_c_binding, only : C_PTR, C_SIZE_T
            implicit none
            type(C_PTR), intent(OUT) :: arg
            integer(C_SIZE_T), intent(OUT) :: SHT_arg_size
        end subroutine c_vector_iota_out_alloc
    end interface
    ! end c_vector_iota_out_alloc

    ! ----------------------------------------
    ! Function:  void vector_iota_out_alloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +deref(allocatable)+intent(out)
    ! Statement: f_out_vector<native>&_cdesc_allocatable
    ! start c_vector_iota_out_alloc_bufferify
    interface
        subroutine c_vector_iota_out_alloc_bufferify(SHT_arg_cdesc) &
                bind(C, name="VEC_vector_iota_out_alloc_bufferify")
            import :: VEC_SHROUD_array
            implicit none
            type(VEC_SHROUD_array), intent(OUT) :: SHT_arg_cdesc
        end subroutine c_vector_iota_out_alloc_bufferify
    end interface
    ! end c_vector_iota_out_alloc_bufferify

    ! ----------------------------------------
    ! Function:  void vector_iota_inout_alloc
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +deref(allocatable)+intent(inout)
    ! Statement: c_inout_vector<native>&_buf_malloc
    ! start c_vector_iota_inout_alloc
    interface
        subroutine c_vector_iota_inout_alloc(arg, SHT_arg_size) &
                bind(C, name="VEC_vector_iota_inout_alloc")
            use iso_c_binding, only : C_PTR, C_SIZE_T
            implicit none
            type(C_PTR), intent(INOUT) :: arg
            integer(C_SIZE_T), intent(INOUT) :: SHT_arg_size
        end subroutine c_vector_iota_inout_alloc
    end interface
    ! end c_vector_iota_inout_alloc

    ! ----------------------------------------
    ! Function:  void vector_iota_inout_alloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +deref(allocatable)+intent(inout)
    ! Statement: f_inout_vector<native>&_cdesc_allocatable
    ! start c_vector_iota_inout_alloc_bufferify
    interface
        subroutine c_vector_iota_inout_alloc_bufferify(arg, &
                SHT_arg_size, SHT_arg_cdesc) &
                bind(C, name="VEC_vector_iota_inout_alloc_bufferify")
            use iso_c_binding, only : C_INT, C_SIZE_T
            import :: VEC_SHROUD_array
            implicit none
            integer(C_INT), intent(IN) :: arg(*)
            integer(C_SIZE_T), intent(IN), value :: SHT_arg_size
            type(VEC_SHROUD_array), intent(OUT) :: SHT_arg_cdesc
        end subroutine c_vector_iota_inout_alloc_bufferify
    end interface
    ! end c_vector_iota_inout_alloc_bufferify

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  void vector_increment
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg
    ! Statement: c_inout_vector<native>&_buf_copy
    interface
        subroutine c_vector_increment(arg, SHT_arg_size) &
                bind(C, name="VEC_vector_increment")
            use iso_c_binding, only : C_INT, C_SIZE_T
            implicit none
            integer(C_INT), intent(INOUT) :: arg(*)
            integer(C_SIZE_T), intent(INOUT) :: SHT_arg_size
        end subroutine c_vector_increment
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void vector_increment
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg
    ! Statement: f_inout_vector<native>&_cdesc
    interface
        subroutine c_vector_increment_bufferify(arg, SHT_arg_size, &
                SHT_arg_cdesc) &
                bind(C, name="VEC_vector_increment_bufferify")
            use iso_c_binding, only : C_INT, C_SIZE_T
            import :: VEC_SHROUD_array
            implicit none
            integer(C_INT), intent(IN) :: arg(*)
            integer(C_SIZE_T), intent(IN), value :: SHT_arg_size
            type(VEC_SHROUD_array), intent(OUT) :: SHT_arg_cdesc
        end subroutine c_vector_increment_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void vector_iota_out_d
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<double> &arg +intent(out)
    ! Statement: c_out_vector<native>&_buf_copy
    interface
        subroutine c_vector_iota_out_d(arg, SHT_arg_size) &
                bind(C, name="VEC_vector_iota_out_d")
            use iso_c_binding, only : C_DOUBLE, C_SIZE_T
            implicit none
            real(C_DOUBLE), intent(OUT) :: arg(*)
            integer(C_SIZE_T), intent(OUT) :: SHT_arg_size
        end subroutine c_vector_iota_out_d
    end interface

    ! ----------------------------------------
    ! Function:  void vector_iota_out_d
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<double> &arg +intent(out)
    ! Statement: f_out_vector<native>&_cdesc
    interface
        subroutine c_vector_iota_out_d_bufferify(SHT_arg_cdesc) &
                bind(C, name="VEC_vector_iota_out_d_bufferify")
            import :: VEC_SHROUD_array
            implicit none
            type(VEC_SHROUD_array), intent(OUT) :: SHT_arg_cdesc
        end subroutine c_vector_iota_out_d_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  int vector_of_pointers
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  std::vector<const double *> &arg1 +intent(in)
    ! Statement: f_in_vector<native*>&_buf
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    interface
        function c_vector_of_pointers(arg1, SHT_arg1_len, SHT_arg1_size, &
                num) &
                result(SHT_rv) &
                bind(C, name="VEC_vector_of_pointers")
            use iso_c_binding, only : C_DOUBLE, C_INT, C_SIZE_T
            implicit none
            real(C_DOUBLE), intent(IN) :: arg1(*)
            integer(C_SIZE_T), intent(IN), value :: SHT_arg1_len
            integer(C_SIZE_T), intent(IN), value :: SHT_arg1_size
            integer(C_INT), value, intent(IN) :: num
            integer(C_INT) :: SHT_rv
        end function c_vector_of_pointers
    end interface

    ! ----------------------------------------
    ! Function:  int vector_string_count
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const std::vector<std::string> &arg
    ! Statement: f_in_vector<string>&_buf
    interface
        function c_vector_string_count(arg, SHT_arg_size, SHT_arg_len) &
                result(SHT_rv) &
                bind(C, name="VEC_vector_string_count")
            use iso_c_binding, only : C_CHAR, C_INT, C_SIZE_T
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg(*)
            integer(C_SIZE_T), intent(IN), value :: SHT_arg_size
            integer(C_INT), intent(IN), value :: SHT_arg_len
            integer(C_INT) :: SHT_rv
        end function c_vector_string_count
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  void vector_string_fill
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<std::string> &arg +intent(out)
    ! Statement: c_out_vector<string>&_buf_copy
    interface
        subroutine c_vector_string_fill(arg) &
                bind(C, name="VEC_vector_string_fill")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg(*)
        end subroutine c_vector_string_fill
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void vector_string_fill
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<std::string> &arg +intent(out)
    ! Statement: f_out_vector<string>&_cdesc
    interface
        subroutine c_vector_string_fill_bufferify(SHT_arg_cdesc) &
                bind(C, name="VEC_vector_string_fill_bufferify")
            import :: VEC_SHROUD_array
            implicit none
            type(VEC_SHROUD_array), intent(OUT) :: SHT_arg_cdesc
        end subroutine c_vector_string_fill_bufferify
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  void vector_string_fill_allocatable
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<std::string> &arg +deref(allocatable)+intent(out)
    ! Statement: c_out_vector<string>&_buf_copy
    interface
        subroutine c_vector_string_fill_allocatable(arg) &
                bind(C, name="VEC_vector_string_fill_allocatable")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg(*)
        end subroutine c_vector_string_fill_allocatable
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void vector_string_fill_allocatable
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<std::string> &arg +deref(allocatable)+intent(out)
    ! Statement: f_out_vector<string>&_cdesc_allocatable
    interface
        subroutine c_vector_string_fill_allocatable_bufferify( &
                SHT_arg_cdesc, SHT_arg_capsule) &
                bind(C, name="VEC_vector_string_fill_allocatable_bufferify")
            import :: VEC_SHROUD_array, VEC_SHROUD_capsule_data
            implicit none
            type(VEC_SHROUD_array), intent(OUT) :: SHT_arg_cdesc
            type(VEC_SHROUD_capsule_data), intent(OUT) :: SHT_arg_capsule
        end subroutine c_vector_string_fill_allocatable_bufferify
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  void vector_string_fill_allocatable_len
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<std::string> &arg +deref(allocatable)+intent(out)+len(20)
    ! Statement: c_out_vector<string>&_buf_copy
    interface
        subroutine c_vector_string_fill_allocatable_len(arg) &
                bind(C, name="VEC_vector_string_fill_allocatable_len")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg(*)
        end subroutine c_vector_string_fill_allocatable_len
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void vector_string_fill_allocatable_len
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<std::string> &arg +deref(allocatable)+intent(out)+len(20)
    ! Statement: f_out_vector<string>&_cdesc_allocatable
    interface
        subroutine c_vector_string_fill_allocatable_len_bufferify( &
                SHT_arg_cdesc, SHT_arg_capsule) &
                bind(C, name="VEC_vector_string_fill_allocatable_len_bufferify")
            import :: VEC_SHROUD_array, VEC_SHROUD_capsule_data
            implicit none
            type(VEC_SHROUD_array), intent(OUT) :: SHT_arg_cdesc
            type(VEC_SHROUD_capsule_data), intent(OUT) :: SHT_arg_capsule
        end subroutine c_vector_string_fill_allocatable_len_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  std::vector<int> ReturnVectorAlloc
    ! Statement: c_function_vector<native>_malloc
    ! ----------------------------------------
    ! Argument:  int n
    ! Statement: c_in_native
    interface
        function c_return_vector_alloc(n, SHT_rv_size) &
                result(SHT_rv) &
                bind(C, name="VEC_ReturnVectorAlloc")
            use iso_c_binding, only : C_INT, C_PTR, C_SIZE_T
            implicit none
            integer(C_INT), value, intent(IN) :: n
            integer(C_SIZE_T), intent(OUT) :: SHT_rv_size
            type(C_PTR) :: SHT_rv
        end function c_return_vector_alloc
    end interface

    ! ----------------------------------------
    ! Function:  std::vector<int> ReturnVectorAlloc
    ! Statement: f_function_vector<native>_cdesc_allocatable
    ! ----------------------------------------
    ! Argument:  int n
    ! Statement: f_in_native
    interface
        subroutine c_return_vector_alloc_bufferify(n, SHT_rv_cdesc) &
                bind(C, name="VEC_ReturnVectorAlloc_bufferify")
            use iso_c_binding, only : C_INT
            import :: VEC_SHROUD_array
            implicit none
            integer(C_INT), value, intent(IN) :: n
            type(VEC_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_return_vector_alloc_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  int returnDim2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int *arg +intent(in)+rank(2)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int len +implied(size(arg,2))
    ! Statement: f_in_native
    interface
        function c_return_dim2(arg, len) &
                result(SHT_rv) &
                bind(C, name="VEC_returnDim2")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: arg(*)
            integer(C_INT), value, intent(IN) :: len
            integer(C_INT) :: SHT_rv
        end function c_return_dim2
    end interface

    interface
        ! helper capsule_dtor
        ! Delete memory in a capsule.
        subroutine VEC_SHROUD_capsule_dtor(ptr) &
            bind(C, name="VEC_SHROUD_memory_destructor")
            import VEC_SHROUD_capsule_data
            implicit none
            type(VEC_SHROUD_capsule_data), intent(INOUT) :: ptr
        end subroutine VEC_SHROUD_capsule_dtor
    end interface

    interface
        ! helper copy_array
        ! Copy contents of context into c_var.
        subroutine VEC_SHROUD_copy_array(context, c_var, c_var_size) &
            bind(C, name="VEC_ShroudCopyArray")
            use iso_c_binding, only : C_PTR, C_SIZE_T
            import VEC_SHROUD_array
            type(VEC_SHROUD_array), intent(IN) :: context
            type(C_PTR), intent(IN), value :: c_var
            integer(C_SIZE_T), value :: c_var_size
        end subroutine VEC_SHROUD_copy_array
    end interface

    interface
        ! helper vector_string_allocatable
        ! Copy the char* or std::string in context into c_var.
        subroutine VEC_SHROUD_vector_string_allocatable(dest, src) &
             bind(c,name="VEC_ShroudVectorStringAllocatable")
            import VEC_SHROUD_capsule_data, VEC_SHROUD_array
            type(VEC_SHROUD_array), intent(IN) :: dest
            type(VEC_SHROUD_capsule_data), intent(IN) :: src
        end subroutine VEC_SHROUD_vector_string_allocatable
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

    ! ----------------------------------------
    ! Function:  int vector_sum
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const std::vector<int> &arg
    ! Statement: f_in_vector<native>&_buf
    ! start vector_sum
    function vector_sum(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_SIZE_T
        integer(C_INT), intent(IN) :: arg(:)
        integer(C_INT) :: SHT_rv
        ! splicer begin function.vector_sum
        SHT_rv = c_vector_sum(arg, size(arg, kind=C_SIZE_T))
        ! splicer end function.vector_sum
    end function vector_sum
    ! end vector_sum

    ! ----------------------------------------
    ! Function:  void vector_iota_out
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +intent(out)
    ! Statement: f_out_vector<native>&_cdesc
    !>
    !! \brief Copy vector into Fortran input array
    !!
    !<
    ! start vector_iota_out
    subroutine vector_iota_out(arg)
        use iso_c_binding, only : C_INT, C_LOC, C_SIZE_T
        integer(C_INT), intent(OUT), target :: arg(:)
        ! splicer begin function.vector_iota_out
        type(VEC_SHROUD_array) :: SHT_arg_cdesc
        call c_vector_iota_out_bufferify(SHT_arg_cdesc)
        call VEC_SHROUD_copy_array(SHT_arg_cdesc, C_LOC(arg), &
            size(arg,kind=C_SIZE_T))
        ! splicer end function.vector_iota_out
    end subroutine vector_iota_out
    ! end vector_iota_out

    ! ----------------------------------------
    ! Function:  void vector_iota_out_with_num
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +intent(out)
    ! Statement: f_out_vector<native>&_cdesc
    !>
    !! \brief Copy vector into Fortran input array
    !!
    !! Convert subroutine into a function and
    !! return the number of items copied into argument
    !! by setting fstatements for both C and Fortran.
    !<
    ! start vector_iota_out_with_num
    function vector_iota_out_with_num(arg) &
            result(num)
        use iso_c_binding, only : C_INT, C_LOC, C_LONG, C_SIZE_T
        integer(C_INT), intent(OUT), target :: arg(:)
        integer(C_LONG) :: num
        ! splicer begin function.vector_iota_out_with_num
        type(VEC_SHROUD_array) :: SHT_arg_cdesc
        num = c_vector_iota_out_with_num_bufferify(SHT_arg_cdesc)
        call VEC_SHROUD_copy_array(SHT_arg_cdesc, C_LOC(arg), &
            size(arg,kind=C_SIZE_T))
        ! splicer end function.vector_iota_out_with_num
    end function vector_iota_out_with_num
    ! end vector_iota_out_with_num

    ! ----------------------------------------
    ! Function:  void vector_iota_out_with_num2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +intent(out)
    ! Statement: f_out_vector<native>&_cdesc
    !>
    !! \brief Copy vector into Fortran input array
    !!
    !! Convert subroutine into a function.
    !! Return the number of items copied into argument
    !! by setting fstatements for the Fortran wrapper only.
    !<
    ! start vector_iota_out_with_num2
    function vector_iota_out_with_num2(arg) &
            result(num)
        use iso_c_binding, only : C_INT, C_LOC, C_LONG, C_SIZE_T
        integer(C_INT), intent(OUT), target :: arg(:)
        integer(C_LONG) :: num
        ! splicer begin function.vector_iota_out_with_num2
        type(VEC_SHROUD_array) :: SHT_arg_cdesc
        call c_vector_iota_out_with_num2_bufferify(SHT_arg_cdesc)
        call VEC_SHROUD_copy_array(SHT_arg_cdesc, C_LOC(arg), &
            size(arg,kind=C_SIZE_T))
        num = SHT_arg_cdesc%size
        ! splicer end function.vector_iota_out_with_num2
    end function vector_iota_out_with_num2
    ! end vector_iota_out_with_num2

    ! ----------------------------------------
    ! Function:  void vector_iota_out_alloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +deref(allocatable)+intent(out)
    ! Statement: f_out_vector<native>&_cdesc_allocatable
    !>
    !! \brief Copy vector into Fortran allocatable array
    !!
    !<
    ! start vector_iota_out_alloc
    subroutine vector_iota_out_alloc(arg)
        use iso_c_binding, only : C_INT, C_LOC, C_SIZE_T
        integer(C_INT), intent(OUT), allocatable, target :: arg(:)
        ! splicer begin function.vector_iota_out_alloc
        type(VEC_SHROUD_array) :: SHT_arg_cdesc
        call c_vector_iota_out_alloc_bufferify(SHT_arg_cdesc)
        allocate(arg(SHT_arg_cdesc%size))
        call VEC_SHROUD_copy_array(SHT_arg_cdesc, C_LOC(arg), &
            size(arg,kind=C_SIZE_T))
        ! splicer end function.vector_iota_out_alloc
    end subroutine vector_iota_out_alloc
    ! end vector_iota_out_alloc

    ! ----------------------------------------
    ! Function:  void vector_iota_inout_alloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg +deref(allocatable)+intent(inout)
    ! Statement: f_inout_vector<native>&_cdesc_allocatable
    !>
    !! \brief Copy vector into Fortran allocatable array
    !!
    !<
    ! start vector_iota_inout_alloc
    subroutine vector_iota_inout_alloc(arg)
        use iso_c_binding, only : C_INT, C_LOC, C_SIZE_T
        integer(C_INT), intent(INOUT), allocatable, target :: arg(:)
        ! splicer begin function.vector_iota_inout_alloc
        type(VEC_SHROUD_array) :: SHT_arg_cdesc
        call c_vector_iota_inout_alloc_bufferify(arg, &
            size(arg, kind=C_SIZE_T), SHT_arg_cdesc)
        if (allocated(arg)) deallocate(arg)
        allocate(arg(SHT_arg_cdesc%size))
        call VEC_SHROUD_copy_array(SHT_arg_cdesc, C_LOC(arg), &
            size(arg,kind=C_SIZE_T))
        ! splicer end function.vector_iota_inout_alloc
    end subroutine vector_iota_inout_alloc
    ! end vector_iota_inout_alloc

    ! ----------------------------------------
    ! Function:  void vector_increment
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<int> &arg
    ! Statement: f_inout_vector<native>&_cdesc
    subroutine vector_increment(arg)
        use iso_c_binding, only : C_INT, C_LOC, C_SIZE_T
        integer(C_INT), intent(INOUT), target :: arg(:)
        ! splicer begin function.vector_increment
        type(VEC_SHROUD_array) :: SHT_arg_cdesc
        call c_vector_increment_bufferify(arg, size(arg, kind=C_SIZE_T), &
            SHT_arg_cdesc)
        call VEC_SHROUD_copy_array(SHT_arg_cdesc, C_LOC(arg), &
            size(arg,kind=C_SIZE_T))
        ! splicer end function.vector_increment
    end subroutine vector_increment

    ! ----------------------------------------
    ! Function:  void vector_iota_out_d
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<double> &arg +intent(out)
    ! Statement: f_out_vector<native>&_cdesc
    !>
    !! \brief Copy vector into Fortran input array
    !!
    !<
    subroutine vector_iota_out_d(arg)
        use iso_c_binding, only : C_DOUBLE, C_LOC, C_SIZE_T
        real(C_DOUBLE), intent(OUT), target :: arg(:)
        ! splicer begin function.vector_iota_out_d
        type(VEC_SHROUD_array) :: SHT_arg_cdesc
        call c_vector_iota_out_d_bufferify(SHT_arg_cdesc)
        call VEC_SHROUD_copy_array(SHT_arg_cdesc, C_LOC(arg), &
            size(arg,kind=C_SIZE_T))
        ! splicer end function.vector_iota_out_d
    end subroutine vector_iota_out_d

    ! ----------------------------------------
    ! Function:  int vector_of_pointers
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  std::vector<const double *> &arg1 +intent(in)
    ! Statement: f_in_vector<native*>&_buf
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    !>
    !! \brief Fortran 2-d array to vector<const double *>
    !!
    !<
    function vector_of_pointers(arg1, num) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_INT, C_SIZE_T
        real(C_DOUBLE), intent(IN) :: arg1(:,:)
        integer(C_INT), value, intent(IN) :: num
        integer(C_INT) :: SHT_rv
        ! splicer begin function.vector_of_pointers
        SHT_rv = c_vector_of_pointers(arg1, &
            size(arg1, 1, kind=C_SIZE_T), size(arg1, 2, kind=C_SIZE_T), &
            num)
        ! splicer end function.vector_of_pointers
    end function vector_of_pointers

    ! ----------------------------------------
    ! Function:  int vector_string_count
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const std::vector<std::string> &arg
    ! Statement: f_in_vector<string>&_buf
    !>
    !! \brief count number of underscore in vector of strings
    !!
    !<
    function vector_string_count(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_SIZE_T
        character(len=*), intent(IN) :: arg(:)
        integer(C_INT) :: SHT_rv
        ! splicer begin function.vector_string_count
        SHT_rv = c_vector_string_count(arg, size(arg, kind=C_SIZE_T), &
            len(arg, kind=C_INT))
        ! splicer end function.vector_string_count
    end function vector_string_count

    ! ----------------------------------------
    ! Function:  void vector_string_fill
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<std::string> &arg +intent(out)
    ! Statement: f_out_vector<string>&_cdesc
    !>
    !! \brief Fill in arg with some animal names
    !!
    !! The C++ function returns void. But the C and Fortran wrappers return
    !! an int with the number of items added to arg.
    !<
    subroutine vector_string_fill(arg)
        use iso_c_binding, only : C_LOC
        character(len=*), intent(OUT), target :: arg(:)
        ! splicer begin function.vector_string_fill
        type(VEC_SHROUD_array) :: SHT_arg_cdesc
        SHT_arg_cdesc%base_addr = C_LOC(arg)
        SHT_arg_cdesc%type = SH_TYPE_CHAR
        SHT_arg_cdesc%elem_len = len(arg)
        SHT_arg_cdesc%size = size(arg)
        SHT_arg_cdesc%rank = rank(arg)
        SHT_arg_cdesc%shape(1:1) = shape(arg)
        call c_vector_string_fill_bufferify(SHT_arg_cdesc)
        ! splicer end function.vector_string_fill
    end subroutine vector_string_fill

    ! ----------------------------------------
    ! Function:  void vector_string_fill_allocatable
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<std::string> &arg +deref(allocatable)+intent(out)
    ! Statement: f_out_vector<string>&_cdesc_allocatable
    subroutine vector_string_fill_allocatable(arg)
        use iso_c_binding, only : C_LOC
        character(:), intent(OUT), allocatable, target :: arg(:)
        ! splicer begin function.vector_string_fill_allocatable
        type(VEC_SHROUD_array) :: SHT_arg_cdesc
        type(VEC_SHROUD_capsule_data) :: SHT_arg_capsule
        call c_vector_string_fill_allocatable_bufferify(SHT_arg_cdesc, &
            SHT_arg_capsule)
        allocate(character(len=SHT_arg_cdesc%elem_len) :: &
            arg(SHT_arg_cdesc%size))
        SHT_arg_cdesc%base_addr = C_LOC(arg)
        call VEC_SHROUD_vector_string_allocatable(SHT_arg_cdesc, SHT_arg_capsule)
        call VEC_SHROUD_capsule_dtor(SHT_arg_capsule)
        ! splicer end function.vector_string_fill_allocatable
    end subroutine vector_string_fill_allocatable

    ! ----------------------------------------
    ! Function:  void vector_string_fill_allocatable_len
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::vector<std::string> &arg +deref(allocatable)+intent(out)+len(20)
    ! Statement: f_out_vector<string>&_cdesc_allocatable
    subroutine vector_string_fill_allocatable_len(arg)
        use iso_c_binding, only : C_LOC
        character(len=20), intent(OUT), allocatable, target :: arg(:)
        ! splicer begin function.vector_string_fill_allocatable_len
        type(VEC_SHROUD_array) :: SHT_arg_cdesc
        type(VEC_SHROUD_capsule_data) :: SHT_arg_capsule
        call c_vector_string_fill_allocatable_len_bufferify(SHT_arg_cdesc, &
            SHT_arg_capsule)
        allocate(arg(SHT_arg_cdesc%size))
        SHT_arg_cdesc%base_addr = C_LOC(arg)
        call VEC_SHROUD_vector_string_allocatable(SHT_arg_cdesc, SHT_arg_capsule)
        call VEC_SHROUD_capsule_dtor(SHT_arg_capsule)
        ! splicer end function.vector_string_fill_allocatable_len
    end subroutine vector_string_fill_allocatable_len

    ! ----------------------------------------
    ! Function:  std::vector<int> ReturnVectorAlloc
    ! Statement: f_function_vector<native>_cdesc_allocatable
    ! ----------------------------------------
    ! Argument:  int n
    ! Statement: f_in_native
    !>
    !! Implement iota function.
    !! Return a vector as an ALLOCATABLE array.
    !! Copy results into the new array.
    !<
    function return_vector_alloc(n) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_LOC, C_SIZE_T
        integer(C_INT), value, intent(IN) :: n
        integer(C_INT), allocatable, target :: SHT_rv(:)
        ! splicer begin function.return_vector_alloc
        type(VEC_SHROUD_array) :: SHT_rv_cdesc
        call c_return_vector_alloc_bufferify(n, SHT_rv_cdesc)
        allocate(SHT_rv(SHT_rv_cdesc%size))
        call VEC_SHROUD_copy_array(SHT_rv_cdesc, C_LOC(SHT_rv), &
            size(SHT_rv,kind=C_SIZE_T))
        ! splicer end function.return_vector_alloc
    end function return_vector_alloc

    ! ----------------------------------------
    ! Function:  int returnDim2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int *arg +intent(in)+rank(2)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int len +implied(size(arg,2))
    ! Statement: c_default
    function return_dim2(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: arg(:,:)
        integer(C_INT) :: SH_len
        integer(C_INT) :: SHT_rv
        ! splicer begin function.return_dim2
        SH_len = size(arg,2,kind=C_INT)
        SHT_rv = c_return_dim2(arg, SH_len)
        ! splicer end function.return_dim2
    end function return_dim2

    ! splicer begin additional_functions
    ! splicer end additional_functions

end module vectors_mod
