// pyvectorsmodule.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//
#include "pyvectorsmodule.hpp"
#define PY_ARRAY_UNIQUE_SYMBOL SHROUD_VECTORS_ARRAY_API
#define NPY_NO_DEPRECATED_API NPY_1_7_API_VERSION
#include "numpy/arrayobject.h"

// splicer begin include
// splicer end include

#ifdef __cplusplus
#define SHROUD_UNUSED(param)
#else
#define SHROUD_UNUSED(param) param
#endif

#if PY_MAJOR_VERSION >= 3
#define PyInt_AsLong PyLong_AsLong
#define PyInt_FromLong PyLong_FromLong
#define PyInt_FromSize_t PyLong_FromSize_t
#define PyString_FromString PyUnicode_FromString
#define PyString_FromStringAndSize PyUnicode_FromStringAndSize
#endif

// splicer begin C_definition
// splicer end C_definition
PyObject *PY_error_obj;

// splicer begin additional_functions
// splicer end additional_functions

// ----------------------------------------
// Function:  int vector_sum
// Statement: py_function_native
// ----------------------------------------
// Argument:  const std::vector<int> &arg
// Statement: py_in_vector<native>&_numpy
static char PY_vector_sum__doc__[] =
"documentation"
;

static PyObject *
PY_vector_sum(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.vector_sum
    PyObject * SHTPy_arg;
    PyArrayObject * SHPy_arg = nullptr;
    const char *SHT_kwlist[] = {
        "arg",
        nullptr };
    int SHCXX_rv;
    PyObject * SHTPy_rv = nullptr;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "O:vector_sum",
        const_cast<char **>(SHT_kwlist), &SHTPy_arg))
        return nullptr;

    // post_declare
    std::vector<int> SH_arg;
    int * SHData_arg;

    // post_parse
    SHPy_arg = reinterpret_cast<PyArrayObject *>(PyArray_FROM_OTF(
        SHTPy_arg, NPY_INT, NPY_ARRAY_IN_ARRAY));
    if (SHPy_arg == nullptr) {
        PyErr_SetString(PyExc_ValueError,
            "arg must be a 1-D array of int");
        goto fail;
    }

    // pre_call
    SHData_arg = static_cast<int *>(PyArray_DATA(SHPy_arg));
    SH_arg.assign(SHData_arg, SHData_arg+PyArray_SIZE(SHPy_arg));

    SHCXX_rv = vector_sum(SH_arg);

    // post_call
    SHTPy_rv = PyInt_FromLong(SHCXX_rv);

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHPy_arg);
    return nullptr;
// splicer end function.vector_sum
}

// ----------------------------------------
// Function:  void vector_iota_out
// Statement: py_subroutine
// ----------------------------------------
// Argument:  std::vector<int> &arg +intent(out)
// Statement: py_out_vector<native>&_numpy
static char PY_vector_iota_out__doc__[] =
"documentation"
;

/**
 * \brief Copy vector into Fortran input array
 *
 */
static PyObject *
PY_vector_iota_out(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.vector_iota_out
    std::vector<int> *SH_arg = nullptr;
    npy_intp SHD_arg[1];
    PyObject * SHPy_arg = nullptr;
    PyObject *SHC_arg = nullptr;

    // pre_call
    SH_arg = new std::vector<int>;
    if (SH_arg == nullptr) {
        PyErr_NoMemory();
        goto fail;
    }

    vector_iota_out(*SH_arg);

    // post_call
    SHD_arg[0] = SH_arg->size();
    SHPy_arg = PyArray_SimpleNewFromData(1, SHD_arg, NPY_INT,
        SH_arg->data());
    if (SHPy_arg == nullptr) goto fail;
    SHC_arg = PyCapsule_New(SH_arg, "PY_array_dtor", 
        PY_SHROUD_capsule_destructor);
    if (SHC_arg == nullptr) goto fail;
    PyCapsule_SetContext(SHC_arg, PY_SHROUD_fetch_context(1));
    if (PyArray_SetBaseObject(reinterpret_cast<PyArrayObject *>
        (SHPy_arg), SHC_arg) < 0) goto fail;

    return (PyObject *) SHPy_arg;

fail:
    if (SH_arg != nullptr) {
        PY_SHROUD_release_memory(1, SH_arg);
    }
    Py_XDECREF(SHPy_arg);
    Py_XDECREF(SHC_arg);
    return nullptr;
// splicer end function.vector_iota_out
}

// ----------------------------------------
// Function:  void vector_iota_out_d
// Statement: py_subroutine
// ----------------------------------------
// Argument:  std::vector<double> &arg +intent(out)
// Statement: py_out_vector<native>&_numpy
static char PY_vector_iota_out_d__doc__[] =
"documentation"
;

/**
 * \brief Copy vector into Fortran input array
 *
 */
static PyObject *
PY_vector_iota_out_d(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.vector_iota_out_d
    std::vector<double> *SH_arg = nullptr;
    npy_intp SHD_arg[1];
    PyObject * SHPy_arg = nullptr;
    PyObject *SHC_arg = nullptr;

    // pre_call
    SH_arg = new std::vector<double>;
    if (SH_arg == nullptr) {
        PyErr_NoMemory();
        goto fail;
    }

    vector_iota_out_d(*SH_arg);

    // post_call
    SHD_arg[0] = SH_arg->size();
    SHPy_arg = PyArray_SimpleNewFromData(1, SHD_arg, NPY_DOUBLE,
        SH_arg->data());
    if (SHPy_arg == nullptr) goto fail;
    SHC_arg = PyCapsule_New(SH_arg, "PY_array_dtor", 
        PY_SHROUD_capsule_destructor);
    if (SHC_arg == nullptr) goto fail;
    PyCapsule_SetContext(SHC_arg, PY_SHROUD_fetch_context(2));
    if (PyArray_SetBaseObject(reinterpret_cast<PyArrayObject *>
        (SHPy_arg), SHC_arg) < 0) goto fail;

    return (PyObject *) SHPy_arg;

fail:
    if (SH_arg != nullptr) {
        PY_SHROUD_release_memory(2, SH_arg);
    }
    Py_XDECREF(SHPy_arg);
    Py_XDECREF(SHC_arg);
    return nullptr;
// splicer end function.vector_iota_out_d
}

// ----------------------------------------
// Function:  std::vector<int> ReturnVectorAlloc
// Statement: py_function_vector<native>_numpy
// ----------------------------------------
// Argument:  int n
// Statement: py_in_native
static char PY_ReturnVectorAlloc__doc__[] =
"documentation"
;

/**
 * Implement iota function.
 * Return a vector as an ALLOCATABLE array.
 * Copy results into the new array.
 */
static PyObject *
PY_ReturnVectorAlloc(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.ReturnVectorAlloc
    std::vector<int> *SHCXX_rv = nullptr;
    int n;
    const char *SHT_kwlist[] = {
        "n",
        nullptr };
    npy_intp SHD_rv[1];
    PyObject * SHTPy_rv = nullptr;
    PyObject *SHC_SHCXX_rv = nullptr;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "i:ReturnVectorAlloc",
        const_cast<char **>(SHT_kwlist), &n))
        return nullptr;

    // result pre_call
    SHCXX_rv = new std::vector<int>;
    if (SHCXX_rv == nullptr) {
        PyErr_NoMemory();
        goto fail;
    }

    *SHCXX_rv = ReturnVectorAlloc(n);

    // post_call
    SHD_rv[0] = SHCXX_rv->size();
    SHTPy_rv = PyArray_SimpleNewFromData(1, SHD_rv, NPY_INT,
        SHCXX_rv->data());
    if (SHTPy_rv == nullptr) goto fail;
    SHC_SHCXX_rv = PyCapsule_New(SHCXX_rv, "PY_array_dtor", 
        PY_SHROUD_capsule_destructor);
    if (SHC_SHCXX_rv == nullptr) goto fail;
    PyCapsule_SetContext(SHC_SHCXX_rv, PY_SHROUD_fetch_context(1));
    if (PyArray_SetBaseObject(reinterpret_cast<PyArrayObject *>
        (SHTPy_rv), SHC_SHCXX_rv) < 0) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    if (SHCXX_rv != nullptr) {
        PY_SHROUD_release_memory(1, SHCXX_rv);
    }
    Py_XDECREF(SHTPy_rv);
    Py_XDECREF(SHC_SHCXX_rv);
    return nullptr;
// splicer end function.ReturnVectorAlloc
}

// ----------------------------------------
// Function:  int returnDim2
// Statement: py_function_native
// ----------------------------------------
// Argument:  int *arg +intent(in)+rank(2)
// Statement: py_in_native*_numpy
// ----------------------------------------
// Argument:  int len +implied(size(arg,2))
// Statement: py_implied_native
static char PY_returnDim2__doc__[] =
"documentation"
;

static PyObject *
PY_returnDim2(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.returnDim2
    int *arg;
    PyObject * SHTPy_arg;
    PyArrayObject * SHPy_arg = nullptr;
    int len;
    const char *SHT_kwlist[] = {
        "arg",
        nullptr };
    int SHCXX_rv;
    PyObject * SHTPy_rv = nullptr;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "O:returnDim2",
        const_cast<char **>(SHT_kwlist), &SHTPy_arg))
        return nullptr;

    // post_parse
    SHPy_arg = reinterpret_cast<PyArrayObject *>
        (PyArray_ContiguousFromObject(SHTPy_arg, NPY_INT, 2, 2));
    if (SHPy_arg == nullptr) {
        PyErr_SetString(PyExc_ValueError,
            "arg must be a 2-D array of int");
        goto fail;
    }

    // pre_call
    arg = static_cast<int *>(PyArray_DATA(SHPy_arg));
    len = PyArray_DIM(SHPy_arg, (2)-1);

    SHCXX_rv = returnDim2(arg, len);

    // post_call
    SHTPy_rv = PyInt_FromLong(SHCXX_rv);

    // cleanup
    Py_DECREF(SHPy_arg);

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHPy_arg);
    return nullptr;
// splicer end function.returnDim2
}
static PyMethodDef PY_methods[] = {
{"vector_sum", (PyCFunction)PY_vector_sum, METH_VARARGS|METH_KEYWORDS,
    PY_vector_sum__doc__},
{"vector_iota_out", (PyCFunction)PY_vector_iota_out, METH_NOARGS,
    PY_vector_iota_out__doc__},
{"vector_iota_out_d", (PyCFunction)PY_vector_iota_out_d, METH_NOARGS,
    PY_vector_iota_out_d__doc__},
{"ReturnVectorAlloc", (PyCFunction)PY_ReturnVectorAlloc,
    METH_VARARGS|METH_KEYWORDS, PY_ReturnVectorAlloc__doc__},
{"returnDim2", (PyCFunction)PY_returnDim2, METH_VARARGS|METH_KEYWORDS,
    PY_returnDim2__doc__},
{nullptr,   (PyCFunction)nullptr, 0, nullptr}            /* sentinel */
};

/*
 * initvectors - Initialization function for the module
 * *must* be called initvectors
 */
static char PY__doc__[] =
"library documentation"
;

struct module_state {
    PyObject *error;
};

#if PY_MAJOR_VERSION >= 3
#define GETSTATE(m) ((struct module_state*)PyModule_GetState(m))
#else
#define GETSTATE(m) (&_state)
static struct module_state _state;
#endif

#if PY_MAJOR_VERSION >= 3
static int vectors_traverse(PyObject *m, visitproc visit, void *arg) {
    Py_VISIT(GETSTATE(m)->error);
    return 0;
}

static int vectors_clear(PyObject *m) {
    Py_CLEAR(GETSTATE(m)->error);
    return 0;
}

static struct PyModuleDef moduledef = {
    PyModuleDef_HEAD_INIT,
    "vectors", /* m_name */
    PY__doc__, /* m_doc */
    sizeof(struct module_state), /* m_size */
    PY_methods, /* m_methods */
    nullptr, /* m_reload */
    vectors_traverse, /* m_traverse */
    vectors_clear, /* m_clear */
    NULL  /* m_free */
};

#define RETVAL m
#define INITERROR return nullptr
#else
#define RETVAL
#define INITERROR return
#endif

extern "C" PyMODINIT_FUNC
#if PY_MAJOR_VERSION >= 3
PyInit_vectors(void)
#else
initvectors(void)
#endif
{
    PyObject *m = nullptr;
    const char * error_name = "vectors.Error";

    // splicer begin C_init_locals
    // splicer end C_init_locals


    /* Create the module and add the functions */
#if PY_MAJOR_VERSION >= 3
    m = PyModule_Create(&moduledef);
#else
    m = Py_InitModule4("vectors", PY_methods,
        PY__doc__,
        (PyObject*)nullptr,PYTHON_API_VERSION);
#endif
    if (m == nullptr)
        return RETVAL;
    struct module_state *st = GETSTATE(m);

    import_array();

    PY_error_obj = PyErr_NewException((char *) error_name, nullptr, nullptr);
    if (PY_error_obj == nullptr)
        return RETVAL;
    st->error = PY_error_obj;
    PyModule_AddObject(m, "Error", st->error);

    // splicer begin C_init_body
    // splicer end C_init_body

    /* Check for errors */
    if (PyErr_Occurred())
        Py_FatalError("can't initialize module vectors");
    return RETVAL;
}

