// wraptypedefs.h
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//
/**
 * \file wraptypedefs.h
 * \brief Shroud generated wrapper for typedefs library
 */
// For C users and C++ implementation

#ifndef WRAPTYPEDEFS_H
#define WRAPTYPEDEFS_H

// typemap
#include "wraptypedefs.h"
#ifdef __cplusplus
#include <cstdint>
#else
#include <stdint.h>
#endif
// shroud
#include "typestypedefs.h"

// splicer begin CXX_declarations
// splicer end CXX_declarations

#ifdef __cplusplus
extern "C" {
#endif

// splicer begin C_declarations
#include "shared.h"
// splicer end C_declarations

//  Color
enum TYP_Color {
    // splicer begin enum.Color
    TYP_RED = 10,
    TYP_BLUE = 11,
    TYP_WHITE = 12
    // splicer end enum.Color
};

//  DataTypeID
enum TYP_DataTypeID {
    // splicer begin enum.DataTypeID
    TYP_NO_TYPE_ID = SHARED_NO_TYPE_ID,
    TYP_INT_ID = SHARED_INT_ID,
    TYP_LONG_ID = SHARED_LONG_ID,
    TYP_FLOAT_ID = SHARED_FLOAT_ID,
    TYP_DOUBLE_ID = SHARED_DOUBLE_ID
    // splicer end enum.DataTypeID
};

// start typedef Alias
// typedef Alias
// splicer begin typedef.Alias
typedef int TYP_Alias;
// splicer end typedef.Alias
// end typedef Alias

// start typedef iColor
// typedef iColor
// splicer begin typedef.iColor
typedef enum TYP_Color TYP_iColor;
// splicer end typedef.iColor
// end typedef iColor

// start typedef TypeID
// typedef TypeID
// splicer begin typedef.TypeID
typedef enum TYP_DataTypeID TYP_TypeID;
// splicer end typedef.TypeID
// end typedef TypeID

// start typedef Struct1Rename
// typedef Struct1Rename
// splicer begin typedef.Struct1Rename
typedef struct s_Struct1 TYP_Struct1Rename;
// splicer end typedef.Struct1Rename
// end typedef Struct1Rename

// start typedef IndexType
// typedef IndexType
// splicer begin typedef.IndexType
#if defined(USE_64BIT_INDEXTYPE)
typedef int64_t TYP_IndexType;
#else
typedef int32_t TYP_IndexType;
#endif
// splicer end typedef.IndexType
// end typedef IndexType

// start typedef IndexType2
// typedef IndexType2
// splicer begin typedef.IndexType2
#if defined(USE_64BIT_INDEXTYPE)
typedef int64_t LOCAL_IndexType;
#else
typedef int32_t LOCAL_IndexType;
#endif
// splicer end typedef.IndexType2
// end typedef IndexType2

#ifdef __cplusplus
}
#endif
#ifdef __cplusplus
using TYP_struct1rename = Struct1Rename;
#else  // __cplusplus

typedef struct s_TYP_struct1rename TYP_struct1rename;
struct s_TYP_struct1rename {
    int i;
    double d;
};
#endif  // __cplusplus

#ifdef __cplusplus
extern "C" {
#endif

TYP_Alias TYP_typefunc(TYP_Alias arg);

TYP_Alias TYP_typefunc_wrap(TYP_Alias arg);

TYP_iColor TYP_returnEnum(TYP_iColor in);

int TYP_returnEnum_bufferify(int in);

TYP_TypeID TYP_returnTypeID(TYP_TypeID in);

int TYP_returnTypeID_bufferify(int in);

void TYP_typestruct(TYP_Struct1Rename *arg1);

int TYP_returnBytesForIndexType(TYP_IndexType arg);

TYP_IndexType TYP_returnShapeSize(int ndims,
    const TYP_IndexType *shape);

int TYP_returnBytesForIndexType2(LOCAL_IndexType arg);

LOCAL_IndexType TYP_returnShapeSize2(int ndims,
    const LOCAL_IndexType *shape);

#ifdef __cplusplus
}
#endif

#endif  // WRAPTYPEDEFS_H
