! wrapftypedefs.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapftypedefs.f
!! \brief Shroud generated wrapper for typedefs library
!<
! splicer begin file_top
#include "shared.h"
! splicer end file_top
module typedefs_mod
    use iso_c_binding, only : C_DOUBLE, C_INT, C_INT32_T, C_INT64_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    !  enum Color
    integer, parameter :: color = C_INT
    ! splicer begin enum.Color
    integer(color), parameter :: &
      red=10, blue=11, white=12
    ! splicer end enum.Color

    !  enum DataTypeID
    integer, parameter :: data_type_id = C_INT
    ! splicer begin enum.DataTypeID
    integer(data_type_id), parameter :: no_type_id = SHARED_NO_TYPE_ID
    integer(data_type_id), parameter :: int_id = SHARED_INT_ID
    integer(data_type_id), parameter :: long_id = SHARED_LONG_ID
    integer(data_type_id), parameter :: float_id = SHARED_FLOAT_ID
    integer(data_type_id), parameter :: double_id = SHARED_DOUBLE_ID
    ! splicer end enum.DataTypeID

    ! start typedef Alias
    ! typedef Alias
    ! splicer begin typedef.Alias
    integer, parameter :: alias = C_INT
    ! splicer end typedef.Alias
    ! end typedef Alias

    ! start typedef iColor
    ! typedef iColor
    ! splicer begin typedef.iColor
    integer, parameter :: i_color = C_INT
    ! splicer end typedef.iColor
    ! end typedef iColor

    ! start typedef TypeID
    ! typedef TypeID
    ! splicer begin typedef.TypeID
    integer, parameter :: type_id = C_INT
    ! splicer end typedef.TypeID
    ! end typedef TypeID

    ! start typedef IndexType
    ! typedef IndexType
    ! splicer begin typedef.IndexType
#if defined(USE_64BIT_INDEXTYPE)
    integer, parameter :: INDEX_TYPE = C_INT64_T
#else
    integer, parameter :: INDEX_TYPE = C_INT32_T
#endif
    ! splicer end typedef.IndexType
    ! end typedef IndexType

    ! start typedef IndexType2
    ! typedef IndexType2
    ! splicer begin typedef.IndexType2
#if defined(USE_64BIT_INDEXTYPE)
    integer, parameter :: LOCAL_INDEX_TYPE = C_INT64_T
#else
    integer, parameter :: LOCAL_INDEX_TYPE = C_INT32_T
#endif
    ! splicer end typedef.IndexType2
    ! end typedef IndexType2


    ! start derived-type struct1_rename
    type, bind(C) :: struct1_rename
        integer(C_INT) :: i
        real(C_DOUBLE) :: d
    end type struct1_rename
    ! end derived-type struct1_rename

    ! ----------------------------------------
    ! Function:  Alias typefunc
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  Alias arg
    ! Statement: f_in_native
    ! start typefunc
    interface
        function typefunc(arg) &
                result(SHT_rv) &
                bind(C, name="TYP_typefunc")
            import :: alias
            implicit none
            integer(alias), value, intent(IN) :: arg
            integer(alias) :: SHT_rv
        end function typefunc
    end interface
    ! end typefunc

    ! ----------------------------------------
    ! Function:  Alias typefunc_wrap
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  Alias arg
    ! Statement: f_in_native
    ! start typefunc_wrap
    interface
        function typefunc_wrap(arg) &
                result(SHT_rv) &
                bind(C, name="TYP_typefunc_wrap")
            import :: alias
            implicit none
            integer(alias), value, intent(IN) :: arg
            integer(alias) :: SHT_rv
        end function typefunc_wrap
    end interface
    ! end typefunc_wrap

    ! ----------------------------------------
    ! Function:  iColor returnEnum
    ! Statement: c_function_enum
    ! ----------------------------------------
    ! Argument:  iColor in
    ! Statement: c_in_enum
    ! start c_return_enum
    interface
        function c_return_enum(in) &
                result(SHT_rv) &
                bind(C, name="TYP_returnEnum")
            import :: i_color
            implicit none
            integer(i_color), value, intent(IN) :: in
            integer(i_color) :: SHT_rv
        end function c_return_enum
    end interface
    ! end c_return_enum

    ! ----------------------------------------
    ! Function:  iColor returnEnum
    ! Statement: f_function_enum
    ! ----------------------------------------
    ! Argument:  iColor in
    ! Statement: f_in_enum
    ! start return_enum
    interface
        function return_enum(in) &
                result(SHT_rv) &
                bind(C, name="TYP_returnEnum_bufferify")
            import :: i_color
            implicit none
            integer(i_color), value, intent(IN) :: in
            integer(i_color) :: SHT_rv
        end function return_enum
    end interface
    ! end return_enum

    ! ----------------------------------------
    ! Function:  TypeID returnTypeID
    ! Statement: c_function_enum
    ! ----------------------------------------
    ! Argument:  TypeID in
    ! Statement: c_in_enum
    ! start c_return_type_id
    interface
        function c_return_type_id(in) &
                result(SHT_rv) &
                bind(C, name="TYP_returnTypeID")
            import :: type_id
            implicit none
            integer(type_id), value, intent(IN) :: in
            integer(type_id) :: SHT_rv
        end function c_return_type_id
    end interface
    ! end c_return_type_id

    ! ----------------------------------------
    ! Function:  TypeID returnTypeID
    ! Statement: f_function_enum
    ! ----------------------------------------
    ! Argument:  TypeID in
    ! Statement: f_in_enum
    ! start return_type_id
    interface
        function return_type_id(in) &
                result(SHT_rv) &
                bind(C, name="TYP_returnTypeID_bufferify")
            import :: type_id
            implicit none
            integer(type_id), value, intent(IN) :: in
            integer(type_id) :: SHT_rv
        end function return_type_id
    end interface
    ! end return_type_id

    ! ----------------------------------------
    ! Function:  void typestruct
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  Struct1Rename *arg1
    ! Statement: f_inout_struct*
    ! start typestruct
    interface
        subroutine typestruct(arg1) &
                bind(C, name="TYP_typestruct")
            import :: struct1_rename
            implicit none
            type(struct1_rename), intent(INOUT) :: arg1
        end subroutine typestruct
    end interface
    ! end typestruct

    ! ----------------------------------------
    ! Function:  int returnBytesForIndexType
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  IndexType arg
    ! Statement: f_in_native
    ! start return_bytes_for_index_type
    interface
        function return_bytes_for_index_type(arg) &
                result(SHT_rv) &
                bind(C, name="TYP_returnBytesForIndexType")
            use iso_c_binding, only : C_INT
            import :: index_type
            implicit none
            integer(index_type), value, intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function return_bytes_for_index_type
    end interface
    ! end return_bytes_for_index_type

    ! ----------------------------------------
    ! Function:  IndexType returnShapeSize
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int ndims
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  const IndexType *shape +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! start return_shape_size
    interface
        function return_shape_size(ndims, shape) &
                result(SHT_rv) &
                bind(C, name="TYP_returnShapeSize")
            use iso_c_binding, only : C_INT
            import :: index_type
            implicit none
            integer(C_INT), value, intent(IN) :: ndims
            integer(index_type), intent(IN) :: shape(*)
            integer(index_type) :: SHT_rv
        end function return_shape_size
    end interface
    ! end return_shape_size

    ! ----------------------------------------
    ! Function:  int returnBytesForIndexType2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  IndexType2 arg
    ! Statement: f_in_native
    ! start return_bytes_for_index_type2
    interface
        function return_bytes_for_index_type2(arg) &
                result(SHT_rv) &
                bind(C, name="TYP_returnBytesForIndexType2")
            use iso_c_binding, only : C_INT
            import :: LOCAL_Index_Type
            implicit none
            integer(LOCAL_Index_Type), value, intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function return_bytes_for_index_type2
    end interface
    ! end return_bytes_for_index_type2

    ! ----------------------------------------
    ! Function:  IndexType2 returnShapeSize2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int ndims
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  const IndexType2 *shape +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! start return_shape_size2
    interface
        function return_shape_size2(ndims, shape) &
                result(SHT_rv) &
                bind(C, name="TYP_returnShapeSize2")
            use iso_c_binding, only : C_INT
            import :: LOCAL_Index_Type
            implicit none
            integer(C_INT), value, intent(IN) :: ndims
            integer(LOCAL_Index_Type), intent(IN) :: shape(*)
            integer(LOCAL_Index_Type) :: SHT_rv
        end function return_shape_size2
    end interface
    ! end return_shape_size2

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  Alias typefunc
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  Alias arg
    ! Statement: f_in_native
    ! start typefunc
    function typefunc(arg) &
            result(SHT_rv)
        integer(alias), value, intent(IN) :: arg
        integer(alias) :: SHT_rv
        ! splicer begin function.typefunc
        SHT_rv = c_typefunc(arg)
        ! splicer end function.typefunc
    end function typefunc
    ! end typefunc
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  Alias typefunc_wrap
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  Alias arg
    ! Statement: f_in_native
    !>
    !! \brief Use typedef with a C wrapper
    !!
    !! Use C_force_wrapper to ensure the typedef will be used
    !! in the C wrapper.
    !<
    ! start typefunc_wrap
    function typefunc_wrap(arg) &
            result(SHT_rv)
        integer(alias), value, intent(IN) :: arg
        integer(alias) :: SHT_rv
        ! splicer begin function.typefunc_wrap
        SHT_rv = c_typefunc_wrap(arg)
        ! splicer end function.typefunc_wrap
    end function typefunc_wrap
    ! end typefunc_wrap
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  iColor returnEnum
    ! Statement: f_function_enum
    ! ----------------------------------------
    ! Argument:  iColor in
    ! Statement: f_in_enum
    ! start return_enum
    function return_enum(in) &
            result(SHT_rv)
        integer(i_color), value, intent(IN) :: in
        integer(i_color) :: SHT_rv
        ! splicer begin function.return_enum
        SHT_rv = c_return_enum_bufferify(in)
        ! splicer end function.return_enum
    end function return_enum
    ! end return_enum
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  TypeID returnTypeID
    ! Statement: f_function_enum
    ! ----------------------------------------
    ! Argument:  TypeID in
    ! Statement: f_in_enum
    ! start return_type_id
    function return_type_id(in) &
            result(SHT_rv)
        integer(type_id), value, intent(IN) :: in
        integer(type_id) :: SHT_rv
        ! splicer begin function.return_type_id
        SHT_rv = c_return_type_id_bufferify(in)
        ! splicer end function.return_type_id
    end function return_type_id
    ! end return_type_id
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void typestruct
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  Struct1Rename *arg1
    ! Statement: f_inout_struct*
    ! start typestruct
    subroutine typestruct(arg1)
        type(struct1_rename), intent(INOUT) :: arg1
        ! splicer begin function.typestruct
        call c_typestruct(arg1)
        ! splicer end function.typestruct
    end subroutine typestruct
    ! end typestruct
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int returnBytesForIndexType
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  IndexType arg
    ! Statement: f_in_native
    ! start return_bytes_for_index_type
    function return_bytes_for_index_type(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(index_type), value, intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.return_bytes_for_index_type
        SHT_rv = c_return_bytes_for_index_type(arg)
        ! splicer end function.return_bytes_for_index_type
    end function return_bytes_for_index_type
    ! end return_bytes_for_index_type
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  IndexType returnShapeSize
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int ndims
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  const IndexType *shape +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! start return_shape_size
    function return_shape_size(ndims, shape) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: ndims
        integer(index_type), intent(IN) :: shape(:)
        integer(index_type) :: SHT_rv
        ! splicer begin function.return_shape_size
        SHT_rv = c_return_shape_size(ndims, shape)
        ! splicer end function.return_shape_size
    end function return_shape_size
    ! end return_shape_size
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int returnBytesForIndexType2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  IndexType2 arg
    ! Statement: f_in_native
    ! start return_bytes_for_index_type2
    function return_bytes_for_index_type2(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(LOCAL_Index_Type), value, intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.return_bytes_for_index_type2
        SHT_rv = c_return_bytes_for_index_type2(arg)
        ! splicer end function.return_bytes_for_index_type2
    end function return_bytes_for_index_type2
    ! end return_bytes_for_index_type2
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  IndexType2 returnShapeSize2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int ndims
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  const IndexType2 *shape +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! start return_shape_size2
    function return_shape_size2(ndims, shape) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: ndims
        integer(LOCAL_Index_Type), intent(IN) :: shape(:)
        integer(LOCAL_Index_Type) :: SHT_rv
        ! splicer begin function.return_shape_size2
        SHT_rv = c_return_shape_size2(ndims, shape)
        ! splicer end function.return_shape_size2
    end function return_shape_size2
    ! end return_shape_size2
#endif

    ! splicer begin additional_functions
    ! splicer end additional_functions

end module typedefs_mod
