! wrapftutorial.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapftutorial.f
!! \brief Shroud generated wrapper for tutorial namespace
!<
! splicer begin file_top
! splicer end file_top
module tutorial_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! start helper array_context
    ! helper array_context
    type, bind(C) :: TUT_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type TUT_SHROUD_array
    ! end helper array_context

    ! start helper capsule_data_helper
    ! helper capsule_data_helper
    type, bind(C) :: TUT_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type TUT_SHROUD_capsule_data
    ! end helper capsule_data_helper

    !  enum tutorial::Color
    integer, parameter :: color = C_INT
    ! splicer begin enum.Color
    integer(color), parameter :: red = 0
    integer(color), parameter :: blue = 1
    integer(color), parameter :: white = 2
    ! splicer end enum.Color

    ! typedef tutorial::TypeID
    ! splicer begin typedef.TypeID
    integer, parameter :: type_id = C_INT
    ! splicer end typedef.TypeID

    ! ----------------------------------------
    ! Function:  int incr
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int
    ! Statement: f_none_native
    ! start abstract callback1_incr
    abstract interface
        function callback1_incr(arg0) &
            result(SHT_rv) bind(C)
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value :: arg0
            integer(C_INT) :: SHT_rv
        end function callback1_incr
    end interface
    ! end abstract callback1_incr

    ! ----------------------------------------
    ! Function:  void NoReturnNoArguments
    ! Statement: f_subroutine
    ! start no_return_no_arguments
    interface
        subroutine no_return_no_arguments() &
                bind(C, name="TUT_NoReturnNoArguments")
            implicit none
        end subroutine no_return_no_arguments
    end interface
    ! end no_return_no_arguments

    ! ----------------------------------------
    ! Function:  double PassByValue
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double arg1
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int arg2
    ! Statement: f_in_native
    interface
        function pass_by_value(arg1, arg2) &
                result(SHT_rv) &
                bind(C, name="TUT_PassByValue")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), value, intent(IN) :: arg1
            integer(C_INT), value, intent(IN) :: arg2
            real(C_DOUBLE) :: SHT_rv
        end function pass_by_value
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  const std::string ConcatenateStrings
    ! Statement: c_function_string
    ! ----------------------------------------
    ! Argument:  const std::string &arg1
    ! Statement: c_in_string&
    ! ----------------------------------------
    ! Argument:  const std::string &arg2
    ! Statement: c_in_string&
    interface
        function c_concatenate_strings(arg1, arg2) &
                result(SHT_rv) &
                bind(C, name="TUT_ConcatenateStrings")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
            character(kind=C_CHAR), intent(IN) :: arg2(*)
            character(kind=C_CHAR) :: SHT_rv(*)
        end function c_concatenate_strings
    end interface
#endif

    ! ----------------------------------------
    ! Function:  const std::string ConcatenateStrings
    ! Statement: f_function_string_cdesc_allocatable
    ! ----------------------------------------
    ! Argument:  const std::string &arg1
    ! Statement: f_in_string&_buf
    ! ----------------------------------------
    ! Argument:  const std::string &arg2
    ! Statement: f_in_string&_buf
    interface
        subroutine c_concatenate_strings_bufferify(arg1, SHT_arg1_len, &
                arg2, SHT_arg2_len, SHT_rv_cdesc, SHT_rv_capsule) &
                bind(C, name="TUT_ConcatenateStrings_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            import :: TUT_SHROUD_array, TUT_SHROUD_capsule_data
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
            integer(C_INT), value, intent(IN) :: SHT_arg1_len
            character(kind=C_CHAR), intent(IN) :: arg2(*)
            integer(C_INT), value, intent(IN) :: SHT_arg2_len
            type(TUT_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(TUT_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_concatenate_strings_bufferify
    end interface

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  double UseDefaultArguments
    ! Statement: f_function_native
    ! start c_use_default_arguments
    interface
        function c_use_default_arguments() &
                result(SHT_rv) &
                bind(C, name="TUT_UseDefaultArguments")
            use iso_c_binding, only : C_DOUBLE
            implicit none
            real(C_DOUBLE) :: SHT_rv
        end function c_use_default_arguments
    end interface
    ! end c_use_default_arguments

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  double UseDefaultArguments
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double arg1=3.1415
    ! Statement: f_in_native
    ! start c_use_default_arguments_arg1
    interface
        function c_use_default_arguments_arg1(arg1) &
                result(SHT_rv) &
                bind(C, name="TUT_UseDefaultArguments_arg1")
            use iso_c_binding, only : C_DOUBLE
            implicit none
            real(C_DOUBLE), value, intent(IN) :: arg1
            real(C_DOUBLE) :: SHT_rv
        end function c_use_default_arguments_arg1
    end interface
    ! end c_use_default_arguments_arg1

    ! ----------------------------------------
    ! Function:  double UseDefaultArguments
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double arg1=3.1415
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  bool arg2=true
    ! Statement: f_in_bool
    ! start c_use_default_arguments_arg1_arg2
    interface
        function c_use_default_arguments_arg1_arg2(arg1, arg2) &
                result(SHT_rv) &
                bind(C, name="TUT_UseDefaultArguments_arg1_arg2")
            use iso_c_binding, only : C_BOOL, C_DOUBLE
            implicit none
            real(C_DOUBLE), value, intent(IN) :: arg1
            logical(C_BOOL), value, intent(IN) :: arg2
            real(C_DOUBLE) :: SHT_rv
        end function c_use_default_arguments_arg1_arg2
    end interface
    ! end c_use_default_arguments_arg1_arg2

    ! ----------------------------------------
    ! Function:  void OverloadedFunction
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: c_in_string&
    interface
        subroutine c_overloaded_function_from_name(name) &
                bind(C, name="TUT_OverloadedFunction_from_name")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
        end subroutine c_overloaded_function_from_name
    end interface

    ! ----------------------------------------
    ! Function:  void OverloadedFunction
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: f_in_string&_buf
    interface
        subroutine c_overloaded_function_from_name_bufferify(name, &
                SHT_name_len) &
                bind(C, name="TUT_OverloadedFunction_from_name_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
        end subroutine c_overloaded_function_from_name_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void OverloadedFunction
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int indx
    ! Statement: f_in_native
    interface
        subroutine c_overloaded_function_from_index(indx) &
                bind(C, name="TUT_OverloadedFunction_from_index")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: indx
        end subroutine c_overloaded_function_from_index
    end interface

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  void TemplateArgument
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int arg
    ! Statement: f_in_native
    interface
        subroutine c_template_argument_int(arg) &
                bind(C, name="TUT_TemplateArgument_int")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: arg
        end subroutine c_template_argument_int
    end interface

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  void TemplateArgument
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double arg
    ! Statement: f_in_native
    interface
        subroutine c_template_argument_double(arg) &
                bind(C, name="TUT_TemplateArgument_double")
            use iso_c_binding, only : C_DOUBLE
            implicit none
            real(C_DOUBLE), value, intent(IN) :: arg
        end subroutine c_template_argument_double
    end interface

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  int TemplateReturn
    ! Statement: f_function_native
    interface
        function c_template_return_int() &
                result(SHT_rv) &
                bind(C, name="TUT_TemplateReturn_int")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT) :: SHT_rv
        end function c_template_return_int
    end interface

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  double TemplateReturn
    ! Statement: f_function_native
    interface
        function c_template_return_double() &
                result(SHT_rv) &
                bind(C, name="TUT_TemplateReturn_double")
            use iso_c_binding, only : C_DOUBLE
            implicit none
            real(C_DOUBLE) :: SHT_rv
        end function c_template_return_double
    end interface

    ! ----------------------------------------
    ! Function:  void FortranGenericOverloaded
    ! Statement: f_subroutine
    interface
        subroutine c_fortran_generic_overloaded_0() &
                bind(C, name="TUT_FortranGenericOverloaded_0")
            implicit none
        end subroutine c_fortran_generic_overloaded_0
    end interface

    ! ----------------------------------------
    ! Function:  void FortranGenericOverloaded
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: c_in_string&
    ! ----------------------------------------
    ! Argument:  double arg2
    ! Statement: c_in_native
    interface
        subroutine c_fortran_generic_overloaded_1(name, arg2) &
                bind(C, name="TUT_FortranGenericOverloaded_1")
            use iso_c_binding, only : C_CHAR, C_DOUBLE
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            real(C_DOUBLE), value, intent(IN) :: arg2
        end subroutine c_fortran_generic_overloaded_1
    end interface

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void FortranGenericOverloaded
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: f_in_string&_buf
    ! ----------------------------------------
    ! Argument:  float arg2
    ! Statement: f_in_native
    interface
        subroutine c_fortran_generic_overloaded_1_float_bufferify(name, &
                SHT_name_len, arg2) &
                bind(C, name="TUT_FortranGenericOverloaded_1_float_bufferify")
            use iso_c_binding, only : C_CHAR, C_FLOAT, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
            real(C_FLOAT), value, intent(IN) :: arg2
        end subroutine c_fortran_generic_overloaded_1_float_bufferify
    end interface

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void FortranGenericOverloaded
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: f_in_string&_buf
    ! ----------------------------------------
    ! Argument:  double arg2
    ! Statement: f_in_native
    interface
        subroutine c_fortran_generic_overloaded_1_double_bufferify(name, &
                SHT_name_len, arg2) &
                bind(C, name="TUT_FortranGenericOverloaded_1_double_bufferify")
            use iso_c_binding, only : C_CHAR, C_DOUBLE, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
            real(C_DOUBLE), value, intent(IN) :: arg2
        end subroutine c_fortran_generic_overloaded_1_double_bufferify
    end interface

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    interface
        function c_use_default_overload_num(num) &
                result(SHT_rv) &
                bind(C, name="TUT_UseDefaultOverload_num")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: num
            integer(C_INT) :: SHT_rv
        end function c_use_default_overload_num
    end interface

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int offset=0
    ! Statement: f_in_native
    interface
        function c_use_default_overload_num_offset(num, offset) &
                result(SHT_rv) &
                bind(C, name="TUT_UseDefaultOverload_num_offset")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: num
            integer(C_INT), value, intent(IN) :: offset
            integer(C_INT) :: SHT_rv
        end function c_use_default_overload_num_offset
    end interface

    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int offset=0
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int stride=1
    ! Statement: f_in_native
    interface
        function c_use_default_overload_num_offset_stride(num, offset, &
                stride) &
                result(SHT_rv) &
                bind(C, name="TUT_UseDefaultOverload_num_offset_stride")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: num
            integer(C_INT), value, intent(IN) :: offset
            integer(C_INT), value, intent(IN) :: stride
            integer(C_INT) :: SHT_rv
        end function c_use_default_overload_num_offset_stride
    end interface

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double type
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    interface
        function c_use_default_overload_3(type, num) &
                result(SHT_rv) &
                bind(C, name="TUT_UseDefaultOverload_3")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), value, intent(IN) :: type
            integer(C_INT), value, intent(IN) :: num
            integer(C_INT) :: SHT_rv
        end function c_use_default_overload_3
    end interface

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double type
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int offset=0
    ! Statement: f_in_native
    interface
        function c_use_default_overload_4(type, num, offset) &
                result(SHT_rv) &
                bind(C, name="TUT_UseDefaultOverload_4")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), value, intent(IN) :: type
            integer(C_INT), value, intent(IN) :: num
            integer(C_INT), value, intent(IN) :: offset
            integer(C_INT) :: SHT_rv
        end function c_use_default_overload_4
    end interface

    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double type
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int offset=0
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int stride=1
    ! Statement: f_in_native
    interface
        function c_use_default_overload_5(type, num, offset, stride) &
                result(SHT_rv) &
                bind(C, name="TUT_UseDefaultOverload_5")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), value, intent(IN) :: type
            integer(C_INT), value, intent(IN) :: num
            integer(C_INT), value, intent(IN) :: offset
            integer(C_INT), value, intent(IN) :: stride
            integer(C_INT) :: SHT_rv
        end function c_use_default_overload_5
    end interface

    ! ----------------------------------------
    ! Function:  TypeID typefunc
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  TypeID arg
    ! Statement: f_in_native
    interface
        function typefunc(arg) &
                result(SHT_rv) &
                bind(C, name="TUT_typefunc")
            import :: type_id
            implicit none
            integer(type_id), value, intent(IN) :: arg
            integer(type_id) :: SHT_rv
        end function typefunc
    end interface

    ! ----------------------------------------
    ! Function:  Color colorfunc
    ! Statement: c_function_enum
    ! ----------------------------------------
    ! Argument:  Color arg
    ! Statement: c_in_enum
    interface
        function c_colorfunc(arg) &
                result(SHT_rv) &
                bind(C, name="TUT_colorfunc")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function c_colorfunc
    end interface

    ! ----------------------------------------
    ! Function:  Color colorfunc
    ! Statement: f_function_enum
    ! ----------------------------------------
    ! Argument:  Color arg
    ! Statement: f_in_enum
    interface
        function colorfunc(arg) &
                result(SHT_rv) &
                bind(C, name="TUT_colorfunc_bufferify")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function colorfunc
    end interface

    ! ----------------------------------------
    ! Function:  void getMinMax
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int &min +intent(out)
    ! Statement: f_out_native&
    ! ----------------------------------------
    ! Argument:  int &max +intent(out)
    ! Statement: f_out_native&
    ! start get_min_max
    interface
        subroutine get_min_max(min, max) &
                bind(C, name="TUT_getMinMax")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT) :: min
            integer(C_INT), intent(OUT) :: max
        end subroutine get_min_max
    end interface
    ! end get_min_max

    ! ----------------------------------------
    ! Function:  int callback1
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int in
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int (*incr)(int)
    ! Statement: f_in_procedure
    ! start callback1
    interface
        function callback1(in, incr) &
                result(SHT_rv) &
                bind(C, name="TUT_callback1")
            use iso_c_binding, only : C_INT
            import :: callback1_incr
            implicit none
            integer(C_INT), value, intent(IN) :: in
            procedure(callback1_incr) :: incr
            integer(C_INT) :: SHT_rv
        end function callback1
    end interface
    ! end callback1

    ! ----------------------------------------
    ! Function:  const std::string &LastFunctionCalled +len(30)
    ! Statement: c_function_string&
    interface
        function c_last_function_called() &
                result(SHT_rv) &
                bind(C, name="TUT_LastFunctionCalled")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_last_function_called
    end interface

    ! ----------------------------------------
    ! Function:  const std::string &LastFunctionCalled +len(30)
    ! Statement: f_function_string&_buf_copy
    interface
        subroutine c_last_function_called_bufferify(SHT_rv, SHT_rv_len) &
                bind(C, name="TUT_LastFunctionCalled_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv(*)
            integer(C_INT), value, intent(IN) :: SHT_rv_len
        end subroutine c_last_function_called_bufferify
    end interface

    interface fortran_generic_overloaded
        module procedure fortran_generic_overloaded_0
        module procedure fortran_generic_overloaded_1_float
        module procedure fortran_generic_overloaded_1_double
    end interface fortran_generic_overloaded

    interface overloaded_function
        module procedure overloaded_function_from_name
        module procedure overloaded_function_from_index
    end interface overloaded_function

    interface template_argument
        module procedure template_argument_int
        module procedure template_argument_double
    end interface template_argument

    ! start generic interface use_default_arguments
    interface use_default_arguments
        module procedure use_default_arguments
        module procedure use_default_arguments_arg1
        module procedure use_default_arguments_arg1_arg2
    end interface use_default_arguments
    ! end generic interface use_default_arguments

    interface use_default_overload
        module procedure use_default_overload_num
        module procedure use_default_overload_num_offset
        module procedure use_default_overload_num_offset_stride
        module procedure use_default_overload_3
        module procedure use_default_overload_4
        module procedure use_default_overload_5
    end interface use_default_overload

    interface
        ! helper capsule_dtor
        ! Delete memory in a capsule.
        subroutine TUT_SHROUD_capsule_dtor(ptr) &
            bind(C, name="TUT_SHROUD_memory_destructor")
            import TUT_SHROUD_capsule_data
            implicit none
            type(TUT_SHROUD_capsule_data), intent(INOUT) :: ptr
        end subroutine TUT_SHROUD_capsule_dtor
    end interface

    interface
        ! helper copy_string
        ! Copy the char* or std::string in context into c_var.
        subroutine TUT_SHROUD_copy_string(context, c_var, c_var_size) &
             bind(c,name="TUT_ShroudCopyString")
            use, intrinsic :: iso_c_binding, only : C_CHAR, C_SIZE_T
            import TUT_SHROUD_array
            type(TUT_SHROUD_array), intent(IN) :: context
            character(kind=C_CHAR), intent(OUT) :: c_var(*)
            integer(C_SIZE_T), value :: c_var_size
        end subroutine TUT_SHROUD_copy_string
    end interface

    ! splicer begin additional_declarations
    interface
      subroutine all_test1(array)
        implicit none
        integer, dimension(:), allocatable :: array
      end subroutine all_test1
    end interface
    ! splicer end additional_declarations

contains

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void NoReturnNoArguments
    ! Statement: f_subroutine
    ! start no_return_no_arguments
    subroutine no_return_no_arguments()
        ! splicer begin function.no_return_no_arguments
        call c_no_return_no_arguments()
        ! splicer end function.no_return_no_arguments
    end subroutine no_return_no_arguments
    ! end no_return_no_arguments
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  double PassByValue
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double arg1
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int arg2
    ! Statement: f_in_native
    function pass_by_value(arg1, arg2) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), value, intent(IN) :: arg1
        integer(C_INT), value, intent(IN) :: arg2
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin function.pass_by_value
        SHT_rv = c_pass_by_value(arg1, arg2)
        ! splicer end function.pass_by_value
    end function pass_by_value
#endif

    ! ----------------------------------------
    ! Function:  const std::string ConcatenateStrings
    ! Statement: f_function_string_cdesc_allocatable
    ! ----------------------------------------
    ! Argument:  const std::string &arg1
    ! Statement: f_in_string&_buf
    ! ----------------------------------------
    ! Argument:  const std::string &arg2
    ! Statement: f_in_string&_buf
    !>
    !! Note that since a reference is returned, no intermediate string
    !! is allocated.  It is assumed +owner(library).
    !<
    function concatenate_strings(arg1, arg2) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: arg1
        character(len=*), intent(IN) :: arg2
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.concatenate_strings
        integer(C_INT) SHT_arg1_len
        integer(C_INT) SHT_arg2_len
        type(TUT_SHROUD_array) :: SHT_rv_cdesc
        type(TUT_SHROUD_capsule_data) :: SHT_rv_capsule
        SHT_arg1_len = len(arg1, kind=C_INT)
        SHT_arg2_len = len(arg2, kind=C_INT)
        call c_concatenate_strings_bufferify(arg1, SHT_arg1_len, arg2, &
            SHT_arg2_len, SHT_rv_cdesc, SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call TUT_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call TUT_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.concatenate_strings
    end function concatenate_strings

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  double UseDefaultArguments
    ! Statement: f_function_native
    ! start use_default_arguments
    function use_default_arguments() &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin function.use_default_arguments
        SHT_rv = c_use_default_arguments()
        ! splicer end function.use_default_arguments
    end function use_default_arguments
    ! end use_default_arguments

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  double UseDefaultArguments
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double arg1=3.1415
    ! Statement: f_in_native
    ! start use_default_arguments_arg1
    function use_default_arguments_arg1(arg1) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE
        real(C_DOUBLE), value, intent(IN) :: arg1
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin function.use_default_arguments_arg1
        SHT_rv = c_use_default_arguments_arg1(arg1)
        ! splicer end function.use_default_arguments_arg1
    end function use_default_arguments_arg1
    ! end use_default_arguments_arg1

    ! ----------------------------------------
    ! Function:  double UseDefaultArguments
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double arg1=3.1415
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  bool arg2=true
    ! Statement: f_in_bool
    ! start use_default_arguments_arg1_arg2
    function use_default_arguments_arg1_arg2(arg1, arg2) &
            result(SHT_rv)
        use iso_c_binding, only : C_BOOL, C_DOUBLE
        real(C_DOUBLE), value, intent(IN) :: arg1
        logical, value, intent(IN) :: arg2
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin function.use_default_arguments_arg1_arg2
        logical(C_BOOL) :: SHT_arg2_cxx
        SHT_arg2_cxx = arg2  ! coerce to C_BOOL
        SHT_rv = c_use_default_arguments_arg1_arg2(arg1, SHT_arg2_cxx)
        ! splicer end function.use_default_arguments_arg1_arg2
    end function use_default_arguments_arg1_arg2
    ! end use_default_arguments_arg1_arg2

    ! ----------------------------------------
    ! Function:  void OverloadedFunction
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: f_in_string&_buf
    subroutine overloaded_function_from_name(name)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: name
        ! splicer begin function.overloaded_function_from_name
        integer(C_INT) SHT_name_len
        SHT_name_len = len(name, kind=C_INT)
        call c_overloaded_function_from_name_bufferify(name, &
            SHT_name_len)
        ! splicer end function.overloaded_function_from_name
    end subroutine overloaded_function_from_name

    ! ----------------------------------------
    ! Function:  void OverloadedFunction
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int indx
    ! Statement: f_in_native
    subroutine overloaded_function_from_index(indx)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: indx
        ! splicer begin function.overloaded_function_from_index
        call c_overloaded_function_from_index(indx)
        ! splicer end function.overloaded_function_from_index
    end subroutine overloaded_function_from_index

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  void TemplateArgument
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int arg
    ! Statement: f_in_native
    subroutine template_argument_int(arg)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: arg
        ! splicer begin function.template_argument_int
        call c_template_argument_int(arg)
        ! splicer end function.template_argument_int
    end subroutine template_argument_int

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  void TemplateArgument
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double arg
    ! Statement: f_in_native
    subroutine template_argument_double(arg)
        use iso_c_binding, only : C_DOUBLE
        real(C_DOUBLE), value, intent(IN) :: arg
        ! splicer begin function.template_argument_double
        call c_template_argument_double(arg)
        ! splicer end function.template_argument_double
    end subroutine template_argument_double

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  int TemplateReturn
    ! Statement: f_function_native
    function template_return_int() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT) :: SHT_rv
        ! splicer begin function.template_return_int
        SHT_rv = c_template_return_int()
        ! splicer end function.template_return_int
    end function template_return_int

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  double TemplateReturn
    ! Statement: f_function_native
    function template_return_double() &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin function.template_return_double
        SHT_rv = c_template_return_double()
        ! splicer end function.template_return_double
    end function template_return_double

    ! ----------------------------------------
    ! Function:  void FortranGenericOverloaded
    ! Statement: f_subroutine
    subroutine fortran_generic_overloaded_0()
        ! splicer begin function.fortran_generic_overloaded_0
        call c_fortran_generic_overloaded_0()
        ! splicer end function.fortran_generic_overloaded_0
    end subroutine fortran_generic_overloaded_0

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void FortranGenericOverloaded
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: f_in_string&_buf
    ! ----------------------------------------
    ! Argument:  float arg2
    ! Statement: f_in_native
    subroutine fortran_generic_overloaded_1_float(name, arg2)
        use iso_c_binding, only : C_FLOAT, C_INT
        character(len=*), intent(IN) :: name
        real(C_FLOAT), value, intent(IN) :: arg2
        ! splicer begin function.fortran_generic_overloaded_1_float
        integer(C_INT) SHT_name_len
        SHT_name_len = len(name, kind=C_INT)
        call c_fortran_generic_overloaded_1_float_bufferify(name, &
            SHT_name_len, arg2)
        ! splicer end function.fortran_generic_overloaded_1_float
    end subroutine fortran_generic_overloaded_1_float

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void FortranGenericOverloaded
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &name
    ! Statement: f_in_string&_buf
    ! ----------------------------------------
    ! Argument:  double arg2
    ! Statement: f_in_native
    subroutine fortran_generic_overloaded_1_double(name, arg2)
        use iso_c_binding, only : C_DOUBLE, C_INT
        character(len=*), intent(IN) :: name
        real(C_DOUBLE), value, intent(IN) :: arg2
        ! splicer begin function.fortran_generic_overloaded_1_double
        integer(C_INT) SHT_name_len
        SHT_name_len = len(name, kind=C_INT)
        call c_fortran_generic_overloaded_1_double_bufferify(name, &
            SHT_name_len, arg2)
        ! splicer end function.fortran_generic_overloaded_1_double
    end subroutine fortran_generic_overloaded_1_double

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    function use_default_overload_num(num) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: num
        integer(C_INT) :: SHT_rv
        ! splicer begin function.use_default_overload_num
        SHT_rv = c_use_default_overload_num(num)
        ! splicer end function.use_default_overload_num
    end function use_default_overload_num

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int offset=0
    ! Statement: f_in_native
    function use_default_overload_num_offset(num, offset) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: num
        integer(C_INT), value, intent(IN) :: offset
        integer(C_INT) :: SHT_rv
        ! splicer begin function.use_default_overload_num_offset
        SHT_rv = c_use_default_overload_num_offset(num, offset)
        ! splicer end function.use_default_overload_num_offset
    end function use_default_overload_num_offset

    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int offset=0
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int stride=1
    ! Statement: f_in_native
    function use_default_overload_num_offset_stride(num, offset, stride) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: num
        integer(C_INT), value, intent(IN) :: offset
        integer(C_INT), value, intent(IN) :: stride
        integer(C_INT) :: SHT_rv
        ! splicer begin function.use_default_overload_num_offset_stride
        SHT_rv = c_use_default_overload_num_offset_stride(num, offset, &
            stride)
        ! splicer end function.use_default_overload_num_offset_stride
    end function use_default_overload_num_offset_stride

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double type
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    function use_default_overload_3(type, num) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), value, intent(IN) :: type
        integer(C_INT), value, intent(IN) :: num
        integer(C_INT) :: SHT_rv
        ! splicer begin function.use_default_overload_3
        SHT_rv = c_use_default_overload_3(type, num)
        ! splicer end function.use_default_overload_3
    end function use_default_overload_3

    ! Generated by has_default_arg
    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double type
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int offset=0
    ! Statement: f_in_native
    function use_default_overload_4(type, num, offset) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), value, intent(IN) :: type
        integer(C_INT), value, intent(IN) :: num
        integer(C_INT), value, intent(IN) :: offset
        integer(C_INT) :: SHT_rv
        ! splicer begin function.use_default_overload_4
        SHT_rv = c_use_default_overload_4(type, num, offset)
        ! splicer end function.use_default_overload_4
    end function use_default_overload_4

    ! ----------------------------------------
    ! Function:  int UseDefaultOverload
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  double type
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int num
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int offset=0
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int stride=1
    ! Statement: f_in_native
    function use_default_overload_5(type, num, offset, stride) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), value, intent(IN) :: type
        integer(C_INT), value, intent(IN) :: num
        integer(C_INT), value, intent(IN) :: offset
        integer(C_INT), value, intent(IN) :: stride
        integer(C_INT) :: SHT_rv
        ! splicer begin function.use_default_overload_5
        SHT_rv = c_use_default_overload_5(type, num, offset, stride)
        ! splicer end function.use_default_overload_5
    end function use_default_overload_5

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  TypeID typefunc
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  TypeID arg
    ! Statement: f_in_native
    function typefunc(arg) &
            result(SHT_rv)
        integer(type_id), value, intent(IN) :: arg
        integer(type_id) :: SHT_rv
        ! splicer begin function.typefunc
        SHT_rv = c_typefunc(arg)
        ! splicer end function.typefunc
    end function typefunc
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  Color colorfunc
    ! Statement: f_function_enum
    ! ----------------------------------------
    ! Argument:  Color arg
    ! Statement: f_in_enum
    function colorfunc(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.colorfunc
        SHT_rv = c_colorfunc_bufferify(arg)
        ! splicer end function.colorfunc
    end function colorfunc
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getMinMax
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int &min +intent(out)
    ! Statement: f_out_native&
    ! ----------------------------------------
    ! Argument:  int &max +intent(out)
    ! Statement: f_out_native&
    !>
    !! \brief Pass in reference to scalar
    !!
    !<
    ! start get_min_max
    subroutine get_min_max(min, max)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT) :: min
        integer(C_INT), intent(OUT) :: max
        ! splicer begin function.get_min_max
        call c_get_min_max(min, max)
        ! splicer end function.get_min_max
    end subroutine get_min_max
    ! end get_min_max
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int callback1
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int in
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int (*incr)(int)
    ! Statement: f_in_procedure
    !>
    !! \brief Test function pointer
    !!
    !<
    ! start callback1
    function callback1(in, incr) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: in
        procedure(callback1_incr) :: incr
        integer(C_INT) :: SHT_rv
        ! splicer begin function.callback1
        SHT_rv = c_callback1(in, incr)
        ! splicer end function.callback1
    end function callback1
    ! end callback1
#endif

    ! ----------------------------------------
    ! Function:  const std::string &LastFunctionCalled +len(30)
    ! Statement: f_function_string&_buf_copy
    function last_function_called() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=30) :: SHT_rv
        ! splicer begin function.last_function_called
        integer(C_INT) SHT_rv_len
        SHT_rv_len = len(SHT_rv, kind=C_INT)
        call c_last_function_called_bufferify(SHT_rv, SHT_rv_len)
        ! splicer end function.last_function_called
    end function last_function_called

    ! splicer begin additional_functions
    ! splicer end additional_functions

end module tutorial_mod
