// wrapTutorial.h
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//
/**
 * \file wrapTutorial.h
 * \brief Shroud generated wrapper for tutorial namespace
 */
// For C users and C++ implementation

#ifndef WRAPTUTORIAL_H
#define WRAPTUTORIAL_H

// typemap
#include "wrapTutorial.h"
#ifndef __cplusplus
#include <stdbool.h>
#endif
// shroud
#include "typesTutorial.h"

// splicer begin CXX_declarations
// splicer end CXX_declarations

#ifdef __cplusplus
extern "C" {
#endif

// splicer begin C_declarations
// splicer end C_declarations

//  tutorial::Color
enum TUT_Color {
    // splicer begin enum.Color
    TUT_RED,
    TUT_BLUE,
    TUT_WHITE
    // splicer end enum.Color
};

// typedef tutorial::TypeID
// splicer begin typedef.TypeID
typedef int TUT_TypeID;
// splicer end typedef.TypeID

void TUT_NoReturnNoArguments(void);

double TUT_PassByValue(double arg1, int arg2);

void TUT_ConcatenateStrings_bufferify(char *arg1, int SHT_arg1_len,
    char *arg2, int SHT_arg2_len, TUT_SHROUD_array *SHT_rv_cdesc,
    TUT_SHROUD_capsule_data *SHT_rv_capsule);

double TUT_UseDefaultArguments(void);

double TUT_UseDefaultArguments_arg1(double arg1);

double TUT_UseDefaultArguments_arg1_arg2(double arg1, bool arg2);

void TUT_OverloadedFunction_from_name(const char *name);

void TUT_OverloadedFunction_from_name_bufferify(char *name,
    int SHT_name_len);

void TUT_OverloadedFunction_from_index(int indx);

void TUT_TemplateArgument_int(int arg);

void TUT_TemplateArgument_double(double arg);

int TUT_TemplateReturn_int(void);

double TUT_TemplateReturn_double(void);

void TUT_FortranGenericOverloaded_0(void);

void TUT_FortranGenericOverloaded_1(const char *name, double arg2);

void TUT_FortranGenericOverloaded_1_float_bufferify(char *name,
    int SHT_name_len, float arg2);

void TUT_FortranGenericOverloaded_1_double_bufferify(char *name,
    int SHT_name_len, double arg2);

int TUT_UseDefaultOverload_num(int num);

int TUT_UseDefaultOverload_num_offset(int num, int offset);

int TUT_UseDefaultOverload_num_offset_stride(int num, int offset,
    int stride);

int TUT_UseDefaultOverload_3(double type, int num);

int TUT_UseDefaultOverload_4(double type, int num, int offset);

int TUT_UseDefaultOverload_5(double type, int num, int offset,
    int stride);

TUT_TypeID TUT_typefunc(TUT_TypeID arg);

enum TUT_Color TUT_colorfunc(enum TUT_Color arg);

int TUT_colorfunc_bufferify(int arg);

void TUT_getMinMax(int *min, int *max);

int TUT_callback1(int in, int (*incr)(int));

const char * TUT_LastFunctionCalled(void);

void TUT_LastFunctionCalled_bufferify(char *SHC_rv, int SHT_rv_len);

#ifdef __cplusplus
}
#endif

#endif  // WRAPTUTORIAL_H
