// wrapTutorial.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "tutorial.hpp"
// typemap
#include <string>
// shroud
#include <cstddef>
#include <cstring>
#include "wrapTutorial.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {


// helper ShroudCharCopy
// Copy src into dest, blank fill to ndest characters
// Truncate if dest is too short.
// dest will not be NULL terminated.
static void ShroudCharCopy(char *dest, int ndest, const char *src, int nsrc)
{
    if (src == NULL) {
        std::memset(dest,' ',ndest); // convert NULL pointer to blank filled string
    } else {
        if (nsrc < 0) nsrc = std::strlen(src);
        int nm = nsrc < ndest ? nsrc : ndest;
        std::memcpy(dest,src,nm);
        if(ndest > nm) std::memset(dest+nm,' ',ndest-nm); // blank fill
    }
}

// helper char_len_trim
// Returns the length of character string src with length nsrc,
// ignoring any trailing blanks.
static int ShroudCharLenTrim(const char *src, int nsrc) {
    int i;

    for (i = nsrc - 1; i >= 0; i--) {
        if (src[i] != ' ') {
            break;
        }
    }

    return i + 1;
}


// start helper string_to_cdesc
// helper string_to_cdesc
// Save std::string metadata into array to allow Fortran to access values.
// CHARACTER(len=elem_size) src
static void ShroudStringToCdesc(TUT_SHROUD_array *cdesc,
    const std::string * src)
{
    if (src->empty()) {
        cdesc->base_addr = NULL;
        cdesc->elem_len = 0;
    } else {
        cdesc->base_addr = const_cast<char *>(src->data());
        cdesc->elem_len = src->length();
    }
    cdesc->size = 1;
    cdesc->rank = 0;  // scalar
}
// end helper string_to_cdesc

// splicer begin C_definitions
// splicer end C_definitions

// ----------------------------------------
// Function:  void NoReturnNoArguments
// Statement: c_subroutine
// start TUT_NoReturnNoArguments
void TUT_NoReturnNoArguments(void)
{
    // splicer begin function.NoReturnNoArguments
    tutorial::NoReturnNoArguments();
    // splicer end function.NoReturnNoArguments
}
// end TUT_NoReturnNoArguments

// ----------------------------------------
// Function:  double PassByValue
// Statement: c_function_native
// ----------------------------------------
// Argument:  double arg1
// Statement: c_in_native
// ----------------------------------------
// Argument:  int arg2
// Statement: c_in_native
double TUT_PassByValue(double arg1, int arg2)
{
    // splicer begin function.PassByValue
    double SHC_rv = tutorial::PassByValue(arg1, arg2);
    return SHC_rv;
    // splicer end function.PassByValue
}

#if 0
! Not Implemented
/**
 * Note that since a reference is returned, no intermediate string
 * is allocated.  It is assumed +owner(library).
 */
// ----------------------------------------
// Function:  const std::string ConcatenateStrings
// Statement: c_function_string
// ----------------------------------------
// Argument:  const std::string &arg1
// Statement: c_in_string&
// ----------------------------------------
// Argument:  const std::string &arg2
// Statement: c_in_string&
const char TUT_ConcatenateStrings(const char *arg1, const char *arg2)
{
    // splicer begin function.ConcatenateStrings
    const std::string SHC_arg1_cxx(arg1);
    const std::string SHC_arg2_cxx(arg2);
    const std::string SHCXX_rv = tutorial::ConcatenateStrings(
        SHC_arg1_cxx, SHC_arg2_cxx);
    const char SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.ConcatenateStrings
}
#endif

/**
 * Note that since a reference is returned, no intermediate string
 * is allocated.  It is assumed +owner(library).
 */
// ----------------------------------------
// Function:  const std::string ConcatenateStrings
// Statement: f_function_string_cdesc_allocatable
// ----------------------------------------
// Argument:  const std::string &arg1
// Statement: f_in_string&_buf
// ----------------------------------------
// Argument:  const std::string &arg2
// Statement: f_in_string&_buf
void TUT_ConcatenateStrings_bufferify(char *arg1, int SHT_arg1_len,
    char *arg2, int SHT_arg2_len, TUT_SHROUD_array *SHT_rv_cdesc,
    TUT_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.ConcatenateStrings_bufferify
    const std::string SHC_arg1_cxx(arg1,
        ShroudCharLenTrim(arg1, SHT_arg1_len));
    const std::string SHC_arg2_cxx(arg2,
        ShroudCharLenTrim(arg2, SHT_arg2_len));
    std::string *SHC_rv_cxx = new std::string;
    *SHC_rv_cxx = tutorial::ConcatenateStrings(SHC_arg1_cxx,
        SHC_arg2_cxx);
    ShroudStringToCdesc(SHT_rv_cdesc, SHC_rv_cxx);
    SHT_rv_capsule->addr  = const_cast<std::string *>(SHC_rv_cxx);
    SHT_rv_capsule->idtor = 1;
    // splicer end function.ConcatenateStrings_bufferify
}

// Generated by has_default_arg
// ----------------------------------------
// Function:  double UseDefaultArguments
// Statement: c_function_native
// start TUT_UseDefaultArguments
double TUT_UseDefaultArguments(void)
{
    // splicer begin function.UseDefaultArguments
    double SHC_rv = tutorial::UseDefaultArguments();
    return SHC_rv;
    // splicer end function.UseDefaultArguments
}
// end TUT_UseDefaultArguments

// Generated by has_default_arg
// ----------------------------------------
// Function:  double UseDefaultArguments
// Statement: c_function_native
// ----------------------------------------
// Argument:  double arg1=3.1415
// Statement: c_in_native
// start TUT_UseDefaultArguments_arg1
double TUT_UseDefaultArguments_arg1(double arg1)
{
    // splicer begin function.UseDefaultArguments_arg1
    double SHC_rv = tutorial::UseDefaultArguments(arg1);
    return SHC_rv;
    // splicer end function.UseDefaultArguments_arg1
}
// end TUT_UseDefaultArguments_arg1

// ----------------------------------------
// Function:  double UseDefaultArguments
// Statement: c_function_native
// ----------------------------------------
// Argument:  double arg1=3.1415
// Statement: c_in_native
// ----------------------------------------
// Argument:  bool arg2=true
// Statement: c_in_bool
// start TUT_UseDefaultArguments_arg1_arg2
double TUT_UseDefaultArguments_arg1_arg2(double arg1, bool arg2)
{
    // splicer begin function.UseDefaultArguments_arg1_arg2
    double SHC_rv = tutorial::UseDefaultArguments(arg1, arg2);
    return SHC_rv;
    // splicer end function.UseDefaultArguments_arg1_arg2
}
// end TUT_UseDefaultArguments_arg1_arg2

// ----------------------------------------
// Function:  void OverloadedFunction
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const std::string &name
// Statement: c_in_string&
void TUT_OverloadedFunction_from_name(const char *name)
{
    // splicer begin function.OverloadedFunction_from_name
    const std::string SHC_name_cxx(name);
    tutorial::OverloadedFunction(SHC_name_cxx);
    // splicer end function.OverloadedFunction_from_name
}

// ----------------------------------------
// Function:  void OverloadedFunction
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const std::string &name
// Statement: f_in_string&_buf
void TUT_OverloadedFunction_from_name_bufferify(char *name,
    int SHT_name_len)
{
    // splicer begin function.OverloadedFunction_from_name_bufferify
    const std::string SHC_name_cxx(name,
        ShroudCharLenTrim(name, SHT_name_len));
    tutorial::OverloadedFunction(SHC_name_cxx);
    // splicer end function.OverloadedFunction_from_name_bufferify
}

// ----------------------------------------
// Function:  void OverloadedFunction
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int indx
// Statement: c_in_native
void TUT_OverloadedFunction_from_index(int indx)
{
    // splicer begin function.OverloadedFunction_from_index
    tutorial::OverloadedFunction(indx);
    // splicer end function.OverloadedFunction_from_index
}

// Generated by cxx_template
// ----------------------------------------
// Function:  void TemplateArgument
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int arg
// Statement: c_in_native
void TUT_TemplateArgument_int(int arg)
{
    // splicer begin function.TemplateArgument_int
    tutorial::TemplateArgument<int>(arg);
    // splicer end function.TemplateArgument_int
}

// Generated by cxx_template
// ----------------------------------------
// Function:  void TemplateArgument
// Statement: c_subroutine
// ----------------------------------------
// Argument:  double arg
// Statement: c_in_native
void TUT_TemplateArgument_double(double arg)
{
    // splicer begin function.TemplateArgument_double
    tutorial::TemplateArgument<double>(arg);
    // splicer end function.TemplateArgument_double
}

// Generated by cxx_template
// ----------------------------------------
// Function:  int TemplateReturn
// Statement: c_function_native
int TUT_TemplateReturn_int(void)
{
    // splicer begin function.TemplateReturn_int
    int SHC_rv = tutorial::TemplateReturn<int>();
    return SHC_rv;
    // splicer end function.TemplateReturn_int
}

// Generated by cxx_template
// ----------------------------------------
// Function:  double TemplateReturn
// Statement: c_function_native
double TUT_TemplateReturn_double(void)
{
    // splicer begin function.TemplateReturn_double
    double SHC_rv = tutorial::TemplateReturn<double>();
    return SHC_rv;
    // splicer end function.TemplateReturn_double
}

// ----------------------------------------
// Function:  void FortranGenericOverloaded
// Statement: c_subroutine
void TUT_FortranGenericOverloaded_0(void)
{
    // splicer begin function.FortranGenericOverloaded_0
    tutorial::FortranGenericOverloaded();
    // splicer end function.FortranGenericOverloaded_0
}

// ----------------------------------------
// Function:  void FortranGenericOverloaded
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const std::string &name
// Statement: c_in_string&
// ----------------------------------------
// Argument:  double arg2
// Statement: c_in_native
void TUT_FortranGenericOverloaded_1(const char *name, double arg2)
{
    // splicer begin function.FortranGenericOverloaded_1
    const std::string SHC_name_cxx(name);
    tutorial::FortranGenericOverloaded(SHC_name_cxx, arg2);
    // splicer end function.FortranGenericOverloaded_1
}

// Generated by fortran_generic
// ----------------------------------------
// Function:  void FortranGenericOverloaded
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const std::string &name
// Statement: f_in_string&_buf
// ----------------------------------------
// Argument:  float arg2
// Statement: f_in_native
void TUT_FortranGenericOverloaded_1_float_bufferify(char *name,
    int SHT_name_len, float arg2)
{
    // splicer begin function.FortranGenericOverloaded_1_float_bufferify
    const std::string SHC_name_cxx(name,
        ShroudCharLenTrim(name, SHT_name_len));
    tutorial::FortranGenericOverloaded(SHC_name_cxx, arg2);
    // splicer end function.FortranGenericOverloaded_1_float_bufferify
}

// Generated by fortran_generic
// ----------------------------------------
// Function:  void FortranGenericOverloaded
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const std::string &name
// Statement: f_in_string&_buf
// ----------------------------------------
// Argument:  double arg2
// Statement: f_in_native
void TUT_FortranGenericOverloaded_1_double_bufferify(char *name,
    int SHT_name_len, double arg2)
{
    // splicer begin function.FortranGenericOverloaded_1_double_bufferify
    const std::string SHC_name_cxx(name,
        ShroudCharLenTrim(name, SHT_name_len));
    tutorial::FortranGenericOverloaded(SHC_name_cxx, arg2);
    // splicer end function.FortranGenericOverloaded_1_double_bufferify
}

// Generated by has_default_arg
// ----------------------------------------
// Function:  int UseDefaultOverload
// Statement: c_function_native
// ----------------------------------------
// Argument:  int num
// Statement: c_in_native
int TUT_UseDefaultOverload_num(int num)
{
    // splicer begin function.UseDefaultOverload_num
    int SHC_rv = tutorial::UseDefaultOverload(num);
    return SHC_rv;
    // splicer end function.UseDefaultOverload_num
}

// Generated by has_default_arg
// ----------------------------------------
// Function:  int UseDefaultOverload
// Statement: c_function_native
// ----------------------------------------
// Argument:  int num
// Statement: c_in_native
// ----------------------------------------
// Argument:  int offset=0
// Statement: c_in_native
int TUT_UseDefaultOverload_num_offset(int num, int offset)
{
    // splicer begin function.UseDefaultOverload_num_offset
    int SHC_rv = tutorial::UseDefaultOverload(num, offset);
    return SHC_rv;
    // splicer end function.UseDefaultOverload_num_offset
}

// ----------------------------------------
// Function:  int UseDefaultOverload
// Statement: c_function_native
// ----------------------------------------
// Argument:  int num
// Statement: c_in_native
// ----------------------------------------
// Argument:  int offset=0
// Statement: c_in_native
// ----------------------------------------
// Argument:  int stride=1
// Statement: c_in_native
int TUT_UseDefaultOverload_num_offset_stride(int num, int offset,
    int stride)
{
    // splicer begin function.UseDefaultOverload_num_offset_stride
    int SHC_rv = tutorial::UseDefaultOverload(num, offset, stride);
    return SHC_rv;
    // splicer end function.UseDefaultOverload_num_offset_stride
}

// Generated by has_default_arg
// ----------------------------------------
// Function:  int UseDefaultOverload
// Statement: c_function_native
// ----------------------------------------
// Argument:  double type
// Statement: c_in_native
// ----------------------------------------
// Argument:  int num
// Statement: c_in_native
int TUT_UseDefaultOverload_3(double type, int num)
{
    // splicer begin function.UseDefaultOverload_3
    int SHC_rv = tutorial::UseDefaultOverload(type, num);
    return SHC_rv;
    // splicer end function.UseDefaultOverload_3
}

// Generated by has_default_arg
// ----------------------------------------
// Function:  int UseDefaultOverload
// Statement: c_function_native
// ----------------------------------------
// Argument:  double type
// Statement: c_in_native
// ----------------------------------------
// Argument:  int num
// Statement: c_in_native
// ----------------------------------------
// Argument:  int offset=0
// Statement: c_in_native
int TUT_UseDefaultOverload_4(double type, int num, int offset)
{
    // splicer begin function.UseDefaultOverload_4
    int SHC_rv = tutorial::UseDefaultOverload(type, num, offset);
    return SHC_rv;
    // splicer end function.UseDefaultOverload_4
}

// ----------------------------------------
// Function:  int UseDefaultOverload
// Statement: c_function_native
// ----------------------------------------
// Argument:  double type
// Statement: c_in_native
// ----------------------------------------
// Argument:  int num
// Statement: c_in_native
// ----------------------------------------
// Argument:  int offset=0
// Statement: c_in_native
// ----------------------------------------
// Argument:  int stride=1
// Statement: c_in_native
int TUT_UseDefaultOverload_5(double type, int num, int offset,
    int stride)
{
    // splicer begin function.UseDefaultOverload_5
    int SHC_rv = tutorial::UseDefaultOverload(type, num, offset,
        stride);
    return SHC_rv;
    // splicer end function.UseDefaultOverload_5
}

// ----------------------------------------
// Function:  TypeID typefunc
// Statement: c_function_native
// ----------------------------------------
// Argument:  TypeID arg
// Statement: c_in_native
TUT_TypeID TUT_typefunc(TUT_TypeID arg)
{
    // splicer begin function.typefunc
    tutorial::TypeID SHC_rv = tutorial::typefunc(arg);
    return SHC_rv;
    // splicer end function.typefunc
}

// ----------------------------------------
// Function:  Color colorfunc
// Statement: c_function_enum
// ----------------------------------------
// Argument:  Color arg
// Statement: c_in_enum
enum TUT_Color TUT_colorfunc(enum TUT_Color arg)
{
    // splicer begin function.colorfunc
    tutorial::Color SHCXX_arg = static_cast<tutorial::Color>(arg);
    tutorial::Color SHCXX_rv = tutorial::colorfunc(SHCXX_arg);
    enum TUT_Color SHC_rv = static_cast<enum TUT_Color>(SHCXX_rv);
    return SHC_rv;
    // splicer end function.colorfunc
}

// ----------------------------------------
// Function:  Color colorfunc
// Statement: f_function_enum
// ----------------------------------------
// Argument:  Color arg
// Statement: f_in_enum
int TUT_colorfunc_bufferify(int arg)
{
    // splicer begin function.colorfunc_bufferify
    tutorial::Color SHCXX_arg = static_cast<tutorial::Color>(arg);
    tutorial::Color SHCXX_rv = tutorial::colorfunc(SHCXX_arg);
    int SHC_rv = static_cast<int>(SHCXX_rv);
    return SHC_rv;
    // splicer end function.colorfunc_bufferify
}

/**
 * \brief Pass in reference to scalar
 *
 */
// ----------------------------------------
// Function:  void getMinMax
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int &min +intent(out)
// Statement: c_out_native&
// ----------------------------------------
// Argument:  int &max +intent(out)
// Statement: c_out_native&
// start TUT_getMinMax
void TUT_getMinMax(int *min, int *max)
{
    // splicer begin function.getMinMax
    tutorial::getMinMax(*min, *max);
    // splicer end function.getMinMax
}
// end TUT_getMinMax

/**
 * \brief Test function pointer
 *
 */
// ----------------------------------------
// Function:  int callback1
// Statement: c_function_native
// ----------------------------------------
// Argument:  int in
// Statement: c_in_native
// ----------------------------------------
// Argument:  int (*incr)(int)
// Statement: c_in_procedure
// start TUT_callback1
int TUT_callback1(int in, int (*incr)(int))
{
    // splicer begin function.callback1
    int SHC_rv = tutorial::callback1(in, incr);
    return SHC_rv;
    // splicer end function.callback1
}
// end TUT_callback1

// ----------------------------------------
// Function:  const std::string &LastFunctionCalled +len(30)
// Statement: c_function_string&
const char * TUT_LastFunctionCalled(void)
{
    // splicer begin function.LastFunctionCalled
    const std::string &SHCXX_rv = tutorial::LastFunctionCalled();
    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.LastFunctionCalled
}

// ----------------------------------------
// Function:  const std::string &LastFunctionCalled +len(30)
// Statement: f_function_string&_buf_copy
void TUT_LastFunctionCalled_bufferify(char *SHC_rv, int SHT_rv_len)
{
    // splicer begin function.LastFunctionCalled_bufferify
    const std::string &SHCXX_rv = tutorial::LastFunctionCalled();
    if (SHCXX_rv.empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_len, SHCXX_rv.data(),
            SHCXX_rv.size());
    }
    // splicer end function.LastFunctionCalled_bufferify
}

}  // extern "C"
