! wrapftemplates_std.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapftemplates_std.f
!! \brief Shroud generated wrapper for std namespace
!<
! splicer begin namespace.std.file_top
! splicer end namespace.std.file_top
module templates_std_mod
    use iso_c_binding, only : C_INT, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin namespace.std.module_use
    ! splicer end namespace.std.module_use
    implicit none

    ! splicer begin namespace.std.module_top
    ! splicer end namespace.std.module_top

    ! helper capsule_data_helper
    type, bind(C) :: TEM_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type TEM_SHROUD_capsule_data

    ! typedef std::vector<int>::size_type
    ! splicer begin namespace.std.class.vector_int.typedef.size_type
    integer, parameter :: vector_int_size_type = C_SIZE_T
    ! splicer end namespace.std.class.vector_int.typedef.size_type

    ! typedef std::vector<double>::size_type
    ! splicer begin namespace.std.class.vector_double.typedef.size_type
    integer, parameter :: vector_double_size_type = C_SIZE_T
    ! splicer end namespace.std.class.vector_double.typedef.size_type

    type vector_int
        type(TEM_SHROUD_capsule_data) :: cxxmem
        ! splicer begin namespace.std.class.vector_int.component_part
        ! splicer end namespace.std.class.vector_int.component_part
    contains
        procedure :: dtor => vector_int_dtor
        procedure :: push_back => vector_int_push_back
        procedure :: at => vector_int_at
        procedure :: get_instance => vector_int_get_instance
        procedure :: set_instance => vector_int_set_instance
        procedure :: associated => vector_int_associated
        ! splicer begin namespace.std.class.vector_int.type_bound_procedure_part
        ! splicer end namespace.std.class.vector_int.type_bound_procedure_part
    end type vector_int

    type vector_double
        type(TEM_SHROUD_capsule_data) :: cxxmem
        ! splicer begin namespace.std.class.vector_double.component_part
        ! splicer end namespace.std.class.vector_double.component_part
    contains
        procedure :: dtor => vector_double_dtor
        procedure :: push_back => vector_double_push_back
        procedure :: at => vector_double_at
        procedure :: get_instance => vector_double_get_instance
        procedure :: set_instance => vector_double_set_instance
        procedure :: associated => vector_double_associated
        ! splicer begin namespace.std.class.vector_double.type_bound_procedure_part
        ! splicer end namespace.std.class.vector_double.type_bound_procedure_part
    end type vector_double

    interface operator (.eq.)
        module procedure vector_int_eq
        module procedure vector_double_eq
    end interface

    interface operator (.ne.)
        module procedure vector_int_ne
        module procedure vector_double_ne
    end interface

    interface

        ! ----------------------------------------
        ! Function:  vector
        ! Statement: c_ctor_shadow_capptr
        function c_vector_int_ctor(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="TEM_vector_int_ctor")
            use iso_c_binding, only : C_PTR
            import :: TEM_SHROUD_capsule_data
            implicit none
            type(TEM_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_vector_int_ctor

        ! ----------------------------------------
        ! Function:  vector
        ! Statement: f_ctor_shadow_capsule
        subroutine c_vector_int_ctor_bufferify(SHT_rv) &
                bind(C, name="TEM_vector_int_ctor_bufferify")
            import :: TEM_SHROUD_capsule_data
            implicit none
            type(TEM_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_vector_int_ctor_bufferify

        ! ----------------------------------------
        ! Function:  ~vector
        ! Statement: f_dtor
        subroutine c_vector_int_dtor(self) &
                bind(C, name="TEM_vector_int_dtor")
            import :: TEM_SHROUD_capsule_data
            implicit none
            type(TEM_SHROUD_capsule_data), intent(INOUT) :: self
        end subroutine c_vector_int_dtor

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  void push_back
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  const int &value +intent(in)
        ! Statement: f_in_native&
        subroutine c_vector_int_push_back(self, value) &
                bind(C, name="TEM_vector_int_push_back")
            use iso_c_binding, only : C_INT
            import :: TEM_SHROUD_capsule_data
            implicit none
            type(TEM_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), intent(IN) :: value
        end subroutine c_vector_int_push_back

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  int &at
        ! Statement: c_function_native&
        ! ----------------------------------------
        ! Argument:  size_type n
        ! Statement: c_in_native
        function c_vector_int_at(self, n) &
                result(SHT_rv) &
                bind(C, name="TEM_vector_int_at")
            use iso_c_binding, only : C_PTR
            import :: TEM_SHROUD_capsule_data, vector_int_size_type
            implicit none
            type(TEM_SHROUD_capsule_data), intent(IN) :: self
            integer(vector_int_size_type), value, intent(IN) :: n
            type(C_PTR) :: SHT_rv
        end function c_vector_int_at

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  int &at
        ! Statement: f_function_native&_pointer
        ! ----------------------------------------
        ! Argument:  size_type n
        ! Statement: f_in_native
        function c_vector_int_at_bufferify(self, n) &
                result(SHT_rv) &
                bind(C, name="TEM_vector_int_at_bufferify")
            use iso_c_binding, only : C_PTR
            import :: TEM_SHROUD_capsule_data, vector_int_size_type
            implicit none
            type(TEM_SHROUD_capsule_data), intent(IN) :: self
            integer(vector_int_size_type), value, intent(IN) :: n
            type(C_PTR) :: SHT_rv
        end function c_vector_int_at_bufferify

        ! ----------------------------------------
        ! Function:  vector
        ! Statement: c_ctor_shadow_capptr
        function c_vector_double_ctor(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="TEM_vector_double_ctor")
            use iso_c_binding, only : C_PTR
            import :: TEM_SHROUD_capsule_data
            implicit none
            type(TEM_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_vector_double_ctor

        ! ----------------------------------------
        ! Function:  vector
        ! Statement: f_ctor_shadow_capsule
        subroutine c_vector_double_ctor_bufferify(SHT_rv) &
                bind(C, name="TEM_vector_double_ctor_bufferify")
            import :: TEM_SHROUD_capsule_data
            implicit none
            type(TEM_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_vector_double_ctor_bufferify

        ! ----------------------------------------
        ! Function:  ~vector
        ! Statement: f_dtor
        subroutine c_vector_double_dtor(self) &
                bind(C, name="TEM_vector_double_dtor")
            import :: TEM_SHROUD_capsule_data
            implicit none
            type(TEM_SHROUD_capsule_data), intent(INOUT) :: self
        end subroutine c_vector_double_dtor

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  void push_back
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  const double &value +intent(in)
        ! Statement: f_in_native&
        subroutine c_vector_double_push_back(self, value) &
                bind(C, name="TEM_vector_double_push_back")
            use iso_c_binding, only : C_DOUBLE
            import :: TEM_SHROUD_capsule_data
            implicit none
            type(TEM_SHROUD_capsule_data), intent(IN) :: self
            real(C_DOUBLE), intent(IN) :: value
        end subroutine c_vector_double_push_back

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  double &at
        ! Statement: c_function_native&
        ! ----------------------------------------
        ! Argument:  size_type n
        ! Statement: c_in_native
        function c_vector_double_at(self, n) &
                result(SHT_rv) &
                bind(C, name="TEM_vector_double_at")
            use iso_c_binding, only : C_PTR
            import :: TEM_SHROUD_capsule_data, vector_double_size_type
            implicit none
            type(TEM_SHROUD_capsule_data), intent(IN) :: self
            integer(vector_double_size_type), value, intent(IN) :: n
            type(C_PTR) :: SHT_rv
        end function c_vector_double_at

        ! Generated by cxx_template
        ! ----------------------------------------
        ! Function:  double &at
        ! Statement: f_function_native&_pointer
        ! ----------------------------------------
        ! Argument:  size_type n
        ! Statement: f_in_native
        function c_vector_double_at_bufferify(self, n) &
                result(SHT_rv) &
                bind(C, name="TEM_vector_double_at_bufferify")
            use iso_c_binding, only : C_PTR
            import :: TEM_SHROUD_capsule_data, vector_double_size_type
            implicit none
            type(TEM_SHROUD_capsule_data), intent(IN) :: self
            integer(vector_double_size_type), value, intent(IN) :: n
            type(C_PTR) :: SHT_rv
        end function c_vector_double_at_bufferify
    end interface

    interface vector_double
        module procedure vector_double_ctor
    end interface vector_double

    interface vector_int
        module procedure vector_int_ctor
    end interface vector_int

    ! splicer begin namespace.std.additional_declarations
    ! splicer end namespace.std.additional_declarations

contains

    ! ----------------------------------------
    ! Function:  vector
    ! Statement: f_ctor_shadow_capsule
    function vector_int_ctor() &
            result(SHT_rv)
        type(vector_int) :: SHT_rv
        ! splicer begin namespace.std.class.vector_int.method.ctor
        call c_vector_int_ctor_bufferify(SHT_rv%cxxmem)
        ! splicer end namespace.std.class.vector_int.method.ctor
    end function vector_int_ctor

    ! ----------------------------------------
    ! Function:  ~vector
    ! Statement: f_dtor
    subroutine vector_int_dtor(obj)
        class(vector_int), intent(INOUT) :: obj
        ! splicer begin namespace.std.class.vector_int.method.dtor
        call c_vector_int_dtor(obj%cxxmem)
        ! splicer end namespace.std.class.vector_int.method.dtor
    end subroutine vector_int_dtor

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  void push_back
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int &value +intent(in)
    ! Statement: f_in_native&
    subroutine vector_int_push_back(obj, value)
        use iso_c_binding, only : C_INT
        class(vector_int), intent(INOUT) :: obj
        integer(C_INT), intent(IN) :: value
        ! splicer begin namespace.std.class.vector_int.method.push_back
        call c_vector_int_push_back(obj%cxxmem, value)
        ! splicer end namespace.std.class.vector_int.method.push_back
    end subroutine vector_int_push_back

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  int &at
    ! Statement: f_function_native&_pointer
    ! ----------------------------------------
    ! Argument:  size_type n
    ! Statement: f_in_native
    function vector_int_at(obj, n) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR, c_f_pointer
        class(vector_int), intent(INOUT) :: obj
        integer(vector_int_size_type), value, intent(IN) :: n
        integer(C_INT), pointer :: SHT_rv
        ! splicer begin namespace.std.class.vector_int.method.at
        type(C_PTR) :: SHC_rv_ptr
        SHC_rv_ptr = c_vector_int_at_bufferify(obj%cxxmem, n)
        call c_f_pointer(SHC_rv_ptr, SHT_rv)
        ! splicer end namespace.std.class.vector_int.method.at
    end function vector_int_at

    ! Return pointer to C++ memory.
    function vector_int_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(vector_int), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function vector_int_get_instance

    subroutine vector_int_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(vector_int), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine vector_int_set_instance

    function vector_int_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(vector_int), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function vector_int_associated

    ! splicer begin namespace.std.class.vector_int.additional_functions
    ! splicer end namespace.std.class.vector_int.additional_functions

    ! ----------------------------------------
    ! Function:  vector
    ! Statement: f_ctor_shadow_capsule
    function vector_double_ctor() &
            result(SHT_rv)
        type(vector_double) :: SHT_rv
        ! splicer begin namespace.std.class.vector_double.method.ctor
        call c_vector_double_ctor_bufferify(SHT_rv%cxxmem)
        ! splicer end namespace.std.class.vector_double.method.ctor
    end function vector_double_ctor

    ! ----------------------------------------
    ! Function:  ~vector
    ! Statement: f_dtor
    subroutine vector_double_dtor(obj)
        class(vector_double), intent(INOUT) :: obj
        ! splicer begin namespace.std.class.vector_double.method.dtor
        call c_vector_double_dtor(obj%cxxmem)
        ! splicer end namespace.std.class.vector_double.method.dtor
    end subroutine vector_double_dtor

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  void push_back
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const double &value +intent(in)
    ! Statement: f_in_native&
    subroutine vector_double_push_back(obj, value)
        use iso_c_binding, only : C_DOUBLE
        class(vector_double), intent(INOUT) :: obj
        real(C_DOUBLE), intent(IN) :: value
        ! splicer begin namespace.std.class.vector_double.method.push_back
        call c_vector_double_push_back(obj%cxxmem, value)
        ! splicer end namespace.std.class.vector_double.method.push_back
    end subroutine vector_double_push_back

    ! Generated by cxx_template
    ! ----------------------------------------
    ! Function:  double &at
    ! Statement: f_function_native&_pointer
    ! ----------------------------------------
    ! Argument:  size_type n
    ! Statement: f_in_native
    function vector_double_at(obj, n) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_PTR, c_f_pointer
        class(vector_double), intent(INOUT) :: obj
        integer(vector_double_size_type), value, intent(IN) :: n
        real(C_DOUBLE), pointer :: SHT_rv
        ! splicer begin namespace.std.class.vector_double.method.at
        type(C_PTR) :: SHC_rv_ptr
        SHC_rv_ptr = c_vector_double_at_bufferify(obj%cxxmem, n)
        call c_f_pointer(SHC_rv_ptr, SHT_rv)
        ! splicer end namespace.std.class.vector_double.method.at
    end function vector_double_at

    ! Return pointer to C++ memory.
    function vector_double_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(vector_double), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function vector_double_get_instance

    subroutine vector_double_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(vector_double), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine vector_double_set_instance

    function vector_double_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(vector_double), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function vector_double_associated

    ! splicer begin namespace.std.class.vector_double.additional_functions
    ! splicer end namespace.std.class.vector_double.additional_functions

    ! splicer begin namespace.std.additional_functions
    ! splicer end namespace.std.additional_functions

    function vector_int_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(vector_int), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function vector_int_eq

    function vector_int_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(vector_int), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function vector_int_ne

    function vector_double_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(vector_double), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function vector_double_eq

    function vector_double_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(vector_double), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function vector_double_ne

end module templates_std_mod
