// wrapstruct.h
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//
/**
 * \file wrapstruct.h
 * \brief Shroud generated wrapper for struct library
 */
// For C users and C++ implementation

#ifndef WRAPSTRUCT_H
#define WRAPSTRUCT_H

// shroud
#include "typesstruct.h"

// splicer begin CXX_declarations
// splicer end CXX_declarations

#ifdef __cplusplus
extern "C" {
#endif

// splicer begin C_declarations
// splicer end C_declarations

#ifdef __cplusplus
}
#endif
#ifdef __cplusplus
using STR_cstruct1 = Cstruct1;
using STR_cstruct_ptr = Cstruct_ptr;
using STR_cstruct_list = Cstruct_list;
using STR_cstruct_numpy = Cstruct_numpy;
using STR_arrays1 = Arrays1;
using STR_s_nested = s_nested;
#else  // __cplusplus

typedef struct s_STR_cstruct1 STR_cstruct1;
struct s_STR_cstruct1 {
    int ifield;
    double dfield;
};

typedef struct s_STR_cstruct_ptr STR_cstruct_ptr;
struct s_STR_cstruct_ptr {
    char *cfield;
    const double *const_dvalue;
};

typedef struct s_STR_cstruct_list STR_cstruct_list;
struct s_STR_cstruct_list {
    int nitems;
    int *ivalue;
    double *dvalue;
    char **svalue;
};

typedef struct s_STR_cstruct_numpy STR_cstruct_numpy;
struct s_STR_cstruct_numpy {
    int nitems;
    int *ivalue;
    double *dvalue;
};

typedef struct s_STR_arrays1 STR_arrays1;
struct s_STR_arrays1 {
    char name[20];
    int count[10];
};

typedef struct s_STR_s_nested STR_s_nested;
struct s_STR_s_nested {
    int sublevels;
};
#endif  // __cplusplus

#ifdef __cplusplus
extern "C" {
#endif

int STR_passStructByValue(STR_cstruct1 arg);

int STR_passStruct1(const STR_cstruct1 *arg);

int STR_passStruct2(const STR_cstruct1 *s1, char *outbuf);

int STR_passStruct2_bufferify(const STR_cstruct1 *s1, char *outbuf,
    int SHT_outbuf_len);

int STR_acceptStructInPtr(STR_cstruct1 *arg);

void STR_acceptStructOutPtr(STR_cstruct1 *arg, int i, double d);

void STR_acceptStructInOutPtr(STR_cstruct1 *arg);

void STR_returnStructByValue(int i, double d, STR_cstruct1 *SHC_rv);

STR_cstruct1 * STR_returnStructPtr1(int i, double d);

void STR_returnStructPtr1_bufferify(int i, double d,
    STR_SHROUD_array *SHT_rv_cdesc);

STR_cstruct1 * STR_returnStructPtr2(int i, double d, char *outbuf);

void STR_returnStructPtr2_bufferify(int i, double d, char *outbuf,
    int SHT_outbuf_len, STR_SHROUD_array *SHT_rv_cdesc);

STR_cstruct1 * STR_returnStructPtrArray(void);

void STR_returnStructPtrArray_bufferify(STR_SHROUD_array *SHT_rv_cdesc);

STR_cstruct_list * STR_get_global_struct_list(void);

void STR_get_global_struct_list_bufferify(
    STR_SHROUD_array *SHT_rv_cdesc);

STR_Cstruct_as_class * STR_Create_Cstruct_as_class(
    STR_Cstruct_as_class * SHC_rv);

void STR_Create_Cstruct_as_class_bufferify(
    STR_Cstruct_as_class * SHC_rv);

STR_Cstruct_as_class * STR_Create_Cstruct_as_class_args(int x, int y,
    STR_Cstruct_as_class * SHC_rv);

void STR_Create_Cstruct_as_class_args_bufferify(int x, int y,
    STR_Cstruct_as_class * SHC_rv);

void STR_Return_Cstruct_as_class(STR_Cstruct_as_class * SHC_rv);

void STR_Return_Cstruct_as_class_args(int x, int y,
    STR_Cstruct_as_class * SHC_rv);

int STR_Cstruct_as_class_sum(STR_Cstruct_as_class * point);

STR_Cstruct_as_subclass * STR_Create_Cstruct_as_subclass_args(int x,
    int y, int z, STR_Cstruct_as_subclass * SHC_rv);

void STR_Create_Cstruct_as_subclass_args_bufferify(int x, int y, int z,
    STR_Cstruct_as_subclass * SHC_rv);

void STR_Return_Cstruct_as_subclass_args(int x, int y, int z,
    STR_Cstruct_as_subclass * SHC_rv);

const double * STR_Cstruct_ptr_get_const_dvalue(
    STR_cstruct_ptr *SH_this);

void STR_Cstruct_ptr_set_const_dvalue(STR_cstruct_ptr *SH_this,
    const double *val);

void STR_Cstruct_list_get_ivalue(STR_cstruct_list *SH_this,
    STR_SHROUD_array *SHT_rv_cdesc);

void STR_Cstruct_list_set_ivalue(STR_cstruct_list *SH_this, int *val);

void STR_Cstruct_list_get_dvalue(STR_cstruct_list *SH_this,
    STR_SHROUD_array *SHT_rv_cdesc);

void STR_Cstruct_list_set_dvalue(STR_cstruct_list *SH_this,
    double *val);

#ifdef __cplusplus
}
#endif

#endif  // WRAPSTRUCT_H
