// wrapstruct.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "struct.h"
// shroud
#include <cstring>
#include "wrapstruct.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {


// helper char_blank_fill
// blank fill dest starting at trailing NULL.
static void ShroudCharBlankFill(char *dest, int ndest)
{
    int nm = std::strlen(dest);
    if(ndest > nm) std::memset(dest+nm,' ',ndest-nm);
}

// splicer begin C_definitions
// splicer end C_definitions

// ----------------------------------------
// Function:  int passStructByValue
// Statement: c_function_native
// ----------------------------------------
// Argument:  Cstruct1 arg
// Statement: c_in_struct
// start STR_passStructByValue
int STR_passStructByValue(STR_cstruct1 arg)
{
    // splicer begin function.passStructByValue
    int SHC_rv = passStructByValue(arg);
    return SHC_rv;
    // splicer end function.passStructByValue
}
// end STR_passStructByValue

// ----------------------------------------
// Function:  int passStruct1
// Statement: c_function_native
// ----------------------------------------
// Argument:  const Cstruct1 *arg
// Statement: c_in_struct*
// start STR_passStruct1
int STR_passStruct1(const STR_cstruct1 *arg)
{
    // splicer begin function.passStruct1
    int SHC_rv = passStruct1(arg);
    return SHC_rv;
    // splicer end function.passStruct1
}
// end STR_passStruct1

/**
 * Pass name argument which will build a bufferify function.
 */
// ----------------------------------------
// Function:  int passStruct2
// Statement: c_function_native
// ----------------------------------------
// Argument:  const Cstruct1 *s1
// Statement: c_in_struct*
// ----------------------------------------
// Argument:  char *outbuf +charlen(LENOUTBUF)+intent(out)
// Statement: c_out_char*
int STR_passStruct2(const STR_cstruct1 *s1, char *outbuf)
{
    // splicer begin function.passStruct2
    int SHC_rv = passStruct2(s1, outbuf);
    return SHC_rv;
    // splicer end function.passStruct2
}

/**
 * Pass name argument which will build a bufferify function.
 */
// ----------------------------------------
// Function:  int passStruct2
// Statement: f_function_native
// ----------------------------------------
// Argument:  const Cstruct1 *s1
// Statement: f_in_struct*
// ----------------------------------------
// Argument:  char *outbuf +charlen(LENOUTBUF)+intent(out)
// Statement: f_out_char*_buf
int STR_passStruct2_bufferify(const STR_cstruct1 *s1, char *outbuf,
    int SHT_outbuf_len)
{
    // splicer begin function.passStruct2_bufferify
    int SHC_rv = passStruct2(s1, outbuf);
    ShroudCharBlankFill(outbuf, SHT_outbuf_len);
    return SHC_rv;
    // splicer end function.passStruct2_bufferify
}

// ----------------------------------------
// Function:  int acceptStructInPtr
// Statement: c_function_native
// ----------------------------------------
// Argument:  Cstruct1 *arg +intent(in)
// Statement: c_in_struct*
int STR_acceptStructInPtr(STR_cstruct1 *arg)
{
    // splicer begin function.acceptStructInPtr
    int SHC_rv = acceptStructInPtr(arg);
    return SHC_rv;
    // splicer end function.acceptStructInPtr
}

/**
 * Pass name argument which will build a bufferify function.
 */
// ----------------------------------------
// Function:  void acceptStructOutPtr
// Statement: c_subroutine
// ----------------------------------------
// Argument:  Cstruct1 *arg +intent(out)
// Statement: c_out_struct*
// ----------------------------------------
// Argument:  int i
// Statement: c_in_native
// ----------------------------------------
// Argument:  double d
// Statement: c_in_native
void STR_acceptStructOutPtr(STR_cstruct1 *arg, int i, double d)
{
    // splicer begin function.acceptStructOutPtr
    acceptStructOutPtr(arg, i, d);
    // splicer end function.acceptStructOutPtr
}

// ----------------------------------------
// Function:  void acceptStructInOutPtr
// Statement: c_subroutine
// ----------------------------------------
// Argument:  Cstruct1 *arg +intent(inout)
// Statement: c_inout_struct*
void STR_acceptStructInOutPtr(STR_cstruct1 *arg)
{
    // splicer begin function.acceptStructInOutPtr
    acceptStructInOutPtr(arg);
    // splicer end function.acceptStructInOutPtr
}

// ----------------------------------------
// Function:  Cstruct1 returnStructByValue
// Statement: c_function_struct
// ----------------------------------------
// Argument:  int i
// Statement: c_in_native
// ----------------------------------------
// Argument:  double d
// Statement: c_in_native
void STR_returnStructByValue(int i, double d, STR_cstruct1 *SHC_rv)
{
    // splicer begin function.returnStructByValue
    *SHC_rv = returnStructByValue(i, d);
    // splicer end function.returnStructByValue
}

/**
 * \brief Return a pointer to a struct
 *
 * Does not generate a bufferify C wrapper.
 */
// ----------------------------------------
// Function:  Cstruct1 *returnStructPtr1
// Statement: c_function_struct*
// ----------------------------------------
// Argument:  int i
// Statement: c_in_native
// ----------------------------------------
// Argument:  double d
// Statement: c_in_native
STR_cstruct1 * STR_returnStructPtr1(int i, double d)
{
    // splicer begin function.returnStructPtr1
    Cstruct1 *SHC_rv = returnStructPtr1(i, d);
    return SHC_rv;
    // splicer end function.returnStructPtr1
}

/**
 * \brief Return a pointer to a struct
 *
 * Does not generate a bufferify C wrapper.
 */
// ----------------------------------------
// Function:  Cstruct1 *returnStructPtr1
// Statement: f_function_struct*_cdesc_pointer
// ----------------------------------------
// Argument:  int i
// Statement: f_in_native
// ----------------------------------------
// Argument:  double d
// Statement: f_in_native
void STR_returnStructPtr1_bufferify(int i, double d,
    STR_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.returnStructPtr1_bufferify
    Cstruct1 *SHC_rv = returnStructPtr1(i, d);
    SHT_rv_cdesc->base_addr = SHC_rv;
    SHT_rv_cdesc->type = SH_TYPE_STRUCT;
    SHT_rv_cdesc->elem_len = sizeof(Cstruct1);
    SHT_rv_cdesc->rank = 0;
    SHT_rv_cdesc->size = 1;
    // splicer end function.returnStructPtr1_bufferify
}

/**
 * \brief Return a pointer to a struct
 *
 * Generates a bufferify C wrapper function.
 */
// ----------------------------------------
// Function:  Cstruct1 *returnStructPtr2
// Statement: c_function_struct*
// ----------------------------------------
// Argument:  int i
// Statement: c_in_native
// ----------------------------------------
// Argument:  double d
// Statement: c_in_native
// ----------------------------------------
// Argument:  char *outbuf +charlen(LENOUTBUF)+intent(out)
// Statement: c_out_char*
STR_cstruct1 * STR_returnStructPtr2(int i, double d, char *outbuf)
{
    // splicer begin function.returnStructPtr2
    Cstruct1 *SHC_rv = returnStructPtr2(i, d, outbuf);
    return SHC_rv;
    // splicer end function.returnStructPtr2
}

/**
 * \brief Return a pointer to a struct
 *
 * Generates a bufferify C wrapper function.
 */
// ----------------------------------------
// Function:  Cstruct1 *returnStructPtr2
// Statement: f_function_struct*_cdesc_pointer
// ----------------------------------------
// Argument:  int i
// Statement: f_in_native
// ----------------------------------------
// Argument:  double d
// Statement: f_in_native
// ----------------------------------------
// Argument:  char *outbuf +charlen(LENOUTBUF)+intent(out)
// Statement: f_out_char*_buf
void STR_returnStructPtr2_bufferify(int i, double d, char *outbuf,
    int SHT_outbuf_len, STR_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.returnStructPtr2_bufferify
    Cstruct1 *SHC_rv = returnStructPtr2(i, d, outbuf);
    ShroudCharBlankFill(outbuf, SHT_outbuf_len);
    SHT_rv_cdesc->base_addr = SHC_rv;
    SHT_rv_cdesc->type = SH_TYPE_STRUCT;
    SHT_rv_cdesc->elem_len = sizeof(Cstruct1);
    SHT_rv_cdesc->rank = 0;
    SHT_rv_cdesc->size = 1;
    // splicer end function.returnStructPtr2_bufferify
}

/**
 * \brief Return a pointer to an array of structs
 *
 */
// ----------------------------------------
// Function:  Cstruct1 *returnStructPtrArray +dimension(2)
// Statement: c_function_struct*
STR_cstruct1 * STR_returnStructPtrArray(void)
{
    // splicer begin function.returnStructPtrArray
    Cstruct1 *SHC_rv = returnStructPtrArray();
    return SHC_rv;
    // splicer end function.returnStructPtrArray
}

/**
 * \brief Return a pointer to an array of structs
 *
 */
// ----------------------------------------
// Function:  Cstruct1 *returnStructPtrArray +dimension(2)
// Statement: f_function_struct*_cdesc_pointer
void STR_returnStructPtrArray_bufferify(STR_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.returnStructPtrArray_bufferify
    Cstruct1 *SHC_rv = returnStructPtrArray();
    SHT_rv_cdesc->base_addr = SHC_rv;
    SHT_rv_cdesc->type = SH_TYPE_STRUCT;
    SHT_rv_cdesc->elem_len = sizeof(Cstruct1);
    SHT_rv_cdesc->rank = 1;
    SHT_rv_cdesc->shape[0] = 2;
    SHT_rv_cdesc->size = SHT_rv_cdesc->shape[0];
    // splicer end function.returnStructPtrArray_bufferify
}

// ----------------------------------------
// Function:  Cstruct_list *get_global_struct_list
// Statement: c_function_struct*
STR_cstruct_list * STR_get_global_struct_list(void)
{
    // splicer begin function.get_global_struct_list
    Cstruct_list *SHC_rv = get_global_struct_list();
    return SHC_rv;
    // splicer end function.get_global_struct_list
}

// ----------------------------------------
// Function:  Cstruct_list *get_global_struct_list
// Statement: f_function_struct*_cdesc_pointer
void STR_get_global_struct_list_bufferify(
    STR_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.get_global_struct_list_bufferify
    Cstruct_list *SHC_rv = get_global_struct_list();
    SHT_rv_cdesc->base_addr = SHC_rv;
    SHT_rv_cdesc->type = SH_TYPE_STRUCT;
    SHT_rv_cdesc->elem_len = sizeof(Cstruct_list);
    SHT_rv_cdesc->rank = 0;
    SHT_rv_cdesc->size = 1;
    // splicer end function.get_global_struct_list_bufferify
}

// ----------------------------------------
// Function:  Cstruct_as_class *Create_Cstruct_as_class
// Statement: c_function_shadow*_capptr
// start STR_Create_Cstruct_as_class
STR_Cstruct_as_class * STR_Create_Cstruct_as_class(
    STR_Cstruct_as_class * SHC_rv)
{
    // splicer begin function.Create_Cstruct_as_class
    Cstruct_as_class *SHC_rv_cxx = Create_Cstruct_as_class();
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    return SHC_rv;
    // splicer end function.Create_Cstruct_as_class
}
// end STR_Create_Cstruct_as_class

// ----------------------------------------
// Function:  Cstruct_as_class *Create_Cstruct_as_class
// Statement: f_function_shadow*_capsule
// start STR_Create_Cstruct_as_class_bufferify
void STR_Create_Cstruct_as_class_bufferify(
    STR_Cstruct_as_class * SHC_rv)
{
    // splicer begin function.Create_Cstruct_as_class_bufferify
    Cstruct_as_class *SHC_rv_cxx = Create_Cstruct_as_class();
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    // splicer end function.Create_Cstruct_as_class_bufferify
}
// end STR_Create_Cstruct_as_class_bufferify

// ----------------------------------------
// Function:  Cstruct_as_class *Create_Cstruct_as_class_args
// Statement: c_function_shadow*_capptr
// ----------------------------------------
// Argument:  int x
// Statement: c_in_native
// ----------------------------------------
// Argument:  int y
// Statement: c_in_native
STR_Cstruct_as_class * STR_Create_Cstruct_as_class_args(int x, int y,
    STR_Cstruct_as_class * SHC_rv)
{
    // splicer begin function.Create_Cstruct_as_class_args
    Cstruct_as_class *SHC_rv_cxx = Create_Cstruct_as_class_args(x, y);
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    return SHC_rv;
    // splicer end function.Create_Cstruct_as_class_args
}

// ----------------------------------------
// Function:  Cstruct_as_class *Create_Cstruct_as_class_args
// Statement: f_function_shadow*_capsule
// ----------------------------------------
// Argument:  int x
// Statement: f_in_native
// ----------------------------------------
// Argument:  int y
// Statement: f_in_native
void STR_Create_Cstruct_as_class_args_bufferify(int x, int y,
    STR_Cstruct_as_class * SHC_rv)
{
    // splicer begin function.Create_Cstruct_as_class_args_bufferify
    Cstruct_as_class *SHC_rv_cxx = Create_Cstruct_as_class_args(x, y);
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    // splicer end function.Create_Cstruct_as_class_args_bufferify
}

// ----------------------------------------
// Function:  Cstruct_as_class *Return_Cstruct_as_class
// Statement: c_function_shadow*_capsule
void STR_Return_Cstruct_as_class(STR_Cstruct_as_class * SHC_rv)
{
    // splicer begin function.Return_Cstruct_as_class
    Cstruct_as_class *SHC_rv_cxx = Return_Cstruct_as_class();
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    // splicer end function.Return_Cstruct_as_class
}

// ----------------------------------------
// Function:  Cstruct_as_class *Return_Cstruct_as_class_args
// Statement: c_function_shadow*_capsule
// ----------------------------------------
// Argument:  int x
// Statement: c_in_native
// ----------------------------------------
// Argument:  int y
// Statement: c_in_native
void STR_Return_Cstruct_as_class_args(int x, int y,
    STR_Cstruct_as_class * SHC_rv)
{
    // splicer begin function.Return_Cstruct_as_class_args
    Cstruct_as_class *SHC_rv_cxx = Return_Cstruct_as_class_args(x, y);
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    // splicer end function.Return_Cstruct_as_class_args
}

// ----------------------------------------
// Function:  int Cstruct_as_class_sum
// Statement: c_function_native
// ----------------------------------------
// Argument:  const Cstruct_as_class *point +pass
// Statement: c_in_shadow*
int STR_Cstruct_as_class_sum(STR_Cstruct_as_class * point)
{
    // splicer begin function.Cstruct_as_class_sum
    const Cstruct_as_class * SHC_point_cxx =
        static_cast<const Cstruct_as_class *>(point->addr);
    int SHC_rv = Cstruct_as_class_sum(SHC_point_cxx);
    return SHC_rv;
    // splicer end function.Cstruct_as_class_sum
}

// ----------------------------------------
// Function:  Cstruct_as_subclass *Create_Cstruct_as_subclass_args
// Statement: c_function_shadow*_capptr
// ----------------------------------------
// Argument:  int x
// Statement: c_in_native
// ----------------------------------------
// Argument:  int y
// Statement: c_in_native
// ----------------------------------------
// Argument:  int z
// Statement: c_in_native
STR_Cstruct_as_subclass * STR_Create_Cstruct_as_subclass_args(int x,
    int y, int z, STR_Cstruct_as_subclass * SHC_rv)
{
    // splicer begin function.Create_Cstruct_as_subclass_args
    Cstruct_as_subclass *SHC_rv_cxx = Create_Cstruct_as_subclass_args(x,
        y, z);
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    return SHC_rv;
    // splicer end function.Create_Cstruct_as_subclass_args
}

// ----------------------------------------
// Function:  Cstruct_as_subclass *Create_Cstruct_as_subclass_args
// Statement: f_function_shadow*_capsule
// ----------------------------------------
// Argument:  int x
// Statement: f_in_native
// ----------------------------------------
// Argument:  int y
// Statement: f_in_native
// ----------------------------------------
// Argument:  int z
// Statement: f_in_native
void STR_Create_Cstruct_as_subclass_args_bufferify(int x, int y, int z,
    STR_Cstruct_as_subclass * SHC_rv)
{
    // splicer begin function.Create_Cstruct_as_subclass_args_bufferify
    Cstruct_as_subclass *SHC_rv_cxx = Create_Cstruct_as_subclass_args(x,
        y, z);
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    // splicer end function.Create_Cstruct_as_subclass_args_bufferify
}

// ----------------------------------------
// Function:  Cstruct_as_subclass *Return_Cstruct_as_subclass_args
// Statement: c_function_shadow*_capsule
// ----------------------------------------
// Argument:  int x
// Statement: c_in_native
// ----------------------------------------
// Argument:  int y
// Statement: c_in_native
// ----------------------------------------
// Argument:  int z
// Statement: c_in_native
void STR_Return_Cstruct_as_subclass_args(int x, int y, int z,
    STR_Cstruct_as_subclass * SHC_rv)
{
    // splicer begin function.Return_Cstruct_as_subclass_args
    Cstruct_as_subclass *SHC_rv_cxx = Return_Cstruct_as_subclass_args(x,
        y, z);
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    // splicer end function.Return_Cstruct_as_subclass_args
}

// Generated by getter/setter
// ----------------------------------------
// Function:  const double *Cstruct_ptr_get_const_dvalue +intent(getter)
// Statement: f_getter_native*_pointer
// ----------------------------------------
// Argument:  Cstruct_ptr *SH_this +intent(in)
// Statement: f_in_struct*
const double * STR_Cstruct_ptr_get_const_dvalue(
    STR_cstruct_ptr *SH_this)
{
    // splicer begin function.Cstruct_ptr_get_const_dvalue
    // skip call c_getter
    return SH_this->const_dvalue;
    // splicer end function.Cstruct_ptr_get_const_dvalue
}

// Generated by getter/setter
// ----------------------------------------
// Function:  void Cstruct_ptr_set_const_dvalue +intent(setter)
// Statement: f_setter
// ----------------------------------------
// Argument:  Cstruct_ptr *SH_this
// Statement: f_inout_struct*
// ----------------------------------------
// Argument:  const double *val +intent(setter)
// Statement: f_setter_native*
void STR_Cstruct_ptr_set_const_dvalue(STR_cstruct_ptr *SH_this,
    const double *val)
{
    // splicer begin function.Cstruct_ptr_set_const_dvalue
    // skip call c_setter
    SH_this->const_dvalue = val;
    // splicer end function.Cstruct_ptr_set_const_dvalue
}

// Generated by getter/setter
// ----------------------------------------
// Function:  int *Cstruct_list_get_ivalue +dimension(nitems+nitems)+intent(getter)
// Statement: f_getter_native*_cdesc_pointer
// ----------------------------------------
// Argument:  Cstruct_list *SH_this +intent(in)
// Statement: f_in_struct*
void STR_Cstruct_list_get_ivalue(STR_cstruct_list *SH_this,
    STR_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.Cstruct_list_get_ivalue
    SHT_rv_cdesc->base_addr = SH_this->ivalue;
    SHT_rv_cdesc->type = SH_TYPE_INT;
    SHT_rv_cdesc->elem_len = sizeof(int);
    SHT_rv_cdesc->rank = 1;
    SHT_rv_cdesc->shape[0] = SH_this->nitems+SH_this->nitems;
    SHT_rv_cdesc->size = SHT_rv_cdesc->shape[0];
    // splicer end function.Cstruct_list_get_ivalue
}

// Generated by getter/setter
// ----------------------------------------
// Function:  void Cstruct_list_set_ivalue +intent(setter)
// Statement: f_setter
// ----------------------------------------
// Argument:  Cstruct_list *SH_this
// Statement: f_inout_struct*
// ----------------------------------------
// Argument:  int *val +intent(setter)+rank(1)
// Statement: f_setter_native*
void STR_Cstruct_list_set_ivalue(STR_cstruct_list *SH_this, int *val)
{
    // splicer begin function.Cstruct_list_set_ivalue
    // skip call c_setter
    SH_this->ivalue = val;
    // splicer end function.Cstruct_list_set_ivalue
}

// Generated by getter/setter
// ----------------------------------------
// Function:  double *Cstruct_list_get_dvalue +dimension(nitems*TWO)+intent(getter)
// Statement: f_getter_native*_cdesc_pointer
// ----------------------------------------
// Argument:  Cstruct_list *SH_this +intent(in)
// Statement: f_in_struct*
void STR_Cstruct_list_get_dvalue(STR_cstruct_list *SH_this,
    STR_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.Cstruct_list_get_dvalue
    SHT_rv_cdesc->base_addr = SH_this->dvalue;
    SHT_rv_cdesc->type = SH_TYPE_DOUBLE;
    SHT_rv_cdesc->elem_len = sizeof(double);
    SHT_rv_cdesc->rank = 1;
    SHT_rv_cdesc->shape[0] = SH_this->nitems*TWO;
    SHT_rv_cdesc->size = SHT_rv_cdesc->shape[0];
    // splicer end function.Cstruct_list_get_dvalue
}

// Generated by getter/setter
// ----------------------------------------
// Function:  void Cstruct_list_set_dvalue +intent(setter)
// Statement: f_setter
// ----------------------------------------
// Argument:  Cstruct_list *SH_this
// Statement: f_inout_struct*
// ----------------------------------------
// Argument:  double *val +intent(setter)+rank(1)
// Statement: f_setter_native*
void STR_Cstruct_list_set_dvalue(STR_cstruct_list *SH_this, double *val)
{
    // splicer begin function.Cstruct_list_set_dvalue
    // skip call c_setter
    SH_this->dvalue = val;
    // splicer end function.Cstruct_list_set_dvalue
}

}  // extern "C"
