! wrapfstruct.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfstruct.f
!! \brief Shroud generated wrapper for struct library
!<
! splicer begin file_top
! splicer end file_top
module struct_mod
    use iso_c_binding, only : C_CHAR, C_DOUBLE, C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    integer, parameter :: MAXNAME = 20
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! start helper array_context
    ! helper array_context
    type, bind(C) :: STR_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type STR_SHROUD_array
    ! end helper array_context

    ! start helper capsule_data_helper
    ! helper capsule_data_helper
    type, bind(C) :: STR_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type STR_SHROUD_capsule_data
    ! end helper capsule_data_helper


    ! start derived-type cstruct1
    type, bind(C) :: cstruct1
        integer(C_INT) :: ifield
        real(C_DOUBLE) :: dfield
    end type cstruct1
    ! end derived-type cstruct1


    type, bind(C) :: cstruct_ptr
        type(C_PTR) :: cfield
        type(C_PTR) :: const_dvalue
    end type cstruct_ptr


    type, bind(C) :: cstruct_list
        integer(C_INT) :: nitems
        type(C_PTR) :: ivalue
        type(C_PTR) :: dvalue
        type(C_PTR) :: svalue
    end type cstruct_list


    type, bind(C) :: cstruct_numpy
        integer(C_INT) :: nitems
        type(C_PTR) :: ivalue
        type(C_PTR) :: dvalue
    end type cstruct_numpy


    type, bind(C) :: arrays1
        character(kind=C_CHAR) :: name(20)
        integer(C_INT) :: count(10)
    end type arrays1

    ! start derived-type cstruct_as_class
    type cstruct_as_class
        type(STR_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.Cstruct_as_class.component_part
        ! splicer end class.Cstruct_as_class.component_part
    contains
        procedure :: get_x1 => cstruct_as_class_get_x1
        procedure :: set_x1 => cstruct_as_class_set_x1
        procedure :: get_y1 => cstruct_as_class_get_y1
        procedure :: set_y1 => cstruct_as_class_set_y1
        procedure :: sum => cstruct_as_class_sum
        ! splicer begin class.Cstruct_as_class.type_bound_procedure_part
        ! splicer end class.Cstruct_as_class.type_bound_procedure_part
    end type cstruct_as_class
    ! end derived-type cstruct_as_class

    ! start derived-type cstruct_as_subclass
    type, extends(cstruct_as_class) :: cstruct_as_subclass
        ! splicer begin class.Cstruct_as_subclass.component_part
        ! splicer end class.Cstruct_as_subclass.component_part
    contains
        procedure :: get_x1 => cstruct_as_subclass_get_x1
        procedure :: set_x1 => cstruct_as_subclass_set_x1
        procedure :: get_y1 => cstruct_as_subclass_get_y1
        procedure :: set_y1 => cstruct_as_subclass_set_y1
        procedure :: get_z1 => cstruct_as_subclass_get_z1
        procedure :: set_z1 => cstruct_as_subclass_set_z1
        ! splicer begin class.Cstruct_as_subclass.type_bound_procedure_part
        ! splicer end class.Cstruct_as_subclass.type_bound_procedure_part
    end type cstruct_as_subclass
    ! end derived-type cstruct_as_subclass


    type, bind(C) :: s_nested
        integer(C_INT) :: sublevels
    end type s_nested

    interface operator (.eq.)
        module procedure cstruct_as_class_eq
        module procedure cstruct_as_subclass_eq
    end interface

    interface operator (.ne.)
        module procedure cstruct_as_class_ne
        module procedure cstruct_as_subclass_ne
    end interface

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_x1 +intent(getter)
    ! Statement: f_getter_native
    ! start c_cstruct_as_class_get_x1
    interface
        function c_cstruct_as_class_get_x1(self) &
                result(SHT_rv) &
                bind(C, name="STR_Cstruct_as_class_get_x1")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_cstruct_as_class_get_x1
    end interface
    ! end c_cstruct_as_class_get_x1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_x1 +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start c_cstruct_as_class_set_x1
    interface
        subroutine c_cstruct_as_class_set_x1(self, val) &
                bind(C, name="STR_Cstruct_as_class_set_x1")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: val
        end subroutine c_cstruct_as_class_set_x1
    end interface
    ! end c_cstruct_as_class_set_x1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_y1 +intent(getter)
    ! Statement: f_getter_native
    ! start c_cstruct_as_class_get_y1
    interface
        function c_cstruct_as_class_get_y1(self) &
                result(SHT_rv) &
                bind(C, name="STR_Cstruct_as_class_get_y1")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_cstruct_as_class_get_y1
    end interface
    ! end c_cstruct_as_class_get_y1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_y1 +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start c_cstruct_as_class_set_y1
    interface
        subroutine c_cstruct_as_class_set_y1(self, val) &
                bind(C, name="STR_Cstruct_as_class_set_y1")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: val
        end subroutine c_cstruct_as_class_set_y1
    end interface
    ! end c_cstruct_as_class_set_y1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_x1 +intent(getter)
    ! Statement: f_getter_native
    ! start c_cstruct_as_subclass_get_x1
    interface
        function c_cstruct_as_subclass_get_x1(self) &
                result(SHT_rv) &
                bind(C, name="STR_Cstruct_as_subclass_get_x1")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_cstruct_as_subclass_get_x1
    end interface
    ! end c_cstruct_as_subclass_get_x1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_x1 +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start c_cstruct_as_subclass_set_x1
    interface
        subroutine c_cstruct_as_subclass_set_x1(self, val) &
                bind(C, name="STR_Cstruct_as_subclass_set_x1")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: val
        end subroutine c_cstruct_as_subclass_set_x1
    end interface
    ! end c_cstruct_as_subclass_set_x1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_y1 +intent(getter)
    ! Statement: f_getter_native
    ! start c_cstruct_as_subclass_get_y1
    interface
        function c_cstruct_as_subclass_get_y1(self) &
                result(SHT_rv) &
                bind(C, name="STR_Cstruct_as_subclass_get_y1")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_cstruct_as_subclass_get_y1
    end interface
    ! end c_cstruct_as_subclass_get_y1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_y1 +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start c_cstruct_as_subclass_set_y1
    interface
        subroutine c_cstruct_as_subclass_set_y1(self, val) &
                bind(C, name="STR_Cstruct_as_subclass_set_y1")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: val
        end subroutine c_cstruct_as_subclass_set_y1
    end interface
    ! end c_cstruct_as_subclass_set_y1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_z1 +intent(getter)
    ! Statement: f_getter_native
    ! start c_cstruct_as_subclass_get_z1
    interface
        function c_cstruct_as_subclass_get_z1(self) &
                result(SHT_rv) &
                bind(C, name="STR_Cstruct_as_subclass_get_z1")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_cstruct_as_subclass_get_z1
    end interface
    ! end c_cstruct_as_subclass_get_z1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_z1 +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start c_cstruct_as_subclass_set_z1
    interface
        subroutine c_cstruct_as_subclass_set_z1(self, val) &
                bind(C, name="STR_Cstruct_as_subclass_set_z1")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT), value, intent(IN) :: val
        end subroutine c_cstruct_as_subclass_set_z1
    end interface
    ! end c_cstruct_as_subclass_set_z1

    ! ----------------------------------------
    ! Function:  int passStructByValue
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  Cstruct1 arg
    ! Statement: f_in_struct
    ! start pass_struct_by_value
    interface
        function pass_struct_by_value(arg) &
                result(SHT_rv) &
                bind(C, name="passStructByValue")
            use iso_c_binding, only : C_INT
            import :: cstruct1
            implicit none
            type(cstruct1), value, intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function pass_struct_by_value
    end interface
    ! end pass_struct_by_value

    ! ----------------------------------------
    ! Function:  int passStruct1
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const Cstruct1 *arg
    ! Statement: f_in_struct*
    ! start pass_struct1
    interface
        function pass_struct1(arg) &
                result(SHT_rv) &
                bind(C, name="passStruct1")
            use iso_c_binding, only : C_INT
            import :: cstruct1
            implicit none
            type(cstruct1), intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function pass_struct1
    end interface
    ! end pass_struct1

    ! ----------------------------------------
    ! Function:  int passStruct2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const Cstruct1 *s1
    ! Statement: f_in_struct*
    ! ----------------------------------------
    ! Argument:  char *outbuf +charlen(LENOUTBUF)+intent(out)
    ! Statement: f_out_char*_buf
    interface
        function c_pass_struct2_bufferify(s1, outbuf, SHT_outbuf_len) &
                result(SHT_rv) &
                bind(C, name="STR_passStruct2_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            import :: cstruct1
            implicit none
            type(cstruct1), intent(IN) :: s1
            character(kind=C_CHAR), intent(OUT) :: outbuf(*)
            integer(C_INT), value, intent(IN) :: SHT_outbuf_len
            integer(C_INT) :: SHT_rv
        end function c_pass_struct2_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  int acceptStructInPtr
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  Cstruct1 *arg +intent(in)
    ! Statement: f_in_struct*
    interface
        function accept_struct_in_ptr(arg) &
                result(SHT_rv) &
                bind(C, name="acceptStructInPtr")
            use iso_c_binding, only : C_INT
            import :: cstruct1
            implicit none
            type(cstruct1), intent(IN) :: arg
            integer(C_INT) :: SHT_rv
        end function accept_struct_in_ptr
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStructOutPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  Cstruct1 *arg +intent(out)
    ! Statement: f_out_struct*
    ! ----------------------------------------
    ! Argument:  int i
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  double d
    ! Statement: f_in_native
    interface
        subroutine accept_struct_out_ptr(arg, i, d) &
                bind(C, name="acceptStructOutPtr")
            use iso_c_binding, only : C_DOUBLE, C_INT
            import :: cstruct1
            implicit none
            type(cstruct1), intent(OUT) :: arg
            integer(C_INT), value, intent(IN) :: i
            real(C_DOUBLE), value, intent(IN) :: d
        end subroutine accept_struct_out_ptr
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStructInOutPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  Cstruct1 *arg +intent(inout)
    ! Statement: f_inout_struct*
    interface
        subroutine accept_struct_in_out_ptr(arg) &
                bind(C, name="acceptStructInOutPtr")
            import :: cstruct1
            implicit none
            type(cstruct1), intent(INOUT) :: arg
        end subroutine accept_struct_in_out_ptr
    end interface

    ! ----------------------------------------
    ! Function:  Cstruct1 returnStructByValue
    ! Statement: f_function_struct
    ! ----------------------------------------
    ! Argument:  int i
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  double d
    ! Statement: f_in_native
    interface
        subroutine c_return_struct_by_value_bufferify(i, d, SHT_rv) &
                bind(C, name="STR_returnStructByValue_bufferify")
            use iso_c_binding, only : C_DOUBLE, C_INT
            import :: cstruct1
            implicit none
            integer(C_INT), value, intent(IN) :: i
            real(C_DOUBLE), value, intent(IN) :: d
            type(cstruct1), intent(OUT) :: SHT_rv
        end subroutine c_return_struct_by_value_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Cstruct1 *returnStructPtr1
    ! Statement: f_function_struct*_cdesc_pointer
    ! ----------------------------------------
    ! Argument:  int i
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  double d
    ! Statement: f_in_native
    interface
        subroutine c_return_struct_ptr1_bufferify(i, d, SHT_rv_cdesc) &
                bind(C, name="STR_returnStructPtr1_bufferify")
            use iso_c_binding, only : C_DOUBLE, C_INT
            import :: STR_SHROUD_array
            implicit none
            integer(C_INT), value, intent(IN) :: i
            real(C_DOUBLE), value, intent(IN) :: d
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_return_struct_ptr1_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Cstruct1 *returnStructPtr2
    ! Statement: f_function_struct*_cdesc_pointer
    ! ----------------------------------------
    ! Argument:  int i
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  double d
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  char *outbuf +charlen(LENOUTBUF)+intent(out)
    ! Statement: f_out_char*_buf
    interface
        subroutine c_return_struct_ptr2_bufferify(i, d, outbuf, &
                SHT_outbuf_len, SHT_rv_cdesc) &
                bind(C, name="STR_returnStructPtr2_bufferify")
            use iso_c_binding, only : C_CHAR, C_DOUBLE, C_INT
            import :: STR_SHROUD_array
            implicit none
            integer(C_INT), value, intent(IN) :: i
            real(C_DOUBLE), value, intent(IN) :: d
            character(kind=C_CHAR), intent(OUT) :: outbuf(*)
            integer(C_INT), value, intent(IN) :: SHT_outbuf_len
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_return_struct_ptr2_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Cstruct1 *returnStructPtrArray +dimension(2)
    ! Statement: f_function_struct*_cdesc_pointer
    interface
        subroutine c_return_struct_ptr_array_bufferify(SHT_rv_cdesc) &
                bind(C, name="STR_returnStructPtrArray_bufferify")
            import :: STR_SHROUD_array
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_return_struct_ptr_array_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Cstruct_list *get_global_struct_list
    ! Statement: f_function_struct*_cdesc_pointer
    interface
        subroutine c_get_global_struct_list_bufferify(SHT_rv_cdesc) &
                bind(C, name="STR_get_global_struct_list_bufferify")
            import :: STR_SHROUD_array
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_get_global_struct_list_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Cstruct_as_class *Create_Cstruct_as_class
    ! Statement: f_function_shadow*_capsule
    ! start c_create_cstruct_as_class_bufferify
    interface
        subroutine c_create_cstruct_as_class_bufferify(SHT_rv) &
                bind(C, name="STR_Create_Cstruct_as_class_bufferify")
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_create_cstruct_as_class_bufferify
    end interface
    ! end c_create_cstruct_as_class_bufferify

    ! ----------------------------------------
    ! Function:  Cstruct_as_class *Create_Cstruct_as_class_args
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  int x
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int y
    ! Statement: f_in_native
    interface
        subroutine c_create_cstruct_as_class_args_bufferify(x, y, &
                SHT_rv) &
                bind(C, name="STR_Create_Cstruct_as_class_args_bufferify")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            integer(C_INT), value, intent(IN) :: x
            integer(C_INT), value, intent(IN) :: y
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_create_cstruct_as_class_args_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Cstruct_as_class *Return_Cstruct_as_class
    ! Statement: f_function_shadow*_capsule
    interface
        subroutine c_return_cstruct_as_class_bufferify(SHT_rv) &
                bind(C, name="STR_Return_Cstruct_as_class_bufferify")
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_return_cstruct_as_class_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Cstruct_as_class *Return_Cstruct_as_class_args
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  int x
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int y
    ! Statement: f_in_native
    interface
        subroutine c_return_cstruct_as_class_args_bufferify(x, y, &
                SHT_rv) &
                bind(C, name="STR_Return_Cstruct_as_class_args_bufferify")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            integer(C_INT), value, intent(IN) :: x
            integer(C_INT), value, intent(IN) :: y
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_return_cstruct_as_class_args_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  int Cstruct_as_class_sum
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const Cstruct_as_class *point +pass
    ! Statement: f_in_shadow*
    interface
        function c_cstruct_as_class_sum_bufferify(point) &
                result(SHT_rv) &
                bind(C, name="STR_Cstruct_as_class_sum_bufferify")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(IN) :: point
            integer(C_INT) :: SHT_rv
        end function c_cstruct_as_class_sum_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Cstruct_as_subclass *Create_Cstruct_as_subclass_args
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  int x
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int y
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int z
    ! Statement: f_in_native
    interface
        subroutine c_create_cstruct_as_subclass_args_bufferify(x, y, z, &
                SHT_rv) &
                bind(C, name="STR_Create_Cstruct_as_subclass_args_bufferify")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            integer(C_INT), value, intent(IN) :: x
            integer(C_INT), value, intent(IN) :: y
            integer(C_INT), value, intent(IN) :: z
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_create_cstruct_as_subclass_args_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  Cstruct_as_subclass *Return_Cstruct_as_subclass_args
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  int x
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int y
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int z
    ! Statement: f_in_native
    interface
        subroutine c_return_cstruct_as_subclass_args_bufferify(x, y, z, &
                SHT_rv) &
                bind(C, name="STR_Return_Cstruct_as_subclass_args_bufferify")
            use iso_c_binding, only : C_INT
            import :: STR_SHROUD_capsule_data
            implicit none
            integer(C_INT), value, intent(IN) :: x
            integer(C_INT), value, intent(IN) :: y
            integer(C_INT), value, intent(IN) :: z
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_return_cstruct_as_subclass_args_bufferify
    end interface

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  const double *Cstruct_ptr_get_const_dvalue +intent(getter)
    ! Statement: f_getter_native*_pointer
    ! ----------------------------------------
    ! Argument:  Cstruct_ptr *SH_this +intent(in)
    ! Statement: f_in_struct*
    interface
        function cstruct_ptr_get_const_dvalue(SH_this) &
                result(SHT_rv) &
                bind(C, name="STR_Cstruct_ptr_get_const_dvalue")
            use iso_c_binding, only : C_DOUBLE
            import :: cstruct_ptr
            implicit none
            type(cstruct_ptr), intent(IN) :: SH_this
            real(C_DOUBLE) :: SHT_rv
        end function cstruct_ptr_get_const_dvalue
    end interface

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void Cstruct_ptr_set_const_dvalue +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  Cstruct_ptr *SH_this
    ! Statement: f_inout_struct*
    ! ----------------------------------------
    ! Argument:  const double *val +intent(setter)
    ! Statement: f_setter_native*
    interface
        subroutine cstruct_ptr_set_const_dvalue(SH_this, val) &
                bind(C, name="STR_Cstruct_ptr_set_const_dvalue")
            use iso_c_binding, only : C_DOUBLE
            import :: cstruct_ptr
            implicit none
            type(cstruct_ptr), intent(INOUT) :: SH_this
            real(C_DOUBLE), intent(IN) :: val
        end subroutine cstruct_ptr_set_const_dvalue
    end interface

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int *Cstruct_list_get_ivalue +dimension(nitems+nitems)+intent(getter)
    ! Statement: f_getter_native*_cdesc_pointer
    ! ----------------------------------------
    ! Argument:  Cstruct_list *SH_this +intent(in)
    ! Statement: f_in_struct*
    interface
        subroutine c_cstruct_list_get_ivalue(SH_this, SHT_rv_cdesc) &
                bind(C, name="STR_Cstruct_list_get_ivalue")
            import :: STR_SHROUD_array, cstruct_list
            implicit none
            type(cstruct_list), intent(IN) :: SH_this
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_cstruct_list_get_ivalue
    end interface

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void Cstruct_list_set_ivalue +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  Cstruct_list *SH_this
    ! Statement: f_inout_struct*
    ! ----------------------------------------
    ! Argument:  int *val +intent(setter)+rank(1)
    ! Statement: f_setter_native*
    interface
        subroutine cstruct_list_set_ivalue(SH_this, val) &
                bind(C, name="STR_Cstruct_list_set_ivalue")
            use iso_c_binding, only : C_INT
            import :: cstruct_list
            implicit none
            type(cstruct_list), intent(INOUT) :: SH_this
            integer(C_INT), intent(IN) :: val(*)
        end subroutine cstruct_list_set_ivalue
    end interface

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  double *Cstruct_list_get_dvalue +dimension(nitems*TWO)+intent(getter)
    ! Statement: f_getter_native*_cdesc_pointer
    ! ----------------------------------------
    ! Argument:  Cstruct_list *SH_this +intent(in)
    ! Statement: f_in_struct*
    interface
        subroutine c_cstruct_list_get_dvalue(SH_this, SHT_rv_cdesc) &
                bind(C, name="STR_Cstruct_list_get_dvalue")
            import :: STR_SHROUD_array, cstruct_list
            implicit none
            type(cstruct_list), intent(IN) :: SH_this
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_cstruct_list_get_dvalue
    end interface

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void Cstruct_list_set_dvalue +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  Cstruct_list *SH_this
    ! Statement: f_inout_struct*
    ! ----------------------------------------
    ! Argument:  double *val +intent(setter)+rank(1)
    ! Statement: f_setter_native*
    interface
        subroutine cstruct_list_set_dvalue(SH_this, val) &
                bind(C, name="STR_Cstruct_list_set_dvalue")
            use iso_c_binding, only : C_DOUBLE
            import :: cstruct_list
            implicit none
            type(cstruct_list), intent(INOUT) :: SH_this
            real(C_DOUBLE), intent(IN) :: val(*)
        end subroutine cstruct_list_set_dvalue
    end interface

    ! start generic interface cstruct_as_class
    interface cstruct_as_class
        module procedure create_cstruct_as_class
        module procedure create_cstruct_as_class_args
    end interface cstruct_as_class
    ! end generic interface cstruct_as_class

    interface cstruct_as_subclass
        module procedure create_cstruct_as_subclass_args
    end interface cstruct_as_subclass

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_x1 +intent(getter)
    ! Statement: f_getter_native
    ! start cstruct_as_class_get_x1
    function cstruct_as_class_get_x1(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(cstruct_as_class), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Cstruct_as_class.method.get_x1
        SHT_rv = c_cstruct_as_class_get_x1(obj%cxxmem)
        ! splicer end class.Cstruct_as_class.method.get_x1
    end function cstruct_as_class_get_x1
    ! end cstruct_as_class_get_x1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_x1 +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start cstruct_as_class_set_x1
    subroutine cstruct_as_class_set_x1(obj, val)
        use iso_c_binding, only : C_INT
        class(cstruct_as_class), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: val
        ! splicer begin class.Cstruct_as_class.method.set_x1
        call c_cstruct_as_class_set_x1(obj%cxxmem, val)
        ! splicer end class.Cstruct_as_class.method.set_x1
    end subroutine cstruct_as_class_set_x1
    ! end cstruct_as_class_set_x1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_y1 +intent(getter)
    ! Statement: f_getter_native
    ! start cstruct_as_class_get_y1
    function cstruct_as_class_get_y1(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(cstruct_as_class), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Cstruct_as_class.method.get_y1
        SHT_rv = c_cstruct_as_class_get_y1(obj%cxxmem)
        ! splicer end class.Cstruct_as_class.method.get_y1
    end function cstruct_as_class_get_y1
    ! end cstruct_as_class_get_y1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_y1 +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start cstruct_as_class_set_y1
    subroutine cstruct_as_class_set_y1(obj, val)
        use iso_c_binding, only : C_INT
        class(cstruct_as_class), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: val
        ! splicer begin class.Cstruct_as_class.method.set_y1
        call c_cstruct_as_class_set_y1(obj%cxxmem, val)
        ! splicer end class.Cstruct_as_class.method.set_y1
    end subroutine cstruct_as_class_set_y1
    ! end cstruct_as_class_set_y1

    ! splicer begin class.Cstruct_as_class.additional_functions
    ! splicer end class.Cstruct_as_class.additional_functions

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_x1 +intent(getter)
    ! Statement: f_getter_native
    ! start cstruct_as_subclass_get_x1
    function cstruct_as_subclass_get_x1(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(cstruct_as_subclass), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Cstruct_as_subclass.method.get_x1
        SHT_rv = c_cstruct_as_subclass_get_x1(obj%cxxmem)
        ! splicer end class.Cstruct_as_subclass.method.get_x1
    end function cstruct_as_subclass_get_x1
    ! end cstruct_as_subclass_get_x1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_x1 +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start cstruct_as_subclass_set_x1
    subroutine cstruct_as_subclass_set_x1(obj, val)
        use iso_c_binding, only : C_INT
        class(cstruct_as_subclass), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: val
        ! splicer begin class.Cstruct_as_subclass.method.set_x1
        call c_cstruct_as_subclass_set_x1(obj%cxxmem, val)
        ! splicer end class.Cstruct_as_subclass.method.set_x1
    end subroutine cstruct_as_subclass_set_x1
    ! end cstruct_as_subclass_set_x1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_y1 +intent(getter)
    ! Statement: f_getter_native
    ! start cstruct_as_subclass_get_y1
    function cstruct_as_subclass_get_y1(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(cstruct_as_subclass), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Cstruct_as_subclass.method.get_y1
        SHT_rv = c_cstruct_as_subclass_get_y1(obj%cxxmem)
        ! splicer end class.Cstruct_as_subclass.method.get_y1
    end function cstruct_as_subclass_get_y1
    ! end cstruct_as_subclass_get_y1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_y1 +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start cstruct_as_subclass_set_y1
    subroutine cstruct_as_subclass_set_y1(obj, val)
        use iso_c_binding, only : C_INT
        class(cstruct_as_subclass), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: val
        ! splicer begin class.Cstruct_as_subclass.method.set_y1
        call c_cstruct_as_subclass_set_y1(obj%cxxmem, val)
        ! splicer end class.Cstruct_as_subclass.method.set_y1
    end subroutine cstruct_as_subclass_set_y1
    ! end cstruct_as_subclass_set_y1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_z1 +intent(getter)
    ! Statement: f_getter_native
    ! start cstruct_as_subclass_get_z1
    function cstruct_as_subclass_get_z1(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(cstruct_as_subclass), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Cstruct_as_subclass.method.get_z1
        SHT_rv = c_cstruct_as_subclass_get_z1(obj%cxxmem)
        ! splicer end class.Cstruct_as_subclass.method.get_z1
    end function cstruct_as_subclass_get_z1
    ! end cstruct_as_subclass_get_z1

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void set_z1 +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  int val +intent(setter)
    ! Statement: f_setter_native
    ! start cstruct_as_subclass_set_z1
    subroutine cstruct_as_subclass_set_z1(obj, val)
        use iso_c_binding, only : C_INT
        class(cstruct_as_subclass), intent(INOUT) :: obj
        integer(C_INT), value, intent(IN) :: val
        ! splicer begin class.Cstruct_as_subclass.method.set_z1
        call c_cstruct_as_subclass_set_z1(obj%cxxmem, val)
        ! splicer end class.Cstruct_as_subclass.method.set_z1
    end subroutine cstruct_as_subclass_set_z1
    ! end cstruct_as_subclass_set_z1

    ! splicer begin class.Cstruct_as_subclass.additional_functions
    ! splicer end class.Cstruct_as_subclass.additional_functions

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int passStructByValue
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  Cstruct1 arg
    ! Statement: f_in_struct
    ! start pass_struct_by_value
    function pass_struct_by_value(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        type(cstruct1), value, intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.pass_struct_by_value
        SHT_rv = c_pass_struct_by_value(arg)
        ! splicer end function.pass_struct_by_value
    end function pass_struct_by_value
    ! end pass_struct_by_value
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int passStruct1
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const Cstruct1 *arg
    ! Statement: f_in_struct*
    ! start pass_struct1
    function pass_struct1(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        type(cstruct1), intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.pass_struct1
        SHT_rv = c_pass_struct1(arg)
        ! splicer end function.pass_struct1
    end function pass_struct1
    ! end pass_struct1
#endif

    ! ----------------------------------------
    ! Function:  int passStruct2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const Cstruct1 *s1
    ! Statement: f_in_struct*
    ! ----------------------------------------
    ! Argument:  char *outbuf +charlen(LENOUTBUF)+intent(out)
    ! Statement: f_out_char*_buf
    !>
    !! Pass name argument which will build a bufferify function.
    !<
    function pass_struct2(s1, outbuf) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        type(cstruct1), intent(IN) :: s1
        character(len=*), intent(OUT) :: outbuf
        integer(C_INT) :: SHT_rv
        ! splicer begin function.pass_struct2
        integer(C_INT) SHT_outbuf_len
        SHT_outbuf_len = len(outbuf, kind=C_INT)
        SHT_rv = c_pass_struct2_bufferify(s1, outbuf, SHT_outbuf_len)
        ! splicer end function.pass_struct2
    end function pass_struct2

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int acceptStructInPtr
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  Cstruct1 *arg +intent(in)
    ! Statement: f_in_struct*
    function accept_struct_in_ptr(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        type(cstruct1), intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.accept_struct_in_ptr
        SHT_rv = c_accept_struct_in_ptr(arg)
        ! splicer end function.accept_struct_in_ptr
    end function accept_struct_in_ptr
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void acceptStructOutPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  Cstruct1 *arg +intent(out)
    ! Statement: f_out_struct*
    ! ----------------------------------------
    ! Argument:  int i
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  double d
    ! Statement: f_in_native
    !>
    !! Pass name argument which will build a bufferify function.
    !<
    subroutine accept_struct_out_ptr(arg, i, d)
        use iso_c_binding, only : C_DOUBLE, C_INT
        type(cstruct1), intent(OUT) :: arg
        integer(C_INT), value, intent(IN) :: i
        real(C_DOUBLE), value, intent(IN) :: d
        ! splicer begin function.accept_struct_out_ptr
        call c_accept_struct_out_ptr(arg, i, d)
        ! splicer end function.accept_struct_out_ptr
    end subroutine accept_struct_out_ptr
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void acceptStructInOutPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  Cstruct1 *arg +intent(inout)
    ! Statement: f_inout_struct*
    subroutine accept_struct_in_out_ptr(arg)
        type(cstruct1), intent(INOUT) :: arg
        ! splicer begin function.accept_struct_in_out_ptr
        call c_accept_struct_in_out_ptr(arg)
        ! splicer end function.accept_struct_in_out_ptr
    end subroutine accept_struct_in_out_ptr
#endif

    ! ----------------------------------------
    ! Function:  Cstruct1 returnStructByValue
    ! Statement: f_function_struct
    ! ----------------------------------------
    ! Argument:  int i
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  double d
    ! Statement: f_in_native
    function return_struct_by_value(i, d) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_INT
        integer(C_INT), value, intent(IN) :: i
        real(C_DOUBLE), value, intent(IN) :: d
        type(cstruct1) :: SHT_rv
        ! splicer begin function.return_struct_by_value
        call c_return_struct_by_value_bufferify(i, d, SHT_rv)
        ! splicer end function.return_struct_by_value
    end function return_struct_by_value

    ! ----------------------------------------
    ! Function:  Cstruct1 *returnStructPtr1
    ! Statement: f_function_struct*_cdesc_pointer
    ! ----------------------------------------
    ! Argument:  int i
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  double d
    ! Statement: f_in_native
    !>
    !! \brief Return a pointer to a struct
    !!
    !! Does not generate a bufferify C wrapper.
    !<
    function return_struct_ptr1(i, d) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_INT, c_f_pointer
        integer(C_INT), value, intent(IN) :: i
        real(C_DOUBLE), value, intent(IN) :: d
        type(cstruct1), pointer :: SHT_rv
        ! splicer begin function.return_struct_ptr1
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        call c_return_struct_ptr1_bufferify(i, d, SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv)
        ! splicer end function.return_struct_ptr1
    end function return_struct_ptr1

    ! ----------------------------------------
    ! Function:  Cstruct1 *returnStructPtr2
    ! Statement: f_function_struct*_cdesc_pointer
    ! ----------------------------------------
    ! Argument:  int i
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  double d
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  char *outbuf +charlen(LENOUTBUF)+intent(out)
    ! Statement: f_out_char*_buf
    !>
    !! \brief Return a pointer to a struct
    !!
    !! Generates a bufferify C wrapper function.
    !<
    function return_struct_ptr2(i, d, outbuf) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, C_INT, c_f_pointer
        integer(C_INT), value, intent(IN) :: i
        real(C_DOUBLE), value, intent(IN) :: d
        character(len=*), intent(OUT) :: outbuf
        type(cstruct1), pointer :: SHT_rv
        ! splicer begin function.return_struct_ptr2
        integer(C_INT) SHT_outbuf_len
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        SHT_outbuf_len = len(outbuf, kind=C_INT)
        call c_return_struct_ptr2_bufferify(i, d, outbuf, &
            SHT_outbuf_len, SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv)
        ! splicer end function.return_struct_ptr2
    end function return_struct_ptr2

    ! ----------------------------------------
    ! Function:  Cstruct1 *returnStructPtrArray +dimension(2)
    ! Statement: f_function_struct*_cdesc_pointer
    !>
    !! \brief Return a pointer to an array of structs
    !!
    !<
    function return_struct_ptr_array() &
            result(SHT_rv)
        use iso_c_binding, only : c_f_pointer
        type(cstruct1), pointer :: SHT_rv(:)
        ! splicer begin function.return_struct_ptr_array
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        call c_return_struct_ptr_array_bufferify(SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end function.return_struct_ptr_array
    end function return_struct_ptr_array

    ! ----------------------------------------
    ! Function:  Cstruct_list *get_global_struct_list
    ! Statement: f_function_struct*_cdesc_pointer
    function get_global_struct_list() &
            result(SHT_rv)
        use iso_c_binding, only : c_f_pointer
        type(cstruct_list), pointer :: SHT_rv
        ! splicer begin function.get_global_struct_list
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        call c_get_global_struct_list_bufferify(SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv)
        ! splicer end function.get_global_struct_list
    end function get_global_struct_list

    ! ----------------------------------------
    ! Function:  Cstruct_as_class *Create_Cstruct_as_class
    ! Statement: f_function_shadow*_capsule
    ! start create_cstruct_as_class
    function create_cstruct_as_class() &
            result(SHT_rv)
        type(cstruct_as_class) :: SHT_rv
        ! splicer begin function.create_cstruct_as_class
        call c_create_cstruct_as_class_bufferify(SHT_rv%cxxmem)
        ! splicer end function.create_cstruct_as_class
    end function create_cstruct_as_class
    ! end create_cstruct_as_class

    ! ----------------------------------------
    ! Function:  Cstruct_as_class *Create_Cstruct_as_class_args
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  int x
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int y
    ! Statement: f_in_native
    function create_cstruct_as_class_args(x, y) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: x
        integer(C_INT), value, intent(IN) :: y
        type(cstruct_as_class) :: SHT_rv
        ! splicer begin function.create_cstruct_as_class_args
        call c_create_cstruct_as_class_args_bufferify(x, y, &
            SHT_rv%cxxmem)
        ! splicer end function.create_cstruct_as_class_args
    end function create_cstruct_as_class_args

    ! ----------------------------------------
    ! Function:  Cstruct_as_class *Return_Cstruct_as_class
    ! Statement: f_function_shadow*_capsule
    function return_cstruct_as_class() &
            result(SHT_rv)
        type(cstruct_as_class) :: SHT_rv
        ! splicer begin function.return_cstruct_as_class
        call c_return_cstruct_as_class_bufferify(SHT_rv%cxxmem)
        ! splicer end function.return_cstruct_as_class
    end function return_cstruct_as_class

    ! ----------------------------------------
    ! Function:  Cstruct_as_class *Return_Cstruct_as_class_args
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  int x
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int y
    ! Statement: f_in_native
    function return_cstruct_as_class_args(x, y) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: x
        integer(C_INT), value, intent(IN) :: y
        type(cstruct_as_class) :: SHT_rv
        ! splicer begin function.return_cstruct_as_class_args
        call c_return_cstruct_as_class_args_bufferify(x, y, &
            SHT_rv%cxxmem)
        ! splicer end function.return_cstruct_as_class_args
    end function return_cstruct_as_class_args

    ! ----------------------------------------
    ! Function:  int Cstruct_as_class_sum
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const Cstruct_as_class *point +pass
    ! Statement: f_in_shadow*
    function cstruct_as_class_sum(point) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(cstruct_as_class), intent(IN) :: point
        integer(C_INT) :: SHT_rv
        ! splicer begin function.sum
        SHT_rv = c_cstruct_as_class_sum_bufferify(point%cxxmem)
        ! splicer end function.sum
    end function cstruct_as_class_sum

    ! ----------------------------------------
    ! Function:  Cstruct_as_subclass *Create_Cstruct_as_subclass_args
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  int x
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int y
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int z
    ! Statement: f_in_native
    function create_cstruct_as_subclass_args(x, y, z) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: x
        integer(C_INT), value, intent(IN) :: y
        integer(C_INT), value, intent(IN) :: z
        type(cstruct_as_subclass) :: SHT_rv
        ! splicer begin function.create_cstruct_as_subclass_args
        call c_create_cstruct_as_subclass_args_bufferify(x, y, z, &
            SHT_rv%cxxmem)
        ! splicer end function.create_cstruct_as_subclass_args
    end function create_cstruct_as_subclass_args

    ! ----------------------------------------
    ! Function:  Cstruct_as_subclass *Return_Cstruct_as_subclass_args
    ! Statement: f_function_shadow*_capsule
    ! ----------------------------------------
    ! Argument:  int x
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int y
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int z
    ! Statement: f_in_native
    function return_cstruct_as_subclass_args(x, y, z) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: x
        integer(C_INT), value, intent(IN) :: y
        integer(C_INT), value, intent(IN) :: z
        type(cstruct_as_subclass) :: SHT_rv
        ! splicer begin function.return_cstruct_as_subclass_args
        call c_return_cstruct_as_subclass_args_bufferify(x, y, z, &
            SHT_rv%cxxmem)
        ! splicer end function.return_cstruct_as_subclass_args
    end function return_cstruct_as_subclass_args

#if 0
    ! Only the interface is needed
    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  const double *Cstruct_ptr_get_const_dvalue +intent(getter)
    ! Statement: f_getter_native*_pointer
    ! ----------------------------------------
    ! Argument:  Cstruct_ptr *SH_this +intent(in)
    ! Statement: f_in_struct*
    function cstruct_ptr_get_const_dvalue(SH_this) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE
        type(cstruct_ptr), intent(IN) :: SH_this
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin function.cstruct_ptr_get_const_dvalue
        SHT_rv = c_cstruct_ptr_get_const_dvalue(SH_this)
        ! splicer end function.cstruct_ptr_get_const_dvalue
    end function cstruct_ptr_get_const_dvalue
#endif

#if 0
    ! Only the interface is needed
    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void Cstruct_ptr_set_const_dvalue +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  Cstruct_ptr *SH_this
    ! Statement: f_inout_struct*
    ! ----------------------------------------
    ! Argument:  const double *val +intent(setter)
    ! Statement: f_setter_native*
    subroutine cstruct_ptr_set_const_dvalue(SH_this, val)
        use iso_c_binding, only : C_DOUBLE
        type(cstruct_ptr), intent(INOUT) :: SH_this
        real(C_DOUBLE), intent(IN) :: val
        ! splicer begin function.cstruct_ptr_set_const_dvalue
        call c_cstruct_ptr_set_const_dvalue(SH_this, val)
        ! splicer end function.cstruct_ptr_set_const_dvalue
    end subroutine cstruct_ptr_set_const_dvalue
#endif

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int *Cstruct_list_get_ivalue +dimension(nitems+nitems)+intent(getter)
    ! Statement: f_getter_native*_cdesc_pointer
    ! ----------------------------------------
    ! Argument:  Cstruct_list *SH_this +intent(in)
    ! Statement: f_in_struct*
    function cstruct_list_get_ivalue(SH_this) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, c_f_pointer
        type(cstruct_list), intent(IN) :: SH_this
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin function.cstruct_list_get_ivalue
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        call c_cstruct_list_get_ivalue(SH_this, SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end function.cstruct_list_get_ivalue
    end function cstruct_list_get_ivalue

#if 0
    ! Only the interface is needed
    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void Cstruct_list_set_ivalue +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  Cstruct_list *SH_this
    ! Statement: f_inout_struct*
    ! ----------------------------------------
    ! Argument:  int *val +intent(setter)+rank(1)
    ! Statement: f_setter_native*
    subroutine cstruct_list_set_ivalue(SH_this, val)
        use iso_c_binding, only : C_INT
        type(cstruct_list), intent(INOUT) :: SH_this
        integer(C_INT), intent(IN) :: val(:)
        ! splicer begin function.cstruct_list_set_ivalue
        call c_cstruct_list_set_ivalue(SH_this, val)
        ! splicer end function.cstruct_list_set_ivalue
    end subroutine cstruct_list_set_ivalue
#endif

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  double *Cstruct_list_get_dvalue +dimension(nitems*TWO)+intent(getter)
    ! Statement: f_getter_native*_cdesc_pointer
    ! ----------------------------------------
    ! Argument:  Cstruct_list *SH_this +intent(in)
    ! Statement: f_in_struct*
    function cstruct_list_get_dvalue(SH_this) &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE, c_f_pointer
        type(cstruct_list), intent(IN) :: SH_this
        real(C_DOUBLE), pointer :: SHT_rv(:)
        ! splicer begin function.cstruct_list_get_dvalue
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        call c_cstruct_list_get_dvalue(SH_this, SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end function.cstruct_list_get_dvalue
    end function cstruct_list_get_dvalue

#if 0
    ! Only the interface is needed
    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void Cstruct_list_set_dvalue +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  Cstruct_list *SH_this
    ! Statement: f_inout_struct*
    ! ----------------------------------------
    ! Argument:  double *val +intent(setter)+rank(1)
    ! Statement: f_setter_native*
    subroutine cstruct_list_set_dvalue(SH_this, val)
        use iso_c_binding, only : C_DOUBLE
        type(cstruct_list), intent(INOUT) :: SH_this
        real(C_DOUBLE), intent(IN) :: val(:)
        ! splicer begin function.cstruct_list_set_dvalue
        call c_cstruct_list_set_dvalue(SH_this, val)
        ! splicer end function.cstruct_list_set_dvalue
    end subroutine cstruct_list_set_dvalue
#endif

    ! splicer begin additional_functions
    ! splicer end additional_functions

    function cstruct_as_class_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(cstruct_as_class), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function cstruct_as_class_eq

    function cstruct_as_class_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(cstruct_as_class), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function cstruct_as_class_ne

    function cstruct_as_subclass_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(cstruct_as_subclass), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function cstruct_as_subclass_eq

    function cstruct_as_subclass_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(cstruct_as_subclass), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function cstruct_as_subclass_ne

end module struct_mod
