// wrapstrings.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "strings.hpp"
#include "shroud/features.h"
// typemap
#include <string>
// shroud
#include <cstring>
#include <cstddef>
#include <cstdlib>
#include "wrapstrings.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {


// helper char_len_trim
// Returns the length of character string src with length nsrc,
// ignoring any trailing blanks.
static int ShroudCharLenTrim(const char *src, int nsrc) {
    int i;

    for (i = nsrc - 1; i >= 0; i--) {
        if (src[i] != ' ') {
            break;
        }
    }

    return i + 1;
}


// helper char_alloc
// Copy src into new memory and null terminate.
// If ntrim is 0, return NULL pointer.
// If blanknull is 1, return NULL when string is blank.
static char *ShroudCharAlloc(const char *src, int nsrc, int blanknull)
{
    int ntrim = ShroudCharLenTrim(src, nsrc);
    if (ntrim == 0 && blanknull == 1) {
        return nullptr;
    }
    char *rv = (char *) std::malloc(nsrc + 1);
    if (ntrim > 0) {
        std::memcpy(rv, src, ntrim);
    }
    rv[ntrim] = '\0';
    return rv;
}

// helper char_blank_fill
// blank fill dest starting at trailing NULL.
static void ShroudCharBlankFill(char *dest, int ndest)
{
    int nm = std::strlen(dest);
    if(ndest > nm) std::memset(dest+nm,' ',ndest-nm);
}

// helper ShroudCharCopy
// Copy src into dest, blank fill to ndest characters
// Truncate if dest is too short.
// dest will not be NULL terminated.
static void ShroudCharCopy(char *dest, int ndest, const char *src, int nsrc)
{
    if (src == NULL) {
        std::memset(dest,' ',ndest); // convert NULL pointer to blank filled string
    } else {
        if (nsrc < 0) nsrc = std::strlen(src);
        int nm = nsrc < ndest ? nsrc : ndest;
        std::memcpy(dest,src,nm);
        if(ndest > nm) std::memset(dest+nm,' ',ndest-nm); // blank fill
    }
}

// helper char_free
// Release memory allocated by ShroudCharAlloc
static void ShroudCharFree(char *src)
{
    if (src != NULL) {
        std::free(src);
    }
}

// start helper string_to_cdesc
// helper string_to_cdesc
// Save std::string metadata into array to allow Fortran to access values.
// CHARACTER(len=elem_size) src
static void ShroudStringToCdesc(STR_SHROUD_array *cdesc,
    const std::string * src)
{
    if (src->empty()) {
        cdesc->base_addr = NULL;
        cdesc->elem_len = 0;
    } else {
        cdesc->base_addr = const_cast<char *>(src->data());
        cdesc->elem_len = src->length();
    }
    cdesc->size = 1;
    cdesc->rank = 0;  // scalar
}
// end helper string_to_cdesc

// splicer begin C_definitions
// splicer end C_definitions

// ----------------------------------------
// Function:  void init_test
// Statement: c_subroutine
void STR_init_test(void)
{
    // splicer begin function.init_test
    init_test();
    // splicer end function.init_test
}

/**
 * \brief pass a single char argument as a scalar.
 *
 */
// ----------------------------------------
// Function:  void passChar
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char status
// Statement: c_in_char
void STR_passChar(char status)
{
    // splicer begin function.passChar
    passChar(status);
    // splicer end function.passChar
}

/**
 * By default no Fortran wrapper is created.
 * Force one so it can be tested.
 */
// ----------------------------------------
// Function:  void passCharForce
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char status
// Statement: c_in_char
void STR_passCharForce(char status)
{
    // splicer begin function.passCharForce
    passCharForce(status);
    // splicer end function.passCharForce
}

/**
 * \brief return a char argument (non-pointer)
 *
 */
// ----------------------------------------
// Function:  char returnChar
// Statement: c_function_char
void STR_returnChar(char *SHC_rv)
{
    // splicer begin function.returnChar
    *SHC_rv = returnChar();
    // splicer end function.returnChar
}

/**
 * \brief strcpy like behavior
 *
 * dest is marked intent(OUT) to override the intent(INOUT) default
 * This avoid a copy-in on dest.
 * In Python, src must not be over 40 characters, defined by charlen.
 */
// ----------------------------------------
// Function:  void passCharPtr
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *dest +charlen(40)+intent(out)
// Statement: c_out_char*
// ----------------------------------------
// Argument:  const char *src
// Statement: c_in_char*
// start STR_passCharPtr
void STR_passCharPtr(char *dest, const char *src)
{
    // splicer begin function.passCharPtr
    passCharPtr(dest, src);
    // splicer end function.passCharPtr
}
// end STR_passCharPtr

/**
 * \brief strcpy like behavior
 *
 * dest is marked intent(OUT) to override the intent(INOUT) default
 * This avoid a copy-in on dest.
 * In Python, src must not be over 40 characters, defined by charlen.
 */
// ----------------------------------------
// Function:  void passCharPtr
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *dest +charlen(40)+intent(out)
// Statement: f_out_char*_buf
// ----------------------------------------
// Argument:  const char *src
// Statement: f_in_char*
// start STR_passCharPtr_bufferify
void STR_passCharPtr_bufferify(char *dest, int SHT_dest_len,
    const char *src)
{
    // splicer begin function.passCharPtr_bufferify
    passCharPtr(dest, src);
    ShroudCharBlankFill(dest, SHT_dest_len);
    // splicer end function.passCharPtr_bufferify
}
// end STR_passCharPtr_bufferify

/**
 * \brief toupper
 *
 * Change a string in-place.
 * For Python, return a new string since strings are immutable.
 */
// ----------------------------------------
// Function:  void passCharPtrInOut
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *s +intent(inout)
// Statement: c_inout_char*
void STR_passCharPtrInOut(char *s)
{
    // splicer begin function.passCharPtrInOut
    passCharPtrInOut(s);
    // splicer end function.passCharPtrInOut
}

/**
 * \brief toupper
 *
 * Change a string in-place.
 * For Python, return a new string since strings are immutable.
 */
// ----------------------------------------
// Function:  void passCharPtrInOut
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *s +intent(inout)
// Statement: f_inout_char*_buf
void STR_passCharPtrInOut_bufferify(char *s, int SHT_s_len)
{
    // splicer begin function.passCharPtrInOut_bufferify
    char * SHT_s_str = ShroudCharAlloc(s, SHT_s_len, 0);
    passCharPtrInOut(SHT_s_str);
    ShroudCharCopy(s, SHT_s_len, SHT_s_str, -1);
    ShroudCharFree(SHT_s_str);
    // splicer end function.passCharPtrInOut_bufferify
}

/**
 * \brief return a 'const char *' as character(*)
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr1
// Statement: c_function_char*
// start STR_getCharPtr1
const char * STR_getCharPtr1(void)
{
    // splicer begin function.getCharPtr1
    const char *SHC_rv = getCharPtr1();
    return SHC_rv;
    // splicer end function.getCharPtr1
}
// end STR_getCharPtr1

/**
 * \brief return a 'const char *' as character(*)
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr1
// Statement: f_function_char*_cdesc_allocatable
// start STR_getCharPtr1_bufferify
void STR_getCharPtr1_bufferify(STR_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.getCharPtr1_bufferify
    const char *SHC_rv = getCharPtr1();
    SHT_rv_cdesc->base_addr = const_cast<char *>(SHC_rv);
    SHT_rv_cdesc->type = SH_TYPE_OTHER;
    SHT_rv_cdesc->elem_len = SHC_rv == nullptr ? 0 : std::strlen(SHC_rv);
    SHT_rv_cdesc->size = 1;
    SHT_rv_cdesc->rank = 0;
    // splicer end function.getCharPtr1_bufferify
}
// end STR_getCharPtr1_bufferify

/**
 * \brief return 'const char *' with fixed size (len=30)
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr2 +len(30)
// Statement: c_function_char*
// start STR_getCharPtr2
const char * STR_getCharPtr2(void)
{
    // splicer begin function.getCharPtr2
    const char *SHC_rv = getCharPtr2();
    return SHC_rv;
    // splicer end function.getCharPtr2
}
// end STR_getCharPtr2

/**
 * \brief return 'const char *' with fixed size (len=30)
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr2 +len(30)
// Statement: f_function_char*_buf_copy
// start STR_getCharPtr2_bufferify
void STR_getCharPtr2_bufferify(char *SHC_rv, int SHT_rv_len)
{
    // splicer begin function.getCharPtr2_bufferify
    const char *SHC_rv_cxx = getCharPtr2();
    ShroudCharCopy(SHC_rv, SHT_rv_len, SHC_rv_cxx, -1);
    // splicer end function.getCharPtr2_bufferify
}
// end STR_getCharPtr2_bufferify

/**
 * \brief return a 'const char *' as argument
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr3
// Statement: c_function_char*
// start STR_getCharPtr3
const char * STR_getCharPtr3(void)
{
    // splicer begin function.getCharPtr3
    const char *SHC_rv = getCharPtr3();
    return SHC_rv;
    // splicer end function.getCharPtr3
}
// end STR_getCharPtr3

/**
 * \brief return a 'const char *' as argument
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr3
// Statement: f_function_char*_buf_arg
// start STR_getCharPtr3_bufferify
void STR_getCharPtr3_bufferify(char *output, int noutput)
{
    // splicer begin function.getCharPtr3_bufferify
    const char *SHC_rv_cxx = getCharPtr3();
    ShroudCharCopy(output, noutput, SHC_rv_cxx, -1);
    // splicer end function.getCharPtr3_bufferify
}
// end STR_getCharPtr3_bufferify

/**
 * \brief return a 'const char *' as type(C_PTR)
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr4 +deref(raw)
// Statement: c_function_char*
const char * STR_getCharPtr4(void)
{
    // splicer begin function.getCharPtr4
    const char *SHC_rv = getCharPtr4();
    return SHC_rv;
    // splicer end function.getCharPtr4
}

/**
 * \brief return a 'const char *' as character(:) pointer
 *
 */
#ifdef HAVE_CHARACTER_POINTER_FUNCTION
// ----------------------------------------
// Function:  const char *getCharPtr5 +deref(pointer)
// Statement: c_function_char*
const char * STR_getCharPtr5(void)
{
    // splicer begin function.getCharPtr5
    const char *SHC_rv = getCharPtr5();
    return SHC_rv;
    // splicer end function.getCharPtr5
}
#endif  // ifdef HAVE_CHARACTER_POINTER_FUNCTION

/**
 * \brief return a 'const char *' as character(:) pointer
 *
 */
#ifdef HAVE_CHARACTER_POINTER_FUNCTION
// ----------------------------------------
// Function:  const char *getCharPtr5 +deref(pointer)
// Statement: f_function_char*_cdesc_pointer
void STR_getCharPtr5_bufferify(STR_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.getCharPtr5_bufferify
    const char *SHC_rv = getCharPtr5();
    SHT_rv_cdesc->base_addr = const_cast<char *>(SHC_rv);
    SHT_rv_cdesc->type = SH_TYPE_OTHER;
    SHT_rv_cdesc->elem_len = SHC_rv == nullptr ? 0 : std::strlen(SHC_rv);
    SHT_rv_cdesc->size = 1;
    SHT_rv_cdesc->rank = 0;
    // splicer end function.getCharPtr5_bufferify
}
#endif  // ifdef HAVE_CHARACTER_POINTER_FUNCTION

#if 0
! Not Implemented
/**
 * \brief return an ALLOCATABLE CHARACTER from std::string
 *
 */
// ----------------------------------------
// Function:  const string getConstStringResult
// Statement: c_function_string
const char STR_getConstStringResult(void)
{
    // splicer begin function.getConstStringResult
    const std::string SHCXX_rv = getConstStringResult();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringResult
}
#endif

/**
 * \brief return an ALLOCATABLE CHARACTER from std::string
 *
 */
// ----------------------------------------
// Function:  const string getConstStringResult
// Statement: f_function_string_cdesc_allocatable
void STR_getConstStringResult_bufferify(STR_SHROUD_array *SHT_rv_cdesc,
    STR_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.getConstStringResult_bufferify
    std::string *SHC_rv_cxx = new std::string;
    *SHC_rv_cxx = getConstStringResult();
    // C_error_pattern
    // Some error code for buf

    ShroudStringToCdesc(SHT_rv_cdesc, SHC_rv_cxx);
    SHT_rv_capsule->addr  = const_cast<std::string *>(SHC_rv_cxx);
    SHT_rv_capsule->idtor = 1;
    // splicer end function.getConstStringResult_bufferify
}

#if 0
! Not Implemented
/**
 * \brief return a 'const string' as argument
 *
 */
// ----------------------------------------
// Function:  const string getConstStringLen +len(30)
// Statement: c_function_string
const char STR_getConstStringLen(void)
{
    // splicer begin function.getConstStringLen
    const std::string SHCXX_rv = getConstStringLen();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringLen
}
#endif

/**
 * \brief return a 'const string' as argument
 *
 */
// ----------------------------------------
// Function:  const string getConstStringLen +len(30)
// Statement: f_function_string_buf_copy
void STR_getConstStringLen_bufferify(char *SHC_rv, int SHT_rv_len)
{
    // splicer begin function.getConstStringLen_bufferify
    const std::string SHCXX_rv = getConstStringLen();
    // C_error_pattern
    // Some error code for buf

    if (SHCXX_rv.empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_len, SHCXX_rv.data(),
            SHCXX_rv.size());
    }
    // splicer end function.getConstStringLen_bufferify
}

#if 0
! Not Implemented
/**
 * \brief return a 'const string' as argument
 *
 */
// ----------------------------------------
// Function:  const string getConstStringAsArg
// Statement: c_function_string
const char STR_getConstStringAsArg(void)
{
    // splicer begin function.getConstStringAsArg
    const std::string SHCXX_rv = getConstStringAsArg();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringAsArg
}
#endif

/**
 * \brief return a 'const string' as argument
 *
 */
// ----------------------------------------
// Function:  const string getConstStringAsArg
// Statement: f_function_string_buf_arg
void STR_getConstStringAsArg_bufferify(char *output, int noutput)
{
    // splicer begin function.getConstStringAsArg_bufferify
    const std::string SHCXX_rv = getConstStringAsArg();
    // C_error_pattern
    // Some error code for buf

    if (SHCXX_rv.empty()) {
        ShroudCharCopy(output, noutput, nullptr, 0);
    } else {
        ShroudCharCopy(output, noutput, SHCXX_rv.data(),
            SHCXX_rv.size());
    }
    // splicer end function.getConstStringAsArg_bufferify
}

#if 0
! Not Implemented
// ----------------------------------------
// Function:  const std::string getConstStringAlloc
// Statement: c_function_string
const char STR_getConstStringAlloc(void)
{
    // splicer begin function.getConstStringAlloc
    const std::string SHCXX_rv = getConstStringAlloc();
    const char SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringAlloc
}
#endif

// ----------------------------------------
// Function:  const std::string getConstStringAlloc
// Statement: f_function_string_cdesc_allocatable
void STR_getConstStringAlloc_bufferify(STR_SHROUD_array *SHT_rv_cdesc,
    STR_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.getConstStringAlloc_bufferify
    std::string *SHC_rv_cxx = new std::string;
    *SHC_rv_cxx = getConstStringAlloc();
    ShroudStringToCdesc(SHT_rv_cdesc, SHC_rv_cxx);
    SHT_rv_capsule->addr  = const_cast<std::string *>(SHC_rv_cxx);
    SHT_rv_capsule->idtor = 1;
    // splicer end function.getConstStringAlloc_bufferify
}

/**
 * \brief return a 'const string&' as ALLOCATABLE character
 *
 */
// ----------------------------------------
// Function:  const string &getConstStringRefPure
// Statement: c_function_string&
// start STR_getConstStringRefPure
const char * STR_getConstStringRefPure(void)
{
    // splicer begin function.getConstStringRefPure
    const std::string &SHCXX_rv = getConstStringRefPure();
    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringRefPure
}
// end STR_getConstStringRefPure

/**
 * \brief return a 'const string&' as ALLOCATABLE character
 *
 */
// ----------------------------------------
// Function:  const string &getConstStringRefPure
// Statement: f_function_string&_cdesc_allocatable
// start STR_getConstStringRefPure_bufferify
void STR_getConstStringRefPure_bufferify(STR_SHROUD_array *SHT_rv_cdesc,
    STR_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.getConstStringRefPure_bufferify
    const std::string &SHCXX_rv = getConstStringRefPure();
    ShroudStringToCdesc(SHT_rv_cdesc, &SHCXX_rv);
    SHT_rv_capsule->addr  = const_cast<std::string *>(&SHCXX_rv);
    SHT_rv_capsule->idtor = 0;
    // splicer end function.getConstStringRefPure_bufferify
}
// end STR_getConstStringRefPure_bufferify

/**
 * \brief return 'const string&' with fixed size (len=30)
 *
 * Since +len(30) is provided, the result of the function
 * will be copied directly into memory provided by Fortran.
 * The function will not be ALLOCATABLE.
 */
// ----------------------------------------
// Function:  const string &getConstStringRefLen +len(30)
// Statement: c_function_string&
const char * STR_getConstStringRefLen(void)
{
    // splicer begin function.getConstStringRefLen
    const std::string &SHCXX_rv = getConstStringRefLen();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringRefLen
}

/**
 * \brief return 'const string&' with fixed size (len=30)
 *
 * Since +len(30) is provided, the result of the function
 * will be copied directly into memory provided by Fortran.
 * The function will not be ALLOCATABLE.
 */
// ----------------------------------------
// Function:  const string &getConstStringRefLen +len(30)
// Statement: f_function_string&_buf_copy
void STR_getConstStringRefLen_bufferify(char *SHC_rv, int SHT_rv_len)
{
    // splicer begin function.getConstStringRefLen_bufferify
    const std::string &SHCXX_rv = getConstStringRefLen();
    // C_error_pattern
    // Some error code for buf

    if (SHCXX_rv.empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_len, SHCXX_rv.data(),
            SHCXX_rv.size());
    }
    // splicer end function.getConstStringRefLen_bufferify
}

/**
 * \brief return a 'const string&' as argument
 *
 * Pass an additional argument which will be used as the return value.
 * The length of the output variable is declared by the caller.
 */
// ----------------------------------------
// Function:  const string &getConstStringRefAsArg
// Statement: c_function_string&
const char * STR_getConstStringRefAsArg(void)
{
    // splicer begin function.getConstStringRefAsArg
    const std::string &SHCXX_rv = getConstStringRefAsArg();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringRefAsArg
}

/**
 * \brief return a 'const string&' as argument
 *
 * Pass an additional argument which will be used as the return value.
 * The length of the output variable is declared by the caller.
 */
// ----------------------------------------
// Function:  const string &getConstStringRefAsArg
// Statement: f_function_string&_buf_arg
void STR_getConstStringRefAsArg_bufferify(char *output, int noutput)
{
    // splicer begin function.getConstStringRefAsArg_bufferify
    const std::string &SHCXX_rv = getConstStringRefAsArg();
    // C_error_pattern
    // Some error code for buf

    if (SHCXX_rv.empty()) {
        ShroudCharCopy(output, noutput, nullptr, 0);
    } else {
        ShroudCharCopy(output, noutput, SHCXX_rv.data(),
            SHCXX_rv.size());
    }
    // splicer end function.getConstStringRefAsArg_bufferify
}

/**
 * \brief Test returning empty string reference
 *
 */
// ----------------------------------------
// Function:  const string &getConstStringRefLenEmpty +len(30)
// Statement: c_function_string&
const char * STR_getConstStringRefLenEmpty(void)
{
    // splicer begin function.getConstStringRefLenEmpty
    const std::string &SHCXX_rv = getConstStringRefLenEmpty();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringRefLenEmpty
}

/**
 * \brief Test returning empty string reference
 *
 */
// ----------------------------------------
// Function:  const string &getConstStringRefLenEmpty +len(30)
// Statement: f_function_string&_buf_copy
void STR_getConstStringRefLenEmpty_bufferify(char *SHC_rv,
    int SHT_rv_len)
{
    // splicer begin function.getConstStringRefLenEmpty_bufferify
    const std::string &SHCXX_rv = getConstStringRefLenEmpty();
    // C_error_pattern
    // Some error code for buf

    if (SHCXX_rv.empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_len, SHCXX_rv.data(),
            SHCXX_rv.size());
    }
    // splicer end function.getConstStringRefLenEmpty_bufferify
}

// ----------------------------------------
// Function:  const std::string &getConstStringRefAlloc
// Statement: c_function_string&
const char * STR_getConstStringRefAlloc(void)
{
    // splicer begin function.getConstStringRefAlloc
    const std::string &SHCXX_rv = getConstStringRefAlloc();
    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringRefAlloc
}

// ----------------------------------------
// Function:  const std::string &getConstStringRefAlloc
// Statement: f_function_string&_cdesc_allocatable
void STR_getConstStringRefAlloc_bufferify(
    STR_SHROUD_array *SHT_rv_cdesc,
    STR_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.getConstStringRefAlloc_bufferify
    const std::string &SHCXX_rv = getConstStringRefAlloc();
    ShroudStringToCdesc(SHT_rv_cdesc, &SHCXX_rv);
    SHT_rv_capsule->addr  = const_cast<std::string *>(&SHCXX_rv);
    SHT_rv_capsule->idtor = 0;
    // splicer end function.getConstStringRefAlloc_bufferify
}

/**
 * \brief return a 'const string *' as character(30)
 *
 * It is the caller's responsibility to release the string
 * created by the C++ library.
 * This is accomplished with C_finalize_buf which is possible
 * because +len(30) so the contents are copied before returning.
 */
// ----------------------------------------
// Function:  const string *getConstStringPtrLen +len(30)
// Statement: c_function_string*
const char * STR_getConstStringPtrLen(void)
{
    // splicer begin function.getConstStringPtrLen
    const std::string *SHCXX_rv = getConstStringPtrLen();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrLen
}

/**
 * \brief return a 'const string *' as character(30)
 *
 * It is the caller's responsibility to release the string
 * created by the C++ library.
 * This is accomplished with C_finalize_buf which is possible
 * because +len(30) so the contents are copied before returning.
 */
// ----------------------------------------
// Function:  const string *getConstStringPtrLen +len(30)
// Statement: f_function_string*_buf_copy
void STR_getConstStringPtrLen_bufferify(char *SHC_rv, int SHT_rv_len)
{
    // splicer begin function.getConstStringPtrLen_bufferify
    const std::string *SHCXX_rv = getConstStringPtrLen();
    if (SHCXX_rv->empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_len, SHCXX_rv->data(),
            SHCXX_rv->size());
    }
    {
        // final
        delete SHCXX_rv;
    }
    // splicer end function.getConstStringPtrLen_bufferify
}

// ----------------------------------------
// Function:  const std::string *getConstStringPtrAlloc +owner(library)
// Statement: c_function_string*_library
const char * STR_getConstStringPtrAlloc(void)
{
    // splicer begin function.getConstStringPtrAlloc
    const std::string *SHCXX_rv = getConstStringPtrAlloc();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrAlloc
}

// ----------------------------------------
// Function:  const std::string *getConstStringPtrAlloc +owner(library)
// Statement: f_function_string*_cdesc_allocatable_library
void STR_getConstStringPtrAlloc_bufferify(
    STR_SHROUD_array *SHT_rv_cdesc,
    STR_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.getConstStringPtrAlloc_bufferify
    const std::string *SHCXX_rv = getConstStringPtrAlloc();
    ShroudStringToCdesc(SHT_rv_cdesc, SHCXX_rv);
    SHT_rv_capsule->addr  = const_cast<std::string *>(SHCXX_rv);
    SHT_rv_capsule->idtor = 0;
    // splicer end function.getConstStringPtrAlloc_bufferify
}

/**
 * It is the caller's responsibility to release the string
 * created by the C++ library.
 * This is accomplished +owner(caller) which sets idtor.
 * The contents are copied by Fortran so they must outlast
 * the return from the C wrapper.
 */
// ----------------------------------------
// Function:  const std::string *getConstStringPtrOwnsAlloc +owner(caller)
// Statement: c_function_string*_caller
const char * STR_getConstStringPtrOwnsAlloc(void)
{
    // splicer begin function.getConstStringPtrOwnsAlloc
    const std::string *SHCXX_rv = getConstStringPtrOwnsAlloc();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrOwnsAlloc
}

/**
 * It is the caller's responsibility to release the string
 * created by the C++ library.
 * This is accomplished +owner(caller) which sets idtor.
 * The contents are copied by Fortran so they must outlast
 * the return from the C wrapper.
 */
// ----------------------------------------
// Function:  const std::string *getConstStringPtrOwnsAlloc +owner(caller)
// Statement: f_function_string*_cdesc_allocatable_caller
void STR_getConstStringPtrOwnsAlloc_bufferify(
    STR_SHROUD_array *SHT_rv_cdesc,
    STR_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.getConstStringPtrOwnsAlloc_bufferify
    const std::string *SHCXX_rv = getConstStringPtrOwnsAlloc();
    ShroudStringToCdesc(SHT_rv_cdesc, SHCXX_rv);
    SHT_rv_capsule->addr  = const_cast<std::string *>(SHCXX_rv);
    SHT_rv_capsule->idtor = 2;
    // splicer end function.getConstStringPtrOwnsAlloc_bufferify
}

/**
 * Similar to getConstStringPtrOwnsAlloc, but uses pattern to release memory.
 */
// ----------------------------------------
// Function:  const std::string *getConstStringPtrOwnsAllocPattern +free_pattern(C_string_free)+owner(caller)
// Statement: c_function_string*_caller
const char * STR_getConstStringPtrOwnsAllocPattern(void)
{
    // splicer begin function.getConstStringPtrOwnsAllocPattern
    const std::string *SHCXX_rv = getConstStringPtrOwnsAllocPattern();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrOwnsAllocPattern
}

/**
 * Similar to getConstStringPtrOwnsAlloc, but uses pattern to release memory.
 */
// ----------------------------------------
// Function:  const std::string *getConstStringPtrOwnsAllocPattern +free_pattern(C_string_free)+owner(caller)
// Statement: f_function_string*_cdesc_allocatable_caller
void STR_getConstStringPtrOwnsAllocPattern_bufferify(
    STR_SHROUD_array *SHT_rv_cdesc,
    STR_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.getConstStringPtrOwnsAllocPattern_bufferify
    const std::string *SHCXX_rv = getConstStringPtrOwnsAllocPattern();
    ShroudStringToCdesc(SHT_rv_cdesc, SHCXX_rv);
    SHT_rv_capsule->addr  = const_cast<std::string *>(SHCXX_rv);
    SHT_rv_capsule->idtor = 3;
    // splicer end function.getConstStringPtrOwnsAllocPattern_bufferify
}

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
// ----------------------------------------
// Function:  const std::string *getConstStringPtrPointer +deref(pointer)+owner(library)
// Statement: c_function_string*_library
const char * STR_getConstStringPtrPointer(void)
{
    // splicer begin function.getConstStringPtrPointer
    const std::string *SHCXX_rv = getConstStringPtrPointer();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrPointer
}
#endif  // ifdef HAVE_CHARACTER_POINTER_FUNCTION

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
// ----------------------------------------
// Function:  const std::string *getConstStringPtrPointer +deref(pointer)+owner(library)
// Statement: f_function_string*_cdesc_pointer_library
void STR_getConstStringPtrPointer_bufferify(
    STR_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.getConstStringPtrPointer_bufferify
    const std::string *SHCXX_rv = getConstStringPtrPointer();
    ShroudStringToCdesc(SHT_rv_cdesc, SHCXX_rv);
    // splicer end function.getConstStringPtrPointer_bufferify
}
#endif  // ifdef HAVE_CHARACTER_POINTER_FUNCTION

/**
 * \brief Accept a const string reference
 *
 * Save contents of arg1.
 * arg1 is assumed to be intent(IN) since it is const
 * Will copy in.
 */
// ----------------------------------------
// Function:  void acceptStringConstReference
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const std::string &arg1
// Statement: c_in_string&
void STR_acceptStringConstReference(const char *arg1)
{
    // splicer begin function.acceptStringConstReference
    const std::string SHC_arg1_cxx(arg1);
    acceptStringConstReference(SHC_arg1_cxx);
    // splicer end function.acceptStringConstReference
}

/**
 * \brief Accept a const string reference
 *
 * Save contents of arg1.
 * arg1 is assumed to be intent(IN) since it is const
 * Will copy in.
 */
// ----------------------------------------
// Function:  void acceptStringConstReference
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const std::string &arg1
// Statement: f_in_string&_buf
void STR_acceptStringConstReference_bufferify(char *arg1,
    int SHT_arg1_len)
{
    // splicer begin function.acceptStringConstReference_bufferify
    const std::string SHC_arg1_cxx(arg1,
        ShroudCharLenTrim(arg1, SHT_arg1_len));
    acceptStringConstReference(SHC_arg1_cxx);
    // splicer end function.acceptStringConstReference_bufferify
}

/**
 * \brief Accept a string reference
 *
 * Set out to a constant string.
 * arg1 is intent(OUT)
 * Must copy out.
 */
// ----------------------------------------
// Function:  void acceptStringReferenceOut
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string &arg1 +intent(out)
// Statement: c_out_string&
void STR_acceptStringReferenceOut(char *arg1)
{
    // splicer begin function.acceptStringReferenceOut
    std::string SHC_arg1_cxx;
    acceptStringReferenceOut(SHC_arg1_cxx);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.acceptStringReferenceOut
}

/**
 * \brief Accept a string reference
 *
 * Set out to a constant string.
 * arg1 is intent(OUT)
 * Must copy out.
 */
// ----------------------------------------
// Function:  void acceptStringReferenceOut
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string &arg1 +intent(out)
// Statement: f_out_string&_buf
void STR_acceptStringReferenceOut_bufferify(char *arg1,
    int SHT_arg1_len)
{
    // splicer begin function.acceptStringReferenceOut_bufferify
    std::string SHC_arg1_cxx;
    acceptStringReferenceOut(SHC_arg1_cxx);
    ShroudCharCopy(arg1, SHT_arg1_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.acceptStringReferenceOut_bufferify
}

/**
 * \brief Accept a string reference
 *
 * Append "dog" to the end of arg1.
 * arg1 is assumed to be intent(INOUT)
 * Must copy in and copy out.
 */
// ----------------------------------------
// Function:  void acceptStringReference
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string &arg1
// Statement: c_inout_string&
// start STR_acceptStringReference
void STR_acceptStringReference(char *arg1)
{
    // splicer begin function.acceptStringReference
    std::string SHC_arg1_cxx(arg1);
    acceptStringReference(SHC_arg1_cxx);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.acceptStringReference
}
// end STR_acceptStringReference

/**
 * \brief Accept a string reference
 *
 * Append "dog" to the end of arg1.
 * arg1 is assumed to be intent(INOUT)
 * Must copy in and copy out.
 */
// ----------------------------------------
// Function:  void acceptStringReference
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string &arg1
// Statement: f_inout_string&_buf
// start STR_acceptStringReference_bufferify
void STR_acceptStringReference_bufferify(char *arg1, int SHT_arg1_len)
{
    // splicer begin function.acceptStringReference_bufferify
    std::string SHC_arg1_cxx(arg1,
        ShroudCharLenTrim(arg1, SHT_arg1_len));
    acceptStringReference(SHC_arg1_cxx);
    ShroudCharCopy(arg1, SHT_arg1_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.acceptStringReference_bufferify
}
// end STR_acceptStringReference_bufferify

/**
 * \brief Accept a const string pointer - intent(in)
 *
 */
// ----------------------------------------
// Function:  void acceptStringPointerConst
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const std::string *arg1
// Statement: c_in_string*
void STR_acceptStringPointerConst(const char *arg1)
{
    // splicer begin function.acceptStringPointerConst
    const std::string SHC_arg1_cxx(arg1);
    acceptStringPointerConst(&SHC_arg1_cxx);
    // splicer end function.acceptStringPointerConst
}

/**
 * \brief Accept a const string pointer - intent(in)
 *
 */
// ----------------------------------------
// Function:  void acceptStringPointerConst
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const std::string *arg1
// Statement: f_in_string*_buf
void STR_acceptStringPointerConst_bufferify(char *arg1,
    int SHT_arg1_len)
{
    // splicer begin function.acceptStringPointerConst_bufferify
    const std::string SHC_arg1_cxx(arg1,
        ShroudCharLenTrim(arg1, SHT_arg1_len));
    acceptStringPointerConst(&SHC_arg1_cxx);
    // splicer end function.acceptStringPointerConst_bufferify
}

/**
 * \brief Accept a string pointer - intent(inout)
 *
 */
// ----------------------------------------
// Function:  void acceptStringPointer
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string *arg1
// Statement: c_inout_string*
void STR_acceptStringPointer(char *arg1)
{
    // splicer begin function.acceptStringPointer
    std::string SHC_arg1_cxx(arg1);
    acceptStringPointer(&SHC_arg1_cxx);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.acceptStringPointer
}

/**
 * \brief Accept a string pointer - intent(inout)
 *
 */
// ----------------------------------------
// Function:  void acceptStringPointer
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string *arg1
// Statement: f_inout_string*_buf
void STR_acceptStringPointer_bufferify(char *arg1, int SHT_arg1_len)
{
    // splicer begin function.acceptStringPointer_bufferify
    std::string SHC_arg1_cxx(arg1,
        ShroudCharLenTrim(arg1, SHT_arg1_len));
    acceptStringPointer(&SHC_arg1_cxx);
    ShroudCharCopy(arg1, SHT_arg1_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.acceptStringPointer_bufferify
}

/**
 * \brief Accept a string pointer - intent(out)
 *
 * Return global_str.
 */
// ----------------------------------------
// Function:  void fetchStringPointer
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string *arg1 +intent(out)
// Statement: c_out_string*
void STR_fetchStringPointer(char *arg1)
{
    // splicer begin function.fetchStringPointer
    std::string SHC_arg1_cxx;
    fetchStringPointer(&SHC_arg1_cxx);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.fetchStringPointer
}

/**
 * \brief Accept a string pointer - intent(out)
 *
 * Return global_str.
 */
// ----------------------------------------
// Function:  void fetchStringPointer
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string *arg1 +intent(out)
// Statement: f_out_string*_buf
void STR_fetchStringPointer_bufferify(char *arg1, int SHT_arg1_len)
{
    // splicer begin function.fetchStringPointer_bufferify
    std::string SHC_arg1_cxx;
    fetchStringPointer(&SHC_arg1_cxx);
    ShroudCharCopy(arg1, SHT_arg1_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.fetchStringPointer_bufferify
}

/**
 * \brief Accept a string pointer - intent(inout)
 *
 * Test return tuple with two arguments.
 * Must rename argument to nlen to avoid conflict with intrinsic len.
 */
// ----------------------------------------
// Function:  void acceptStringPointerLen
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string *arg1
// Statement: c_inout_string*
// ----------------------------------------
// Argument:  int *nlen +intent(out)
// Statement: c_out_native*
void STR_acceptStringPointerLen(char *arg1, int *nlen)
{
    // splicer begin function.acceptStringPointerLen
    std::string SHC_arg1_cxx(arg1);
    acceptStringPointerLen(&SHC_arg1_cxx, nlen);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.acceptStringPointerLen
}

/**
 * \brief Accept a string pointer - intent(inout)
 *
 * Test return tuple with two arguments.
 * Must rename argument to nlen to avoid conflict with intrinsic len.
 */
// ----------------------------------------
// Function:  void acceptStringPointerLen
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string *arg1
// Statement: f_inout_string*_buf
// ----------------------------------------
// Argument:  int *nlen +intent(out)
// Statement: f_out_native*
void STR_acceptStringPointerLen_bufferify(char *arg1, int SHT_arg1_len,
    int *nlen)
{
    // splicer begin function.acceptStringPointerLen_bufferify
    std::string SHC_arg1_cxx(arg1,
        ShroudCharLenTrim(arg1, SHT_arg1_len));
    acceptStringPointerLen(&SHC_arg1_cxx, nlen);
    ShroudCharCopy(arg1, SHT_arg1_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.acceptStringPointerLen_bufferify
}

/**
 * \brief Accept a string pointer - intent(out)
 *
 * Return global_str.
 * Test return tuple with two arguments.
 * Must rename argument to nlen to avoid conflict with intrinsic len.
 */
// ----------------------------------------
// Function:  void fetchStringPointerLen
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string *arg1 +intent(out)
// Statement: c_out_string*
// ----------------------------------------
// Argument:  int *nlen +intent(out)
// Statement: c_out_native*
void STR_fetchStringPointerLen(char *arg1, int *nlen)
{
    // splicer begin function.fetchStringPointerLen
    std::string SHC_arg1_cxx;
    fetchStringPointerLen(&SHC_arg1_cxx, nlen);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.fetchStringPointerLen
}

/**
 * \brief Accept a string pointer - intent(out)
 *
 * Return global_str.
 * Test return tuple with two arguments.
 * Must rename argument to nlen to avoid conflict with intrinsic len.
 */
// ----------------------------------------
// Function:  void fetchStringPointerLen
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string *arg1 +intent(out)
// Statement: f_out_string*_buf
// ----------------------------------------
// Argument:  int *nlen +intent(out)
// Statement: f_out_native*
void STR_fetchStringPointerLen_bufferify(char *arg1, int SHT_arg1_len,
    int *nlen)
{
    // splicer begin function.fetchStringPointerLen_bufferify
    std::string SHC_arg1_cxx;
    fetchStringPointerLen(&SHC_arg1_cxx, nlen);
    ShroudCharCopy(arg1, SHT_arg1_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.fetchStringPointerLen_bufferify
}

/**
 * \brief Accept a string instance
 *
 */
// ----------------------------------------
// Function:  int acceptStringInstance
// Statement: c_function_native
// ----------------------------------------
// Argument:  std::string arg1
// Statement: c_in_string
int STR_acceptStringInstance(char *arg1)
{
    // splicer begin function.acceptStringInstance
    int SHC_rv = acceptStringInstance(arg1);
    return SHC_rv;
    // splicer end function.acceptStringInstance
}

/**
 * \brief Accept a string instance
 *
 */
// ----------------------------------------
// Function:  int acceptStringInstance
// Statement: f_function_native
// ----------------------------------------
// Argument:  std::string arg1
// Statement: f_in_string_buf
int STR_acceptStringInstance_bufferify(char *arg1, int SHT_arg1_len)
{
    // splicer begin function.acceptStringInstance_bufferify
    int SHC_arg1_trim = ShroudCharLenTrim(arg1, SHT_arg1_len);
    std::string SHC_arg1_cxx(arg1, SHC_arg1_trim);
    int SHC_rv = acceptStringInstance(SHC_arg1_cxx);
    return SHC_rv;
    // splicer end function.acceptStringInstance_bufferify
}

#if 0
! Not Implemented
/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 */
// ----------------------------------------
// Function:  void fetchArrayStringArg
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string **strs +dimension(nstrs)+intent(out)
// Statement: c_out_string**
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: c_out_native*
void STR_fetchArrayStringArg(char **strs, int *nstrs)
{
    // splicer begin function.fetchArrayStringArg
    fetchArrayStringArg(strs, nstrs);
    // splicer end function.fetchArrayStringArg
}
#endif

/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 */
// ----------------------------------------
// Function:  void fetchArrayStringArg
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string **strs +dimension(nstrs)+intent(out)
// Statement: f_out_string**_cdesc_copy
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: f_out_native*_hidden
void STR_fetchArrayStringArg_bufferify(STR_SHROUD_array *SHT_strs_cdesc)
{
    // splicer begin function.fetchArrayStringArg_bufferify
    std::string *strs;
    int nstrs;
    fetchArrayStringArg(&strs, &nstrs);
    STR_ShroudArrayStringOut(SHT_strs_cdesc, strs, nstrs);
    // splicer end function.fetchArrayStringArg_bufferify
}

#if 0
! Not Implemented
/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 * The defered length is set to the maximum string length.
 */
// ----------------------------------------
// Function:  void fetchArrayStringAlloc
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)
// Statement: c_out_string**
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: c_out_native*
void STR_fetchArrayStringAlloc(char **strs, int *nstrs)
{
    // splicer begin function.fetchArrayStringAlloc
    fetchArrayStringAlloc(strs, nstrs);
    // splicer end function.fetchArrayStringAlloc
}
#endif

/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 * The defered length is set to the maximum string length.
 */
// ----------------------------------------
// Function:  void fetchArrayStringAlloc
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)
// Statement: f_out_string**_cdesc_allocatable
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: f_out_native*_hidden
void STR_fetchArrayStringAlloc_bufferify(
    STR_SHROUD_array *SHT_strs_cdesc,
    STR_SHROUD_capsule_data *SHT_strs_capsule)
{
    // splicer begin function.fetchArrayStringAlloc_bufferify
    std::string *strs;
    int nstrs;
    fetchArrayStringAlloc(&strs, &nstrs);
    SHT_strs_cdesc->rank = 1;
    SHT_strs_cdesc->shape[0] = nstrs;
    SHT_strs_cdesc->size     = SHT_strs_cdesc->shape[0];
    if (0 > 0) {
        SHT_strs_cdesc->elem_len = 0;
    } else {
        SHT_strs_cdesc->elem_len = STR_ShroudArrayStringOutSize(strs, SHT_strs_cdesc->size);
    }
    SHT_strs_capsule->addr  = strs;
    SHT_strs_capsule->idtor = 0;
    // splicer end function.fetchArrayStringAlloc_bufferify
}

#if 0
! Not Implemented
/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 * The defered length is set to the len attribute.
 */
// ----------------------------------------
// Function:  void fetchArrayStringAllocLen
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)+len(20)
// Statement: c_out_string**
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: c_out_native*
void STR_fetchArrayStringAllocLen(char **strs, int *nstrs)
{
    // splicer begin function.fetchArrayStringAllocLen
    fetchArrayStringAllocLen(strs, nstrs);
    // splicer end function.fetchArrayStringAllocLen
}
#endif

/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 * The defered length is set to the len attribute.
 */
// ----------------------------------------
// Function:  void fetchArrayStringAllocLen
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)+len(20)
// Statement: f_out_string**_cdesc_allocatable
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: f_out_native*_hidden
void STR_fetchArrayStringAllocLen_bufferify(
    STR_SHROUD_array *SHT_strs_cdesc,
    STR_SHROUD_capsule_data *SHT_strs_capsule)
{
    // splicer begin function.fetchArrayStringAllocLen_bufferify
    std::string *strs;
    int nstrs;
    fetchArrayStringAllocLen(&strs, &nstrs);
    SHT_strs_cdesc->rank = 1;
    SHT_strs_cdesc->shape[0] = nstrs;
    SHT_strs_cdesc->size     = SHT_strs_cdesc->shape[0];
    if (20 > 0) {
        SHT_strs_cdesc->elem_len = 20;
    } else {
        SHT_strs_cdesc->elem_len = STR_ShroudArrayStringOutSize(strs, SHT_strs_cdesc->size);
    }
    SHT_strs_capsule->addr  = strs;
    SHT_strs_capsule->idtor = 0;
    // splicer end function.fetchArrayStringAllocLen_bufferify
}

// ----------------------------------------
// Function:  void explicit1
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *name +intent(in)+len_trim(AAlen)
// Statement: c_in_char*
void STR_explicit1(char *name)
{
    // splicer begin function.explicit1
    explicit1(name);
    // splicer end function.explicit1
}

// ----------------------------------------
// Function:  void explicit2
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *name +intent(out)+len(AAtrim)
// Statement: c_out_char*
void STR_explicit2(char *name)
{
    // splicer begin function.explicit2
    explicit2(name);
    // splicer end function.explicit2
}

// ----------------------------------------
// Function:  void explicit2
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *name +intent(out)+len(AAtrim)
// Statement: f_out_char*_buf
void STR_explicit2_bufferify(char *name, int SHT_name_len)
{
    // splicer begin function.explicit2_bufferify
    explicit2(name);
    ShroudCharBlankFill(name, SHT_name_len);
    // splicer end function.explicit2_bufferify
}

/**
 * \brief return a char argument (non-pointer), extern "C"
 *
 */
// ----------------------------------------
// Function:  char CreturnChar
// Statement: c_function_char
void STR_CreturnChar(char *SHC_rv)
{
    // splicer begin function.CreturnChar
    *SHC_rv = CreturnChar();
    // splicer end function.CreturnChar
}

/**
 * \brief strcpy like behavior
 *
 * dest is marked intent(OUT) to override the intent(INOUT) default
 * This avoid a copy-in on dest.
 * extern "C"
 * If src is a blank string, pass a NULL pointer to C library function.
 */
// ----------------------------------------
// Function:  void CpassCharPtr
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *dest +intent(out)
// Statement: f_out_char*_buf
// ----------------------------------------
// Argument:  const char *src +blanknull
// Statement: f_in_char*_buf
void STR_CpassCharPtr_bufferify(char *dest, int SHT_dest_len, char *src,
    int SHT_src_len)
{
    // splicer begin function.CpassCharPtr_bufferify
    char * SHT_src_str = ShroudCharAlloc(src, SHT_src_len, 1);
    CpassCharPtr(dest, SHT_src_str);
    ShroudCharBlankFill(dest, SHT_dest_len);
    ShroudCharFree(SHT_src_str);
    // splicer end function.CpassCharPtr_bufferify
}

/**
 * \brief Test F_blanknull option
 *
 */
// ----------------------------------------
// Function:  void CpassCharPtrBlank
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *dest +intent(out)
// Statement: c_out_char*
// ----------------------------------------
// Argument:  const char *src
// Statement: c_in_char*
void STR_CpassCharPtrBlank(char *dest, const char *src)
{
    // splicer begin function.CpassCharPtrBlank
    CpassCharPtrBlank(dest, src);
    // splicer end function.CpassCharPtrBlank
}

/**
 * \brief Test F_blanknull option
 *
 */
// ----------------------------------------
// Function:  void CpassCharPtrBlank
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *dest +intent(out)
// Statement: f_out_char*_buf
// ----------------------------------------
// Argument:  const char *src
// Statement: f_in_char*_buf
void STR_CpassCharPtrBlank_bufferify(char *dest, int SHT_dest_len,
    char *src, int SHT_src_len)
{
    // splicer begin function.CpassCharPtrBlank_bufferify
    char * SHT_src_str = ShroudCharAlloc(src, SHT_src_len, 1);
    CpassCharPtrBlank(dest, SHT_src_str);
    ShroudCharBlankFill(dest, SHT_dest_len);
    ShroudCharFree(SHT_src_str);
    // splicer end function.CpassCharPtrBlank_bufferify
}

/**
 * Test post_declare.
 * The std::string in py_string_inout must be declared before the
 * goto added by py_native_*_in_pointer_list to avoid
 * "jump to label 'fail' crosses initialization of" error.
 */
// ----------------------------------------
// Function:  void PostDeclare
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int *count +intent(in)+rank(1)
// Statement: c_in_native*
// ----------------------------------------
// Argument:  std::string &name
// Statement: c_inout_string&
void STR_PostDeclare(int *count, char *name)
{
    // splicer begin function.PostDeclare
    std::string SHC_name_cxx(name);
    PostDeclare(count, SHC_name_cxx);
    strcpy(name, SHC_name_cxx.c_str());
    // splicer end function.PostDeclare
}

/**
 * Test post_declare.
 * The std::string in py_string_inout must be declared before the
 * goto added by py_native_*_in_pointer_list to avoid
 * "jump to label 'fail' crosses initialization of" error.
 */
// ----------------------------------------
// Function:  void PostDeclare
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int *count +intent(in)+rank(1)
// Statement: f_in_native*
// ----------------------------------------
// Argument:  std::string &name
// Statement: f_inout_string&_buf
void STR_PostDeclare_bufferify(int *count, char *name, int SHT_name_len)
{
    // splicer begin function.PostDeclare_bufferify
    std::string SHC_name_cxx(name,
        ShroudCharLenTrim(name, SHT_name_len));
    PostDeclare(count, SHC_name_cxx);
    ShroudCharCopy(name, SHT_name_len, SHC_name_cxx.data(),
        SHC_name_cxx.size());
    // splicer end function.PostDeclare_bufferify
}

/**
 * \brief NULL terminate input string in C, not in Fortran.
 *
 */
// ----------------------------------------
// Function:  int CpassCharPtrNotrim
// Statement: c_function_native
// ----------------------------------------
// Argument:  const char *src
// Statement: c_in_char*
int STR_CpassCharPtrNotrim(const char *src)
{
    // splicer begin function.CpassCharPtrNotrim
    int SHC_rv = CpassCharPtrNotrim(src);
    return SHC_rv;
    // splicer end function.CpassCharPtrNotrim
}

/**
 * \brief NULL terminate input string in C, not in Fortran.
 *
 */
// ----------------------------------------
// Function:  int CpassCharPtrNotrim
// Statement: f_function_native
// ----------------------------------------
// Argument:  const char *src
// Statement: f_in_char*_buf
int STR_CpassCharPtrNotrim_bufferify(char *src, int SHT_src_len)
{
    // splicer begin function.CpassCharPtrNotrim_bufferify
    char * SHT_src_str = ShroudCharAlloc(src, SHT_src_len, 0);
    int SHC_rv = CpassCharPtrNotrim(SHT_src_str);
    ShroudCharFree(SHT_src_str);
    return SHC_rv;
    // splicer end function.CpassCharPtrNotrim_bufferify
}

/**
 * \brief Do not NULL terminate input string
 *
 * The C library function should get the same address
 * for addr and src.
 * Used when the C function needs the true address of the argument.
 * Skips null-termination. Useful to create an interface for
 * a function which is already callable by Fortran.
 * For example, the length is passed explicitly.
 * This example will not create a Fortran wrapper since C can be
 * called directly.
 */
// ----------------------------------------
// Function:  int CpassCharPtrCAPI
// Statement: c_function_native
// ----------------------------------------
// Argument:  void *addr
// Statement: c_in_void*
// ----------------------------------------
// Argument:  const char *src +api(capi)
// Statement: c_in_char*
int STR_CpassCharPtrCAPI(void *addr, const char *src)
{
    // splicer begin function.CpassCharPtrCAPI
    int SHC_rv = CpassCharPtrCAPI(addr, src);
    return SHC_rv;
    // splicer end function.CpassCharPtrCAPI
}

/**
 * \brief Mix api(buf) and api(capi)
 *
 */
// ----------------------------------------
// Function:  int CpassCharPtrCAPI2
// Statement: c_function_native
// ----------------------------------------
// Argument:  const char *in
// Statement: c_in_char*
// ----------------------------------------
// Argument:  const char *src +api(capi)
// Statement: c_in_char*
int STR_CpassCharPtrCAPI2(const char *in, const char *src)
{
    // splicer begin function.CpassCharPtrCAPI2
    int SHC_rv = CpassCharPtrCAPI2(in, src);
    return SHC_rv;
    // splicer end function.CpassCharPtrCAPI2
}

}  // extern "C"
