! wrapfstrings.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
#include "shroud/features.h"
!>
!! \file wrapfstrings.f
!! \brief Shroud generated wrapper for strings library
!<
! splicer begin file_top
! splicer end file_top
module strings_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! start helper array_context
    ! helper array_context
    type, bind(C) :: STR_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type STR_SHROUD_array
    ! end helper array_context

    ! start helper capsule_data_helper
    ! helper capsule_data_helper
    type, bind(C) :: STR_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type STR_SHROUD_capsule_data
    ! end helper capsule_data_helper

    ! ----------------------------------------
    ! Function:  void init_test
    ! Statement: f_subroutine
    interface
        subroutine init_test() &
                bind(C, name="STR_init_test")
            implicit none
        end subroutine init_test
    end interface

    ! ----------------------------------------
    ! Function:  void passChar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    interface
        subroutine pass_char(status) &
                bind(C, name="STR_passChar")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), value, intent(IN) :: status
        end subroutine pass_char
    end interface

    ! ----------------------------------------
    ! Function:  void passCharForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    interface
        subroutine c_pass_char_force(status) &
                bind(C, name="STR_passCharForce")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), value, intent(IN) :: status
        end subroutine c_pass_char_force
    end interface

    ! ----------------------------------------
    ! Function:  char returnChar
    ! Statement: f_function_char
    interface
        subroutine c_return_char(SHT_rv) &
                bind(C, name="STR_returnChar")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv
        end subroutine c_return_char
    end interface

    ! ----------------------------------------
    ! Function:  void passCharPtr
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +charlen(40)+intent(out)
    ! Statement: c_out_char*
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: c_in_char*
    ! start c_pass_char_ptr
    interface
        subroutine c_pass_char_ptr(dest, src) &
                bind(C, name="STR_passCharPtr")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: dest(*)
            character(kind=C_CHAR), intent(IN) :: src(*)
        end subroutine c_pass_char_ptr
    end interface
    ! end c_pass_char_ptr

    ! ----------------------------------------
    ! Function:  void passCharPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +charlen(40)+intent(out)
    ! Statement: f_out_char*_buf
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*
    ! start c_pass_char_ptr_bufferify
    interface
        subroutine c_pass_char_ptr_bufferify(dest, SHT_dest_len, src) &
                bind(C, name="STR_passCharPtr_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: dest(*)
            integer(C_INT), value, intent(IN) :: SHT_dest_len
            character(kind=C_CHAR), intent(IN) :: src(*)
        end subroutine c_pass_char_ptr_bufferify
    end interface
    ! end c_pass_char_ptr_bufferify

    ! ----------------------------------------
    ! Function:  void passCharPtrInOut
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *s +intent(inout)
    ! Statement: c_inout_char*
    interface
        subroutine c_pass_char_ptr_in_out(s) &
                bind(C, name="STR_passCharPtrInOut")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: s(*)
        end subroutine c_pass_char_ptr_in_out
    end interface

    ! ----------------------------------------
    ! Function:  void passCharPtrInOut
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *s +intent(inout)
    ! Statement: f_inout_char*_buf
    interface
        subroutine c_pass_char_ptr_in_out_bufferify(s, SHT_s_len) &
                bind(C, name="STR_passCharPtrInOut_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: s(*)
            integer(C_INT), value, intent(IN) :: SHT_s_len
        end subroutine c_pass_char_ptr_in_out_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  const char *getCharPtr1
    ! Statement: c_function_char*
    ! start c_get_char_ptr1
    interface
        function c_get_char_ptr1() &
                result(SHT_rv) &
                bind(C, name="STR_getCharPtr1")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_char_ptr1
    end interface
    ! end c_get_char_ptr1

    ! ----------------------------------------
    ! Function:  const char *getCharPtr1
    ! Statement: f_function_char*_cdesc_allocatable
    ! start c_get_char_ptr1_bufferify
    interface
        subroutine c_get_char_ptr1_bufferify(SHT_rv_cdesc) &
                bind(C, name="STR_getCharPtr1_bufferify")
            import :: STR_SHROUD_array
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_get_char_ptr1_bufferify
    end interface
    ! end c_get_char_ptr1_bufferify

    ! ----------------------------------------
    ! Function:  const char *getCharPtr2 +len(30)
    ! Statement: c_function_char*
    ! start c_get_char_ptr2
    interface
        function c_get_char_ptr2() &
                result(SHT_rv) &
                bind(C, name="STR_getCharPtr2")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_char_ptr2
    end interface
    ! end c_get_char_ptr2

    ! ----------------------------------------
    ! Function:  const char *getCharPtr2 +len(30)
    ! Statement: f_function_char*_buf_copy
    ! start c_get_char_ptr2_bufferify
    interface
        subroutine c_get_char_ptr2_bufferify(SHT_rv, SHT_rv_len) &
                bind(C, name="STR_getCharPtr2_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv(*)
            integer(C_INT), value, intent(IN) :: SHT_rv_len
        end subroutine c_get_char_ptr2_bufferify
    end interface
    ! end c_get_char_ptr2_bufferify

    ! ----------------------------------------
    ! Function:  const char *getCharPtr3
    ! Statement: c_function_char*
    ! start c_get_char_ptr3
    interface
        function c_get_char_ptr3() &
                result(SHT_rv) &
                bind(C, name="STR_getCharPtr3")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_char_ptr3
    end interface
    ! end c_get_char_ptr3

    ! ----------------------------------------
    ! Function:  const char *getCharPtr3
    ! Statement: f_function_char*_buf_arg
    ! start c_get_char_ptr3_bufferify
    interface
        subroutine c_get_char_ptr3_bufferify(output, noutput) &
                bind(C, name="STR_getCharPtr3_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: output(*)
            integer(C_INT), value, intent(IN) :: noutput
        end subroutine c_get_char_ptr3_bufferify
    end interface
    ! end c_get_char_ptr3_bufferify

    ! ----------------------------------------
    ! Function:  const char *getCharPtr4 +deref(raw)
    ! Statement: f_function_char*_raw
    interface
        function get_char_ptr4() &
                result(SHT_rv) &
                bind(C, name="STR_getCharPtr4")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function get_char_ptr4
    end interface

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const char *getCharPtr5 +deref(pointer)
    ! Statement: c_function_char*
    interface
        function c_get_char_ptr5() &
                result(SHT_rv) &
                bind(C, name="STR_getCharPtr5")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_char_ptr5
    end interface
#endif

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const char *getCharPtr5 +deref(pointer)
    ! Statement: f_function_char*_cdesc_pointer
    interface
        subroutine c_get_char_ptr5_bufferify(SHT_rv_cdesc) &
                bind(C, name="STR_getCharPtr5_bufferify")
            import :: STR_SHROUD_array
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_get_char_ptr5_bufferify
    end interface
#endif

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  const string getConstStringResult
    ! Statement: c_function_string
    interface
        function c_get_const_string_result() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringResult")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR) :: SHT_rv(*)
        end function c_get_const_string_result
    end interface
#endif

    ! ----------------------------------------
    ! Function:  const string getConstStringResult
    ! Statement: f_function_string_cdesc_allocatable
    interface
        subroutine c_get_const_string_result_bufferify(SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="STR_getConstStringResult_bufferify")
            import :: STR_SHROUD_array, STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_get_const_string_result_bufferify
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  const string getConstStringLen +len(30)
    ! Statement: c_function_string
    interface
        function c_get_const_string_len() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringLen")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR) :: SHT_rv(*)
        end function c_get_const_string_len
    end interface
#endif

    ! ----------------------------------------
    ! Function:  const string getConstStringLen +len(30)
    ! Statement: f_function_string_buf_copy
    interface
        subroutine c_get_const_string_len_bufferify(SHT_rv, SHT_rv_len) &
                bind(C, name="STR_getConstStringLen_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv(*)
            integer(C_INT), value, intent(IN) :: SHT_rv_len
        end subroutine c_get_const_string_len_bufferify
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  const string getConstStringAsArg
    ! Statement: c_function_string
    interface
        function c_get_const_string_as_arg() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringAsArg")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR) :: SHT_rv(*)
        end function c_get_const_string_as_arg
    end interface
#endif

    ! ----------------------------------------
    ! Function:  const string getConstStringAsArg
    ! Statement: f_function_string_buf_arg
    interface
        subroutine c_get_const_string_as_arg_bufferify(output, noutput) &
                bind(C, name="STR_getConstStringAsArg_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: output(*)
            integer(C_INT), value, intent(IN) :: noutput
        end subroutine c_get_const_string_as_arg_bufferify
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  const std::string getConstStringAlloc
    ! Statement: c_function_string
    interface
        function c_get_const_string_alloc() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringAlloc")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR) :: SHT_rv(*)
        end function c_get_const_string_alloc
    end interface
#endif

    ! ----------------------------------------
    ! Function:  const std::string getConstStringAlloc
    ! Statement: f_function_string_cdesc_allocatable
    interface
        subroutine c_get_const_string_alloc_bufferify(SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="STR_getConstStringAlloc_bufferify")
            import :: STR_SHROUD_array, STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_get_const_string_alloc_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefPure
    ! Statement: c_function_string&
    ! start c_get_const_string_ref_pure
    interface
        function c_get_const_string_ref_pure() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringRefPure")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ref_pure
    end interface
    ! end c_get_const_string_ref_pure

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefPure
    ! Statement: f_function_string&_cdesc_allocatable
    ! start c_get_const_string_ref_pure_bufferify
    interface
        subroutine c_get_const_string_ref_pure_bufferify(SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="STR_getConstStringRefPure_bufferify")
            import :: STR_SHROUD_array, STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_get_const_string_ref_pure_bufferify
    end interface
    ! end c_get_const_string_ref_pure_bufferify

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLen +len(30)
    ! Statement: c_function_string&
    interface
        function c_get_const_string_ref_len() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringRefLen")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ref_len
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLen +len(30)
    ! Statement: f_function_string&_buf_copy
    interface
        subroutine c_get_const_string_ref_len_bufferify(SHT_rv, &
                SHT_rv_len) &
                bind(C, name="STR_getConstStringRefLen_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv(*)
            integer(C_INT), value, intent(IN) :: SHT_rv_len
        end subroutine c_get_const_string_ref_len_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefAsArg
    ! Statement: c_function_string&
    interface
        function c_get_const_string_ref_as_arg() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringRefAsArg")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ref_as_arg
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefAsArg
    ! Statement: f_function_string&_buf_arg
    interface
        subroutine c_get_const_string_ref_as_arg_bufferify(output, &
                noutput) &
                bind(C, name="STR_getConstStringRefAsArg_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: output(*)
            integer(C_INT), value, intent(IN) :: noutput
        end subroutine c_get_const_string_ref_as_arg_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLenEmpty +len(30)
    ! Statement: c_function_string&
    interface
        function c_get_const_string_ref_len_empty() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringRefLenEmpty")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ref_len_empty
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLenEmpty +len(30)
    ! Statement: f_function_string&_buf_copy
    interface
        subroutine c_get_const_string_ref_len_empty_bufferify(SHT_rv, &
                SHT_rv_len) &
                bind(C, name="STR_getConstStringRefLenEmpty_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv(*)
            integer(C_INT), value, intent(IN) :: SHT_rv_len
        end subroutine c_get_const_string_ref_len_empty_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  const std::string &getConstStringRefAlloc
    ! Statement: c_function_string&
    interface
        function c_get_const_string_ref_alloc() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringRefAlloc")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ref_alloc
    end interface

    ! ----------------------------------------
    ! Function:  const std::string &getConstStringRefAlloc
    ! Statement: f_function_string&_cdesc_allocatable
    interface
        subroutine c_get_const_string_ref_alloc_bufferify(SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="STR_getConstStringRefAlloc_bufferify")
            import :: STR_SHROUD_array, STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_get_const_string_ref_alloc_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  const string *getConstStringPtrLen +len(30)
    ! Statement: c_function_string*
    interface
        function c_get_const_string_ptr_len() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrLen")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_len
    end interface

    ! ----------------------------------------
    ! Function:  const string *getConstStringPtrLen +len(30)
    ! Statement: f_function_string*_buf_copy
    interface
        subroutine c_get_const_string_ptr_len_bufferify(SHT_rv, &
                SHT_rv_len) &
                bind(C, name="STR_getConstStringPtrLen_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv(*)
            integer(C_INT), value, intent(IN) :: SHT_rv_len
        end subroutine c_get_const_string_ptr_len_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrAlloc +owner(library)
    ! Statement: c_function_string*_library
    interface
        function c_get_const_string_ptr_alloc() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrAlloc")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_alloc
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrAlloc +owner(library)
    ! Statement: f_function_string*_cdesc_allocatable_library
    interface
        subroutine c_get_const_string_ptr_alloc_bufferify(SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="STR_getConstStringPtrAlloc_bufferify")
            import :: STR_SHROUD_array, STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_get_const_string_ptr_alloc_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAlloc +owner(caller)
    ! Statement: c_function_string*_caller
    interface
        function c_get_const_string_ptr_owns_alloc() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrOwnsAlloc")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_owns_alloc
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAlloc +owner(caller)
    ! Statement: f_function_string*_cdesc_allocatable_caller
    interface
        subroutine c_get_const_string_ptr_owns_alloc_bufferify( &
                SHT_rv_cdesc, SHT_rv_capsule) &
                bind(C, name="STR_getConstStringPtrOwnsAlloc_bufferify")
            import :: STR_SHROUD_array, STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_get_const_string_ptr_owns_alloc_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAllocPattern +free_pattern(C_string_free)+owner(caller)
    ! Statement: c_function_string*_caller
    interface
        function c_get_const_string_ptr_owns_alloc_pattern() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrOwnsAllocPattern")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_owns_alloc_pattern
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAllocPattern +free_pattern(C_string_free)+owner(caller)
    ! Statement: f_function_string*_cdesc_allocatable_caller
    interface
        subroutine c_get_const_string_ptr_owns_alloc_pattern_bufferify( &
                SHT_rv_cdesc, SHT_rv_capsule) &
                bind(C, name="STR_getConstStringPtrOwnsAllocPattern_bufferify")
            import :: STR_SHROUD_array, STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_get_const_string_ptr_owns_alloc_pattern_bufferify
    end interface

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrPointer +deref(pointer)+owner(library)
    ! Statement: c_function_string*_library
    interface
        function c_get_const_string_ptr_pointer() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrPointer")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_pointer
    end interface
#endif

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrPointer +deref(pointer)+owner(library)
    ! Statement: f_function_string*_cdesc_pointer_library
    interface
        subroutine c_get_const_string_ptr_pointer_bufferify( &
                SHT_rv_cdesc) &
                bind(C, name="STR_getConstStringPtrPointer_bufferify")
            import :: STR_SHROUD_array
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_get_const_string_ptr_pointer_bufferify
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void acceptStringConstReference
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &arg1
    ! Statement: c_in_string&
    interface
        subroutine c_accept_string_const_reference(arg1) &
                bind(C, name="STR_acceptStringConstReference")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
        end subroutine c_accept_string_const_reference
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringConstReference
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &arg1
    ! Statement: f_in_string&_buf
    interface
        subroutine c_accept_string_const_reference_bufferify(arg1, &
                SHT_arg1_len) &
                bind(C, name="STR_acceptStringConstReference_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
            integer(C_INT), value, intent(IN) :: SHT_arg1_len
        end subroutine c_accept_string_const_reference_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringReferenceOut
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1 +intent(out)
    ! Statement: c_out_string&
    interface
        subroutine c_accept_string_reference_out(arg1) &
                bind(C, name="STR_acceptStringReferenceOut")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg1(*)
        end subroutine c_accept_string_reference_out
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringReferenceOut
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1 +intent(out)
    ! Statement: f_out_string&_buf
    interface
        subroutine c_accept_string_reference_out_bufferify(arg1, &
                SHT_arg1_len) &
                bind(C, name="STR_acceptStringReferenceOut_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg1(*)
            integer(C_INT), value, intent(IN) :: SHT_arg1_len
        end subroutine c_accept_string_reference_out_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringReference
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1
    ! Statement: c_inout_string&
    ! start c_accept_string_reference
    interface
        subroutine c_accept_string_reference(arg1) &
                bind(C, name="STR_acceptStringReference")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: arg1(*)
        end subroutine c_accept_string_reference
    end interface
    ! end c_accept_string_reference

    ! ----------------------------------------
    ! Function:  void acceptStringReference
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1
    ! Statement: f_inout_string&_buf
    ! start c_accept_string_reference_bufferify
    interface
        subroutine c_accept_string_reference_bufferify(arg1, &
                SHT_arg1_len) &
                bind(C, name="STR_acceptStringReference_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: arg1(*)
            integer(C_INT), value, intent(IN) :: SHT_arg1_len
        end subroutine c_accept_string_reference_bufferify
    end interface
    ! end c_accept_string_reference_bufferify

    ! ----------------------------------------
    ! Function:  void acceptStringPointerConst
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string *arg1
    ! Statement: c_in_string*
    interface
        subroutine c_accept_string_pointer_const(arg1) &
                bind(C, name="STR_acceptStringPointerConst")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
        end subroutine c_accept_string_pointer_const
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringPointerConst
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string *arg1
    ! Statement: f_in_string*_buf
    interface
        subroutine c_accept_string_pointer_const_bufferify(arg1, &
                SHT_arg1_len) &
                bind(C, name="STR_acceptStringPointerConst_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
            integer(C_INT), value, intent(IN) :: SHT_arg1_len
        end subroutine c_accept_string_pointer_const_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringPointer
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: c_inout_string*
    interface
        subroutine c_accept_string_pointer(arg1) &
                bind(C, name="STR_acceptStringPointer")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: arg1(*)
        end subroutine c_accept_string_pointer
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: f_inout_string*_buf
    interface
        subroutine c_accept_string_pointer_bufferify(arg1, SHT_arg1_len) &
                bind(C, name="STR_acceptStringPointer_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: arg1(*)
            integer(C_INT), value, intent(IN) :: SHT_arg1_len
        end subroutine c_accept_string_pointer_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void fetchStringPointer
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: c_out_string*
    interface
        subroutine c_fetch_string_pointer(arg1) &
                bind(C, name="STR_fetchStringPointer")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg1(*)
        end subroutine c_fetch_string_pointer
    end interface

    ! ----------------------------------------
    ! Function:  void fetchStringPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: f_out_string*_buf
    interface
        subroutine c_fetch_string_pointer_bufferify(arg1, SHT_arg1_len) &
                bind(C, name="STR_fetchStringPointer_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg1(*)
            integer(C_INT), value, intent(IN) :: SHT_arg1_len
        end subroutine c_fetch_string_pointer_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringPointerLen
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: c_inout_string*
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: c_out_native*
    interface
        subroutine c_accept_string_pointer_len(arg1, nlen) &
                bind(C, name="STR_acceptStringPointerLen")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: arg1(*)
            integer(C_INT), intent(OUT) :: nlen
        end subroutine c_accept_string_pointer_len
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringPointerLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: f_inout_string*_buf
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: f_out_native*
    interface
        subroutine c_accept_string_pointer_len_bufferify(arg1, &
                SHT_arg1_len, nlen) &
                bind(C, name="STR_acceptStringPointerLen_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: arg1(*)
            integer(C_INT), value, intent(IN) :: SHT_arg1_len
            integer(C_INT), intent(OUT) :: nlen
        end subroutine c_accept_string_pointer_len_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void fetchStringPointerLen
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: c_out_string*
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: c_out_native*
    interface
        subroutine c_fetch_string_pointer_len(arg1, nlen) &
                bind(C, name="STR_fetchStringPointerLen")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg1(*)
            integer(C_INT), intent(OUT) :: nlen
        end subroutine c_fetch_string_pointer_len
    end interface

    ! ----------------------------------------
    ! Function:  void fetchStringPointerLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: f_out_string*_buf
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: f_out_native*
    interface
        subroutine c_fetch_string_pointer_len_bufferify(arg1, &
                SHT_arg1_len, nlen) &
                bind(C, name="STR_fetchStringPointerLen_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg1(*)
            integer(C_INT), value, intent(IN) :: SHT_arg1_len
            integer(C_INT), intent(OUT) :: nlen
        end subroutine c_fetch_string_pointer_len_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  int acceptStringInstance
    ! Statement: c_function_native
    ! ----------------------------------------
    ! Argument:  std::string arg1
    ! Statement: c_in_string
    interface
        function c_accept_string_instance(arg1) &
                result(SHT_rv) &
                bind(C, name="STR_acceptStringInstance")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
            integer(C_INT) :: SHT_rv
        end function c_accept_string_instance
    end interface

    ! ----------------------------------------
    ! Function:  int acceptStringInstance
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  std::string arg1
    ! Statement: f_in_string_buf
    interface
        function c_accept_string_instance_bufferify(arg1, SHT_arg1_len) &
                result(SHT_rv) &
                bind(C, name="STR_acceptStringInstance_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
            integer(C_INT), value, intent(IN) :: SHT_arg1_len
            integer(C_INT) :: SHT_rv
        end function c_accept_string_instance_bufferify
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  void fetchArrayStringArg
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +dimension(nstrs)+intent(out)
    ! Statement: c_out_string**
    ! ----------------------------------------
    ! Argument:  int *nstrs +hidden+intent(out)
    ! Statement: c_out_native*
    interface
        subroutine c_fetch_array_string_arg(strs, nstrs) &
                bind(C, name="STR_fetchArrayStringArg")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(OUT), value :: strs
            integer(C_INT), intent(OUT) :: nstrs
        end subroutine c_fetch_array_string_arg
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void fetchArrayStringArg
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +dimension(nstrs)+intent(out)
    ! Statement: f_out_string**_cdesc_copy
    interface
        subroutine c_fetch_array_string_arg_bufferify(SHT_strs_cdesc) &
                bind(C, name="STR_fetchArrayStringArg_bufferify")
            import :: STR_SHROUD_array
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_strs_cdesc
        end subroutine c_fetch_array_string_arg_bufferify
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  void fetchArrayStringAlloc
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)
    ! Statement: c_out_string**
    ! ----------------------------------------
    ! Argument:  int *nstrs +hidden+intent(out)
    ! Statement: c_out_native*
    interface
        subroutine c_fetch_array_string_alloc(strs, nstrs) &
                bind(C, name="STR_fetchArrayStringAlloc")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(OUT), value :: strs
            integer(C_INT), intent(OUT) :: nstrs
        end subroutine c_fetch_array_string_alloc
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void fetchArrayStringAlloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)
    ! Statement: f_out_string**_cdesc_allocatable
    interface
        subroutine c_fetch_array_string_alloc_bufferify(SHT_strs_cdesc, &
                SHT_strs_capsule) &
                bind(C, name="STR_fetchArrayStringAlloc_bufferify")
            import :: STR_SHROUD_array, STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_strs_cdesc
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_strs_capsule
        end subroutine c_fetch_array_string_alloc_bufferify
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  void fetchArrayStringAllocLen
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)+len(20)
    ! Statement: c_out_string**
    ! ----------------------------------------
    ! Argument:  int *nstrs +hidden+intent(out)
    ! Statement: c_out_native*
    interface
        subroutine c_fetch_array_string_alloc_len(strs, nstrs) &
                bind(C, name="STR_fetchArrayStringAllocLen")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(OUT), value :: strs
            integer(C_INT), intent(OUT) :: nstrs
        end subroutine c_fetch_array_string_alloc_len
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void fetchArrayStringAllocLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)+len(20)
    ! Statement: f_out_string**_cdesc_allocatable
    interface
        subroutine c_fetch_array_string_alloc_len_bufferify( &
                SHT_strs_cdesc, SHT_strs_capsule) &
                bind(C, name="STR_fetchArrayStringAllocLen_bufferify")
            import :: STR_SHROUD_array, STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_strs_cdesc
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_strs_capsule
        end subroutine c_fetch_array_string_alloc_len_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void explicit1
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(in)+len_trim(AAlen)
    ! Statement: f_in_char*
    interface
        subroutine c_explicit1(name) &
                bind(C, name="STR_explicit1")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
        end subroutine c_explicit1
    end interface

    ! ----------------------------------------
    ! Function:  void explicit2
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(out)+len(AAtrim)
    ! Statement: c_out_char*
    interface
        subroutine c_explicit2(name) &
                bind(C, name="STR_explicit2")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: name(*)
        end subroutine c_explicit2
    end interface

    ! ----------------------------------------
    ! Function:  void explicit2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(out)+len(AAtrim)
    ! Statement: f_out_char*_buf
    interface
        subroutine c_explicit2_bufferify(name, SHT_name_len) &
                bind(C, name="STR_explicit2_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
        end subroutine c_explicit2_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void CpassChar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    interface
        subroutine cpass_char(status) &
                bind(C, name="CpassChar")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), value, intent(IN) :: status
        end subroutine cpass_char
    end interface

    ! ----------------------------------------
    ! Function:  char CreturnChar
    ! Statement: f_function_char
    interface
        subroutine c_creturn_char(SHT_rv) &
                bind(C, name="STR_CreturnChar")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv
        end subroutine c_creturn_char
    end interface

    ! ----------------------------------------
    ! Function:  void CpassCharPtr
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: c_out_char*
    ! ----------------------------------------
    ! Argument:  const char *src +blanknull
    ! Statement: c_in_char*
    interface
        subroutine c_cpass_char_ptr(dest, src) &
                bind(C, name="CpassCharPtr")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: dest(*)
            character(kind=C_CHAR), intent(IN) :: src(*)
        end subroutine c_cpass_char_ptr
    end interface

    ! ----------------------------------------
    ! Function:  void CpassCharPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: f_out_char*_buf
    ! ----------------------------------------
    ! Argument:  const char *src +blanknull
    ! Statement: f_in_char*_buf
    interface
        subroutine c_cpass_char_ptr_bufferify(dest, SHT_dest_len, src, &
                SHT_src_len) &
                bind(C, name="STR_CpassCharPtr_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: dest(*)
            integer(C_INT), value, intent(IN) :: SHT_dest_len
            character(kind=C_CHAR), intent(IN) :: src(*)
            integer(C_INT), value, intent(IN) :: SHT_src_len
        end subroutine c_cpass_char_ptr_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void CpassCharPtrBlank
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: c_out_char*
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: c_in_char*
    interface
        subroutine c_cpass_char_ptr_blank(dest, src) &
                bind(C, name="STR_CpassCharPtrBlank")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: dest(*)
            character(kind=C_CHAR), intent(IN) :: src(*)
        end subroutine c_cpass_char_ptr_blank
    end interface

    ! ----------------------------------------
    ! Function:  void CpassCharPtrBlank
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: f_out_char*_buf
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*_buf
    interface
        subroutine c_cpass_char_ptr_blank_bufferify(dest, SHT_dest_len, &
                src, SHT_src_len) &
                bind(C, name="STR_CpassCharPtrBlank_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: dest(*)
            integer(C_INT), value, intent(IN) :: SHT_dest_len
            character(kind=C_CHAR), intent(IN) :: src(*)
            integer(C_INT), value, intent(IN) :: SHT_src_len
        end subroutine c_cpass_char_ptr_blank_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  void PostDeclare
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  int *count +intent(in)+rank(1)
    ! Statement: c_in_native*
    ! ----------------------------------------
    ! Argument:  std::string &name
    ! Statement: c_inout_string&
    interface
        subroutine c_post_declare(count, name) &
                bind(C, name="STR_PostDeclare")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            integer(C_INT), intent(IN) :: count(*)
            character(kind=C_CHAR), intent(INOUT) :: name(*)
        end subroutine c_post_declare
    end interface

    ! ----------------------------------------
    ! Function:  void PostDeclare
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *count +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  std::string &name
    ! Statement: f_inout_string&_buf
    interface
        subroutine c_post_declare_bufferify(count, name, SHT_name_len) &
                bind(C, name="STR_PostDeclare_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            integer(C_INT), intent(IN) :: count(*)
            character(kind=C_CHAR), intent(INOUT) :: name(*)
            integer(C_INT), value, intent(IN) :: SHT_name_len
        end subroutine c_post_declare_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  int CpassCharPtrNotrim
    ! Statement: c_function_native
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: c_in_char*
    interface
        function c_cpass_char_ptr_notrim(src) &
                result(SHT_rv) &
                bind(C, name="STR_CpassCharPtrNotrim")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: src(*)
            integer(C_INT) :: SHT_rv
        end function c_cpass_char_ptr_notrim
    end interface

    ! ----------------------------------------
    ! Function:  int CpassCharPtrNotrim
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*_buf
    interface
        function c_cpass_char_ptr_notrim_bufferify(src, SHT_src_len) &
                result(SHT_rv) &
                bind(C, name="STR_CpassCharPtrNotrim_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: src(*)
            integer(C_INT), value, intent(IN) :: SHT_src_len
            integer(C_INT) :: SHT_rv
        end function c_cpass_char_ptr_notrim_bufferify
    end interface

    ! ----------------------------------------
    ! Function:  int CpassCharPtrCAPI
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void *addr
    ! Statement: f_in_void*
    ! ----------------------------------------
    ! Argument:  const char *src +api(capi)
    ! Statement: f_in_char*_capi
    interface
        function cpass_char_ptr_capi(addr, src) &
                result(SHT_rv) &
                bind(C, name="STR_CpassCharPtrCAPI")
            use iso_c_binding, only : C_CHAR, C_INT, C_PTR
            implicit none
            type(C_PTR), value, intent(IN) :: addr
            character(kind=C_CHAR), intent(IN) :: src(*)
            integer(C_INT) :: SHT_rv
        end function cpass_char_ptr_capi
    end interface

    ! ----------------------------------------
    ! Function:  int CpassCharPtrCAPI2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *in
    ! Statement: f_in_char*
    ! ----------------------------------------
    ! Argument:  const char *src +api(capi)
    ! Statement: f_in_char*_capi
    interface
        function c_cpass_char_ptr_capi2(in, src) &
                result(SHT_rv) &
                bind(C, name="STR_CpassCharPtrCAPI2")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: in(*)
            character(kind=C_CHAR), intent(IN) :: src(*)
            integer(C_INT) :: SHT_rv
        end function c_cpass_char_ptr_capi2
    end interface

    interface
        ! helper array_string_allocatable
        subroutine STR_SHROUD_array_string_allocatable(dest, src) &
             bind(c,name="STR_ShroudArrayStringAllocatable")
            import STR_SHROUD_array, STR_SHROUD_capsule_data
            type(STR_SHROUD_array), intent(IN) :: dest
            type(STR_SHROUD_capsule_data), intent(IN) :: src
        end subroutine STR_SHROUD_array_string_allocatable
    end interface

    interface
        ! helper capsule_dtor
        ! Delete memory in a capsule.
        subroutine STR_SHROUD_capsule_dtor(ptr) &
            bind(C, name="STR_SHROUD_memory_destructor")
            import STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(INOUT) :: ptr
        end subroutine STR_SHROUD_capsule_dtor
    end interface

    interface
        ! helper copy_string
        ! Copy the char* or std::string in context into c_var.
        subroutine STR_SHROUD_copy_string(context, c_var, c_var_size) &
             bind(c,name="STR_ShroudCopyString")
            use, intrinsic :: iso_c_binding, only : C_CHAR, C_SIZE_T
            import STR_SHROUD_array
            type(STR_SHROUD_array), intent(IN) :: context
            character(kind=C_CHAR), intent(OUT) :: c_var(*)
            integer(C_SIZE_T), value :: c_var_size
        end subroutine STR_SHROUD_copy_string
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void init_test
    ! Statement: f_subroutine
    subroutine init_test()
        ! splicer begin function.init_test
        call c_init_test()
        ! splicer end function.init_test
    end subroutine init_test
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void passChar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    !>
    !! \brief pass a single char argument as a scalar.
    !!
    !<
    subroutine pass_char(status)
        character, value, intent(IN) :: status
        ! splicer begin function.pass_char
        call c_pass_char(status)
        ! splicer end function.pass_char
    end subroutine pass_char
#endif

    ! ----------------------------------------
    ! Function:  void passCharForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    !>
    !! By default no Fortran wrapper is created.
    !! Force one so it can be tested.
    !<
    subroutine pass_char_force(status)
        character, value, intent(IN) :: status
        ! splicer begin function.pass_char_force
        call c_pass_char_force(status)
        ! splicer end function.pass_char_force
    end subroutine pass_char_force

    ! ----------------------------------------
    ! Function:  char returnChar
    ! Statement: f_function_char
    !>
    !! \brief return a char argument (non-pointer)
    !!
    !<
    function return_char() &
            result(SHT_rv)
        character :: SHT_rv
        ! splicer begin function.return_char
        call c_return_char(SHT_rv)
        ! splicer end function.return_char
    end function return_char

    ! ----------------------------------------
    ! Function:  void passCharPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +charlen(40)+intent(out)
    ! Statement: f_out_char*_buf
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*
    !>
    !! \brief strcpy like behavior
    !!
    !! dest is marked intent(OUT) to override the intent(INOUT) default
    !! This avoid a copy-in on dest.
    !! In Python, src must not be over 40 characters, defined by charlen.
    !<
    ! start pass_char_ptr
    subroutine pass_char_ptr(dest, src)
        use iso_c_binding, only : C_INT, C_NULL_CHAR
        character(len=*), intent(OUT) :: dest
        character(len=*), intent(IN) :: src
        ! splicer begin function.pass_char_ptr
        integer(C_INT) SHT_dest_len
        SHT_dest_len = len(dest, kind=C_INT)
        call c_pass_char_ptr_bufferify(dest, SHT_dest_len, &
            trim(src)//C_NULL_CHAR)
        ! splicer end function.pass_char_ptr
    end subroutine pass_char_ptr
    ! end pass_char_ptr

    ! ----------------------------------------
    ! Function:  void passCharPtrInOut
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *s +intent(inout)
    ! Statement: f_inout_char*_buf
    !>
    !! \brief toupper
    !!
    !! Change a string in-place.
    !! For Python, return a new string since strings are immutable.
    !<
    subroutine pass_char_ptr_in_out(s)
        use iso_c_binding, only : C_INT
        character(len=*), intent(INOUT) :: s
        ! splicer begin function.pass_char_ptr_in_out
        integer(C_INT) SHT_s_len
        SHT_s_len = len(s, kind=C_INT)
        call c_pass_char_ptr_in_out_bufferify(s, SHT_s_len)
        ! splicer end function.pass_char_ptr_in_out
    end subroutine pass_char_ptr_in_out

    ! ----------------------------------------
    ! Function:  const char *getCharPtr1
    ! Statement: f_function_char*_cdesc_allocatable
    !>
    !! \brief return a 'const char *' as character(*)
    !!
    !<
    ! start get_char_ptr1
    function get_char_ptr1() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_char_ptr1
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        call c_get_char_ptr1_bufferify(SHT_rv_cdesc)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call STR_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        ! splicer end function.get_char_ptr1
    end function get_char_ptr1
    ! end get_char_ptr1

    ! ----------------------------------------
    ! Function:  const char *getCharPtr2 +len(30)
    ! Statement: f_function_char*_buf_copy
    !>
    !! \brief return 'const char *' with fixed size (len=30)
    !!
    !<
    ! start get_char_ptr2
    function get_char_ptr2() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=30) :: SHT_rv
        ! splicer begin function.get_char_ptr2
        integer(C_INT) SHT_rv_len
        SHT_rv_len = len(SHT_rv, kind=C_INT)
        call c_get_char_ptr2_bufferify(SHT_rv, SHT_rv_len)
        ! splicer end function.get_char_ptr2
    end function get_char_ptr2
    ! end get_char_ptr2

    ! ----------------------------------------
    ! Function:  const char *getCharPtr3
    ! Statement: f_function_char*_buf_arg
    !>
    !! \brief return a 'const char *' as argument
    !!
    !<
    ! start get_char_ptr3
    subroutine get_char_ptr3(output)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: output
        ! splicer begin function.get_char_ptr3
        integer(C_INT) noutput
        noutput = len(output, kind=C_INT)
        call c_get_char_ptr3_bufferify(output, noutput)
        ! splicer end function.get_char_ptr3
    end subroutine get_char_ptr3
    ! end get_char_ptr3

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  const char *getCharPtr4 +deref(raw)
    ! Statement: f_function_char*_raw
    !>
    !! \brief return a 'const char *' as type(C_PTR)
    !!
    !<
    function get_char_ptr4() &
            result(SHT_rv)
        type(C_PTR) :: SHT_rv
        ! splicer begin function.get_char_ptr4
        SHT_rv = c_get_char_ptr4()
        ! splicer end function.get_char_ptr4
    end function get_char_ptr4
#endif

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const char *getCharPtr5 +deref(pointer)
    ! Statement: f_function_char*_cdesc_pointer
    !>
    !! \brief return a 'const char *' as character(:) pointer
    !!
    !<
    function get_char_ptr5() &
            result(SHT_rv)
        use iso_c_binding, only : c_f_pointer
        character(len=:), pointer :: SHT_rv
        ! splicer begin function.get_char_ptr5
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        call c_get_char_ptr5_bufferify(SHT_rv_cdesc)
        call STR_SHROUD_pointer_string(SHT_rv_cdesc, SHT_rv)
        ! splicer end function.get_char_ptr5
    end function get_char_ptr5
#endif

    ! ----------------------------------------
    ! Function:  const string getConstStringResult
    ! Statement: f_function_string_cdesc_allocatable
    !>
    !! \brief return an ALLOCATABLE CHARACTER from std::string
    !!
    !<
    function get_const_string_result() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_result
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        type(STR_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_get_const_string_result_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call STR_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call STR_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.get_const_string_result
    end function get_const_string_result

    ! ----------------------------------------
    ! Function:  const string getConstStringLen +len(30)
    ! Statement: f_function_string_buf_copy
    !>
    !! \brief return a 'const string' as argument
    !!
    !<
    function get_const_string_len() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=30) :: SHT_rv
        ! splicer begin function.get_const_string_len
        integer(C_INT) SHT_rv_len
        SHT_rv_len = len(SHT_rv, kind=C_INT)
        call c_get_const_string_len_bufferify(SHT_rv, SHT_rv_len)
        ! splicer end function.get_const_string_len
    end function get_const_string_len

    ! ----------------------------------------
    ! Function:  const string getConstStringAsArg
    ! Statement: f_function_string_buf_arg
    !>
    !! \brief return a 'const string' as argument
    !!
    !<
    subroutine get_const_string_as_arg(output)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: output
        ! splicer begin function.get_const_string_as_arg
        integer(C_INT) noutput
        noutput = len(output, kind=C_INT)
        call c_get_const_string_as_arg_bufferify(output, noutput)
        ! splicer end function.get_const_string_as_arg
    end subroutine get_const_string_as_arg

    ! ----------------------------------------
    ! Function:  const std::string getConstStringAlloc
    ! Statement: f_function_string_cdesc_allocatable
    function get_const_string_alloc() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_alloc
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        type(STR_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_get_const_string_alloc_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call STR_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call STR_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.get_const_string_alloc
    end function get_const_string_alloc

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefPure
    ! Statement: f_function_string&_cdesc_allocatable
    !>
    !! \brief return a 'const string&' as ALLOCATABLE character
    !!
    !<
    ! start get_const_string_ref_pure
    function get_const_string_ref_pure() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ref_pure
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        type(STR_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_get_const_string_ref_pure_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call STR_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call STR_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.get_const_string_ref_pure
    end function get_const_string_ref_pure
    ! end get_const_string_ref_pure

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLen +len(30)
    ! Statement: f_function_string&_buf_copy
    !>
    !! \brief return 'const string&' with fixed size (len=30)
    !!
    !! Since +len(30) is provided, the result of the function
    !! will be copied directly into memory provided by Fortran.
    !! The function will not be ALLOCATABLE.
    !<
    function get_const_string_ref_len() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=30) :: SHT_rv
        ! splicer begin function.get_const_string_ref_len
        integer(C_INT) SHT_rv_len
        SHT_rv_len = len(SHT_rv, kind=C_INT)
        call c_get_const_string_ref_len_bufferify(SHT_rv, SHT_rv_len)
        ! splicer end function.get_const_string_ref_len
    end function get_const_string_ref_len

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefAsArg
    ! Statement: f_function_string&_buf_arg
    !>
    !! \brief return a 'const string&' as argument
    !!
    !! Pass an additional argument which will be used as the return value.
    !! The length of the output variable is declared by the caller.
    !<
    subroutine get_const_string_ref_as_arg(output)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: output
        ! splicer begin function.get_const_string_ref_as_arg
        integer(C_INT) noutput
        noutput = len(output, kind=C_INT)
        call c_get_const_string_ref_as_arg_bufferify(output, noutput)
        ! splicer end function.get_const_string_ref_as_arg
    end subroutine get_const_string_ref_as_arg

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLenEmpty +len(30)
    ! Statement: f_function_string&_buf_copy
    !>
    !! \brief Test returning empty string reference
    !!
    !<
    function get_const_string_ref_len_empty() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=30) :: SHT_rv
        ! splicer begin function.get_const_string_ref_len_empty
        integer(C_INT) SHT_rv_len
        SHT_rv_len = len(SHT_rv, kind=C_INT)
        call c_get_const_string_ref_len_empty_bufferify(SHT_rv, &
            SHT_rv_len)
        ! splicer end function.get_const_string_ref_len_empty
    end function get_const_string_ref_len_empty

    ! ----------------------------------------
    ! Function:  const std::string &getConstStringRefAlloc
    ! Statement: f_function_string&_cdesc_allocatable
    function get_const_string_ref_alloc() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ref_alloc
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        type(STR_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_get_const_string_ref_alloc_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call STR_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call STR_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.get_const_string_ref_alloc
    end function get_const_string_ref_alloc

    ! ----------------------------------------
    ! Function:  const string *getConstStringPtrLen +len(30)
    ! Statement: f_function_string*_buf_copy
    !>
    !! \brief return a 'const string *' as character(30)
    !!
    !! It is the caller's responsibility to release the string
    !! created by the C++ library.
    !! This is accomplished with C_finalize_buf which is possible
    !! because +len(30) so the contents are copied before returning.
    !<
    function get_const_string_ptr_len() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=30) :: SHT_rv
        ! splicer begin function.get_const_string_ptr_len
        integer(C_INT) SHT_rv_len
        SHT_rv_len = len(SHT_rv, kind=C_INT)
        call c_get_const_string_ptr_len_bufferify(SHT_rv, SHT_rv_len)
        ! splicer end function.get_const_string_ptr_len
    end function get_const_string_ptr_len

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrAlloc +owner(library)
    ! Statement: f_function_string*_cdesc_allocatable_library
    function get_const_string_ptr_alloc() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ptr_alloc
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        type(STR_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_get_const_string_ptr_alloc_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call STR_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call STR_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.get_const_string_ptr_alloc
    end function get_const_string_ptr_alloc

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAlloc +owner(caller)
    ! Statement: f_function_string*_cdesc_allocatable_caller
    !>
    !! It is the caller's responsibility to release the string
    !! created by the C++ library.
    !! This is accomplished +owner(caller) which sets idtor.
    !! The contents are copied by Fortran so they must outlast
    !! the return from the C wrapper.
    !<
    function get_const_string_ptr_owns_alloc() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ptr_owns_alloc
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        type(STR_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_get_const_string_ptr_owns_alloc_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call STR_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call STR_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.get_const_string_ptr_owns_alloc
    end function get_const_string_ptr_owns_alloc

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAllocPattern +free_pattern(C_string_free)+owner(caller)
    ! Statement: f_function_string*_cdesc_allocatable_caller
    !>
    !! Similar to getConstStringPtrOwnsAlloc, but uses pattern to release memory.
    !<
    function get_const_string_ptr_owns_alloc_pattern() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ptr_owns_alloc_pattern
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        type(STR_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_get_const_string_ptr_owns_alloc_pattern_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call STR_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call STR_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.get_const_string_ptr_owns_alloc_pattern
    end function get_const_string_ptr_owns_alloc_pattern

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrPointer +deref(pointer)+owner(library)
    ! Statement: f_function_string*_cdesc_pointer_library
    function get_const_string_ptr_pointer() &
            result(SHT_rv)
        use iso_c_binding, only : c_f_pointer
        character(len=:), pointer :: SHT_rv
        ! splicer begin function.get_const_string_ptr_pointer
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        call c_get_const_string_ptr_pointer_bufferify(SHT_rv_cdesc)
        call STR_SHROUD_pointer_string(SHT_rv_cdesc, SHT_rv)
        ! splicer end function.get_const_string_ptr_pointer
    end function get_const_string_ptr_pointer
#endif

    ! ----------------------------------------
    ! Function:  void acceptStringConstReference
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &arg1
    ! Statement: f_in_string&_buf
    !>
    !! \brief Accept a const string reference
    !!
    !! Save contents of arg1.
    !! arg1 is assumed to be intent(IN) since it is const
    !! Will copy in.
    !<
    subroutine accept_string_const_reference(arg1)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: arg1
        ! splicer begin function.accept_string_const_reference
        integer(C_INT) SHT_arg1_len
        SHT_arg1_len = len(arg1, kind=C_INT)
        call c_accept_string_const_reference_bufferify(arg1, &
            SHT_arg1_len)
        ! splicer end function.accept_string_const_reference
    end subroutine accept_string_const_reference

    ! ----------------------------------------
    ! Function:  void acceptStringReferenceOut
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1 +intent(out)
    ! Statement: f_out_string&_buf
    !>
    !! \brief Accept a string reference
    !!
    !! Set out to a constant string.
    !! arg1 is intent(OUT)
    !! Must copy out.
    !<
    subroutine accept_string_reference_out(arg1)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: arg1
        ! splicer begin function.accept_string_reference_out
        integer(C_INT) SHT_arg1_len
        SHT_arg1_len = len(arg1, kind=C_INT)
        call c_accept_string_reference_out_bufferify(arg1, SHT_arg1_len)
        ! splicer end function.accept_string_reference_out
    end subroutine accept_string_reference_out

    ! ----------------------------------------
    ! Function:  void acceptStringReference
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1
    ! Statement: f_inout_string&_buf
    !>
    !! \brief Accept a string reference
    !!
    !! Append "dog" to the end of arg1.
    !! arg1 is assumed to be intent(INOUT)
    !! Must copy in and copy out.
    !<
    ! start accept_string_reference
    subroutine accept_string_reference(arg1)
        use iso_c_binding, only : C_INT
        character(len=*), intent(INOUT) :: arg1
        ! splicer begin function.accept_string_reference
        integer(C_INT) SHT_arg1_len
        SHT_arg1_len = len(arg1, kind=C_INT)
        call c_accept_string_reference_bufferify(arg1, SHT_arg1_len)
        ! splicer end function.accept_string_reference
    end subroutine accept_string_reference
    ! end accept_string_reference

    ! ----------------------------------------
    ! Function:  void acceptStringPointerConst
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string *arg1
    ! Statement: f_in_string*_buf
    !>
    !! \brief Accept a const string pointer - intent(in)
    !!
    !<
    subroutine accept_string_pointer_const(arg1)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: arg1
        ! splicer begin function.accept_string_pointer_const
        integer(C_INT) SHT_arg1_len
        SHT_arg1_len = len(arg1, kind=C_INT)
        call c_accept_string_pointer_const_bufferify(arg1, SHT_arg1_len)
        ! splicer end function.accept_string_pointer_const
    end subroutine accept_string_pointer_const

    ! ----------------------------------------
    ! Function:  void acceptStringPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: f_inout_string*_buf
    !>
    !! \brief Accept a string pointer - intent(inout)
    !!
    !<
    subroutine accept_string_pointer(arg1)
        use iso_c_binding, only : C_INT
        character(len=*), intent(INOUT) :: arg1
        ! splicer begin function.accept_string_pointer
        integer(C_INT) SHT_arg1_len
        SHT_arg1_len = len(arg1, kind=C_INT)
        call c_accept_string_pointer_bufferify(arg1, SHT_arg1_len)
        ! splicer end function.accept_string_pointer
    end subroutine accept_string_pointer

    ! ----------------------------------------
    ! Function:  void fetchStringPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: f_out_string*_buf
    !>
    !! \brief Accept a string pointer - intent(out)
    !!
    !! Return global_str.
    !<
    subroutine fetch_string_pointer(arg1)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: arg1
        ! splicer begin function.fetch_string_pointer
        integer(C_INT) SHT_arg1_len
        SHT_arg1_len = len(arg1, kind=C_INT)
        call c_fetch_string_pointer_bufferify(arg1, SHT_arg1_len)
        ! splicer end function.fetch_string_pointer
    end subroutine fetch_string_pointer

    ! ----------------------------------------
    ! Function:  void acceptStringPointerLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: f_inout_string*_buf
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: f_out_native*
    !>
    !! \brief Accept a string pointer - intent(inout)
    !!
    !! Test return tuple with two arguments.
    !! Must rename argument to nlen to avoid conflict with intrinsic len.
    !<
    subroutine accept_string_pointer_len(arg1, nlen)
        use iso_c_binding, only : C_INT
        character(len=*), intent(INOUT) :: arg1
        integer(C_INT), intent(OUT) :: nlen
        ! splicer begin function.accept_string_pointer_len
        integer(C_INT) SHT_arg1_len
        SHT_arg1_len = len(arg1, kind=C_INT)
        call c_accept_string_pointer_len_bufferify(arg1, SHT_arg1_len, &
            nlen)
        ! splicer end function.accept_string_pointer_len
    end subroutine accept_string_pointer_len

    ! ----------------------------------------
    ! Function:  void fetchStringPointerLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: f_out_string*_buf
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: f_out_native*
    !>
    !! \brief Accept a string pointer - intent(out)
    !!
    !! Return global_str.
    !! Test return tuple with two arguments.
    !! Must rename argument to nlen to avoid conflict with intrinsic len.
    !<
    subroutine fetch_string_pointer_len(arg1, nlen)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: arg1
        integer(C_INT), intent(OUT) :: nlen
        ! splicer begin function.fetch_string_pointer_len
        integer(C_INT) SHT_arg1_len
        SHT_arg1_len = len(arg1, kind=C_INT)
        call c_fetch_string_pointer_len_bufferify(arg1, SHT_arg1_len, &
            nlen)
        ! splicer end function.fetch_string_pointer_len
    end subroutine fetch_string_pointer_len

    ! ----------------------------------------
    ! Function:  int acceptStringInstance
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  std::string arg1
    ! Statement: f_in_string_buf
    !>
    !! \brief Accept a string instance
    !!
    !<
    function accept_string_instance(arg1) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: arg1
        integer(C_INT) :: SHT_rv
        ! splicer begin function.accept_string_instance
        integer(C_INT) SHT_arg1_len
        SHT_arg1_len = len(arg1, kind=C_INT)
        SHT_rv = c_accept_string_instance_bufferify(arg1, SHT_arg1_len)
        ! splicer end function.accept_string_instance
    end function accept_string_instance

    ! ----------------------------------------
    ! Function:  void fetchArrayStringArg
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +dimension(nstrs)+intent(out)
    ! Statement: f_out_string**_cdesc_copy
    !>
    !! Copy output into argument strs which must be large enough
    !! to hold values.  Excess values will be truncated.
    !! The nstrs argument is the length of the array.
    !! It is associated with strs via the dimension(nstrs) attribute.
    !! +hidden indicates that it is not part of the Fortran API.
    !<
    subroutine fetch_array_string_arg(strs)
        use iso_c_binding, only : C_LOC
        character(len=*), intent(OUT), target :: strs(:)
        ! splicer begin function.fetch_array_string_arg
        type(STR_SHROUD_array) :: SHT_strs_cdesc
        SHT_strs_cdesc%base_addr = C_LOC(strs)
        SHT_strs_cdesc%type = SH_TYPE_CHAR
        SHT_strs_cdesc%elem_len = len(strs)
        SHT_strs_cdesc%size = size(strs)
        SHT_strs_cdesc%rank = rank(strs)
        SHT_strs_cdesc%shape(1:1) = shape(strs)
        call c_fetch_array_string_arg_bufferify(SHT_strs_cdesc)
        ! splicer end function.fetch_array_string_arg
    end subroutine fetch_array_string_arg

    ! ----------------------------------------
    ! Function:  void fetchArrayStringAlloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)
    ! Statement: f_out_string**_cdesc_allocatable
    !>
    !! Copy output into argument strs which must be large enough
    !! to hold values.  Excess values will be truncated.
    !! The nstrs argument is the length of the array.
    !! It is associated with strs via the dimension(nstrs) attribute.
    !! +hidden indicates that it is not part of the Fortran API.
    !! The defered length is set to the maximum string length.
    !<
    subroutine fetch_array_string_alloc(strs)
        use iso_c_binding, only : C_LOC
        character(:), intent(OUT), allocatable, target :: strs(:)
        ! splicer begin function.fetch_array_string_alloc
        type(STR_SHROUD_array) :: SHT_strs_cdesc
        type(STR_SHROUD_capsule_data) :: SHT_strs_capsule
        call c_fetch_array_string_alloc_bufferify(SHT_strs_cdesc, &
            SHT_strs_capsule)
        allocate(character(len=SHT_strs_cdesc%elem_len) :: &
            strs(SHT_strs_cdesc%size))
        SHT_strs_cdesc%base_addr = C_LOC(strs)
        call STR_SHROUD_array_string_allocatable(SHT_strs_cdesc, SHT_strs_capsule)
        call STR_SHROUD_capsule_dtor(SHT_strs_capsule)
        ! splicer end function.fetch_array_string_alloc
    end subroutine fetch_array_string_alloc

    ! ----------------------------------------
    ! Function:  void fetchArrayStringAllocLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)+len(20)
    ! Statement: f_out_string**_cdesc_allocatable
    !>
    !! Copy output into argument strs which must be large enough
    !! to hold values.  Excess values will be truncated.
    !! The nstrs argument is the length of the array.
    !! It is associated with strs via the dimension(nstrs) attribute.
    !! +hidden indicates that it is not part of the Fortran API.
    !! The defered length is set to the len attribute.
    !<
    subroutine fetch_array_string_alloc_len(strs)
        use iso_c_binding, only : C_LOC
        character(len=20), intent(OUT), allocatable, target :: strs(:)
        ! splicer begin function.fetch_array_string_alloc_len
        type(STR_SHROUD_array) :: SHT_strs_cdesc
        type(STR_SHROUD_capsule_data) :: SHT_strs_capsule
        call c_fetch_array_string_alloc_len_bufferify(SHT_strs_cdesc, &
            SHT_strs_capsule)
        allocate(strs(SHT_strs_cdesc%size))
        SHT_strs_cdesc%base_addr = C_LOC(strs)
        call STR_SHROUD_array_string_allocatable(SHT_strs_cdesc, SHT_strs_capsule)
        call STR_SHROUD_capsule_dtor(SHT_strs_capsule)
        ! splicer end function.fetch_array_string_alloc_len
    end subroutine fetch_array_string_alloc_len

    ! ----------------------------------------
    ! Function:  void explicit1
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(in)+len_trim(AAlen)
    ! Statement: f_in_char*
    subroutine explicit1(name)
        use iso_c_binding, only : C_NULL_CHAR
        character(len=*), intent(IN) :: name
        ! splicer begin function.explicit1
        call c_explicit1(trim(name)//C_NULL_CHAR)
        ! splicer end function.explicit1
    end subroutine explicit1

    ! ----------------------------------------
    ! Function:  void explicit2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(out)+len(AAtrim)
    ! Statement: f_out_char*_buf
    subroutine explicit2(name)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: name
        ! splicer begin function.explicit2
        integer(C_INT) SHT_name_len
        SHT_name_len = len(name, kind=C_INT)
        call c_explicit2_bufferify(name, SHT_name_len)
        ! splicer end function.explicit2
    end subroutine explicit2

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void CpassChar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    !>
    !! \brief pass a single char argument as a scalar, extern "C"
    !!
    !<
    subroutine cpass_char(status)
        character, value, intent(IN) :: status
        ! splicer begin function.cpass_char
        call c_cpass_char(status)
        ! splicer end function.cpass_char
    end subroutine cpass_char
#endif

    ! ----------------------------------------
    ! Function:  char CreturnChar
    ! Statement: f_function_char
    !>
    !! \brief return a char argument (non-pointer), extern "C"
    !!
    !<
    function creturn_char() &
            result(SHT_rv)
        character :: SHT_rv
        ! splicer begin function.creturn_char
        call c_creturn_char(SHT_rv)
        ! splicer end function.creturn_char
    end function creturn_char

    ! ----------------------------------------
    ! Function:  void CpassCharPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: f_out_char*_buf
    ! ----------------------------------------
    ! Argument:  const char *src +blanknull
    ! Statement: f_in_char*_buf
    !>
    !! \brief strcpy like behavior
    !!
    !! dest is marked intent(OUT) to override the intent(INOUT) default
    !! This avoid a copy-in on dest.
    !! extern "C"
    !! If src is a blank string, pass a NULL pointer to C library function.
    !<
    subroutine cpass_char_ptr(dest, src)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: dest
        character(len=*), intent(IN) :: src
        ! splicer begin function.cpass_char_ptr
        integer(C_INT) SHT_dest_len
        integer(C_INT) SHT_src_len
        SHT_dest_len = len(dest, kind=C_INT)
        SHT_src_len = len(src, kind=C_INT)
        call c_cpass_char_ptr_bufferify(dest, SHT_dest_len, src, &
            SHT_src_len)
        ! splicer end function.cpass_char_ptr
    end subroutine cpass_char_ptr

    ! ----------------------------------------
    ! Function:  void CpassCharPtrBlank
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: f_out_char*_buf
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*_buf
    !>
    !! \brief Test F_blanknull option
    !!
    !<
    subroutine cpass_char_ptr_blank(dest, src)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: dest
        character(len=*), intent(IN) :: src
        ! splicer begin function.cpass_char_ptr_blank
        integer(C_INT) SHT_dest_len
        integer(C_INT) SHT_src_len
        SHT_dest_len = len(dest, kind=C_INT)
        SHT_src_len = len(src, kind=C_INT)
        call c_cpass_char_ptr_blank_bufferify(dest, SHT_dest_len, src, &
            SHT_src_len)
        ! splicer end function.cpass_char_ptr_blank
    end subroutine cpass_char_ptr_blank

    ! ----------------------------------------
    ! Function:  void PostDeclare
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *count +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  std::string &name
    ! Statement: f_inout_string&_buf
    !>
    !! Test post_declare.
    !! The std::string in py_string_inout must be declared before the
    !! goto added by py_native_*_in_pointer_list to avoid
    !! "jump to label 'fail' crosses initialization of" error.
    !<
    subroutine post_declare(count, name)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: count(:)
        character(len=*), intent(INOUT) :: name
        ! splicer begin function.post_declare
        integer(C_INT) SHT_name_len
        SHT_name_len = len(name, kind=C_INT)
        call c_post_declare_bufferify(count, name, SHT_name_len)
        ! splicer end function.post_declare
    end subroutine post_declare

    ! ----------------------------------------
    ! Function:  int CpassCharPtrNotrim
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*_buf
    !>
    !! \brief NULL terminate input string in C, not in Fortran.
    !!
    !<
    function cpass_char_ptr_notrim(src) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: src
        integer(C_INT) :: SHT_rv
        ! splicer begin function.cpass_char_ptr_notrim
        integer(C_INT) SHT_src_len
        SHT_src_len = len(src, kind=C_INT)
        SHT_rv = c_cpass_char_ptr_notrim_bufferify(src, SHT_src_len)
        ! splicer end function.cpass_char_ptr_notrim
    end function cpass_char_ptr_notrim

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int CpassCharPtrCAPI
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void *addr
    ! Statement: f_in_void*
    ! ----------------------------------------
    ! Argument:  const char *src +api(capi)
    ! Statement: f_in_char*_capi
    !>
    !! \brief Do not NULL terminate input string
    !!
    !! The C library function should get the same address
    !! for addr and src.
    !! Used when the C function needs the true address of the argument.
    !! Skips null-termination. Useful to create an interface for
    !! a function which is already callable by Fortran.
    !! For example, the length is passed explicitly.
    !! This example will not create a Fortran wrapper since C can be
    !! called directly.
    !<
    function cpass_char_ptr_capi(addr, src) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR
        type(C_PTR), intent(IN) :: addr
        character(len=*), intent(IN) :: src
        integer(C_INT) :: SHT_rv
        ! splicer begin function.cpass_char_ptr_capi
        SHT_rv = c_cpass_char_ptr_capi(addr, src)
        ! splicer end function.cpass_char_ptr_capi
    end function cpass_char_ptr_capi
#endif

    ! ----------------------------------------
    ! Function:  int CpassCharPtrCAPI2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *in
    ! Statement: f_in_char*
    ! ----------------------------------------
    ! Argument:  const char *src +api(capi)
    ! Statement: f_in_char*_capi
    !>
    !! \brief Mix api(buf) and api(capi)
    !!
    !<
    function cpass_char_ptr_capi2(in, src) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_NULL_CHAR
        character(len=*), intent(IN) :: in
        character(len=*), intent(IN) :: src
        integer(C_INT) :: SHT_rv
        ! splicer begin function.cpass_char_ptr_capi2
        SHT_rv = c_cpass_char_ptr_capi2(trim(in)//C_NULL_CHAR, src)
        ! splicer end function.cpass_char_ptr_capi2
    end function cpass_char_ptr_capi2

    ! splicer begin additional_functions
    ! splicer end additional_functions

    ! helper pointer_string
    ! Assign context to an assumed-length character pointer
    subroutine STR_SHROUD_pointer_string(context, var)
        use iso_c_binding, only : c_f_pointer, C_PTR
        implicit none
        type(STR_SHROUD_array), intent(IN) :: context
        character(len=:), pointer, intent(OUT) :: var
        character(len=context%elem_len), pointer :: fptr
        call c_f_pointer(context%base_addr, fptr)
        var => fptr
    end subroutine STR_SHROUD_pointer_string

end module strings_mod
