// wrapstrings.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "strings.hpp"
#include "shroud/features.h"
// typemap
#include <string>
// shroud
#include <cstring>
#include <cstdlib>
#include "wrapstrings.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {


// helper char_len_trim
// Returns the length of character string src with length nsrc,
// ignoring any trailing blanks.
static int ShroudCharLenTrim(const char *src, int nsrc) {
    int i;

    for (i = nsrc - 1; i >= 0; i--) {
        if (src[i] != ' ') {
            break;
        }
    }

    return i + 1;
}


// helper char_alloc
// Copy src into new memory and null terminate.
// If ntrim is 0, return NULL pointer.
// If blanknull is 1, return NULL when string is blank.
static char *ShroudCharAlloc(const char *src, int nsrc, int blanknull)
{
    int ntrim = ShroudCharLenTrim(src, nsrc);
    if (ntrim == 0 && blanknull == 1) {
        return nullptr;
    }
    char *rv = (char *) std::malloc(nsrc + 1);
    if (ntrim > 0) {
        std::memcpy(rv, src, ntrim);
    }
    rv[ntrim] = '\0';
    return rv;
}

// helper char_blank_fill
// blank fill dest starting at trailing NULL.
static void ShroudCharBlankFill(char *dest, int ndest)
{
    int nm = std::strlen(dest);
    if(ndest > nm) std::memset(dest+nm,' ',ndest-nm);
}

// helper ShroudCharCopy
// Copy src into dest, blank fill to ndest characters
// Truncate if dest is too short.
// dest will not be NULL terminated.
static void ShroudCharCopy(char *dest, int ndest, const char *src, int nsrc)
{
    if (src == NULL) {
        std::memset(dest,' ',ndest); // convert NULL pointer to blank filled string
    } else {
        if (nsrc < 0) nsrc = std::strlen(src);
        int nm = nsrc < ndest ? nsrc : ndest;
        std::memcpy(dest,src,nm);
        if(ndest > nm) std::memset(dest+nm,' ',ndest-nm); // blank fill
    }
}

// helper char_free
// Release memory allocated by ShroudCharAlloc
static void ShroudCharFree(char *src)
{
    if (src != NULL) {
        std::free(src);
    }
}

// splicer begin C_definitions
// splicer end C_definitions

// ----------------------------------------
// Function:  void init_test
// Statement: c_subroutine
void STR_init_test(void)
{
    // splicer begin function.init_test
    init_test();
    // splicer end function.init_test
}

/**
 * \brief pass a single char argument as a scalar.
 *
 */
// ----------------------------------------
// Function:  void passChar
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char status
// Statement: c_in_char
void STR_passChar(char status)
{
    // splicer begin function.passChar
    passChar(status);
    // splicer end function.passChar
}

/**
 * By default no Fortran wrapper is created.
 * Force one so it can be tested.
 */
// ----------------------------------------
// Function:  void passCharForce
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char status
// Statement: c_in_char
void STR_passCharForce(char status)
{
    // splicer begin function.passCharForce
    passCharForce(status);
    // splicer end function.passCharForce
}

/**
 * \brief return a char argument (non-pointer)
 *
 */
// ----------------------------------------
// Function:  char returnChar
// Statement: c_function_char
void STR_returnChar(char *SHC_rv)
{
    // splicer begin function.returnChar
    *SHC_rv = returnChar();
    // splicer end function.returnChar
}

/**
 * \brief strcpy like behavior
 *
 * dest is marked intent(OUT) to override the intent(INOUT) default
 * This avoid a copy-in on dest.
 * In Python, src must not be over 40 characters, defined by charlen.
 */
// ----------------------------------------
// Function:  void passCharPtr
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *dest +charlen(40)+intent(out)
// Statement: c_out_char*
// ----------------------------------------
// Argument:  const char *src
// Statement: c_in_char*
// start STR_passCharPtr
void STR_passCharPtr(char *dest, const char *src)
{
    // splicer begin function.passCharPtr
    passCharPtr(dest, src);
    // splicer end function.passCharPtr
}
// end STR_passCharPtr

/**
 * \brief strcpy like behavior
 *
 * dest is marked intent(OUT) to override the intent(INOUT) default
 * This avoid a copy-in on dest.
 * In Python, src must not be over 40 characters, defined by charlen.
 */
// ----------------------------------------
// Function:  void passCharPtr
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *dest +charlen(40)+intent(out)
// Statement: f_out_char*_cfi
// ----------------------------------------
// Argument:  const char *src
// Statement: f_in_char*_cfi
// start STR_passCharPtr_CFI
void STR_passCharPtr_CFI(CFI_cdesc_t *SHT_dest_cfi,
    CFI_cdesc_t *SHT_src_cfi)
{
    // splicer begin function.passCharPtr_CFI
    char *SHC_dest_cxx = static_cast<char *>(SHT_dest_cfi->base_addr);
    char *src = static_cast<char *>(SHT_src_cfi->base_addr);
    char *SHC_src_cxx = ShroudCharAlloc(src, SHT_src_cfi->elem_len, 0);
    passCharPtr(SHC_dest_cxx, SHC_src_cxx);
    ShroudCharBlankFill(SHC_dest_cxx, SHT_dest_cfi->elem_len);
    ShroudCharFree(SHC_src_cxx);
    // splicer end function.passCharPtr_CFI
}
// end STR_passCharPtr_CFI

/**
 * \brief toupper
 *
 * Change a string in-place.
 * For Python, return a new string since strings are immutable.
 */
// ----------------------------------------
// Function:  void passCharPtrInOut
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *s +intent(inout)
// Statement: c_inout_char*
void STR_passCharPtrInOut(char *s)
{
    // splicer begin function.passCharPtrInOut
    passCharPtrInOut(s);
    // splicer end function.passCharPtrInOut
}

/**
 * \brief toupper
 *
 * Change a string in-place.
 * For Python, return a new string since strings are immutable.
 */
// ----------------------------------------
// Function:  void passCharPtrInOut
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *s +intent(inout)
// Statement: f_inout_char*_cfi
void STR_passCharPtrInOut_CFI(CFI_cdesc_t *SHT_s_cfi)
{
    // splicer begin function.passCharPtrInOut_CFI
    char *s = static_cast<char *>(SHT_s_cfi->base_addr);
    char *SHC_s_cxx = ShroudCharAlloc(s, SHT_s_cfi->elem_len, 0);
    passCharPtrInOut(SHC_s_cxx);
    ShroudCharCopy(s, SHT_s_cfi->elem_len, SHC_s_cxx, -1);
    ShroudCharFree(SHC_s_cxx);
    // splicer end function.passCharPtrInOut_CFI
}

/**
 * \brief return a 'const char *' as character(*)
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr1
// Statement: c_function_char*
// start STR_getCharPtr1
const char * STR_getCharPtr1(void)
{
    // splicer begin function.getCharPtr1
    const char *SHC_rv = getCharPtr1();
    return SHC_rv;
    // splicer end function.getCharPtr1
}
// end STR_getCharPtr1

/**
 * \brief return a 'const char *' as character(*)
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr1
// Statement: f_function_char*_cfi_allocatable
// start STR_getCharPtr1_CFI
void STR_getCharPtr1_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getCharPtr1_CFI
    const char *SHC_rv = getCharPtr1();
    if (SHC_rv != nullptr) {
        int SH_ret = CFI_allocate(SHT_rv_cfi, (CFI_index_t *) 0, 
            (CFI_index_t *) 0, strlen(SHC_rv));
        if (SH_ret == CFI_SUCCESS) {
            std::memcpy(SHT_rv_cfi->base_addr, SHC_rv, 
                SHT_rv_cfi->elem_len);
        }
    }
    // splicer end function.getCharPtr1_CFI
}
// end STR_getCharPtr1_CFI

/**
 * \brief return 'const char *' with fixed size (len=30)
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr2 +len(30)
// Statement: c_function_char*
// start STR_getCharPtr2
const char * STR_getCharPtr2(void)
{
    // splicer begin function.getCharPtr2
    const char *SHC_rv = getCharPtr2();
    return SHC_rv;
    // splicer end function.getCharPtr2
}
// end STR_getCharPtr2

/**
 * \brief return 'const char *' with fixed size (len=30)
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr2 +len(30)
// Statement: f_function_char*_cfi_copy
// start STR_getCharPtr2_CFI
void STR_getCharPtr2_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getCharPtr2_CFI
    const char *SHC_rv_cxx = getCharPtr2();
    char *SHC_rv = static_cast<char *>(SHT_rv_cfi->base_addr);
    ShroudCharCopy(SHC_rv, SHT_rv_cfi->elem_len, SHC_rv_cxx, -1);
    // splicer end function.getCharPtr2_CFI
}
// end STR_getCharPtr2_CFI

/**
 * \brief return a 'const char *' as argument
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr3
// Statement: c_function_char*
// start STR_getCharPtr3
const char * STR_getCharPtr3(void)
{
    // splicer begin function.getCharPtr3
    const char *SHC_rv = getCharPtr3();
    return SHC_rv;
    // splicer end function.getCharPtr3
}
// end STR_getCharPtr3

/**
 * \brief return a 'const char *' as argument
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr3
// Statement: f_function_char*_cfi_arg
// start STR_getCharPtr3_CFI
void STR_getCharPtr3_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getCharPtr3_CFI
    const char *SHC_rv_cxx = getCharPtr3();
    char *output = static_cast<char *>(SHT_rv_cfi->base_addr);
    ShroudCharCopy(output, SHT_rv_cfi->elem_len, SHC_rv_cxx, -1);
    // splicer end function.getCharPtr3_CFI
}
// end STR_getCharPtr3_CFI

/**
 * \brief return a 'const char *' as type(C_PTR)
 *
 */
// ----------------------------------------
// Function:  const char *getCharPtr4 +deref(raw)
// Statement: c_function_char*
const char * STR_getCharPtr4(void)
{
    // splicer begin function.getCharPtr4
    const char *SHC_rv = getCharPtr4();
    return SHC_rv;
    // splicer end function.getCharPtr4
}

/**
 * \brief return a 'const char *' as character(:) pointer
 *
 */
#ifdef HAVE_CHARACTER_POINTER_FUNCTION
// ----------------------------------------
// Function:  const char *getCharPtr5 +deref(pointer)
// Statement: c_function_char*
const char * STR_getCharPtr5(void)
{
    // splicer begin function.getCharPtr5
    const char *SHC_rv = getCharPtr5();
    return SHC_rv;
    // splicer end function.getCharPtr5
}
#endif  // ifdef HAVE_CHARACTER_POINTER_FUNCTION

/**
 * \brief return a 'const char *' as character(:) pointer
 *
 */
#ifdef HAVE_CHARACTER_POINTER_FUNCTION
// ----------------------------------------
// Function:  const char *getCharPtr5 +deref(pointer)
// Statement: f_function_char*_cfi_pointer
void STR_getCharPtr5_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getCharPtr5_CFI
    const char *SHC_rv = getCharPtr5();
    int SHC_rv_err;
    if (SHC_rv == nullptr) {
        SHC_rv_err = CFI_setpointer(SHT_rv_cfi, nullptr, nullptr);
    } else {
        CFI_CDESC_T(0) SHC_rv_fptr;
        CFI_cdesc_t *SHC_rv_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_rv_fptr);
        void *SHC_rv_cptr = const_cast<char *>(SHC_rv);
        size_t SHC_rv_len = std::strlen(SHC_rv);
        SHC_rv_err = CFI_establish(SHC_rv_cdesc, SHC_rv_cptr,
            CFI_attribute_pointer, CFI_type_char, SHC_rv_len, 0,
            nullptr);
        if (SHC_rv_err == CFI_SUCCESS) {
            SHT_rv_cfi->elem_len = SHC_rv_cdesc->elem_len;
            SHC_rv_err = CFI_setpointer(SHT_rv_cfi, SHC_rv_cdesc,
                nullptr);
        }
    }
    // splicer end function.getCharPtr5_CFI
}
#endif  // ifdef HAVE_CHARACTER_POINTER_FUNCTION

#if 0
! Not Implemented
/**
 * \brief return an ALLOCATABLE CHARACTER from std::string
 *
 */
// ----------------------------------------
// Function:  const string getConstStringResult
// Statement: c_function_string
const char STR_getConstStringResult(void)
{
    // splicer begin function.getConstStringResult
    const std::string SHCXX_rv = getConstStringResult();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringResult
}
#endif

/**
 * \brief return an ALLOCATABLE CHARACTER from std::string
 *
 */
// ----------------------------------------
// Function:  const string getConstStringResult
// Statement: f_function_string_cfi_allocatable
void STR_getConstStringResult_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringResult_CFI
    const std::string SHCXX_rv = getConstStringResult();
    // C_error_pattern
    // Some error code for buf

    int SH_ret = CFI_allocate(SHT_rv_cfi, (CFI_index_t *) 0, 
        (CFI_index_t *) 0, SHCXX_rv.length());
    if (SH_ret == CFI_SUCCESS) {
        std::memcpy(SHT_rv_cfi->base_addr, SHCXX_rv.data(), 
            SHT_rv_cfi->elem_len);
    }
    // splicer end function.getConstStringResult_CFI
}

#if 0
! Not Implemented
/**
 * \brief return a 'const string' as argument
 *
 */
// ----------------------------------------
// Function:  const string getConstStringLen +len(30)
// Statement: c_function_string
const char STR_getConstStringLen(void)
{
    // splicer begin function.getConstStringLen
    const std::string SHCXX_rv = getConstStringLen();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringLen
}
#endif

/**
 * \brief return a 'const string' as argument
 *
 */
// ----------------------------------------
// Function:  const string getConstStringLen +len(30)
// Statement: f_function_string_cfi_copy
void STR_getConstStringLen_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringLen_CFI
    const std::string SHC_rv_cxx = getConstStringLen();
    // C_error_pattern
    // Some error code for buf

    char *SHC_rv = static_cast<char *>(SHT_rv_cfi->base_addr);
    if (SHC_rv_cxx.empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_cfi->elem_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_cfi->elem_len, SHC_rv_cxx.data(),
            SHC_rv_cxx.size());
    }
    // splicer end function.getConstStringLen_CFI
}

#if 0
! Not Implemented
/**
 * \brief return a 'const string' as argument
 *
 */
// ----------------------------------------
// Function:  const string getConstStringAsArg
// Statement: c_function_string
const char STR_getConstStringAsArg(void)
{
    // splicer begin function.getConstStringAsArg
    const std::string SHCXX_rv = getConstStringAsArg();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringAsArg
}
#endif

/**
 * \brief return a 'const string' as argument
 *
 */
// ----------------------------------------
// Function:  const string getConstStringAsArg
// Statement: f_function_string_cfi_arg
void STR_getConstStringAsArg_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringAsArg_CFI
    const std::string SHC_rv_cxx = getConstStringAsArg();
    // C_error_pattern
    // Some error code for buf

    char *output = static_cast<char *>(SHT_rv_cfi->base_addr);
    if (SHC_rv_cxx.empty()) {
        ShroudCharCopy(output, SHT_rv_cfi->elem_len, nullptr, 0);
    } else {
        ShroudCharCopy(output, SHT_rv_cfi->elem_len, SHC_rv_cxx.data(),
            SHC_rv_cxx.size());
    }
    // splicer end function.getConstStringAsArg_CFI
}

#if 0
! Not Implemented
// ----------------------------------------
// Function:  const std::string getConstStringAlloc
// Statement: c_function_string
const char STR_getConstStringAlloc(void)
{
    // splicer begin function.getConstStringAlloc
    const std::string SHCXX_rv = getConstStringAlloc();
    const char SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringAlloc
}
#endif

// ----------------------------------------
// Function:  const std::string getConstStringAlloc
// Statement: f_function_string_cfi_allocatable
void STR_getConstStringAlloc_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringAlloc_CFI
    const std::string SHCXX_rv = getConstStringAlloc();
    int SH_ret = CFI_allocate(SHT_rv_cfi, (CFI_index_t *) 0, 
        (CFI_index_t *) 0, SHCXX_rv.length());
    if (SH_ret == CFI_SUCCESS) {
        std::memcpy(SHT_rv_cfi->base_addr, SHCXX_rv.data(), 
            SHT_rv_cfi->elem_len);
    }
    // splicer end function.getConstStringAlloc_CFI
}

/**
 * \brief return a 'const string&' as ALLOCATABLE character
 *
 */
// ----------------------------------------
// Function:  const string &getConstStringRefPure
// Statement: c_function_string&
// start STR_getConstStringRefPure
const char * STR_getConstStringRefPure(void)
{
    // splicer begin function.getConstStringRefPure
    const std::string &SHCXX_rv = getConstStringRefPure();
    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringRefPure
}
// end STR_getConstStringRefPure

/**
 * \brief return a 'const string&' as ALLOCATABLE character
 *
 */
// ----------------------------------------
// Function:  const string &getConstStringRefPure
// Statement: f_function_string&_cfi_allocatable
// start STR_getConstStringRefPure_CFI
void STR_getConstStringRefPure_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringRefPure_CFI
    const std::string &SHCXX_rv = getConstStringRefPure();
    int SH_ret = CFI_allocate(SHT_rv_cfi, (CFI_index_t *) 0, 
        (CFI_index_t *) 0, SHCXX_rv.length());
    if (SH_ret == CFI_SUCCESS) {
        std::memcpy(SHT_rv_cfi->base_addr, SHCXX_rv.data(), 
            SHCXX_rv.length());
    }
    // splicer end function.getConstStringRefPure_CFI
}
// end STR_getConstStringRefPure_CFI

/**
 * \brief return 'const string&' with fixed size (len=30)
 *
 * Since +len(30) is provided, the result of the function
 * will be copied directly into memory provided by Fortran.
 * The function will not be ALLOCATABLE.
 */
// ----------------------------------------
// Function:  const string &getConstStringRefLen +len(30)
// Statement: c_function_string&
const char * STR_getConstStringRefLen(void)
{
    // splicer begin function.getConstStringRefLen
    const std::string &SHCXX_rv = getConstStringRefLen();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringRefLen
}

/**
 * \brief return 'const string&' with fixed size (len=30)
 *
 * Since +len(30) is provided, the result of the function
 * will be copied directly into memory provided by Fortran.
 * The function will not be ALLOCATABLE.
 */
// ----------------------------------------
// Function:  const string &getConstStringRefLen +len(30)
// Statement: f_function_string&_cfi_copy
void STR_getConstStringRefLen_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringRefLen_CFI
    const std::string &SHC_rv_cxx = getConstStringRefLen();
    // C_error_pattern
    // Some error code for buf

    char *SHC_rv = static_cast<char *>(SHT_rv_cfi->base_addr);
    if (SHC_rv_cxx.empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_cfi->elem_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_cfi->elem_len, SHC_rv_cxx.data(),
            SHC_rv_cxx.size());
    }
    // splicer end function.getConstStringRefLen_CFI
}

/**
 * \brief return a 'const string&' as argument
 *
 * Pass an additional argument which will be used as the return value.
 * The length of the output variable is declared by the caller.
 */
// ----------------------------------------
// Function:  const string &getConstStringRefAsArg
// Statement: c_function_string&
const char * STR_getConstStringRefAsArg(void)
{
    // splicer begin function.getConstStringRefAsArg
    const std::string &SHCXX_rv = getConstStringRefAsArg();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringRefAsArg
}

/**
 * \brief return a 'const string&' as argument
 *
 * Pass an additional argument which will be used as the return value.
 * The length of the output variable is declared by the caller.
 */
// ----------------------------------------
// Function:  const string &getConstStringRefAsArg
// Statement: f_function_string&_cfi_arg
void STR_getConstStringRefAsArg_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringRefAsArg_CFI
    const std::string &SHC_rv_cxx = getConstStringRefAsArg();
    // C_error_pattern
    // Some error code for buf

    char *output = static_cast<char *>(SHT_rv_cfi->base_addr);
    if (SHC_rv_cxx.empty()) {
        ShroudCharCopy(output, SHT_rv_cfi->elem_len, nullptr, 0);
    } else {
        ShroudCharCopy(output, SHT_rv_cfi->elem_len, SHC_rv_cxx.data(),
            SHC_rv_cxx.size());
    }
    // splicer end function.getConstStringRefAsArg_CFI
}

/**
 * \brief Test returning empty string reference
 *
 */
// ----------------------------------------
// Function:  const string &getConstStringRefLenEmpty +len(30)
// Statement: c_function_string&
const char * STR_getConstStringRefLenEmpty(void)
{
    // splicer begin function.getConstStringRefLenEmpty
    const std::string &SHCXX_rv = getConstStringRefLenEmpty();
    // C_error_pattern
    if (SHCXX_rv.empty()) {
        return NULL;
    }

    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringRefLenEmpty
}

/**
 * \brief Test returning empty string reference
 *
 */
// ----------------------------------------
// Function:  const string &getConstStringRefLenEmpty +len(30)
// Statement: f_function_string&_cfi_copy
void STR_getConstStringRefLenEmpty_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringRefLenEmpty_CFI
    const std::string &SHC_rv_cxx = getConstStringRefLenEmpty();
    // C_error_pattern
    // Some error code for buf

    char *SHC_rv = static_cast<char *>(SHT_rv_cfi->base_addr);
    if (SHC_rv_cxx.empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_cfi->elem_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_cfi->elem_len, SHC_rv_cxx.data(),
            SHC_rv_cxx.size());
    }
    // splicer end function.getConstStringRefLenEmpty_CFI
}

// ----------------------------------------
// Function:  const std::string &getConstStringRefAlloc
// Statement: c_function_string&
const char * STR_getConstStringRefAlloc(void)
{
    // splicer begin function.getConstStringRefAlloc
    const std::string &SHCXX_rv = getConstStringRefAlloc();
    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getConstStringRefAlloc
}

// ----------------------------------------
// Function:  const std::string &getConstStringRefAlloc
// Statement: f_function_string&_cfi_allocatable
void STR_getConstStringRefAlloc_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringRefAlloc_CFI
    const std::string &SHCXX_rv = getConstStringRefAlloc();
    int SH_ret = CFI_allocate(SHT_rv_cfi, (CFI_index_t *) 0, 
        (CFI_index_t *) 0, SHCXX_rv.length());
    if (SH_ret == CFI_SUCCESS) {
        std::memcpy(SHT_rv_cfi->base_addr, SHCXX_rv.data(), 
            SHCXX_rv.length());
    }
    // splicer end function.getConstStringRefAlloc_CFI
}

/**
 * \brief return a 'const string *' as character(30)
 *
 * It is the caller's responsibility to release the string
 * created by the C++ library.
 * This is accomplished with C_finalize_buf which is possible
 * because +len(30) so the contents are copied before returning.
 */
// ----------------------------------------
// Function:  const string *getConstStringPtrLen +len(30)
// Statement: c_function_string*
const char * STR_getConstStringPtrLen(void)
{
    // splicer begin function.getConstStringPtrLen
    const std::string *SHCXX_rv = getConstStringPtrLen();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrLen
}

/**
 * \brief return a 'const string *' as character(30)
 *
 * It is the caller's responsibility to release the string
 * created by the C++ library.
 * This is accomplished with C_finalize_buf which is possible
 * because +len(30) so the contents are copied before returning.
 */
// ----------------------------------------
// Function:  const string *getConstStringPtrLen +len(30)
// Statement: f_function_string*_cfi_copy
void STR_getConstStringPtrLen_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringPtrLen_CFI
    const std::string *SHC_rv_cxx = getConstStringPtrLen();
    char *SHC_rv = static_cast<char *>(SHT_rv_cfi->base_addr);
    if (SHC_rv_cxx->empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_cfi->elem_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_cfi->elem_len, SHC_rv_cxx->data(),
            SHC_rv_cxx->size());
    }
    {
        // final
        delete SHC_rv_cxx;
    }
    // splicer end function.getConstStringPtrLen_CFI
}

// ----------------------------------------
// Function:  const std::string *getConstStringPtrAlloc +owner(library)
// Statement: c_function_string*_library
const char * STR_getConstStringPtrAlloc(void)
{
    // splicer begin function.getConstStringPtrAlloc
    const std::string *SHCXX_rv = getConstStringPtrAlloc();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrAlloc
}

// ----------------------------------------
// Function:  const std::string *getConstStringPtrAlloc +owner(library)
// Statement: f_function_string*_cfi_allocatable_library
void STR_getConstStringPtrAlloc_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringPtrAlloc_CFI
    const std::string *SHCXX_rv = getConstStringPtrAlloc();
    int SH_ret = CFI_allocate(SHT_rv_cfi, (CFI_index_t *) 0, 
        (CFI_index_t *) 0, SHCXX_rv->length());
    if (SH_ret == CFI_SUCCESS) {
        std::memcpy(SHT_rv_cfi->base_addr, SHCXX_rv->data(), 
            SHCXX_rv->length());
    }
    // splicer end function.getConstStringPtrAlloc_CFI
}

/**
 * It is the caller's responsibility to release the string
 * created by the C++ library.
 * This is accomplished +owner(caller) which sets idtor.
 * The contents are copied by Fortran so they must outlast
 * the return from the C wrapper.
 */
// ----------------------------------------
// Function:  const std::string *getConstStringPtrOwnsAlloc +owner(caller)
// Statement: c_function_string*_caller
const char * STR_getConstStringPtrOwnsAlloc(void)
{
    // splicer begin function.getConstStringPtrOwnsAlloc
    const std::string *SHCXX_rv = getConstStringPtrOwnsAlloc();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrOwnsAlloc
}

/**
 * It is the caller's responsibility to release the string
 * created by the C++ library.
 * This is accomplished +owner(caller) which sets idtor.
 * The contents are copied by Fortran so they must outlast
 * the return from the C wrapper.
 */
// ----------------------------------------
// Function:  const std::string *getConstStringPtrOwnsAlloc +owner(caller)
// Statement: f_function_string*_cfi_allocatable_caller
void STR_getConstStringPtrOwnsAlloc_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringPtrOwnsAlloc_CFI
    const std::string *SHCXX_rv = getConstStringPtrOwnsAlloc();
    int SH_ret = CFI_allocate(SHT_rv_cfi, (CFI_index_t *) 0, 
        (CFI_index_t *) 0, SHCXX_rv->length());
    if (SH_ret == CFI_SUCCESS) {
        std::memcpy(SHT_rv_cfi->base_addr, SHCXX_rv->data(), 
            SHCXX_rv->length());
    }
    // splicer end function.getConstStringPtrOwnsAlloc_CFI
}

/**
 * Similar to getConstStringPtrOwnsAlloc, but uses pattern to release memory.
 */
// ----------------------------------------
// Function:  const std::string *getConstStringPtrOwnsAllocPattern +free_pattern(C_string_free)+owner(caller)
// Statement: c_function_string*_caller
const char * STR_getConstStringPtrOwnsAllocPattern(void)
{
    // splicer begin function.getConstStringPtrOwnsAllocPattern
    const std::string *SHCXX_rv = getConstStringPtrOwnsAllocPattern();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrOwnsAllocPattern
}

/**
 * Similar to getConstStringPtrOwnsAlloc, but uses pattern to release memory.
 */
// ----------------------------------------
// Function:  const std::string *getConstStringPtrOwnsAllocPattern +free_pattern(C_string_free)+owner(caller)
// Statement: f_function_string*_cfi_allocatable_caller
void STR_getConstStringPtrOwnsAllocPattern_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringPtrOwnsAllocPattern_CFI
    const std::string *SHCXX_rv = getConstStringPtrOwnsAllocPattern();
    int SH_ret = CFI_allocate(SHT_rv_cfi, (CFI_index_t *) 0, 
        (CFI_index_t *) 0, SHCXX_rv->length());
    if (SH_ret == CFI_SUCCESS) {
        std::memcpy(SHT_rv_cfi->base_addr, SHCXX_rv->data(), 
            SHCXX_rv->length());
    }
    // splicer end function.getConstStringPtrOwnsAllocPattern_CFI
}

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
// ----------------------------------------
// Function:  const std::string *getConstStringPtrPointer +deref(pointer)+owner(library)
// Statement: c_function_string*_library
const char * STR_getConstStringPtrPointer(void)
{
    // splicer begin function.getConstStringPtrPointer
    const std::string *SHCXX_rv = getConstStringPtrPointer();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrPointer
}
#endif  // ifdef HAVE_CHARACTER_POINTER_FUNCTION

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
// ----------------------------------------
// Function:  const std::string *getConstStringPtrPointer +deref(pointer)+owner(library)
// Statement: f_function_string*_cfi_pointer_library
void STR_getConstStringPtrPointer_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.getConstStringPtrPointer_CFI
    const std::string *SHCXX_rv = getConstStringPtrPointer();
    int SHC_rv_err;
    if (SHCXX_rv == nullptr) {
        SHC_rv_err = CFI_setpointer(SHT_rv_cfi, nullptr, nullptr);
    } else {
        CFI_CDESC_T(0) SHC_rv_fptr;
        CFI_cdesc_t *SHC_rv_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_rv_fptr);
        void *SHC_rv_cptr = const_cast<char *>(SHCXX_rv->data());
        size_t SHC_rv_len = SHCXX_rv->length();
        SHC_rv_err = CFI_establish(SHC_rv_cdesc, SHC_rv_cptr,
            CFI_attribute_pointer, CFI_type_char, SHC_rv_len, 0,
            nullptr);
        if (SHC_rv_err == CFI_SUCCESS) {
            SHT_rv_cfi->elem_len = SHC_rv_cdesc->elem_len;
            SHC_rv_err = CFI_setpointer(SHT_rv_cfi, SHC_rv_cdesc,
                nullptr);
        }
    }
    // splicer end function.getConstStringPtrPointer_CFI
}
#endif  // ifdef HAVE_CHARACTER_POINTER_FUNCTION

/**
 * \brief Accept a const string reference
 *
 * Save contents of arg1.
 * arg1 is assumed to be intent(IN) since it is const
 * Will copy in.
 */
// ----------------------------------------
// Function:  void acceptStringConstReference
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const std::string &arg1
// Statement: c_in_string&
void STR_acceptStringConstReference(const char *arg1)
{
    // splicer begin function.acceptStringConstReference
    const std::string SHC_arg1_cxx(arg1);
    acceptStringConstReference(SHC_arg1_cxx);
    // splicer end function.acceptStringConstReference
}

/**
 * \brief Accept a const string reference
 *
 * Save contents of arg1.
 * arg1 is assumed to be intent(IN) since it is const
 * Will copy in.
 */
// ----------------------------------------
// Function:  void acceptStringConstReference
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const std::string &arg1
// Statement: f_in_string&_cfi
void STR_acceptStringConstReference_CFI(CFI_cdesc_t *SHT_arg1_cfi)
{
    // splicer begin function.acceptStringConstReference_CFI
    char *arg1 = static_cast<char *>(SHT_arg1_cfi->base_addr);
    size_t SHC_arg1_trim = ShroudCharLenTrim(arg1, SHT_arg1_cfi->elem_len);
    const std::string SHC_arg1_cxx(arg1, SHC_arg1_trim);
    acceptStringConstReference(SHC_arg1_cxx);
    // splicer end function.acceptStringConstReference_CFI
}

/**
 * \brief Accept a string reference
 *
 * Set out to a constant string.
 * arg1 is intent(OUT)
 * Must copy out.
 */
// ----------------------------------------
// Function:  void acceptStringReferenceOut
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string &arg1 +intent(out)
// Statement: c_out_string&
void STR_acceptStringReferenceOut(char *arg1)
{
    // splicer begin function.acceptStringReferenceOut
    std::string SHC_arg1_cxx;
    acceptStringReferenceOut(SHC_arg1_cxx);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.acceptStringReferenceOut
}

/**
 * \brief Accept a string reference
 *
 * Set out to a constant string.
 * arg1 is intent(OUT)
 * Must copy out.
 */
// ----------------------------------------
// Function:  void acceptStringReferenceOut
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string &arg1 +intent(out)
// Statement: f_out_string&_cfi
void STR_acceptStringReferenceOut_CFI(CFI_cdesc_t *SHT_arg1_cfi)
{
    // splicer begin function.acceptStringReferenceOut_CFI
    std::string SHC_arg1_cxx;
    char *arg1 = static_cast<char *>(SHT_arg1_cfi->base_addr);
    acceptStringReferenceOut(SHC_arg1_cxx);
    ShroudCharCopy(arg1, SHT_arg1_cfi->elem_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.acceptStringReferenceOut_CFI
}

/**
 * \brief Accept a string reference
 *
 * Append "dog" to the end of arg1.
 * arg1 is assumed to be intent(INOUT)
 * Must copy in and copy out.
 */
// ----------------------------------------
// Function:  void acceptStringReference
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string &arg1
// Statement: c_inout_string&
// start STR_acceptStringReference
void STR_acceptStringReference(char *arg1)
{
    // splicer begin function.acceptStringReference
    std::string SHC_arg1_cxx(arg1);
    acceptStringReference(SHC_arg1_cxx);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.acceptStringReference
}
// end STR_acceptStringReference

/**
 * \brief Accept a string reference
 *
 * Append "dog" to the end of arg1.
 * arg1 is assumed to be intent(INOUT)
 * Must copy in and copy out.
 */
// ----------------------------------------
// Function:  void acceptStringReference
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string &arg1
// Statement: f_inout_string&_cfi
// start STR_acceptStringReference_CFI
void STR_acceptStringReference_CFI(CFI_cdesc_t *SHT_arg1_cfi)
{
    // splicer begin function.acceptStringReference_CFI
    char *arg1 = static_cast<char *>(SHT_arg1_cfi->base_addr);
    size_t SHC_arg1_trim = ShroudCharLenTrim(arg1, SHT_arg1_cfi->elem_len);
    std::string SHC_arg1_cxx(arg1, SHC_arg1_trim);
    acceptStringReference(SHC_arg1_cxx);
    ShroudCharCopy(arg1, SHT_arg1_cfi->elem_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.acceptStringReference_CFI
}
// end STR_acceptStringReference_CFI

/**
 * \brief Accept a const string pointer - intent(in)
 *
 */
// ----------------------------------------
// Function:  void acceptStringPointerConst
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const std::string *arg1
// Statement: c_in_string*
void STR_acceptStringPointerConst(const char *arg1)
{
    // splicer begin function.acceptStringPointerConst
    const std::string SHC_arg1_cxx(arg1);
    acceptStringPointerConst(&SHC_arg1_cxx);
    // splicer end function.acceptStringPointerConst
}

/**
 * \brief Accept a const string pointer - intent(in)
 *
 */
// ----------------------------------------
// Function:  void acceptStringPointerConst
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const std::string *arg1
// Statement: f_in_string*_cfi
void STR_acceptStringPointerConst_CFI(CFI_cdesc_t *SHT_arg1_cfi)
{
    // splicer begin function.acceptStringPointerConst_CFI
    char *arg1 = static_cast<char *>(SHT_arg1_cfi->base_addr);
    size_t SHC_arg1_trim = ShroudCharLenTrim(arg1, SHT_arg1_cfi->elem_len);
    const std::string SHC_arg1_cxx(arg1, SHC_arg1_trim);
    acceptStringPointerConst(&SHC_arg1_cxx);
    // splicer end function.acceptStringPointerConst_CFI
}

/**
 * \brief Accept a string pointer - intent(inout)
 *
 */
// ----------------------------------------
// Function:  void acceptStringPointer
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string *arg1
// Statement: c_inout_string*
void STR_acceptStringPointer(char *arg1)
{
    // splicer begin function.acceptStringPointer
    std::string SHC_arg1_cxx(arg1);
    acceptStringPointer(&SHC_arg1_cxx);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.acceptStringPointer
}

/**
 * \brief Accept a string pointer - intent(inout)
 *
 */
// ----------------------------------------
// Function:  void acceptStringPointer
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string *arg1
// Statement: f_inout_string*_cfi
void STR_acceptStringPointer_CFI(CFI_cdesc_t *SHT_arg1_cfi)
{
    // splicer begin function.acceptStringPointer_CFI
    char *arg1 = static_cast<char *>(SHT_arg1_cfi->base_addr);
    size_t SHC_arg1_trim = ShroudCharLenTrim(arg1, SHT_arg1_cfi->elem_len);
    std::string SHC_arg1_cxx(arg1, SHC_arg1_trim);
    acceptStringPointer(&SHC_arg1_cxx);
    ShroudCharCopy(arg1, SHT_arg1_cfi->elem_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.acceptStringPointer_CFI
}

/**
 * \brief Accept a string pointer - intent(out)
 *
 * Return global_str.
 */
// ----------------------------------------
// Function:  void fetchStringPointer
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string *arg1 +intent(out)
// Statement: c_out_string*
void STR_fetchStringPointer(char *arg1)
{
    // splicer begin function.fetchStringPointer
    std::string SHC_arg1_cxx;
    fetchStringPointer(&SHC_arg1_cxx);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.fetchStringPointer
}

/**
 * \brief Accept a string pointer - intent(out)
 *
 * Return global_str.
 */
// ----------------------------------------
// Function:  void fetchStringPointer
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string *arg1 +intent(out)
// Statement: f_out_string*_cfi
void STR_fetchStringPointer_CFI(CFI_cdesc_t *SHT_arg1_cfi)
{
    // splicer begin function.fetchStringPointer_CFI
    std::string SHC_arg1_cxx;
    char *arg1 = static_cast<char *>(SHT_arg1_cfi->base_addr);
    fetchStringPointer(&SHC_arg1_cxx);
    ShroudCharCopy(arg1, SHT_arg1_cfi->elem_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.fetchStringPointer_CFI
}

/**
 * \brief Accept a string pointer - intent(inout)
 *
 * Test return tuple with two arguments.
 * Must rename argument to nlen to avoid conflict with intrinsic len.
 */
// ----------------------------------------
// Function:  void acceptStringPointerLen
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string *arg1
// Statement: c_inout_string*
// ----------------------------------------
// Argument:  int *nlen +intent(out)
// Statement: c_out_native*
void STR_acceptStringPointerLen(char *arg1, int *nlen)
{
    // splicer begin function.acceptStringPointerLen
    std::string SHC_arg1_cxx(arg1);
    acceptStringPointerLen(&SHC_arg1_cxx, nlen);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.acceptStringPointerLen
}

/**
 * \brief Accept a string pointer - intent(inout)
 *
 * Test return tuple with two arguments.
 * Must rename argument to nlen to avoid conflict with intrinsic len.
 */
// ----------------------------------------
// Function:  void acceptStringPointerLen
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string *arg1
// Statement: f_inout_string*_cfi
// ----------------------------------------
// Argument:  int *nlen +intent(out)
// Statement: f_out_native*
void STR_acceptStringPointerLen_CFI(CFI_cdesc_t *SHT_arg1_cfi,
    int *nlen)
{
    // splicer begin function.acceptStringPointerLen_CFI
    char *arg1 = static_cast<char *>(SHT_arg1_cfi->base_addr);
    size_t SHC_arg1_trim = ShroudCharLenTrim(arg1, SHT_arg1_cfi->elem_len);
    std::string SHC_arg1_cxx(arg1, SHC_arg1_trim);
    acceptStringPointerLen(&SHC_arg1_cxx, nlen);
    ShroudCharCopy(arg1, SHT_arg1_cfi->elem_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.acceptStringPointerLen_CFI
}

/**
 * \brief Accept a string pointer - intent(out)
 *
 * Return global_str.
 * Test return tuple with two arguments.
 * Must rename argument to nlen to avoid conflict with intrinsic len.
 */
// ----------------------------------------
// Function:  void fetchStringPointerLen
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string *arg1 +intent(out)
// Statement: c_out_string*
// ----------------------------------------
// Argument:  int *nlen +intent(out)
// Statement: c_out_native*
void STR_fetchStringPointerLen(char *arg1, int *nlen)
{
    // splicer begin function.fetchStringPointerLen
    std::string SHC_arg1_cxx;
    fetchStringPointerLen(&SHC_arg1_cxx, nlen);
    strcpy(arg1, SHC_arg1_cxx.c_str());
    // splicer end function.fetchStringPointerLen
}

/**
 * \brief Accept a string pointer - intent(out)
 *
 * Return global_str.
 * Test return tuple with two arguments.
 * Must rename argument to nlen to avoid conflict with intrinsic len.
 */
// ----------------------------------------
// Function:  void fetchStringPointerLen
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string *arg1 +intent(out)
// Statement: f_out_string*_cfi
// ----------------------------------------
// Argument:  int *nlen +intent(out)
// Statement: f_out_native*
void STR_fetchStringPointerLen_CFI(CFI_cdesc_t *SHT_arg1_cfi, int *nlen)
{
    // splicer begin function.fetchStringPointerLen_CFI
    std::string SHC_arg1_cxx;
    char *arg1 = static_cast<char *>(SHT_arg1_cfi->base_addr);
    fetchStringPointerLen(&SHC_arg1_cxx, nlen);
    ShroudCharCopy(arg1, SHT_arg1_cfi->elem_len, SHC_arg1_cxx.data(),
        SHC_arg1_cxx.size());
    // splicer end function.fetchStringPointerLen_CFI
}

/**
 * \brief Accept a string instance
 *
 */
// ----------------------------------------
// Function:  int acceptStringInstance
// Statement: c_function_native
// ----------------------------------------
// Argument:  std::string arg1
// Statement: c_in_string
int STR_acceptStringInstance(char *arg1)
{
    // splicer begin function.acceptStringInstance
    int SHC_rv = acceptStringInstance(arg1);
    return SHC_rv;
    // splicer end function.acceptStringInstance
}

/**
 * \brief Accept a string instance
 *
 */
// ----------------------------------------
// Function:  int acceptStringInstance
// Statement: f_function_native
// ----------------------------------------
// Argument:  std::string arg1
// Statement: f_in_string_cfi
int STR_acceptStringInstance_CFI(CFI_cdesc_t *SHT_arg1_cfi)
{
    // splicer begin function.acceptStringInstance_CFI
    char *arg1 = static_cast<char *>(SHT_arg1_cfi->base_addr);
    size_t SHC_arg1_trim = ShroudCharLenTrim(arg1, SHT_arg1_cfi->elem_len);
    std::string SHC_arg1_cxx(arg1, SHC_arg1_trim);
    int SHC_rv = acceptStringInstance(SHC_arg1_cxx);
    return SHC_rv;
    // splicer end function.acceptStringInstance_CFI
}

#if 0
! Not Implemented
/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 */
// ----------------------------------------
// Function:  void fetchArrayStringArg
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string **strs +dimension(nstrs)+intent(out)
// Statement: c_out_string**
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: c_out_native*
void STR_fetchArrayStringArg(char **strs, int *nstrs)
{
    // splicer begin function.fetchArrayStringArg
    fetchArrayStringArg(strs, nstrs);
    // splicer end function.fetchArrayStringArg
}
#endif

/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 */
// ----------------------------------------
// Function:  void fetchArrayStringArg
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string **strs +dimension(nstrs)+intent(out)
// Statement: f_out_string**_cfi_copy
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: f_out_native*_hidden
void STR_fetchArrayStringArg_CFI(CFI_cdesc_t *SHT_strs_cfi)
{
    // splicer begin function.fetchArrayStringArg_CFI
    std::string *SHT_strs_cxx;
    int nstrs;
    fetchArrayStringArg(&SHT_strs_cxx, &nstrs);
    // Copy results into strs
    // splicer end function.fetchArrayStringArg_CFI
}

#if 0
! Not Implemented
/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 * The defered length is set to the maximum string length.
 */
// ----------------------------------------
// Function:  void fetchArrayStringAlloc
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)
// Statement: c_out_string**
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: c_out_native*
void STR_fetchArrayStringAlloc(char **strs, int *nstrs)
{
    // splicer begin function.fetchArrayStringAlloc
    fetchArrayStringAlloc(strs, nstrs);
    // splicer end function.fetchArrayStringAlloc
}
#endif

/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 * The defered length is set to the maximum string length.
 */
// ----------------------------------------
// Function:  void fetchArrayStringAlloc
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)
// Statement: f_out_string**_cfi_allocatable
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: f_out_native*_hidden
void STR_fetchArrayStringAlloc_CFI(CFI_cdesc_t *SHT_strs_cfi)
{
    // splicer begin function.fetchArrayStringAlloc_CFI
    std::string *SHT_strs_cxx;
    int nstrs;
    fetchArrayStringAlloc(&SHT_strs_cxx, &nstrs);
    // Allocate and copy into strs
    // splicer end function.fetchArrayStringAlloc_CFI
}

#if 0
! Not Implemented
/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 * The defered length is set to the len attribute.
 */
// ----------------------------------------
// Function:  void fetchArrayStringAllocLen
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)+len(20)
// Statement: c_out_string**
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: c_out_native*
void STR_fetchArrayStringAllocLen(char **strs, int *nstrs)
{
    // splicer begin function.fetchArrayStringAllocLen
    fetchArrayStringAllocLen(strs, nstrs);
    // splicer end function.fetchArrayStringAllocLen
}
#endif

/**
 * Copy output into argument strs which must be large enough
 * to hold values.  Excess values will be truncated.
 * The nstrs argument is the length of the array.
 * It is associated with strs via the dimension(nstrs) attribute.
 * +hidden indicates that it is not part of the Fortran API.
 * The defered length is set to the len attribute.
 */
// ----------------------------------------
// Function:  void fetchArrayStringAllocLen
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)+len(20)
// Statement: f_out_string**_cfi_allocatable
// ----------------------------------------
// Argument:  int *nstrs +hidden+intent(out)
// Statement: f_out_native*_hidden
void STR_fetchArrayStringAllocLen_CFI(CFI_cdesc_t *SHT_strs_cfi)
{
    // splicer begin function.fetchArrayStringAllocLen_CFI
    std::string *SHT_strs_cxx;
    int nstrs;
    fetchArrayStringAllocLen(&SHT_strs_cxx, &nstrs);
    // Allocate and copy into strs
    // splicer end function.fetchArrayStringAllocLen_CFI
}

// ----------------------------------------
// Function:  void explicit1
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *name +intent(in)+len_trim(AAlen)
// Statement: c_in_char*
void STR_explicit1(char *name)
{
    // splicer begin function.explicit1
    explicit1(name);
    // splicer end function.explicit1
}

// ----------------------------------------
// Function:  void explicit1
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *name +intent(in)+len_trim(AAlen)
// Statement: f_in_char*_cfi
void STR_explicit1_CFI(CFI_cdesc_t *SHT_name_cfi)
{
    // splicer begin function.explicit1_CFI
    char *name = static_cast<char *>(SHT_name_cfi->base_addr);
    char *SHC_name_cxx = ShroudCharAlloc(name, SHT_name_cfi->elem_len,
        0);
    explicit1(SHC_name_cxx);
    ShroudCharFree(SHC_name_cxx);
    // splicer end function.explicit1_CFI
}

// ----------------------------------------
// Function:  void explicit2
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *name +intent(out)+len(AAtrim)
// Statement: c_out_char*
void STR_explicit2(char *name)
{
    // splicer begin function.explicit2
    explicit2(name);
    // splicer end function.explicit2
}

// ----------------------------------------
// Function:  void explicit2
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *name +intent(out)+len(AAtrim)
// Statement: f_out_char*_cfi
void STR_explicit2_CFI(CFI_cdesc_t *SHT_name_cfi)
{
    // splicer begin function.explicit2_CFI
    char *SHC_name_cxx = static_cast<char *>(SHT_name_cfi->base_addr);
    explicit2(SHC_name_cxx);
    ShroudCharBlankFill(SHC_name_cxx, SHT_name_cfi->elem_len);
    // splicer end function.explicit2_CFI
}

/**
 * \brief return a char argument (non-pointer), extern "C"
 *
 */
// ----------------------------------------
// Function:  char CreturnChar
// Statement: c_function_char
void STR_CreturnChar(char *SHC_rv)
{
    // splicer begin function.CreturnChar
    *SHC_rv = CreturnChar();
    // splicer end function.CreturnChar
}

/**
 * \brief strcpy like behavior
 *
 * dest is marked intent(OUT) to override the intent(INOUT) default
 * This avoid a copy-in on dest.
 * extern "C"
 * If src is a blank string, pass a NULL pointer to C library function.
 */
// ----------------------------------------
// Function:  void CpassCharPtr
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *dest +intent(out)
// Statement: f_out_char*_cfi
// ----------------------------------------
// Argument:  const char *src +blanknull
// Statement: f_in_char*_cfi
void STR_CpassCharPtr_CFI(CFI_cdesc_t *SHT_dest_cfi,
    CFI_cdesc_t *SHT_src_cfi)
{
    // splicer begin function.CpassCharPtr_CFI
    char *SHC_dest_cxx = static_cast<char *>(SHT_dest_cfi->base_addr);
    char *src = static_cast<char *>(SHT_src_cfi->base_addr);
    char *SHC_src_cxx = ShroudCharAlloc(src, SHT_src_cfi->elem_len, 1);
    CpassCharPtr(SHC_dest_cxx, SHC_src_cxx);
    ShroudCharBlankFill(SHC_dest_cxx, SHT_dest_cfi->elem_len);
    ShroudCharFree(SHC_src_cxx);
    // splicer end function.CpassCharPtr_CFI
}

/**
 * \brief Test F_blanknull option
 *
 */
// ----------------------------------------
// Function:  void CpassCharPtrBlank
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *dest +intent(out)
// Statement: c_out_char*
// ----------------------------------------
// Argument:  const char *src
// Statement: c_in_char*
void STR_CpassCharPtrBlank(char *dest, const char *src)
{
    // splicer begin function.CpassCharPtrBlank
    CpassCharPtrBlank(dest, src);
    // splicer end function.CpassCharPtrBlank
}

/**
 * \brief Test F_blanknull option
 *
 */
// ----------------------------------------
// Function:  void CpassCharPtrBlank
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *dest +intent(out)
// Statement: f_out_char*_cfi
// ----------------------------------------
// Argument:  const char *src
// Statement: f_in_char*_cfi
void STR_CpassCharPtrBlank_CFI(CFI_cdesc_t *SHT_dest_cfi,
    CFI_cdesc_t *SHT_src_cfi)
{
    // splicer begin function.CpassCharPtrBlank_CFI
    char *SHC_dest_cxx = static_cast<char *>(SHT_dest_cfi->base_addr);
    char *src = static_cast<char *>(SHT_src_cfi->base_addr);
    char *SHC_src_cxx = ShroudCharAlloc(src, SHT_src_cfi->elem_len, 1);
    CpassCharPtrBlank(SHC_dest_cxx, SHC_src_cxx);
    ShroudCharBlankFill(SHC_dest_cxx, SHT_dest_cfi->elem_len);
    ShroudCharFree(SHC_src_cxx);
    // splicer end function.CpassCharPtrBlank_CFI
}

/**
 * Test post_declare.
 * The std::string in py_string_inout must be declared before the
 * goto added by py_native_*_in_pointer_list to avoid
 * "jump to label 'fail' crosses initialization of" error.
 */
// ----------------------------------------
// Function:  void PostDeclare
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int *count +intent(in)+rank(1)
// Statement: c_in_native*
// ----------------------------------------
// Argument:  std::string &name
// Statement: c_inout_string&
void STR_PostDeclare(int *count, char *name)
{
    // splicer begin function.PostDeclare
    std::string SHC_name_cxx(name);
    PostDeclare(count, SHC_name_cxx);
    strcpy(name, SHC_name_cxx.c_str());
    // splicer end function.PostDeclare
}

/**
 * Test post_declare.
 * The std::string in py_string_inout must be declared before the
 * goto added by py_native_*_in_pointer_list to avoid
 * "jump to label 'fail' crosses initialization of" error.
 */
// ----------------------------------------
// Function:  void PostDeclare
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int *count +intent(in)+rank(1)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  std::string &name
// Statement: f_inout_string&_cfi
void STR_PostDeclare_CFI(CFI_cdesc_t *SHT_count_cfi,
    CFI_cdesc_t *SHT_name_cfi)
{
    // splicer begin function.PostDeclare_CFI
    int *SHC_count_cxx = static_cast<int *>(SHT_count_cfi->base_addr);
    char *name = static_cast<char *>(SHT_name_cfi->base_addr);
    size_t SHC_name_trim = ShroudCharLenTrim(name, SHT_name_cfi->elem_len);
    std::string SHC_name_cxx(name, SHC_name_trim);
    PostDeclare(SHC_count_cxx, SHC_name_cxx);
    ShroudCharCopy(name, SHT_name_cfi->elem_len, SHC_name_cxx.data(),
        SHC_name_cxx.size());
    // splicer end function.PostDeclare_CFI
}

/**
 * \brief NULL terminate input string in C, not in Fortran.
 *
 */
// ----------------------------------------
// Function:  int CpassCharPtrNotrim
// Statement: c_function_native
// ----------------------------------------
// Argument:  const char *src
// Statement: c_in_char*
int STR_CpassCharPtrNotrim(const char *src)
{
    // splicer begin function.CpassCharPtrNotrim
    int SHC_rv = CpassCharPtrNotrim(src);
    return SHC_rv;
    // splicer end function.CpassCharPtrNotrim
}

/**
 * \brief NULL terminate input string in C, not in Fortran.
 *
 */
// ----------------------------------------
// Function:  int CpassCharPtrNotrim
// Statement: f_function_native
// ----------------------------------------
// Argument:  const char *src
// Statement: f_in_char*_cfi
int STR_CpassCharPtrNotrim_CFI(CFI_cdesc_t *SHT_src_cfi)
{
    // splicer begin function.CpassCharPtrNotrim_CFI
    char *src = static_cast<char *>(SHT_src_cfi->base_addr);
    char *SHC_src_cxx = ShroudCharAlloc(src, SHT_src_cfi->elem_len, 0);
    int SHC_rv = CpassCharPtrNotrim(SHC_src_cxx);
    ShroudCharFree(SHC_src_cxx);
    return SHC_rv;
    // splicer end function.CpassCharPtrNotrim_CFI
}

/**
 * \brief Do not NULL terminate input string
 *
 * The C library function should get the same address
 * for addr and src.
 * Used when the C function needs the true address of the argument.
 * Skips null-termination. Useful to create an interface for
 * a function which is already callable by Fortran.
 * For example, the length is passed explicitly.
 * This example will not create a Fortran wrapper since C can be
 * called directly.
 */
// ----------------------------------------
// Function:  int CpassCharPtrCAPI
// Statement: c_function_native
// ----------------------------------------
// Argument:  void *addr
// Statement: c_in_void*
// ----------------------------------------
// Argument:  const char *src +api(capi)
// Statement: c_in_char*
int STR_CpassCharPtrCAPI(void *addr, const char *src)
{
    // splicer begin function.CpassCharPtrCAPI
    int SHC_rv = CpassCharPtrCAPI(addr, src);
    return SHC_rv;
    // splicer end function.CpassCharPtrCAPI
}

/**
 * \brief Mix api(buf) and api(capi)
 *
 */
// ----------------------------------------
// Function:  int CpassCharPtrCAPI2
// Statement: c_function_native
// ----------------------------------------
// Argument:  const char *in
// Statement: c_in_char*
// ----------------------------------------
// Argument:  const char *src +api(capi)
// Statement: c_in_char*
int STR_CpassCharPtrCAPI2(const char *in, const char *src)
{
    // splicer begin function.CpassCharPtrCAPI2
    int SHC_rv = CpassCharPtrCAPI2(in, src);
    return SHC_rv;
    // splicer end function.CpassCharPtrCAPI2
}

/**
 * \brief Mix api(buf) and api(capi)
 *
 */
// ----------------------------------------
// Function:  int CpassCharPtrCAPI2
// Statement: f_function_native
// ----------------------------------------
// Argument:  const char *in
// Statement: f_in_char*_cfi
// ----------------------------------------
// Argument:  const char *src +api(capi)
// Statement: f_in_char*_capi
int STR_CpassCharPtrCAPI2_CFI(CFI_cdesc_t *SHT_in_cfi, const char *src)
{
    // splicer begin function.CpassCharPtrCAPI2_CFI
    char *in = static_cast<char *>(SHT_in_cfi->base_addr);
    char *SHC_in_cxx = ShroudCharAlloc(in, SHT_in_cfi->elem_len, 0);
    int SHC_rv = CpassCharPtrCAPI2(SHC_in_cxx, src);
    ShroudCharFree(SHC_in_cxx);
    return SHC_rv;
    // splicer end function.CpassCharPtrCAPI2_CFI
}

}  // extern "C"
