! wrapfstrings.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
#include "shroud/features.h"
!>
!! \file wrapfstrings.f
!! \brief Shroud generated wrapper for strings library
!<
! splicer begin file_top
! splicer end file_top
module strings_mod
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! ----------------------------------------
    ! Function:  void init_test
    ! Statement: f_subroutine
    interface
        subroutine init_test() &
                bind(C, name="STR_init_test")
            implicit none
        end subroutine init_test
    end interface

    ! ----------------------------------------
    ! Function:  void passChar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    interface
        subroutine pass_char(status) &
                bind(C, name="STR_passChar")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), value, intent(IN) :: status
        end subroutine pass_char
    end interface

    ! ----------------------------------------
    ! Function:  void passCharForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    interface
        subroutine c_pass_char_force(status) &
                bind(C, name="STR_passCharForce")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), value, intent(IN) :: status
        end subroutine c_pass_char_force
    end interface

    ! ----------------------------------------
    ! Function:  char returnChar
    ! Statement: f_function_char
    interface
        subroutine c_return_char(SHT_rv) &
                bind(C, name="STR_returnChar")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv
        end subroutine c_return_char
    end interface

    ! ----------------------------------------
    ! Function:  void passCharPtr
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +charlen(40)+intent(out)
    ! Statement: c_out_char*
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: c_in_char*
    ! start c_pass_char_ptr
    interface
        subroutine c_pass_char_ptr(dest, src) &
                bind(C, name="STR_passCharPtr")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: dest(*)
            character(kind=C_CHAR), intent(IN) :: src(*)
        end subroutine c_pass_char_ptr
    end interface
    ! end c_pass_char_ptr

    ! ----------------------------------------
    ! Function:  void passCharPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +charlen(40)+intent(out)
    ! Statement: f_out_char*_cfi
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*_cfi
    ! start pass_char_ptr
    interface
        subroutine pass_char_ptr(dest, src) &
                bind(C, name="STR_passCharPtr_CFI")
            implicit none
            character(len=*), intent(OUT) :: dest
            character(len=*), intent(IN) :: src
        end subroutine pass_char_ptr
    end interface
    ! end pass_char_ptr

    ! ----------------------------------------
    ! Function:  void passCharPtrInOut
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *s +intent(inout)
    ! Statement: c_inout_char*
    interface
        subroutine c_pass_char_ptr_in_out(s) &
                bind(C, name="STR_passCharPtrInOut")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: s(*)
        end subroutine c_pass_char_ptr_in_out
    end interface

    ! ----------------------------------------
    ! Function:  void passCharPtrInOut
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *s +intent(inout)
    ! Statement: f_inout_char*_cfi
    interface
        subroutine pass_char_ptr_in_out(s) &
                bind(C, name="STR_passCharPtrInOut_CFI")
            implicit none
            character(len=*), intent(INOUT) :: s
        end subroutine pass_char_ptr_in_out
    end interface

    ! ----------------------------------------
    ! Function:  const char *getCharPtr1
    ! Statement: c_function_char*
    ! start c_get_char_ptr1
    interface
        function c_get_char_ptr1() &
                result(SHT_rv) &
                bind(C, name="STR_getCharPtr1")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_char_ptr1
    end interface
    ! end c_get_char_ptr1

    ! ----------------------------------------
    ! Function:  const char *getCharPtr1
    ! Statement: f_function_char*_cfi_allocatable
    ! start c_get_char_ptr1_CFI
    interface
        subroutine c_get_char_ptr1_CFI(SHT_rv) &
                bind(C, name="STR_getCharPtr1_CFI")
            implicit none
            character(len=:), intent(OUT), allocatable :: SHT_rv
        end subroutine c_get_char_ptr1_CFI
    end interface
    ! end c_get_char_ptr1_CFI

    ! ----------------------------------------
    ! Function:  const char *getCharPtr2 +len(30)
    ! Statement: c_function_char*
    ! start c_get_char_ptr2
    interface
        function c_get_char_ptr2() &
                result(SHT_rv) &
                bind(C, name="STR_getCharPtr2")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_char_ptr2
    end interface
    ! end c_get_char_ptr2

    ! ----------------------------------------
    ! Function:  const char *getCharPtr2 +len(30)
    ! Statement: f_function_char*_cfi_copy
    ! start c_get_char_ptr2_CFI
    interface
        subroutine c_get_char_ptr2_CFI(SHT_rv) &
                bind(C, name="STR_getCharPtr2_CFI")
            implicit none
            character(len=*), intent(OUT) :: SHT_rv
        end subroutine c_get_char_ptr2_CFI
    end interface
    ! end c_get_char_ptr2_CFI

    ! ----------------------------------------
    ! Function:  const char *getCharPtr3
    ! Statement: c_function_char*
    ! start c_get_char_ptr3
    interface
        function c_get_char_ptr3() &
                result(SHT_rv) &
                bind(C, name="STR_getCharPtr3")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_char_ptr3
    end interface
    ! end c_get_char_ptr3

    ! ----------------------------------------
    ! Function:  const char *getCharPtr3
    ! Statement: f_function_char*_cfi_arg
    ! start c_get_char_ptr3_CFI
    interface
        subroutine c_get_char_ptr3_CFI(output) &
                bind(C, name="STR_getCharPtr3_CFI")
            implicit none
            character(len=*), intent(OUT) :: output
        end subroutine c_get_char_ptr3_CFI
    end interface
    ! end c_get_char_ptr3_CFI

    ! ----------------------------------------
    ! Function:  const char *getCharPtr4 +deref(raw)
    ! Statement: f_function_char*_raw
    interface
        function get_char_ptr4() &
                result(SHT_rv) &
                bind(C, name="STR_getCharPtr4")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function get_char_ptr4
    end interface

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const char *getCharPtr5 +deref(pointer)
    ! Statement: c_function_char*
    interface
        function c_get_char_ptr5() &
                result(SHT_rv) &
                bind(C, name="STR_getCharPtr5")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_char_ptr5
    end interface
#endif

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const char *getCharPtr5 +deref(pointer)
    ! Statement: f_function_char*_cfi_pointer
    interface
        subroutine c_get_char_ptr5_CFI(SHT_rv) &
                bind(C, name="STR_getCharPtr5_CFI")
            implicit none
            character(len=:), intent(OUT), pointer :: SHT_rv
        end subroutine c_get_char_ptr5_CFI
    end interface
#endif

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  const string getConstStringResult
    ! Statement: c_function_string
    interface
        function c_get_const_string_result() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringResult")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR) :: SHT_rv(*)
        end function c_get_const_string_result
    end interface
#endif

    ! ----------------------------------------
    ! Function:  const string getConstStringResult
    ! Statement: f_function_string_cfi_allocatable
    interface
        subroutine c_get_const_string_result_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringResult_CFI")
            implicit none
            character(len=:), intent(OUT), allocatable :: SHT_rv
        end subroutine c_get_const_string_result_CFI
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  const string getConstStringLen +len(30)
    ! Statement: c_function_string
    interface
        function c_get_const_string_len() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringLen")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR) :: SHT_rv(*)
        end function c_get_const_string_len
    end interface
#endif

    ! ----------------------------------------
    ! Function:  const string getConstStringLen +len(30)
    ! Statement: f_function_string_cfi_copy
    interface
        subroutine c_get_const_string_len_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringLen_CFI")
            implicit none
            character(len=*), intent(OUT) :: SHT_rv
        end subroutine c_get_const_string_len_CFI
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  const string getConstStringAsArg
    ! Statement: c_function_string
    interface
        function c_get_const_string_as_arg() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringAsArg")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR) :: SHT_rv(*)
        end function c_get_const_string_as_arg
    end interface
#endif

    ! ----------------------------------------
    ! Function:  const string getConstStringAsArg
    ! Statement: f_function_string_cfi_arg
    interface
        subroutine c_get_const_string_as_arg_CFI(output) &
                bind(C, name="STR_getConstStringAsArg_CFI")
            implicit none
            character(len=*), intent(OUT) :: output
        end subroutine c_get_const_string_as_arg_CFI
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  const std::string getConstStringAlloc
    ! Statement: c_function_string
    interface
        function c_get_const_string_alloc() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringAlloc")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR) :: SHT_rv(*)
        end function c_get_const_string_alloc
    end interface
#endif

    ! ----------------------------------------
    ! Function:  const std::string getConstStringAlloc
    ! Statement: f_function_string_cfi_allocatable
    interface
        subroutine c_get_const_string_alloc_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringAlloc_CFI")
            implicit none
            character(len=:), intent(OUT), allocatable :: SHT_rv
        end subroutine c_get_const_string_alloc_CFI
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefPure
    ! Statement: c_function_string&
    ! start c_get_const_string_ref_pure
    interface
        function c_get_const_string_ref_pure() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringRefPure")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ref_pure
    end interface
    ! end c_get_const_string_ref_pure

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefPure
    ! Statement: f_function_string&_cfi_allocatable
    ! start c_get_const_string_ref_pure_CFI
    interface
        subroutine c_get_const_string_ref_pure_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringRefPure_CFI")
            implicit none
            character(len=:), intent(OUT), allocatable :: SHT_rv
        end subroutine c_get_const_string_ref_pure_CFI
    end interface
    ! end c_get_const_string_ref_pure_CFI

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLen +len(30)
    ! Statement: c_function_string&
    interface
        function c_get_const_string_ref_len() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringRefLen")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ref_len
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLen +len(30)
    ! Statement: f_function_string&_cfi_copy
    interface
        subroutine c_get_const_string_ref_len_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringRefLen_CFI")
            implicit none
            character(len=*), intent(OUT) :: SHT_rv
        end subroutine c_get_const_string_ref_len_CFI
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefAsArg
    ! Statement: c_function_string&
    interface
        function c_get_const_string_ref_as_arg() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringRefAsArg")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ref_as_arg
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefAsArg
    ! Statement: f_function_string&_cfi_arg
    interface
        subroutine c_get_const_string_ref_as_arg_CFI(output) &
                bind(C, name="STR_getConstStringRefAsArg_CFI")
            implicit none
            character(len=*), intent(OUT) :: output
        end subroutine c_get_const_string_ref_as_arg_CFI
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLenEmpty +len(30)
    ! Statement: c_function_string&
    interface
        function c_get_const_string_ref_len_empty() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringRefLenEmpty")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ref_len_empty
    end interface

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLenEmpty +len(30)
    ! Statement: f_function_string&_cfi_copy
    interface
        subroutine c_get_const_string_ref_len_empty_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringRefLenEmpty_CFI")
            implicit none
            character(len=*), intent(OUT) :: SHT_rv
        end subroutine c_get_const_string_ref_len_empty_CFI
    end interface

    ! ----------------------------------------
    ! Function:  const std::string &getConstStringRefAlloc
    ! Statement: c_function_string&
    interface
        function c_get_const_string_ref_alloc() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringRefAlloc")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ref_alloc
    end interface

    ! ----------------------------------------
    ! Function:  const std::string &getConstStringRefAlloc
    ! Statement: f_function_string&_cfi_allocatable
    interface
        subroutine c_get_const_string_ref_alloc_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringRefAlloc_CFI")
            implicit none
            character(len=:), intent(OUT), allocatable :: SHT_rv
        end subroutine c_get_const_string_ref_alloc_CFI
    end interface

    ! ----------------------------------------
    ! Function:  const string *getConstStringPtrLen +len(30)
    ! Statement: c_function_string*
    interface
        function c_get_const_string_ptr_len() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrLen")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_len
    end interface

    ! ----------------------------------------
    ! Function:  const string *getConstStringPtrLen +len(30)
    ! Statement: f_function_string*_cfi_copy
    interface
        subroutine c_get_const_string_ptr_len_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringPtrLen_CFI")
            implicit none
            character(len=*), intent(OUT) :: SHT_rv
        end subroutine c_get_const_string_ptr_len_CFI
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrAlloc +owner(library)
    ! Statement: c_function_string*_library
    interface
        function c_get_const_string_ptr_alloc() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrAlloc")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_alloc
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrAlloc +owner(library)
    ! Statement: f_function_string*_cfi_allocatable_library
    interface
        subroutine c_get_const_string_ptr_alloc_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringPtrAlloc_CFI")
            implicit none
            character(len=:), intent(OUT), allocatable :: SHT_rv
        end subroutine c_get_const_string_ptr_alloc_CFI
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAlloc +owner(caller)
    ! Statement: c_function_string*_caller
    interface
        function c_get_const_string_ptr_owns_alloc() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrOwnsAlloc")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_owns_alloc
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAlloc +owner(caller)
    ! Statement: f_function_string*_cfi_allocatable_caller
    interface
        subroutine c_get_const_string_ptr_owns_alloc_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringPtrOwnsAlloc_CFI")
            implicit none
            character(len=:), intent(OUT), allocatable :: SHT_rv
        end subroutine c_get_const_string_ptr_owns_alloc_CFI
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAllocPattern +free_pattern(C_string_free)+owner(caller)
    ! Statement: c_function_string*_caller
    interface
        function c_get_const_string_ptr_owns_alloc_pattern() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrOwnsAllocPattern")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_owns_alloc_pattern
    end interface

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAllocPattern +free_pattern(C_string_free)+owner(caller)
    ! Statement: f_function_string*_cfi_allocatable_caller
    interface
        subroutine c_get_const_string_ptr_owns_alloc_pattern_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringPtrOwnsAllocPattern_CFI")
            implicit none
            character(len=:), intent(OUT), allocatable :: SHT_rv
        end subroutine c_get_const_string_ptr_owns_alloc_pattern_CFI
    end interface

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrPointer +deref(pointer)+owner(library)
    ! Statement: c_function_string*_library
    interface
        function c_get_const_string_ptr_pointer() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrPointer")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_pointer
    end interface
#endif

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrPointer +deref(pointer)+owner(library)
    ! Statement: f_function_string*_cfi_pointer_library
    interface
        subroutine c_get_const_string_ptr_pointer_CFI(SHT_rv) &
                bind(C, name="STR_getConstStringPtrPointer_CFI")
            implicit none
            character(len=:), intent(OUT), pointer :: SHT_rv
        end subroutine c_get_const_string_ptr_pointer_CFI
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void acceptStringConstReference
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &arg1
    ! Statement: c_in_string&
    interface
        subroutine c_accept_string_const_reference(arg1) &
                bind(C, name="STR_acceptStringConstReference")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
        end subroutine c_accept_string_const_reference
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringConstReference
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &arg1
    ! Statement: f_in_string&_cfi
    interface
        subroutine accept_string_const_reference(arg1) &
                bind(C, name="STR_acceptStringConstReference_CFI")
            implicit none
            character(len=*), intent(IN) :: arg1
        end subroutine accept_string_const_reference
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringReferenceOut
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1 +intent(out)
    ! Statement: c_out_string&
    interface
        subroutine c_accept_string_reference_out(arg1) &
                bind(C, name="STR_acceptStringReferenceOut")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg1(*)
        end subroutine c_accept_string_reference_out
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringReferenceOut
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1 +intent(out)
    ! Statement: f_out_string&_cfi
    interface
        subroutine accept_string_reference_out(arg1) &
                bind(C, name="STR_acceptStringReferenceOut_CFI")
            implicit none
            character(len=*), intent(OUT) :: arg1
        end subroutine accept_string_reference_out
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringReference
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1
    ! Statement: c_inout_string&
    ! start c_accept_string_reference
    interface
        subroutine c_accept_string_reference(arg1) &
                bind(C, name="STR_acceptStringReference")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: arg1(*)
        end subroutine c_accept_string_reference
    end interface
    ! end c_accept_string_reference

    ! ----------------------------------------
    ! Function:  void acceptStringReference
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1
    ! Statement: f_inout_string&_cfi
    ! start accept_string_reference
    interface
        subroutine accept_string_reference(arg1) &
                bind(C, name="STR_acceptStringReference_CFI")
            implicit none
            character(len=*), intent(INOUT) :: arg1
        end subroutine accept_string_reference
    end interface
    ! end accept_string_reference

    ! ----------------------------------------
    ! Function:  void acceptStringPointerConst
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string *arg1
    ! Statement: c_in_string*
    interface
        subroutine c_accept_string_pointer_const(arg1) &
                bind(C, name="STR_acceptStringPointerConst")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
        end subroutine c_accept_string_pointer_const
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringPointerConst
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string *arg1
    ! Statement: f_in_string*_cfi
    interface
        subroutine accept_string_pointer_const(arg1) &
                bind(C, name="STR_acceptStringPointerConst_CFI")
            implicit none
            character(len=*), intent(IN) :: arg1
        end subroutine accept_string_pointer_const
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringPointer
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: c_inout_string*
    interface
        subroutine c_accept_string_pointer(arg1) &
                bind(C, name="STR_acceptStringPointer")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: arg1(*)
        end subroutine c_accept_string_pointer
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: f_inout_string*_cfi
    interface
        subroutine accept_string_pointer(arg1) &
                bind(C, name="STR_acceptStringPointer_CFI")
            implicit none
            character(len=*), intent(INOUT) :: arg1
        end subroutine accept_string_pointer
    end interface

    ! ----------------------------------------
    ! Function:  void fetchStringPointer
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: c_out_string*
    interface
        subroutine c_fetch_string_pointer(arg1) &
                bind(C, name="STR_fetchStringPointer")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg1(*)
        end subroutine c_fetch_string_pointer
    end interface

    ! ----------------------------------------
    ! Function:  void fetchStringPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: f_out_string*_cfi
    interface
        subroutine fetch_string_pointer(arg1) &
                bind(C, name="STR_fetchStringPointer_CFI")
            implicit none
            character(len=*), intent(OUT) :: arg1
        end subroutine fetch_string_pointer
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringPointerLen
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: c_inout_string*
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: c_out_native*
    interface
        subroutine c_accept_string_pointer_len(arg1, nlen) &
                bind(C, name="STR_acceptStringPointerLen")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(INOUT) :: arg1(*)
            integer(C_INT), intent(OUT) :: nlen
        end subroutine c_accept_string_pointer_len
    end interface

    ! ----------------------------------------
    ! Function:  void acceptStringPointerLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: f_inout_string*_cfi
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: f_out_native*
    interface
        subroutine accept_string_pointer_len(arg1, nlen) &
                bind(C, name="STR_acceptStringPointerLen_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            character(len=*), intent(INOUT) :: arg1
            integer(C_INT), intent(OUT) :: nlen
        end subroutine accept_string_pointer_len
    end interface

    ! ----------------------------------------
    ! Function:  void fetchStringPointerLen
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: c_out_string*
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: c_out_native*
    interface
        subroutine c_fetch_string_pointer_len(arg1, nlen) &
                bind(C, name="STR_fetchStringPointerLen")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(OUT) :: arg1(*)
            integer(C_INT), intent(OUT) :: nlen
        end subroutine c_fetch_string_pointer_len
    end interface

    ! ----------------------------------------
    ! Function:  void fetchStringPointerLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: f_out_string*_cfi
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: f_out_native*
    interface
        subroutine fetch_string_pointer_len(arg1, nlen) &
                bind(C, name="STR_fetchStringPointerLen_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            character(len=*), intent(OUT) :: arg1
            integer(C_INT), intent(OUT) :: nlen
        end subroutine fetch_string_pointer_len
    end interface

    ! ----------------------------------------
    ! Function:  int acceptStringInstance
    ! Statement: c_function_native
    ! ----------------------------------------
    ! Argument:  std::string arg1
    ! Statement: c_in_string
    interface
        function c_accept_string_instance(arg1) &
                result(SHT_rv) &
                bind(C, name="STR_acceptStringInstance")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: arg1(*)
            integer(C_INT) :: SHT_rv
        end function c_accept_string_instance
    end interface

    ! ----------------------------------------
    ! Function:  int acceptStringInstance
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  std::string arg1
    ! Statement: f_in_string_cfi
    interface
        function accept_string_instance(arg1) &
                result(SHT_rv) &
                bind(C, name="STR_acceptStringInstance_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            character(len=*), intent(IN) :: arg1
            integer(C_INT) :: SHT_rv
        end function accept_string_instance
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  void fetchArrayStringArg
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +dimension(nstrs)+intent(out)
    ! Statement: c_out_string**
    ! ----------------------------------------
    ! Argument:  int *nstrs +hidden+intent(out)
    ! Statement: c_out_native*
    interface
        subroutine c_fetch_array_string_arg(strs, nstrs) &
                bind(C, name="STR_fetchArrayStringArg")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(OUT), value :: strs
            integer(C_INT), intent(OUT) :: nstrs
        end subroutine c_fetch_array_string_arg
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void fetchArrayStringArg
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +dimension(nstrs)+intent(out)
    ! Statement: f_out_string**_cfi_copy
    interface
        subroutine fetch_array_string_arg(strs) &
                bind(C, name="STR_fetchArrayStringArg_CFI")
            implicit none
            character(*), intent(OUT) :: strs(:)
        end subroutine fetch_array_string_arg
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  void fetchArrayStringAlloc
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)
    ! Statement: c_out_string**
    ! ----------------------------------------
    ! Argument:  int *nstrs +hidden+intent(out)
    ! Statement: c_out_native*
    interface
        subroutine c_fetch_array_string_alloc(strs, nstrs) &
                bind(C, name="STR_fetchArrayStringAlloc")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(OUT), value :: strs
            integer(C_INT), intent(OUT) :: nstrs
        end subroutine c_fetch_array_string_alloc
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void fetchArrayStringAlloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)
    ! Statement: f_out_string**_cfi_allocatable
    interface
        subroutine fetch_array_string_alloc(strs) &
                bind(C, name="STR_fetchArrayStringAlloc_CFI")
            implicit none
            character(*), intent(OUT) :: strs(:)
        end subroutine fetch_array_string_alloc
    end interface

#if 0
    ! Not Implemented
    ! ----------------------------------------
    ! Function:  void fetchArrayStringAllocLen
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)+len(20)
    ! Statement: c_out_string**
    ! ----------------------------------------
    ! Argument:  int *nstrs +hidden+intent(out)
    ! Statement: c_out_native*
    interface
        subroutine c_fetch_array_string_alloc_len(strs, nstrs) &
                bind(C, name="STR_fetchArrayStringAllocLen")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(OUT), value :: strs
            integer(C_INT), intent(OUT) :: nstrs
        end subroutine c_fetch_array_string_alloc_len
    end interface
#endif

    ! ----------------------------------------
    ! Function:  void fetchArrayStringAllocLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)+len(20)
    ! Statement: f_out_string**_cfi_allocatable
    interface
        subroutine fetch_array_string_alloc_len(strs) &
                bind(C, name="STR_fetchArrayStringAllocLen_CFI")
            implicit none
            character(*), intent(OUT) :: strs(:)
        end subroutine fetch_array_string_alloc_len
    end interface

    ! ----------------------------------------
    ! Function:  void explicit1
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(in)+len_trim(AAlen)
    ! Statement: c_in_char*
    interface
        subroutine c_explicit1(name) &
                bind(C, name="STR_explicit1")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
        end subroutine c_explicit1
    end interface

    ! ----------------------------------------
    ! Function:  void explicit1
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(in)+len_trim(AAlen)
    ! Statement: f_in_char*_cfi
    interface
        subroutine explicit1(name) &
                bind(C, name="STR_explicit1_CFI")
            implicit none
            character(len=*), intent(IN) :: name
        end subroutine explicit1
    end interface

    ! ----------------------------------------
    ! Function:  void explicit2
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(out)+len(AAtrim)
    ! Statement: c_out_char*
    interface
        subroutine c_explicit2(name) &
                bind(C, name="STR_explicit2")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: name(*)
        end subroutine c_explicit2
    end interface

    ! ----------------------------------------
    ! Function:  void explicit2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(out)+len(AAtrim)
    ! Statement: f_out_char*_cfi
    interface
        subroutine explicit2(name) &
                bind(C, name="STR_explicit2_CFI")
            implicit none
            character(len=*), intent(OUT) :: name
        end subroutine explicit2
    end interface

    ! ----------------------------------------
    ! Function:  void CpassChar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    interface
        subroutine cpass_char(status) &
                bind(C, name="CpassChar")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), value, intent(IN) :: status
        end subroutine cpass_char
    end interface

    ! ----------------------------------------
    ! Function:  char CreturnChar
    ! Statement: f_function_char
    interface
        subroutine c_creturn_char(SHT_rv) &
                bind(C, name="STR_CreturnChar")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: SHT_rv
        end subroutine c_creturn_char
    end interface

    ! ----------------------------------------
    ! Function:  void CpassCharPtr
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: c_out_char*
    ! ----------------------------------------
    ! Argument:  const char *src +blanknull
    ! Statement: c_in_char*
    interface
        subroutine c_cpass_char_ptr(dest, src) &
                bind(C, name="CpassCharPtr")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: dest(*)
            character(kind=C_CHAR), intent(IN) :: src(*)
        end subroutine c_cpass_char_ptr
    end interface

    ! ----------------------------------------
    ! Function:  void CpassCharPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: f_out_char*_cfi
    ! ----------------------------------------
    ! Argument:  const char *src +blanknull
    ! Statement: f_in_char*_cfi
    interface
        subroutine cpass_char_ptr(dest, src) &
                bind(C, name="STR_CpassCharPtr_CFI")
            implicit none
            character(len=*), intent(OUT) :: dest
            character(len=*), intent(IN) :: src
        end subroutine cpass_char_ptr
    end interface

    ! ----------------------------------------
    ! Function:  void CpassCharPtrBlank
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: c_out_char*
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: c_in_char*
    interface
        subroutine c_cpass_char_ptr_blank(dest, src) &
                bind(C, name="STR_CpassCharPtrBlank")
            use iso_c_binding, only : C_CHAR
            implicit none
            character(kind=C_CHAR), intent(OUT) :: dest(*)
            character(kind=C_CHAR), intent(IN) :: src(*)
        end subroutine c_cpass_char_ptr_blank
    end interface

    ! ----------------------------------------
    ! Function:  void CpassCharPtrBlank
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: f_out_char*_cfi
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*_cfi
    interface
        subroutine cpass_char_ptr_blank(dest, src) &
                bind(C, name="STR_CpassCharPtrBlank_CFI")
            implicit none
            character(len=*), intent(OUT) :: dest
            character(len=*), intent(IN) :: src
        end subroutine cpass_char_ptr_blank
    end interface

    ! ----------------------------------------
    ! Function:  void PostDeclare
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  int *count +intent(in)+rank(1)
    ! Statement: c_in_native*
    ! ----------------------------------------
    ! Argument:  std::string &name
    ! Statement: c_inout_string&
    interface
        subroutine c_post_declare(count, name) &
                bind(C, name="STR_PostDeclare")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            integer(C_INT), intent(IN) :: count(*)
            character(kind=C_CHAR), intent(INOUT) :: name(*)
        end subroutine c_post_declare
    end interface

    ! ----------------------------------------
    ! Function:  void PostDeclare
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *count +intent(in)+rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  std::string &name
    ! Statement: f_inout_string&_cfi
    interface
        subroutine post_declare(count, name) &
                bind(C, name="STR_PostDeclare_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: count(:)
            character(len=*), intent(INOUT) :: name
        end subroutine post_declare
    end interface

    ! ----------------------------------------
    ! Function:  int CpassCharPtrNotrim
    ! Statement: c_function_native
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: c_in_char*
    interface
        function c_cpass_char_ptr_notrim(src) &
                result(SHT_rv) &
                bind(C, name="STR_CpassCharPtrNotrim")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: src(*)
            integer(C_INT) :: SHT_rv
        end function c_cpass_char_ptr_notrim
    end interface

    ! ----------------------------------------
    ! Function:  int CpassCharPtrNotrim
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*_cfi
    interface
        function cpass_char_ptr_notrim(src) &
                result(SHT_rv) &
                bind(C, name="STR_CpassCharPtrNotrim_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            character(len=*), intent(IN) :: src
            integer(C_INT) :: SHT_rv
        end function cpass_char_ptr_notrim
    end interface

    ! ----------------------------------------
    ! Function:  int CpassCharPtrCAPI
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void *addr
    ! Statement: f_in_void*
    ! ----------------------------------------
    ! Argument:  const char *src +api(capi)
    ! Statement: f_in_char*_capi
    interface
        function cpass_char_ptr_capi(addr, src) &
                result(SHT_rv) &
                bind(C, name="STR_CpassCharPtrCAPI")
            use iso_c_binding, only : C_CHAR, C_INT, C_PTR
            implicit none
            type(C_PTR), value, intent(IN) :: addr
            character(kind=C_CHAR), intent(IN) :: src(*)
            integer(C_INT) :: SHT_rv
        end function cpass_char_ptr_capi
    end interface

    ! ----------------------------------------
    ! Function:  int CpassCharPtrCAPI2
    ! Statement: c_function_native
    ! ----------------------------------------
    ! Argument:  const char *in
    ! Statement: c_in_char*
    ! ----------------------------------------
    ! Argument:  const char *src +api(capi)
    ! Statement: c_in_char*
    interface
        function c_cpass_char_ptr_capi2(in, src) &
                result(SHT_rv) &
                bind(C, name="STR_CpassCharPtrCAPI2")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(kind=C_CHAR), intent(IN) :: in(*)
            character(kind=C_CHAR), intent(IN) :: src(*)
            integer(C_INT) :: SHT_rv
        end function c_cpass_char_ptr_capi2
    end interface

    ! ----------------------------------------
    ! Function:  int CpassCharPtrCAPI2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *in
    ! Statement: f_in_char*_cfi
    ! ----------------------------------------
    ! Argument:  const char *src +api(capi)
    ! Statement: f_in_char*_capi
    interface
        function cpass_char_ptr_capi2(in, src) &
                result(SHT_rv) &
                bind(C, name="STR_CpassCharPtrCAPI2_CFI")
            use iso_c_binding, only : C_CHAR, C_INT
            implicit none
            character(len=*), intent(IN) :: in
            character(kind=C_CHAR), intent(IN) :: src(*)
            integer(C_INT) :: SHT_rv
        end function cpass_char_ptr_capi2
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void init_test
    ! Statement: f_subroutine
    subroutine init_test()
        ! splicer begin function.init_test
        call c_init_test()
        ! splicer end function.init_test
    end subroutine init_test
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void passChar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    !>
    !! \brief pass a single char argument as a scalar.
    !!
    !<
    subroutine pass_char(status)
        character, value, intent(IN) :: status
        ! splicer begin function.pass_char
        call c_pass_char(status)
        ! splicer end function.pass_char
    end subroutine pass_char
#endif

    ! ----------------------------------------
    ! Function:  void passCharForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    !>
    !! By default no Fortran wrapper is created.
    !! Force one so it can be tested.
    !<
    subroutine pass_char_force(status)
        character, value, intent(IN) :: status
        ! splicer begin function.pass_char_force
        call c_pass_char_force(status)
        ! splicer end function.pass_char_force
    end subroutine pass_char_force

    ! ----------------------------------------
    ! Function:  char returnChar
    ! Statement: f_function_char
    !>
    !! \brief return a char argument (non-pointer)
    !!
    !<
    function return_char() &
            result(SHT_rv)
        character :: SHT_rv
        ! splicer begin function.return_char
        call c_return_char(SHT_rv)
        ! splicer end function.return_char
    end function return_char

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void passCharPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +charlen(40)+intent(out)
    ! Statement: f_out_char*_cfi
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*_cfi
    !>
    !! \brief strcpy like behavior
    !!
    !! dest is marked intent(OUT) to override the intent(INOUT) default
    !! This avoid a copy-in on dest.
    !! In Python, src must not be over 40 characters, defined by charlen.
    !<
    ! start pass_char_ptr
    subroutine pass_char_ptr(dest, src)
        character(len=*), intent(OUT) :: dest
        character(len=*), intent(IN) :: src
        ! splicer begin function.pass_char_ptr
        call c_pass_char_ptr_CFI(dest, src)
        ! splicer end function.pass_char_ptr
    end subroutine pass_char_ptr
    ! end pass_char_ptr
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void passCharPtrInOut
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *s +intent(inout)
    ! Statement: f_inout_char*_cfi
    !>
    !! \brief toupper
    !!
    !! Change a string in-place.
    !! For Python, return a new string since strings are immutable.
    !<
    subroutine pass_char_ptr_in_out(s)
        character(len=*), intent(INOUT) :: s
        ! splicer begin function.pass_char_ptr_in_out
        call c_pass_char_ptr_in_out_CFI(s)
        ! splicer end function.pass_char_ptr_in_out
    end subroutine pass_char_ptr_in_out
#endif

    ! ----------------------------------------
    ! Function:  const char *getCharPtr1
    ! Statement: f_function_char*_cfi_allocatable
    !>
    !! \brief return a 'const char *' as character(*)
    !!
    !<
    ! start get_char_ptr1
    function get_char_ptr1() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_char_ptr1
        call c_get_char_ptr1_CFI(SHT_rv)
        ! splicer end function.get_char_ptr1
    end function get_char_ptr1
    ! end get_char_ptr1

    ! ----------------------------------------
    ! Function:  const char *getCharPtr2 +len(30)
    ! Statement: f_function_char*_cfi_copy
    !>
    !! \brief return 'const char *' with fixed size (len=30)
    !!
    !<
    ! start get_char_ptr2
    function get_char_ptr2() &
            result(SHT_rv)
        character(len=30) :: SHT_rv
        ! splicer begin function.get_char_ptr2
        call c_get_char_ptr2_CFI(SHT_rv)
        ! splicer end function.get_char_ptr2
    end function get_char_ptr2
    ! end get_char_ptr2

    ! ----------------------------------------
    ! Function:  const char *getCharPtr3
    ! Statement: f_function_char*_cfi_arg
    !>
    !! \brief return a 'const char *' as argument
    !!
    !<
    ! start get_char_ptr3
    subroutine get_char_ptr3(output)
        character(len=*), intent(OUT) :: output
        ! splicer begin function.get_char_ptr3
        call c_get_char_ptr3_CFI(output)
        ! splicer end function.get_char_ptr3
    end subroutine get_char_ptr3
    ! end get_char_ptr3

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  const char *getCharPtr4 +deref(raw)
    ! Statement: f_function_char*_raw
    !>
    !! \brief return a 'const char *' as type(C_PTR)
    !!
    !<
    function get_char_ptr4() &
            result(SHT_rv)
        type(C_PTR) :: SHT_rv
        ! splicer begin function.get_char_ptr4
        SHT_rv = c_get_char_ptr4()
        ! splicer end function.get_char_ptr4
    end function get_char_ptr4
#endif

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const char *getCharPtr5 +deref(pointer)
    ! Statement: f_function_char*_cfi_pointer
    !>
    !! \brief return a 'const char *' as character(:) pointer
    !!
    !<
    function get_char_ptr5() &
            result(SHT_rv)
        character(len=:), pointer :: SHT_rv
        ! splicer begin function.get_char_ptr5
        call c_get_char_ptr5_CFI(SHT_rv)
        ! splicer end function.get_char_ptr5
    end function get_char_ptr5
#endif

    ! ----------------------------------------
    ! Function:  const string getConstStringResult
    ! Statement: f_function_string_cfi_allocatable
    !>
    !! \brief return an ALLOCATABLE CHARACTER from std::string
    !!
    !<
    function get_const_string_result() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_result
        call c_get_const_string_result_CFI(SHT_rv)
        ! splicer end function.get_const_string_result
    end function get_const_string_result

    ! ----------------------------------------
    ! Function:  const string getConstStringLen +len(30)
    ! Statement: f_function_string_cfi_copy
    !>
    !! \brief return a 'const string' as argument
    !!
    !<
    function get_const_string_len() &
            result(SHT_rv)
        character(len=30) :: SHT_rv
        ! splicer begin function.get_const_string_len
        call c_get_const_string_len_CFI(SHT_rv)
        ! splicer end function.get_const_string_len
    end function get_const_string_len

    ! ----------------------------------------
    ! Function:  const string getConstStringAsArg
    ! Statement: f_function_string_cfi_arg
    !>
    !! \brief return a 'const string' as argument
    !!
    !<
    subroutine get_const_string_as_arg(output)
        character(len=*), intent(OUT) :: output
        ! splicer begin function.get_const_string_as_arg
        call c_get_const_string_as_arg_CFI(output)
        ! splicer end function.get_const_string_as_arg
    end subroutine get_const_string_as_arg

    ! ----------------------------------------
    ! Function:  const std::string getConstStringAlloc
    ! Statement: f_function_string_cfi_allocatable
    function get_const_string_alloc() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_alloc
        call c_get_const_string_alloc_CFI(SHT_rv)
        ! splicer end function.get_const_string_alloc
    end function get_const_string_alloc

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefPure
    ! Statement: f_function_string&_cfi_allocatable
    !>
    !! \brief return a 'const string&' as ALLOCATABLE character
    !!
    !<
    ! start get_const_string_ref_pure
    function get_const_string_ref_pure() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ref_pure
        call c_get_const_string_ref_pure_CFI(SHT_rv)
        ! splicer end function.get_const_string_ref_pure
    end function get_const_string_ref_pure
    ! end get_const_string_ref_pure

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLen +len(30)
    ! Statement: f_function_string&_cfi_copy
    !>
    !! \brief return 'const string&' with fixed size (len=30)
    !!
    !! Since +len(30) is provided, the result of the function
    !! will be copied directly into memory provided by Fortran.
    !! The function will not be ALLOCATABLE.
    !<
    function get_const_string_ref_len() &
            result(SHT_rv)
        character(len=30) :: SHT_rv
        ! splicer begin function.get_const_string_ref_len
        call c_get_const_string_ref_len_CFI(SHT_rv)
        ! splicer end function.get_const_string_ref_len
    end function get_const_string_ref_len

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefAsArg
    ! Statement: f_function_string&_cfi_arg
    !>
    !! \brief return a 'const string&' as argument
    !!
    !! Pass an additional argument which will be used as the return value.
    !! The length of the output variable is declared by the caller.
    !<
    subroutine get_const_string_ref_as_arg(output)
        character(len=*), intent(OUT) :: output
        ! splicer begin function.get_const_string_ref_as_arg
        call c_get_const_string_ref_as_arg_CFI(output)
        ! splicer end function.get_const_string_ref_as_arg
    end subroutine get_const_string_ref_as_arg

    ! ----------------------------------------
    ! Function:  const string &getConstStringRefLenEmpty +len(30)
    ! Statement: f_function_string&_cfi_copy
    !>
    !! \brief Test returning empty string reference
    !!
    !<
    function get_const_string_ref_len_empty() &
            result(SHT_rv)
        character(len=30) :: SHT_rv
        ! splicer begin function.get_const_string_ref_len_empty
        call c_get_const_string_ref_len_empty_CFI(SHT_rv)
        ! splicer end function.get_const_string_ref_len_empty
    end function get_const_string_ref_len_empty

    ! ----------------------------------------
    ! Function:  const std::string &getConstStringRefAlloc
    ! Statement: f_function_string&_cfi_allocatable
    function get_const_string_ref_alloc() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ref_alloc
        call c_get_const_string_ref_alloc_CFI(SHT_rv)
        ! splicer end function.get_const_string_ref_alloc
    end function get_const_string_ref_alloc

    ! ----------------------------------------
    ! Function:  const string *getConstStringPtrLen +len(30)
    ! Statement: f_function_string*_cfi_copy
    !>
    !! \brief return a 'const string *' as character(30)
    !!
    !! It is the caller's responsibility to release the string
    !! created by the C++ library.
    !! This is accomplished with C_finalize_buf which is possible
    !! because +len(30) so the contents are copied before returning.
    !<
    function get_const_string_ptr_len() &
            result(SHT_rv)
        character(len=30) :: SHT_rv
        ! splicer begin function.get_const_string_ptr_len
        call c_get_const_string_ptr_len_CFI(SHT_rv)
        ! splicer end function.get_const_string_ptr_len
    end function get_const_string_ptr_len

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrAlloc +owner(library)
    ! Statement: f_function_string*_cfi_allocatable_library
    function get_const_string_ptr_alloc() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ptr_alloc
        call c_get_const_string_ptr_alloc_CFI(SHT_rv)
        ! splicer end function.get_const_string_ptr_alloc
    end function get_const_string_ptr_alloc

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAlloc +owner(caller)
    ! Statement: f_function_string*_cfi_allocatable_caller
    !>
    !! It is the caller's responsibility to release the string
    !! created by the C++ library.
    !! This is accomplished +owner(caller) which sets idtor.
    !! The contents are copied by Fortran so they must outlast
    !! the return from the C wrapper.
    !<
    function get_const_string_ptr_owns_alloc() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ptr_owns_alloc
        call c_get_const_string_ptr_owns_alloc_CFI(SHT_rv)
        ! splicer end function.get_const_string_ptr_owns_alloc
    end function get_const_string_ptr_owns_alloc

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrOwnsAllocPattern +free_pattern(C_string_free)+owner(caller)
    ! Statement: f_function_string*_cfi_allocatable_caller
    !>
    !! Similar to getConstStringPtrOwnsAlloc, but uses pattern to release memory.
    !<
    function get_const_string_ptr_owns_alloc_pattern() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ptr_owns_alloc_pattern
        call c_get_const_string_ptr_owns_alloc_pattern_CFI(SHT_rv)
        ! splicer end function.get_const_string_ptr_owns_alloc_pattern
    end function get_const_string_ptr_owns_alloc_pattern

#ifdef HAVE_CHARACTER_POINTER_FUNCTION
    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrPointer +deref(pointer)+owner(library)
    ! Statement: f_function_string*_cfi_pointer_library
    function get_const_string_ptr_pointer() &
            result(SHT_rv)
        character(len=:), pointer :: SHT_rv
        ! splicer begin function.get_const_string_ptr_pointer
        call c_get_const_string_ptr_pointer_CFI(SHT_rv)
        ! splicer end function.get_const_string_ptr_pointer
    end function get_const_string_ptr_pointer
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void acceptStringConstReference
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string &arg1
    ! Statement: f_in_string&_cfi
    !>
    !! \brief Accept a const string reference
    !!
    !! Save contents of arg1.
    !! arg1 is assumed to be intent(IN) since it is const
    !! Will copy in.
    !<
    subroutine accept_string_const_reference(arg1)
        character(len=*), intent(IN) :: arg1
        ! splicer begin function.accept_string_const_reference
        call c_accept_string_const_reference_CFI(arg1)
        ! splicer end function.accept_string_const_reference
    end subroutine accept_string_const_reference
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void acceptStringReferenceOut
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1 +intent(out)
    ! Statement: f_out_string&_cfi
    !>
    !! \brief Accept a string reference
    !!
    !! Set out to a constant string.
    !! arg1 is intent(OUT)
    !! Must copy out.
    !<
    subroutine accept_string_reference_out(arg1)
        character(len=*), intent(OUT) :: arg1
        ! splicer begin function.accept_string_reference_out
        call c_accept_string_reference_out_CFI(arg1)
        ! splicer end function.accept_string_reference_out
    end subroutine accept_string_reference_out
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void acceptStringReference
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string &arg1
    ! Statement: f_inout_string&_cfi
    !>
    !! \brief Accept a string reference
    !!
    !! Append "dog" to the end of arg1.
    !! arg1 is assumed to be intent(INOUT)
    !! Must copy in and copy out.
    !<
    ! start accept_string_reference
    subroutine accept_string_reference(arg1)
        character(len=*), intent(INOUT) :: arg1
        ! splicer begin function.accept_string_reference
        call c_accept_string_reference_CFI(arg1)
        ! splicer end function.accept_string_reference
    end subroutine accept_string_reference
    ! end accept_string_reference
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void acceptStringPointerConst
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const std::string *arg1
    ! Statement: f_in_string*_cfi
    !>
    !! \brief Accept a const string pointer - intent(in)
    !!
    !<
    subroutine accept_string_pointer_const(arg1)
        character(len=*), intent(IN) :: arg1
        ! splicer begin function.accept_string_pointer_const
        call c_accept_string_pointer_const_CFI(arg1)
        ! splicer end function.accept_string_pointer_const
    end subroutine accept_string_pointer_const
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void acceptStringPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: f_inout_string*_cfi
    !>
    !! \brief Accept a string pointer - intent(inout)
    !!
    !<
    subroutine accept_string_pointer(arg1)
        character(len=*), intent(INOUT) :: arg1
        ! splicer begin function.accept_string_pointer
        call c_accept_string_pointer_CFI(arg1)
        ! splicer end function.accept_string_pointer
    end subroutine accept_string_pointer
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void fetchStringPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: f_out_string*_cfi
    !>
    !! \brief Accept a string pointer - intent(out)
    !!
    !! Return global_str.
    !<
    subroutine fetch_string_pointer(arg1)
        character(len=*), intent(OUT) :: arg1
        ! splicer begin function.fetch_string_pointer
        call c_fetch_string_pointer_CFI(arg1)
        ! splicer end function.fetch_string_pointer
    end subroutine fetch_string_pointer
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void acceptStringPointerLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1
    ! Statement: f_inout_string*_cfi
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: f_out_native*
    !>
    !! \brief Accept a string pointer - intent(inout)
    !!
    !! Test return tuple with two arguments.
    !! Must rename argument to nlen to avoid conflict with intrinsic len.
    !<
    subroutine accept_string_pointer_len(arg1, nlen)
        use iso_c_binding, only : C_INT
        character(len=*), intent(INOUT) :: arg1
        integer(C_INT), intent(OUT) :: nlen
        ! splicer begin function.accept_string_pointer_len
        call c_accept_string_pointer_len_CFI(arg1, nlen)
        ! splicer end function.accept_string_pointer_len
    end subroutine accept_string_pointer_len
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void fetchStringPointerLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string *arg1 +intent(out)
    ! Statement: f_out_string*_cfi
    ! ----------------------------------------
    ! Argument:  int *nlen +intent(out)
    ! Statement: f_out_native*
    !>
    !! \brief Accept a string pointer - intent(out)
    !!
    !! Return global_str.
    !! Test return tuple with two arguments.
    !! Must rename argument to nlen to avoid conflict with intrinsic len.
    !<
    subroutine fetch_string_pointer_len(arg1, nlen)
        use iso_c_binding, only : C_INT
        character(len=*), intent(OUT) :: arg1
        integer(C_INT), intent(OUT) :: nlen
        ! splicer begin function.fetch_string_pointer_len
        call c_fetch_string_pointer_len_CFI(arg1, nlen)
        ! splicer end function.fetch_string_pointer_len
    end subroutine fetch_string_pointer_len
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int acceptStringInstance
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  std::string arg1
    ! Statement: f_in_string_cfi
    !>
    !! \brief Accept a string instance
    !!
    !<
    function accept_string_instance(arg1) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: arg1
        integer(C_INT) :: SHT_rv
        ! splicer begin function.accept_string_instance
        SHT_rv = c_accept_string_instance_CFI(arg1)
        ! splicer end function.accept_string_instance
    end function accept_string_instance
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void fetchArrayStringArg
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +dimension(nstrs)+intent(out)
    ! Statement: f_out_string**_cfi_copy
    !>
    !! Copy output into argument strs which must be large enough
    !! to hold values.  Excess values will be truncated.
    !! The nstrs argument is the length of the array.
    !! It is associated with strs via the dimension(nstrs) attribute.
    !! +hidden indicates that it is not part of the Fortran API.
    !<
    subroutine fetch_array_string_arg(strs)
        character(len=*), intent(OUT) :: strs(nstrs)
        ! splicer begin function.fetch_array_string_arg
        call c_fetch_array_string_arg_CFI(strs)
        ! splicer end function.fetch_array_string_arg
    end subroutine fetch_array_string_arg
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void fetchArrayStringAlloc
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)
    ! Statement: f_out_string**_cfi_allocatable
    !>
    !! Copy output into argument strs which must be large enough
    !! to hold values.  Excess values will be truncated.
    !! The nstrs argument is the length of the array.
    !! It is associated with strs via the dimension(nstrs) attribute.
    !! +hidden indicates that it is not part of the Fortran API.
    !! The defered length is set to the maximum string length.
    !<
    subroutine fetch_array_string_alloc(strs)
        character(len=:), intent(OUT), allocatable :: strs(:)
        ! splicer begin function.fetch_array_string_alloc
        call c_fetch_array_string_alloc_CFI(strs)
        ! splicer end function.fetch_array_string_alloc
    end subroutine fetch_array_string_alloc
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void fetchArrayStringAllocLen
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::string **strs +deref(allocatable)+dimension(nstrs)+intent(out)+len(20)
    ! Statement: f_out_string**_cfi_allocatable
    !>
    !! Copy output into argument strs which must be large enough
    !! to hold values.  Excess values will be truncated.
    !! The nstrs argument is the length of the array.
    !! It is associated with strs via the dimension(nstrs) attribute.
    !! +hidden indicates that it is not part of the Fortran API.
    !! The defered length is set to the len attribute.
    !<
    subroutine fetch_array_string_alloc_len(strs)
        character(len=:), intent(OUT), allocatable :: strs(:)
        ! splicer begin function.fetch_array_string_alloc_len
        call c_fetch_array_string_alloc_len_CFI(strs)
        ! splicer end function.fetch_array_string_alloc_len
    end subroutine fetch_array_string_alloc_len
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void explicit1
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(in)+len_trim(AAlen)
    ! Statement: f_in_char*_cfi
    subroutine explicit1(name)
        character(len=*), intent(IN) :: name
        ! splicer begin function.explicit1
        call c_explicit1_CFI(name)
        ! splicer end function.explicit1
    end subroutine explicit1
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void explicit2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *name +intent(out)+len(AAtrim)
    ! Statement: f_out_char*_cfi
    subroutine explicit2(name)
        character(len=*), intent(OUT) :: name
        ! splicer begin function.explicit2
        call c_explicit2_CFI(name)
        ! splicer end function.explicit2
    end subroutine explicit2
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void CpassChar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char status
    ! Statement: f_in_char
    !>
    !! \brief pass a single char argument as a scalar, extern "C"
    !!
    !<
    subroutine cpass_char(status)
        character, value, intent(IN) :: status
        ! splicer begin function.cpass_char
        call c_cpass_char(status)
        ! splicer end function.cpass_char
    end subroutine cpass_char
#endif

    ! ----------------------------------------
    ! Function:  char CreturnChar
    ! Statement: f_function_char
    !>
    !! \brief return a char argument (non-pointer), extern "C"
    !!
    !<
    function creturn_char() &
            result(SHT_rv)
        character :: SHT_rv
        ! splicer begin function.creturn_char
        call c_creturn_char(SHT_rv)
        ! splicer end function.creturn_char
    end function creturn_char

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void CpassCharPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: f_out_char*_cfi
    ! ----------------------------------------
    ! Argument:  const char *src +blanknull
    ! Statement: f_in_char*_cfi
    !>
    !! \brief strcpy like behavior
    !!
    !! dest is marked intent(OUT) to override the intent(INOUT) default
    !! This avoid a copy-in on dest.
    !! extern "C"
    !! If src is a blank string, pass a NULL pointer to C library function.
    !<
    subroutine cpass_char_ptr(dest, src)
        character(len=*), intent(OUT) :: dest
        character(len=*), intent(IN) :: src
        ! splicer begin function.cpass_char_ptr
        call c_cpass_char_ptr_CFI(dest, src)
        ! splicer end function.cpass_char_ptr
    end subroutine cpass_char_ptr
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void CpassCharPtrBlank
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  char *dest +intent(out)
    ! Statement: f_out_char*_cfi
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*_cfi
    !>
    !! \brief Test F_blanknull option
    !!
    !<
    subroutine cpass_char_ptr_blank(dest, src)
        character(len=*), intent(OUT) :: dest
        character(len=*), intent(IN) :: src
        ! splicer begin function.cpass_char_ptr_blank
        call c_cpass_char_ptr_blank_CFI(dest, src)
        ! splicer end function.cpass_char_ptr_blank
    end subroutine cpass_char_ptr_blank
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void PostDeclare
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *count +intent(in)+rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  std::string &name
    ! Statement: f_inout_string&_cfi
    !>
    !! Test post_declare.
    !! The std::string in py_string_inout must be declared before the
    !! goto added by py_native_*_in_pointer_list to avoid
    !! "jump to label 'fail' crosses initialization of" error.
    !<
    subroutine post_declare(count, name)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: count(:)
        character(len=*), intent(INOUT) :: name
        ! splicer begin function.post_declare
        call c_post_declare_CFI(count, name)
        ! splicer end function.post_declare
    end subroutine post_declare
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int CpassCharPtrNotrim
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *src
    ! Statement: f_in_char*_cfi
    !>
    !! \brief NULL terminate input string in C, not in Fortran.
    !!
    !<
    function cpass_char_ptr_notrim(src) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: src
        integer(C_INT) :: SHT_rv
        ! splicer begin function.cpass_char_ptr_notrim
        SHT_rv = c_cpass_char_ptr_notrim_CFI(src)
        ! splicer end function.cpass_char_ptr_notrim
    end function cpass_char_ptr_notrim
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int CpassCharPtrCAPI
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void *addr
    ! Statement: f_in_void*
    ! ----------------------------------------
    ! Argument:  const char *src +api(capi)
    ! Statement: f_in_char*_capi
    !>
    !! \brief Do not NULL terminate input string
    !!
    !! The C library function should get the same address
    !! for addr and src.
    !! Used when the C function needs the true address of the argument.
    !! Skips null-termination. Useful to create an interface for
    !! a function which is already callable by Fortran.
    !! For example, the length is passed explicitly.
    !! This example will not create a Fortran wrapper since C can be
    !! called directly.
    !<
    function cpass_char_ptr_capi(addr, src) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR
        type(C_PTR), intent(IN) :: addr
        character(len=*), intent(IN) :: src
        integer(C_INT) :: SHT_rv
        ! splicer begin function.cpass_char_ptr_capi
        SHT_rv = c_cpass_char_ptr_capi(addr, src)
        ! splicer end function.cpass_char_ptr_capi
    end function cpass_char_ptr_capi
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int CpassCharPtrCAPI2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const char *in
    ! Statement: f_in_char*_cfi
    ! ----------------------------------------
    ! Argument:  const char *src +api(capi)
    ! Statement: f_in_char*_capi
    !>
    !! \brief Mix api(buf) and api(capi)
    !!
    !<
    function cpass_char_ptr_capi2(in, src) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: in
        character(len=*), intent(IN) :: src
        integer(C_INT) :: SHT_rv
        ! splicer begin function.cpass_char_ptr_capi2
        SHT_rv = c_cpass_char_ptr_capi2_CFI(in, src)
        ! splicer end function.cpass_char_ptr_capi2
    end function cpass_char_ptr_capi2
#endif

    ! splicer begin additional_functions
    ! splicer end additional_functions

end module strings_mod
