// wrapstatement.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "statement.hpp"
// typemap
#include <string>
// shroud
#include <cstring>
#include "wrapstatement.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {


// helper ShroudCharCopy
// Copy src into dest, blank fill to ndest characters
// Truncate if dest is too short.
// dest will not be NULL terminated.
static void ShroudCharCopy(char *dest, int ndest, const char *src, int nsrc)
{
    if (src == NULL) {
        std::memset(dest,' ',ndest); // convert NULL pointer to blank filled string
    } else {
        if (nsrc < 0) nsrc = std::strlen(src);
        int nm = nsrc < ndest ? nsrc : ndest;
        std::memcpy(dest,src,nm);
        if(ndest > nm) std::memset(dest+nm,' ',ndest-nm); // blank fill
    }
}

// splicer begin C_definitions
// splicer end C_definitions

/**
 * \brief helper function for Fortran to get length of name.
 *
 */
// ----------------------------------------
// Function:  int GetNameLength +pure
// Statement: c_function_native
int STMT_GetNameLength(void)
{
    // splicer begin function.GetNameLength
    return getNameErrorPattern().length();
    // splicer end function.GetNameLength
}

// ----------------------------------------
// Function:  const string &getNameErrorPattern +len(get_name_length())
// Statement: c_function_string&
const char * STMT_getNameErrorPattern(void)
{
    // splicer begin function.getNameErrorPattern
    const std::string &SHCXX_rv = getNameErrorPattern();
    // C_error_pattern
    if (! isNameValid(SHCXX_rv)) {
        return NULL;
    }

    const char * SHC_rv = SHCXX_rv.c_str();
    return SHC_rv;
    // splicer end function.getNameErrorPattern
}

// ----------------------------------------
// Function:  const string &getNameErrorPattern +len(get_name_length())
// Statement: f_function_string&_buf_copy
void STMT_getNameErrorPattern_bufferify(char *SHC_rv, int SHT_rv_len)
{
    // splicer begin function.getNameErrorPattern_bufferify
    const std::string &SHCXX_rv = getNameErrorPattern();
    if (SHCXX_rv.empty()) {
        ShroudCharCopy(SHC_rv, SHT_rv_len, nullptr, 0);
    } else {
        ShroudCharCopy(SHC_rv, SHT_rv_len, SHCXX_rv.data(),
            SHCXX_rv.size());
    }
    // splicer end function.getNameErrorPattern_bufferify
}

// ----------------------------------------
// Function:  bool nameIsValid
// Statement: c_function_bool
// ----------------------------------------
// Argument:  const std::string &name
// Statement: c_in_string&
bool STMT_nameIsValid(const char *name)
{
    // splicer begin function.nameIsValid
    return name != NULL;
    // splicer end function.nameIsValid
}

}  // extern "C"
