! wrapfshared.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfshared.f
!! \brief Shroud generated wrapper for Shared library
!<
! splicer begin file_top
! splicer end file_top
module shared_mod
    use iso_c_binding, only : C_INT, C_NULL_PTR, C_PTR
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper capsule_data_helper
    type, bind(C) :: SHA_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type SHA_SHROUD_capsule_data

    type object
        type(SHA_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.Object.component_part
        ! splicer end class.Object.component_part
    contains
        procedure :: dtor => object_dtor
        procedure :: create_child_a => object_create_child_a
        procedure :: create_child_b => object_create_child_b
        procedure :: replace_child_b => object_replace_child_b
        procedure :: get_instance => object_get_instance
        procedure :: set_instance => object_set_instance
        procedure :: associated => object_associated
        ! splicer begin class.Object.type_bound_procedure_part
        ! splicer end class.Object.type_bound_procedure_part
    end type object

    type, extends(object) :: object_shared
        ! splicer begin class.Object_shared.component_part
        ! splicer end class.Object_shared.component_part
    contains
        procedure :: dtor => object_shared_dtor
        procedure :: create_child_a => object_shared_create_child_a
        procedure :: create_child_b => object_shared_create_child_b
        procedure :: replace_child_b => object_shared_replace_child_b
        procedure :: use_count => object_shared_use_count
        final :: object_shared_final
        ! splicer begin class.Object_shared.type_bound_procedure_part
        ! splicer end class.Object_shared.type_bound_procedure_part
    end type object_shared

    type, extends(object) :: object_weak
        ! splicer begin class.Object_weak.component_part
        ! splicer end class.Object_weak.component_part
    contains
        procedure :: assign_weak => object_weak_assign_weak
        generic :: assignment(=) => assign_weak
        procedure :: use_count => object_weak_use_count
        final :: object_weak_final
        ! splicer begin class.Object_weak.type_bound_procedure_part
        ! splicer end class.Object_weak.type_bound_procedure_part
    end type object_weak

    interface operator (.eq.)
        module procedure object_eq
        module procedure object_shared_eq
        module procedure object_weak_eq
    end interface

    interface operator (.ne.)
        module procedure object_ne
        module procedure object_shared_ne
        module procedure object_weak_ne
    end interface

    interface

        ! ----------------------------------------
        ! Function:  Object
        ! Statement: c_ctor_shadow_capptr
        function c_object_ctor(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="SHA_Object_ctor")
            use iso_c_binding, only : C_PTR
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_object_ctor

        ! ----------------------------------------
        ! Function:  Object
        ! Statement: f_ctor_shadow_capsule
        subroutine c_object_ctor_bufferify(SHT_rv) &
                bind(C, name="SHA_Object_ctor_bufferify")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_object_ctor_bufferify

        ! ----------------------------------------
        ! Function:  ~Object
        ! Statement: f_dtor
        subroutine c_object_dtor(self) &
                bind(C, name="SHA_Object_dtor")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(INOUT) :: self
        end subroutine c_object_dtor

        ! ----------------------------------------
        ! Function:  std::shared_ptr<Object> *createChildA
        ! Statement: c_function_smartptr<shadow>*_capptr
        function c_object_create_child_a(self, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="SHA_Object_createChildA")
            use iso_c_binding, only : C_PTR
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_object_create_child_a

        ! ----------------------------------------
        ! Function:  std::shared_ptr<Object> *createChildA
        ! Statement: f_function_smartptr<shadow>*_capsule
        subroutine c_object_create_child_a_bufferify(self, SHT_rv) &
                bind(C, name="SHA_Object_createChildA_bufferify")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_object_create_child_a_bufferify

        ! ----------------------------------------
        ! Function:  std::shared_ptr<Object> *createChildB
        ! Statement: c_function_smartptr<shadow>*_capptr
        function c_object_create_child_b(self, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="SHA_Object_createChildB")
            use iso_c_binding, only : C_PTR
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_object_create_child_b

        ! ----------------------------------------
        ! Function:  std::shared_ptr<Object> *createChildB
        ! Statement: f_function_smartptr<shadow>*_capsule
        subroutine c_object_create_child_b_bufferify(self, SHT_rv) &
                bind(C, name="SHA_Object_createChildB_bufferify")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_object_create_child_b_bufferify

        ! ----------------------------------------
        ! Function:  void replaceChildB
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  std::shared_ptr<Object> *child
        ! Statement: f_inout_smartptr<shadow>*
        subroutine c_object_replace_child_b(self, child) &
                bind(C, name="SHA_Object_replaceChildB")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(INOUT) :: child
        end subroutine c_object_replace_child_b

        ! ----------------------------------------
        ! Function:  Object
        ! Statement: c_ctor_shadow_capptr_shared
        function c_object_shared_ctor(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="SHA_Object_shared_ctor")
            use iso_c_binding, only : C_PTR
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_object_shared_ctor

        ! ----------------------------------------
        ! Function:  Object
        ! Statement: f_ctor_shadow_capsule_shared
        subroutine c_object_shared_ctor_bufferify(SHT_rv) &
                bind(C, name="SHA_Object_shared_ctor_bufferify")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_object_shared_ctor_bufferify

        ! ----------------------------------------
        ! Function:  ~Object
        ! Statement: f_dtor
        subroutine c_object_shared_dtor(self) &
                bind(C, name="SHA_Object_shared_dtor")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(INOUT) :: self
        end subroutine c_object_shared_dtor

        ! ----------------------------------------
        ! Function:  std::shared_ptr<Object> *createChildA
        ! Statement: c_function_smartptr<shadow>*_capptr
        function c_object_shared_create_child_a(self, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="SHA_Object_shared_createChildA")
            use iso_c_binding, only : C_PTR
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_object_shared_create_child_a

        ! ----------------------------------------
        ! Function:  std::shared_ptr<Object> *createChildA
        ! Statement: f_function_smartptr<shadow>*_capsule
        subroutine c_object_shared_create_child_a_bufferify(self, &
                SHT_rv) &
                bind(C, name="SHA_Object_shared_createChildA_bufferify")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_object_shared_create_child_a_bufferify

        ! ----------------------------------------
        ! Function:  std::shared_ptr<Object> *createChildB
        ! Statement: c_function_smartptr<shadow>*_capptr
        function c_object_shared_create_child_b(self, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="SHA_Object_shared_createChildB")
            use iso_c_binding, only : C_PTR
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_object_shared_create_child_b

        ! ----------------------------------------
        ! Function:  std::shared_ptr<Object> *createChildB
        ! Statement: f_function_smartptr<shadow>*_capsule
        subroutine c_object_shared_create_child_b_bufferify(self, &
                SHT_rv) &
                bind(C, name="SHA_Object_shared_createChildB_bufferify")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_object_shared_create_child_b_bufferify

        ! ----------------------------------------
        ! Function:  void replaceChildB
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  std::shared_ptr<Object> *child
        ! Statement: f_inout_smartptr<shadow>*
        subroutine c_object_shared_replace_child_b(self, child) &
                bind(C, name="SHA_Object_shared_replaceChildB")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(INOUT) :: child
        end subroutine c_object_shared_replace_child_b

        ! ----------------------------------------
        ! Function:  long use_count
        ! Statement: f_function_native
        function c_object_shared_use_count(self) &
                result(SHT_rv) &
                bind(C, name="SHA_Object_shared_use_count")
            use iso_c_binding, only : C_LONG
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_LONG) :: SHT_rv
        end function c_object_shared_use_count

        ! ----------------------------------------
        ! Function:  void assign_weak +custom(weakptr)+operator(assignment)
        ! Statement: f_subroutine_assignment_weakptr
        ! ----------------------------------------
        ! Argument:  std::shared_ptr<Object> *from +intent(in)
        ! Statement: f_in_smartptr<shadow>*
        subroutine c_object_weak_assign_weak(self, from) &
                bind(C, name="SHA_Object_weak_assign_weak")
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            type(SHA_SHROUD_capsule_data), intent(IN) :: from
        end subroutine c_object_weak_assign_weak

        ! ----------------------------------------
        ! Function:  long use_count
        ! Statement: f_function_native
        function c_object_weak_use_count(self) &
                result(SHT_rv) &
                bind(C, name="SHA_Object_weak_use_count")
            use iso_c_binding, only : C_LONG
            import :: SHA_SHROUD_capsule_data
            implicit none
            type(SHA_SHROUD_capsule_data), intent(IN) :: self
            integer(C_LONG) :: SHT_rv
        end function c_object_weak_use_count
    end interface

    interface object
        module procedure object_ctor
    end interface object

    interface object_shared
        module procedure object_shared_ctor
    end interface object_shared

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

    ! ----------------------------------------
    ! Function:  Object
    ! Statement: f_ctor_shadow_capsule
    function object_ctor() &
            result(SHT_rv)
        type(object) :: SHT_rv
        ! splicer begin class.Object.method.ctor
        call c_object_ctor_bufferify(SHT_rv%cxxmem)
        ! splicer end class.Object.method.ctor
    end function object_ctor

    ! ----------------------------------------
    ! Function:  ~Object
    ! Statement: f_dtor
    subroutine object_dtor(obj)
        class(object), intent(INOUT) :: obj
        ! splicer begin class.Object.method.dtor
        call c_object_dtor(obj%cxxmem)
        ! splicer end class.Object.method.dtor
    end subroutine object_dtor

    ! ----------------------------------------
    ! Function:  std::shared_ptr<Object> *createChildA
    ! Statement: f_function_smartptr<shadow>*_capsule
    function object_create_child_a(obj) &
            result(SHT_rv)
        class(object), intent(INOUT) :: obj
        type(object_shared) :: SHT_rv
        ! splicer begin class.Object.method.create_child_a
        call c_object_create_child_a_bufferify(obj%cxxmem, &
            SHT_rv%cxxmem)
        ! splicer end class.Object.method.create_child_a
    end function object_create_child_a

    ! ----------------------------------------
    ! Function:  std::shared_ptr<Object> *createChildB
    ! Statement: f_function_smartptr<shadow>*_capsule
    function object_create_child_b(obj) &
            result(SHT_rv)
        class(object), intent(INOUT) :: obj
        type(object_shared) :: SHT_rv
        ! splicer begin class.Object.method.create_child_b
        call c_object_create_child_b_bufferify(obj%cxxmem, &
            SHT_rv%cxxmem)
        ! splicer end class.Object.method.create_child_b
    end function object_create_child_b

    ! ----------------------------------------
    ! Function:  void replaceChildB
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::shared_ptr<Object> *child
    ! Statement: f_inout_smartptr<shadow>*
    subroutine object_replace_child_b(obj, child)
        class(object), intent(INOUT) :: obj
        type(object_shared), intent(INOUT) :: child
        ! splicer begin class.Object.method.replace_child_b
        call c_object_replace_child_b(obj%cxxmem, child%cxxmem)
        ! splicer end class.Object.method.replace_child_b
    end subroutine object_replace_child_b

    ! Return pointer to C++ memory.
    function object_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(object), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function object_get_instance

    subroutine object_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(object), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine object_set_instance

    function object_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(object), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function object_associated

    ! splicer begin class.Object.additional_functions
    ! splicer end class.Object.additional_functions

    ! ----------------------------------------
    ! Function:  Object
    ! Statement: f_ctor_shadow_capsule_shared
    function object_shared_ctor() &
            result(SHT_rv)
        type(object_shared) :: SHT_rv
        ! splicer begin class.Object_shared.method.ctor
        call c_object_shared_ctor_bufferify(SHT_rv%cxxmem)
        ! splicer end class.Object_shared.method.ctor
    end function object_shared_ctor

    ! ----------------------------------------
    ! Function:  ~Object
    ! Statement: f_dtor
    subroutine object_shared_dtor(obj)
        class(object_shared), intent(INOUT) :: obj
        ! splicer begin class.Object_shared.method.dtor
        call c_object_shared_dtor(obj%cxxmem)
        ! splicer end class.Object_shared.method.dtor
    end subroutine object_shared_dtor

    ! ----------------------------------------
    ! Function:  std::shared_ptr<Object> *createChildA
    ! Statement: f_function_smartptr<shadow>*_capsule
    function object_shared_create_child_a(obj) &
            result(SHT_rv)
        class(object_shared), intent(INOUT) :: obj
        type(object_shared) :: SHT_rv
        ! splicer begin class.Object_shared.method.create_child_a
        call c_object_shared_create_child_a_bufferify(obj%cxxmem, &
            SHT_rv%cxxmem)
        ! splicer end class.Object_shared.method.create_child_a
    end function object_shared_create_child_a

    ! ----------------------------------------
    ! Function:  std::shared_ptr<Object> *createChildB
    ! Statement: f_function_smartptr<shadow>*_capsule
    function object_shared_create_child_b(obj) &
            result(SHT_rv)
        class(object_shared), intent(INOUT) :: obj
        type(object_shared) :: SHT_rv
        ! splicer begin class.Object_shared.method.create_child_b
        call c_object_shared_create_child_b_bufferify(obj%cxxmem, &
            SHT_rv%cxxmem)
        ! splicer end class.Object_shared.method.create_child_b
    end function object_shared_create_child_b

    ! ----------------------------------------
    ! Function:  void replaceChildB
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  std::shared_ptr<Object> *child
    ! Statement: f_inout_smartptr<shadow>*
    subroutine object_shared_replace_child_b(obj, child)
        class(object_shared), intent(INOUT) :: obj
        type(object_shared), intent(INOUT) :: child
        ! splicer begin class.Object_shared.method.replace_child_b
        call c_object_shared_replace_child_b(obj%cxxmem, child%cxxmem)
        ! splicer end class.Object_shared.method.replace_child_b
    end subroutine object_shared_replace_child_b

    ! ----------------------------------------
    ! Function:  long use_count
    ! Statement: f_function_native
    function object_shared_use_count(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_LONG
        class(object_shared), intent(INOUT) :: obj
        integer(C_LONG) :: SHT_rv
        ! splicer begin class.Object_shared.method.use_count
        SHT_rv = c_object_shared_use_count(obj%cxxmem)
        ! splicer end class.Object_shared.method.use_count
    end function object_shared_use_count

    subroutine object_shared_final(obj)
        use iso_c_binding, only : c_associated
        type(object_shared), intent(INOUT) :: obj
        interface
            subroutine array_destructor(capsule) &
                bind(C, name="SHA_SHROUD_memory_destructor")
                import SHA_SHROUD_capsule_data
                implicit none
                type(SHA_SHROUD_capsule_data), intent(INOUT) :: capsule
            end subroutine array_destructor
        end interface
        if (c_associated(obj%cxxmem%addr)) then
            call array_destructor(obj%cxxmem)
        endif
    end subroutine object_shared_final

    ! splicer begin class.Object_shared.additional_functions
    ! splicer end class.Object_shared.additional_functions

    ! ----------------------------------------
    ! Function:  void assign_weak +custom(weakptr)+operator(assignment)
    ! Statement: f_subroutine_assignment_weakptr
    ! ----------------------------------------
    ! Argument:  std::shared_ptr<Object> *from +intent(in)
    ! Statement: f_in_smartptr<shadow>*
    subroutine object_weak_assign_weak(obj, from)
        class(object_weak), intent(INOUT) :: obj
        type(object_shared), intent(IN) :: from
        ! splicer begin class.Object_weak.method.assign_weak
        call c_object_weak_assign_weak(obj%cxxmem, from%cxxmem)
        ! splicer end class.Object_weak.method.assign_weak
    end subroutine object_weak_assign_weak

    ! ----------------------------------------
    ! Function:  long use_count
    ! Statement: f_function_native
    function object_weak_use_count(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_LONG
        class(object_weak), intent(INOUT) :: obj
        integer(C_LONG) :: SHT_rv
        ! splicer begin class.Object_weak.method.use_count
        SHT_rv = c_object_weak_use_count(obj%cxxmem)
        ! splicer end class.Object_weak.method.use_count
    end function object_weak_use_count

    subroutine object_weak_final(obj)
        use iso_c_binding, only : c_associated
        type(object_weak), intent(INOUT) :: obj
        interface
            subroutine array_destructor(capsule) &
                bind(C, name="SHA_SHROUD_memory_destructor")
                import SHA_SHROUD_capsule_data
                implicit none
                type(SHA_SHROUD_capsule_data), intent(INOUT) :: capsule
            end subroutine array_destructor
        end interface
        if (c_associated(obj%cxxmem%addr)) then
            call array_destructor(obj%cxxmem)
        endif
    end subroutine object_weak_final

    ! splicer begin class.Object_weak.additional_functions
    ! splicer end class.Object_weak.additional_functions

    ! splicer begin additional_functions
    ! splicer end additional_functions

    function object_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(object), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function object_eq

    function object_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(object), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function object_ne

    function object_shared_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(object_shared), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function object_shared_eq

    function object_shared_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(object_shared), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function object_shared_ne

    function object_weak_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(object_weak), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function object_weak_eq

    function object_weak_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(object_weak), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function object_weak_ne

end module shared_mod
