// utilShared.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// typemap
#include "shared.hpp"
// shroud
#include "typesShared.h"
#include <memory>


#ifdef __cplusplus
extern "C" {
#endif

// Release library allocated memory.
void SHA_SHROUD_memory_destructor(SHA_SHROUD_capsule_data *cap)
{
    void *ptr = cap->addr;
    switch (cap->idtor) {
    case 0:   // --none--
    {
        // Nothing to delete
        break;
    }
    case 1:   // Object
    {
        Object *cxx_ptr = reinterpret_cast<Object *>(ptr);
        delete cxx_ptr;
        break;
    }
    case 2:   // std::shared_ptr<Object>
    {
        std::shared_ptr<Object> *cxx_ptr = 
            reinterpret_cast<std::shared_ptr<Object> *>(ptr);
        delete cxx_ptr;
        break;
    }
    case 3:   // shadow-std::shared_ptr<Object>
    {
        std::shared_ptr<Object> *shared =
            reinterpret_cast<std::shared_ptr<Object> *>(ptr);
        shared->reset();
        delete shared;
        break;
    }
    case 4:   // assignment-std::weak_ptr<Object>
    {
        auto cxx_ptr = reinterpret_cast<std::weak_ptr<Object>*>(ptr);
        delete cxx_ptr;
        break;
    }
    default:
    {
        // Unexpected case in destructor
        break;
    }
    }
    cap->addr = nullptr;
    cap->idtor = 0;  // avoid deleting again
}

#ifdef __cplusplus
}
#endif
