! wrapfscope.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfscope.f
!! \brief Shroud generated wrapper for scope library
!<
! splicer begin file_top
! splicer end file_top
module scope_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! helper array_context
    type, bind(C) :: SCO_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type SCO_SHROUD_array

    ! helper capsule_data_helper
    type, bind(C) :: SCO_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type SCO_SHROUD_capsule_data

    !  enum Class1::Color
    integer, parameter :: class1_color = C_INT
    ! splicer begin class.Class1.enum.Color
    integer(class1_color), parameter :: class1_red = 40
    integer(class1_color), parameter :: class1_blue = 41
    integer(class1_color), parameter :: class1_white = 42
    ! splicer end class.Class1.enum.Color

    !  enum Class2::Color
    integer, parameter :: class2_color = C_INT
    ! splicer begin class.Class2.enum.Color
    integer(class2_color), parameter :: class2_red = 50
    integer(class2_color), parameter :: class2_blue = 51
    integer(class2_color), parameter :: class2_white = 52
    ! splicer end class.Class2.enum.Color

    !  enum Color
    integer, parameter :: color = C_INT
    ! splicer begin enum.Color
    integer(color), parameter :: red = 10
    integer(color), parameter :: blue = 11
    integer(color), parameter :: white = 12
    ! splicer end enum.Color

    !  enum ns3::Color
    integer, parameter :: ns3_color = C_INT
    ! splicer begin enum.Color
    integer(ns3_color), parameter :: ns3_red = 70
    integer(ns3_color), parameter :: ns3_blue = 71
    integer(ns3_color), parameter :: ns3_white = 72
    ! splicer end enum.Color

    !  enum class ColorEnum
    ! splicer begin enum.ColorEnum
    integer(color_enum), parameter :: colorenum_red = 60
    integer(color_enum), parameter :: colorenum_blue = 61
    integer(color_enum), parameter :: colorenum_white = 62
    ! splicer end enum.ColorEnum


    type, bind(C) :: data_pointer
        integer(C_INT) :: nitems
        type(C_PTR) :: items
    end type data_pointer

    type class1
        type(SCO_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.Class1.component_part
        ! splicer end class.Class1.component_part
    contains
        procedure :: get_instance => class1_get_instance
        procedure :: set_instance => class1_set_instance
        procedure :: associated => class1_associated
        ! splicer begin class.Class1.type_bound_procedure_part
        ! splicer end class.Class1.type_bound_procedure_part
    end type class1

    type class2
        type(SCO_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.Class2.component_part
        ! splicer end class.Class2.component_part
    contains
        procedure :: get_instance => class2_get_instance
        procedure :: set_instance => class2_set_instance
        procedure :: associated => class2_associated
        ! splicer begin class.Class2.type_bound_procedure_part
        ! splicer end class.Class2.type_bound_procedure_part
    end type class2

    interface operator (.eq.)
        module procedure class1_eq
        module procedure class2_eq
    end interface

    interface operator (.ne.)
        module procedure class1_ne
        module procedure class2_ne
    end interface

    interface

        ! Generated by getter/setter
        ! ----------------------------------------
        ! Function:  int *DataPointer_get_items +dimension(nitems)+intent(getter)
        ! Statement: f_getter_native*_cdesc_pointer
        ! ----------------------------------------
        ! Argument:  ns3::DataPointer *SH_this +intent(in)
        ! Statement: f_in_struct*
        subroutine c_data_pointer_get_items(SH_this, SHT_rv_cdesc) &
                bind(C, name="SCO_DataPointer_get_items")
            use scope_ns3_mod, only : data_pointer
            import :: SCO_SHROUD_array
            implicit none
            type(data_pointer), intent(IN) :: SH_this
            type(SCO_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_data_pointer_get_items

        ! Generated by getter/setter
        ! ----------------------------------------
        ! Function:  void DataPointer_set_items +intent(setter)
        ! Statement: f_setter
        ! ----------------------------------------
        ! Argument:  ns3::DataPointer *SH_this
        ! Statement: f_inout_struct*
        ! ----------------------------------------
        ! Argument:  int *val +intent(setter)+rank(1)
        ! Statement: f_setter_native*
        subroutine data_pointer_set_items(SH_this, val) &
                bind(C, name="SCO_DataPointer_set_items")
            use iso_c_binding, only : C_INT
            use scope_ns3_mod, only : data_pointer
            implicit none
            type(data_pointer), intent(INOUT) :: SH_this
            integer(C_INT), intent(IN) :: val(*)
        end subroutine data_pointer_set_items
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

    ! Return pointer to C++ memory.
    function class1_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(class1), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function class1_get_instance

    subroutine class1_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(class1), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine class1_set_instance

    function class1_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(class1), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function class1_associated

    ! splicer begin class.Class1.additional_functions
    ! splicer end class.Class1.additional_functions

    ! Return pointer to C++ memory.
    function class2_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(class2), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function class2_get_instance

    subroutine class2_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(class2), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine class2_set_instance

    function class2_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(class2), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function class2_associated

    ! splicer begin class.Class2.additional_functions
    ! splicer end class.Class2.additional_functions

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int *DataPointer_get_items +dimension(nitems)+intent(getter)
    ! Statement: f_getter_native*_cdesc_pointer
    ! ----------------------------------------
    ! Argument:  ns3::DataPointer *SH_this +intent(in)
    ! Statement: f_in_struct*
    function data_pointer_get_items(SH_this) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, c_f_pointer
        use scope_ns3_mod, only : data_pointer
        type(data_pointer), intent(IN) :: SH_this
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin function.data_pointer_get_items
        type(SCO_SHROUD_array) :: SHT_rv_cdesc
        call c_data_pointer_get_items(SH_this, SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end function.data_pointer_get_items
    end function data_pointer_get_items

#if 0
    ! Only the interface is needed
    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  void DataPointer_set_items +intent(setter)
    ! Statement: f_setter
    ! ----------------------------------------
    ! Argument:  ns3::DataPointer *SH_this
    ! Statement: f_inout_struct*
    ! ----------------------------------------
    ! Argument:  int *val +intent(setter)+rank(1)
    ! Statement: f_setter_native*
    subroutine data_pointer_set_items(SH_this, val)
        use iso_c_binding, only : C_INT
        use scope_ns3_mod, only : data_pointer
        type(data_pointer), intent(INOUT) :: SH_this
        integer(C_INT), intent(IN) :: val(:)
        ! splicer begin function.data_pointer_set_items
        call c_data_pointer_set_items(SH_this, val)
        ! splicer end function.data_pointer_set_items
    end subroutine data_pointer_set_items
#endif

    ! splicer begin additional_functions
    ! splicer end additional_functions

    function class1_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class1), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function class1_eq

    function class1_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class1), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function class1_ne

    function class2_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class2), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function class2_eq

    function class2_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class2), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function class2_ne

end module scope_mod
