// pypointersmodule.c
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//
#include "pypointersmodule.h"

// shroud
#include <stdlib.h>

// splicer begin include
// splicer end include

#ifdef __cplusplus
#define SHROUD_UNUSED(param)
#else
#define SHROUD_UNUSED(param) param
#endif

#if PY_MAJOR_VERSION >= 3
#define PyInt_AsLong PyLong_AsLong
#define PyInt_FromLong PyLong_FromLong
#define PyInt_FromSize_t PyLong_FromSize_t
#define PyString_FromString PyUnicode_FromString
#define PyString_FromStringAndSize PyUnicode_FromStringAndSize
#endif

// helper get_from_object_char
// Converter from PyObject to char *.
// The returned status will be 1 for a successful conversion
// and 0 if the conversion has failed.
// value.obj is unused.
// value.dataobj - object which holds the data.
// If same as obj argument, its refcount is incremented.
// value.data is owned by value.dataobj and must be copied to be preserved.
// Caller must use Py_XDECREF(value.dataobj).
static int SHROUD_get_from_object_char(PyObject *obj,
    POI_SHROUD_converter_value *value)
{
    size_t size = 0;
    char *out;
    if (PyUnicode_Check(obj)) {
#if PY_MAJOR_VERSION >= 3
        PyObject *strobj = PyUnicode_AsUTF8String(obj);
        out = PyBytes_AS_STRING(strobj);
        size = PyBytes_GET_SIZE(strobj);
        value->dataobj = strobj;  // steal reference
#else
        PyObject *strobj = PyUnicode_AsUTF8String(obj);
        out = PyString_AsString(strobj);
        size = PyString_Size(obj);
        value->dataobj = strobj;  // steal reference
#endif
#if PY_MAJOR_VERSION < 3
    } else if (PyString_Check(obj)) {
        out = PyString_AsString(obj);
        size = PyString_Size(obj);
        value->dataobj = obj;
        Py_INCREF(obj);
#endif
    } else if (PyBytes_Check(obj)) {
        out = PyBytes_AS_STRING(obj);
        size = PyBytes_GET_SIZE(obj);
        value->dataobj = obj;
        Py_INCREF(obj);
    } else if (PyByteArray_Check(obj)) {
        out = PyByteArray_AS_STRING(obj);
        size = PyByteArray_GET_SIZE(obj);
        value->dataobj = obj;
        Py_INCREF(obj);
    } else if (obj == Py_None) {
        out = NULL;
        size = 0;
        value->dataobj = NULL;
    } else {
        PyErr_Format(PyExc_TypeError,
            "argument should be string or None, not %.200s",
            Py_TYPE(obj)->tp_name);
        return 0;
    }
    value->obj = NULL;
    value->data = out;
    value->size = size;
    return 1;
}



// helper FREE_get_from_object_charptr
static void FREE_get_from_object_charptr(PyObject *obj)
{
    char **in = (char **) PyCapsule_GetPointer(obj, NULL);
    if (in == NULL)
        return;
    size_t *size = (size_t *) PyCapsule_GetContext(obj);
    if (size == NULL)
        return;
    for (size_t i=0; i < *size; ++i) {
        if (in[i] == NULL)
            continue;
        free(in[i]);
    }
    free(in);
    free(size);
}

// helper get_from_object_charptr
// Convert obj into an array of char * (i.e. char **).
static int SHROUD_get_from_object_charptr(PyObject *obj,
    POI_SHROUD_converter_value *value)
{
    PyObject *seq = PySequence_Fast(obj, "holder");
    if (seq == NULL) {
        PyErr_Format(PyExc_TypeError, "argument '%s' must be iterable",
            value->name);
        return -1;
    }
    Py_ssize_t size = PySequence_Fast_GET_SIZE(seq);
    char **in = (char **) calloc(size, sizeof(char *));
    PyObject *dataobj = PyCapsule_New(in, NULL, FREE_get_from_object_charptr);
    size_t *size_context = (size_t *) malloc(sizeof(size_t));
    *size_context = size;
    int ierr = PyCapsule_SetContext(dataobj, size_context);
    // XXX - check error
    POI_SHROUD_converter_value itemvalue = {NULL, NULL, NULL, NULL, 0};
    for (Py_ssize_t i = 0; i < size; i++) {
        PyObject *item = PySequence_Fast_GET_ITEM(seq, i);
        ierr = SHROUD_get_from_object_char(item, &itemvalue);
        if (ierr == 0) {
            Py_XDECREF(itemvalue.dataobj);
            Py_DECREF(dataobj);
            Py_DECREF(seq);
            PyErr_Format(PyExc_TypeError,
                "argument '%s', index %d must be string", value->name,
                (int) i);
            return 0;
        }
        if (itemvalue.data != NULL) {
            in[i] = strdup((char *) itemvalue.data);
        }
        Py_XDECREF(itemvalue.dataobj);
    }
    Py_DECREF(seq);

    value->obj = NULL;
    value->dataobj = dataobj;
    value->data = in;
    value->size = size;
    return 1;
}

// helper py_capsule_dtor
// Release memory in PyCapsule.
// Used with native arrays.
static void FREE_py_capsule_dtor(PyObject *obj)
{
    void *in = PyCapsule_GetPointer(obj, NULL);
    if (in != NULL) {
        free(in);
    }
}

// helper get_from_object_double_list
// Convert list of PyObject to array of double.
// Return 0 on error, 1 on success.
// Set Python exception on error.
static int SHROUD_get_from_object_double_list(PyObject *obj,
    POI_SHROUD_converter_value *value)
{
    PyObject *seq = PySequence_Fast(obj, "holder");
    if (seq == NULL) {
        PyErr_Format(PyExc_TypeError, "argument '%s' must be iterable",
            value->name);
        return 0;
    }
    Py_ssize_t size = PySequence_Fast_GET_SIZE(seq);
    double *in = (double *) malloc(size * sizeof(double));
    for (Py_ssize_t i = 0; i < size; i++) {
        PyObject *item = PySequence_Fast_GET_ITEM(seq, i);
        double cvalue = PyFloat_AsDouble(item);
        if (PyErr_Occurred()) {
            free(in);
            Py_DECREF(seq);
            PyErr_Format(PyExc_TypeError,
                "argument '%s', index %d must be double", value->name,
                (int) i);
            return 0;
        }
        in[i] = cvalue;
    }
    Py_DECREF(seq);

    value->obj = NULL;  // Do not save list object.
    value->dataobj = PyCapsule_New(in, NULL, FREE_py_capsule_dtor);
    value->data = (double *) in;
    value->size = size;
    return 1;
}

// helper get_from_object_int_list
// Convert list of PyObject to array of int.
// Return 0 on error, 1 on success.
// Set Python exception on error.
static int SHROUD_get_from_object_int_list(PyObject *obj,
    POI_SHROUD_converter_value *value)
{
    PyObject *seq = PySequence_Fast(obj, "holder");
    if (seq == NULL) {
        PyErr_Format(PyExc_TypeError, "argument '%s' must be iterable",
            value->name);
        return 0;
    }
    Py_ssize_t size = PySequence_Fast_GET_SIZE(seq);
    int *in = (int *) malloc(size * sizeof(int));
    for (Py_ssize_t i = 0; i < size; i++) {
        PyObject *item = PySequence_Fast_GET_ITEM(seq, i);
        int cvalue = PyInt_AsLong(item);
        if (PyErr_Occurred()) {
            free(in);
            Py_DECREF(seq);
            PyErr_Format(PyExc_TypeError,
                "argument '%s', index %d must be int", value->name,
                (int) i);
            return 0;
        }
        in[i] = cvalue;
    }
    Py_DECREF(seq);

    value->obj = NULL;  // Do not save list object.
    value->dataobj = PyCapsule_New(in, NULL, FREE_py_capsule_dtor);
    value->data = (int *) in;
    value->size = size;
    return 1;
}

// helper to_PyList_double
// Convert double pointer to PyList of PyObjects.
static PyObject *SHROUD_to_PyList_double(const double *in, size_t size)
{
    PyObject *out = PyList_New(size);
    for (size_t i = 0; i < size; ++i) {
        PyList_SET_ITEM(out, i, PyFloat_FromDouble(in[i]));
    }
    return out;
}

// helper to_PyList_int
// Convert int pointer to PyList of PyObjects.
static PyObject *SHROUD_to_PyList_int(const int *in, size_t size)
{
    PyObject *out = PyList_New(size);
    for (size_t i = 0; i < size; ++i) {
        PyList_SET_ITEM(out, i, PyInt_FromLong(in[i]));
    }
    return out;
}

// splicer begin C_definition
// splicer end C_definition
PyObject *PY_error_obj;

// splicer begin additional_functions
// splicer end additional_functions

// ----------------------------------------
// Function:  void intargs_in
// Statement: py_subroutine
// ----------------------------------------
// Argument:  const int *arg
// Statement: py_in_native*
static char PY_intargs_in__doc__[] =
"documentation"
;

static PyObject *
PY_intargs_in(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.intargs_in
    int arg;
    char *SHT_kwlist[] = {
        "arg",
        NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "i:intargs_in",
        SHT_kwlist, &arg))
        return NULL;

    intargs_in(&arg);
    Py_RETURN_NONE;
// splicer end function.intargs_in
}

// ----------------------------------------
// Function:  void intargs_inout
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int *arg
// Statement: py_inout_native*
static char PY_intargs_inout__doc__[] =
"documentation"
;

/**
 * Argument is modified by library, defaults to intent(inout).
 */
static PyObject *
PY_intargs_inout(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.intargs_inout
    int arg;
    char *SHT_kwlist[] = {
        "arg",
        NULL };
    PyObject * SHPy_arg = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "i:intargs_inout",
        SHT_kwlist, &arg))
        return NULL;

    intargs_inout(&arg);

    // post_call
    SHPy_arg = PyInt_FromLong(arg);

    return (PyObject *) SHPy_arg;
// splicer end function.intargs_inout
}

// ----------------------------------------
// Function:  void intargs_out
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int *arg +intent(out)
// Statement: py_out_native*
static char PY_intargs_out__doc__[] =
"documentation"
;

static PyObject *
PY_intargs_out(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.intargs_out
    int arg;
    PyObject * SHPy_arg = NULL;

    intargs_out(&arg);

    // post_call
    SHPy_arg = PyInt_FromLong(arg);

    return (PyObject *) SHPy_arg;
// splicer end function.intargs_out
}

// ----------------------------------------
// Function:  void intargs
// Statement: py_subroutine
// ----------------------------------------
// Argument:  const int argin +intent(in)
// Statement: py_in_native
// ----------------------------------------
// Argument:  int *arginout +intent(inout)
// Statement: py_inout_native*
// ----------------------------------------
// Argument:  int *argout +intent(out)
// Statement: py_out_native*
static char PY_intargs__doc__[] =
"documentation"
;

static PyObject *
PY_intargs(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.intargs
    int argin;
    int arginout;
    int argout;
    char *SHT_kwlist[] = {
        "argin",
        "arginout",
        NULL };
    PyObject *SHTPy_rv = NULL;  // return value object

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "ii:intargs",
        SHT_kwlist, &argin, &arginout))
        return NULL;

    intargs(argin, &arginout, &argout);

    // post_call
    SHTPy_rv = Py_BuildValue("ii", arginout, argout);

    return SHTPy_rv;
// splicer end function.intargs
}

// ----------------------------------------
// Function:  void cos_doubles
// Statement: py_subroutine
// ----------------------------------------
// Argument:  double *in +intent(in)+rank(1)
// Statement: py_in_native*_list
// ----------------------------------------
// Argument:  double *out +dimension(size(in))+intent(out)
// Statement: py_out_native*_list
// ----------------------------------------
// Argument:  int sizein +implied(size(in))
// Statement: py_implied_native
static char PY_cos_doubles__doc__[] =
"documentation"
;

/**
 * \brief compute cos of IN and save in OUT
 *
 * allocate OUT same type as IN implied size of array
 */
static PyObject *
PY_cos_doubles(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.cos_doubles
    double * in = NULL;
    PyObject *SHTPy_in = NULL;
    POI_SHROUD_converter_value SHValue_in = {NULL, NULL, NULL, NULL, 0};
    SHValue_in.name = "in";
    Py_ssize_t SHSize_in;
    double * out = NULL;
    PyObject *SHPy_out = NULL;
    int sizein;
    char *SHT_kwlist[] = {
        "in",
        NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "O:cos_doubles",
        SHT_kwlist, &SHTPy_in))
        return NULL;

    // post_parse
    if (SHROUD_get_from_object_double_list(SHTPy_in, &SHValue_in) == 0)
        goto fail;
    in = (double *) SHValue_in.data;
    SHSize_in = SHValue_in.size;

    // pre_call
    out = malloc(sizeof(double) * (SHSize_in));
    if (out == NULL) {
        PyErr_NoMemory();
        goto fail;
    }
    sizein = SHSize_in;

    cos_doubles(in, out, sizein);

    // post_call
    SHPy_out = SHROUD_to_PyList_double(out, SHSize_in);
    if (SHPy_out == NULL) goto fail;

    // cleanup
    Py_XDECREF(SHValue_in.dataobj);
    free(out);
    out = NULL;

    return (PyObject *) SHPy_out;

fail:
    Py_XDECREF(SHValue_in.dataobj);
    Py_XDECREF(SHPy_out);
    if (out != NULL) free(out);
    return NULL;
// splicer end function.cos_doubles
}

// ----------------------------------------
// Function:  void truncate_to_int
// Statement: py_subroutine
// ----------------------------------------
// Argument:  double *in +intent(in)+rank(1)
// Statement: py_in_native*_list
// ----------------------------------------
// Argument:  int *out +dimension(size(in))+intent(out)
// Statement: py_out_native*_list
// ----------------------------------------
// Argument:  int sizein +implied(size(in))
// Statement: py_implied_native
static char PY_truncate_to_int__doc__[] =
"documentation"
;

/**
 * \brief truncate IN argument and save in OUT
 *
 * allocate OUT different type as IN
 * implied size of array
 */
static PyObject *
PY_truncate_to_int(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.truncate_to_int
    double * in = NULL;
    PyObject *SHTPy_in = NULL;
    POI_SHROUD_converter_value SHValue_in = {NULL, NULL, NULL, NULL, 0};
    SHValue_in.name = "in";
    Py_ssize_t SHSize_in;
    int * out = NULL;
    PyObject *SHPy_out = NULL;
    int sizein;
    char *SHT_kwlist[] = {
        "in",
        NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "O:truncate_to_int",
        SHT_kwlist, &SHTPy_in))
        return NULL;

    // post_parse
    if (SHROUD_get_from_object_double_list(SHTPy_in, &SHValue_in) == 0)
        goto fail;
    in = (double *) SHValue_in.data;
    SHSize_in = SHValue_in.size;

    // pre_call
    out = malloc(sizeof(int) * (SHSize_in));
    if (out == NULL) {
        PyErr_NoMemory();
        goto fail;
    }
    sizein = SHSize_in;

    truncate_to_int(in, out, sizein);

    // post_call
    SHPy_out = SHROUD_to_PyList_int(out, SHSize_in);
    if (SHPy_out == NULL) goto fail;

    // cleanup
    Py_XDECREF(SHValue_in.dataobj);
    free(out);
    out = NULL;

    return (PyObject *) SHPy_out;

fail:
    Py_XDECREF(SHValue_in.dataobj);
    Py_XDECREF(SHPy_out);
    if (out != NULL) free(out);
    return NULL;
// splicer end function.truncate_to_int
}

// ----------------------------------------
// Function:  void get_values
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int *nvalues +intent(OUT)
// Statement: py_out_native*
// ----------------------------------------
// Argument:  int *values +dimension(3)+intent(out)
// Statement: py_out_native*_list
static char PY_get_values__doc__[] =
"documentation"
;

/**
 * \brief fill values into array
 *
 * The function knows how long the array must be.
 * Fortran will treat the dimension as assumed-length.
 * The Python wrapper will create a NumPy array or list so it must
 * have an explicit dimension (not assumed-length).
 */
static PyObject *
PY_get_values(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.get_values
    int nvalues;
    int * values = NULL;
    PyObject *SHPy_values = NULL;
    PyObject *SHTPy_rv = NULL;  // return value object

    // pre_call
    values = malloc(sizeof(int) * (3));
    if (values == NULL) {
        PyErr_NoMemory();
        goto fail;
    }

    get_values(&nvalues, values);

    // post_call
    SHPy_values = SHROUD_to_PyList_int(values, 3);
    if (SHPy_values == NULL) goto fail;
    SHTPy_rv = Py_BuildValue("iN", nvalues, SHPy_values);

    // cleanup
    free(values);
    values = NULL;

    return SHTPy_rv;

fail:
    Py_XDECREF(SHPy_values);
    if (values != NULL) free(values);
    return NULL;
// splicer end function.get_values
}

// ----------------------------------------
// Function:  void get_values2
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int *arg1 +dimension(3)+intent(out)
// Statement: py_out_native*_list
// ----------------------------------------
// Argument:  int *arg2 +dimension(3)+intent(out)
// Statement: py_out_native*_list
static char PY_get_values2__doc__[] =
"documentation"
;

/**
 * \brief fill values into two arrays
 *
 * Test two intent(out) arguments.
 * Make sure error handling works with C++.
 */
static PyObject *
PY_get_values2(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.get_values2
    int * arg1 = NULL;
    PyObject *SHPy_arg1 = NULL;
    int * arg2 = NULL;
    PyObject *SHPy_arg2 = NULL;
    PyObject *SHTPy_rv = NULL;  // return value object

    // pre_call
    arg1 = malloc(sizeof(int) * (3));
    if (arg1 == NULL) {
        PyErr_NoMemory();
        goto fail;
    }
    arg2 = malloc(sizeof(int) * (3));
    if (arg2 == NULL) {
        PyErr_NoMemory();
        goto fail;
    }

    get_values2(arg1, arg2);

    // post_call
    SHPy_arg1 = SHROUD_to_PyList_int(arg1, 3);
    if (SHPy_arg1 == NULL) goto fail;
    SHPy_arg2 = SHROUD_to_PyList_int(arg2, 3);
    if (SHPy_arg2 == NULL) goto fail;
    SHTPy_rv = Py_BuildValue("NN", SHPy_arg1, SHPy_arg2);

    // cleanup
    free(arg1);
    arg1 = NULL;
    free(arg2);
    arg2 = NULL;

    return SHTPy_rv;

fail:
    Py_XDECREF(SHPy_arg1);
    if (arg1 != NULL) free(arg1);
    Py_XDECREF(SHPy_arg2);
    if (arg2 != NULL) free(arg2);
    return NULL;
// splicer end function.get_values2
}

// ----------------------------------------
// Function:  void iota_dimension
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int nvar
// Statement: py_in_native
// ----------------------------------------
// Argument:  int *values +dimension(nvar)+intent(out)
// Statement: py_out_native*_list
static char PY_iota_dimension__doc__[] =
"documentation"
;

static PyObject *
PY_iota_dimension(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.iota_dimension
    int nvar;
    int * values = NULL;
    PyObject *SHPy_values = NULL;
    char *SHT_kwlist[] = {
        "nvar",
        NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "i:iota_dimension",
        SHT_kwlist, &nvar))
        return NULL;

    // pre_call
    values = malloc(sizeof(int) * (nvar));
    if (values == NULL) {
        PyErr_NoMemory();
        goto fail;
    }

    iota_dimension(nvar, values);

    // post_call
    SHPy_values = SHROUD_to_PyList_int(values, nvar);
    if (SHPy_values == NULL) goto fail;

    // cleanup
    free(values);
    values = NULL;

    return (PyObject *) SHPy_values;

fail:
    Py_XDECREF(SHPy_values);
    if (values != NULL) free(values);
    return NULL;
// splicer end function.iota_dimension
}

// ----------------------------------------
// Function:  void Sum
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int len +implied(size(values))
// Statement: py_implied_native
// ----------------------------------------
// Argument:  const int *values +rank(1)
// Statement: py_in_native*_list
// ----------------------------------------
// Argument:  int *result +intent(out)
// Statement: py_out_native*
static char PY_Sum__doc__[] =
"documentation"
;

static PyObject *
PY_Sum(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.Sum
    int len;
    int * values = NULL;
    PyObject *SHTPy_values = NULL;
    POI_SHROUD_converter_value SHValue_values = {NULL, NULL, NULL, NULL, 0};
    SHValue_values.name = "values";
    Py_ssize_t SHSize_values;
    int result;
    char *SHT_kwlist[] = {
        "values",
        NULL };
    PyObject * SHPy_result = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "O:Sum", SHT_kwlist, 
        &SHTPy_values))
        return NULL;

    // post_parse
    if (SHROUD_get_from_object_int_list
        (SHTPy_values, &SHValue_values) == 0)
        goto fail;
    values = (int *) SHValue_values.data;
    SHSize_values = SHValue_values.size;

    // pre_call
    len = SHSize_values;

    Sum(len, values, &result);

    // post_call
    SHPy_result = PyInt_FromLong(result);

    // cleanup
    Py_XDECREF(SHValue_values.dataobj);

    return (PyObject *) SHPy_result;

fail:
    Py_XDECREF(SHValue_values.dataobj);
    return NULL;
// splicer end function.Sum
}

// ----------------------------------------
// Function:  void fillIntArray
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int *out +dimension(3)+intent(out)
// Statement: py_out_native*_list
static char PY_fillIntArray__doc__[] =
"documentation"
;

/**
 * Return three values into memory the user provides.
 */
static PyObject *
PY_fillIntArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.fillIntArray
    int * out = NULL;
    PyObject *SHPy_out = NULL;

    // pre_call
    out = malloc(sizeof(int) * (3));
    if (out == NULL) {
        PyErr_NoMemory();
        goto fail;
    }

    fillIntArray(out);

    // post_call
    SHPy_out = SHROUD_to_PyList_int(out, 3);
    if (SHPy_out == NULL) goto fail;

    // cleanup
    free(out);
    out = NULL;

    return (PyObject *) SHPy_out;

fail:
    Py_XDECREF(SHPy_out);
    if (out != NULL) free(out);
    return NULL;
// splicer end function.fillIntArray
}

// ----------------------------------------
// Function:  void incrementIntArray
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int *array +intent(inout)+rank(1)
// Statement: py_inout_native*_list
// ----------------------------------------
// Argument:  int sizein +implied(size(array))
// Statement: py_implied_native
static char PY_incrementIntArray__doc__[] =
"documentation"
;

/**
 * Increment array in place using intent(INOUT).
 */
static PyObject *
PY_incrementIntArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.incrementIntArray
    int * array = NULL;
    PyObject *SHPy_array;
    PyObject *SHTPy_array = NULL;
    POI_SHROUD_converter_value SHValue_array = {NULL, NULL, NULL, NULL, 0};
    SHValue_array.name = "array";
    Py_ssize_t SHSize_array;
    int sizein;
    char *SHT_kwlist[] = {
        "array",
        NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "O:incrementIntArray",
        SHT_kwlist, &SHTPy_array))
        return NULL;

    // post_parse
    if (SHROUD_get_from_object_int_list
        (SHTPy_array, &SHValue_array) == 0)
        goto fail;
    array = (int *) SHValue_array.data;
    SHSize_array = SHValue_array.size;

    // pre_call
    sizein = SHSize_array;

    incrementIntArray(array, sizein);

    // post_call
    SHPy_array = SHROUD_to_PyList_int(array, SHSize_array);
    if (SHPy_array == NULL) goto fail;

    // cleanup
    Py_XDECREF(SHValue_array.dataobj);

    return (PyObject *) SHPy_array;

fail:
    Py_XDECREF(SHValue_array.dataobj);
    return NULL;
// splicer end function.incrementIntArray
}

// ----------------------------------------
// Function:  void fill_with_zeros
// Statement: py_subroutine
// ----------------------------------------
// Argument:  double *x +rank(1)
// Statement: py_inout_native*_list
// ----------------------------------------
// Argument:  int x_length +implied(size(x))
// Statement: py_implied_native
static char PY_fill_with_zeros__doc__[] =
"documentation"
;

static PyObject *
PY_fill_with_zeros(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.fill_with_zeros
    double * x = NULL;
    PyObject *SHPy_x;
    PyObject *SHTPy_x = NULL;
    POI_SHROUD_converter_value SHValue_x = {NULL, NULL, NULL, NULL, 0};
    SHValue_x.name = "x";
    Py_ssize_t SHSize_x;
    int x_length;
    char *SHT_kwlist[] = {
        "x",
        NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "O:fill_with_zeros",
        SHT_kwlist, &SHTPy_x))
        return NULL;

    // post_parse
    if (SHROUD_get_from_object_double_list(SHTPy_x, &SHValue_x) == 0)
        goto fail;
    x = (double *) SHValue_x.data;
    SHSize_x = SHValue_x.size;

    // pre_call
    x_length = SHSize_x;

    fill_with_zeros(x, x_length);

    // post_call
    SHPy_x = SHROUD_to_PyList_double(x, SHSize_x);
    if (SHPy_x == NULL) goto fail;

    // cleanup
    Py_XDECREF(SHValue_x.dataobj);

    return (PyObject *) SHPy_x;

fail:
    Py_XDECREF(SHValue_x.dataobj);
    return NULL;
// splicer end function.fill_with_zeros
}

// ----------------------------------------
// Function:  int accumulate
// Statement: py_function_native
// ----------------------------------------
// Argument:  const int *arr +rank(1)
// Statement: py_in_native*_list
// ----------------------------------------
// Argument:  size_t len +implied(size(arr))
// Statement: py_implied_native
static char PY_accumulate__doc__[] =
"documentation"
;

static PyObject *
PY_accumulate(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.accumulate
    int * arr = NULL;
    PyObject *SHTPy_arr = NULL;
    POI_SHROUD_converter_value SHValue_arr = {NULL, NULL, NULL, NULL, 0};
    SHValue_arr.name = "arr";
    Py_ssize_t SHSize_arr;
    size_t len;
    char *SHT_kwlist[] = {
        "arr",
        NULL };
    int SHCXX_rv;
    PyObject * SHTPy_rv = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "O:accumulate",
        SHT_kwlist, &SHTPy_arr))
        return NULL;

    // post_parse
    if (SHROUD_get_from_object_int_list(SHTPy_arr, &SHValue_arr) == 0)
        goto fail;
    arr = (int *) SHValue_arr.data;
    SHSize_arr = SHValue_arr.size;

    // pre_call
    len = SHSize_arr;

    SHCXX_rv = accumulate(arr, len);

    // post_call
    SHTPy_rv = PyInt_FromLong(SHCXX_rv);

    // cleanup
    Py_XDECREF(SHValue_arr.dataobj);

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHValue_arr.dataobj);
    return NULL;
// splicer end function.accumulate
}

// ----------------------------------------
// Function:  int acceptCharArrayIn
// Statement: py_function_native
// ----------------------------------------
// Argument:  char **names +intent(in)
// Statement: py_in_char**
static char PY_acceptCharArrayIn__doc__[] =
"documentation"
;

/**
 * Return strlen of the first index as a check.
 */
static PyObject *
PY_acceptCharArrayIn(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.acceptCharArrayIn
    char ** names = NULL;
    PyObject * SHTPy_names;
    POI_SHROUD_converter_value SHValue_names = {NULL, NULL, NULL, NULL, 0};
    SHValue_names.name = "names";
    Py_ssize_t SHSize_names;
    char *SHT_kwlist[] = {
        "names",
        NULL };
    int SHCXX_rv;
    PyObject * SHTPy_rv = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "O:acceptCharArrayIn",
        SHT_kwlist, &SHTPy_names))
        return NULL;

    // pre_call
    if (SHROUD_get_from_object_charptr
        (SHTPy_names, &SHValue_names) == 0)
        goto fail;
    names = (char **) SHValue_names.data;

    SHCXX_rv = acceptCharArrayIn(names);

    // post_call
    Py_XDECREF(SHValue_names.dataobj);
    SHTPy_rv = PyInt_FromLong(SHCXX_rv);

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHValue_names.dataobj);
    return NULL;
// splicer end function.acceptCharArrayIn
}

// ----------------------------------------
// Function:  void setGlobalInt
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int value
// Statement: py_in_native
static char PY_setGlobalInt__doc__[] =
"documentation"
;

static PyObject *
PY_setGlobalInt(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.setGlobalInt
    int value;
    char *SHT_kwlist[] = {
        "value",
        NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "i:setGlobalInt",
        SHT_kwlist, &value))
        return NULL;

    setGlobalInt(value);
    Py_RETURN_NONE;
// splicer end function.setGlobalInt
}

// ----------------------------------------
// Function:  int sumFixedArray
// Statement: py_function_native
static char PY_sumFixedArray__doc__[] =
"documentation"
;

/**
 * Used to test values global_array.
 */
static PyObject *
PY_sumFixedArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.sumFixedArray
    PyObject * SHTPy_rv = NULL;

    int SHCXX_rv = sumFixedArray();

    // post_call
    SHTPy_rv = PyInt_FromLong(SHCXX_rv);

    return (PyObject *) SHTPy_rv;
// splicer end function.sumFixedArray
}

// ----------------------------------------
// Function:  void getPtrToFixedArray
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(10)+intent(out)
// Statement: py_out_native**_list
static char PY_getPtrToFixedArray__doc__[] =
"documentation"
;

/**
 * Return a Fortran pointer to an array which is always the same length.
 */
static PyObject *
PY_getPtrToFixedArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.getPtrToFixedArray
    int *count;
    PyObject *SHPy_count = NULL;

    getPtrToFixedArray(&count);

    // post_call
    SHPy_count = SHROUD_to_PyList_int(count, 10);
    if (SHPy_count == NULL) goto fail;

    return (PyObject *) SHPy_count;

fail:
    Py_XDECREF(SHPy_count);
    return NULL;
// splicer end function.getPtrToFixedArray
}

// ----------------------------------------
// Function:  void getPtrToDynamicArray
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(ncount)+intent(out)
// Statement: py_out_native**_list
// ----------------------------------------
// Argument:  int *ncount +hidden+intent(out)
// Statement: py_out_native*
static char PY_getPtrToDynamicArray__doc__[] =
"documentation"
;

/**
 * Return a Fortran pointer to an array which is the length of
 * the argument ncount.
 */
static PyObject *
PY_getPtrToDynamicArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.getPtrToDynamicArray
    int *count;
    PyObject *SHPy_count = NULL;
    int ncount;

    getPtrToDynamicArray(&count, &ncount);

    // post_call
    SHPy_count = SHROUD_to_PyList_int(count, ncount);
    if (SHPy_count == NULL) goto fail;

    return (PyObject *) SHPy_count;

fail:
    Py_XDECREF(SHPy_count);
    return NULL;
// splicer end function.getPtrToDynamicArray
}

// ----------------------------------------
// Function:  void getPtrToFuncArray
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(getLen())+intent(out)
// Statement: py_out_native**_list
static char PY_getPtrToFuncArray__doc__[] =
"documentation"
;

/**
 * Return a Fortran pointer to an array which is the length
 * is computed by C++ function getLen.
 * getLen will be called from C/C++ to compute the shape.
 */
static PyObject *
PY_getPtrToFuncArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.getPtrToFuncArray
    int *count;
    PyObject *SHPy_count = NULL;

    getPtrToFuncArray(&count);

    // post_call
    SHPy_count = SHROUD_to_PyList_int(count, getLen());
    if (SHPy_count == NULL) goto fail;

    return (PyObject *) SHPy_count;

fail:
    Py_XDECREF(SHPy_count);
    return NULL;
// splicer end function.getPtrToFuncArray
}

// ----------------------------------------
// Function:  void getPtrToFixedConstArray
// Statement: py_subroutine
// ----------------------------------------
// Argument:  const int **count +dimension(10)+intent(out)
// Statement: py_out_native**_list
static char PY_getPtrToFixedConstArray__doc__[] =
"documentation"
;

static PyObject *
PY_getPtrToFixedConstArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.getPtrToFixedConstArray
    const int *count;
    PyObject *SHPy_count = NULL;

    getPtrToFixedConstArray(&count);

    // post_call
    SHPy_count = SHROUD_to_PyList_int(count, 10);
    if (SHPy_count == NULL) goto fail;

    return (PyObject *) SHPy_count;

fail:
    Py_XDECREF(SHPy_count);
    return NULL;
// splicer end function.getPtrToFixedConstArray
}

// ----------------------------------------
// Function:  void getPtrToDynamicConstArray
// Statement: py_subroutine
// ----------------------------------------
// Argument:  const int **count +dimension(ncount)+intent(out)
// Statement: py_out_native**_list
// ----------------------------------------
// Argument:  int *ncount +hidden+intent(out)
// Statement: py_out_native*
static char PY_getPtrToDynamicConstArray__doc__[] =
"documentation"
;

static PyObject *
PY_getPtrToDynamicConstArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.getPtrToDynamicConstArray
    const int *count;
    PyObject *SHPy_count = NULL;
    int ncount;

    getPtrToDynamicConstArray(&count, &ncount);

    // post_call
    SHPy_count = SHROUD_to_PyList_int(count, ncount);
    if (SHPy_count == NULL) goto fail;

    return (PyObject *) SHPy_count;

fail:
    Py_XDECREF(SHPy_count);
    return NULL;
// splicer end function.getPtrToDynamicConstArray
}

// ----------------------------------------
// Function:  void getRawPtrToScalar
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int **nitems +deref(raw)+intent(out)
// Statement: py_out_native**_raw
static char PY_getRawPtrToScalar__doc__[] =
"documentation"
;

/**
 * Called directly via an interface in Fortran.
 */
static PyObject *
PY_getRawPtrToScalar(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.getRawPtrToScalar
    int *nitems;
    PyObject *SHPy_nitems = NULL;

    getRawPtrToScalar(&nitems);

    // post_call
    SHPy_nitems = PyCapsule_New(nitems, NULL, NULL);

    return (PyObject *) SHPy_nitems;
// splicer end function.getRawPtrToScalar
}

// ----------------------------------------
// Function:  void getRawPtrToFixedArray
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int **count +deref(raw)+intent(out)
// Statement: py_out_native**_raw
static char PY_getRawPtrToFixedArray__doc__[] =
"documentation"
;

/**
 * Return a type(C_PTR) to an array which is always the same length.
 * Called directly via an interface in Fortran.
 * # Uses +deref(raw) instead of +dimension(10) like getPtrToFixedArray.
 */
static PyObject *
PY_getRawPtrToFixedArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.getRawPtrToFixedArray
    int *count;
    PyObject *SHPy_count = NULL;

    getRawPtrToFixedArray(&count);

    // post_call
    SHPy_count = PyCapsule_New(count, NULL, NULL);

    return (PyObject *) SHPy_count;
// splicer end function.getRawPtrToFixedArray
}

// ----------------------------------------
// Function:  void *returnAddress1
// Statement: py_function_void*
// ----------------------------------------
// Argument:  int flag
// Statement: py_in_native
static char PY_returnAddress1__doc__[] =
"documentation"
;

static PyObject *
PY_returnAddress1(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.returnAddress1
    int flag;
    char *SHT_kwlist[] = {
        "flag",
        NULL };
    PyObject * SHTPy_rv = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "i:returnAddress1",
        SHT_kwlist, &flag))
        return NULL;

    void *SHCXX_rv = returnAddress1(flag);

    // post_call
    SHTPy_rv = PyCapsule_New(SHCXX_rv, NULL, NULL);

    return (PyObject *) SHTPy_rv;
// splicer end function.returnAddress1
}

// ----------------------------------------
// Function:  void *returnAddress2
// Statement: py_function_void*
// ----------------------------------------
// Argument:  int flag
// Statement: py_in_native
static char PY_returnAddress2__doc__[] =
"documentation"
;

static PyObject *
PY_returnAddress2(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.returnAddress2
    int flag;
    char *SHT_kwlist[] = {
        "flag",
        NULL };
    PyObject * SHTPy_rv = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "i:returnAddress2",
        SHT_kwlist, &flag))
        return NULL;

    void *SHCXX_rv = returnAddress2(flag);

    // post_call
    SHTPy_rv = PyCapsule_New(SHCXX_rv, NULL, NULL);

    return (PyObject *) SHTPy_rv;
// splicer end function.returnAddress2
}

// ----------------------------------------
// Function:  void fetchVoidPtr
// Statement: py_subroutine
// ----------------------------------------
// Argument:  void **addr +intent(out)
// Statement: py_out_void**
static char PY_fetchVoidPtr__doc__[] =
"documentation"
;

static PyObject *
PY_fetchVoidPtr(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.fetchVoidPtr
    void *addr;
    PyObject * SHPy_addr = NULL;

    fetchVoidPtr(&addr);

    // post_call
    SHPy_addr = PyCapsule_New(addr, NULL, NULL);

    return (PyObject *) SHPy_addr;
// splicer end function.fetchVoidPtr
}

// ----------------------------------------
// Function:  int *returnIntPtrToScalar
// Statement: py_function_native*_list
static char PY_returnIntPtrToScalar__doc__[] =
"documentation"
;

static PyObject *
PY_returnIntPtrToScalar(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.returnIntPtrToScalar
    PyObject *SHTPy_rv = NULL;

    int *SHCXX_rv = returnIntPtrToScalar();

    // post_call
    SHTPy_rv = SHROUD_to_PyList_int(SHCXX_rv, 1);
    if (SHTPy_rv == NULL) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return NULL;
// splicer end function.returnIntPtrToScalar
}

// ----------------------------------------
// Function:  int *returnIntPtrToFixedArray +dimension(10)
// Statement: py_function_native*_list
static char PY_returnIntPtrToFixedArray__doc__[] =
"documentation"
;

static PyObject *
PY_returnIntPtrToFixedArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.returnIntPtrToFixedArray
    PyObject *SHTPy_rv = NULL;

    int *SHCXX_rv = returnIntPtrToFixedArray();

    // post_call
    SHTPy_rv = SHROUD_to_PyList_int(SHCXX_rv, 10);
    if (SHTPy_rv == NULL) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return NULL;
// splicer end function.returnIntPtrToFixedArray
}

// ----------------------------------------
// Function:  const int *returnIntPtrToConstScalar
// Statement: py_function_native*_list
static char PY_returnIntPtrToConstScalar__doc__[] =
"documentation"
;

static PyObject *
PY_returnIntPtrToConstScalar(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.returnIntPtrToConstScalar
    PyObject *SHTPy_rv = NULL;

    const int *SHCXX_rv = returnIntPtrToConstScalar();

    // post_call
    SHTPy_rv = SHROUD_to_PyList_int(SHCXX_rv, 1);
    if (SHTPy_rv == NULL) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return NULL;
// splicer end function.returnIntPtrToConstScalar
}

// ----------------------------------------
// Function:  const int *returnIntPtrToFixedConstArray +dimension(10)
// Statement: py_function_native*_list
static char PY_returnIntPtrToFixedConstArray__doc__[] =
"documentation"
;

static PyObject *
PY_returnIntPtrToFixedConstArray(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.returnIntPtrToFixedConstArray
    PyObject *SHTPy_rv = NULL;

    const int *SHCXX_rv = returnIntPtrToFixedConstArray();

    // post_call
    SHTPy_rv = SHROUD_to_PyList_int(SHCXX_rv, 10);
    if (SHTPy_rv == NULL) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return NULL;
// splicer end function.returnIntPtrToFixedConstArray
}

// ----------------------------------------
// Function:  int *returnIntScalar +deref(scalar)
// Statement: py_function_native*_scalar
static char PY_returnIntScalar__doc__[] =
"documentation"
;

static PyObject *
PY_returnIntScalar(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.returnIntScalar
    PyObject * SHTPy_rv = NULL;

    int *SHCXX_rv = returnIntScalar();

    // post_call
    SHTPy_rv = PyInt_FromLong(*SHCXX_rv);

    return (PyObject *) SHTPy_rv;
// splicer end function.returnIntScalar
}
static PyMethodDef PY_methods[] = {
{"intargs_in", (PyCFunction)PY_intargs_in, METH_VARARGS|METH_KEYWORDS,
    PY_intargs_in__doc__},
{"intargs_inout", (PyCFunction)PY_intargs_inout,
    METH_VARARGS|METH_KEYWORDS, PY_intargs_inout__doc__},
{"intargs_out", (PyCFunction)PY_intargs_out, METH_NOARGS,
    PY_intargs_out__doc__},
{"intargs", (PyCFunction)PY_intargs, METH_VARARGS|METH_KEYWORDS,
    PY_intargs__doc__},
{"cos_doubles", (PyCFunction)PY_cos_doubles, METH_VARARGS|METH_KEYWORDS,
    PY_cos_doubles__doc__},
{"truncate_to_int", (PyCFunction)PY_truncate_to_int,
    METH_VARARGS|METH_KEYWORDS, PY_truncate_to_int__doc__},
{"get_values", (PyCFunction)PY_get_values, METH_NOARGS,
    PY_get_values__doc__},
{"get_values2", (PyCFunction)PY_get_values2, METH_NOARGS,
    PY_get_values2__doc__},
{"iota_dimension", (PyCFunction)PY_iota_dimension,
    METH_VARARGS|METH_KEYWORDS, PY_iota_dimension__doc__},
{"Sum", (PyCFunction)PY_Sum, METH_VARARGS|METH_KEYWORDS, PY_Sum__doc__},
{"fillIntArray", (PyCFunction)PY_fillIntArray, METH_NOARGS,
    PY_fillIntArray__doc__},
{"incrementIntArray", (PyCFunction)PY_incrementIntArray,
    METH_VARARGS|METH_KEYWORDS, PY_incrementIntArray__doc__},
{"fill_with_zeros", (PyCFunction)PY_fill_with_zeros,
    METH_VARARGS|METH_KEYWORDS, PY_fill_with_zeros__doc__},
{"accumulate", (PyCFunction)PY_accumulate, METH_VARARGS|METH_KEYWORDS,
    PY_accumulate__doc__},
{"acceptCharArrayIn", (PyCFunction)PY_acceptCharArrayIn,
    METH_VARARGS|METH_KEYWORDS, PY_acceptCharArrayIn__doc__},
{"setGlobalInt", (PyCFunction)PY_setGlobalInt,
    METH_VARARGS|METH_KEYWORDS, PY_setGlobalInt__doc__},
{"sumFixedArray", (PyCFunction)PY_sumFixedArray, METH_NOARGS,
    PY_sumFixedArray__doc__},
{"getPtrToFixedArray", (PyCFunction)PY_getPtrToFixedArray, METH_NOARGS,
    PY_getPtrToFixedArray__doc__},
{"getPtrToDynamicArray", (PyCFunction)PY_getPtrToDynamicArray,
    METH_NOARGS, PY_getPtrToDynamicArray__doc__},
{"getPtrToFuncArray", (PyCFunction)PY_getPtrToFuncArray, METH_NOARGS,
    PY_getPtrToFuncArray__doc__},
{"getPtrToFixedConstArray", (PyCFunction)PY_getPtrToFixedConstArray,
    METH_NOARGS, PY_getPtrToFixedConstArray__doc__},
{"getPtrToDynamicConstArray", (PyCFunction)PY_getPtrToDynamicConstArray,
    METH_NOARGS, PY_getPtrToDynamicConstArray__doc__},
{"getRawPtrToScalar", (PyCFunction)PY_getRawPtrToScalar, METH_NOARGS,
    PY_getRawPtrToScalar__doc__},
{"getRawPtrToFixedArray", (PyCFunction)PY_getRawPtrToFixedArray,
    METH_NOARGS, PY_getRawPtrToFixedArray__doc__},
{"returnAddress1", (PyCFunction)PY_returnAddress1,
    METH_VARARGS|METH_KEYWORDS, PY_returnAddress1__doc__},
{"returnAddress2", (PyCFunction)PY_returnAddress2,
    METH_VARARGS|METH_KEYWORDS, PY_returnAddress2__doc__},
{"fetchVoidPtr", (PyCFunction)PY_fetchVoidPtr, METH_NOARGS,
    PY_fetchVoidPtr__doc__},
{"returnIntPtrToScalar", (PyCFunction)PY_returnIntPtrToScalar,
    METH_NOARGS, PY_returnIntPtrToScalar__doc__},
{"returnIntPtrToFixedArray", (PyCFunction)PY_returnIntPtrToFixedArray,
    METH_NOARGS, PY_returnIntPtrToFixedArray__doc__},
{"returnIntPtrToConstScalar", (PyCFunction)PY_returnIntPtrToConstScalar,
    METH_NOARGS, PY_returnIntPtrToConstScalar__doc__},
{"returnIntPtrToFixedConstArray",
    (PyCFunction)PY_returnIntPtrToFixedConstArray, METH_NOARGS,
    PY_returnIntPtrToFixedConstArray__doc__},
{"returnIntScalar", (PyCFunction)PY_returnIntScalar, METH_NOARGS,
    PY_returnIntScalar__doc__},
{NULL,   (PyCFunction)NULL, 0, NULL}            /* sentinel */
};

/*
 * initpointers - Initialization function for the module
 * *must* be called initpointers
 */
static char PY__doc__[] =
"library documentation"
;

struct module_state {
    PyObject *error;
};

#if PY_MAJOR_VERSION >= 3
#define GETSTATE(m) ((struct module_state*)PyModule_GetState(m))
#else
#define GETSTATE(m) (&_state)
static struct module_state _state;
#endif

#if PY_MAJOR_VERSION >= 3
static int pointers_traverse(PyObject *m, visitproc visit, void *arg) {
    Py_VISIT(GETSTATE(m)->error);
    return 0;
}

static int pointers_clear(PyObject *m) {
    Py_CLEAR(GETSTATE(m)->error);
    return 0;
}

static struct PyModuleDef moduledef = {
    PyModuleDef_HEAD_INIT,
    "pointers", /* m_name */
    PY__doc__, /* m_doc */
    sizeof(struct module_state), /* m_size */
    PY_methods, /* m_methods */
    NULL, /* m_reload */
    pointers_traverse, /* m_traverse */
    pointers_clear, /* m_clear */
    NULL  /* m_free */
};

#define RETVAL m
#define INITERROR return NULL
#else
#define RETVAL
#define INITERROR return
#endif

PyMODINIT_FUNC
#if PY_MAJOR_VERSION >= 3
PyInit_pointers(void)
#else
initpointers(void)
#endif
{
    PyObject *m = NULL;
    const char * error_name = "pointers.Error";

    // splicer begin C_init_locals
    // splicer end C_init_locals


    /* Create the module and add the functions */
#if PY_MAJOR_VERSION >= 3
    m = PyModule_Create(&moduledef);
#else
    m = Py_InitModule4("pointers", PY_methods,
        PY__doc__,
        (PyObject*)NULL,PYTHON_API_VERSION);
#endif
    if (m == NULL)
        return RETVAL;
    struct module_state *st = GETSTATE(m);

    PY_error_obj = PyErr_NewException((char *) error_name, NULL, NULL);
    if (PY_error_obj == NULL)
        return RETVAL;
    st->error = PY_error_obj;
    PyModule_AddObject(m, "Error", st->error);

    // splicer begin C_init_body
    // splicer end C_init_body

    /* Check for errors */
    if (PyErr_Occurred())
        Py_FatalError("can't initialize module pointers");
    return RETVAL;
}

