// wrappointers.h
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//
/**
 * \file wrappointers.h
 * \brief Shroud generated wrapper for pointers library
 */
// For C users and C++ implementation

#ifndef WRAPPOINTERS_H
#define WRAPPOINTERS_H

// typemap
#ifdef __cplusplus
#include <cstddef>
#else
#include <stddef.h>
#endif
// shroud
#include "typespointers.h"

// splicer begin CXX_declarations
// splicer end CXX_declarations

#ifdef __cplusplus
extern "C" {
#endif

// splicer begin C_declarations
// splicer end C_declarations

void POI_intargs_in_bufferify(const int *arg);

void POI_intargs_inout_bufferify(int *arg);

void POI_intargs_out_bufferify(int *arg);

void POI_intargs_bufferify(const int argin, int *arginout, int *argout);

void POI_cos_doubles_bufferify(double *in, double *out, int sizein);

void POI_truncate_to_int_bufferify(double *in, int *out, int sizein);

void POI_get_values_bufferify(int *nvalues, int *values);

void POI_get_values2_bufferify(int *arg1, int *arg2);

void POI_iota_dimension_bufferify(int nvar, int *values);

void POI_Sum_bufferify(int len, const int *values, int *result);

void POI_fillIntArray_bufferify(int *out);

void POI_incrementIntArray_bufferify(int *array, int sizein);

void POI_fill_with_zeros_bufferify(double *x, int x_length);

int POI_accumulate_bufferify(const int *arr, size_t len);

int POI_acceptCharArrayIn_bufferify(const char *names,
    size_t SHT_names_size, int SHT_names_len);

void POI_setGlobalInt_bufferify(int value);

int POI_sumFixedArray_bufferify(void);

void POI_getPtrToScalar_bufferify(POI_SHROUD_array *SHT_nitems_cdesc);

void POI_getPtrToFixedArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc);

void POI_getPtrToDynamicArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc);

void POI_getPtrToFuncArray_bufferify(POI_SHROUD_array *SHT_count_cdesc);

void POI_getPtrToConstScalar_bufferify(
    POI_SHROUD_array *SHT_nitems_cdesc);

void POI_getPtrToFixedConstArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc);

void POI_getPtrToDynamicConstArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc);

void POI_getRawPtrToScalar_bufferify(int **nitems);

void POI_getRawPtrToScalarForce_bufferify(int **nitems);

void POI_getRawPtrToFixedArray_bufferify(int **count);

void POI_getRawPtrToFixedArrayForce_bufferify(int **count);

void POI_getRawPtrToInt2d_bufferify(int ***arg);

int POI_checkInt2d_bufferify(int **arg);

void POI_DimensionIn_bufferify(const int *arg);

void POI_getAllocToFixedArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc,
    POI_SHROUD_capsule_data *SHT_count_capsule);

void * POI_returnAddress1_bufferify(int flag);

void * POI_returnAddress2_bufferify(int flag);

void POI_fetchVoidPtr_bufferify(void **addr);

void POI_updateVoidPtr_bufferify(void **addr);

int POI_VoidPtrArray_bufferify(void **addr);

int * POI_returnIntPtrToScalar_bufferify(void);

void POI_returnIntPtrToFixedArray_bufferify(
    POI_SHROUD_array *SHT_rv_cdesc);

const int * POI_returnIntPtrToConstScalar_bufferify(void);

void POI_returnIntPtrToFixedConstArray_bufferify(
    POI_SHROUD_array *SHT_rv_cdesc);

int POI_returnIntScalar_bufferify(void);

int * POI_returnIntRaw_bufferify(void);

int * POI_returnIntRawWithArgs_bufferify(const char *name);

int ** POI_returnRawPtrToInt2d_bufferify(void);

void POI_returnIntAllocToFixedArray_bufferify(
    POI_SHROUD_array *SHT_rv_cdesc,
    POI_SHROUD_capsule_data *SHT_rv_capsule);

#ifdef __cplusplus
}
#endif

#endif  // WRAPPOINTERS_H
