// wrappointers.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "pointers.h"
// shroud
#include <cstdlib>
#include <cstring>
#include "wrappointers.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {


// helper char_len_trim
// Returns the length of character string src with length nsrc,
// ignoring any trailing blanks.
static int ShroudCharLenTrim(const char *src, int nsrc) {
    int i;

    for (i = nsrc - 1; i >= 0; i--) {
        if (src[i] != ' ') {
            break;
        }
    }

    return i + 1;
}


// start helper char_array_alloc
// helper char_array_alloc
// Copy src into new memory and null terminate.
// char **src +size(nsrc) +len(len)
// CHARACTER(len) src(nsrc)
static char **ShroudStrArrayAlloc(const char *src, int nsrc, int len)
{
    char **rv = static_cast<char **>
        (std::malloc(sizeof(char *) * nsrc));
    const char *src0 = src;
    for(int i=0; i < nsrc; ++i) {
        int ntrim = ShroudCharLenTrim(src0, len);
        char *tgt = static_cast<char *>(std::malloc(ntrim+1));
        std::memcpy(tgt, src0, ntrim);
        tgt[ntrim] = '\0';
        rv[i] = tgt;
        src0 += len;
    }
    return rv;
}
// end helper char_array_alloc

// helper char_array_free
// Release memory allocated by ShroudStrArrayAlloc
static void ShroudStrArrayFree(char **src, int nsrc)
{
    for(int i=0; i < nsrc; ++i) {
        std::free(src[i]);
    }
    std::free(src);
}

// splicer begin C_definitions
// splicer end C_definitions

// ----------------------------------------
// Function:  void intargs_in
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int *arg
// Statement: f_in_native*
// start POI_intargs_in_bufferify
void POI_intargs_in_bufferify(const int *arg)
{
    // splicer begin function.intargs_in_bufferify
    intargs_in(arg);
    // splicer end function.intargs_in_bufferify
}
// end POI_intargs_in_bufferify

/**
 * Argument is modified by library, defaults to intent(inout).
 */
// ----------------------------------------
// Function:  void intargs_inout
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int *arg
// Statement: f_inout_native*
// start POI_intargs_inout_bufferify
void POI_intargs_inout_bufferify(int *arg)
{
    // splicer begin function.intargs_inout_bufferify
    intargs_inout(arg);
    // splicer end function.intargs_inout_bufferify
}
// end POI_intargs_inout_bufferify

// ----------------------------------------
// Function:  void intargs_out
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int *arg +intent(out)
// Statement: f_out_native*
// start POI_intargs_out_bufferify
void POI_intargs_out_bufferify(int *arg)
{
    // splicer begin function.intargs_out_bufferify
    intargs_out(arg);
    // splicer end function.intargs_out_bufferify
}
// end POI_intargs_out_bufferify

// ----------------------------------------
// Function:  void intargs
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int argin +intent(in)
// Statement: f_in_native
// ----------------------------------------
// Argument:  int *arginout +intent(inout)
// Statement: f_inout_native*
// ----------------------------------------
// Argument:  int *argout +intent(out)
// Statement: f_out_native*
// start POI_intargs_bufferify
void POI_intargs_bufferify(const int argin, int *arginout, int *argout)
{
    // splicer begin function.intargs_bufferify
    intargs(argin, arginout, argout);
    // splicer end function.intargs_bufferify
}
// end POI_intargs_bufferify

/**
 * \brief compute cos of IN and save in OUT
 *
 * allocate OUT same type as IN implied size of array
 */
// ----------------------------------------
// Function:  void cos_doubles
// Statement: f_subroutine
// ----------------------------------------
// Argument:  double *in +intent(in)+rank(1)
// Statement: f_in_native*
// ----------------------------------------
// Argument:  double *out +dimension(size(in))+intent(out)
// Statement: f_out_native*
// ----------------------------------------
// Argument:  int sizein +implied(size(in))
// Statement: f_in_native
// start POI_cos_doubles_bufferify
void POI_cos_doubles_bufferify(double *in, double *out, int sizein)
{
    // splicer begin function.cos_doubles_bufferify
    cos_doubles(in, out, sizein);
    // splicer end function.cos_doubles_bufferify
}
// end POI_cos_doubles_bufferify

/**
 * \brief truncate IN argument and save in OUT
 *
 * allocate OUT different type as IN
 * implied size of array
 */
// ----------------------------------------
// Function:  void truncate_to_int
// Statement: f_subroutine
// ----------------------------------------
// Argument:  double *in +intent(in)+rank(1)
// Statement: f_in_native*
// ----------------------------------------
// Argument:  int *out +dimension(size(in))+intent(out)
// Statement: f_out_native*
// ----------------------------------------
// Argument:  int sizein +implied(size(in))
// Statement: f_in_native
// start POI_truncate_to_int_bufferify
void POI_truncate_to_int_bufferify(double *in, int *out, int sizein)
{
    // splicer begin function.truncate_to_int_bufferify
    truncate_to_int(in, out, sizein);
    // splicer end function.truncate_to_int_bufferify
}
// end POI_truncate_to_int_bufferify

/**
 * \brief fill values into array
 *
 * The function knows how long the array must be.
 * Fortran will treat the dimension as assumed-length.
 * The Python wrapper will create a NumPy array or list so it must
 * have an explicit dimension (not assumed-length).
 */
// ----------------------------------------
// Function:  void get_values
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int *nvalues +intent(OUT)
// Statement: f_out_native*
// ----------------------------------------
// Argument:  int *values +dimension(3)+intent(out)
// Statement: f_out_native*
// start POI_get_values_bufferify
void POI_get_values_bufferify(int *nvalues, int *values)
{
    // splicer begin function.get_values_bufferify
    get_values(nvalues, values);
    // splicer end function.get_values_bufferify
}
// end POI_get_values_bufferify

/**
 * \brief fill values into two arrays
 *
 * Test two intent(out) arguments.
 * Make sure error handling works with C++.
 */
// ----------------------------------------
// Function:  void get_values2
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int *arg1 +dimension(3)+intent(out)
// Statement: f_out_native*
// ----------------------------------------
// Argument:  int *arg2 +dimension(3)+intent(out)
// Statement: f_out_native*
// start POI_get_values2_bufferify
void POI_get_values2_bufferify(int *arg1, int *arg2)
{
    // splicer begin function.get_values2_bufferify
    get_values2(arg1, arg2);
    // splicer end function.get_values2_bufferify
}
// end POI_get_values2_bufferify

// ----------------------------------------
// Function:  void iota_dimension
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int nvar
// Statement: f_in_native
// ----------------------------------------
// Argument:  int *values +dimension(nvar)+intent(out)
// Statement: f_out_native*
// start POI_iota_dimension_bufferify
void POI_iota_dimension_bufferify(int nvar, int *values)
{
    // splicer begin function.iota_dimension_bufferify
    iota_dimension(nvar, values);
    // splicer end function.iota_dimension_bufferify
}
// end POI_iota_dimension_bufferify

// ----------------------------------------
// Function:  void Sum
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int len +implied(size(values))
// Statement: f_in_native
// ----------------------------------------
// Argument:  const int *values +rank(1)
// Statement: f_in_native*
// ----------------------------------------
// Argument:  int *result +intent(out)
// Statement: f_out_native*
// start POI_Sum_bufferify
void POI_Sum_bufferify(int len, const int *values, int *result)
{
    // splicer begin function.Sum_bufferify
    Sum(len, values, result);
    // splicer end function.Sum_bufferify
}
// end POI_Sum_bufferify

/**
 * Return three values into memory the user provides.
 */
// ----------------------------------------
// Function:  void fillIntArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int *out +dimension(3)+intent(out)
// Statement: f_out_native*
// start POI_fillIntArray_bufferify
void POI_fillIntArray_bufferify(int *out)
{
    // splicer begin function.fillIntArray_bufferify
    fillIntArray(out);
    // splicer end function.fillIntArray_bufferify
}
// end POI_fillIntArray_bufferify

/**
 * Increment array in place using intent(INOUT).
 */
// ----------------------------------------
// Function:  void incrementIntArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int *array +intent(inout)+rank(1)
// Statement: f_inout_native*
// ----------------------------------------
// Argument:  int sizein +implied(size(array))
// Statement: f_in_native
// start POI_incrementIntArray_bufferify
void POI_incrementIntArray_bufferify(int *array, int sizein)
{
    // splicer begin function.incrementIntArray_bufferify
    incrementIntArray(array, sizein);
    // splicer end function.incrementIntArray_bufferify
}
// end POI_incrementIntArray_bufferify

// ----------------------------------------
// Function:  void fill_with_zeros
// Statement: f_subroutine
// ----------------------------------------
// Argument:  double *x +rank(1)
// Statement: f_inout_native*
// ----------------------------------------
// Argument:  int x_length +implied(size(x))
// Statement: f_in_native
// start POI_fill_with_zeros_bufferify
void POI_fill_with_zeros_bufferify(double *x, int x_length)
{
    // splicer begin function.fill_with_zeros_bufferify
    fill_with_zeros(x, x_length);
    // splicer end function.fill_with_zeros_bufferify
}
// end POI_fill_with_zeros_bufferify

// ----------------------------------------
// Function:  int accumulate
// Statement: f_function_native
// ----------------------------------------
// Argument:  const int *arr +rank(1)
// Statement: f_in_native*
// ----------------------------------------
// Argument:  size_t len +implied(size(arr))
// Statement: f_in_native
// start POI_accumulate_bufferify
int POI_accumulate_bufferify(const int *arr, size_t len)
{
    // splicer begin function.accumulate_bufferify
    int SHC_rv = accumulate(arr, len);
    return SHC_rv;
    // splicer end function.accumulate_bufferify
}
// end POI_accumulate_bufferify

/**
 * Return strlen of the first index as a check.
 */
// ----------------------------------------
// Function:  int acceptCharArrayIn
// Statement: f_function_native
// ----------------------------------------
// Argument:  char **names +intent(in)
// Statement: f_in_char**_buf
// start POI_acceptCharArrayIn_bufferify
int POI_acceptCharArrayIn_bufferify(const char *names,
    size_t SHT_names_size, int SHT_names_len)
{
    // splicer begin function.acceptCharArrayIn_bufferify
    char **SHC_names_cxx = ShroudStrArrayAlloc(names, SHT_names_size,
        SHT_names_len);
    int SHC_rv = acceptCharArrayIn(SHC_names_cxx);
    ShroudStrArrayFree(SHC_names_cxx, SHT_names_size);
    return SHC_rv;
    // splicer end function.acceptCharArrayIn_bufferify
}
// end POI_acceptCharArrayIn_bufferify

// ----------------------------------------
// Function:  void setGlobalInt
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int value
// Statement: f_in_native
// start POI_setGlobalInt_bufferify
void POI_setGlobalInt_bufferify(int value)
{
    // splicer begin function.setGlobalInt_bufferify
    setGlobalInt(value);
    // splicer end function.setGlobalInt_bufferify
}
// end POI_setGlobalInt_bufferify

/**
 * Used to test values global_array.
 */
// ----------------------------------------
// Function:  int sumFixedArray
// Statement: f_function_native
// start POI_sumFixedArray_bufferify
int POI_sumFixedArray_bufferify(void)
{
    // splicer begin function.sumFixedArray_bufferify
    int SHC_rv = sumFixedArray();
    return SHC_rv;
    // splicer end function.sumFixedArray_bufferify
}
// end POI_sumFixedArray_bufferify

// ----------------------------------------
// Function:  void getPtrToScalar
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **nitems +intent(out)
// Statement: f_out_native**_cdesc_pointer
// start POI_getPtrToScalar_bufferify
void POI_getPtrToScalar_bufferify(POI_SHROUD_array *SHT_nitems_cdesc)
{
    // splicer begin function.getPtrToScalar_bufferify
    int *nitems;
    getPtrToScalar(&nitems);
    SHT_nitems_cdesc->base_addr = nitems;
    SHT_nitems_cdesc->type = SH_TYPE_INT;
    SHT_nitems_cdesc->elem_len = sizeof(int);
    SHT_nitems_cdesc->rank = 0;
    SHT_nitems_cdesc->size = 1;
    // splicer end function.getPtrToScalar_bufferify
}
// end POI_getPtrToScalar_bufferify

/**
 * Return a Fortran pointer to an array which is always the same length.
 */
// ----------------------------------------
// Function:  void getPtrToFixedArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(10)+intent(out)
// Statement: f_out_native**_cdesc_pointer
// start POI_getPtrToFixedArray_bufferify
void POI_getPtrToFixedArray_bufferify(POI_SHROUD_array *SHT_count_cdesc)
{
    // splicer begin function.getPtrToFixedArray_bufferify
    int *count;
    getPtrToFixedArray(&count);
    SHT_count_cdesc->base_addr = count;
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = 10;
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    // splicer end function.getPtrToFixedArray_bufferify
}
// end POI_getPtrToFixedArray_bufferify

/**
 * Return a Fortran pointer to an array which is the length of
 * the argument ncount.
 */
// ----------------------------------------
// Function:  void getPtrToDynamicArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(ncount)+intent(out)
// Statement: f_out_native**_cdesc_pointer
// ----------------------------------------
// Argument:  int *ncount +hidden+intent(out)
// Statement: f_out_native*_hidden
// start POI_getPtrToDynamicArray_bufferify
void POI_getPtrToDynamicArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc)
{
    // splicer begin function.getPtrToDynamicArray_bufferify
    int *count;
    int ncount;
    getPtrToDynamicArray(&count, &ncount);
    SHT_count_cdesc->base_addr = count;
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = ncount;
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    // splicer end function.getPtrToDynamicArray_bufferify
}
// end POI_getPtrToDynamicArray_bufferify

/**
 * Return a Fortran pointer to an array which is the length
 * is computed by C++ function getLen.
 * getLen will be called from C/C++ to compute the shape.
 */
// ----------------------------------------
// Function:  void getPtrToFuncArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(getLen())+intent(out)
// Statement: f_out_native**_cdesc_pointer
// start POI_getPtrToFuncArray_bufferify
void POI_getPtrToFuncArray_bufferify(POI_SHROUD_array *SHT_count_cdesc)
{
    // splicer begin function.getPtrToFuncArray_bufferify
    int *count;
    getPtrToFuncArray(&count);
    SHT_count_cdesc->base_addr = count;
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = getLen();
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    // splicer end function.getPtrToFuncArray_bufferify
}
// end POI_getPtrToFuncArray_bufferify

// ----------------------------------------
// Function:  void getPtrToConstScalar
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int **nitems +intent(out)
// Statement: f_out_native**_cdesc_pointer
// start POI_getPtrToConstScalar_bufferify
void POI_getPtrToConstScalar_bufferify(
    POI_SHROUD_array *SHT_nitems_cdesc)
{
    // splicer begin function.getPtrToConstScalar_bufferify
    const int *nitems;
    getPtrToConstScalar(&nitems);
    SHT_nitems_cdesc->base_addr = const_cast<int *>(nitems);
    SHT_nitems_cdesc->type = SH_TYPE_INT;
    SHT_nitems_cdesc->elem_len = sizeof(int);
    SHT_nitems_cdesc->rank = 0;
    SHT_nitems_cdesc->size = 1;
    // splicer end function.getPtrToConstScalar_bufferify
}
// end POI_getPtrToConstScalar_bufferify

// ----------------------------------------
// Function:  void getPtrToFixedConstArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int **count +dimension(10)+intent(out)
// Statement: f_out_native**_cdesc_pointer
// start POI_getPtrToFixedConstArray_bufferify
void POI_getPtrToFixedConstArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc)
{
    // splicer begin function.getPtrToFixedConstArray_bufferify
    const int *count;
    getPtrToFixedConstArray(&count);
    SHT_count_cdesc->base_addr = const_cast<int *>(count);
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = 10;
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    // splicer end function.getPtrToFixedConstArray_bufferify
}
// end POI_getPtrToFixedConstArray_bufferify

// ----------------------------------------
// Function:  void getPtrToDynamicConstArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int **count +dimension(ncount)+intent(out)
// Statement: f_out_native**_cdesc_pointer
// ----------------------------------------
// Argument:  int *ncount +hidden+intent(out)
// Statement: f_out_native*_hidden
// start POI_getPtrToDynamicConstArray_bufferify
void POI_getPtrToDynamicConstArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc)
{
    // splicer begin function.getPtrToDynamicConstArray_bufferify
    const int *count;
    int ncount;
    getPtrToDynamicConstArray(&count, &ncount);
    SHT_count_cdesc->base_addr = const_cast<int *>(count);
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = ncount;
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    // splicer end function.getPtrToDynamicConstArray_bufferify
}
// end POI_getPtrToDynamicConstArray_bufferify

/**
 * Called directly via an interface in Fortran.
 */
// ----------------------------------------
// Function:  void getRawPtrToScalar
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **nitems +deref(raw)+intent(out)
// Statement: f_out_native**_raw
// start POI_getRawPtrToScalar_bufferify
void POI_getRawPtrToScalar_bufferify(int **nitems)
{
    // splicer begin function.getRawPtrToScalar_bufferify
    getRawPtrToScalar(nitems);
    // splicer end function.getRawPtrToScalar_bufferify
}
// end POI_getRawPtrToScalar_bufferify

/**
 * Create a Fortran wrapper.
 */
// ----------------------------------------
// Function:  void getRawPtrToScalarForce
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **nitems +deref(raw)+intent(out)
// Statement: f_out_native**_raw
// start POI_getRawPtrToScalarForce_bufferify
void POI_getRawPtrToScalarForce_bufferify(int **nitems)
{
    // splicer begin function.getRawPtrToScalarForce_bufferify
    getRawPtrToScalarForce(nitems);
    // splicer end function.getRawPtrToScalarForce_bufferify
}
// end POI_getRawPtrToScalarForce_bufferify

/**
 * Return a type(C_PTR) to an array which is always the same length.
 * Called directly via an interface in Fortran.
 * # Uses +deref(raw) instead of +dimension(10) like getPtrToFixedArray.
 */
// ----------------------------------------
// Function:  void getRawPtrToFixedArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +deref(raw)+intent(out)
// Statement: f_out_native**_raw
// start POI_getRawPtrToFixedArray_bufferify
void POI_getRawPtrToFixedArray_bufferify(int **count)
{
    // splicer begin function.getRawPtrToFixedArray_bufferify
    getRawPtrToFixedArray(count);
    // splicer end function.getRawPtrToFixedArray_bufferify
}
// end POI_getRawPtrToFixedArray_bufferify

/**
 * Return a type(C_PTR) to an array which is always the same length.
 * Create a Fortran wrapper.
 */
// ----------------------------------------
// Function:  void getRawPtrToFixedArrayForce
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +deref(raw)+intent(out)
// Statement: f_out_native**_raw
// start POI_getRawPtrToFixedArrayForce_bufferify
void POI_getRawPtrToFixedArrayForce_bufferify(int **count)
{
    // splicer begin function.getRawPtrToFixedArrayForce_bufferify
    getRawPtrToFixedArrayForce(count);
    // splicer end function.getRawPtrToFixedArrayForce_bufferify
}
// end POI_getRawPtrToFixedArrayForce_bufferify

/**
 * Test multiple layers of indirection.
 */
// ----------------------------------------
// Function:  void getRawPtrToInt2d
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int ***arg +intent(out)
// Statement: f_out_native***
// start POI_getRawPtrToInt2d_bufferify
void POI_getRawPtrToInt2d_bufferify(int ***arg)
{
    // splicer begin function.getRawPtrToInt2d_bufferify
    getRawPtrToInt2d(arg);
    // splicer end function.getRawPtrToInt2d_bufferify
}
// end POI_getRawPtrToInt2d_bufferify

/**
 * Check results of getRawPtrToInt2d.
 */
// ----------------------------------------
// Function:  int checkInt2d
// Statement: f_function_native
// ----------------------------------------
// Argument:  int **arg +intent(in)
// Statement: f_in_native**
// start POI_checkInt2d_bufferify
int POI_checkInt2d_bufferify(int **arg)
{
    // splicer begin function.checkInt2d_bufferify
    int SHC_rv = checkInt2d(arg);
    return SHC_rv;
    // splicer end function.checkInt2d_bufferify
}
// end POI_checkInt2d_bufferify

/**
 * Test +dimension(10,20) +intent(in) together.
 * This will not use assumed-shape in the Fortran wrapper.
 */
// ----------------------------------------
// Function:  void DimensionIn
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int *arg +dimension(10,20)
// Statement: f_in_native*
// start POI_DimensionIn_bufferify
void POI_DimensionIn_bufferify(const int *arg)
{
    // splicer begin function.DimensionIn_bufferify
    DimensionIn(arg);
    // splicer end function.DimensionIn_bufferify
}
// end POI_DimensionIn_bufferify

/**
 * Return a Fortran pointer to an array which is always the same length.
 */
// ----------------------------------------
// Function:  void getAllocToFixedArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +deref(allocatable)+dimension(10)+intent(out)
// Statement: f_out_native**_cdesc_allocatable
// start POI_getAllocToFixedArray_bufferify
void POI_getAllocToFixedArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc,
    POI_SHROUD_capsule_data *SHT_count_capsule)
{
    // splicer begin function.getAllocToFixedArray_bufferify
    int *count;
    getAllocToFixedArray(&count);
    SHT_count_cdesc->base_addr = count;
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = 10;
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    SHT_count_capsule->addr  = count;
    SHT_count_capsule->idtor = 0;
    // splicer end function.getAllocToFixedArray_bufferify
}
// end POI_getAllocToFixedArray_bufferify

// ----------------------------------------
// Function:  void *returnAddress1
// Statement: f_function_void*
// ----------------------------------------
// Argument:  int flag
// Statement: f_in_native
// start POI_returnAddress1_bufferify
void * POI_returnAddress1_bufferify(int flag)
{
    // splicer begin function.returnAddress1_bufferify
    void *SHC_rv = returnAddress1(flag);
    return SHC_rv;
    // splicer end function.returnAddress1_bufferify
}
// end POI_returnAddress1_bufferify

// ----------------------------------------
// Function:  void *returnAddress2
// Statement: f_function_void*
// ----------------------------------------
// Argument:  int flag
// Statement: f_in_native
// start POI_returnAddress2_bufferify
void * POI_returnAddress2_bufferify(int flag)
{
    // splicer begin function.returnAddress2_bufferify
    void *SHC_rv = returnAddress2(flag);
    return SHC_rv;
    // splicer end function.returnAddress2_bufferify
}
// end POI_returnAddress2_bufferify

// ----------------------------------------
// Function:  void fetchVoidPtr
// Statement: f_subroutine
// ----------------------------------------
// Argument:  void **addr +intent(out)
// Statement: f_out_void**
// start POI_fetchVoidPtr_bufferify
void POI_fetchVoidPtr_bufferify(void **addr)
{
    // splicer begin function.fetchVoidPtr_bufferify
    fetchVoidPtr(addr);
    // splicer end function.fetchVoidPtr_bufferify
}
// end POI_fetchVoidPtr_bufferify

// ----------------------------------------
// Function:  void updateVoidPtr
// Statement: f_subroutine
// ----------------------------------------
// Argument:  void **addr +intent(inout)
// Statement: f_inout_void**
// start POI_updateVoidPtr_bufferify
void POI_updateVoidPtr_bufferify(void **addr)
{
    // splicer begin function.updateVoidPtr_bufferify
    updateVoidPtr(addr);
    // splicer end function.updateVoidPtr_bufferify
}
// end POI_updateVoidPtr_bufferify

// ----------------------------------------
// Function:  int VoidPtrArray
// Statement: f_function_native
// ----------------------------------------
// Argument:  void **addr +rank(1)
// Statement: f_in_void**
// start POI_VoidPtrArray_bufferify
int POI_VoidPtrArray_bufferify(void **addr)
{
    // splicer begin function.VoidPtrArray_bufferify
    int SHC_rv = VoidPtrArray(addr);
    return SHC_rv;
    // splicer end function.VoidPtrArray_bufferify
}
// end POI_VoidPtrArray_bufferify

// ----------------------------------------
// Function:  int *returnIntPtrToScalar
// Statement: f_function_native*_pointer
// start POI_returnIntPtrToScalar_bufferify
int * POI_returnIntPtrToScalar_bufferify(void)
{
    // splicer begin function.returnIntPtrToScalar_bufferify
    int *SHC_rv = returnIntPtrToScalar();
    return SHC_rv;
    // splicer end function.returnIntPtrToScalar_bufferify
}
// end POI_returnIntPtrToScalar_bufferify

// ----------------------------------------
// Function:  int *returnIntPtrToFixedArray +dimension(10)
// Statement: f_function_native*_cdesc_pointer
// start POI_returnIntPtrToFixedArray_bufferify
void POI_returnIntPtrToFixedArray_bufferify(
    POI_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.returnIntPtrToFixedArray_bufferify
    int *SHC_rv = returnIntPtrToFixedArray();
    SHT_rv_cdesc->base_addr = SHC_rv;
    SHT_rv_cdesc->type = SH_TYPE_INT;
    SHT_rv_cdesc->elem_len = sizeof(int);
    SHT_rv_cdesc->rank = 1;
    SHT_rv_cdesc->shape[0] = 10;
    SHT_rv_cdesc->size = SHT_rv_cdesc->shape[0];
    // splicer end function.returnIntPtrToFixedArray_bufferify
}
// end POI_returnIntPtrToFixedArray_bufferify

// ----------------------------------------
// Function:  const int *returnIntPtrToConstScalar
// Statement: f_function_native*_pointer
// start POI_returnIntPtrToConstScalar_bufferify
const int * POI_returnIntPtrToConstScalar_bufferify(void)
{
    // splicer begin function.returnIntPtrToConstScalar_bufferify
    const int *SHC_rv = returnIntPtrToConstScalar();
    return SHC_rv;
    // splicer end function.returnIntPtrToConstScalar_bufferify
}
// end POI_returnIntPtrToConstScalar_bufferify

// ----------------------------------------
// Function:  const int *returnIntPtrToFixedConstArray +dimension(10)
// Statement: f_function_native*_cdesc_pointer
// start POI_returnIntPtrToFixedConstArray_bufferify
void POI_returnIntPtrToFixedConstArray_bufferify(
    POI_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.returnIntPtrToFixedConstArray_bufferify
    const int *SHC_rv = returnIntPtrToFixedConstArray();
    SHT_rv_cdesc->base_addr = const_cast<int *>(SHC_rv);
    SHT_rv_cdesc->type = SH_TYPE_INT;
    SHT_rv_cdesc->elem_len = sizeof(int);
    SHT_rv_cdesc->rank = 1;
    SHT_rv_cdesc->shape[0] = 10;
    SHT_rv_cdesc->size = SHT_rv_cdesc->shape[0];
    // splicer end function.returnIntPtrToFixedConstArray_bufferify
}
// end POI_returnIntPtrToFixedConstArray_bufferify

// ----------------------------------------
// Function:  int *returnIntScalar +deref(scalar)
// Statement: f_function_native*_scalar
// start POI_returnIntScalar_bufferify
int POI_returnIntScalar_bufferify(void)
{
    // splicer begin function.returnIntScalar_bufferify
    int *SHC_rv = returnIntScalar();
    return *SHC_rv;
    // splicer end function.returnIntScalar_bufferify
}
// end POI_returnIntScalar_bufferify

/**
 * Call directly via interface.
 */
// ----------------------------------------
// Function:  int *returnIntRaw +deref(raw)
// Statement: f_function_native*_raw
// start POI_returnIntRaw_bufferify
int * POI_returnIntRaw_bufferify(void)
{
    // splicer begin function.returnIntRaw_bufferify
    int *SHC_rv = returnIntRaw();
    return SHC_rv;
    // splicer end function.returnIntRaw_bufferify
}
// end POI_returnIntRaw_bufferify

/**
 * Like returnIntRaw but with another argument to force a wrapper.
 * Uses fc_statements f_function_native_*_raw.
 */
// ----------------------------------------
// Function:  int *returnIntRawWithArgs +deref(raw)
// Statement: f_function_native*_raw
// ----------------------------------------
// Argument:  const char *name
// Statement: f_in_char*
// start POI_returnIntRawWithArgs_bufferify
int * POI_returnIntRawWithArgs_bufferify(const char *name)
{
    // splicer begin function.returnIntRawWithArgs_bufferify
    int *SHC_rv = returnIntRawWithArgs(name);
    return SHC_rv;
    // splicer end function.returnIntRawWithArgs_bufferify
}
// end POI_returnIntRawWithArgs_bufferify

/**
 * Test multiple layers of indirection.
 * # getRawPtrToInt2d
 */
// ----------------------------------------
// Function:  int **returnRawPtrToInt2d
// Statement: f_function_native**
// start POI_returnRawPtrToInt2d_bufferify
int ** POI_returnRawPtrToInt2d_bufferify(void)
{
    // splicer begin function.returnRawPtrToInt2d_bufferify
    int **SHC_rv = returnRawPtrToInt2d();
    return SHC_rv;
    // splicer end function.returnRawPtrToInt2d_bufferify
}
// end POI_returnRawPtrToInt2d_bufferify

// ----------------------------------------
// Function:  int *returnIntAllocToFixedArray +deref(allocatable)+dimension(10)
// Statement: f_function_native*_cdesc_allocatable
// start POI_returnIntAllocToFixedArray_bufferify
void POI_returnIntAllocToFixedArray_bufferify(
    POI_SHROUD_array *SHT_rv_cdesc,
    POI_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.returnIntAllocToFixedArray_bufferify
    int *SHC_rv = returnIntAllocToFixedArray();
    SHT_rv_cdesc->base_addr = SHC_rv;
    SHT_rv_cdesc->type = SH_TYPE_INT;
    SHT_rv_cdesc->elem_len = sizeof(int);
    SHT_rv_cdesc->rank = 1;
    SHT_rv_cdesc->shape[0] = 10;
    SHT_rv_cdesc->size = SHT_rv_cdesc->shape[0];
    SHT_rv_capsule->addr  = SHC_rv;
    SHT_rv_capsule->idtor = 0;
    // splicer end function.returnIntAllocToFixedArray_bufferify
}
// end POI_returnIntAllocToFixedArray_bufferify

}  // extern "C"
