// wrappointers.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "pointers.h"
// shroud
#include <cstdlib>
#include <cstring>
#include "wrappointers.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {


// helper char_len_trim
// Returns the length of character string src with length nsrc,
// ignoring any trailing blanks.
static int ShroudCharLenTrim(const char *src, int nsrc) {
    int i;

    for (i = nsrc - 1; i >= 0; i--) {
        if (src[i] != ' ') {
            break;
        }
    }

    return i + 1;
}


// helper char_alloc
// Copy src into new memory and null terminate.
// If ntrim is 0, return NULL pointer.
// If blanknull is 1, return NULL when string is blank.
static char *ShroudCharAlloc(const char *src, int nsrc, int blanknull)
{
    int ntrim = ShroudCharLenTrim(src, nsrc);
    if (ntrim == 0 && blanknull == 1) {
        return nullptr;
    }
    char *rv = (char *) std::malloc(nsrc + 1);
    if (ntrim > 0) {
        std::memcpy(rv, src, ntrim);
    }
    rv[ntrim] = '\0';
    return rv;
}

// start helper char_array_alloc
// helper char_array_alloc
// Copy src into new memory and null terminate.
// char **src +size(nsrc) +len(len)
// CHARACTER(len) src(nsrc)
static char **ShroudStrArrayAlloc(const char *src, int nsrc, int len)
{
    char **rv = static_cast<char **>
        (std::malloc(sizeof(char *) * nsrc));
    const char *src0 = src;
    for(int i=0; i < nsrc; ++i) {
        int ntrim = ShroudCharLenTrim(src0, len);
        char *tgt = static_cast<char *>(std::malloc(ntrim+1));
        std::memcpy(tgt, src0, ntrim);
        tgt[ntrim] = '\0';
        rv[i] = tgt;
        src0 += len;
    }
    return rv;
}
// end helper char_array_alloc

// helper char_array_free
// Release memory allocated by ShroudStrArrayAlloc
static void ShroudStrArrayFree(char **src, int nsrc)
{
    for(int i=0; i < nsrc; ++i) {
        std::free(src[i]);
    }
    std::free(src);
}

// helper char_free
// Release memory allocated by ShroudCharAlloc
static void ShroudCharFree(char *src)
{
    if (src != NULL) {
        std::free(src);
    }
}

// splicer begin C_definitions
// splicer end C_definitions

// ----------------------------------------
// Function:  void intargs_in
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const int *arg
// Statement: c_in_native*
// start POI_intargs_in
void POI_intargs_in(const int *arg)
{
    // splicer begin function.intargs_in
    intargs_in(arg);
    // splicer end function.intargs_in
}
// end POI_intargs_in

/**
 * Argument is modified by library, defaults to intent(inout).
 */
// ----------------------------------------
// Function:  void intargs_inout
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int *arg
// Statement: c_inout_native*
// start POI_intargs_inout
void POI_intargs_inout(int *arg)
{
    // splicer begin function.intargs_inout
    intargs_inout(arg);
    // splicer end function.intargs_inout
}
// end POI_intargs_inout

// ----------------------------------------
// Function:  void intargs_out
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int *arg +intent(out)
// Statement: c_out_native*
// start POI_intargs_out
void POI_intargs_out(int *arg)
{
    // splicer begin function.intargs_out
    intargs_out(arg);
    // splicer end function.intargs_out
}
// end POI_intargs_out

// ----------------------------------------
// Function:  void intargs
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const int argin +intent(in)
// Statement: c_in_native
// ----------------------------------------
// Argument:  int *arginout +intent(inout)
// Statement: c_inout_native*
// ----------------------------------------
// Argument:  int *argout +intent(out)
// Statement: c_out_native*
// start POI_intargs
void POI_intargs(const int argin, int *arginout, int *argout)
{
    // splicer begin function.intargs
    intargs(argin, arginout, argout);
    // splicer end function.intargs
}
// end POI_intargs

/**
 * \brief compute cos of IN and save in OUT
 *
 * allocate OUT same type as IN implied size of array
 */
// ----------------------------------------
// Function:  void cos_doubles
// Statement: c_subroutine
// ----------------------------------------
// Argument:  double *in +intent(in)+rank(1)
// Statement: c_in_native*
// ----------------------------------------
// Argument:  double *out +dimension(size(in))+intent(out)
// Statement: c_out_native*
// ----------------------------------------
// Argument:  int sizein +implied(size(in))
// Statement: c_in_native
// start POI_cos_doubles
void POI_cos_doubles(double *in, double *out, int sizein)
{
    // splicer begin function.cos_doubles
    cos_doubles(in, out, sizein);
    // splicer end function.cos_doubles
}
// end POI_cos_doubles

/**
 * \brief compute cos of IN and save in OUT
 *
 * allocate OUT same type as IN implied size of array
 */
// ----------------------------------------
// Function:  void cos_doubles
// Statement: f_subroutine
// ----------------------------------------
// Argument:  double *in +intent(in)+rank(1)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  double *out +dimension(size(in))+intent(out)
// Statement: f_out_native*
// ----------------------------------------
// Argument:  int sizein +implied(size(in))
// Statement: f_in_native
// start POI_cos_doubles_CFI
void POI_cos_doubles_CFI(CFI_cdesc_t *SHT_in_cfi, double *out,
    int sizein)
{
    // splicer begin function.cos_doubles_CFI
    double *SHC_in_cxx = static_cast<double *>(SHT_in_cfi->base_addr);
    cos_doubles(SHC_in_cxx, out, sizein);
    // splicer end function.cos_doubles_CFI
}
// end POI_cos_doubles_CFI

/**
 * \brief truncate IN argument and save in OUT
 *
 * allocate OUT different type as IN
 * implied size of array
 */
// ----------------------------------------
// Function:  void truncate_to_int
// Statement: c_subroutine
// ----------------------------------------
// Argument:  double *in +intent(in)+rank(1)
// Statement: c_in_native*
// ----------------------------------------
// Argument:  int *out +dimension(size(in))+intent(out)
// Statement: c_out_native*
// ----------------------------------------
// Argument:  int sizein +implied(size(in))
// Statement: c_in_native
// start POI_truncate_to_int
void POI_truncate_to_int(double *in, int *out, int sizein)
{
    // splicer begin function.truncate_to_int
    truncate_to_int(in, out, sizein);
    // splicer end function.truncate_to_int
}
// end POI_truncate_to_int

/**
 * \brief truncate IN argument and save in OUT
 *
 * allocate OUT different type as IN
 * implied size of array
 */
// ----------------------------------------
// Function:  void truncate_to_int
// Statement: f_subroutine
// ----------------------------------------
// Argument:  double *in +intent(in)+rank(1)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  int *out +dimension(size(in))+intent(out)
// Statement: f_out_native*
// ----------------------------------------
// Argument:  int sizein +implied(size(in))
// Statement: f_in_native
// start POI_truncate_to_int_CFI
void POI_truncate_to_int_CFI(CFI_cdesc_t *SHT_in_cfi, int *out,
    int sizein)
{
    // splicer begin function.truncate_to_int_CFI
    double *SHC_in_cxx = static_cast<double *>(SHT_in_cfi->base_addr);
    truncate_to_int(SHC_in_cxx, out, sizein);
    // splicer end function.truncate_to_int_CFI
}
// end POI_truncate_to_int_CFI

/**
 * \brief fill values into array
 *
 * The function knows how long the array must be.
 * Fortran will treat the dimension as assumed-length.
 * The Python wrapper will create a NumPy array or list so it must
 * have an explicit dimension (not assumed-length).
 */
// ----------------------------------------
// Function:  void get_values
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int *nvalues +intent(OUT)
// Statement: c_out_native*
// ----------------------------------------
// Argument:  int *values +dimension(3)+intent(out)
// Statement: c_out_native*
// start POI_get_values
void POI_get_values(int *nvalues, int *values)
{
    // splicer begin function.get_values
    get_values(nvalues, values);
    // splicer end function.get_values
}
// end POI_get_values

/**
 * \brief fill values into two arrays
 *
 * Test two intent(out) arguments.
 * Make sure error handling works with C++.
 */
// ----------------------------------------
// Function:  void get_values2
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int *arg1 +dimension(3)+intent(out)
// Statement: c_out_native*
// ----------------------------------------
// Argument:  int *arg2 +dimension(3)+intent(out)
// Statement: c_out_native*
// start POI_get_values2
void POI_get_values2(int *arg1, int *arg2)
{
    // splicer begin function.get_values2
    get_values2(arg1, arg2);
    // splicer end function.get_values2
}
// end POI_get_values2

// ----------------------------------------
// Function:  void iota_dimension
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int nvar
// Statement: c_in_native
// ----------------------------------------
// Argument:  int *values +dimension(nvar)+intent(out)
// Statement: c_out_native*
// start POI_iota_dimension
void POI_iota_dimension(int nvar, int *values)
{
    // splicer begin function.iota_dimension
    iota_dimension(nvar, values);
    // splicer end function.iota_dimension
}
// end POI_iota_dimension

// ----------------------------------------
// Function:  void Sum
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int len +implied(size(values))
// Statement: c_in_native
// ----------------------------------------
// Argument:  const int *values +rank(1)
// Statement: c_in_native*
// ----------------------------------------
// Argument:  int *result +intent(out)
// Statement: c_out_native*
// start POI_Sum
void POI_Sum(int len, const int *values, int *result)
{
    // splicer begin function.Sum
    Sum(len, values, result);
    // splicer end function.Sum
}
// end POI_Sum

// ----------------------------------------
// Function:  void Sum
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int len +implied(size(values))
// Statement: f_in_native
// ----------------------------------------
// Argument:  const int *values +rank(1)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  int *result +intent(out)
// Statement: f_out_native*
// start POI_Sum_CFI
void POI_Sum_CFI(int len, CFI_cdesc_t *SHT_values_cfi, int *result)
{
    // splicer begin function.Sum_CFI
    int *SHC_values_cxx = static_cast<int *>(SHT_values_cfi->base_addr);
    Sum(len, SHC_values_cxx, result);
    // splicer end function.Sum_CFI
}
// end POI_Sum_CFI

/**
 * Return three values into memory the user provides.
 */
// ----------------------------------------
// Function:  void fillIntArray
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int *out +dimension(3)+intent(out)
// Statement: c_out_native*
// start POI_fillIntArray
void POI_fillIntArray(int *out)
{
    // splicer begin function.fillIntArray
    fillIntArray(out);
    // splicer end function.fillIntArray
}
// end POI_fillIntArray

/**
 * Increment array in place using intent(INOUT).
 */
// ----------------------------------------
// Function:  void incrementIntArray
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int *array +intent(inout)+rank(1)
// Statement: c_inout_native*
// ----------------------------------------
// Argument:  int sizein +implied(size(array))
// Statement: c_in_native
// start POI_incrementIntArray
void POI_incrementIntArray(int *array, int sizein)
{
    // splicer begin function.incrementIntArray
    incrementIntArray(array, sizein);
    // splicer end function.incrementIntArray
}
// end POI_incrementIntArray

/**
 * Increment array in place using intent(INOUT).
 */
// ----------------------------------------
// Function:  void incrementIntArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int *array +intent(inout)+rank(1)
// Statement: f_inout_native*_cfi
// ----------------------------------------
// Argument:  int sizein +implied(size(array))
// Statement: f_in_native
// start POI_incrementIntArray_CFI
void POI_incrementIntArray_CFI(CFI_cdesc_t *SHT_array_cfi, int sizein)
{
    // splicer begin function.incrementIntArray_CFI
    int *SHC_array_cxx = static_cast<int *>(SHT_array_cfi->base_addr);
    incrementIntArray(SHC_array_cxx, sizein);
    // splicer end function.incrementIntArray_CFI
}
// end POI_incrementIntArray_CFI

// ----------------------------------------
// Function:  void fill_with_zeros
// Statement: c_subroutine
// ----------------------------------------
// Argument:  double *x +rank(1)
// Statement: c_inout_native*
// ----------------------------------------
// Argument:  int x_length +implied(size(x))
// Statement: c_in_native
// start POI_fill_with_zeros
void POI_fill_with_zeros(double *x, int x_length)
{
    // splicer begin function.fill_with_zeros
    fill_with_zeros(x, x_length);
    // splicer end function.fill_with_zeros
}
// end POI_fill_with_zeros

// ----------------------------------------
// Function:  void fill_with_zeros
// Statement: f_subroutine
// ----------------------------------------
// Argument:  double *x +rank(1)
// Statement: f_inout_native*_cfi
// ----------------------------------------
// Argument:  int x_length +implied(size(x))
// Statement: f_in_native
// start POI_fill_with_zeros_CFI
void POI_fill_with_zeros_CFI(CFI_cdesc_t *SHT_x_cfi, int x_length)
{
    // splicer begin function.fill_with_zeros_CFI
    double *SHC_x_cxx = static_cast<double *>(SHT_x_cfi->base_addr);
    fill_with_zeros(SHC_x_cxx, x_length);
    // splicer end function.fill_with_zeros_CFI
}
// end POI_fill_with_zeros_CFI

// ----------------------------------------
// Function:  int accumulate
// Statement: c_function_native
// ----------------------------------------
// Argument:  const int *arr +rank(1)
// Statement: c_in_native*
// ----------------------------------------
// Argument:  size_t len +implied(size(arr))
// Statement: c_in_native
// start POI_accumulate
int POI_accumulate(const int *arr, size_t len)
{
    // splicer begin function.accumulate
    int SHC_rv = accumulate(arr, len);
    return SHC_rv;
    // splicer end function.accumulate
}
// end POI_accumulate

// ----------------------------------------
// Function:  int accumulate
// Statement: f_function_native
// ----------------------------------------
// Argument:  const int *arr +rank(1)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  size_t len +implied(size(arr))
// Statement: f_in_native
// start POI_accumulate_CFI
int POI_accumulate_CFI(CFI_cdesc_t *SHT_arr_cfi, size_t len)
{
    // splicer begin function.accumulate_CFI
    int *SHC_arr_cxx = static_cast<int *>(SHT_arr_cfi->base_addr);
    int SHC_rv = accumulate(SHC_arr_cxx, len);
    return SHC_rv;
    // splicer end function.accumulate_CFI
}
// end POI_accumulate_CFI

/**
 * Return strlen of the first index as a check.
 */
// ----------------------------------------
// Function:  int acceptCharArrayIn
// Statement: c_function_native
// ----------------------------------------
// Argument:  char **names +intent(in)
// Statement: c_in_char**
// start POI_acceptCharArrayIn
int POI_acceptCharArrayIn(char **names)
{
    // splicer begin function.acceptCharArrayIn
    int SHC_rv = acceptCharArrayIn(names);
    return SHC_rv;
    // splicer end function.acceptCharArrayIn
}
// end POI_acceptCharArrayIn

/**
 * Return strlen of the first index as a check.
 */
// ----------------------------------------
// Function:  int acceptCharArrayIn
// Statement: f_function_native
// ----------------------------------------
// Argument:  char **names +intent(in)
// Statement: f_in_char**_cfi
// start POI_acceptCharArrayIn_CFI
int POI_acceptCharArrayIn_CFI(CFI_cdesc_t *SHT_names_cfi)
{
    // splicer begin function.acceptCharArrayIn_CFI
    char *names = static_cast<char *>(SHT_names_cfi->base_addr);
    size_t SHT_names_len = SHT_names_cfi->elem_len;
    size_t SHT_names_size = SHT_names_cfi->dim[0].extent;
    char **SHC_names_cxx = ShroudStrArrayAlloc(names, SHT_names_size,
        SHT_names_len);
    int SHC_rv = acceptCharArrayIn(SHC_names_cxx);
    ShroudStrArrayFree(SHC_names_cxx, SHT_names_size);
    return SHC_rv;
    // splicer end function.acceptCharArrayIn_CFI
}
// end POI_acceptCharArrayIn_CFI

// ----------------------------------------
// Function:  void setGlobalInt
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int value
// Statement: c_in_native
// start POI_setGlobalInt
void POI_setGlobalInt(int value)
{
    // splicer begin function.setGlobalInt
    setGlobalInt(value);
    // splicer end function.setGlobalInt
}
// end POI_setGlobalInt

/**
 * Used to test values global_array.
 */
// ----------------------------------------
// Function:  int sumFixedArray
// Statement: c_function_native
// start POI_sumFixedArray
int POI_sumFixedArray(void)
{
    // splicer begin function.sumFixedArray
    int SHC_rv = sumFixedArray();
    return SHC_rv;
    // splicer end function.sumFixedArray
}
// end POI_sumFixedArray

// ----------------------------------------
// Function:  void getPtrToScalar
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int **nitems +intent(out)
// Statement: c_out_native**
// start POI_getPtrToScalar
void POI_getPtrToScalar(int **nitems)
{
    // splicer begin function.getPtrToScalar
    getPtrToScalar(nitems);
    // splicer end function.getPtrToScalar
}
// end POI_getPtrToScalar

// ----------------------------------------
// Function:  void getPtrToScalar
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **nitems +intent(out)
// Statement: f_out_native**_cfi_pointer
// start POI_getPtrToScalar_CFI
void POI_getPtrToScalar_CFI(CFI_cdesc_t *SHT_nitems_cfi)
{
    // splicer begin function.getPtrToScalar_CFI
    int * SHC_nitems_cxx;
    getPtrToScalar(&SHC_nitems_cxx);
    {
        CFI_CDESC_T(0) SHC_nitems_fptr;
        CFI_cdesc_t *SHC_nitems_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_nitems_fptr);
        void *SHC_nitems_cptr = const_cast<int *>(SHC_nitems_cxx);
        int SHC_nitems_err = CFI_establish(SHC_nitems_cdesc,
            SHC_nitems_cptr, CFI_attribute_pointer, CFI_type_int, 0, 0,
            NULL);
        if (SHC_nitems_err == CFI_SUCCESS) {
            SHC_nitems_err = CFI_setpointer(SHT_nitems_cfi,
                SHC_nitems_cdesc, NULL);
        }
    }
    // splicer end function.getPtrToScalar_CFI
}
// end POI_getPtrToScalar_CFI

/**
 * Return a Fortran pointer to an array which is always the same length.
 */
// ----------------------------------------
// Function:  void getPtrToFixedArray
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(10)+intent(out)
// Statement: c_out_native**
// start POI_getPtrToFixedArray
void POI_getPtrToFixedArray(int **count)
{
    // splicer begin function.getPtrToFixedArray
    getPtrToFixedArray(count);
    // splicer end function.getPtrToFixedArray
}
// end POI_getPtrToFixedArray

/**
 * Return a Fortran pointer to an array which is always the same length.
 */
// ----------------------------------------
// Function:  void getPtrToFixedArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(10)+intent(out)
// Statement: f_out_native**_cfi_pointer
// start POI_getPtrToFixedArray_CFI
void POI_getPtrToFixedArray_CFI(CFI_cdesc_t *SHT_count_cfi)
{
    // splicer begin function.getPtrToFixedArray_CFI
    int * SHC_count_cxx;
    getPtrToFixedArray(&SHC_count_cxx);
    {
        CFI_CDESC_T(1) SHC_count_fptr;
        CFI_cdesc_t *SHC_count_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_count_fptr);
        void *SHC_count_cptr = const_cast<int *>(SHC_count_cxx);
        CFI_index_t SHT_count_extents[1];
        SHT_count_extents[0] = 10;
        CFI_index_t SHT_count_lower[1] = {1};
        int SHC_count_err = CFI_establish(SHC_count_cdesc,
            SHC_count_cptr, CFI_attribute_pointer, CFI_type_int, 0, 1,
            SHT_count_extents);
        if (SHC_count_err == CFI_SUCCESS) {
            SHC_count_err = CFI_setpointer(SHT_count_cfi,
                SHC_count_cdesc, SHT_count_lower);
        }
    }
    // splicer end function.getPtrToFixedArray_CFI
}
// end POI_getPtrToFixedArray_CFI

/**
 * Return a Fortran pointer to an array which is the length of
 * the argument ncount.
 */
// ----------------------------------------
// Function:  void getPtrToDynamicArray
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(ncount)+intent(out)
// Statement: c_out_native**
// ----------------------------------------
// Argument:  int *ncount +hidden+intent(out)
// Statement: c_out_native*
// start POI_getPtrToDynamicArray
void POI_getPtrToDynamicArray(int **count, int *ncount)
{
    // splicer begin function.getPtrToDynamicArray
    getPtrToDynamicArray(count, ncount);
    // splicer end function.getPtrToDynamicArray
}
// end POI_getPtrToDynamicArray

/**
 * Return a Fortran pointer to an array which is the length of
 * the argument ncount.
 */
// ----------------------------------------
// Function:  void getPtrToDynamicArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(ncount)+intent(out)
// Statement: f_out_native**_cfi_pointer
// ----------------------------------------
// Argument:  int *ncount +hidden+intent(out)
// Statement: f_out_native*_hidden
// start POI_getPtrToDynamicArray_CFI
void POI_getPtrToDynamicArray_CFI(CFI_cdesc_t *SHT_count_cfi)
{
    // splicer begin function.getPtrToDynamicArray_CFI
    int * SHC_count_cxx;
    int ncount;
    getPtrToDynamicArray(&SHC_count_cxx, &ncount);
    {
        CFI_CDESC_T(1) SHC_count_fptr;
        CFI_cdesc_t *SHC_count_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_count_fptr);
        void *SHC_count_cptr = const_cast<int *>(SHC_count_cxx);
        CFI_index_t SHT_count_extents[1];
        SHT_count_extents[0] = ncount;
        CFI_index_t SHT_count_lower[1] = {1};
        int SHC_count_err = CFI_establish(SHC_count_cdesc,
            SHC_count_cptr, CFI_attribute_pointer, CFI_type_int, 0, 1,
            SHT_count_extents);
        if (SHC_count_err == CFI_SUCCESS) {
            SHC_count_err = CFI_setpointer(SHT_count_cfi,
                SHC_count_cdesc, SHT_count_lower);
        }
    }
    // splicer end function.getPtrToDynamicArray_CFI
}
// end POI_getPtrToDynamicArray_CFI

/**
 * Return a Fortran pointer to an array which is the length
 * is computed by C++ function getLen.
 * getLen will be called from C/C++ to compute the shape.
 */
// ----------------------------------------
// Function:  void getPtrToFuncArray
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(getLen())+intent(out)
// Statement: c_out_native**
// start POI_getPtrToFuncArray
void POI_getPtrToFuncArray(int **count)
{
    // splicer begin function.getPtrToFuncArray
    getPtrToFuncArray(count);
    // splicer end function.getPtrToFuncArray
}
// end POI_getPtrToFuncArray

/**
 * Return a Fortran pointer to an array which is the length
 * is computed by C++ function getLen.
 * getLen will be called from C/C++ to compute the shape.
 */
// ----------------------------------------
// Function:  void getPtrToFuncArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(getLen())+intent(out)
// Statement: f_out_native**_cfi_pointer
// start POI_getPtrToFuncArray_CFI
void POI_getPtrToFuncArray_CFI(CFI_cdesc_t *SHT_count_cfi)
{
    // splicer begin function.getPtrToFuncArray_CFI
    int * SHC_count_cxx;
    getPtrToFuncArray(&SHC_count_cxx);
    {
        CFI_CDESC_T(1) SHC_count_fptr;
        CFI_cdesc_t *SHC_count_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_count_fptr);
        void *SHC_count_cptr = const_cast<int *>(SHC_count_cxx);
        CFI_index_t SHT_count_extents[1];
        SHT_count_extents[0] = getLen();
        CFI_index_t SHT_count_lower[1] = {1};
        int SHC_count_err = CFI_establish(SHC_count_cdesc,
            SHC_count_cptr, CFI_attribute_pointer, CFI_type_int, 0, 1,
            SHT_count_extents);
        if (SHC_count_err == CFI_SUCCESS) {
            SHC_count_err = CFI_setpointer(SHT_count_cfi,
                SHC_count_cdesc, SHT_count_lower);
        }
    }
    // splicer end function.getPtrToFuncArray_CFI
}
// end POI_getPtrToFuncArray_CFI

// ----------------------------------------
// Function:  void getPtrToConstScalar
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const int **nitems +intent(out)
// Statement: c_out_native**
// start POI_getPtrToConstScalar
void POI_getPtrToConstScalar(const int **nitems)
{
    // splicer begin function.getPtrToConstScalar
    getPtrToConstScalar(nitems);
    // splicer end function.getPtrToConstScalar
}
// end POI_getPtrToConstScalar

// ----------------------------------------
// Function:  void getPtrToConstScalar
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int **nitems +intent(out)
// Statement: f_out_native**_cfi_pointer
// start POI_getPtrToConstScalar_CFI
void POI_getPtrToConstScalar_CFI(CFI_cdesc_t *SHT_nitems_cfi)
{
    // splicer begin function.getPtrToConstScalar_CFI
    const int * SHC_nitems_cxx;
    getPtrToConstScalar(&SHC_nitems_cxx);
    {
        CFI_CDESC_T(0) SHC_nitems_fptr;
        CFI_cdesc_t *SHC_nitems_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_nitems_fptr);
        void *SHC_nitems_cptr = const_cast<int *>(SHC_nitems_cxx);
        int SHC_nitems_err = CFI_establish(SHC_nitems_cdesc,
            SHC_nitems_cptr, CFI_attribute_pointer, CFI_type_int, 0, 0,
            NULL);
        if (SHC_nitems_err == CFI_SUCCESS) {
            SHC_nitems_err = CFI_setpointer(SHT_nitems_cfi,
                SHC_nitems_cdesc, NULL);
        }
    }
    // splicer end function.getPtrToConstScalar_CFI
}
// end POI_getPtrToConstScalar_CFI

// ----------------------------------------
// Function:  void getPtrToFixedConstArray
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const int **count +dimension(10)+intent(out)
// Statement: c_out_native**
// start POI_getPtrToFixedConstArray
void POI_getPtrToFixedConstArray(const int **count)
{
    // splicer begin function.getPtrToFixedConstArray
    getPtrToFixedConstArray(count);
    // splicer end function.getPtrToFixedConstArray
}
// end POI_getPtrToFixedConstArray

// ----------------------------------------
// Function:  void getPtrToFixedConstArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int **count +dimension(10)+intent(out)
// Statement: f_out_native**_cfi_pointer
// start POI_getPtrToFixedConstArray_CFI
void POI_getPtrToFixedConstArray_CFI(CFI_cdesc_t *SHT_count_cfi)
{
    // splicer begin function.getPtrToFixedConstArray_CFI
    const int * SHC_count_cxx;
    getPtrToFixedConstArray(&SHC_count_cxx);
    {
        CFI_CDESC_T(1) SHC_count_fptr;
        CFI_cdesc_t *SHC_count_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_count_fptr);
        void *SHC_count_cptr = const_cast<int *>(SHC_count_cxx);
        CFI_index_t SHT_count_extents[1];
        SHT_count_extents[0] = 10;
        CFI_index_t SHT_count_lower[1] = {1};
        int SHC_count_err = CFI_establish(SHC_count_cdesc,
            SHC_count_cptr, CFI_attribute_pointer, CFI_type_int, 0, 1,
            SHT_count_extents);
        if (SHC_count_err == CFI_SUCCESS) {
            SHC_count_err = CFI_setpointer(SHT_count_cfi,
                SHC_count_cdesc, SHT_count_lower);
        }
    }
    // splicer end function.getPtrToFixedConstArray_CFI
}
// end POI_getPtrToFixedConstArray_CFI

// ----------------------------------------
// Function:  void getPtrToDynamicConstArray
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const int **count +dimension(ncount)+intent(out)
// Statement: c_out_native**
// ----------------------------------------
// Argument:  int *ncount +hidden+intent(out)
// Statement: c_out_native*
// start POI_getPtrToDynamicConstArray
void POI_getPtrToDynamicConstArray(const int **count, int *ncount)
{
    // splicer begin function.getPtrToDynamicConstArray
    getPtrToDynamicConstArray(count, ncount);
    // splicer end function.getPtrToDynamicConstArray
}
// end POI_getPtrToDynamicConstArray

// ----------------------------------------
// Function:  void getPtrToDynamicConstArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int **count +dimension(ncount)+intent(out)
// Statement: f_out_native**_cfi_pointer
// ----------------------------------------
// Argument:  int *ncount +hidden+intent(out)
// Statement: f_out_native*_hidden
// start POI_getPtrToDynamicConstArray_CFI
void POI_getPtrToDynamicConstArray_CFI(CFI_cdesc_t *SHT_count_cfi)
{
    // splicer begin function.getPtrToDynamicConstArray_CFI
    const int * SHC_count_cxx;
    int ncount;
    getPtrToDynamicConstArray(&SHC_count_cxx, &ncount);
    {
        CFI_CDESC_T(1) SHC_count_fptr;
        CFI_cdesc_t *SHC_count_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_count_fptr);
        void *SHC_count_cptr = const_cast<int *>(SHC_count_cxx);
        CFI_index_t SHT_count_extents[1];
        SHT_count_extents[0] = ncount;
        CFI_index_t SHT_count_lower[1] = {1};
        int SHC_count_err = CFI_establish(SHC_count_cdesc,
            SHC_count_cptr, CFI_attribute_pointer, CFI_type_int, 0, 1,
            SHT_count_extents);
        if (SHC_count_err == CFI_SUCCESS) {
            SHC_count_err = CFI_setpointer(SHT_count_cfi,
                SHC_count_cdesc, SHT_count_lower);
        }
    }
    // splicer end function.getPtrToDynamicConstArray_CFI
}
// end POI_getPtrToDynamicConstArray_CFI

/**
 * Called directly via an interface in Fortran.
 */
// ----------------------------------------
// Function:  void getRawPtrToScalar
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int **nitems +deref(raw)+intent(out)
// Statement: c_out_native**
// start POI_getRawPtrToScalar
void POI_getRawPtrToScalar(int **nitems)
{
    // splicer begin function.getRawPtrToScalar
    getRawPtrToScalar(nitems);
    // splicer end function.getRawPtrToScalar
}
// end POI_getRawPtrToScalar

/**
 * Create a Fortran wrapper.
 */
// ----------------------------------------
// Function:  void getRawPtrToScalarForce
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int **nitems +deref(raw)+intent(out)
// Statement: c_out_native**
// start POI_getRawPtrToScalarForce
void POI_getRawPtrToScalarForce(int **nitems)
{
    // splicer begin function.getRawPtrToScalarForce
    getRawPtrToScalarForce(nitems);
    // splicer end function.getRawPtrToScalarForce
}
// end POI_getRawPtrToScalarForce

/**
 * Return a type(C_PTR) to an array which is always the same length.
 * Called directly via an interface in Fortran.
 * # Uses +deref(raw) instead of +dimension(10) like getPtrToFixedArray.
 */
// ----------------------------------------
// Function:  void getRawPtrToFixedArray
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int **count +deref(raw)+intent(out)
// Statement: c_out_native**
// start POI_getRawPtrToFixedArray
void POI_getRawPtrToFixedArray(int **count)
{
    // splicer begin function.getRawPtrToFixedArray
    getRawPtrToFixedArray(count);
    // splicer end function.getRawPtrToFixedArray
}
// end POI_getRawPtrToFixedArray

/**
 * Return a type(C_PTR) to an array which is always the same length.
 * Create a Fortran wrapper.
 */
// ----------------------------------------
// Function:  void getRawPtrToFixedArrayForce
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int **count +deref(raw)+intent(out)
// Statement: c_out_native**
// start POI_getRawPtrToFixedArrayForce
void POI_getRawPtrToFixedArrayForce(int **count)
{
    // splicer begin function.getRawPtrToFixedArrayForce
    getRawPtrToFixedArrayForce(count);
    // splicer end function.getRawPtrToFixedArrayForce
}
// end POI_getRawPtrToFixedArrayForce

/**
 * Test multiple layers of indirection.
 */
// ----------------------------------------
// Function:  void getRawPtrToInt2d
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int ***arg +intent(out)
// Statement: c_out_native***
// start POI_getRawPtrToInt2d
void POI_getRawPtrToInt2d(int ***arg)
{
    // splicer begin function.getRawPtrToInt2d
    getRawPtrToInt2d(arg);
    // splicer end function.getRawPtrToInt2d
}
// end POI_getRawPtrToInt2d

/**
 * Check results of getRawPtrToInt2d.
 */
// ----------------------------------------
// Function:  int checkInt2d
// Statement: c_function_native
// ----------------------------------------
// Argument:  int **arg +intent(in)
// Statement: c_in_native**
// start POI_checkInt2d
int POI_checkInt2d(int **arg)
{
    // splicer begin function.checkInt2d
    int SHC_rv = checkInt2d(arg);
    return SHC_rv;
    // splicer end function.checkInt2d
}
// end POI_checkInt2d

/**
 * Test +dimension(10,20) +intent(in) together.
 * This will not use assumed-shape in the Fortran wrapper.
 */
// ----------------------------------------
// Function:  void DimensionIn
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const int *arg +dimension(10,20)
// Statement: c_in_native*
// start POI_DimensionIn
void POI_DimensionIn(const int *arg)
{
    // splicer begin function.DimensionIn
    DimensionIn(arg);
    // splicer end function.DimensionIn
}
// end POI_DimensionIn

/**
 * Return a Fortran pointer to an array which is always the same length.
 */
// ----------------------------------------
// Function:  void getAllocToFixedArray
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int **count +deref(allocatable)+dimension(10)+intent(out)
// Statement: c_out_native**
// start POI_getAllocToFixedArray
void POI_getAllocToFixedArray(int **count)
{
    // splicer begin function.getAllocToFixedArray
    getAllocToFixedArray(count);
    // splicer end function.getAllocToFixedArray
}
// end POI_getAllocToFixedArray

/**
 * Return a Fortran pointer to an array which is always the same length.
 */
// ----------------------------------------
// Function:  void getAllocToFixedArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +deref(allocatable)+dimension(10)+intent(out)
// Statement: f_out_native**_cfi_allocatable
// start POI_getAllocToFixedArray_CFI
void POI_getAllocToFixedArray_CFI(CFI_cdesc_t *SHT_count_cfi)
{
    // splicer begin function.getAllocToFixedArray_CFI
    int * SHC_count_cxx;
    getAllocToFixedArray(&SHC_count_cxx);
    if (SHC_count_cxx != nullptr) {
        CFI_index_t SHT_count_lower[1] = {1};
        CFI_index_t SHT_count_extents[1];
        SHT_count_extents[0] = 10;
        int SH_ret = CFI_allocate(SHT_count_cfi, SHT_count_lower, 
            SHT_count_extents, 0);
        if (SH_ret == CFI_SUCCESS) {
            std::memcpy(SHT_count_cfi->base_addr, SHC_count_cxx, 
                SHT_count_cfi->elem_len);
        }
    }
    // splicer end function.getAllocToFixedArray_CFI
}
// end POI_getAllocToFixedArray_CFI

// ----------------------------------------
// Function:  void *returnAddress1
// Statement: c_function_void*
// ----------------------------------------
// Argument:  int flag
// Statement: c_in_native
// start POI_returnAddress1
void * POI_returnAddress1(int flag)
{
    // splicer begin function.returnAddress1
    void *SHC_rv = returnAddress1(flag);
    return SHC_rv;
    // splicer end function.returnAddress1
}
// end POI_returnAddress1

// ----------------------------------------
// Function:  void *returnAddress2
// Statement: c_function_void*
// ----------------------------------------
// Argument:  int flag
// Statement: c_in_native
// start POI_returnAddress2
void * POI_returnAddress2(int flag)
{
    // splicer begin function.returnAddress2
    void *SHC_rv = returnAddress2(flag);
    return SHC_rv;
    // splicer end function.returnAddress2
}
// end POI_returnAddress2

// ----------------------------------------
// Function:  void fetchVoidPtr
// Statement: c_subroutine
// ----------------------------------------
// Argument:  void **addr +intent(out)
// Statement: c_out_void**
// start POI_fetchVoidPtr
void POI_fetchVoidPtr(void **addr)
{
    // splicer begin function.fetchVoidPtr
    fetchVoidPtr(addr);
    // splicer end function.fetchVoidPtr
}
// end POI_fetchVoidPtr

// ----------------------------------------
// Function:  void updateVoidPtr
// Statement: c_subroutine
// ----------------------------------------
// Argument:  void **addr +intent(inout)
// Statement: c_inout_void**
// start POI_updateVoidPtr
void POI_updateVoidPtr(void **addr)
{
    // splicer begin function.updateVoidPtr
    updateVoidPtr(addr);
    // splicer end function.updateVoidPtr
}
// end POI_updateVoidPtr

// ----------------------------------------
// Function:  int VoidPtrArray
// Statement: c_function_native
// ----------------------------------------
// Argument:  void **addr +rank(1)
// Statement: c_in_void**
// start POI_VoidPtrArray
int POI_VoidPtrArray(void **addr)
{
    // splicer begin function.VoidPtrArray
    int SHC_rv = VoidPtrArray(addr);
    return SHC_rv;
    // splicer end function.VoidPtrArray
}
// end POI_VoidPtrArray

// ----------------------------------------
// Function:  int *returnIntPtrToScalar
// Statement: c_function_native*
// start POI_returnIntPtrToScalar
int * POI_returnIntPtrToScalar(void)
{
    // splicer begin function.returnIntPtrToScalar
    int *SHC_rv = returnIntPtrToScalar();
    return SHC_rv;
    // splicer end function.returnIntPtrToScalar
}
// end POI_returnIntPtrToScalar

// ----------------------------------------
// Function:  int *returnIntPtrToScalar
// Statement: f_function_native*_cfi_pointer
// start POI_returnIntPtrToScalar_CFI
void POI_returnIntPtrToScalar_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.returnIntPtrToScalar_CFI
    int *SHC_rv_cxx = returnIntPtrToScalar();
    {
        CFI_CDESC_T(0) SHC_rv_fptr;
        CFI_cdesc_t *SHC_rv_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_rv_fptr);
        void *SHC_rv_cptr = const_cast<int *>(SHC_rv_cxx);
        int SHC_rv_err = CFI_establish(SHC_rv_cdesc, SHC_rv_cptr,
            CFI_attribute_pointer, CFI_type_int, 0, 0, NULL);
        if (SHC_rv_err == CFI_SUCCESS) {
            SHC_rv_err = CFI_setpointer(SHT_rv_cfi, SHC_rv_cdesc, NULL);
        }
    }
    // splicer end function.returnIntPtrToScalar_CFI
}
// end POI_returnIntPtrToScalar_CFI

// ----------------------------------------
// Function:  int *returnIntPtrToFixedArray +dimension(10)
// Statement: c_function_native*
// start POI_returnIntPtrToFixedArray
int * POI_returnIntPtrToFixedArray(void)
{
    // splicer begin function.returnIntPtrToFixedArray
    int *SHC_rv = returnIntPtrToFixedArray();
    return SHC_rv;
    // splicer end function.returnIntPtrToFixedArray
}
// end POI_returnIntPtrToFixedArray

// ----------------------------------------
// Function:  int *returnIntPtrToFixedArray +dimension(10)
// Statement: f_function_native*_cfi_pointer
// start POI_returnIntPtrToFixedArray_CFI
void POI_returnIntPtrToFixedArray_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.returnIntPtrToFixedArray_CFI
    int *SHC_rv_cxx = returnIntPtrToFixedArray();
    {
        CFI_CDESC_T(1) SHC_rv_fptr;
        CFI_cdesc_t *SHC_rv_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_rv_fptr);
        void *SHC_rv_cptr = const_cast<int *>(SHC_rv_cxx);
        CFI_index_t SHT_rv_extents[1];
        SHT_rv_extents[0] = 10;
        CFI_index_t SHT_rv_lower[1] = {1};
        int SHC_rv_err = CFI_establish(SHC_rv_cdesc, SHC_rv_cptr,
            CFI_attribute_pointer, CFI_type_int, 0, 1, SHT_rv_extents);
        if (SHC_rv_err == CFI_SUCCESS) {
            SHC_rv_err = CFI_setpointer(SHT_rv_cfi, SHC_rv_cdesc,
                SHT_rv_lower);
        }
    }
    // splicer end function.returnIntPtrToFixedArray_CFI
}
// end POI_returnIntPtrToFixedArray_CFI

// ----------------------------------------
// Function:  const int *returnIntPtrToConstScalar
// Statement: c_function_native*
// start POI_returnIntPtrToConstScalar
const int * POI_returnIntPtrToConstScalar(void)
{
    // splicer begin function.returnIntPtrToConstScalar
    const int *SHC_rv = returnIntPtrToConstScalar();
    return SHC_rv;
    // splicer end function.returnIntPtrToConstScalar
}
// end POI_returnIntPtrToConstScalar

// ----------------------------------------
// Function:  const int *returnIntPtrToConstScalar
// Statement: f_function_native*_cfi_pointer
// start POI_returnIntPtrToConstScalar_CFI
void POI_returnIntPtrToConstScalar_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.returnIntPtrToConstScalar_CFI
    const int *SHC_rv_cxx = returnIntPtrToConstScalar();
    {
        CFI_CDESC_T(0) SHC_rv_fptr;
        CFI_cdesc_t *SHC_rv_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_rv_fptr);
        void *SHC_rv_cptr = const_cast<int *>(SHC_rv_cxx);
        int SHC_rv_err = CFI_establish(SHC_rv_cdesc, SHC_rv_cptr,
            CFI_attribute_pointer, CFI_type_int, 0, 0, NULL);
        if (SHC_rv_err == CFI_SUCCESS) {
            SHC_rv_err = CFI_setpointer(SHT_rv_cfi, SHC_rv_cdesc, NULL);
        }
    }
    // splicer end function.returnIntPtrToConstScalar_CFI
}
// end POI_returnIntPtrToConstScalar_CFI

// ----------------------------------------
// Function:  const int *returnIntPtrToFixedConstArray +dimension(10)
// Statement: c_function_native*
// start POI_returnIntPtrToFixedConstArray
const int * POI_returnIntPtrToFixedConstArray(void)
{
    // splicer begin function.returnIntPtrToFixedConstArray
    const int *SHC_rv = returnIntPtrToFixedConstArray();
    return SHC_rv;
    // splicer end function.returnIntPtrToFixedConstArray
}
// end POI_returnIntPtrToFixedConstArray

// ----------------------------------------
// Function:  const int *returnIntPtrToFixedConstArray +dimension(10)
// Statement: f_function_native*_cfi_pointer
// start POI_returnIntPtrToFixedConstArray_CFI
void POI_returnIntPtrToFixedConstArray_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.returnIntPtrToFixedConstArray_CFI
    const int *SHC_rv_cxx = returnIntPtrToFixedConstArray();
    {
        CFI_CDESC_T(1) SHC_rv_fptr;
        CFI_cdesc_t *SHC_rv_cdesc = reinterpret_cast<CFI_cdesc_t *>
            (&SHC_rv_fptr);
        void *SHC_rv_cptr = const_cast<int *>(SHC_rv_cxx);
        CFI_index_t SHT_rv_extents[1];
        SHT_rv_extents[0] = 10;
        CFI_index_t SHT_rv_lower[1] = {1};
        int SHC_rv_err = CFI_establish(SHC_rv_cdesc, SHC_rv_cptr,
            CFI_attribute_pointer, CFI_type_int, 0, 1, SHT_rv_extents);
        if (SHC_rv_err == CFI_SUCCESS) {
            SHC_rv_err = CFI_setpointer(SHT_rv_cfi, SHC_rv_cdesc,
                SHT_rv_lower);
        }
    }
    // splicer end function.returnIntPtrToFixedConstArray_CFI
}
// end POI_returnIntPtrToFixedConstArray_CFI

// ----------------------------------------
// Function:  int *returnIntScalar +deref(scalar)
// Statement: c_function_native*
// start POI_returnIntScalar
int * POI_returnIntScalar(void)
{
    // splicer begin function.returnIntScalar
    int *SHC_rv = returnIntScalar();
    return SHC_rv;
    // splicer end function.returnIntScalar
}
// end POI_returnIntScalar

// ----------------------------------------
// Function:  int *returnIntScalar +deref(scalar)
// Statement: f_function_native*_scalar
// start POI_returnIntScalar_bufferify
int POI_returnIntScalar_bufferify(void)
{
    // splicer begin function.returnIntScalar_bufferify
    int *SHC_rv = returnIntScalar();
    return *SHC_rv;
    // splicer end function.returnIntScalar_bufferify
}
// end POI_returnIntScalar_bufferify

/**
 * Call directly via interface.
 */
// ----------------------------------------
// Function:  int *returnIntRaw +deref(raw)
// Statement: c_function_native*
// start POI_returnIntRaw
int * POI_returnIntRaw(void)
{
    // splicer begin function.returnIntRaw
    int *SHC_rv = returnIntRaw();
    return SHC_rv;
    // splicer end function.returnIntRaw
}
// end POI_returnIntRaw

/**
 * Like returnIntRaw but with another argument to force a wrapper.
 * Uses fc_statements f_function_native_*_raw.
 */
// ----------------------------------------
// Function:  int *returnIntRawWithArgs +deref(raw)
// Statement: c_function_native*
// ----------------------------------------
// Argument:  const char *name
// Statement: c_in_char*
// start POI_returnIntRawWithArgs
int * POI_returnIntRawWithArgs(const char *name)
{
    // splicer begin function.returnIntRawWithArgs
    int *SHC_rv = returnIntRawWithArgs(name);
    return SHC_rv;
    // splicer end function.returnIntRawWithArgs
}
// end POI_returnIntRawWithArgs

/**
 * Like returnIntRaw but with another argument to force a wrapper.
 * Uses fc_statements f_function_native_*_raw.
 */
// ----------------------------------------
// Function:  int *returnIntRawWithArgs +deref(raw)
// Statement: f_function_native*_raw
// ----------------------------------------
// Argument:  const char *name
// Statement: f_in_char*_cfi
// start POI_returnIntRawWithArgs_CFI
int * POI_returnIntRawWithArgs_CFI(CFI_cdesc_t *SHT_name_cfi)
{
    // splicer begin function.returnIntRawWithArgs_CFI
    char *name = static_cast<char *>(SHT_name_cfi->base_addr);
    char *SHC_name_cxx = ShroudCharAlloc(name, SHT_name_cfi->elem_len,
        0);
    int *SHC_rv = returnIntRawWithArgs(SHC_name_cxx);
    ShroudCharFree(SHC_name_cxx);
    return SHC_rv;
    // splicer end function.returnIntRawWithArgs_CFI
}
// end POI_returnIntRawWithArgs_CFI

/**
 * Test multiple layers of indirection.
 * # getRawPtrToInt2d
 */
// ----------------------------------------
// Function:  int **returnRawPtrToInt2d
// Statement: c_function_native**
// start POI_returnRawPtrToInt2d
int ** POI_returnRawPtrToInt2d(void)
{
    // splicer begin function.returnRawPtrToInt2d
    int **SHC_rv = returnRawPtrToInt2d();
    return SHC_rv;
    // splicer end function.returnRawPtrToInt2d
}
// end POI_returnRawPtrToInt2d

// ----------------------------------------
// Function:  int *returnIntAllocToFixedArray +deref(allocatable)+dimension(10)
// Statement: c_function_native*
// start POI_returnIntAllocToFixedArray
int * POI_returnIntAllocToFixedArray(void)
{
    // splicer begin function.returnIntAllocToFixedArray
    int *SHC_rv = returnIntAllocToFixedArray();
    return SHC_rv;
    // splicer end function.returnIntAllocToFixedArray
}
// end POI_returnIntAllocToFixedArray

// ----------------------------------------
// Function:  int *returnIntAllocToFixedArray +deref(allocatable)+dimension(10)
// Statement: f_function_native*_cfi_allocatable
// start POI_returnIntAllocToFixedArray_CFI
void POI_returnIntAllocToFixedArray_CFI(CFI_cdesc_t *SHT_rv_cfi)
{
    // splicer begin function.returnIntAllocToFixedArray_CFI
    int *SHC_rv_cxx = returnIntAllocToFixedArray();
    if (SHC_rv_cxx != nullptr) {
        CFI_index_t SHT_rv_lower[1] = {1};
        CFI_index_t SHT_rv_extents[1];
        SHT_rv_extents[0] = 10;
        int SH_ret = CFI_allocate(SHT_rv_cfi, SHT_rv_lower, 
            SHT_rv_extents, 0);
        if (SH_ret == CFI_SUCCESS) {
            std::memcpy(SHT_rv_cfi->base_addr, SHC_rv_cxx, 
                SHT_rv_cfi->elem_len);
        }
    }
    // splicer end function.returnIntAllocToFixedArray_CFI
}
// end POI_returnIntAllocToFixedArray_CFI

}  // extern "C"
