! wrapfpointers.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfpointers.f
!! \brief Shroud generated wrapper for pointers library
!<
! splicer begin file_top
! splicer end file_top
module pointers_mod
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! ----------------------------------------
    ! Function:  void intargs_in
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *arg
    ! Statement: f_in_native*
    ! start intargs_in
    interface
        subroutine intargs_in(arg) &
                bind(C, name="POI_intargs_in")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: arg
        end subroutine intargs_in
    end interface
    ! end intargs_in

    ! ----------------------------------------
    ! Function:  void intargs_inout
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg
    ! Statement: f_inout_native*
    ! start intargs_inout
    interface
        subroutine intargs_inout(arg) &
                bind(C, name="POI_intargs_inout")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(INOUT) :: arg
        end subroutine intargs_inout
    end interface
    ! end intargs_inout

    ! ----------------------------------------
    ! Function:  void intargs_out
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg +intent(out)
    ! Statement: f_out_native*
    ! start intargs_out
    interface
        subroutine intargs_out(arg) &
                bind(C, name="POI_intargs_out")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT) :: arg
        end subroutine intargs_out
    end interface
    ! end intargs_out

    ! ----------------------------------------
    ! Function:  void intargs
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int argin +intent(in)
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *arginout +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *argout +intent(out)
    ! Statement: f_out_native*
    ! start intargs
    interface
        subroutine intargs(argin, arginout, argout) &
                bind(C, name="POI_intargs")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: argin
            integer(C_INT), intent(INOUT) :: arginout
            integer(C_INT), intent(OUT) :: argout
        end subroutine intargs
    end interface
    ! end intargs

    ! ----------------------------------------
    ! Function:  void cos_doubles
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(1)
    ! Statement: c_in_native*
    ! ----------------------------------------
    ! Argument:  double *out +dimension(size(in))+intent(out)
    ! Statement: c_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: c_in_native
    ! start c_cos_doubles
    interface
        subroutine c_cos_doubles(in, out, sizein) &
                bind(C, name="POI_cos_doubles")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(IN) :: in(*)
            real(C_DOUBLE), intent(OUT) :: out(*)
            integer(C_INT), value, intent(IN) :: sizein
        end subroutine c_cos_doubles
    end interface
    ! end c_cos_doubles

    ! ----------------------------------------
    ! Function:  void cos_doubles
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  double *out +dimension(size(in))+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: f_in_native
    ! start c_cos_doubles_CFI
    interface
        subroutine c_cos_doubles_CFI(in, out, sizein) &
                bind(C, name="POI_cos_doubles_CFI")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(IN) :: in(:)
            real(C_DOUBLE), intent(OUT) :: out(*)
            integer(C_INT), value, intent(IN) :: sizein
        end subroutine c_cos_doubles_CFI
    end interface
    ! end c_cos_doubles_CFI

    ! ----------------------------------------
    ! Function:  void truncate_to_int
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(1)
    ! Statement: c_in_native*
    ! ----------------------------------------
    ! Argument:  int *out +dimension(size(in))+intent(out)
    ! Statement: c_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: c_in_native
    ! start c_truncate_to_int
    interface
        subroutine c_truncate_to_int(in, out, sizein) &
                bind(C, name="POI_truncate_to_int")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(IN) :: in(*)
            integer(C_INT), intent(OUT) :: out(*)
            integer(C_INT), value, intent(IN) :: sizein
        end subroutine c_truncate_to_int
    end interface
    ! end c_truncate_to_int

    ! ----------------------------------------
    ! Function:  void truncate_to_int
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int *out +dimension(size(in))+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: f_in_native
    ! start c_truncate_to_int_CFI
    interface
        subroutine c_truncate_to_int_CFI(in, out, sizein) &
                bind(C, name="POI_truncate_to_int_CFI")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(IN) :: in(:)
            integer(C_INT), intent(OUT) :: out(*)
            integer(C_INT), value, intent(IN) :: sizein
        end subroutine c_truncate_to_int_CFI
    end interface
    ! end c_truncate_to_int_CFI

    ! ----------------------------------------
    ! Function:  void get_values
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *nvalues +intent(OUT)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int *values +dimension(3)+intent(out)
    ! Statement: f_out_native*
    ! start get_values
    interface
        subroutine get_values(nvalues, values) &
                bind(C, name="POI_get_values")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT) :: nvalues
            integer(C_INT), intent(OUT) :: values(*)
        end subroutine get_values
    end interface
    ! end get_values

    ! ----------------------------------------
    ! Function:  void get_values2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg1 +dimension(3)+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int *arg2 +dimension(3)+intent(out)
    ! Statement: f_out_native*
    ! start get_values2
    interface
        subroutine get_values2(arg1, arg2) &
                bind(C, name="POI_get_values2")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT) :: arg1(*)
            integer(C_INT), intent(OUT) :: arg2(*)
        end subroutine get_values2
    end interface
    ! end get_values2

    ! ----------------------------------------
    ! Function:  void iota_dimension
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int nvar
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *values +dimension(nvar)+intent(out)
    ! Statement: f_out_native*
    ! start iota_dimension
    interface
        subroutine iota_dimension(nvar, values) &
                bind(C, name="POI_iota_dimension")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: nvar
            integer(C_INT), intent(OUT) :: values(*)
        end subroutine iota_dimension
    end interface
    ! end iota_dimension

    ! ----------------------------------------
    ! Function:  void Sum
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  int len +implied(size(values))
    ! Statement: c_in_native
    ! ----------------------------------------
    ! Argument:  const int *values +rank(1)
    ! Statement: c_in_native*
    ! ----------------------------------------
    ! Argument:  int *result +intent(out)
    ! Statement: c_out_native*
    ! start c_sum
    interface
        subroutine c_sum(len, values, result) &
                bind(C, name="POI_Sum")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: len
            integer(C_INT), intent(IN) :: values(*)
            integer(C_INT), intent(OUT) :: result
        end subroutine c_sum
    end interface
    ! end c_sum

    ! ----------------------------------------
    ! Function:  void Sum
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int len +implied(size(values))
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  const int *values +rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int *result +intent(out)
    ! Statement: f_out_native*
    ! start c_sum_CFI
    interface
        subroutine c_sum_CFI(len, values, result) &
                bind(C, name="POI_Sum_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: len
            integer(C_INT), intent(IN) :: values(:)
            integer(C_INT), intent(OUT) :: result
        end subroutine c_sum_CFI
    end interface
    ! end c_sum_CFI

    ! ----------------------------------------
    ! Function:  void fillIntArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *out +dimension(3)+intent(out)
    ! Statement: f_out_native*
    ! start fill_int_array
    interface
        subroutine fill_int_array(out) &
                bind(C, name="POI_fillIntArray")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT) :: out(*)
        end subroutine fill_int_array
    end interface
    ! end fill_int_array

    ! ----------------------------------------
    ! Function:  void incrementIntArray
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  int *array +intent(inout)+rank(1)
    ! Statement: c_inout_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(array))
    ! Statement: c_in_native
    ! start c_increment_int_array
    interface
        subroutine c_increment_int_array(array, sizein) &
                bind(C, name="POI_incrementIntArray")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(INOUT) :: array(*)
            integer(C_INT), value, intent(IN) :: sizein
        end subroutine c_increment_int_array
    end interface
    ! end c_increment_int_array

    ! ----------------------------------------
    ! Function:  void incrementIntArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *array +intent(inout)+rank(1)
    ! Statement: f_inout_native*_cfi
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(array))
    ! Statement: f_in_native
    ! start c_increment_int_array_CFI
    interface
        subroutine c_increment_int_array_CFI(array, sizein) &
                bind(C, name="POI_incrementIntArray_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(INOUT) :: array(:)
            integer(C_INT), value, intent(IN) :: sizein
        end subroutine c_increment_int_array_CFI
    end interface
    ! end c_increment_int_array_CFI

    ! ----------------------------------------
    ! Function:  void fill_with_zeros
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  double *x +rank(1)
    ! Statement: c_inout_native*
    ! ----------------------------------------
    ! Argument:  int x_length +implied(size(x))
    ! Statement: c_in_native
    ! start c_fill_with_zeros
    interface
        subroutine c_fill_with_zeros(x, x_length) &
                bind(C, name="POI_fill_with_zeros")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(INOUT) :: x(*)
            integer(C_INT), value, intent(IN) :: x_length
        end subroutine c_fill_with_zeros
    end interface
    ! end c_fill_with_zeros

    ! ----------------------------------------
    ! Function:  void fill_with_zeros
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *x +rank(1)
    ! Statement: f_inout_native*_cfi
    ! ----------------------------------------
    ! Argument:  int x_length +implied(size(x))
    ! Statement: f_in_native
    ! start c_fill_with_zeros_CFI
    interface
        subroutine c_fill_with_zeros_CFI(x, x_length) &
                bind(C, name="POI_fill_with_zeros_CFI")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(INOUT) :: x(:)
            integer(C_INT), value, intent(IN) :: x_length
        end subroutine c_fill_with_zeros_CFI
    end interface
    ! end c_fill_with_zeros_CFI

    ! ----------------------------------------
    ! Function:  int accumulate
    ! Statement: c_function_native
    ! ----------------------------------------
    ! Argument:  const int *arr +rank(1)
    ! Statement: c_in_native*
    ! ----------------------------------------
    ! Argument:  size_t len +implied(size(arr))
    ! Statement: c_in_native
    ! start c_accumulate
    interface
        function c_accumulate(arr, len) &
                result(SHT_rv) &
                bind(C, name="POI_accumulate")
            use iso_c_binding, only : C_INT, C_SIZE_T
            implicit none
            integer(C_INT), intent(IN) :: arr(*)
            integer(C_SIZE_T), value, intent(IN) :: len
            integer(C_INT) :: SHT_rv
        end function c_accumulate
    end interface
    ! end c_accumulate

    ! ----------------------------------------
    ! Function:  int accumulate
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const int *arr +rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  size_t len +implied(size(arr))
    ! Statement: f_in_native
    ! start c_accumulate_CFI
    interface
        function c_accumulate_CFI(arr, len) &
                result(SHT_rv) &
                bind(C, name="POI_accumulate_CFI")
            use iso_c_binding, only : C_INT, C_SIZE_T
            implicit none
            integer(C_INT), intent(IN) :: arr(:)
            integer(C_SIZE_T), value, intent(IN) :: len
            integer(C_INT) :: SHT_rv
        end function c_accumulate_CFI
    end interface
    ! end c_accumulate_CFI

    ! ----------------------------------------
    ! Function:  int acceptCharArrayIn
    ! Statement: c_function_native
    ! ----------------------------------------
    ! Argument:  char **names +intent(in)
    ! Statement: c_in_char**
    ! start c_accept_char_array_in
    interface
        function c_accept_char_array_in(names) &
                result(SHT_rv) &
                bind(C, name="POI_acceptCharArrayIn")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(IN) :: names(*)
            integer(C_INT) :: SHT_rv
        end function c_accept_char_array_in
    end interface
    ! end c_accept_char_array_in

    ! ----------------------------------------
    ! Function:  int acceptCharArrayIn
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  char **names +intent(in)
    ! Statement: f_in_char**_cfi
    ! start accept_char_array_in
    interface
        function accept_char_array_in(names) &
                result(SHT_rv) &
                bind(C, name="POI_acceptCharArrayIn_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            character(len=*), intent(IN) :: names(:)
            integer(C_INT) :: SHT_rv
        end function accept_char_array_in
    end interface
    ! end accept_char_array_in

    ! ----------------------------------------
    ! Function:  void setGlobalInt
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int value
    ! Statement: f_in_native
    ! start set_global_int
    interface
        subroutine set_global_int(value) &
                bind(C, name="POI_setGlobalInt")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: value
        end subroutine set_global_int
    end interface
    ! end set_global_int

    ! ----------------------------------------
    ! Function:  int sumFixedArray
    ! Statement: f_function_native
    ! start sum_fixed_array
    interface
        function sum_fixed_array() &
                result(SHT_rv) &
                bind(C, name="POI_sumFixedArray")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT) :: SHT_rv
        end function sum_fixed_array
    end interface
    ! end sum_fixed_array

    ! ----------------------------------------
    ! Function:  void getPtrToScalar
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +intent(out)
    ! Statement: c_out_native**
    ! start c_get_ptr_to_scalar
    interface
        subroutine c_get_ptr_to_scalar(nitems) &
                bind(C, name="POI_getPtrToScalar")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: nitems
        end subroutine c_get_ptr_to_scalar
    end interface
    ! end c_get_ptr_to_scalar

    ! ----------------------------------------
    ! Function:  void getPtrToScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_scalar
    interface
        subroutine get_ptr_to_scalar(nitems) &
                bind(C, name="POI_getPtrToScalar_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: nitems
        end subroutine get_ptr_to_scalar
    end interface
    ! end get_ptr_to_scalar

    ! ----------------------------------------
    ! Function:  void getPtrToFixedArray
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(10)+intent(out)
    ! Statement: c_out_native**
    ! start c_get_ptr_to_fixed_array
    interface
        subroutine c_get_ptr_to_fixed_array(count) &
                bind(C, name="POI_getPtrToFixedArray")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: count
        end subroutine c_get_ptr_to_fixed_array
    end interface
    ! end c_get_ptr_to_fixed_array

    ! ----------------------------------------
    ! Function:  void getPtrToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(10)+intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_fixed_array
    interface
        subroutine get_ptr_to_fixed_array(count) &
                bind(C, name="POI_getPtrToFixedArray_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: count(:)
        end subroutine get_ptr_to_fixed_array
    end interface
    ! end get_ptr_to_fixed_array

    ! ----------------------------------------
    ! Function:  void getPtrToDynamicArray
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(ncount)+intent(out)
    ! Statement: c_out_native**
    ! ----------------------------------------
    ! Argument:  int *ncount +hidden+intent(out)
    ! Statement: c_out_native*
    ! start c_get_ptr_to_dynamic_array
    interface
        subroutine c_get_ptr_to_dynamic_array(count, ncount) &
                bind(C, name="POI_getPtrToDynamicArray")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: count
            integer(C_INT), intent(OUT) :: ncount
        end subroutine c_get_ptr_to_dynamic_array
    end interface
    ! end c_get_ptr_to_dynamic_array

    ! ----------------------------------------
    ! Function:  void getPtrToDynamicArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(ncount)+intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_dynamic_array
    interface
        subroutine get_ptr_to_dynamic_array(count) &
                bind(C, name="POI_getPtrToDynamicArray_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: count(:)
        end subroutine get_ptr_to_dynamic_array
    end interface
    ! end get_ptr_to_dynamic_array

    ! ----------------------------------------
    ! Function:  void getPtrToFuncArray
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(getLen())+intent(out)
    ! Statement: c_out_native**
    ! start c_get_ptr_to_func_array
    interface
        subroutine c_get_ptr_to_func_array(count) &
                bind(C, name="POI_getPtrToFuncArray")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: count
        end subroutine c_get_ptr_to_func_array
    end interface
    ! end c_get_ptr_to_func_array

    ! ----------------------------------------
    ! Function:  void getPtrToFuncArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(getLen())+intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_func_array
    interface
        subroutine get_ptr_to_func_array(count) &
                bind(C, name="POI_getPtrToFuncArray_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: count(:)
        end subroutine get_ptr_to_func_array
    end interface
    ! end get_ptr_to_func_array

    ! ----------------------------------------
    ! Function:  void getPtrToConstScalar
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  const int **nitems +intent(out)
    ! Statement: c_out_native**
    ! start c_get_ptr_to_const_scalar
    interface
        subroutine c_get_ptr_to_const_scalar(nitems) &
                bind(C, name="POI_getPtrToConstScalar")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: nitems
        end subroutine c_get_ptr_to_const_scalar
    end interface
    ! end c_get_ptr_to_const_scalar

    ! ----------------------------------------
    ! Function:  void getPtrToConstScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **nitems +intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_const_scalar
    interface
        subroutine get_ptr_to_const_scalar(nitems) &
                bind(C, name="POI_getPtrToConstScalar_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: nitems
        end subroutine get_ptr_to_const_scalar
    end interface
    ! end get_ptr_to_const_scalar

    ! ----------------------------------------
    ! Function:  void getPtrToFixedConstArray
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  const int **count +dimension(10)+intent(out)
    ! Statement: c_out_native**
    ! start c_get_ptr_to_fixed_const_array
    interface
        subroutine c_get_ptr_to_fixed_const_array(count) &
                bind(C, name="POI_getPtrToFixedConstArray")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: count
        end subroutine c_get_ptr_to_fixed_const_array
    end interface
    ! end c_get_ptr_to_fixed_const_array

    ! ----------------------------------------
    ! Function:  void getPtrToFixedConstArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **count +dimension(10)+intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_fixed_const_array
    interface
        subroutine get_ptr_to_fixed_const_array(count) &
                bind(C, name="POI_getPtrToFixedConstArray_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: count(:)
        end subroutine get_ptr_to_fixed_const_array
    end interface
    ! end get_ptr_to_fixed_const_array

    ! ----------------------------------------
    ! Function:  void getPtrToDynamicConstArray
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  const int **count +dimension(ncount)+intent(out)
    ! Statement: c_out_native**
    ! ----------------------------------------
    ! Argument:  int *ncount +hidden+intent(out)
    ! Statement: c_out_native*
    ! start c_get_ptr_to_dynamic_const_array
    interface
        subroutine c_get_ptr_to_dynamic_const_array(count, ncount) &
                bind(C, name="POI_getPtrToDynamicConstArray")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: count
            integer(C_INT), intent(OUT) :: ncount
        end subroutine c_get_ptr_to_dynamic_const_array
    end interface
    ! end c_get_ptr_to_dynamic_const_array

    ! ----------------------------------------
    ! Function:  void getPtrToDynamicConstArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **count +dimension(ncount)+intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_dynamic_const_array
    interface
        subroutine get_ptr_to_dynamic_const_array(count) &
                bind(C, name="POI_getPtrToDynamicConstArray_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: count(:)
        end subroutine get_ptr_to_dynamic_const_array
    end interface
    ! end get_ptr_to_dynamic_const_array

    ! ----------------------------------------
    ! Function:  void getRawPtrToScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    ! start get_raw_ptr_to_scalar
    interface
        subroutine get_raw_ptr_to_scalar(nitems) &
                bind(C, name="POI_getRawPtrToScalar")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: nitems
        end subroutine get_raw_ptr_to_scalar
    end interface
    ! end get_raw_ptr_to_scalar

    ! ----------------------------------------
    ! Function:  void getRawPtrToScalarForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    ! start c_get_raw_ptr_to_scalar_force
    interface
        subroutine c_get_raw_ptr_to_scalar_force(nitems) &
                bind(C, name="POI_getRawPtrToScalarForce")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: nitems
        end subroutine c_get_raw_ptr_to_scalar_force
    end interface
    ! end c_get_raw_ptr_to_scalar_force

    ! ----------------------------------------
    ! Function:  void getRawPtrToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    ! start get_raw_ptr_to_fixed_array
    interface
        subroutine get_raw_ptr_to_fixed_array(count) &
                bind(C, name="POI_getRawPtrToFixedArray")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: count
        end subroutine get_raw_ptr_to_fixed_array
    end interface
    ! end get_raw_ptr_to_fixed_array

    ! ----------------------------------------
    ! Function:  void getRawPtrToFixedArrayForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    ! start c_get_raw_ptr_to_fixed_array_force
    interface
        subroutine c_get_raw_ptr_to_fixed_array_force(count) &
                bind(C, name="POI_getRawPtrToFixedArrayForce")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: count
        end subroutine c_get_raw_ptr_to_fixed_array_force
    end interface
    ! end c_get_raw_ptr_to_fixed_array_force

    ! ----------------------------------------
    ! Function:  void getRawPtrToInt2d
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int ***arg +intent(out)
    ! Statement: f_out_native***
    ! start get_raw_ptr_to_int2d
    interface
        subroutine get_raw_ptr_to_int2d(arg) &
                bind(C, name="POI_getRawPtrToInt2d")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: arg
        end subroutine get_raw_ptr_to_int2d
    end interface
    ! end get_raw_ptr_to_int2d

    ! ----------------------------------------
    ! Function:  int checkInt2d
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int **arg +intent(in)
    ! Statement: f_in_native**
    ! start check_int2d
    interface
        function check_int2d(arg) &
                result(SHT_rv) &
                bind(C, name="POI_checkInt2d")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(IN), value :: arg
            integer(C_INT) :: SHT_rv
        end function check_int2d
    end interface
    ! end check_int2d

    ! ----------------------------------------
    ! Function:  void DimensionIn
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *arg +dimension(10,20)
    ! Statement: f_in_native*
    ! start c_dimension_in
    interface
        subroutine c_dimension_in(arg) &
                bind(C, name="POI_DimensionIn")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: arg(*)
        end subroutine c_dimension_in
    end interface
    ! end c_dimension_in

    ! ----------------------------------------
    ! Function:  void getAllocToFixedArray
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(allocatable)+dimension(10)+intent(out)
    ! Statement: c_out_native**
    ! start c_get_alloc_to_fixed_array
    interface
        subroutine c_get_alloc_to_fixed_array(count) &
                bind(C, name="POI_getAllocToFixedArray")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: count
        end subroutine c_get_alloc_to_fixed_array
    end interface
    ! end c_get_alloc_to_fixed_array

    ! ----------------------------------------
    ! Function:  void getAllocToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(allocatable)+dimension(10)+intent(out)
    ! Statement: f_out_native**_cfi_allocatable
    ! start get_alloc_to_fixed_array
    interface
        subroutine get_alloc_to_fixed_array(count) &
                bind(C, name="POI_getAllocToFixedArray_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), allocatable :: count(:)
        end subroutine get_alloc_to_fixed_array
    end interface
    ! end get_alloc_to_fixed_array

    ! ----------------------------------------
    ! Function:  void *returnAddress1
    ! Statement: f_function_void*
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    ! start return_address1
    interface
        function return_address1(flag) &
                result(SHT_rv) &
                bind(C, name="POI_returnAddress1")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), value, intent(IN) :: flag
            type(C_PTR) :: SHT_rv
        end function return_address1
    end interface
    ! end return_address1

    ! ----------------------------------------
    ! Function:  void *returnAddress2
    ! Statement: f_function_void*
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    ! start c_return_address2
    interface
        function c_return_address2(flag) &
                result(SHT_rv) &
                bind(C, name="POI_returnAddress2")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), value, intent(IN) :: flag
            type(C_PTR) :: SHT_rv
        end function c_return_address2
    end interface
    ! end c_return_address2

    ! ----------------------------------------
    ! Function:  void fetchVoidPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **addr +intent(out)
    ! Statement: f_out_void**
    ! start fetch_void_ptr
    interface
        subroutine fetch_void_ptr(addr) &
                bind(C, name="POI_fetchVoidPtr")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: addr
        end subroutine fetch_void_ptr
    end interface
    ! end fetch_void_ptr

    ! ----------------------------------------
    ! Function:  void updateVoidPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **addr +intent(inout)
    ! Statement: f_inout_void**
    ! start c_update_void_ptr
    interface
        subroutine c_update_void_ptr(addr) &
                bind(C, name="POI_updateVoidPtr")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(INOUT) :: addr
        end subroutine c_update_void_ptr
    end interface
    ! end c_update_void_ptr

    ! ----------------------------------------
    ! Function:  int VoidPtrArray
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void **addr +rank(1)
    ! Statement: f_in_void**_cfi
    ! start c_void_ptr_array
    interface
        function c_void_ptr_array(addr) &
                result(SHT_rv) &
                bind(C, name="POI_VoidPtrArray")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(IN) :: addr(*)
            integer(C_INT) :: SHT_rv
        end function c_void_ptr_array
    end interface
    ! end c_void_ptr_array

    ! ----------------------------------------
    ! Function:  int *returnIntPtrToScalar
    ! Statement: c_function_native*
    ! start c_return_int_ptr_to_scalar
    interface
        function c_return_int_ptr_to_scalar() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntPtrToScalar")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_to_scalar
    end interface
    ! end c_return_int_ptr_to_scalar

    ! ----------------------------------------
    ! Function:  int *returnIntPtrToScalar
    ! Statement: f_function_native*_cfi_pointer
    ! start c_return_int_ptr_to_scalar_CFI
    interface
        subroutine c_return_int_ptr_to_scalar_CFI(SHT_rv) &
                bind(C, name="POI_returnIntPtrToScalar_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: SHT_rv
        end subroutine c_return_int_ptr_to_scalar_CFI
    end interface
    ! end c_return_int_ptr_to_scalar_CFI

    ! ----------------------------------------
    ! Function:  int *returnIntPtrToFixedArray +dimension(10)
    ! Statement: c_function_native*
    ! start c_return_int_ptr_to_fixed_array
    interface
        function c_return_int_ptr_to_fixed_array() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntPtrToFixedArray")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_to_fixed_array
    end interface
    ! end c_return_int_ptr_to_fixed_array

    ! ----------------------------------------
    ! Function:  int *returnIntPtrToFixedArray +dimension(10)
    ! Statement: f_function_native*_cfi_pointer
    ! start c_return_int_ptr_to_fixed_array_CFI
    interface
        subroutine c_return_int_ptr_to_fixed_array_CFI(SHT_rv) &
                bind(C, name="POI_returnIntPtrToFixedArray_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: SHT_rv(:)
        end subroutine c_return_int_ptr_to_fixed_array_CFI
    end interface
    ! end c_return_int_ptr_to_fixed_array_CFI

    ! ----------------------------------------
    ! Function:  const int *returnIntPtrToConstScalar
    ! Statement: c_function_native*
    ! start c_return_int_ptr_to_const_scalar
    interface
        function c_return_int_ptr_to_const_scalar() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntPtrToConstScalar")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_to_const_scalar
    end interface
    ! end c_return_int_ptr_to_const_scalar

    ! ----------------------------------------
    ! Function:  const int *returnIntPtrToConstScalar
    ! Statement: f_function_native*_cfi_pointer
    ! start c_return_int_ptr_to_const_scalar_CFI
    interface
        subroutine c_return_int_ptr_to_const_scalar_CFI(SHT_rv) &
                bind(C, name="POI_returnIntPtrToConstScalar_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: SHT_rv
        end subroutine c_return_int_ptr_to_const_scalar_CFI
    end interface
    ! end c_return_int_ptr_to_const_scalar_CFI

    ! ----------------------------------------
    ! Function:  const int *returnIntPtrToFixedConstArray +dimension(10)
    ! Statement: c_function_native*
    ! start c_return_int_ptr_to_fixed_const_array
    interface
        function c_return_int_ptr_to_fixed_const_array() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntPtrToFixedConstArray")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_to_fixed_const_array
    end interface
    ! end c_return_int_ptr_to_fixed_const_array

    ! ----------------------------------------
    ! Function:  const int *returnIntPtrToFixedConstArray +dimension(10)
    ! Statement: f_function_native*_cfi_pointer
    ! start c_return_int_ptr_to_fixed_const_array_CFI
    interface
        subroutine c_return_int_ptr_to_fixed_const_array_CFI(SHT_rv) &
                bind(C, name="POI_returnIntPtrToFixedConstArray_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), pointer :: SHT_rv(:)
        end subroutine c_return_int_ptr_to_fixed_const_array_CFI
    end interface
    ! end c_return_int_ptr_to_fixed_const_array_CFI

    ! ----------------------------------------
    ! Function:  int *returnIntScalar +deref(scalar)
    ! Statement: c_function_native*
    ! start c_return_int_scalar
    interface
        function c_return_int_scalar() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntScalar")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_scalar
    end interface
    ! end c_return_int_scalar

    ! ----------------------------------------
    ! Function:  int *returnIntScalar +deref(scalar)
    ! Statement: f_function_native*_scalar
    ! start return_int_scalar
    interface
        function return_int_scalar() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntScalar_bufferify")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT) :: SHT_rv
        end function return_int_scalar
    end interface
    ! end return_int_scalar

    ! ----------------------------------------
    ! Function:  int *returnIntRaw +deref(raw)
    ! Statement: f_function_native*_raw
    ! start return_int_raw
    interface
        function return_int_raw() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntRaw")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function return_int_raw
    end interface
    ! end return_int_raw

    ! ----------------------------------------
    ! Function:  int *returnIntRawWithArgs +deref(raw)
    ! Statement: c_function_native*
    ! ----------------------------------------
    ! Argument:  const char *name
    ! Statement: c_in_char*
    ! start c_return_int_raw_with_args
    interface
        function c_return_int_raw_with_args(name) &
                result(SHT_rv) &
                bind(C, name="POI_returnIntRawWithArgs")
            use iso_c_binding, only : C_CHAR, C_PTR
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            type(C_PTR) :: SHT_rv
        end function c_return_int_raw_with_args
    end interface
    ! end c_return_int_raw_with_args

    ! ----------------------------------------
    ! Function:  int *returnIntRawWithArgs +deref(raw)
    ! Statement: f_function_native*_raw
    ! ----------------------------------------
    ! Argument:  const char *name
    ! Statement: f_in_char*_cfi
    ! start return_int_raw_with_args
    interface
        function return_int_raw_with_args(name) &
                result(SHT_rv) &
                bind(C, name="POI_returnIntRawWithArgs_CFI")
            use iso_c_binding, only : C_PTR
            implicit none
            character(len=*), intent(IN) :: name
            type(C_PTR) :: SHT_rv
        end function return_int_raw_with_args
    end interface
    ! end return_int_raw_with_args

    ! ----------------------------------------
    ! Function:  int **returnRawPtrToInt2d
    ! Statement: f_function_native**
    ! start c_return_raw_ptr_to_int2d
    interface
        function c_return_raw_ptr_to_int2d() &
                result(SHT_rv) &
                bind(C, name="POI_returnRawPtrToInt2d")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_raw_ptr_to_int2d
    end interface
    ! end c_return_raw_ptr_to_int2d

    ! ----------------------------------------
    ! Function:  int *returnIntAllocToFixedArray +deref(allocatable)+dimension(10)
    ! Statement: c_function_native*
    ! start c_return_int_alloc_to_fixed_array
    interface
        function c_return_int_alloc_to_fixed_array() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntAllocToFixedArray")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_alloc_to_fixed_array
    end interface
    ! end c_return_int_alloc_to_fixed_array

    ! ----------------------------------------
    ! Function:  int *returnIntAllocToFixedArray +deref(allocatable)+dimension(10)
    ! Statement: f_function_native*_cfi_allocatable
    ! start c_return_int_alloc_to_fixed_array_CFI
    interface
        subroutine c_return_int_alloc_to_fixed_array_CFI(SHT_rv) &
                bind(C, name="POI_returnIntAllocToFixedArray_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT), allocatable :: SHT_rv(:)
        end subroutine c_return_int_alloc_to_fixed_array_CFI
    end interface
    ! end c_return_int_alloc_to_fixed_array_CFI

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void intargs_in
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *arg
    ! Statement: f_in_native*
    ! start intargs_in
    subroutine intargs_in(arg)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: arg
        ! splicer begin function.intargs_in
        call c_intargs_in(arg)
        ! splicer end function.intargs_in
    end subroutine intargs_in
    ! end intargs_in
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void intargs_inout
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg
    ! Statement: f_inout_native*
    !>
    !! Argument is modified by library, defaults to intent(inout).
    !<
    ! start intargs_inout
    subroutine intargs_inout(arg)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(INOUT) :: arg
        ! splicer begin function.intargs_inout
        call c_intargs_inout(arg)
        ! splicer end function.intargs_inout
    end subroutine intargs_inout
    ! end intargs_inout
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void intargs_out
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg +intent(out)
    ! Statement: f_out_native*
    ! start intargs_out
    subroutine intargs_out(arg)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT) :: arg
        ! splicer begin function.intargs_out
        call c_intargs_out(arg)
        ! splicer end function.intargs_out
    end subroutine intargs_out
    ! end intargs_out
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void intargs
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int argin +intent(in)
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *arginout +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *argout +intent(out)
    ! Statement: f_out_native*
    ! start intargs
    subroutine intargs(argin, arginout, argout)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: argin
        integer(C_INT), intent(INOUT) :: arginout
        integer(C_INT), intent(OUT) :: argout
        ! splicer begin function.intargs
        call c_intargs(argin, arginout, argout)
        ! splicer end function.intargs
    end subroutine intargs
    ! end intargs
#endif

    ! ----------------------------------------
    ! Function:  void cos_doubles
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  double *out +dimension(size(in))+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: c_default
    !>
    !! \brief compute cos of IN and save in OUT
    !!
    !! allocate OUT same type as IN implied size of array
    !<
    ! start cos_doubles
    subroutine cos_doubles(in, out)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), intent(IN) :: in(:)
        real(C_DOUBLE), intent(OUT) :: out(:)
        integer(C_INT) :: SH_sizein
        ! splicer begin function.cos_doubles
        SH_sizein = size(in,kind=C_INT)
        call c_cos_doubles_CFI(in, out, SH_sizein)
        ! splicer end function.cos_doubles
    end subroutine cos_doubles
    ! end cos_doubles

    ! ----------------------------------------
    ! Function:  void truncate_to_int
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int *out +dimension(size(in))+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: c_default
    !>
    !! \brief truncate IN argument and save in OUT
    !!
    !! allocate OUT different type as IN
    !! implied size of array
    !<
    ! start truncate_to_int
    subroutine truncate_to_int(in, out)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), intent(IN) :: in(:)
        integer(C_INT), intent(OUT) :: out(:)
        integer(C_INT) :: SH_sizein
        ! splicer begin function.truncate_to_int
        SH_sizein = size(in,kind=C_INT)
        call c_truncate_to_int_CFI(in, out, SH_sizein)
        ! splicer end function.truncate_to_int
    end subroutine truncate_to_int
    ! end truncate_to_int

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void get_values
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *nvalues +intent(OUT)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int *values +dimension(3)+intent(out)
    ! Statement: f_out_native*
    !>
    !! \brief fill values into array
    !!
    !! The function knows how long the array must be.
    !! Fortran will treat the dimension as assumed-length.
    !! The Python wrapper will create a NumPy array or list so it must
    !! have an explicit dimension (not assumed-length).
    !<
    ! start get_values
    subroutine get_values(nvalues, values)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT) :: nvalues
        integer(C_INT), intent(OUT) :: values(3)
        ! splicer begin function.get_values
        call c_get_values(nvalues, values)
        ! splicer end function.get_values
    end subroutine get_values
    ! end get_values
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void get_values2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg1 +dimension(3)+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int *arg2 +dimension(3)+intent(out)
    ! Statement: f_out_native*
    !>
    !! \brief fill values into two arrays
    !!
    !! Test two intent(out) arguments.
    !! Make sure error handling works with C++.
    !<
    ! start get_values2
    subroutine get_values2(arg1, arg2)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT) :: arg1(3)
        integer(C_INT), intent(OUT) :: arg2(3)
        ! splicer begin function.get_values2
        call c_get_values2(arg1, arg2)
        ! splicer end function.get_values2
    end subroutine get_values2
    ! end get_values2
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void iota_dimension
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int nvar
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *values +dimension(nvar)+intent(out)
    ! Statement: f_out_native*
    ! start iota_dimension
    subroutine iota_dimension(nvar, values)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: nvar
        integer(C_INT), intent(OUT) :: values(nvar)
        ! splicer begin function.iota_dimension
        call c_iota_dimension(nvar, values)
        ! splicer end function.iota_dimension
    end subroutine iota_dimension
    ! end iota_dimension
#endif

    ! ----------------------------------------
    ! Function:  void Sum
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int len +implied(size(values))
    ! Statement: c_default
    ! ----------------------------------------
    ! Argument:  const int *values +rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int *result +intent(out)
    ! Statement: f_out_native*
    ! start sum
    subroutine sum(values, result)
        use iso_c_binding, only : C_INT
        integer(C_INT) :: SH_len
        integer(C_INT), intent(IN) :: values(:)
        integer(C_INT), intent(OUT) :: result
        ! splicer begin function.sum
        SH_len = size(values,kind=C_INT)
        call c_sum_CFI(SH_len, values, result)
        ! splicer end function.sum
    end subroutine sum
    ! end sum

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void fillIntArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *out +dimension(3)+intent(out)
    ! Statement: f_out_native*
    !>
    !! Return three values into memory the user provides.
    !<
    ! start fill_int_array
    subroutine fill_int_array(out)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT) :: out(3)
        ! splicer begin function.fill_int_array
        call c_fill_int_array(out)
        ! splicer end function.fill_int_array
    end subroutine fill_int_array
    ! end fill_int_array
#endif

    ! ----------------------------------------
    ! Function:  void incrementIntArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *array +intent(inout)+rank(1)
    ! Statement: f_inout_native*_cfi
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(array))
    ! Statement: c_default
    !>
    !! Increment array in place using intent(INOUT).
    !<
    ! start increment_int_array
    subroutine increment_int_array(array)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(INOUT) :: array(:)
        integer(C_INT) :: SH_sizein
        ! splicer begin function.increment_int_array
        SH_sizein = size(array,kind=C_INT)
        call c_increment_int_array_CFI(array, SH_sizein)
        ! splicer end function.increment_int_array
    end subroutine increment_int_array
    ! end increment_int_array

    ! ----------------------------------------
    ! Function:  void fill_with_zeros
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *x +rank(1)
    ! Statement: f_inout_native*_cfi
    ! ----------------------------------------
    ! Argument:  int x_length +implied(size(x))
    ! Statement: c_default
    ! start fill_with_zeros
    subroutine fill_with_zeros(x)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), intent(INOUT) :: x(:)
        integer(C_INT) :: SH_x_length
        ! splicer begin function.fill_with_zeros
        SH_x_length = size(x,kind=C_INT)
        call c_fill_with_zeros_CFI(x, SH_x_length)
        ! splicer end function.fill_with_zeros
    end subroutine fill_with_zeros
    ! end fill_with_zeros

    ! ----------------------------------------
    ! Function:  int accumulate
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const int *arr +rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  size_t len +implied(size(arr))
    ! Statement: c_default
    ! start accumulate
    function accumulate(arr) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_SIZE_T
        integer(C_INT), intent(IN) :: arr(:)
        integer(C_SIZE_T) :: SH_len
        integer(C_INT) :: SHT_rv
        ! splicer begin function.accumulate
        SH_len = size(arr,kind=C_SIZE_T)
        SHT_rv = c_accumulate_CFI(arr, SH_len)
        ! splicer end function.accumulate
    end function accumulate
    ! end accumulate

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int acceptCharArrayIn
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  char **names +intent(in)
    ! Statement: f_in_char**_cfi
    !>
    !! Return strlen of the first index as a check.
    !<
    ! start accept_char_array_in
    function accept_char_array_in(names) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        character(len=*), intent(IN) :: names(:)
        integer(C_INT) :: SHT_rv
        ! splicer begin function.accept_char_array_in
        SHT_rv = c_accept_char_array_in_CFI(names)
        ! splicer end function.accept_char_array_in
    end function accept_char_array_in
    ! end accept_char_array_in
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void setGlobalInt
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int value
    ! Statement: f_in_native
    ! start set_global_int
    subroutine set_global_int(value)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: value
        ! splicer begin function.set_global_int
        call c_set_global_int(value)
        ! splicer end function.set_global_int
    end subroutine set_global_int
    ! end set_global_int
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int sumFixedArray
    ! Statement: f_function_native
    !>
    !! Used to test values global_array.
    !<
    ! start sum_fixed_array
    function sum_fixed_array() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT) :: SHT_rv
        ! splicer begin function.sum_fixed_array
        SHT_rv = c_sum_fixed_array()
        ! splicer end function.sum_fixed_array
    end function sum_fixed_array
    ! end sum_fixed_array
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getPtrToScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_scalar
    subroutine get_ptr_to_scalar(nitems)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT), pointer :: nitems
        ! splicer begin function.get_ptr_to_scalar
        call c_get_ptr_to_scalar_CFI(nitems)
        ! splicer end function.get_ptr_to_scalar
    end subroutine get_ptr_to_scalar
    ! end get_ptr_to_scalar
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getPtrToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(10)+intent(out)
    ! Statement: f_out_native**_cfi_pointer
    !>
    !! Return a Fortran pointer to an array which is always the same length.
    !<
    ! start get_ptr_to_fixed_array
    subroutine get_ptr_to_fixed_array(count)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT), pointer :: count(:)
        ! splicer begin function.get_ptr_to_fixed_array
        call c_get_ptr_to_fixed_array_CFI(count)
        ! splicer end function.get_ptr_to_fixed_array
    end subroutine get_ptr_to_fixed_array
    ! end get_ptr_to_fixed_array
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getPtrToDynamicArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(ncount)+intent(out)
    ! Statement: f_out_native**_cfi_pointer
    !>
    !! Return a Fortran pointer to an array which is the length of
    !! the argument ncount.
    !<
    ! start get_ptr_to_dynamic_array
    subroutine get_ptr_to_dynamic_array(count)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT), pointer :: count(:)
        ! splicer begin function.get_ptr_to_dynamic_array
        call c_get_ptr_to_dynamic_array_CFI(count)
        ! splicer end function.get_ptr_to_dynamic_array
    end subroutine get_ptr_to_dynamic_array
    ! end get_ptr_to_dynamic_array
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getPtrToFuncArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(getLen())+intent(out)
    ! Statement: f_out_native**_cfi_pointer
    !>
    !! Return a Fortran pointer to an array which is the length
    !! is computed by C++ function getLen.
    !! getLen will be called from C/C++ to compute the shape.
    !<
    ! start get_ptr_to_func_array
    subroutine get_ptr_to_func_array(count)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT), pointer :: count(:)
        ! splicer begin function.get_ptr_to_func_array
        call c_get_ptr_to_func_array_CFI(count)
        ! splicer end function.get_ptr_to_func_array
    end subroutine get_ptr_to_func_array
    ! end get_ptr_to_func_array
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getPtrToConstScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **nitems +intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_const_scalar
    subroutine get_ptr_to_const_scalar(nitems)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT), pointer :: nitems
        ! splicer begin function.get_ptr_to_const_scalar
        call c_get_ptr_to_const_scalar_CFI(nitems)
        ! splicer end function.get_ptr_to_const_scalar
    end subroutine get_ptr_to_const_scalar
    ! end get_ptr_to_const_scalar
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getPtrToFixedConstArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **count +dimension(10)+intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_fixed_const_array
    subroutine get_ptr_to_fixed_const_array(count)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT), pointer :: count(:)
        ! splicer begin function.get_ptr_to_fixed_const_array
        call c_get_ptr_to_fixed_const_array_CFI(count)
        ! splicer end function.get_ptr_to_fixed_const_array
    end subroutine get_ptr_to_fixed_const_array
    ! end get_ptr_to_fixed_const_array
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getPtrToDynamicConstArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **count +dimension(ncount)+intent(out)
    ! Statement: f_out_native**_cfi_pointer
    ! start get_ptr_to_dynamic_const_array
    subroutine get_ptr_to_dynamic_const_array(count)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT), pointer :: count(:)
        ! splicer begin function.get_ptr_to_dynamic_const_array
        call c_get_ptr_to_dynamic_const_array_CFI(count)
        ! splicer end function.get_ptr_to_dynamic_const_array
    end subroutine get_ptr_to_dynamic_const_array
    ! end get_ptr_to_dynamic_const_array
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getRawPtrToScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    !>
    !! Called directly via an interface in Fortran.
    !<
    ! start get_raw_ptr_to_scalar
    subroutine get_raw_ptr_to_scalar(nitems)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: nitems
        ! splicer begin function.get_raw_ptr_to_scalar
        call c_get_raw_ptr_to_scalar(nitems)
        ! splicer end function.get_raw_ptr_to_scalar
    end subroutine get_raw_ptr_to_scalar
    ! end get_raw_ptr_to_scalar
#endif

    ! ----------------------------------------
    ! Function:  void getRawPtrToScalarForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    !>
    !! Create a Fortran wrapper.
    !<
    ! start get_raw_ptr_to_scalar_force
    subroutine get_raw_ptr_to_scalar_force(nitems)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: nitems
        ! splicer begin function.get_raw_ptr_to_scalar_force
        call c_get_raw_ptr_to_scalar_force(nitems)
        ! splicer end function.get_raw_ptr_to_scalar_force
    end subroutine get_raw_ptr_to_scalar_force
    ! end get_raw_ptr_to_scalar_force

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getRawPtrToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    !>
    !! Return a type(C_PTR) to an array which is always the same length.
    !! Called directly via an interface in Fortran.
    !! # Uses +deref(raw) instead of +dimension(10) like getPtrToFixedArray.
    !<
    ! start get_raw_ptr_to_fixed_array
    subroutine get_raw_ptr_to_fixed_array(count)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: count
        ! splicer begin function.get_raw_ptr_to_fixed_array
        call c_get_raw_ptr_to_fixed_array(count)
        ! splicer end function.get_raw_ptr_to_fixed_array
    end subroutine get_raw_ptr_to_fixed_array
    ! end get_raw_ptr_to_fixed_array
#endif

    ! ----------------------------------------
    ! Function:  void getRawPtrToFixedArrayForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    !>
    !! Return a type(C_PTR) to an array which is always the same length.
    !! Create a Fortran wrapper.
    !<
    ! start get_raw_ptr_to_fixed_array_force
    subroutine get_raw_ptr_to_fixed_array_force(count)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: count
        ! splicer begin function.get_raw_ptr_to_fixed_array_force
        call c_get_raw_ptr_to_fixed_array_force(count)
        ! splicer end function.get_raw_ptr_to_fixed_array_force
    end subroutine get_raw_ptr_to_fixed_array_force
    ! end get_raw_ptr_to_fixed_array_force

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getRawPtrToInt2d
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int ***arg +intent(out)
    ! Statement: f_out_native***
    !>
    !! Test multiple layers of indirection.
    !<
    ! start get_raw_ptr_to_int2d
    subroutine get_raw_ptr_to_int2d(arg)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: arg
        ! splicer begin function.get_raw_ptr_to_int2d
        call c_get_raw_ptr_to_int2d(arg)
        ! splicer end function.get_raw_ptr_to_int2d
    end subroutine get_raw_ptr_to_int2d
    ! end get_raw_ptr_to_int2d
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int checkInt2d
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int **arg +intent(in)
    ! Statement: f_in_native**
    !>
    !! Check results of getRawPtrToInt2d.
    !<
    ! start check_int2d
    function check_int2d(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.check_int2d
        SHT_rv = c_check_int2d(arg)
        ! splicer end function.check_int2d
    end function check_int2d
    ! end check_int2d
#endif

    ! ----------------------------------------
    ! Function:  void DimensionIn
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *arg +dimension(10,20)
    ! Statement: f_in_native*
    !>
    !! Test +dimension(10,20) +intent(in) together.
    !! This will not use assumed-shape in the Fortran wrapper.
    !<
    ! start dimension_in
    subroutine dimension_in(arg)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: arg(10,20)
        ! splicer begin function.dimension_in
        call c_dimension_in(arg)
        ! splicer end function.dimension_in
    end subroutine dimension_in
    ! end dimension_in

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getAllocToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(allocatable)+dimension(10)+intent(out)
    ! Statement: f_out_native**_cfi_allocatable
    !>
    !! Return a Fortran pointer to an array which is always the same length.
    !<
    ! start get_alloc_to_fixed_array
    subroutine get_alloc_to_fixed_array(count)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT), allocatable :: count(:)
        ! splicer begin function.get_alloc_to_fixed_array
        call c_get_alloc_to_fixed_array_CFI(count)
        ! splicer end function.get_alloc_to_fixed_array
    end subroutine get_alloc_to_fixed_array
    ! end get_alloc_to_fixed_array
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void *returnAddress1
    ! Statement: f_function_void*
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    ! start return_address1
    function return_address1(flag) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR
        integer(C_INT), value, intent(IN) :: flag
        type(C_PTR) :: SHT_rv
        ! splicer begin function.return_address1
        SHT_rv = c_return_address1(flag)
        ! splicer end function.return_address1
    end function return_address1
    ! end return_address1
#endif

    ! ----------------------------------------
    ! Function:  void *returnAddress2
    ! Statement: f_function_void*
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    ! start return_address2
    function return_address2(flag) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR
        integer(C_INT), value, intent(IN) :: flag
        type(C_PTR) :: SHT_rv
        ! splicer begin function.return_address2
        SHT_rv = c_return_address2(flag)
        ! splicer end function.return_address2
    end function return_address2
    ! end return_address2

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void fetchVoidPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **addr +intent(out)
    ! Statement: f_out_void**
    ! start fetch_void_ptr
    subroutine fetch_void_ptr(addr)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: addr
        ! splicer begin function.fetch_void_ptr
        call c_fetch_void_ptr(addr)
        ! splicer end function.fetch_void_ptr
    end subroutine fetch_void_ptr
    ! end fetch_void_ptr
#endif

    ! ----------------------------------------
    ! Function:  void updateVoidPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **addr +intent(inout)
    ! Statement: f_inout_void**
    ! start update_void_ptr
    subroutine update_void_ptr(addr)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(INOUT) :: addr
        ! splicer begin function.update_void_ptr
        call c_update_void_ptr(addr)
        ! splicer end function.update_void_ptr
    end subroutine update_void_ptr
    ! end update_void_ptr

    ! ----------------------------------------
    ! Function:  int VoidPtrArray
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void **addr +rank(1)
    ! Statement: f_in_void**_cfi
    ! start void_ptr_array
    function void_ptr_array(addr) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR
        type(C_PTR), intent(IN) :: addr(:)
        integer(C_INT) :: SHT_rv
        ! splicer begin function.void_ptr_array
        SHT_rv = c_void_ptr_array(addr)
        ! splicer end function.void_ptr_array
    end function void_ptr_array
    ! end void_ptr_array

    ! ----------------------------------------
    ! Function:  int *returnIntPtrToScalar
    ! Statement: f_function_native*_cfi_pointer
    ! start return_int_ptr_to_scalar
    function return_int_ptr_to_scalar() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), pointer :: SHT_rv
        ! splicer begin function.return_int_ptr_to_scalar
        nullify(SHT_rv)
        call c_return_int_ptr_to_scalar_CFI(SHT_rv)
        ! splicer end function.return_int_ptr_to_scalar
    end function return_int_ptr_to_scalar
    ! end return_int_ptr_to_scalar

    ! ----------------------------------------
    ! Function:  int *returnIntPtrToFixedArray +dimension(10)
    ! Statement: f_function_native*_cfi_pointer
    ! start return_int_ptr_to_fixed_array
    function return_int_ptr_to_fixed_array() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin function.return_int_ptr_to_fixed_array
        nullify(SHT_rv)
        call c_return_int_ptr_to_fixed_array_CFI(SHT_rv)
        ! splicer end function.return_int_ptr_to_fixed_array
    end function return_int_ptr_to_fixed_array
    ! end return_int_ptr_to_fixed_array

    ! ----------------------------------------
    ! Function:  const int *returnIntPtrToConstScalar
    ! Statement: f_function_native*_cfi_pointer
    ! start return_int_ptr_to_const_scalar
    function return_int_ptr_to_const_scalar() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), pointer :: SHT_rv
        ! splicer begin function.return_int_ptr_to_const_scalar
        nullify(SHT_rv)
        call c_return_int_ptr_to_const_scalar_CFI(SHT_rv)
        ! splicer end function.return_int_ptr_to_const_scalar
    end function return_int_ptr_to_const_scalar
    ! end return_int_ptr_to_const_scalar

    ! ----------------------------------------
    ! Function:  const int *returnIntPtrToFixedConstArray +dimension(10)
    ! Statement: f_function_native*_cfi_pointer
    ! start return_int_ptr_to_fixed_const_array
    function return_int_ptr_to_fixed_const_array() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin function.return_int_ptr_to_fixed_const_array
        nullify(SHT_rv)
        call c_return_int_ptr_to_fixed_const_array_CFI(SHT_rv)
        ! splicer end function.return_int_ptr_to_fixed_const_array
    end function return_int_ptr_to_fixed_const_array
    ! end return_int_ptr_to_fixed_const_array

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int *returnIntScalar +deref(scalar)
    ! Statement: f_function_native*_scalar
    ! start return_int_scalar
    function return_int_scalar() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT) :: SHT_rv
        ! splicer begin function.return_int_scalar
        SHT_rv = c_return_int_scalar_bufferify()
        ! splicer end function.return_int_scalar
    end function return_int_scalar
    ! end return_int_scalar
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int *returnIntRaw +deref(raw)
    ! Statement: f_function_native*_raw
    !>
    !! Call directly via interface.
    !<
    ! start return_int_raw
    function return_int_raw() &
            result(SHT_rv)
        use iso_c_binding, only : C_PTR
        type(C_PTR) :: SHT_rv
        ! splicer begin function.return_int_raw
        SHT_rv = c_return_int_raw()
        ! splicer end function.return_int_raw
    end function return_int_raw
    ! end return_int_raw
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int *returnIntRawWithArgs +deref(raw)
    ! Statement: f_function_native*_raw
    ! ----------------------------------------
    ! Argument:  const char *name
    ! Statement: f_in_char*_cfi
    !>
    !! Like returnIntRaw but with another argument to force a wrapper.
    !! Uses fc_statements f_function_native_*_raw.
    !<
    ! start return_int_raw_with_args
    function return_int_raw_with_args(name) &
            result(SHT_rv)
        use iso_c_binding, only : C_PTR
        character(len=*), intent(IN) :: name
        type(C_PTR) :: SHT_rv
        ! splicer begin function.return_int_raw_with_args
        SHT_rv = c_return_int_raw_with_args_CFI(name)
        ! splicer end function.return_int_raw_with_args
    end function return_int_raw_with_args
    ! end return_int_raw_with_args
#endif

    ! ----------------------------------------
    ! Function:  int **returnRawPtrToInt2d
    ! Statement: f_function_native**
    !>
    !! Test multiple layers of indirection.
    !! # getRawPtrToInt2d
    !<
    ! start return_raw_ptr_to_int2d
    function return_raw_ptr_to_int2d() &
            result(SHT_rv)
        use iso_c_binding, only : C_PTR
        type(C_PTR) :: SHT_rv
        ! splicer begin function.return_raw_ptr_to_int2d
        SHT_rv = c_return_raw_ptr_to_int2d()
        ! splicer end function.return_raw_ptr_to_int2d
    end function return_raw_ptr_to_int2d
    ! end return_raw_ptr_to_int2d

    ! ----------------------------------------
    ! Function:  int *returnIntAllocToFixedArray +deref(allocatable)+dimension(10)
    ! Statement: f_function_native*_cfi_allocatable
    ! start return_int_alloc_to_fixed_array
    function return_int_alloc_to_fixed_array() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), allocatable :: SHT_rv(:)
        ! splicer begin function.return_int_alloc_to_fixed_array
        call c_return_int_alloc_to_fixed_array_CFI(SHT_rv)
        ! splicer end function.return_int_alloc_to_fixed_array
    end function return_int_alloc_to_fixed_array
    ! end return_int_alloc_to_fixed_array

    ! splicer begin additional_functions
    ! splicer end additional_functions

end module pointers_mod
