! wrapfpointers.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfpointers.f
!! \brief Shroud generated wrapper for pointers library
!<
! splicer begin file_top
! splicer end file_top
module pointers_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! start helper array_context
    ! helper array_context
    type, bind(C) :: POI_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type POI_SHROUD_array
    ! end helper array_context

    ! start helper capsule_data_helper
    ! helper capsule_data_helper
    type, bind(C) :: POI_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type POI_SHROUD_capsule_data
    ! end helper capsule_data_helper

    ! ----------------------------------------
    ! Function:  void intargs_in
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *arg
    ! Statement: f_in_native*
    ! start intargs_in
    interface
        subroutine intargs_in(arg) &
                bind(C, name="intargs_in")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: arg
        end subroutine intargs_in
    end interface
    ! end intargs_in

    ! ----------------------------------------
    ! Function:  void intargs_inout
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg
    ! Statement: f_inout_native*
    ! start intargs_inout
    interface
        subroutine intargs_inout(arg) &
                bind(C, name="intargs_inout")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(INOUT) :: arg
        end subroutine intargs_inout
    end interface
    ! end intargs_inout

    ! ----------------------------------------
    ! Function:  void intargs_out
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg +intent(out)
    ! Statement: f_out_native*
    ! start intargs_out
    interface
        subroutine intargs_out(arg) &
                bind(C, name="intargs_out")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT) :: arg
        end subroutine intargs_out
    end interface
    ! end intargs_out

    ! ----------------------------------------
    ! Function:  void intargs
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int argin +intent(in)
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *arginout +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *argout +intent(out)
    ! Statement: f_out_native*
    ! start intargs
    interface
        subroutine intargs(argin, arginout, argout) &
                bind(C, name="intargs")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: argin
            integer(C_INT), intent(INOUT) :: arginout
            integer(C_INT), intent(OUT) :: argout
        end subroutine intargs
    end interface
    ! end intargs

    ! ----------------------------------------
    ! Function:  void cos_doubles
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  double *out +dimension(size(in))+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: f_in_native
    ! start c_cos_doubles
    interface
        subroutine c_cos_doubles(in, out, sizein) &
                bind(C, name="cos_doubles")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(IN) :: in(*)
            real(C_DOUBLE), intent(OUT) :: out(*)
            integer(C_INT), value, intent(IN) :: sizein
        end subroutine c_cos_doubles
    end interface
    ! end c_cos_doubles

    ! ----------------------------------------
    ! Function:  void truncate_to_int
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int *out +dimension(size(in))+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: f_in_native
    ! start c_truncate_to_int
    interface
        subroutine c_truncate_to_int(in, out, sizein) &
                bind(C, name="truncate_to_int")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(IN) :: in(*)
            integer(C_INT), intent(OUT) :: out(*)
            integer(C_INT), value, intent(IN) :: sizein
        end subroutine c_truncate_to_int
    end interface
    ! end c_truncate_to_int

    ! ----------------------------------------
    ! Function:  void get_values
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *nvalues +intent(OUT)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int *values +dimension(3)+intent(out)
    ! Statement: f_out_native*
    ! start get_values
    interface
        subroutine get_values(nvalues, values) &
                bind(C, name="get_values")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT) :: nvalues
            integer(C_INT), intent(OUT) :: values(*)
        end subroutine get_values
    end interface
    ! end get_values

    ! ----------------------------------------
    ! Function:  void get_values2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg1 +dimension(3)+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int *arg2 +dimension(3)+intent(out)
    ! Statement: f_out_native*
    ! start get_values2
    interface
        subroutine get_values2(arg1, arg2) &
                bind(C, name="get_values2")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT) :: arg1(*)
            integer(C_INT), intent(OUT) :: arg2(*)
        end subroutine get_values2
    end interface
    ! end get_values2

    ! ----------------------------------------
    ! Function:  void iota_dimension
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int nvar
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *values +dimension(nvar)+intent(out)
    ! Statement: f_out_native*
    ! start iota_dimension
    interface
        subroutine iota_dimension(nvar, values) &
                bind(C, name="iota_dimension")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: nvar
            integer(C_INT), intent(OUT) :: values(*)
        end subroutine iota_dimension
    end interface
    ! end iota_dimension

    ! ----------------------------------------
    ! Function:  void Sum
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int len +implied(size(values))
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  const int *values +rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int *result +intent(out)
    ! Statement: f_out_native*
    ! start c_sum
    interface
        subroutine c_sum(len, values, result) &
                bind(C, name="Sum")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: len
            integer(C_INT), intent(IN) :: values(*)
            integer(C_INT), intent(OUT) :: result
        end subroutine c_sum
    end interface
    ! end c_sum

    ! ----------------------------------------
    ! Function:  void fillIntArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *out +dimension(3)+intent(out)
    ! Statement: f_out_native*
    ! start fill_int_array
    interface
        subroutine fill_int_array(out) &
                bind(C, name="fillIntArray")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(OUT) :: out(*)
        end subroutine fill_int_array
    end interface
    ! end fill_int_array

    ! ----------------------------------------
    ! Function:  void incrementIntArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *array +intent(inout)+rank(1)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(array))
    ! Statement: f_in_native
    ! start c_increment_int_array
    interface
        subroutine c_increment_int_array(array, sizein) &
                bind(C, name="incrementIntArray")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(INOUT) :: array(*)
            integer(C_INT), value, intent(IN) :: sizein
        end subroutine c_increment_int_array
    end interface
    ! end c_increment_int_array

    ! ----------------------------------------
    ! Function:  void fill_with_zeros
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *x +rank(1)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int x_length +implied(size(x))
    ! Statement: f_in_native
    ! start c_fill_with_zeros
    interface
        subroutine c_fill_with_zeros(x, x_length) &
                bind(C, name="fill_with_zeros")
            use iso_c_binding, only : C_DOUBLE, C_INT
            implicit none
            real(C_DOUBLE), intent(INOUT) :: x(*)
            integer(C_INT), value, intent(IN) :: x_length
        end subroutine c_fill_with_zeros
    end interface
    ! end c_fill_with_zeros

    ! ----------------------------------------
    ! Function:  int accumulate
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const int *arr +rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  size_t len +implied(size(arr))
    ! Statement: f_in_native
    ! start c_accumulate
    interface
        function c_accumulate(arr, len) &
                result(SHT_rv) &
                bind(C, name="accumulate")
            use iso_c_binding, only : C_INT, C_SIZE_T
            implicit none
            integer(C_INT), intent(IN) :: arr(*)
            integer(C_SIZE_T), value, intent(IN) :: len
            integer(C_INT) :: SHT_rv
        end function c_accumulate
    end interface
    ! end c_accumulate

    ! ----------------------------------------
    ! Function:  int acceptCharArrayIn
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  char **names +intent(in)
    ! Statement: f_in_char**_buf
    ! start c_accept_char_array_in_bufferify
    interface
        function c_accept_char_array_in_bufferify(names, SHT_names_size, &
                SHT_names_len) &
                result(SHT_rv) &
                bind(C, name="POI_acceptCharArrayIn_bufferify")
            use iso_c_binding, only : C_CHAR, C_INT, C_SIZE_T
            implicit none
            character(kind=C_CHAR), intent(IN) :: names(*)
            integer(C_SIZE_T), intent(IN), value :: SHT_names_size
            integer(C_INT), intent(IN), value :: SHT_names_len
            integer(C_INT) :: SHT_rv
        end function c_accept_char_array_in_bufferify
    end interface
    ! end c_accept_char_array_in_bufferify

    ! ----------------------------------------
    ! Function:  void setGlobalInt
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int value
    ! Statement: f_in_native
    ! start set_global_int
    interface
        subroutine set_global_int(value) &
                bind(C, name="setGlobalInt")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: value
        end subroutine set_global_int
    end interface
    ! end set_global_int

    ! ----------------------------------------
    ! Function:  int sumFixedArray
    ! Statement: f_function_native
    ! start sum_fixed_array
    interface
        function sum_fixed_array() &
                result(SHT_rv) &
                bind(C, name="sumFixedArray")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT) :: SHT_rv
        end function sum_fixed_array
    end interface
    ! end sum_fixed_array

    ! ----------------------------------------
    ! Function:  void getPtrToScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start c_get_ptr_to_scalar_bufferify
    interface
        subroutine c_get_ptr_to_scalar_bufferify(SHT_nitems_cdesc) &
                bind(C, name="POI_getPtrToScalar_bufferify")
            import :: POI_SHROUD_array
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_nitems_cdesc
        end subroutine c_get_ptr_to_scalar_bufferify
    end interface
    ! end c_get_ptr_to_scalar_bufferify

    ! ----------------------------------------
    ! Function:  void getPtrToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(10)+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start c_get_ptr_to_fixed_array_bufferify
    interface
        subroutine c_get_ptr_to_fixed_array_bufferify(SHT_count_cdesc) &
                bind(C, name="POI_getPtrToFixedArray_bufferify")
            import :: POI_SHROUD_array
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_count_cdesc
        end subroutine c_get_ptr_to_fixed_array_bufferify
    end interface
    ! end c_get_ptr_to_fixed_array_bufferify

    ! ----------------------------------------
    ! Function:  void getPtrToDynamicArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(ncount)+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start c_get_ptr_to_dynamic_array_bufferify
    interface
        subroutine c_get_ptr_to_dynamic_array_bufferify(SHT_count_cdesc) &
                bind(C, name="POI_getPtrToDynamicArray_bufferify")
            import :: POI_SHROUD_array
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_count_cdesc
        end subroutine c_get_ptr_to_dynamic_array_bufferify
    end interface
    ! end c_get_ptr_to_dynamic_array_bufferify

    ! ----------------------------------------
    ! Function:  void getPtrToFuncArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(getLen())+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start c_get_ptr_to_func_array_bufferify
    interface
        subroutine c_get_ptr_to_func_array_bufferify(SHT_count_cdesc) &
                bind(C, name="POI_getPtrToFuncArray_bufferify")
            import :: POI_SHROUD_array
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_count_cdesc
        end subroutine c_get_ptr_to_func_array_bufferify
    end interface
    ! end c_get_ptr_to_func_array_bufferify

    ! ----------------------------------------
    ! Function:  void getPtrToConstScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **nitems +intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start c_get_ptr_to_const_scalar_bufferify
    interface
        subroutine c_get_ptr_to_const_scalar_bufferify(SHT_nitems_cdesc) &
                bind(C, name="POI_getPtrToConstScalar_bufferify")
            import :: POI_SHROUD_array
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_nitems_cdesc
        end subroutine c_get_ptr_to_const_scalar_bufferify
    end interface
    ! end c_get_ptr_to_const_scalar_bufferify

    ! ----------------------------------------
    ! Function:  void getPtrToFixedConstArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **count +dimension(10)+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start c_get_ptr_to_fixed_const_array_bufferify
    interface
        subroutine c_get_ptr_to_fixed_const_array_bufferify( &
                SHT_count_cdesc) &
                bind(C, name="POI_getPtrToFixedConstArray_bufferify")
            import :: POI_SHROUD_array
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_count_cdesc
        end subroutine c_get_ptr_to_fixed_const_array_bufferify
    end interface
    ! end c_get_ptr_to_fixed_const_array_bufferify

    ! ----------------------------------------
    ! Function:  void getPtrToDynamicConstArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **count +dimension(ncount)+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start c_get_ptr_to_dynamic_const_array_bufferify
    interface
        subroutine c_get_ptr_to_dynamic_const_array_bufferify( &
                SHT_count_cdesc) &
                bind(C, name="POI_getPtrToDynamicConstArray_bufferify")
            import :: POI_SHROUD_array
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_count_cdesc
        end subroutine c_get_ptr_to_dynamic_const_array_bufferify
    end interface
    ! end c_get_ptr_to_dynamic_const_array_bufferify

    ! ----------------------------------------
    ! Function:  void getRawPtrToScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    ! start get_raw_ptr_to_scalar
    interface
        subroutine get_raw_ptr_to_scalar(nitems) &
                bind(C, name="getRawPtrToScalar")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: nitems
        end subroutine get_raw_ptr_to_scalar
    end interface
    ! end get_raw_ptr_to_scalar

    ! ----------------------------------------
    ! Function:  void getRawPtrToScalarForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    ! start c_get_raw_ptr_to_scalar_force
    interface
        subroutine c_get_raw_ptr_to_scalar_force(nitems) &
                bind(C, name="getRawPtrToScalarForce")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: nitems
        end subroutine c_get_raw_ptr_to_scalar_force
    end interface
    ! end c_get_raw_ptr_to_scalar_force

    ! ----------------------------------------
    ! Function:  void getRawPtrToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    ! start get_raw_ptr_to_fixed_array
    interface
        subroutine get_raw_ptr_to_fixed_array(count) &
                bind(C, name="getRawPtrToFixedArray")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: count
        end subroutine get_raw_ptr_to_fixed_array
    end interface
    ! end get_raw_ptr_to_fixed_array

    ! ----------------------------------------
    ! Function:  void getRawPtrToFixedArrayForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    ! start c_get_raw_ptr_to_fixed_array_force
    interface
        subroutine c_get_raw_ptr_to_fixed_array_force(count) &
                bind(C, name="getRawPtrToFixedArrayForce")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: count
        end subroutine c_get_raw_ptr_to_fixed_array_force
    end interface
    ! end c_get_raw_ptr_to_fixed_array_force

    ! ----------------------------------------
    ! Function:  void getRawPtrToInt2d
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int ***arg +intent(out)
    ! Statement: f_out_native***
    ! start get_raw_ptr_to_int2d
    interface
        subroutine get_raw_ptr_to_int2d(arg) &
                bind(C, name="getRawPtrToInt2d")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: arg
        end subroutine get_raw_ptr_to_int2d
    end interface
    ! end get_raw_ptr_to_int2d

    ! ----------------------------------------
    ! Function:  int checkInt2d
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int **arg +intent(in)
    ! Statement: f_in_native**
    ! start check_int2d
    interface
        function check_int2d(arg) &
                result(SHT_rv) &
                bind(C, name="checkInt2d")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(IN), value :: arg
            integer(C_INT) :: SHT_rv
        end function check_int2d
    end interface
    ! end check_int2d

    ! ----------------------------------------
    ! Function:  void DimensionIn
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *arg +dimension(10,20)
    ! Statement: f_in_native*
    ! start c_dimension_in
    interface
        subroutine c_dimension_in(arg) &
                bind(C, name="DimensionIn")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: arg(*)
        end subroutine c_dimension_in
    end interface
    ! end c_dimension_in

    ! ----------------------------------------
    ! Function:  void getAllocToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(allocatable)+dimension(10)+intent(out)
    ! Statement: f_out_native**_cdesc_allocatable
    ! start c_get_alloc_to_fixed_array_bufferify
    interface
        subroutine c_get_alloc_to_fixed_array_bufferify(SHT_count_cdesc, &
                SHT_count_capsule) &
                bind(C, name="POI_getAllocToFixedArray_bufferify")
            import :: POI_SHROUD_array, POI_SHROUD_capsule_data
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_count_cdesc
            type(POI_SHROUD_capsule_data), intent(OUT) :: SHT_count_capsule
        end subroutine c_get_alloc_to_fixed_array_bufferify
    end interface
    ! end c_get_alloc_to_fixed_array_bufferify

    ! ----------------------------------------
    ! Function:  void *returnAddress1
    ! Statement: f_function_void*
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    ! start return_address1
    interface
        function return_address1(flag) &
                result(SHT_rv) &
                bind(C, name="returnAddress1")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), value, intent(IN) :: flag
            type(C_PTR) :: SHT_rv
        end function return_address1
    end interface
    ! end return_address1

    ! ----------------------------------------
    ! Function:  void *returnAddress2
    ! Statement: f_function_void*
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    ! start c_return_address2
    interface
        function c_return_address2(flag) &
                result(SHT_rv) &
                bind(C, name="returnAddress2")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), value, intent(IN) :: flag
            type(C_PTR) :: SHT_rv
        end function c_return_address2
    end interface
    ! end c_return_address2

    ! ----------------------------------------
    ! Function:  void fetchVoidPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **addr +intent(out)
    ! Statement: f_out_void**
    ! start fetch_void_ptr
    interface
        subroutine fetch_void_ptr(addr) &
                bind(C, name="fetchVoidPtr")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(OUT) :: addr
        end subroutine fetch_void_ptr
    end interface
    ! end fetch_void_ptr

    ! ----------------------------------------
    ! Function:  void updateVoidPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **addr +intent(inout)
    ! Statement: f_inout_void**
    ! start c_update_void_ptr
    interface
        subroutine c_update_void_ptr(addr) &
                bind(C, name="updateVoidPtr")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR), intent(INOUT) :: addr
        end subroutine c_update_void_ptr
    end interface
    ! end c_update_void_ptr

    ! ----------------------------------------
    ! Function:  int VoidPtrArray
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void **addr +rank(1)
    ! Statement: f_in_void**
    ! start c_void_ptr_array
    interface
        function c_void_ptr_array(addr) &
                result(SHT_rv) &
                bind(C, name="VoidPtrArray")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            type(C_PTR), intent(IN) :: addr(*)
            integer(C_INT) :: SHT_rv
        end function c_void_ptr_array
    end interface
    ! end c_void_ptr_array

    ! ----------------------------------------
    ! Function:  int *returnIntPtrToScalar
    ! Statement: f_function_native*_pointer
    ! start c_return_int_ptr_to_scalar_bufferify
    interface
        function c_return_int_ptr_to_scalar_bufferify() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntPtrToScalar_bufferify")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_to_scalar_bufferify
    end interface
    ! end c_return_int_ptr_to_scalar_bufferify

    ! ----------------------------------------
    ! Function:  int *returnIntPtrToFixedArray +dimension(10)
    ! Statement: f_function_native*_cdesc_pointer
    ! start c_return_int_ptr_to_fixed_array_bufferify
    interface
        subroutine c_return_int_ptr_to_fixed_array_bufferify( &
                SHT_rv_cdesc) &
                bind(C, name="POI_returnIntPtrToFixedArray_bufferify")
            import :: POI_SHROUD_array
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_return_int_ptr_to_fixed_array_bufferify
    end interface
    ! end c_return_int_ptr_to_fixed_array_bufferify

    ! ----------------------------------------
    ! Function:  const int *returnIntPtrToConstScalar
    ! Statement: f_function_native*_pointer
    ! start c_return_int_ptr_to_const_scalar_bufferify
    interface
        function c_return_int_ptr_to_const_scalar_bufferify() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntPtrToConstScalar_bufferify")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_to_const_scalar_bufferify
    end interface
    ! end c_return_int_ptr_to_const_scalar_bufferify

    ! ----------------------------------------
    ! Function:  const int *returnIntPtrToFixedConstArray +dimension(10)
    ! Statement: f_function_native*_cdesc_pointer
    ! start c_return_int_ptr_to_fixed_const_array_bufferify
    interface
        subroutine c_return_int_ptr_to_fixed_const_array_bufferify( &
                SHT_rv_cdesc) &
                bind(C, name="POI_returnIntPtrToFixedConstArray_bufferify")
            import :: POI_SHROUD_array
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_return_int_ptr_to_fixed_const_array_bufferify
    end interface
    ! end c_return_int_ptr_to_fixed_const_array_bufferify

    ! ----------------------------------------
    ! Function:  int *returnIntScalar +deref(scalar)
    ! Statement: f_function_native*_scalar
    ! start return_int_scalar
    interface
        function return_int_scalar() &
                result(SHT_rv) &
                bind(C, name="POI_returnIntScalar_bufferify")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT) :: SHT_rv
        end function return_int_scalar
    end interface
    ! end return_int_scalar

    ! ----------------------------------------
    ! Function:  int *returnIntRaw +deref(raw)
    ! Statement: f_function_native*_raw
    ! start return_int_raw
    interface
        function return_int_raw() &
                result(SHT_rv) &
                bind(C, name="returnIntRaw")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function return_int_raw
    end interface
    ! end return_int_raw

    ! ----------------------------------------
    ! Function:  int *returnIntRawWithArgs +deref(raw)
    ! Statement: f_function_native*_raw
    ! ----------------------------------------
    ! Argument:  const char *name
    ! Statement: f_in_char*
    ! start c_return_int_raw_with_args
    interface
        function c_return_int_raw_with_args(name) &
                result(SHT_rv) &
                bind(C, name="returnIntRawWithArgs")
            use iso_c_binding, only : C_CHAR, C_PTR
            implicit none
            character(kind=C_CHAR), intent(IN) :: name(*)
            type(C_PTR) :: SHT_rv
        end function c_return_int_raw_with_args
    end interface
    ! end c_return_int_raw_with_args

    ! ----------------------------------------
    ! Function:  int **returnRawPtrToInt2d
    ! Statement: f_function_native**
    ! start c_return_raw_ptr_to_int2d
    interface
        function c_return_raw_ptr_to_int2d() &
                result(SHT_rv) &
                bind(C, name="returnRawPtrToInt2d")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_raw_ptr_to_int2d
    end interface
    ! end c_return_raw_ptr_to_int2d

    ! ----------------------------------------
    ! Function:  int *returnIntAllocToFixedArray +deref(allocatable)+dimension(10)
    ! Statement: f_function_native*_cdesc_allocatable
    ! start c_return_int_alloc_to_fixed_array_bufferify
    interface
        subroutine c_return_int_alloc_to_fixed_array_bufferify( &
                SHT_rv_cdesc, SHT_rv_capsule) &
                bind(C, name="POI_returnIntAllocToFixedArray_bufferify")
            import :: POI_SHROUD_array, POI_SHROUD_capsule_data
            implicit none
            type(POI_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(POI_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_return_int_alloc_to_fixed_array_bufferify
    end interface
    ! end c_return_int_alloc_to_fixed_array_bufferify

    interface
        ! helper capsule_dtor
        ! Delete memory in a capsule.
        subroutine POI_SHROUD_capsule_dtor(ptr) &
            bind(C, name="POI_SHROUD_memory_destructor")
            import POI_SHROUD_capsule_data
            implicit none
            type(POI_SHROUD_capsule_data), intent(INOUT) :: ptr
        end subroutine POI_SHROUD_capsule_dtor
    end interface

    interface
        ! helper copy_array
        ! Copy contents of context into c_var.
        subroutine POI_SHROUD_copy_array(context, c_var, c_var_size) &
            bind(C, name="POI_ShroudCopyArray")
            use iso_c_binding, only : C_PTR, C_SIZE_T
            import POI_SHROUD_array
            type(POI_SHROUD_array), intent(IN) :: context
            type(C_PTR), intent(IN), value :: c_var
            integer(C_SIZE_T), value :: c_var_size
        end subroutine POI_SHROUD_copy_array
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void intargs_in
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *arg
    ! Statement: f_in_native*
    ! start intargs_in
    subroutine intargs_in(arg)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: arg
        ! splicer begin function.intargs_in
        call c_intargs_in(arg)
        ! splicer end function.intargs_in
    end subroutine intargs_in
    ! end intargs_in
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void intargs_inout
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg
    ! Statement: f_inout_native*
    !>
    !! Argument is modified by library, defaults to intent(inout).
    !<
    ! start intargs_inout
    subroutine intargs_inout(arg)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(INOUT) :: arg
        ! splicer begin function.intargs_inout
        call c_intargs_inout(arg)
        ! splicer end function.intargs_inout
    end subroutine intargs_inout
    ! end intargs_inout
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void intargs_out
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg +intent(out)
    ! Statement: f_out_native*
    ! start intargs_out
    subroutine intargs_out(arg)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT) :: arg
        ! splicer begin function.intargs_out
        call c_intargs_out(arg)
        ! splicer end function.intargs_out
    end subroutine intargs_out
    ! end intargs_out
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void intargs
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int argin +intent(in)
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *arginout +intent(inout)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int *argout +intent(out)
    ! Statement: f_out_native*
    ! start intargs
    subroutine intargs(argin, arginout, argout)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: argin
        integer(C_INT), intent(INOUT) :: arginout
        integer(C_INT), intent(OUT) :: argout
        ! splicer begin function.intargs
        call c_intargs(argin, arginout, argout)
        ! splicer end function.intargs
    end subroutine intargs
    ! end intargs
#endif

    ! ----------------------------------------
    ! Function:  void cos_doubles
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  double *out +dimension(size(in))+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: c_default
    !>
    !! \brief compute cos of IN and save in OUT
    !!
    !! allocate OUT same type as IN implied size of array
    !<
    ! start cos_doubles
    subroutine cos_doubles(in, out)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), intent(IN) :: in(:)
        real(C_DOUBLE), intent(OUT) :: out(:)
        integer(C_INT) :: SH_sizein
        ! splicer begin function.cos_doubles
        SH_sizein = size(in,kind=C_INT)
        call c_cos_doubles(in, out, SH_sizein)
        ! splicer end function.cos_doubles
    end subroutine cos_doubles
    ! end cos_doubles

    ! ----------------------------------------
    ! Function:  void truncate_to_int
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *in +intent(in)+rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int *out +dimension(size(in))+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(in))
    ! Statement: c_default
    !>
    !! \brief truncate IN argument and save in OUT
    !!
    !! allocate OUT different type as IN
    !! implied size of array
    !<
    ! start truncate_to_int
    subroutine truncate_to_int(in, out)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), intent(IN) :: in(:)
        integer(C_INT), intent(OUT) :: out(:)
        integer(C_INT) :: SH_sizein
        ! splicer begin function.truncate_to_int
        SH_sizein = size(in,kind=C_INT)
        call c_truncate_to_int(in, out, SH_sizein)
        ! splicer end function.truncate_to_int
    end subroutine truncate_to_int
    ! end truncate_to_int

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void get_values
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *nvalues +intent(OUT)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int *values +dimension(3)+intent(out)
    ! Statement: f_out_native*
    !>
    !! \brief fill values into array
    !!
    !! The function knows how long the array must be.
    !! Fortran will treat the dimension as assumed-length.
    !! The Python wrapper will create a NumPy array or list so it must
    !! have an explicit dimension (not assumed-length).
    !<
    ! start get_values
    subroutine get_values(nvalues, values)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT) :: nvalues
        integer(C_INT), intent(OUT) :: values(3)
        ! splicer begin function.get_values
        call c_get_values(nvalues, values)
        ! splicer end function.get_values
    end subroutine get_values
    ! end get_values
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void get_values2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *arg1 +dimension(3)+intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  int *arg2 +dimension(3)+intent(out)
    ! Statement: f_out_native*
    !>
    !! \brief fill values into two arrays
    !!
    !! Test two intent(out) arguments.
    !! Make sure error handling works with C++.
    !<
    ! start get_values2
    subroutine get_values2(arg1, arg2)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT) :: arg1(3)
        integer(C_INT), intent(OUT) :: arg2(3)
        ! splicer begin function.get_values2
        call c_get_values2(arg1, arg2)
        ! splicer end function.get_values2
    end subroutine get_values2
    ! end get_values2
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void iota_dimension
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int nvar
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *values +dimension(nvar)+intent(out)
    ! Statement: f_out_native*
    ! start iota_dimension
    subroutine iota_dimension(nvar, values)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: nvar
        integer(C_INT), intent(OUT) :: values(nvar)
        ! splicer begin function.iota_dimension
        call c_iota_dimension(nvar, values)
        ! splicer end function.iota_dimension
    end subroutine iota_dimension
    ! end iota_dimension
#endif

    ! ----------------------------------------
    ! Function:  void Sum
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int len +implied(size(values))
    ! Statement: c_default
    ! ----------------------------------------
    ! Argument:  const int *values +rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int *result +intent(out)
    ! Statement: f_out_native*
    ! start sum
    subroutine sum(values, result)
        use iso_c_binding, only : C_INT
        integer(C_INT) :: SH_len
        integer(C_INT), intent(IN) :: values(:)
        integer(C_INT), intent(OUT) :: result
        ! splicer begin function.sum
        SH_len = size(values,kind=C_INT)
        call c_sum(SH_len, values, result)
        ! splicer end function.sum
    end subroutine sum
    ! end sum

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void fillIntArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *out +dimension(3)+intent(out)
    ! Statement: f_out_native*
    !>
    !! Return three values into memory the user provides.
    !<
    ! start fill_int_array
    subroutine fill_int_array(out)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(OUT) :: out(3)
        ! splicer begin function.fill_int_array
        call c_fill_int_array(out)
        ! splicer end function.fill_int_array
    end subroutine fill_int_array
    ! end fill_int_array
#endif

    ! ----------------------------------------
    ! Function:  void incrementIntArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int *array +intent(inout)+rank(1)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int sizein +implied(size(array))
    ! Statement: c_default
    !>
    !! Increment array in place using intent(INOUT).
    !<
    ! start increment_int_array
    subroutine increment_int_array(array)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(INOUT) :: array(:)
        integer(C_INT) :: SH_sizein
        ! splicer begin function.increment_int_array
        SH_sizein = size(array,kind=C_INT)
        call c_increment_int_array(array, SH_sizein)
        ! splicer end function.increment_int_array
    end subroutine increment_int_array
    ! end increment_int_array

    ! ----------------------------------------
    ! Function:  void fill_with_zeros
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double *x +rank(1)
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int x_length +implied(size(x))
    ! Statement: c_default
    ! start fill_with_zeros
    subroutine fill_with_zeros(x)
        use iso_c_binding, only : C_DOUBLE, C_INT
        real(C_DOUBLE), intent(INOUT) :: x(:)
        integer(C_INT) :: SH_x_length
        ! splicer begin function.fill_with_zeros
        SH_x_length = size(x,kind=C_INT)
        call c_fill_with_zeros(x, SH_x_length)
        ! splicer end function.fill_with_zeros
    end subroutine fill_with_zeros
    ! end fill_with_zeros

    ! ----------------------------------------
    ! Function:  int accumulate
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const int *arr +rank(1)
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  size_t len +implied(size(arr))
    ! Statement: c_default
    ! start accumulate
    function accumulate(arr) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_SIZE_T
        integer(C_INT), intent(IN) :: arr(:)
        integer(C_SIZE_T) :: SH_len
        integer(C_INT) :: SHT_rv
        ! splicer begin function.accumulate
        SH_len = size(arr,kind=C_SIZE_T)
        SHT_rv = c_accumulate(arr, SH_len)
        ! splicer end function.accumulate
    end function accumulate
    ! end accumulate

    ! ----------------------------------------
    ! Function:  int acceptCharArrayIn
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  char **names +intent(in)
    ! Statement: f_in_char**_buf
    !>
    !! Return strlen of the first index as a check.
    !<
    ! start accept_char_array_in
    function accept_char_array_in(names) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_SIZE_T
        character(len=*), intent(IN) :: names(:)
        integer(C_INT) :: SHT_rv
        ! splicer begin function.accept_char_array_in
        SHT_rv = c_accept_char_array_in_bufferify(names, &
            size(names, kind=C_SIZE_T), len(names, kind=C_INT))
        ! splicer end function.accept_char_array_in
    end function accept_char_array_in
    ! end accept_char_array_in

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void setGlobalInt
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int value
    ! Statement: f_in_native
    ! start set_global_int
    subroutine set_global_int(value)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: value
        ! splicer begin function.set_global_int
        call c_set_global_int(value)
        ! splicer end function.set_global_int
    end subroutine set_global_int
    ! end set_global_int
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int sumFixedArray
    ! Statement: f_function_native
    !>
    !! Used to test values global_array.
    !<
    ! start sum_fixed_array
    function sum_fixed_array() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT) :: SHT_rv
        ! splicer begin function.sum_fixed_array
        SHT_rv = c_sum_fixed_array()
        ! splicer end function.sum_fixed_array
    end function sum_fixed_array
    ! end sum_fixed_array
#endif

    ! ----------------------------------------
    ! Function:  void getPtrToScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start get_ptr_to_scalar
    subroutine get_ptr_to_scalar(nitems)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), intent(OUT), pointer :: nitems
        ! splicer begin function.get_ptr_to_scalar
        type(POI_SHROUD_array) :: SHT_nitems_cdesc
        call c_get_ptr_to_scalar_bufferify(SHT_nitems_cdesc)
        call c_f_pointer(SHT_nitems_cdesc%base_addr, nitems)
        ! splicer end function.get_ptr_to_scalar
    end subroutine get_ptr_to_scalar
    ! end get_ptr_to_scalar

    ! ----------------------------------------
    ! Function:  void getPtrToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(10)+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    !>
    !! Return a Fortran pointer to an array which is always the same length.
    !<
    ! start get_ptr_to_fixed_array
    subroutine get_ptr_to_fixed_array(count)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), intent(OUT), pointer :: count(:)
        ! splicer begin function.get_ptr_to_fixed_array
        type(POI_SHROUD_array) :: SHT_count_cdesc
        call c_get_ptr_to_fixed_array_bufferify(SHT_count_cdesc)
        call c_f_pointer(SHT_count_cdesc%base_addr, count, &
            SHT_count_cdesc%shape(1:1))
        ! splicer end function.get_ptr_to_fixed_array
    end subroutine get_ptr_to_fixed_array
    ! end get_ptr_to_fixed_array

    ! ----------------------------------------
    ! Function:  void getPtrToDynamicArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(ncount)+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    !>
    !! Return a Fortran pointer to an array which is the length of
    !! the argument ncount.
    !<
    ! start get_ptr_to_dynamic_array
    subroutine get_ptr_to_dynamic_array(count)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), intent(OUT), pointer :: count(:)
        ! splicer begin function.get_ptr_to_dynamic_array
        type(POI_SHROUD_array) :: SHT_count_cdesc
        call c_get_ptr_to_dynamic_array_bufferify(SHT_count_cdesc)
        call c_f_pointer(SHT_count_cdesc%base_addr, count, &
            SHT_count_cdesc%shape(1:1))
        ! splicer end function.get_ptr_to_dynamic_array
    end subroutine get_ptr_to_dynamic_array
    ! end get_ptr_to_dynamic_array

    ! ----------------------------------------
    ! Function:  void getPtrToFuncArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +dimension(getLen())+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    !>
    !! Return a Fortran pointer to an array which is the length
    !! is computed by C++ function getLen.
    !! getLen will be called from C/C++ to compute the shape.
    !<
    ! start get_ptr_to_func_array
    subroutine get_ptr_to_func_array(count)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), intent(OUT), pointer :: count(:)
        ! splicer begin function.get_ptr_to_func_array
        type(POI_SHROUD_array) :: SHT_count_cdesc
        call c_get_ptr_to_func_array_bufferify(SHT_count_cdesc)
        call c_f_pointer(SHT_count_cdesc%base_addr, count, &
            SHT_count_cdesc%shape(1:1))
        ! splicer end function.get_ptr_to_func_array
    end subroutine get_ptr_to_func_array
    ! end get_ptr_to_func_array

    ! ----------------------------------------
    ! Function:  void getPtrToConstScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **nitems +intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start get_ptr_to_const_scalar
    subroutine get_ptr_to_const_scalar(nitems)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), intent(OUT), pointer :: nitems
        ! splicer begin function.get_ptr_to_const_scalar
        type(POI_SHROUD_array) :: SHT_nitems_cdesc
        call c_get_ptr_to_const_scalar_bufferify(SHT_nitems_cdesc)
        call c_f_pointer(SHT_nitems_cdesc%base_addr, nitems)
        ! splicer end function.get_ptr_to_const_scalar
    end subroutine get_ptr_to_const_scalar
    ! end get_ptr_to_const_scalar

    ! ----------------------------------------
    ! Function:  void getPtrToFixedConstArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **count +dimension(10)+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start get_ptr_to_fixed_const_array
    subroutine get_ptr_to_fixed_const_array(count)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), intent(OUT), pointer :: count(:)
        ! splicer begin function.get_ptr_to_fixed_const_array
        type(POI_SHROUD_array) :: SHT_count_cdesc
        call c_get_ptr_to_fixed_const_array_bufferify(SHT_count_cdesc)
        call c_f_pointer(SHT_count_cdesc%base_addr, count, &
            SHT_count_cdesc%shape(1:1))
        ! splicer end function.get_ptr_to_fixed_const_array
    end subroutine get_ptr_to_fixed_const_array
    ! end get_ptr_to_fixed_const_array

    ! ----------------------------------------
    ! Function:  void getPtrToDynamicConstArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int **count +dimension(ncount)+intent(out)
    ! Statement: f_out_native**_cdesc_pointer
    ! start get_ptr_to_dynamic_const_array
    subroutine get_ptr_to_dynamic_const_array(count)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), intent(OUT), pointer :: count(:)
        ! splicer begin function.get_ptr_to_dynamic_const_array
        type(POI_SHROUD_array) :: SHT_count_cdesc
        call c_get_ptr_to_dynamic_const_array_bufferify(SHT_count_cdesc)
        call c_f_pointer(SHT_count_cdesc%base_addr, count, &
            SHT_count_cdesc%shape(1:1))
        ! splicer end function.get_ptr_to_dynamic_const_array
    end subroutine get_ptr_to_dynamic_const_array
    ! end get_ptr_to_dynamic_const_array

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getRawPtrToScalar
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    !>
    !! Called directly via an interface in Fortran.
    !<
    ! start get_raw_ptr_to_scalar
    subroutine get_raw_ptr_to_scalar(nitems)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: nitems
        ! splicer begin function.get_raw_ptr_to_scalar
        call c_get_raw_ptr_to_scalar(nitems)
        ! splicer end function.get_raw_ptr_to_scalar
    end subroutine get_raw_ptr_to_scalar
    ! end get_raw_ptr_to_scalar
#endif

    ! ----------------------------------------
    ! Function:  void getRawPtrToScalarForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **nitems +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    !>
    !! Create a Fortran wrapper.
    !<
    ! start get_raw_ptr_to_scalar_force
    subroutine get_raw_ptr_to_scalar_force(nitems)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: nitems
        ! splicer begin function.get_raw_ptr_to_scalar_force
        call c_get_raw_ptr_to_scalar_force(nitems)
        ! splicer end function.get_raw_ptr_to_scalar_force
    end subroutine get_raw_ptr_to_scalar_force
    ! end get_raw_ptr_to_scalar_force

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getRawPtrToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    !>
    !! Return a type(C_PTR) to an array which is always the same length.
    !! Called directly via an interface in Fortran.
    !! # Uses +deref(raw) instead of +dimension(10) like getPtrToFixedArray.
    !<
    ! start get_raw_ptr_to_fixed_array
    subroutine get_raw_ptr_to_fixed_array(count)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: count
        ! splicer begin function.get_raw_ptr_to_fixed_array
        call c_get_raw_ptr_to_fixed_array(count)
        ! splicer end function.get_raw_ptr_to_fixed_array
    end subroutine get_raw_ptr_to_fixed_array
    ! end get_raw_ptr_to_fixed_array
#endif

    ! ----------------------------------------
    ! Function:  void getRawPtrToFixedArrayForce
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(raw)+intent(out)
    ! Statement: f_out_native**_raw
    !>
    !! Return a type(C_PTR) to an array which is always the same length.
    !! Create a Fortran wrapper.
    !<
    ! start get_raw_ptr_to_fixed_array_force
    subroutine get_raw_ptr_to_fixed_array_force(count)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: count
        ! splicer begin function.get_raw_ptr_to_fixed_array_force
        call c_get_raw_ptr_to_fixed_array_force(count)
        ! splicer end function.get_raw_ptr_to_fixed_array_force
    end subroutine get_raw_ptr_to_fixed_array_force
    ! end get_raw_ptr_to_fixed_array_force

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void getRawPtrToInt2d
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int ***arg +intent(out)
    ! Statement: f_out_native***
    !>
    !! Test multiple layers of indirection.
    !<
    ! start get_raw_ptr_to_int2d
    subroutine get_raw_ptr_to_int2d(arg)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: arg
        ! splicer begin function.get_raw_ptr_to_int2d
        call c_get_raw_ptr_to_int2d(arg)
        ! splicer end function.get_raw_ptr_to_int2d
    end subroutine get_raw_ptr_to_int2d
    ! end get_raw_ptr_to_int2d
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int checkInt2d
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int **arg +intent(in)
    ! Statement: f_in_native**
    !>
    !! Check results of getRawPtrToInt2d.
    !<
    ! start check_int2d
    function check_int2d(arg) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: arg
        integer(C_INT) :: SHT_rv
        ! splicer begin function.check_int2d
        SHT_rv = c_check_int2d(arg)
        ! splicer end function.check_int2d
    end function check_int2d
    ! end check_int2d
#endif

    ! ----------------------------------------
    ! Function:  void DimensionIn
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *arg +dimension(10,20)
    ! Statement: f_in_native*
    !>
    !! Test +dimension(10,20) +intent(in) together.
    !! This will not use assumed-shape in the Fortran wrapper.
    !<
    ! start dimension_in
    subroutine dimension_in(arg)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: arg(10,20)
        ! splicer begin function.dimension_in
        call c_dimension_in(arg)
        ! splicer end function.dimension_in
    end subroutine dimension_in
    ! end dimension_in

    ! ----------------------------------------
    ! Function:  void getAllocToFixedArray
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int **count +deref(allocatable)+dimension(10)+intent(out)
    ! Statement: f_out_native**_cdesc_allocatable
    !>
    !! Return a Fortran pointer to an array which is always the same length.
    !<
    ! start get_alloc_to_fixed_array
    subroutine get_alloc_to_fixed_array(count)
        use iso_c_binding, only : C_INT, C_LOC
        integer(C_INT), intent(OUT), allocatable, target :: count(:)
        ! splicer begin function.get_alloc_to_fixed_array
        type(POI_SHROUD_array) :: SHT_count_cdesc
        type(POI_SHROUD_capsule_data) :: SHT_count_capsule
        call c_get_alloc_to_fixed_array_bufferify(SHT_count_cdesc, &
            SHT_count_capsule)
        allocate(count(SHT_count_cdesc%shape(1)))
        call POI_SHROUD_copy_array(SHT_count_cdesc, C_LOC(count), &
            SHT_count_cdesc%size)
        call POI_SHROUD_capsule_dtor(SHT_count_capsule)
        ! splicer end function.get_alloc_to_fixed_array
    end subroutine get_alloc_to_fixed_array
    ! end get_alloc_to_fixed_array

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void *returnAddress1
    ! Statement: f_function_void*
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    ! start return_address1
    function return_address1(flag) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR
        integer(C_INT), value, intent(IN) :: flag
        type(C_PTR) :: SHT_rv
        ! splicer begin function.return_address1
        SHT_rv = c_return_address1(flag)
        ! splicer end function.return_address1
    end function return_address1
    ! end return_address1
#endif

    ! ----------------------------------------
    ! Function:  void *returnAddress2
    ! Statement: f_function_void*
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    ! start return_address2
    function return_address2(flag) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR
        integer(C_INT), value, intent(IN) :: flag
        type(C_PTR) :: SHT_rv
        ! splicer begin function.return_address2
        SHT_rv = c_return_address2(flag)
        ! splicer end function.return_address2
    end function return_address2
    ! end return_address2

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void fetchVoidPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **addr +intent(out)
    ! Statement: f_out_void**
    ! start fetch_void_ptr
    subroutine fetch_void_ptr(addr)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(OUT) :: addr
        ! splicer begin function.fetch_void_ptr
        call c_fetch_void_ptr(addr)
        ! splicer end function.fetch_void_ptr
    end subroutine fetch_void_ptr
    ! end fetch_void_ptr
#endif

    ! ----------------------------------------
    ! Function:  void updateVoidPtr
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **addr +intent(inout)
    ! Statement: f_inout_void**
    ! start update_void_ptr
    subroutine update_void_ptr(addr)
        use iso_c_binding, only : C_PTR
        type(C_PTR), intent(INOUT) :: addr
        ! splicer begin function.update_void_ptr
        call c_update_void_ptr(addr)
        ! splicer end function.update_void_ptr
    end subroutine update_void_ptr
    ! end update_void_ptr

    ! ----------------------------------------
    ! Function:  int VoidPtrArray
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  void **addr +rank(1)
    ! Statement: f_in_void**
    ! start void_ptr_array
    function void_ptr_array(addr) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR
        type(C_PTR), intent(IN) :: addr(:)
        integer(C_INT) :: SHT_rv
        ! splicer begin function.void_ptr_array
        SHT_rv = c_void_ptr_array(addr)
        ! splicer end function.void_ptr_array
    end function void_ptr_array
    ! end void_ptr_array

    ! ----------------------------------------
    ! Function:  int *returnIntPtrToScalar
    ! Statement: f_function_native*_pointer
    ! start return_int_ptr_to_scalar
    function return_int_ptr_to_scalar() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR, c_f_pointer
        integer(C_INT), pointer :: SHT_rv
        ! splicer begin function.return_int_ptr_to_scalar
        type(C_PTR) :: SHC_rv_ptr
        SHC_rv_ptr = c_return_int_ptr_to_scalar_bufferify()
        call c_f_pointer(SHC_rv_ptr, SHT_rv)
        ! splicer end function.return_int_ptr_to_scalar
    end function return_int_ptr_to_scalar
    ! end return_int_ptr_to_scalar

    ! ----------------------------------------
    ! Function:  int *returnIntPtrToFixedArray +dimension(10)
    ! Statement: f_function_native*_cdesc_pointer
    ! start return_int_ptr_to_fixed_array
    function return_int_ptr_to_fixed_array() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin function.return_int_ptr_to_fixed_array
        type(POI_SHROUD_array) :: SHT_rv_cdesc
        call c_return_int_ptr_to_fixed_array_bufferify(SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end function.return_int_ptr_to_fixed_array
    end function return_int_ptr_to_fixed_array
    ! end return_int_ptr_to_fixed_array

    ! ----------------------------------------
    ! Function:  const int *returnIntPtrToConstScalar
    ! Statement: f_function_native*_pointer
    ! start return_int_ptr_to_const_scalar
    function return_int_ptr_to_const_scalar() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR, c_f_pointer
        integer(C_INT), pointer :: SHT_rv
        ! splicer begin function.return_int_ptr_to_const_scalar
        type(C_PTR) :: SHC_rv_ptr
        SHC_rv_ptr = c_return_int_ptr_to_const_scalar_bufferify()
        call c_f_pointer(SHC_rv_ptr, SHT_rv)
        ! splicer end function.return_int_ptr_to_const_scalar
    end function return_int_ptr_to_const_scalar
    ! end return_int_ptr_to_const_scalar

    ! ----------------------------------------
    ! Function:  const int *returnIntPtrToFixedConstArray +dimension(10)
    ! Statement: f_function_native*_cdesc_pointer
    ! start return_int_ptr_to_fixed_const_array
    function return_int_ptr_to_fixed_const_array() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin function.return_int_ptr_to_fixed_const_array
        type(POI_SHROUD_array) :: SHT_rv_cdesc
        call c_return_int_ptr_to_fixed_const_array_bufferify(SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end function.return_int_ptr_to_fixed_const_array
    end function return_int_ptr_to_fixed_const_array
    ! end return_int_ptr_to_fixed_const_array

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int *returnIntScalar +deref(scalar)
    ! Statement: f_function_native*_scalar
    ! start return_int_scalar
    function return_int_scalar() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT) :: SHT_rv
        ! splicer begin function.return_int_scalar
        SHT_rv = c_return_int_scalar_bufferify()
        ! splicer end function.return_int_scalar
    end function return_int_scalar
    ! end return_int_scalar
#endif

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int *returnIntRaw +deref(raw)
    ! Statement: f_function_native*_raw
    !>
    !! Call directly via interface.
    !<
    ! start return_int_raw
    function return_int_raw() &
            result(SHT_rv)
        use iso_c_binding, only : C_PTR
        type(C_PTR) :: SHT_rv
        ! splicer begin function.return_int_raw
        SHT_rv = c_return_int_raw()
        ! splicer end function.return_int_raw
    end function return_int_raw
    ! end return_int_raw
#endif

    ! ----------------------------------------
    ! Function:  int *returnIntRawWithArgs +deref(raw)
    ! Statement: f_function_native*_raw
    ! ----------------------------------------
    ! Argument:  const char *name
    ! Statement: f_in_char*
    !>
    !! Like returnIntRaw but with another argument to force a wrapper.
    !! Uses fc_statements f_function_native_*_raw.
    !<
    ! start return_int_raw_with_args
    function return_int_raw_with_args(name) &
            result(SHT_rv)
        use iso_c_binding, only : C_NULL_CHAR, C_PTR
        character(len=*), intent(IN) :: name
        type(C_PTR) :: SHT_rv
        ! splicer begin function.return_int_raw_with_args
        SHT_rv = c_return_int_raw_with_args(trim(name)//C_NULL_CHAR)
        ! splicer end function.return_int_raw_with_args
    end function return_int_raw_with_args
    ! end return_int_raw_with_args

    ! ----------------------------------------
    ! Function:  int **returnRawPtrToInt2d
    ! Statement: f_function_native**
    !>
    !! Test multiple layers of indirection.
    !! # getRawPtrToInt2d
    !<
    ! start return_raw_ptr_to_int2d
    function return_raw_ptr_to_int2d() &
            result(SHT_rv)
        use iso_c_binding, only : C_PTR
        type(C_PTR) :: SHT_rv
        ! splicer begin function.return_raw_ptr_to_int2d
        SHT_rv = c_return_raw_ptr_to_int2d()
        ! splicer end function.return_raw_ptr_to_int2d
    end function return_raw_ptr_to_int2d
    ! end return_raw_ptr_to_int2d

    ! ----------------------------------------
    ! Function:  int *returnIntAllocToFixedArray +deref(allocatable)+dimension(10)
    ! Statement: f_function_native*_cdesc_allocatable
    ! start return_int_alloc_to_fixed_array
    function return_int_alloc_to_fixed_array() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_LOC, C_SIZE_T
        integer(C_INT), allocatable, target :: SHT_rv(:)
        ! splicer begin function.return_int_alloc_to_fixed_array
        type(POI_SHROUD_array) :: SHT_rv_cdesc
        type(POI_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_return_int_alloc_to_fixed_array_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(SHT_rv(SHT_rv_cdesc%shape(1)))
        call POI_SHROUD_copy_array(SHT_rv_cdesc, C_LOC(SHT_rv), &
            size(SHT_rv, kind=C_SIZE_T))
        call POI_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.return_int_alloc_to_fixed_array
    end function return_int_alloc_to_fixed_array
    ! end return_int_alloc_to_fixed_array

    ! splicer begin additional_functions
    ! splicer end additional_functions

end module pointers_mod
