// wrappointers.c
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "pointers.h"
// shroud
#include <stdlib.h>
#include <string.h>
#include "wrappointers.h"


// helper char_len_trim
// Returns the length of character string src with length nsrc,
// ignoring any trailing blanks.
static int ShroudCharLenTrim(const char *src, int nsrc) {
    int i;

    for (i = nsrc - 1; i >= 0; i--) {
        if (src[i] != ' ') {
            break;
        }
    }

    return i + 1;
}


// start helper char_array_alloc
// helper char_array_alloc
// Copy src into new memory and null terminate.
// char **src +size(nsrc) +len(len)
// CHARACTER(len) src(nsrc)
static char **ShroudStrArrayAlloc(const char *src, int nsrc, int len)
{
    char **rv = (char **) malloc(sizeof(char *) * nsrc);
    const char *src0 = src;
    for(int i=0; i < nsrc; ++i) {
        int ntrim = ShroudCharLenTrim(src0, len);
        char *tgt = (char *) malloc(ntrim+1);
        memcpy(tgt, src0, ntrim);
        tgt[ntrim] = '\0';
        rv[i] = tgt;
        src0 += len;
    }
    return rv;
}
// end helper char_array_alloc

// helper char_array_free
// Release memory allocated by ShroudStrArrayAlloc
static void ShroudStrArrayFree(char **src, int nsrc)
{
    for(int i=0; i < nsrc; ++i) {
        free(src[i]);
    }
    free(src);
}

// splicer begin C_definitions
// splicer end C_definitions

/**
 * Return strlen of the first index as a check.
 */
// ----------------------------------------
// Function:  int acceptCharArrayIn
// Statement: f_function_native
// ----------------------------------------
// Argument:  char **names +intent(in)
// Statement: f_in_char**_buf
// start POI_acceptCharArrayIn_bufferify
int POI_acceptCharArrayIn_bufferify(const char *names,
    size_t SHT_names_size, int SHT_names_len)
{
    // splicer begin function.acceptCharArrayIn_bufferify
    char **SHC_names_cxx = ShroudStrArrayAlloc(names, SHT_names_size,
        SHT_names_len);
    int SHC_rv = acceptCharArrayIn(SHC_names_cxx);
    ShroudStrArrayFree(SHC_names_cxx, SHT_names_size);
    return SHC_rv;
    // splicer end function.acceptCharArrayIn_bufferify
}
// end POI_acceptCharArrayIn_bufferify

// ----------------------------------------
// Function:  void getPtrToScalar
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **nitems +intent(out)
// Statement: f_out_native**_cdesc_pointer
// start POI_getPtrToScalar_bufferify
void POI_getPtrToScalar_bufferify(POI_SHROUD_array *SHT_nitems_cdesc)
{
    // splicer begin function.getPtrToScalar_bufferify
    int *nitems;
    getPtrToScalar(&nitems);
    SHT_nitems_cdesc->base_addr = nitems;
    SHT_nitems_cdesc->type = SH_TYPE_INT;
    SHT_nitems_cdesc->elem_len = sizeof(int);
    SHT_nitems_cdesc->rank = 0;
    SHT_nitems_cdesc->size = 1;
    // splicer end function.getPtrToScalar_bufferify
}
// end POI_getPtrToScalar_bufferify

/**
 * Return a Fortran pointer to an array which is always the same length.
 */
// ----------------------------------------
// Function:  void getPtrToFixedArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(10)+intent(out)
// Statement: f_out_native**_cdesc_pointer
// start POI_getPtrToFixedArray_bufferify
void POI_getPtrToFixedArray_bufferify(POI_SHROUD_array *SHT_count_cdesc)
{
    // splicer begin function.getPtrToFixedArray_bufferify
    int *count;
    getPtrToFixedArray(&count);
    SHT_count_cdesc->base_addr = count;
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = 10;
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    // splicer end function.getPtrToFixedArray_bufferify
}
// end POI_getPtrToFixedArray_bufferify

/**
 * Return a Fortran pointer to an array which is the length of
 * the argument ncount.
 */
// ----------------------------------------
// Function:  void getPtrToDynamicArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(ncount)+intent(out)
// Statement: f_out_native**_cdesc_pointer
// ----------------------------------------
// Argument:  int *ncount +hidden+intent(out)
// Statement: f_out_native*_hidden
// start POI_getPtrToDynamicArray_bufferify
void POI_getPtrToDynamicArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc)
{
    // splicer begin function.getPtrToDynamicArray_bufferify
    int *count;
    int ncount;
    getPtrToDynamicArray(&count, &ncount);
    SHT_count_cdesc->base_addr = count;
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = ncount;
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    // splicer end function.getPtrToDynamicArray_bufferify
}
// end POI_getPtrToDynamicArray_bufferify

/**
 * Return a Fortran pointer to an array which is the length
 * is computed by C++ function getLen.
 * getLen will be called from C/C++ to compute the shape.
 */
// ----------------------------------------
// Function:  void getPtrToFuncArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +dimension(getLen())+intent(out)
// Statement: f_out_native**_cdesc_pointer
// start POI_getPtrToFuncArray_bufferify
void POI_getPtrToFuncArray_bufferify(POI_SHROUD_array *SHT_count_cdesc)
{
    // splicer begin function.getPtrToFuncArray_bufferify
    int *count;
    getPtrToFuncArray(&count);
    SHT_count_cdesc->base_addr = count;
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = getLen();
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    // splicer end function.getPtrToFuncArray_bufferify
}
// end POI_getPtrToFuncArray_bufferify

// ----------------------------------------
// Function:  void getPtrToConstScalar
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int **nitems +intent(out)
// Statement: f_out_native**_cdesc_pointer
// start POI_getPtrToConstScalar_bufferify
void POI_getPtrToConstScalar_bufferify(
    POI_SHROUD_array *SHT_nitems_cdesc)
{
    // splicer begin function.getPtrToConstScalar_bufferify
    const int *nitems;
    getPtrToConstScalar(&nitems);
    SHT_nitems_cdesc->base_addr = (int *) nitems;
    SHT_nitems_cdesc->type = SH_TYPE_INT;
    SHT_nitems_cdesc->elem_len = sizeof(int);
    SHT_nitems_cdesc->rank = 0;
    SHT_nitems_cdesc->size = 1;
    // splicer end function.getPtrToConstScalar_bufferify
}
// end POI_getPtrToConstScalar_bufferify

// ----------------------------------------
// Function:  void getPtrToFixedConstArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int **count +dimension(10)+intent(out)
// Statement: f_out_native**_cdesc_pointer
// start POI_getPtrToFixedConstArray_bufferify
void POI_getPtrToFixedConstArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc)
{
    // splicer begin function.getPtrToFixedConstArray_bufferify
    const int *count;
    getPtrToFixedConstArray(&count);
    SHT_count_cdesc->base_addr = (int *) count;
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = 10;
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    // splicer end function.getPtrToFixedConstArray_bufferify
}
// end POI_getPtrToFixedConstArray_bufferify

// ----------------------------------------
// Function:  void getPtrToDynamicConstArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int **count +dimension(ncount)+intent(out)
// Statement: f_out_native**_cdesc_pointer
// ----------------------------------------
// Argument:  int *ncount +hidden+intent(out)
// Statement: f_out_native*_hidden
// start POI_getPtrToDynamicConstArray_bufferify
void POI_getPtrToDynamicConstArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc)
{
    // splicer begin function.getPtrToDynamicConstArray_bufferify
    const int *count;
    int ncount;
    getPtrToDynamicConstArray(&count, &ncount);
    SHT_count_cdesc->base_addr = (int *) count;
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = ncount;
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    // splicer end function.getPtrToDynamicConstArray_bufferify
}
// end POI_getPtrToDynamicConstArray_bufferify

/**
 * Return a Fortran pointer to an array which is always the same length.
 */
// ----------------------------------------
// Function:  void getAllocToFixedArray
// Statement: f_subroutine
// ----------------------------------------
// Argument:  int **count +deref(allocatable)+dimension(10)+intent(out)
// Statement: f_out_native**_cdesc_allocatable
// start POI_getAllocToFixedArray_bufferify
void POI_getAllocToFixedArray_bufferify(
    POI_SHROUD_array *SHT_count_cdesc,
    POI_SHROUD_capsule_data *SHT_count_capsule)
{
    // splicer begin function.getAllocToFixedArray_bufferify
    int *count;
    getAllocToFixedArray(&count);
    SHT_count_cdesc->base_addr = count;
    SHT_count_cdesc->type = SH_TYPE_INT;
    SHT_count_cdesc->elem_len = sizeof(int);
    SHT_count_cdesc->rank = 1;
    SHT_count_cdesc->shape[0] = 10;
    SHT_count_cdesc->size = SHT_count_cdesc->shape[0];
    SHT_count_capsule->addr  = count;
    SHT_count_capsule->idtor = 0;
    // splicer end function.getAllocToFixedArray_bufferify
}
// end POI_getAllocToFixedArray_bufferify

// ----------------------------------------
// Function:  int *returnIntPtrToScalar
// Statement: f_function_native*_pointer
// start POI_returnIntPtrToScalar_bufferify
int * POI_returnIntPtrToScalar_bufferify(void)
{
    // splicer begin function.returnIntPtrToScalar_bufferify
    int *SHC_rv = returnIntPtrToScalar();
    return SHC_rv;
    // splicer end function.returnIntPtrToScalar_bufferify
}
// end POI_returnIntPtrToScalar_bufferify

// ----------------------------------------
// Function:  int *returnIntPtrToFixedArray +dimension(10)
// Statement: f_function_native*_cdesc_pointer
// start POI_returnIntPtrToFixedArray_bufferify
void POI_returnIntPtrToFixedArray_bufferify(
    POI_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.returnIntPtrToFixedArray_bufferify
    int *SHC_rv = returnIntPtrToFixedArray();
    SHT_rv_cdesc->base_addr = SHC_rv;
    SHT_rv_cdesc->type = SH_TYPE_INT;
    SHT_rv_cdesc->elem_len = sizeof(int);
    SHT_rv_cdesc->rank = 1;
    SHT_rv_cdesc->shape[0] = 10;
    SHT_rv_cdesc->size = SHT_rv_cdesc->shape[0];
    // splicer end function.returnIntPtrToFixedArray_bufferify
}
// end POI_returnIntPtrToFixedArray_bufferify

// ----------------------------------------
// Function:  const int *returnIntPtrToConstScalar
// Statement: f_function_native*_pointer
// start POI_returnIntPtrToConstScalar_bufferify
const int * POI_returnIntPtrToConstScalar_bufferify(void)
{
    // splicer begin function.returnIntPtrToConstScalar_bufferify
    const int *SHC_rv = returnIntPtrToConstScalar();
    return SHC_rv;
    // splicer end function.returnIntPtrToConstScalar_bufferify
}
// end POI_returnIntPtrToConstScalar_bufferify

// ----------------------------------------
// Function:  const int *returnIntPtrToFixedConstArray +dimension(10)
// Statement: f_function_native*_cdesc_pointer
// start POI_returnIntPtrToFixedConstArray_bufferify
void POI_returnIntPtrToFixedConstArray_bufferify(
    POI_SHROUD_array *SHT_rv_cdesc)
{
    // splicer begin function.returnIntPtrToFixedConstArray_bufferify
    const int *SHC_rv = returnIntPtrToFixedConstArray();
    SHT_rv_cdesc->base_addr = (int *) SHC_rv;
    SHT_rv_cdesc->type = SH_TYPE_INT;
    SHT_rv_cdesc->elem_len = sizeof(int);
    SHT_rv_cdesc->rank = 1;
    SHT_rv_cdesc->shape[0] = 10;
    SHT_rv_cdesc->size = SHT_rv_cdesc->shape[0];
    // splicer end function.returnIntPtrToFixedConstArray_bufferify
}
// end POI_returnIntPtrToFixedConstArray_bufferify

// ----------------------------------------
// Function:  int *returnIntScalar +deref(scalar)
// Statement: f_function_native*_scalar
// start POI_returnIntScalar_bufferify
int POI_returnIntScalar_bufferify(void)
{
    // splicer begin function.returnIntScalar_bufferify
    int *SHC_rv = returnIntScalar();
    return *SHC_rv;
    // splicer end function.returnIntScalar_bufferify
}
// end POI_returnIntScalar_bufferify

// ----------------------------------------
// Function:  int *returnIntAllocToFixedArray +deref(allocatable)+dimension(10)
// Statement: f_function_native*_cdesc_allocatable
// start POI_returnIntAllocToFixedArray_bufferify
void POI_returnIntAllocToFixedArray_bufferify(
    POI_SHROUD_array *SHT_rv_cdesc,
    POI_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.returnIntAllocToFixedArray_bufferify
    int *SHC_rv = returnIntAllocToFixedArray();
    SHT_rv_cdesc->base_addr = SHC_rv;
    SHT_rv_cdesc->type = SH_TYPE_INT;
    SHT_rv_cdesc->elem_len = sizeof(int);
    SHT_rv_cdesc->rank = 1;
    SHT_rv_cdesc->shape[0] = 10;
    SHT_rv_cdesc->size = SHT_rv_cdesc->shape[0];
    SHT_rv_capsule->addr  = SHC_rv;
    SHT_rv_capsule->idtor = 0;
    // splicer end function.returnIntAllocToFixedArray_bufferify
}
// end POI_returnIntAllocToFixedArray_bufferify
