! wrapfownership.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfownership.f
!! \brief Shroud generated wrapper for ownership library
!<
! splicer begin file_top
! splicer end file_top
module ownership_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! helper array_context
    type, bind(C) :: OWN_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type OWN_SHROUD_array

    ! helper capsule_data_helper
    type, bind(C) :: OWN_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type OWN_SHROUD_capsule_data

    ! helper capsule_helper
    type :: OWN_SHROUD_capsule
        private
        type(OWN_SHROUD_capsule_data) :: mem
    contains
        final :: SHROUD_capsule_final
        procedure :: delete => SHROUD_capsule_delete
    end type OWN_SHROUD_capsule

    type class1
        type(OWN_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.Class1.component_part
        ! splicer end class.Class1.component_part
    contains
        procedure :: dtor => class1_dtor
        procedure :: get_flag => class1_get_flag
        procedure :: get_instance => class1_get_instance
        procedure :: set_instance => class1_set_instance
        procedure :: associated => class1_associated
        ! splicer begin class.Class1.type_bound_procedure_part
        ! splicer end class.Class1.type_bound_procedure_part
    end type class1

    interface operator (.eq.)
        module procedure class1_eq
    end interface

    interface operator (.ne.)
        module procedure class1_ne
    end interface

    interface

        ! ----------------------------------------
        ! Function:  ~Class1
        ! Statement: f_dtor
        subroutine c_class1_dtor(self) &
                bind(C, name="OWN_Class1_dtor")
            import :: OWN_SHROUD_capsule_data
            implicit none
            type(OWN_SHROUD_capsule_data), intent(INOUT) :: self
        end subroutine c_class1_dtor

        ! Generated by getter/setter
        ! ----------------------------------------
        ! Function:  int get_flag +intent(getter)
        ! Statement: f_getter_native
        function c_class1_get_flag(self) &
                result(SHT_rv) &
                bind(C, name="OWN_Class1_get_flag")
            use iso_c_binding, only : C_INT
            import :: OWN_SHROUD_capsule_data
            implicit none
            type(OWN_SHROUD_capsule_data), intent(IN) :: self
            integer(C_INT) :: SHT_rv
        end function c_class1_get_flag

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrRaw +deref(raw)
        ! Statement: c_function_native*
        function c_return_int_ptr_raw() &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrRaw")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_raw

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrScalar +deref(scalar)
        ! Statement: c_function_native*
        function c_return_int_ptr_scalar() &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrScalar")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_scalar

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrScalar +deref(scalar)
        ! Statement: f_function_native*_scalar
        function return_int_ptr_scalar() &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrScalar_bufferify")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT) :: SHT_rv
        end function return_int_ptr_scalar

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrPointer +deref(pointer)
        ! Statement: c_function_native*
        function c_return_int_ptr_pointer() &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrPointer")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_pointer

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrPointer +deref(pointer)
        ! Statement: f_function_native*_pointer
        function c_return_int_ptr_pointer_bufferify() &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrPointer_bufferify")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_pointer_bufferify

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimRaw +deref(raw)
        ! Statement: c_function_native*
        ! ----------------------------------------
        ! Argument:  int *len +intent(out)
        ! Statement: c_out_native*
        function c_return_int_ptr_dim_raw(len) &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrDimRaw")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), intent(OUT) :: len
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_dim_raw

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimPointer +deref(pointer)+dimension(len)
        ! Statement: c_function_native*
        ! ----------------------------------------
        ! Argument:  int *len +hidden+intent(out)
        ! Statement: c_out_native*
        ! start c_return_int_ptr_dim_pointer
        function c_return_int_ptr_dim_pointer(len) &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrDimPointer")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), intent(OUT) :: len
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_dim_pointer
        ! end c_return_int_ptr_dim_pointer

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimPointer +deref(pointer)+dimension(len)
        ! Statement: f_function_native*_cdesc_pointer
        ! start c_return_int_ptr_dim_pointer_bufferify
        subroutine c_return_int_ptr_dim_pointer_bufferify(SHT_rv_cdesc) &
                bind(C, name="OWN_ReturnIntPtrDimPointer_bufferify")
            import :: OWN_SHROUD_array
            implicit none
            type(OWN_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_return_int_ptr_dim_pointer_bufferify
        ! end c_return_int_ptr_dim_pointer_bufferify

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimAlloc +deref(allocatable)+dimension(len)
        ! Statement: c_function_native*
        ! ----------------------------------------
        ! Argument:  int *len +hidden+intent(out)
        ! Statement: c_out_native*
        ! start c_return_int_ptr_dim_alloc
        function c_return_int_ptr_dim_alloc(len) &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrDimAlloc")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), intent(OUT) :: len
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_dim_alloc
        ! end c_return_int_ptr_dim_alloc

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimAlloc +deref(allocatable)+dimension(len)
        ! Statement: f_function_native*_cdesc_allocatable
        ! start c_return_int_ptr_dim_alloc_bufferify
        subroutine c_return_int_ptr_dim_alloc_bufferify(SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="OWN_ReturnIntPtrDimAlloc_bufferify")
            import :: OWN_SHROUD_array, OWN_SHROUD_capsule_data
            implicit none
            type(OWN_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(OWN_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_return_int_ptr_dim_alloc_bufferify
        ! end c_return_int_ptr_dim_alloc_bufferify

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimDefault +dimension(len)
        ! Statement: c_function_native*
        ! ----------------------------------------
        ! Argument:  int *len +hidden+intent(out)
        ! Statement: c_out_native*
        function c_return_int_ptr_dim_default(len) &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrDimDefault")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), intent(OUT) :: len
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_dim_default

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimDefault +dimension(len)
        ! Statement: f_function_native*_cdesc_pointer
        subroutine c_return_int_ptr_dim_default_bufferify(SHT_rv_cdesc) &
                bind(C, name="OWN_ReturnIntPtrDimDefault_bufferify")
            import :: OWN_SHROUD_array
            implicit none
            type(OWN_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
        end subroutine c_return_int_ptr_dim_default_bufferify

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimRawNew +dimension(len)+owner(caller)
        ! Statement: c_function_native*_caller
        ! ----------------------------------------
        ! Argument:  int *len +hidden+intent(out)
        ! Statement: c_out_native*
        function c_return_int_ptr_dim_raw_new(len) &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrDimRawNew")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), intent(OUT) :: len
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_dim_raw_new

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimPointerNew +deref(pointer)+dimension(len)+owner(caller)
        ! Statement: c_function_native*_caller
        ! ----------------------------------------
        ! Argument:  int *len +hidden+intent(out)
        ! Statement: c_out_native*
        function c_return_int_ptr_dim_pointer_new(len) &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrDimPointerNew")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), intent(OUT) :: len
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_dim_pointer_new

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimPointerNew +deref(pointer)+dimension(len)+owner(caller)
        ! Statement: f_function_native*_cdesc_pointer_caller
        subroutine c_return_int_ptr_dim_pointer_new_bufferify( &
                SHT_rv_cdesc, SHT_rv_capsule) &
                bind(C, name="OWN_ReturnIntPtrDimPointerNew_bufferify")
            import :: OWN_SHROUD_array, OWN_SHROUD_capsule_data
            implicit none
            type(OWN_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(OWN_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_return_int_ptr_dim_pointer_new_bufferify

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimAllocNew +deref(allocatable)+dimension(len)+owner(caller)
        ! Statement: c_function_native*_caller
        ! ----------------------------------------
        ! Argument:  int *len +hidden+intent(out)
        ! Statement: c_out_native*
        function c_return_int_ptr_dim_alloc_new(len) &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrDimAllocNew")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), intent(OUT) :: len
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_dim_alloc_new

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimDefaultNew +dimension(len)+owner(caller)
        ! Statement: c_function_native*_caller
        ! ----------------------------------------
        ! Argument:  int *len +hidden+intent(out)
        ! Statement: c_out_native*
        function c_return_int_ptr_dim_default_new(len) &
                result(SHT_rv) &
                bind(C, name="OWN_ReturnIntPtrDimDefaultNew")
            use iso_c_binding, only : C_INT, C_PTR
            implicit none
            integer(C_INT), intent(OUT) :: len
            type(C_PTR) :: SHT_rv
        end function c_return_int_ptr_dim_default_new

        ! ----------------------------------------
        ! Function:  int *ReturnIntPtrDimDefaultNew +dimension(len)+owner(caller)
        ! Statement: f_function_native*_cdesc_pointer_caller
        subroutine c_return_int_ptr_dim_default_new_bufferify( &
                SHT_rv_cdesc, SHT_rv_capsule) &
                bind(C, name="OWN_ReturnIntPtrDimDefaultNew_bufferify")
            import :: OWN_SHROUD_array, OWN_SHROUD_capsule_data
            implicit none
            type(OWN_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(OWN_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_return_int_ptr_dim_default_new_bufferify

        ! ----------------------------------------
        ! Function:  void createClassStatic
        ! Statement: f_subroutine
        ! ----------------------------------------
        ! Argument:  int flag
        ! Statement: f_in_native
        subroutine create_class_static(flag) &
                bind(C, name="OWN_createClassStatic")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), value, intent(IN) :: flag
        end subroutine create_class_static

        ! ----------------------------------------
        ! Function:  Class1 *getClassStatic +owner(library)
        ! Statement: c_function_shadow*_capptr_library
        function c_get_class_static(SHT_rv) &
                result(SHT_prv) &
                bind(C, name="OWN_getClassStatic")
            use iso_c_binding, only : C_PTR
            import :: OWN_SHROUD_capsule_data
            implicit none
            type(OWN_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_get_class_static

        ! ----------------------------------------
        ! Function:  Class1 *getClassStatic +owner(library)
        ! Statement: f_function_shadow*_capsule_library
        subroutine c_get_class_static_bufferify(SHT_rv) &
                bind(C, name="OWN_getClassStatic_bufferify")
            import :: OWN_SHROUD_capsule_data
            implicit none
            type(OWN_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_get_class_static_bufferify

        ! ----------------------------------------
        ! Function:  Class1 *getClassNew +owner(caller)
        ! Statement: c_function_shadow*_capptr_caller
        ! ----------------------------------------
        ! Argument:  int flag
        ! Statement: c_in_native
        function c_get_class_new(flag, SHT_rv) &
                result(SHT_prv) &
                bind(C, name="OWN_getClassNew")
            use iso_c_binding, only : C_INT, C_PTR
            import :: OWN_SHROUD_capsule_data
            implicit none
            integer(C_INT), value, intent(IN) :: flag
            type(OWN_SHROUD_capsule_data), intent(OUT) :: SHT_rv
            type(C_PTR) :: SHT_prv
        end function c_get_class_new

        ! ----------------------------------------
        ! Function:  Class1 *getClassNew +owner(caller)
        ! Statement: f_function_shadow*_capsule_caller
        ! ----------------------------------------
        ! Argument:  int flag
        ! Statement: f_in_native
        subroutine c_get_class_new_bufferify(flag, SHT_rv) &
                bind(C, name="OWN_getClassNew_bufferify")
            use iso_c_binding, only : C_INT
            import :: OWN_SHROUD_capsule_data
            implicit none
            integer(C_INT), value, intent(IN) :: flag
            type(OWN_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_get_class_new_bufferify
    end interface

    interface
        ! helper capsule_dtor
        ! Delete memory in a capsule.
        subroutine OWN_SHROUD_capsule_dtor(ptr) &
            bind(C, name="OWN_SHROUD_memory_destructor")
            import OWN_SHROUD_capsule_data
            implicit none
            type(OWN_SHROUD_capsule_data), intent(INOUT) :: ptr
        end subroutine OWN_SHROUD_capsule_dtor
    end interface

    interface
        ! helper copy_array
        ! Copy contents of context into c_var.
        subroutine OWN_SHROUD_copy_array(context, c_var, c_var_size) &
            bind(C, name="OWN_ShroudCopyArray")
            use iso_c_binding, only : C_PTR, C_SIZE_T
            import OWN_SHROUD_array
            type(OWN_SHROUD_array), intent(IN) :: context
            type(C_PTR), intent(IN), value :: c_var
            integer(C_SIZE_T), value :: c_var_size
        end subroutine OWN_SHROUD_copy_array
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

    ! ----------------------------------------
    ! Function:  ~Class1
    ! Statement: f_dtor
    subroutine class1_dtor(obj)
        class(class1), intent(INOUT) :: obj
        ! splicer begin class.Class1.method.dtor
        call c_class1_dtor(obj%cxxmem)
        ! splicer end class.Class1.method.dtor
    end subroutine class1_dtor

    ! Generated by getter/setter
    ! ----------------------------------------
    ! Function:  int get_flag +intent(getter)
    ! Statement: f_getter_native
    function class1_get_flag(obj) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        class(class1), intent(INOUT) :: obj
        integer(C_INT) :: SHT_rv
        ! splicer begin class.Class1.method.get_flag
        SHT_rv = c_class1_get_flag(obj%cxxmem)
        ! splicer end class.Class1.method.get_flag
    end function class1_get_flag

    ! Return pointer to C++ memory.
    function class1_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(class1), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function class1_get_instance

    subroutine class1_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(class1), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine class1_set_instance

    function class1_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(class1), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function class1_associated

    ! splicer begin class.Class1.additional_functions
    ! splicer end class.Class1.additional_functions

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int *ReturnIntPtrScalar +deref(scalar)
    ! Statement: f_function_native*_scalar
    function return_int_ptr_scalar() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT) :: SHT_rv
        ! splicer begin function.return_int_ptr_scalar
        SHT_rv = c_return_int_ptr_scalar_bufferify()
        ! splicer end function.return_int_ptr_scalar
    end function return_int_ptr_scalar
#endif

    ! ----------------------------------------
    ! Function:  int *ReturnIntPtrPointer +deref(pointer)
    ! Statement: f_function_native*_pointer
    function return_int_ptr_pointer() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_PTR, c_f_pointer
        integer(C_INT), pointer :: SHT_rv
        ! splicer begin function.return_int_ptr_pointer
        type(C_PTR) :: SHC_rv_ptr
        SHC_rv_ptr = c_return_int_ptr_pointer_bufferify()
        call c_f_pointer(SHC_rv_ptr, SHT_rv)
        ! splicer end function.return_int_ptr_pointer
    end function return_int_ptr_pointer

    ! ----------------------------------------
    ! Function:  int *ReturnIntPtrDimPointer +deref(pointer)+dimension(len)
    ! Statement: f_function_native*_cdesc_pointer
    ! start return_int_ptr_dim_pointer
    function return_int_ptr_dim_pointer() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin function.return_int_ptr_dim_pointer
        type(OWN_SHROUD_array) :: SHT_rv_cdesc
        call c_return_int_ptr_dim_pointer_bufferify(SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end function.return_int_ptr_dim_pointer
    end function return_int_ptr_dim_pointer
    ! end return_int_ptr_dim_pointer

    ! ----------------------------------------
    ! Function:  int *ReturnIntPtrDimAlloc +deref(allocatable)+dimension(len)
    ! Statement: f_function_native*_cdesc_allocatable
    ! start return_int_ptr_dim_alloc
    function return_int_ptr_dim_alloc() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_LOC, C_SIZE_T
        integer(C_INT), allocatable, target :: SHT_rv(:)
        ! splicer begin function.return_int_ptr_dim_alloc
        type(OWN_SHROUD_array) :: SHT_rv_cdesc
        type(OWN_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_return_int_ptr_dim_alloc_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(SHT_rv(SHT_rv_cdesc%shape(1)))
        call OWN_SHROUD_copy_array(SHT_rv_cdesc, C_LOC(SHT_rv), &
            size(SHT_rv, kind=C_SIZE_T))
        call OWN_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.return_int_ptr_dim_alloc
    end function return_int_ptr_dim_alloc
    ! end return_int_ptr_dim_alloc

    ! ----------------------------------------
    ! Function:  int *ReturnIntPtrDimDefault +dimension(len)
    ! Statement: f_function_native*_cdesc_pointer
    function return_int_ptr_dim_default() &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, c_f_pointer
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin function.return_int_ptr_dim_default
        type(OWN_SHROUD_array) :: SHT_rv_cdesc
        call c_return_int_ptr_dim_default_bufferify(SHT_rv_cdesc)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end function.return_int_ptr_dim_default
    end function return_int_ptr_dim_default

    ! ----------------------------------------
    ! Function:  int *ReturnIntPtrDimPointerNew +deref(pointer)+dimension(len)+owner(caller)
    ! Statement: f_function_native*_cdesc_pointer_caller
    function return_int_ptr_dim_pointer_new(Crv) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, c_f_pointer
        type(OWN_SHROUD_capsule), intent(OUT) :: Crv
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin function.return_int_ptr_dim_pointer_new
        type(OWN_SHROUD_array) :: SHT_rv_cdesc
        call c_return_int_ptr_dim_pointer_new_bufferify(SHT_rv_cdesc, &
            Crv%mem)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end function.return_int_ptr_dim_pointer_new
    end function return_int_ptr_dim_pointer_new

    ! ----------------------------------------
    ! Function:  int *ReturnIntPtrDimDefaultNew +dimension(len)+owner(caller)
    ! Statement: f_function_native*_cdesc_pointer_caller
    function return_int_ptr_dim_default_new(Crv) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, c_f_pointer
        type(OWN_SHROUD_capsule), intent(OUT) :: Crv
        integer(C_INT), pointer :: SHT_rv(:)
        ! splicer begin function.return_int_ptr_dim_default_new
        type(OWN_SHROUD_array) :: SHT_rv_cdesc
        call c_return_int_ptr_dim_default_new_bufferify(SHT_rv_cdesc, &
            Crv%mem)
        call c_f_pointer(SHT_rv_cdesc%base_addr, SHT_rv, &
            SHT_rv_cdesc%shape(1:1))
        ! splicer end function.return_int_ptr_dim_default_new
    end function return_int_ptr_dim_default_new

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void createClassStatic
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    subroutine create_class_static(flag)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: flag
        ! splicer begin function.create_class_static
        call c_create_class_static(flag)
        ! splicer end function.create_class_static
    end subroutine create_class_static
#endif

    ! ----------------------------------------
    ! Function:  Class1 *getClassStatic +owner(library)
    ! Statement: f_function_shadow*_capsule_library
    function get_class_static() &
            result(SHT_rv)
        type(class1) :: SHT_rv
        ! splicer begin function.get_class_static
        call c_get_class_static_bufferify(SHT_rv%cxxmem)
        ! splicer end function.get_class_static
    end function get_class_static

    ! ----------------------------------------
    ! Function:  Class1 *getClassNew +owner(caller)
    ! Statement: f_function_shadow*_capsule_caller
    ! ----------------------------------------
    ! Argument:  int flag
    ! Statement: f_in_native
    !>
    !! \brief Return pointer to new Class1 instance.
    !!
    !<
    function get_class_new(flag) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), value, intent(IN) :: flag
        type(class1) :: SHT_rv
        ! splicer begin function.get_class_new
        call c_get_class_new_bufferify(flag, SHT_rv%cxxmem)
        ! splicer end function.get_class_new
    end function get_class_new

    ! splicer begin additional_functions
    ! splicer end additional_functions

    function class1_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class1), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function class1_eq

    function class1_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class1), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function class1_ne

    ! helper capsule_helper
    ! finalize a static OWN_SHROUD_capsule_data
    subroutine SHROUD_capsule_final(cap)
        type(OWN_SHROUD_capsule), intent(INOUT) :: cap
        call OWN_SHROUD_capsule_dtor(cap%mem)
    end subroutine SHROUD_capsule_final

    subroutine SHROUD_capsule_delete(cap)
        class(OWN_SHROUD_capsule) :: cap
        call OWN_SHROUD_capsule_dtor(cap%mem)
    end subroutine SHROUD_capsule_delete

end module ownership_mod
