// pyownershipmodule.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//
#include "pyownershipmodule.hpp"
#define PY_ARRAY_UNIQUE_SYMBOL SHROUD_OWNERSHIP_ARRAY_API
#define NPY_NO_DEPRECATED_API NPY_1_7_API_VERSION
#include "numpy/arrayobject.h"

// splicer begin include
// splicer end include

#ifdef __cplusplus
#define SHROUD_UNUSED(param)
#else
#define SHROUD_UNUSED(param) param
#endif

#if PY_MAJOR_VERSION >= 3
#define PyInt_AsLong PyLong_AsLong
#define PyInt_FromLong PyLong_FromLong
#define PyInt_FromSize_t PyLong_FromSize_t
#define PyString_FromString PyUnicode_FromString
#define PyString_FromStringAndSize PyUnicode_FromStringAndSize
#endif

// splicer begin C_definition
// splicer end C_definition
PyObject *PY_error_obj;

// splicer begin additional_functions
// splicer end additional_functions

// ----------------------------------------
// Function:  int *ReturnIntPtrScalar +deref(scalar)
// Statement: py_function_native*_scalar
static char PY_ReturnIntPtrScalar__doc__[] =
"documentation"
;

static PyObject *
PY_ReturnIntPtrScalar(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ReturnIntPtrScalar
    PyObject * SHTPy_rv = nullptr;

    int *SHCXX_rv = ReturnIntPtrScalar();

    // post_call
    SHTPy_rv = PyInt_FromLong(*SHCXX_rv);

    return (PyObject *) SHTPy_rv;
// splicer end function.ReturnIntPtrScalar
}

// ----------------------------------------
// Function:  int *ReturnIntPtrPointer +deref(pointer)
// Statement: py_function_native*_numpy
static char PY_ReturnIntPtrPointer__doc__[] =
"documentation"
;

static PyObject *
PY_ReturnIntPtrPointer(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ReturnIntPtrPointer
    PyObject * SHTPy_rv = nullptr;

    int *SHCXX_rv = ReturnIntPtrPointer();

    // post_call
    SHTPy_rv = PyArray_SimpleNewFromData(0, nullptr, NPY_INT, SHCXX_rv);
    if (SHTPy_rv == nullptr) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return nullptr;
// splicer end function.ReturnIntPtrPointer
}

// ----------------------------------------
// Function:  int *ReturnIntPtrDimPointer +deref(pointer)+dimension(len)
// Statement: py_function_native*_numpy
// ----------------------------------------
// Argument:  int *len +hidden+intent(out)
// Statement: py_out_native*
static char PY_ReturnIntPtrDimPointer__doc__[] =
"documentation"
;

static PyObject *
PY_ReturnIntPtrDimPointer(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ReturnIntPtrDimPointer
    int len;
    npy_intp SHD_rv[1];
    PyObject * SHTPy_rv = nullptr;

    int *SHCXX_rv = ReturnIntPtrDimPointer(&len);

    // post_call
    SHD_rv[0] = len;
    SHTPy_rv = PyArray_SimpleNewFromData(1, SHD_rv, NPY_INT, SHCXX_rv);
    if (SHTPy_rv == nullptr) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return nullptr;
// splicer end function.ReturnIntPtrDimPointer
}

// ----------------------------------------
// Function:  int *ReturnIntPtrDimAlloc +deref(allocatable)+dimension(len)
// Statement: py_function_native*_numpy
// ----------------------------------------
// Argument:  int *len +hidden+intent(out)
// Statement: py_out_native*
static char PY_ReturnIntPtrDimAlloc__doc__[] =
"documentation"
;

static PyObject *
PY_ReturnIntPtrDimAlloc(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ReturnIntPtrDimAlloc
    int len;
    npy_intp SHD_rv[1];
    PyObject * SHTPy_rv = nullptr;

    int *SHCXX_rv = ReturnIntPtrDimAlloc(&len);

    // post_call
    SHD_rv[0] = len;
    SHTPy_rv = PyArray_SimpleNewFromData(1, SHD_rv, NPY_INT, SHCXX_rv);
    if (SHTPy_rv == nullptr) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return nullptr;
// splicer end function.ReturnIntPtrDimAlloc
}

// ----------------------------------------
// Function:  int *ReturnIntPtrDimDefault +dimension(len)
// Statement: py_function_native*_numpy
// ----------------------------------------
// Argument:  int *len +hidden+intent(out)
// Statement: py_out_native*
static char PY_ReturnIntPtrDimDefault__doc__[] =
"documentation"
;

static PyObject *
PY_ReturnIntPtrDimDefault(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ReturnIntPtrDimDefault
    int len;
    npy_intp SHD_rv[1];
    PyObject * SHTPy_rv = nullptr;

    int *SHCXX_rv = ReturnIntPtrDimDefault(&len);

    // post_call
    SHD_rv[0] = len;
    SHTPy_rv = PyArray_SimpleNewFromData(1, SHD_rv, NPY_INT, SHCXX_rv);
    if (SHTPy_rv == nullptr) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return nullptr;
// splicer end function.ReturnIntPtrDimDefault
}

// ----------------------------------------
// Function:  int *ReturnIntPtrDimPointerNew +deref(pointer)+dimension(len)+owner(caller)
// Statement: py_function_native*_numpy
// ----------------------------------------
// Argument:  int *len +hidden+intent(out)
// Statement: py_out_native*
static char PY_ReturnIntPtrDimPointerNew__doc__[] =
"documentation"
;

static PyObject *
PY_ReturnIntPtrDimPointerNew(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ReturnIntPtrDimPointerNew
    int len;
    npy_intp SHD_rv[1];
    PyObject * SHTPy_rv = nullptr;

    int *SHCXX_rv = ReturnIntPtrDimPointerNew(&len);

    // post_call
    SHD_rv[0] = len;
    SHTPy_rv = PyArray_SimpleNewFromData(1, SHD_rv, NPY_INT, SHCXX_rv);
    if (SHTPy_rv == nullptr) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return nullptr;
// splicer end function.ReturnIntPtrDimPointerNew
}

// ----------------------------------------
// Function:  int *ReturnIntPtrDimAllocNew +deref(allocatable)+dimension(len)+owner(caller)
// Statement: py_function_native*_numpy
// ----------------------------------------
// Argument:  int *len +hidden+intent(out)
// Statement: py_out_native*
static char PY_ReturnIntPtrDimAllocNew__doc__[] =
"documentation"
;

static PyObject *
PY_ReturnIntPtrDimAllocNew(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ReturnIntPtrDimAllocNew
    int len;
    npy_intp SHD_rv[1];
    PyObject * SHTPy_rv = nullptr;

    int *SHCXX_rv = ReturnIntPtrDimAllocNew(&len);

    // post_call
    SHD_rv[0] = len;
    SHTPy_rv = PyArray_SimpleNewFromData(1, SHD_rv, NPY_INT, SHCXX_rv);
    if (SHTPy_rv == nullptr) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return nullptr;
// splicer end function.ReturnIntPtrDimAllocNew
}

// ----------------------------------------
// Function:  int *ReturnIntPtrDimDefaultNew +dimension(len)+owner(caller)
// Statement: py_function_native*_numpy
// ----------------------------------------
// Argument:  int *len +hidden+intent(out)
// Statement: py_out_native*
static char PY_ReturnIntPtrDimDefaultNew__doc__[] =
"documentation"
;

static PyObject *
PY_ReturnIntPtrDimDefaultNew(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.ReturnIntPtrDimDefaultNew
    int len;
    npy_intp SHD_rv[1];
    PyObject * SHTPy_rv = nullptr;

    int *SHCXX_rv = ReturnIntPtrDimDefaultNew(&len);

    // post_call
    SHD_rv[0] = len;
    SHTPy_rv = PyArray_SimpleNewFromData(1, SHD_rv, NPY_INT, SHCXX_rv);
    if (SHTPy_rv == nullptr) goto fail;

    return (PyObject *) SHTPy_rv;

fail:
    Py_XDECREF(SHTPy_rv);
    return nullptr;
// splicer end function.ReturnIntPtrDimDefaultNew
}

// ----------------------------------------
// Function:  void createClassStatic
// Statement: py_subroutine
// ----------------------------------------
// Argument:  int flag
// Statement: py_in_native
static char PY_createClassStatic__doc__[] =
"documentation"
;

static PyObject *
PY_createClassStatic(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.createClassStatic
    int flag;
    const char *SHT_kwlist[] = {
        "flag",
        nullptr };

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "i:createClassStatic",
        const_cast<char **>(SHT_kwlist), &flag))
        return nullptr;

    createClassStatic(flag);
    Py_RETURN_NONE;
// splicer end function.createClassStatic
}

// ----------------------------------------
// Function:  Class1 *getClassStatic +owner(library)
// Statement: py_function_shadow*
static char PY_getClassStatic__doc__[] =
"documentation"
;

static PyObject *
PY_getClassStatic(
  PyObject *SHROUD_UNUSED(self),
  PyObject *SHROUD_UNUSED(args),
  PyObject *SHROUD_UNUSED(kwds))
{
// splicer begin function.getClassStatic
    Class1 *SHCXX_rv = getClassStatic();

    // post_call
    PY_Class1 * SHTPy_rv = PyObject_New(PY_Class1, &PY_Class1_Type);
    SHTPy_rv->obj = SHCXX_rv;

    return (PyObject *) SHTPy_rv;
// splicer end function.getClassStatic
}

// ----------------------------------------
// Function:  Class1 *getClassNew +owner(caller)
// Statement: py_function_shadow*
// ----------------------------------------
// Argument:  int flag
// Statement: py_in_native
static char PY_getClassNew__doc__[] =
"documentation"
;

/**
 * \brief Return pointer to new Class1 instance.
 *
 */
static PyObject *
PY_getClassNew(
  PyObject *SHROUD_UNUSED(self),
  PyObject *args,
  PyObject *kwds)
{
// splicer begin function.getClassNew
    int flag;
    const char *SHT_kwlist[] = {
        "flag",
        nullptr };

    if (!PyArg_ParseTupleAndKeywords(args, kwds, "i:getClassNew",
        const_cast<char **>(SHT_kwlist), &flag))
        return nullptr;

    Class1 *SHCXX_rv = getClassNew(flag);

    // post_call
    PY_Class1 * SHTPy_rv = PyObject_New(PY_Class1, &PY_Class1_Type);
    SHTPy_rv->obj = SHCXX_rv;

    return (PyObject *) SHTPy_rv;
// splicer end function.getClassNew
}
static PyMethodDef PY_methods[] = {
{"ReturnIntPtrScalar", (PyCFunction)PY_ReturnIntPtrScalar, METH_NOARGS,
    PY_ReturnIntPtrScalar__doc__},
{"ReturnIntPtrPointer", (PyCFunction)PY_ReturnIntPtrPointer,
    METH_NOARGS, PY_ReturnIntPtrPointer__doc__},
{"ReturnIntPtrDimPointer", (PyCFunction)PY_ReturnIntPtrDimPointer,
    METH_NOARGS, PY_ReturnIntPtrDimPointer__doc__},
{"ReturnIntPtrDimAlloc", (PyCFunction)PY_ReturnIntPtrDimAlloc,
    METH_NOARGS, PY_ReturnIntPtrDimAlloc__doc__},
{"ReturnIntPtrDimDefault", (PyCFunction)PY_ReturnIntPtrDimDefault,
    METH_NOARGS, PY_ReturnIntPtrDimDefault__doc__},
{"ReturnIntPtrDimPointerNew", (PyCFunction)PY_ReturnIntPtrDimPointerNew,
    METH_NOARGS, PY_ReturnIntPtrDimPointerNew__doc__},
{"ReturnIntPtrDimAllocNew", (PyCFunction)PY_ReturnIntPtrDimAllocNew,
    METH_NOARGS, PY_ReturnIntPtrDimAllocNew__doc__},
{"ReturnIntPtrDimDefaultNew", (PyCFunction)PY_ReturnIntPtrDimDefaultNew,
    METH_NOARGS, PY_ReturnIntPtrDimDefaultNew__doc__},
{"createClassStatic", (PyCFunction)PY_createClassStatic,
    METH_VARARGS|METH_KEYWORDS, PY_createClassStatic__doc__},
{"getClassStatic", (PyCFunction)PY_getClassStatic, METH_NOARGS,
    PY_getClassStatic__doc__},
{"getClassNew", (PyCFunction)PY_getClassNew, METH_VARARGS|METH_KEYWORDS,
    PY_getClassNew__doc__},
{nullptr,   (PyCFunction)nullptr, 0, nullptr}            /* sentinel */
};

/*
 * initownership - Initialization function for the module
 * *must* be called initownership
 */
static char PY__doc__[] =
"library documentation"
;

struct module_state {
    PyObject *error;
};

#if PY_MAJOR_VERSION >= 3
#define GETSTATE(m) ((struct module_state*)PyModule_GetState(m))
#else
#define GETSTATE(m) (&_state)
static struct module_state _state;
#endif

#if PY_MAJOR_VERSION >= 3
static int ownership_traverse(PyObject *m, visitproc visit, void *arg) {
    Py_VISIT(GETSTATE(m)->error);
    return 0;
}

static int ownership_clear(PyObject *m) {
    Py_CLEAR(GETSTATE(m)->error);
    return 0;
}

static struct PyModuleDef moduledef = {
    PyModuleDef_HEAD_INIT,
    "ownership", /* m_name */
    PY__doc__, /* m_doc */
    sizeof(struct module_state), /* m_size */
    PY_methods, /* m_methods */
    nullptr, /* m_reload */
    ownership_traverse, /* m_traverse */
    ownership_clear, /* m_clear */
    NULL  /* m_free */
};

#define RETVAL m
#define INITERROR return nullptr
#else
#define RETVAL
#define INITERROR return
#endif

extern "C" PyMODINIT_FUNC
#if PY_MAJOR_VERSION >= 3
PyInit_ownership(void)
#else
initownership(void)
#endif
{
    PyObject *m = nullptr;
    const char * error_name = "ownership.Error";

    // splicer begin C_init_locals
    // splicer end C_init_locals


    /* Create the module and add the functions */
#if PY_MAJOR_VERSION >= 3
    m = PyModule_Create(&moduledef);
#else
    m = Py_InitModule4("ownership", PY_methods,
        PY__doc__,
        (PyObject*)nullptr,PYTHON_API_VERSION);
#endif
    if (m == nullptr)
        return RETVAL;
    struct module_state *st = GETSTATE(m);

    import_array();

    // Class1
    PY_Class1_Type.tp_new   = PyType_GenericNew;
    PY_Class1_Type.tp_alloc = PyType_GenericAlloc;
    if (PyType_Ready(&PY_Class1_Type) < 0)
        return RETVAL;
    Py_INCREF(&PY_Class1_Type);
    PyModule_AddObject(m, "Class1", (PyObject *)&PY_Class1_Type);

    PY_error_obj = PyErr_NewException((char *) error_name, nullptr, nullptr);
    if (PY_error_obj == nullptr)
        return RETVAL;
    st->error = PY_error_obj;
    PyModule_AddObject(m, "Error", st->error);

    // splicer begin C_init_body
    // splicer end C_init_body

    /* Check for errors */
    if (PyErr_Occurred())
        Py_FatalError("can't initialize module ownership");
    return RETVAL;
}

