! wrapfns.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfns.f
!! \brief Shroud generated wrapper for ns library
!<
! splicer begin file_top
! splicer end file_top
module ns_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! helper array_context
    type, bind(C) :: NS_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type NS_SHROUD_array

    ! helper capsule_data_helper
    type, bind(C) :: NS_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type NS_SHROUD_capsule_data

    !  enum upper::Color
    integer, parameter :: upper_color = C_INT
    ! splicer begin namespace.XXX.enum.Color
    integer(upper_color), parameter :: upper_error = 0
    integer(upper_color), parameter :: upper_warn = 1
    ! splicer end namespace.XXX.enum.Color

    type class_work
        type(NS_SHROUD_capsule_data) :: cxxmem
        ! splicer begin namespace.outer.class.ClassWork.component_part
        ! splicer end namespace.outer.class.ClassWork.component_part
    contains
        procedure :: get_instance => nswork_class_work_get_instance
        procedure :: set_instance => nswork_class_work_set_instance
        procedure :: associated => nswork_class_work_associated
        ! splicer begin namespace.outer.class.ClassWork.type_bound_procedure_part
        ! splicer end namespace.outer.class.ClassWork.type_bound_procedure_part
    end type class_work

    interface operator (.eq.)
        module procedure nswork_class_work_eq
    end interface

    interface operator (.ne.)
        module procedure nswork_class_work_ne
    end interface

    interface

        ! ----------------------------------------
        ! Function:  const std::string &LastFunctionCalled
        ! Statement: c_function_string&
        function c_last_function_called() &
                result(SHT_rv) &
                bind(C, name="NS_LastFunctionCalled")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_last_function_called

        ! ----------------------------------------
        ! Function:  const std::string &LastFunctionCalled
        ! Statement: f_function_string&_cdesc_allocatable
        subroutine c_last_function_called_bufferify(SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="NS_LastFunctionCalled_bufferify")
            import :: NS_SHROUD_array, NS_SHROUD_capsule_data
            implicit none
            type(NS_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(NS_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_last_function_called_bufferify

        ! ----------------------------------------
        ! Function:  void One
        ! Statement: f_subroutine
        subroutine one() &
                bind(C, name="NS_One")
            implicit none
        end subroutine one
    end interface

    interface
        ! helper capsule_dtor
        ! Delete memory in a capsule.
        subroutine NS_SHROUD_capsule_dtor(ptr) &
            bind(C, name="NS_SHROUD_memory_destructor")
            import NS_SHROUD_capsule_data
            implicit none
            type(NS_SHROUD_capsule_data), intent(INOUT) :: ptr
        end subroutine NS_SHROUD_capsule_dtor
    end interface

    interface
        ! helper copy_string
        ! Copy the char* or std::string in context into c_var.
        subroutine NS_SHROUD_copy_string(context, c_var, c_var_size) &
             bind(c,name="NS_ShroudCopyString")
            use, intrinsic :: iso_c_binding, only : C_CHAR, C_SIZE_T
            import NS_SHROUD_array
            type(NS_SHROUD_array), intent(IN) :: context
            character(kind=C_CHAR), intent(OUT) :: c_var(*)
            integer(C_SIZE_T), value :: c_var_size
        end subroutine NS_SHROUD_copy_string
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

    ! ----------------------------------------
    ! Function:  const std::string &LastFunctionCalled
    ! Statement: f_function_string&_cdesc_allocatable
    function last_function_called() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.last_function_called
        type(NS_SHROUD_array) :: SHT_rv_cdesc
        type(NS_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_last_function_called_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call NS_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call NS_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.last_function_called
    end function last_function_called

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void One
    ! Statement: f_subroutine
    subroutine one()
        ! splicer begin function.one
        call c_one()
        ! splicer end function.one
    end subroutine one
#endif

    ! splicer begin additional_functions
    ! splicer end additional_functions

    ! Return pointer to C++ memory.
    function nswork_class_work_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(class_work), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function nswork_class_work_get_instance

    subroutine nswork_class_work_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(class_work), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine nswork_class_work_set_instance

    function nswork_class_work_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(class_work), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function nswork_class_work_associated

    ! splicer begin namespace.outer.class.ClassWork.additional_functions
    ! splicer end namespace.outer.class.ClassWork.additional_functions

    function nswork_class_work_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class_work), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function nswork_class_work_eq

    function nswork_class_work_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(class_work), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function nswork_class_work_ne

end module ns_mod
