// top.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// typemap
#include <string>
// shroud
#include <cstring>
#include <cstdlib>
#include "top.h"

// splicer begin CXX_definitions
// Add some text from splicer
// And another line
// splicer end CXX_definitions

extern "C" {


// helper char_len_trim
// Returns the length of character string src with length nsrc,
// ignoring any trailing blanks.
static int ShroudCharLenTrim(const char *src, int nsrc) {
    int i;

    for (i = nsrc - 1; i >= 0; i--) {
        if (src[i] != ' ') {
            break;
        }
    }

    return i + 1;
}


// helper char_alloc
// Copy src into new memory and null terminate.
// If ntrim is 0, return NULL pointer.
// If blanknull is 1, return NULL when string is blank.
static char *ShroudCharAlloc(const char *src, int nsrc, int blanknull)
{
    int ntrim = ShroudCharLenTrim(src, nsrc);
    if (ntrim == 0 && blanknull == 1) {
        return nullptr;
    }
    char *rv = (char *) std::malloc(nsrc + 1);
    if (ntrim > 0) {
        std::memcpy(rv, src, ntrim);
    }
    rv[ntrim] = '\0';
    return rv;
}

// helper ShroudCharCopy
// Copy src into dest, blank fill to ndest characters
// Truncate if dest is too short.
// dest will not be NULL terminated.
static void ShroudCharCopy(char *dest, int ndest, const char *src, int nsrc)
{
    if (src == NULL) {
        std::memset(dest,' ',ndest); // convert NULL pointer to blank filled string
    } else {
        if (nsrc < 0) nsrc = std::strlen(src);
        int nm = nsrc < ndest ? nsrc : ndest;
        std::memcpy(dest,src,nm);
        if(ndest > nm) std::memset(dest+nm,' ',ndest-nm); // blank fill
    }
}

// helper char_free
// Release memory allocated by ShroudCharAlloc
static void ShroudCharFree(char *src)
{
    if (src != NULL) {
        std::free(src);
    }
}

// splicer begin C_definitions
// splicer end C_definitions

// ----------------------------------------
// Function:  void getName
// Statement: c_subroutine
// ----------------------------------------
// Argument:  char *name +len(worklen)+len_trim(worktrim)
// Statement: c_inout_char*
void TES_getName(char *name)
{
    // splicer begin function.getName
    getName(name);
    // splicer end function.getName
}

// ----------------------------------------
// Function:  void getName
// Statement: f_subroutine
// ----------------------------------------
// Argument:  char *name +len(worklen)+len_trim(worktrim)
// Statement: f_inout_char*_buf
void TES_getName_bufferify(char *name, int SHT_name_len)
{
    // splicer begin function.getName_bufferify
    char * SHT_name_str = ShroudCharAlloc(name, SHT_name_len, 0);
    getName(SHT_name_str);
    ShroudCharCopy(name, SHT_name_len, SHT_name_str, -1);
    ShroudCharFree(SHT_name_str);
    // splicer end function.getName_bufferify
}

// ----------------------------------------
// Function:  void function1
// Statement: c_subroutine
void YYY_TES_function1(void)
{
    // splicer begin function.function1
    function1();
    // splicer end function.function1
}

// ----------------------------------------
// Function:  void function2
// Statement: c_subroutine
void c_name_special(void)
{
    // splicer begin function.function2
    function2();
    // splicer end function.function2
}

// ----------------------------------------
// Function:  void function3a
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int i
// Statement: c_in_native
void YYY_TES_function3a_0(int i)
{
    // splicer begin function.function3a_0
    function3a(i);
    // splicer end function.function3a_0
}

// ----------------------------------------
// Function:  void function3a
// Statement: c_subroutine
// ----------------------------------------
// Argument:  long i
// Statement: c_in_native
void YYY_TES_function3a_1(long i)
{
    // splicer begin function.function3a_1
    function3a(i);
    // splicer end function.function3a_1
}

// ----------------------------------------
// Function:  int function4
// Statement: c_function_native
// ----------------------------------------
// Argument:  const std::string &rv
// Statement: c_in_string&
int YYY_TES_function4(const char *rv)
{
    // splicer begin function.function4
    const std::string SHC_rv_cxx(rv);
    int SHC_rv = function4(SHC_rv_cxx);
    return SHC_rv;
    // splicer end function.function4
}

// ----------------------------------------
// Function:  int function4
// Statement: f_function_native
// ----------------------------------------
// Argument:  const std::string &rv
// Statement: f_in_string&_buf
int YYY_TES_function4_bufferify(char *rv, int SHT_rv_len)
{
    // splicer begin function.function4_bufferify
    const std::string SHC_rv_cxx(rv, ShroudCharLenTrim(rv, SHT_rv_len));
    int SHC_rv = function4(SHC_rv_cxx);
    return SHC_rv;
    // splicer end function.function4_bufferify
}

// ----------------------------------------
// Function:  void function5 +name(fiveplus)
// Statement: c_subroutine
void YYY_TES_fiveplus(void)
{
    // splicer begin function.fiveplus
    fiveplus();
    // splicer end function.fiveplus
}

/**
 * Use std::string argument to get bufferified function.
 */
// ----------------------------------------
// Function:  void TestMultilineSplicer
// Statement: c_subroutine
// ----------------------------------------
// Argument:  std::string &name
// Statement: c_inout_string&
// ----------------------------------------
// Argument:  int *value +intent(out)
// Statement: c_out_native*
void TES_TestMultilineSplicer(char *name, int *value)
{
    // splicer begin function.TestMultilineSplicer
    // line 1
    // line 2
    // splicer end function.TestMultilineSplicer
}

/**
 * Use std::string argument to get bufferified function.
 */
// ----------------------------------------
// Function:  void TestMultilineSplicer
// Statement: f_subroutine
// ----------------------------------------
// Argument:  std::string &name
// Statement: f_inout_string&_buf
// ----------------------------------------
// Argument:  int *value +intent(out)
// Statement: f_out_native*
void TES_TestMultilineSplicer_bufferify(char *name, int SHT_name_len,
    int *value)
{
    // splicer begin function.TestMultilineSplicer_bufferify
    // buf line 1
    // buf line 2
    // splicer end function.TestMultilineSplicer_bufferify
}

/**
 * \brief Function template with two template parameters.
 *
 */
// Generated by cxx_template
// ----------------------------------------
// Function:  void FunctionTU
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int arg1
// Statement: c_in_native
// ----------------------------------------
// Argument:  long arg2
// Statement: c_in_native
void c_name_instantiation1(int arg1, long arg2)
{
    // splicer begin function.FunctionTU_0
    FunctionTU<int, long>(arg1, arg2);
    // splicer end function.FunctionTU_0
}

/**
 * \brief Function template with two template parameters.
 *
 */
// Generated by cxx_template
// ----------------------------------------
// Function:  void FunctionTU
// Statement: c_subroutine
// ----------------------------------------
// Argument:  float arg1
// Statement: c_in_native
// ----------------------------------------
// Argument:  double arg2
// Statement: c_in_native
void TES_FunctionTU_instantiation2(float arg1, double arg2)
{
    // splicer begin function.FunctionTU_instantiation2
    FunctionTU<float, double>(arg1, arg2);
    // splicer end function.FunctionTU_instantiation2
}

/**
 * \brief Function which uses a templated T in the implemetation.
 *
 */
// Generated by cxx_template
// ----------------------------------------
// Function:  int UseImplWorker
// Statement: c_function_native
int TES_UseImplWorker_instantiation3(void)
{
    // splicer begin function.UseImplWorker_instantiation3
    int SHC_rv = UseImplWorker<internal::ImplWorker1>();
    return SHC_rv;
    // splicer end function.UseImplWorker_instantiation3
}

// ----------------------------------------
// Function:  int Cstruct_as_class_sum
// Statement: c_function_native
// ----------------------------------------
// Argument:  const Cstruct_as_class *point +pass
// Statement: c_in_shadow*
int TES_Cstruct_as_class_sum(TES_Cstruct_as_class * point)
{
    // splicer begin function.Cstruct_as_class_sum
    const Cstruct_as_class * SHC_point_cxx =
        static_cast<const Cstruct_as_class *>(point->addr);
    int SHC_rv = Cstruct_as_class_sum(SHC_point_cxx);
    return SHC_rv;
    // splicer end function.Cstruct_as_class_sum
}

// ----------------------------------------
// Function:  void external_funcs
// Statement: c_subroutine
// ----------------------------------------
// Argument:  const char *rdbase
// Statement: c_in_char*
// ----------------------------------------
// Argument:  const char *pkg
// Statement: c_in_char*
// ----------------------------------------
// Argument:  const char *name
// Statement: c_in_char*
// ----------------------------------------
// Argument:  void (*alloc)(double *arr +intent(inout), int *err +intent(out))
// Statement: c_in_procedure
// ----------------------------------------
// Argument:  void (*afree)(double *arr +intent(inout))
// Statement: c_in_procedure
// ----------------------------------------
// Argument:  void (*assoc)(double *arr +intent(in), int *err +intent(out))
// Statement: c_in_procedure
void TES_external_funcs(const char *rdbase, const char *pkg,
    const char *name, void (*alloc)(double *arr, int *err),
    void (*afree)(double *arr), void (*assoc)(double *arr, int *err))
{
    // splicer begin function.external_funcs
    external_funcs(rdbase, pkg, name, alloc, afree, assoc);
    // splicer end function.external_funcs
}

// ----------------------------------------
// Function:  void bindtest
// Statement: c_subroutine
// ----------------------------------------
// Argument:  int arg1
// Statement: c_in_native
void TES_bindtest(int arg1)
{
    // splicer begin function.bindtest
    bindtest(arg1);
    // splicer end function.bindtest
}

}  // extern "C"
