// wrapmemdoc.cpp
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// typemap
#include <string>
// shroud
#include <cstddef>
#include <cstring>
#include "wrapmemdoc.h"

// splicer begin CXX_definitions
// splicer end CXX_definitions

extern "C" {


// start helper string_to_cdesc
// helper string_to_cdesc
// Save std::string metadata into array to allow Fortran to access values.
// CHARACTER(len=elem_size) src
static void ShroudStringToCdesc(STR_SHROUD_array *cdesc,
    const std::string * src)
{
    if (src->empty()) {
        cdesc->base_addr = NULL;
        cdesc->elem_len = 0;
    } else {
        cdesc->base_addr = const_cast<char *>(src->data());
        cdesc->elem_len = src->length();
    }
    cdesc->size = 1;
    cdesc->rank = 0;  // scalar
}
// end helper string_to_cdesc

// splicer begin C_definitions
// splicer end C_definitions

// ----------------------------------------
// Function:  const std::string *getConstStringPtrAlloc +owner(library)
// Statement: c_function_string*_library
// start STR_getConstStringPtrAlloc
const char * STR_getConstStringPtrAlloc(void)
{
    // splicer begin function.getConstStringPtrAlloc
    const std::string *SHCXX_rv = getConstStringPtrAlloc();
    const char * SHC_rv = SHCXX_rv->c_str();
    return SHC_rv;
    // splicer end function.getConstStringPtrAlloc
}
// end STR_getConstStringPtrAlloc

// ----------------------------------------
// Function:  const std::string *getConstStringPtrAlloc +owner(library)
// Statement: f_function_string*_cdesc_allocatable_library
// start STR_getConstStringPtrAlloc_bufferify
void STR_getConstStringPtrAlloc_bufferify(
    STR_SHROUD_array *SHT_rv_cdesc,
    STR_SHROUD_capsule_data *SHT_rv_capsule)
{
    // splicer begin function.getConstStringPtrAlloc_bufferify
    const std::string *SHCXX_rv = getConstStringPtrAlloc();
    ShroudStringToCdesc(SHT_rv_cdesc, SHCXX_rv);
    SHT_rv_capsule->addr  = const_cast<std::string *>(SHCXX_rv);
    SHT_rv_capsule->idtor = 0;
    // splicer end function.getConstStringPtrAlloc_bufferify
}
// end STR_getConstStringPtrAlloc_bufferify

}  // extern "C"
