! wrapfmemdoc.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfmemdoc.f
!! \brief Shroud generated wrapper for memdoc library
!<
! splicer begin file_top
! splicer end file_top
module memdoc_mod
    use iso_c_binding, only : C_INT, C_LONG, C_NULL_PTR, C_PTR, C_SIZE_T
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    ! splicer end module_top

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    ! start helper array_context
    ! helper array_context
    type, bind(C) :: STR_SHROUD_array
        ! address of data
        type(C_PTR) :: base_addr = C_NULL_PTR
        ! type of element
        integer(C_INT) :: type
        ! bytes-per-item or character len of data in cxx
        integer(C_SIZE_T) :: elem_len = 0_C_SIZE_T
        ! size of data in cxx
        integer(C_SIZE_T) :: size = 0_C_SIZE_T
        ! number of dimensions
        integer(C_INT) :: rank = -1
        integer(C_LONG) :: shape(7) = 0
    end type STR_SHROUD_array
    ! end helper array_context

    ! start helper capsule_data_helper
    ! helper capsule_data_helper
    type, bind(C) :: STR_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type STR_SHROUD_capsule_data
    ! end helper capsule_data_helper

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrAlloc +owner(library)
    ! Statement: c_function_string*_library
    ! start c_get_const_string_ptr_alloc
    interface
        function c_get_const_string_ptr_alloc() &
                result(SHT_rv) &
                bind(C, name="STR_getConstStringPtrAlloc")
            use iso_c_binding, only : C_PTR
            implicit none
            type(C_PTR) :: SHT_rv
        end function c_get_const_string_ptr_alloc
    end interface
    ! end c_get_const_string_ptr_alloc

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrAlloc +owner(library)
    ! Statement: f_function_string*_cdesc_allocatable_library
    ! start c_get_const_string_ptr_alloc_bufferify
    interface
        subroutine c_get_const_string_ptr_alloc_bufferify(SHT_rv_cdesc, &
                SHT_rv_capsule) &
                bind(C, name="STR_getConstStringPtrAlloc_bufferify")
            import :: STR_SHROUD_array, STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_array), intent(OUT) :: SHT_rv_cdesc
            type(STR_SHROUD_capsule_data), intent(OUT) :: SHT_rv_capsule
        end subroutine c_get_const_string_ptr_alloc_bufferify
    end interface
    ! end c_get_const_string_ptr_alloc_bufferify

    interface
        ! helper capsule_dtor
        ! Delete memory in a capsule.
        subroutine STR_SHROUD_capsule_dtor(ptr) &
            bind(C, name="STR_SHROUD_memory_destructor")
            import STR_SHROUD_capsule_data
            implicit none
            type(STR_SHROUD_capsule_data), intent(INOUT) :: ptr
        end subroutine STR_SHROUD_capsule_dtor
    end interface

    interface
        ! helper copy_string
        ! Copy the char* or std::string in context into c_var.
        subroutine STR_SHROUD_copy_string(context, c_var, c_var_size) &
             bind(c,name="STR_ShroudCopyString")
            use, intrinsic :: iso_c_binding, only : C_CHAR, C_SIZE_T
            import STR_SHROUD_array
            type(STR_SHROUD_array), intent(IN) :: context
            character(kind=C_CHAR), intent(OUT) :: c_var(*)
            integer(C_SIZE_T), value :: c_var_size
        end subroutine STR_SHROUD_copy_string
    end interface

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

    ! ----------------------------------------
    ! Function:  const std::string *getConstStringPtrAlloc +owner(library)
    ! Statement: f_function_string*_cdesc_allocatable_library
    ! start get_const_string_ptr_alloc
    function get_const_string_ptr_alloc() &
            result(SHT_rv)
        character(len=:), allocatable :: SHT_rv
        ! splicer begin function.get_const_string_ptr_alloc
        type(STR_SHROUD_array) :: SHT_rv_cdesc
        type(STR_SHROUD_capsule_data) :: SHT_rv_capsule
        call c_get_const_string_ptr_alloc_bufferify(SHT_rv_cdesc, &
            SHT_rv_capsule)
        allocate(character(len=SHT_rv_cdesc%elem_len):: SHT_rv)
        call STR_SHROUD_copy_string(SHT_rv_cdesc, SHT_rv, &
            SHT_rv_cdesc%elem_len)
        call STR_SHROUD_capsule_dtor(SHT_rv_capsule)
        ! splicer end function.get_const_string_ptr_alloc
    end function get_const_string_ptr_alloc
    ! end get_const_string_ptr_alloc

    ! splicer begin additional_functions
    ! splicer end additional_functions

end module memdoc_mod
