// wrapgeneric.h
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//
/**
 * \file wrapgeneric.h
 * \brief Shroud generated wrapper for generic library
 */
// For C users and C implementation

#ifndef WRAPGENERIC_H
#define WRAPGENERIC_H

// typemap
#include <stddef.h>
// shroud
#include "typesgeneric.h"

// shroud
#include "ISO_Fortran_binding.h"

// splicer begin C_declarations
// splicer end C_declarations

int GEN_SumValues_CFI(CFI_cdesc_t *SHT_values_cfi, int nvalues);

void GEN_AssignValues_scalar_bufferify(const int *from, int nfrom,
    int *to, int nto);

void GEN_AssignValues_broadcast_CFI(const int *from, int nfrom,
    CFI_cdesc_t *SHT_to_cfi, int nto);

void GEN_AssignValues_copy_CFI(CFI_cdesc_t *SHT_from_cfi, int nfrom,
    CFI_cdesc_t *SHT_to_cfi, int nto);

#if 1
void GEN_SavePointer_float1d_CFI(CFI_cdesc_t *SHT_addr_cfi, int type,
    size_t size);
#endif

#if 1
void GEN_SavePointer_float2d_CFI(CFI_cdesc_t *SHT_addr_cfi, int type,
    size_t size);
#endif

void GEN_SavePointer2_float1d_CFI(CFI_cdesc_t *SHT_addr_cfi, int type,
    size_t size);

void GEN_SavePointer2_float2d_CFI(CFI_cdesc_t *SHT_addr_cfi, int type,
    size_t size);

#if 0
void GEN_GetPointerAsPointer_float1d_CFI(CFI_cdesc_t *SHT_addr_cfi);
#endif

#if 0
void GEN_GetPointerAsPointer_float2d_CFI(CFI_cdesc_t *SHT_addr_cfi);
#endif

void GEN_CreateStructAsClass_bufferify(GEN_StructAsClass * SHC_rv);

long GEN_UpdateStructAsClass_int_bufferify(GEN_StructAsClass * arg,
    int inew);

long GEN_UpdateStructAsClass_long_bufferify(GEN_StructAsClass * arg,
    long inew);

#endif  // WRAPGENERIC_H
