// wrapgeneric.c
// This file is generated by Shroud nowrite-version. Do not edit.
// Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
// other Shroud Project Developers.
// See the top-level COPYRIGHT file for details.
//
// SPDX-License-Identifier: (BSD-3-Clause)
//

// cxx_header
#include "generic.h"
#include "helper.h"
// shroud
#include "wrapgeneric.h"

// splicer begin C_definitions
// splicer end C_definitions

/**
 * \brief scalar or array argument using assumed rank
 *
 */
// ----------------------------------------
// Function:  int SumValues
// Statement: f_function_native
// ----------------------------------------
// Argument:  const int *values +dimension(..)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  int nvalues
// Statement: f_in_native
int GEN_SumValues_CFI(CFI_cdesc_t *SHT_values_cfi, int nvalues)
{
    // splicer begin function.SumValues_CFI
    int *SHC_values_cxx = (int *) SHT_values_cfi->base_addr;
    int SHC_rv = SumValues(SHC_values_cxx, nvalues);
    return SHC_rv;
    // splicer end function.SumValues_CFI
}

/**
 * Broadcast if nfrom == 1
 * Copy if nfrom == nto
 */
// Generated by fortran_generic
// ----------------------------------------
// Function:  void AssignValues
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int *from
// Statement: f_in_native*
// ----------------------------------------
// Argument:  int nfrom
// Statement: f_in_native
// ----------------------------------------
// Argument:  int *to
// Statement: f_inout_native*
// ----------------------------------------
// Argument:  int nto
// Statement: f_in_native
void GEN_AssignValues_scalar_bufferify(const int *from, int nfrom,
    int *to, int nto)
{
    // splicer begin function.AssignValues_scalar_bufferify
    AssignValues(from, nfrom, to, nto);
    // splicer end function.AssignValues_scalar_bufferify
}

/**
 * Broadcast if nfrom == 1
 * Copy if nfrom == nto
 */
// Generated by fortran_generic
// ----------------------------------------
// Function:  void AssignValues
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int *from
// Statement: f_in_native*
// ----------------------------------------
// Argument:  int nfrom
// Statement: f_in_native
// ----------------------------------------
// Argument:  int *to +rank(1)
// Statement: f_inout_native*_cfi
// ----------------------------------------
// Argument:  int nto
// Statement: f_in_native
void GEN_AssignValues_broadcast_CFI(const int *from, int nfrom,
    CFI_cdesc_t *SHT_to_cfi, int nto)
{
    // splicer begin function.AssignValues_broadcast_CFI
    int *SHC_to_cxx = (int *) SHT_to_cfi->base_addr;
    AssignValues(from, nfrom, SHC_to_cxx, nto);
    // splicer end function.AssignValues_broadcast_CFI
}

/**
 * Broadcast if nfrom == 1
 * Copy if nfrom == nto
 */
// Generated by fortran_generic
// ----------------------------------------
// Function:  void AssignValues
// Statement: f_subroutine
// ----------------------------------------
// Argument:  const int *from +rank(1)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  int nfrom
// Statement: f_in_native
// ----------------------------------------
// Argument:  int *to +rank(1)
// Statement: f_inout_native*_cfi
// ----------------------------------------
// Argument:  int nto
// Statement: f_in_native
void GEN_AssignValues_copy_CFI(CFI_cdesc_t *SHT_from_cfi, int nfrom,
    CFI_cdesc_t *SHT_to_cfi, int nto)
{
    // splicer begin function.AssignValues_copy_CFI
    int *SHC_from_cxx = (int *) SHT_from_cfi->base_addr;
    int *SHC_to_cxx = (int *) SHT_to_cfi->base_addr;
    AssignValues(SHC_from_cxx, nfrom, SHC_to_cxx, nto);
    // splicer end function.AssignValues_copy_CFI
}

#if 1
// Generated by fortran_generic
// ----------------------------------------
// Function:  void SavePointer
// Statement: f_subroutine
// ----------------------------------------
// Argument:  float *addr +intent(in)+rank(1)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  int type +implied(T_FLOAT)
// Statement: f_in_native
// ----------------------------------------
// Argument:  size_t size +implied(size(addr))
// Statement: f_in_native
void GEN_SavePointer_float1d_CFI(CFI_cdesc_t *SHT_addr_cfi, int type,
    size_t size)
{
    // splicer begin function.SavePointer_float1d_CFI
    float *SHC_addr_cxx = (float *) SHT_addr_cfi->base_addr;
    SavePointer(SHC_addr_cxx, type, size);
    // splicer end function.SavePointer_float1d_CFI
}
#endif  // if 1

#if 1
// Generated by fortran_generic
// ----------------------------------------
// Function:  void SavePointer
// Statement: f_subroutine
// ----------------------------------------
// Argument:  float *addr +intent(in)+rank(2)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  int type +implied(T_FLOAT)
// Statement: f_in_native
// ----------------------------------------
// Argument:  size_t size +implied(size(addr))
// Statement: f_in_native
void GEN_SavePointer_float2d_CFI(CFI_cdesc_t *SHT_addr_cfi, int type,
    size_t size)
{
    // splicer begin function.SavePointer_float2d_CFI
    float *SHC_addr_cxx = (float *) SHT_addr_cfi->base_addr;
    SavePointer(SHC_addr_cxx, type, size);
    // splicer end function.SavePointer_float2d_CFI
}
#endif  // if 1

// Generated by fortran_generic
// ----------------------------------------
// Function:  void SavePointer2
// Statement: f_subroutine
// ----------------------------------------
// Argument:  float *addr +intent(in)+rank(1)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  int type +implied(type(addr))
// Statement: f_in_native
// ----------------------------------------
// Argument:  size_t size +implied(size(addr))
// Statement: f_in_native
void GEN_SavePointer2_float1d_CFI(CFI_cdesc_t *SHT_addr_cfi, int type,
    size_t size)
{
    // splicer begin function.SavePointer2_float1d_CFI
    float *SHC_addr_cxx = (float *) SHT_addr_cfi->base_addr;
    // Test adding a blank line below.

    type = convert_type(type);
    SavePointer2(SHC_addr_cxx, type, size);
    // splicer end function.SavePointer2_float1d_CFI
}

// Generated by fortran_generic
// ----------------------------------------
// Function:  void SavePointer2
// Statement: f_subroutine
// ----------------------------------------
// Argument:  float *addr +intent(in)+rank(2)
// Statement: f_in_native*_cfi
// ----------------------------------------
// Argument:  int type +implied(type(addr))
// Statement: f_in_native
// ----------------------------------------
// Argument:  size_t size +implied(size(addr))
// Statement: f_in_native
void GEN_SavePointer2_float2d_CFI(CFI_cdesc_t *SHT_addr_cfi, int type,
    size_t size)
{
    // splicer begin function.SavePointer2_float2d_CFI
    float *SHC_addr_cxx = (float *) SHT_addr_cfi->base_addr;
    // Test adding a blank line below.

    type = convert_type(type);
    SavePointer2(SHC_addr_cxx, type, size);
    // splicer end function.SavePointer2_float2d_CFI
}

#if 0
// Generated by fortran_generic
// ----------------------------------------
// Function:  void GetPointerAsPointer
// Statement: f_subroutine
// ----------------------------------------
// Argument:  float **addr +deref(pointer)+intent(out)+rank(1)
// Statement: f_out_native**_cfi_pointer
// ----------------------------------------
// Argument:  int *type +hidden+intent(out)
// Statement: f_out_native*_hidden
// ----------------------------------------
// Argument:  size_t *size +hidden+intent(out)
// Statement: f_out_native*_hidden
void GEN_GetPointerAsPointer_float1d_CFI(CFI_cdesc_t *SHT_addr_cfi)
{
    // splicer begin function.GetPointerAsPointer_float1d_CFI
    float * SHC_addr_cxx;
    int type;
    size_t size;
    GetPointerAsPointer(&SHC_addr_cxx, &type, &size);
    {
        CFI_CDESC_T(0) SHC_addr_fptr;
        CFI_cdesc_t *SHC_addr_cdesc = (CFI_cdesc_t *) &SHC_addr_fptr;
        void *SHC_addr_cptr = const_cast<float *>(SHC_addr_cxx);
        int SHC_addr_err = CFI_establish(SHC_addr_cdesc, SHC_addr_cptr,
            CFI_attribute_pointer, CFI_type_float, 0, 0, NULL);
        if (SHC_addr_err == CFI_SUCCESS) {
            SHC_addr_err = CFI_setpointer(SHT_addr_cfi, SHC_addr_cdesc,
                NULL);
        }
    }
    // splicer end function.GetPointerAsPointer_float1d_CFI
}
#endif  // if 0

#if 0
// Generated by fortran_generic
// ----------------------------------------
// Function:  void GetPointerAsPointer
// Statement: f_subroutine
// ----------------------------------------
// Argument:  float **addr +deref(pointer)+intent(out)+rank(2)
// Statement: f_out_native**_cfi_pointer
// ----------------------------------------
// Argument:  int *type +hidden+intent(out)
// Statement: f_out_native*_hidden
// ----------------------------------------
// Argument:  size_t *size +hidden+intent(out)
// Statement: f_out_native*_hidden
void GEN_GetPointerAsPointer_float2d_CFI(CFI_cdesc_t *SHT_addr_cfi)
{
    // splicer begin function.GetPointerAsPointer_float2d_CFI
    float * SHC_addr_cxx;
    int type;
    size_t size;
    GetPointerAsPointer(&SHC_addr_cxx, &type, &size);
    {
        CFI_CDESC_T(0) SHC_addr_fptr;
        CFI_cdesc_t *SHC_addr_cdesc = (CFI_cdesc_t *) &SHC_addr_fptr;
        void *SHC_addr_cptr = const_cast<float *>(SHC_addr_cxx);
        int SHC_addr_err = CFI_establish(SHC_addr_cdesc, SHC_addr_cptr,
            CFI_attribute_pointer, CFI_type_float, 0, 0, NULL);
        if (SHC_addr_err == CFI_SUCCESS) {
            SHC_addr_err = CFI_setpointer(SHT_addr_cfi, SHC_addr_cdesc,
                NULL);
        }
    }
    // splicer end function.GetPointerAsPointer_float2d_CFI
}
#endif  // if 0

// ----------------------------------------
// Function:  StructAsClass *CreateStructAsClass
// Statement: f_function_shadow*_capsule
void GEN_CreateStructAsClass_bufferify(GEN_StructAsClass * SHC_rv)
{
    // splicer begin function.CreateStructAsClass_bufferify
    StructAsClass *SHC_rv_cxx = CreateStructAsClass();
    SHC_rv->addr  = SHC_rv_cxx;
    SHC_rv->idtor = 0;
    // splicer end function.CreateStructAsClass_bufferify
}

// Generated by fortran_generic
// ----------------------------------------
// Function:  long UpdateStructAsClass
// Statement: f_function_native
// ----------------------------------------
// Argument:  StructAsClass *arg
// Statement: f_inout_shadow*
// ----------------------------------------
// Argument:  int inew
// Statement: f_in_native
long GEN_UpdateStructAsClass_int_bufferify(GEN_StructAsClass * arg,
    int inew)
{
    // splicer begin function.UpdateStructAsClass_int_bufferify
    StructAsClass * SHC_arg_cxx = (StructAsClass *) arg->addr;
    long SHC_rv = UpdateStructAsClass(SHC_arg_cxx, inew);
    return SHC_rv;
    // splicer end function.UpdateStructAsClass_int_bufferify
}

// Generated by fortran_generic
// ----------------------------------------
// Function:  long UpdateStructAsClass
// Statement: f_function_native
// ----------------------------------------
// Argument:  StructAsClass *arg
// Statement: f_inout_shadow*
// ----------------------------------------
// Argument:  long inew
// Statement: f_in_native
long GEN_UpdateStructAsClass_long_bufferify(GEN_StructAsClass * arg,
    long inew)
{
    // splicer begin function.UpdateStructAsClass_long_bufferify
    StructAsClass * SHC_arg_cxx = (StructAsClass *) arg->addr;
    long SHC_rv = UpdateStructAsClass(SHC_arg_cxx, inew);
    return SHC_rv;
    // splicer end function.UpdateStructAsClass_long_bufferify
}
