! wrapfgeneric.f
! This file is generated by Shroud nowrite-version. Do not edit.
! Copyright (c) 2017-2024, Lawrence Livermore National Security, LLC and
! other Shroud Project Developers.
! See the top-level COPYRIGHT file for details.
!
! SPDX-License-Identifier: (BSD-3-Clause)
!
!>
!! \file wrapfgeneric.f
!! \brief Shroud generated wrapper for generic library
!<
! splicer begin file_top
! splicer end file_top
module generic_mod
    use iso_c_binding, only : C_INT, C_NULL_PTR, C_PTR
    ! splicer begin module_use
    ! splicer end module_use
    implicit none

    ! splicer begin module_top
    integer, parameter :: T_INT = 1
    integer, parameter :: T_LONG = 2
    integer, parameter :: T_FLOAT = 3
    integer, parameter :: T_DOUBLE = 4
    ! splicer end module_top

    ! start helper capsule_data_helper
    ! helper capsule_data_helper
    type, bind(C) :: GEN_SHROUD_capsule_data
        type(C_PTR) :: addr = C_NULL_PTR  ! address of C++ memory
        integer(C_INT) :: idtor = 0       ! index of destructor
    end type GEN_SHROUD_capsule_data
    ! end helper capsule_data_helper

    ! helper type_defines
    ! Shroud type defines from helper type_defines
    integer, parameter, private :: &
        SH_TYPE_SIGNED_CHAR= 1, &
        SH_TYPE_SHORT      = 2, &
        SH_TYPE_INT        = 3, &
        SH_TYPE_LONG       = 4, &
        SH_TYPE_LONG_LONG  = 5, &
        SH_TYPE_SIZE_T     = 6, &
        SH_TYPE_UNSIGNED_SHORT      = SH_TYPE_SHORT + 100, &
        SH_TYPE_UNSIGNED_INT        = SH_TYPE_INT + 100, &
        SH_TYPE_UNSIGNED_LONG       = SH_TYPE_LONG + 100, &
        SH_TYPE_UNSIGNED_LONG_LONG  = SH_TYPE_LONG_LONG + 100, &
        SH_TYPE_INT8_T    =  7, &
        SH_TYPE_INT16_T   =  8, &
        SH_TYPE_INT32_T   =  9, &
        SH_TYPE_INT64_T   = 10, &
        SH_TYPE_UINT8_T  =  SH_TYPE_INT8_T + 100, &
        SH_TYPE_UINT16_T =  SH_TYPE_INT16_T + 100, &
        SH_TYPE_UINT32_T =  SH_TYPE_INT32_T + 100, &
        SH_TYPE_UINT64_T =  SH_TYPE_INT64_T + 100, &
        SH_TYPE_FLOAT       = 22, &
        SH_TYPE_DOUBLE      = 23, &
        SH_TYPE_LONG_DOUBLE = 24, &
        SH_TYPE_FLOAT_COMPLEX      = 25, &
        SH_TYPE_DOUBLE_COMPLEX     = 26, &
        SH_TYPE_LONG_DOUBLE_COMPLEX= 27, &
        SH_TYPE_BOOL      = 28, &
        SH_TYPE_CHAR      = 29, &
        SH_TYPE_CPTR      = 30, &
        SH_TYPE_STRUCT    = 31, &
        SH_TYPE_OTHER     = 32

    type struct_as_class
        type(GEN_SHROUD_capsule_data) :: cxxmem
        ! splicer begin class.StructAsClass.component_part
        ! splicer end class.StructAsClass.component_part
    contains
        procedure :: get_instance => struct_as_class_get_instance
        procedure :: set_instance => struct_as_class_set_instance
        procedure :: associated => struct_as_class_associated
        ! splicer begin class.StructAsClass.type_bound_procedure_part
        ! splicer end class.StructAsClass.type_bound_procedure_part
    end type struct_as_class

    interface operator (.eq.)
        module procedure struct_as_class_eq
    end interface

    interface operator (.ne.)
        module procedure struct_as_class_ne
    end interface

    ! ----------------------------------------
    ! Function:  void UpdateAsFloat
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float arg
    ! Statement: f_in_native
    interface
        subroutine c_update_as_float(arg) &
                bind(C, name="UpdateAsFloat")
            use iso_c_binding, only : C_FLOAT
            implicit none
            real(C_FLOAT), value, intent(IN) :: arg
        end subroutine c_update_as_float
    end interface

    ! ----------------------------------------
    ! Function:  void UpdateAsDouble
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double arg
    ! Statement: f_in_native
    interface
        subroutine c_update_as_double(arg) &
                bind(C, name="UpdateAsDouble")
            use iso_c_binding, only : C_DOUBLE
            implicit none
            real(C_DOUBLE), value, intent(IN) :: arg
        end subroutine c_update_as_double
    end interface

    ! ----------------------------------------
    ! Function:  double GetGlobalDouble
    ! Statement: f_function_native
    interface
        function get_global_double() &
                result(SHT_rv) &
                bind(C, name="GetGlobalDouble")
            use iso_c_binding, only : C_DOUBLE
            implicit none
            real(C_DOUBLE) :: SHT_rv
        end function get_global_double
    end interface

    ! ----------------------------------------
    ! Function:  void GenericReal
    ! Statement: c_subroutine
    ! ----------------------------------------
    ! Argument:  double arg
    ! Statement: c_in_native
    ! start c_generic_real
    interface
        subroutine c_generic_real(arg) &
                bind(C, name="GenericReal")
            use iso_c_binding, only : C_DOUBLE
            implicit none
            real(C_DOUBLE), value, intent(IN) :: arg
        end subroutine c_generic_real
    end interface
    ! end c_generic_real

    ! ----------------------------------------
    ! Function:  long GenericReal2
    ! Statement: c_function_native
    ! ----------------------------------------
    ! Argument:  long arg1
    ! Statement: c_in_native
    ! ----------------------------------------
    ! Argument:  long arg2
    ! Statement: c_in_native
    interface
        function c_generic_real2(arg1, arg2) &
                result(SHT_rv) &
                bind(C, name="GenericReal2")
            use iso_c_binding, only : C_LONG
            implicit none
            integer(C_LONG), value, intent(IN) :: arg1
            integer(C_LONG), value, intent(IN) :: arg2
            integer(C_LONG) :: SHT_rv
        end function c_generic_real2
    end interface

    ! ----------------------------------------
    ! Function:  int SumValues
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const int *values +dimension(..)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int nvalues
    ! Statement: f_in_native
    interface
        function sum_values(values, nvalues) &
                result(SHT_rv) &
                bind(C, name="GEN_SumValues_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: values(..)
            integer(C_INT), value, intent(IN) :: nvalues
            integer(C_INT) :: SHT_rv
        end function sum_values
    end interface

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void AssignValues
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *from
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int nfrom
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *to
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int nto
    ! Statement: f_in_native
    interface
        subroutine c_assign_values_scalar_bufferify(from, nfrom, to, &
                nto) &
                bind(C, name="GEN_AssignValues_scalar_bufferify")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: from
            integer(C_INT), value, intent(IN) :: nfrom
            integer(C_INT), intent(INOUT) :: to
            integer(C_INT), value, intent(IN) :: nto
        end subroutine c_assign_values_scalar_bufferify
    end interface

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void AssignValues
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *from
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int nfrom
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *to +rank(1)
    ! Statement: f_inout_native*_cfi
    ! ----------------------------------------
    ! Argument:  int nto
    ! Statement: f_in_native
    interface
        subroutine c_assign_values_broadcast_CFI(from, nfrom, to, nto) &
                bind(C, name="GEN_AssignValues_broadcast_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: from
            integer(C_INT), value, intent(IN) :: nfrom
            integer(C_INT), intent(INOUT) :: to(:)
            integer(C_INT), value, intent(IN) :: nto
        end subroutine c_assign_values_broadcast_CFI
    end interface

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void AssignValues
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *from +rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int nfrom
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *to +rank(1)
    ! Statement: f_inout_native*_cfi
    ! ----------------------------------------
    ! Argument:  int nto
    ! Statement: f_in_native
    interface
        subroutine c_assign_values_copy_CFI(from, nfrom, to, nto) &
                bind(C, name="GEN_AssignValues_copy_CFI")
            use iso_c_binding, only : C_INT
            implicit none
            integer(C_INT), intent(IN) :: from(:)
            integer(C_INT), value, intent(IN) :: nfrom
            integer(C_INT), intent(INOUT) :: to(:)
            integer(C_INT), value, intent(IN) :: nto
        end subroutine c_assign_values_copy_CFI
    end interface

#if 1
    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void SavePointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float *addr +intent(in)+rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int type +implied(T_FLOAT)
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  size_t size +implied(size(addr))
    ! Statement: f_in_native
    interface
        subroutine c_save_pointer_float1d_CFI(addr, type, size) &
                bind(C, name="GEN_SavePointer_float1d_CFI")
            use iso_c_binding, only : C_FLOAT, C_INT, C_SIZE_T
            implicit none
            real(C_FLOAT), intent(IN) :: addr(:)
            integer(C_INT), value, intent(IN) :: type
            integer(C_SIZE_T), value, intent(IN) :: size
        end subroutine c_save_pointer_float1d_CFI
    end interface
#endif

#if 1
    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void SavePointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float *addr +intent(in)+rank(2)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int type +implied(T_FLOAT)
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  size_t size +implied(size(addr))
    ! Statement: f_in_native
    interface
        subroutine c_save_pointer_float2d_CFI(addr, type, size) &
                bind(C, name="GEN_SavePointer_float2d_CFI")
            use iso_c_binding, only : C_FLOAT, C_INT, C_SIZE_T
            implicit none
            real(C_FLOAT), intent(IN) :: addr(:,:)
            integer(C_INT), value, intent(IN) :: type
            integer(C_SIZE_T), value, intent(IN) :: size
        end subroutine c_save_pointer_float2d_CFI
    end interface
#endif

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void SavePointer2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float *addr +intent(in)+rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int type +implied(type(addr))
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  size_t size +implied(size(addr))
    ! Statement: f_in_native
    interface
        subroutine c_save_pointer2_float1d_CFI(addr, type, size) &
                bind(C, name="GEN_SavePointer2_float1d_CFI")
            use iso_c_binding, only : C_FLOAT, C_INT, C_SIZE_T
            implicit none
            real(C_FLOAT), intent(IN) :: addr(:)
            integer(C_INT), value, intent(IN) :: type
            integer(C_SIZE_T), value, intent(IN) :: size
        end subroutine c_save_pointer2_float1d_CFI
    end interface

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void SavePointer2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float *addr +intent(in)+rank(2)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int type +implied(type(addr))
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  size_t size +implied(size(addr))
    ! Statement: f_in_native
    interface
        subroutine c_save_pointer2_float2d_CFI(addr, type, size) &
                bind(C, name="GEN_SavePointer2_float2d_CFI")
            use iso_c_binding, only : C_FLOAT, C_INT, C_SIZE_T
            implicit none
            real(C_FLOAT), intent(IN) :: addr(:,:)
            integer(C_INT), value, intent(IN) :: type
            integer(C_SIZE_T), value, intent(IN) :: size
        end subroutine c_save_pointer2_float2d_CFI
    end interface

    ! ----------------------------------------
    ! Function:  void GetPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **addr +intent(out)
    ! Statement: f_out_void**
    ! ----------------------------------------
    ! Argument:  int *type +intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  size_t *size +intent(out)
    ! Statement: f_out_native*
    interface
        subroutine get_pointer(addr, type, size) &
                bind(C, name="GetPointer")
            use iso_c_binding, only : C_INT, C_PTR, C_SIZE_T
            implicit none
            type(C_PTR), intent(OUT) :: addr
            integer(C_INT), intent(OUT) :: type
            integer(C_SIZE_T), intent(OUT) :: size
        end subroutine get_pointer
    end interface

#if 0
    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void GetPointerAsPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float **addr +deref(pointer)+intent(out)+rank(1)
    ! Statement: f_out_native**_cfi_pointer
    interface
        subroutine c_get_pointer_as_pointer_float1d_CFI(addr) &
                bind(C, name="GEN_GetPointerAsPointer_float1d_CFI")
            use iso_c_binding, only : C_FLOAT
            implicit none
            real(C_FLOAT), intent(OUT), pointer :: addr(:)
        end subroutine c_get_pointer_as_pointer_float1d_CFI
    end interface
#endif

#if 0
    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void GetPointerAsPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float **addr +deref(pointer)+intent(out)+rank(2)
    ! Statement: f_out_native**_cfi_pointer
    interface
        subroutine c_get_pointer_as_pointer_float2d_CFI(addr) &
                bind(C, name="GEN_GetPointerAsPointer_float2d_CFI")
            use iso_c_binding, only : C_FLOAT
            implicit none
            real(C_FLOAT), intent(OUT), pointer :: addr(:,:)
        end subroutine c_get_pointer_as_pointer_float2d_CFI
    end interface
#endif

    ! ----------------------------------------
    ! Function:  StructAsClass *CreateStructAsClass
    ! Statement: f_function_shadow*_capsule
    interface
        subroutine c_create_struct_as_class_bufferify(SHT_rv) &
                bind(C, name="GEN_CreateStructAsClass_bufferify")
            import :: GEN_SHROUD_capsule_data
            implicit none
            type(GEN_SHROUD_capsule_data), intent(OUT) :: SHT_rv
        end subroutine c_create_struct_as_class_bufferify
    end interface

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  long UpdateStructAsClass
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  StructAsClass *arg
    ! Statement: f_inout_shadow*
    ! ----------------------------------------
    ! Argument:  int inew
    ! Statement: f_in_native
    interface
        function c_update_struct_as_class_int_bufferify(arg, inew) &
                result(SHT_rv) &
                bind(C, name="GEN_UpdateStructAsClass_int_bufferify")
            use iso_c_binding, only : C_INT, C_LONG
            import :: GEN_SHROUD_capsule_data
            implicit none
            type(GEN_SHROUD_capsule_data), intent(INOUT) :: arg
            integer(C_INT), value, intent(IN) :: inew
            integer(C_LONG) :: SHT_rv
        end function c_update_struct_as_class_int_bufferify
    end interface

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  long UpdateStructAsClass
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  StructAsClass *arg
    ! Statement: f_inout_shadow*
    ! ----------------------------------------
    ! Argument:  long inew
    ! Statement: f_in_native
    interface
        function c_update_struct_as_class_long_bufferify(arg, inew) &
                result(SHT_rv) &
                bind(C, name="GEN_UpdateStructAsClass_long_bufferify")
            use iso_c_binding, only : C_LONG
            import :: GEN_SHROUD_capsule_data
            implicit none
            type(GEN_SHROUD_capsule_data), intent(INOUT) :: arg
            integer(C_LONG), value, intent(IN) :: inew
            integer(C_LONG) :: SHT_rv
        end function c_update_struct_as_class_long_bufferify
    end interface

    interface assign_values
        module procedure assign_values_scalar
        module procedure assign_values_broadcast
        module procedure assign_values_copy
    end interface assign_values

    ! start generic interface generic_real
    interface generic_real
        module procedure generic_real_float
        module procedure generic_real_double
    end interface generic_real
    ! end generic interface generic_real

    interface generic_real2
        module procedure generic_real2_all_int
        module procedure generic_real2_all_long
    end interface generic_real2

#if 0
    interface get_pointer_as_pointer
        module procedure get_pointer_as_pointer_float1d
        module procedure get_pointer_as_pointer_float2d
    end interface get_pointer_as_pointer
#endif

#if 1
    interface save_pointer
        module procedure save_pointer_float1d
        module procedure save_pointer_float2d
    end interface save_pointer
#endif

    interface save_pointer2
        module procedure save_pointer2_float1d
        module procedure save_pointer2_float2d
    end interface save_pointer2

    interface struct_as_class
        module procedure create_struct_as_class
    end interface struct_as_class

    interface update_real
        module procedure update_as_float
        module procedure update_as_double
    end interface update_real

    interface update_struct_as_class
        module procedure update_struct_as_class_int
        module procedure update_struct_as_class_long
    end interface update_struct_as_class

    ! splicer begin additional_declarations
    ! splicer end additional_declarations

contains

    ! Return pointer to C++ memory.
    function struct_as_class_get_instance(obj) result (cxxptr)
        use iso_c_binding, only: C_PTR
        class(struct_as_class), intent(IN) :: obj
        type(C_PTR) :: cxxptr
        cxxptr = obj%cxxmem%addr
    end function struct_as_class_get_instance

    subroutine struct_as_class_set_instance(obj, cxxmem)
        use iso_c_binding, only: C_PTR
        class(struct_as_class), intent(INOUT) :: obj
        type(C_PTR), intent(IN) :: cxxmem
        obj%cxxmem%addr = cxxmem
        obj%cxxmem%idtor = 0
    end subroutine struct_as_class_set_instance

    function struct_as_class_associated(obj) result (rv)
        use iso_c_binding, only: c_associated
        class(struct_as_class), intent(IN) :: obj
        logical rv
        rv = c_associated(obj%cxxmem%addr)
    end function struct_as_class_associated

    ! splicer begin class.StructAsClass.additional_functions
    ! splicer end class.StructAsClass.additional_functions

    ! ----------------------------------------
    ! Function:  void UpdateAsFloat
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float arg
    ! Statement: f_in_native
    subroutine update_as_float(arg)
        use iso_c_binding, only : C_FLOAT
        real(C_FLOAT), value, intent(IN) :: arg
        ! splicer begin function.update_as_float
        call c_update_as_float(arg)
        ! splicer end function.update_as_float
    end subroutine update_as_float

    ! ----------------------------------------
    ! Function:  void UpdateAsDouble
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double arg
    ! Statement: f_in_native
    subroutine update_as_double(arg)
        use iso_c_binding, only : C_DOUBLE
        real(C_DOUBLE), value, intent(IN) :: arg
        ! splicer begin function.update_as_double
        call c_update_as_double(arg)
        ! splicer end function.update_as_double
    end subroutine update_as_double

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  double GetGlobalDouble
    ! Statement: f_function_native
    function get_global_double() &
            result(SHT_rv)
        use iso_c_binding, only : C_DOUBLE
        real(C_DOUBLE) :: SHT_rv
        ! splicer begin function.get_global_double
        SHT_rv = c_get_global_double()
        ! splicer end function.get_global_double
    end function get_global_double
#endif

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void GenericReal
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float arg
    ! Statement: f_in_native
    ! Argument:  double arg
    !>
    !! \brief Single argument generic
    !!
    !<
    ! start generic_real_float
    subroutine generic_real_float(arg)
        use iso_c_binding, only : C_DOUBLE, C_FLOAT
        real(C_FLOAT), value, intent(IN) :: arg
        ! splicer begin function.generic_real_float
        call c_generic_real(real(arg, C_DOUBLE))
        ! splicer end function.generic_real_float
    end subroutine generic_real_float
    ! end generic_real_float

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void GenericReal
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  double arg
    ! Statement: f_in_native
    !>
    !! \brief Single argument generic
    !!
    !<
    ! start generic_real_double
    subroutine generic_real_double(arg)
        use iso_c_binding, only : C_DOUBLE
        real(C_DOUBLE), value, intent(IN) :: arg
        ! splicer begin function.generic_real_double
        call c_generic_real(arg)
        ! splicer end function.generic_real_double
    end subroutine generic_real_double
    ! end generic_real_double

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  long GenericReal2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  int arg1
    ! Statement: f_in_native
    ! Argument:  long arg1
    ! ----------------------------------------
    ! Argument:  int arg2
    ! Statement: f_in_native
    ! Argument:  long arg2
    !>
    !! \brief Two argument generic
    !!
    !! It is not possible to call the function with (int, long)
    !! or (long, int)
    !<
    function generic_real2_all_int(arg1, arg2) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_LONG
        integer(C_INT), value, intent(IN) :: arg1
        integer(C_INT), value, intent(IN) :: arg2
        integer(C_LONG) :: SHT_rv
        ! splicer begin function.generic_real2_all_int
        SHT_rv = c_generic_real2(int(arg1, C_LONG), int(arg2, C_LONG))
        ! splicer end function.generic_real2_all_int
    end function generic_real2_all_int

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  long GenericReal2
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  long arg1
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  long arg2
    ! Statement: f_in_native
    !>
    !! \brief Two argument generic
    !!
    !! It is not possible to call the function with (int, long)
    !! or (long, int)
    !<
    function generic_real2_all_long(arg1, arg2) &
            result(SHT_rv)
        use iso_c_binding, only : C_LONG
        integer(C_LONG), value, intent(IN) :: arg1
        integer(C_LONG), value, intent(IN) :: arg2
        integer(C_LONG) :: SHT_rv
        ! splicer begin function.generic_real2_all_long
        SHT_rv = c_generic_real2(arg1, arg2)
        ! splicer end function.generic_real2_all_long
    end function generic_real2_all_long

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  int SumValues
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  const int *values +dimension(..)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int nvalues
    ! Statement: f_in_native
    !>
    !! \brief scalar or array argument using assumed rank
    !!
    !<
    function sum_values(values, nvalues) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: values(..)
        integer(C_INT), value, intent(IN) :: nvalues
        integer(C_INT) :: SHT_rv
        ! splicer begin function.sum_values
        SHT_rv = c_sum_values_CFI(values, nvalues)
        ! splicer end function.sum_values
    end function sum_values
#endif

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void AssignValues
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *from
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int nfrom
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *to
    ! Statement: f_inout_native*
    ! ----------------------------------------
    ! Argument:  int nto
    ! Statement: f_in_native
    !>
    !! Broadcast if nfrom == 1
    !! Copy if nfrom == nto
    !<
    subroutine assign_values_scalar(from, nfrom, to, nto)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: from
        integer(C_INT), value, intent(IN) :: nfrom
        integer(C_INT), intent(INOUT) :: to
        integer(C_INT), value, intent(IN) :: nto
        ! splicer begin function.assign_values_scalar
        call c_assign_values_scalar_bufferify(from, nfrom, to, nto)
        ! splicer end function.assign_values_scalar
    end subroutine assign_values_scalar

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void AssignValues
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *from
    ! Statement: f_in_native*
    ! ----------------------------------------
    ! Argument:  int nfrom
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *to +rank(1)
    ! Statement: f_inout_native*_cfi
    ! ----------------------------------------
    ! Argument:  int nto
    ! Statement: f_in_native
    !>
    !! Broadcast if nfrom == 1
    !! Copy if nfrom == nto
    !<
    subroutine assign_values_broadcast(from, nfrom, to, nto)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: from
        integer(C_INT), value, intent(IN) :: nfrom
        integer(C_INT), intent(INOUT) :: to(:)
        integer(C_INT), value, intent(IN) :: nto
        ! splicer begin function.assign_values_broadcast
        call c_assign_values_broadcast_CFI(from, nfrom, to, nto)
        ! splicer end function.assign_values_broadcast
    end subroutine assign_values_broadcast

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void AssignValues
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  const int *from +rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int nfrom
    ! Statement: f_in_native
    ! ----------------------------------------
    ! Argument:  int *to +rank(1)
    ! Statement: f_inout_native*_cfi
    ! ----------------------------------------
    ! Argument:  int nto
    ! Statement: f_in_native
    !>
    !! Broadcast if nfrom == 1
    !! Copy if nfrom == nto
    !<
    subroutine assign_values_copy(from, nfrom, to, nto)
        use iso_c_binding, only : C_INT
        integer(C_INT), intent(IN) :: from(:)
        integer(C_INT), value, intent(IN) :: nfrom
        integer(C_INT), intent(INOUT) :: to(:)
        integer(C_INT), value, intent(IN) :: nto
        ! splicer begin function.assign_values_copy
        call c_assign_values_copy_CFI(from, nfrom, to, nto)
        ! splicer end function.assign_values_copy
    end subroutine assign_values_copy

#if 1
    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void SavePointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float *addr +intent(in)+rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int type +implied(T_FLOAT)
    ! Statement: c_default
    ! ----------------------------------------
    ! Argument:  size_t size +implied(size(addr))
    ! Statement: c_default
    subroutine save_pointer_float1d(addr)
        use iso_c_binding, only : C_FLOAT, C_INT, C_SIZE_T
        real(C_FLOAT), intent(IN) :: addr(:)
        integer(C_INT) :: SH_type
        integer(C_SIZE_T) :: SH_size
        ! splicer begin function.save_pointer_float1d
        SH_type = T_FLOAT
        SH_size = size(addr,kind=C_SIZE_T)
        call c_save_pointer_float1d_CFI(addr, SH_type, SH_size)
        ! splicer end function.save_pointer_float1d
    end subroutine save_pointer_float1d
#endif

#if 1
    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void SavePointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float *addr +intent(in)+rank(2)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int type +implied(T_FLOAT)
    ! Statement: c_default
    ! ----------------------------------------
    ! Argument:  size_t size +implied(size(addr))
    ! Statement: c_default
    subroutine save_pointer_float2d(addr)
        use iso_c_binding, only : C_FLOAT, C_INT, C_SIZE_T
        real(C_FLOAT), intent(IN) :: addr(:,:)
        integer(C_INT) :: SH_type
        integer(C_SIZE_T) :: SH_size
        ! splicer begin function.save_pointer_float2d
        SH_type = T_FLOAT
        SH_size = size(addr,kind=C_SIZE_T)
        call c_save_pointer_float2d_CFI(addr, SH_type, SH_size)
        ! splicer end function.save_pointer_float2d
    end subroutine save_pointer_float2d
#endif

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void SavePointer2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float *addr +intent(in)+rank(1)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int type +implied(type(addr))
    ! Statement: c_default
    ! ----------------------------------------
    ! Argument:  size_t size +implied(size(addr))
    ! Statement: c_default
    subroutine save_pointer2_float1d(addr)
        use iso_c_binding, only : C_FLOAT, C_INT, C_SIZE_T
        real(C_FLOAT), intent(IN) :: addr(:)
        integer(C_INT) :: SH_type
        integer(C_SIZE_T) :: SH_size
        ! splicer begin function.save_pointer2_float1d
        SH_type = SH_TYPE_FLOAT
        SH_size = size(addr,kind=C_SIZE_T)
        call c_save_pointer2_float1d_CFI(addr, SH_type, SH_size)
        ! splicer end function.save_pointer2_float1d
    end subroutine save_pointer2_float1d

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void SavePointer2
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float *addr +intent(in)+rank(2)
    ! Statement: f_in_native*_cfi
    ! ----------------------------------------
    ! Argument:  int type +implied(type(addr))
    ! Statement: c_default
    ! ----------------------------------------
    ! Argument:  size_t size +implied(size(addr))
    ! Statement: c_default
    subroutine save_pointer2_float2d(addr)
        use iso_c_binding, only : C_FLOAT, C_INT, C_SIZE_T
        real(C_FLOAT), intent(IN) :: addr(:,:)
        integer(C_INT) :: SH_type
        integer(C_SIZE_T) :: SH_size
        ! splicer begin function.save_pointer2_float2d
        SH_type = SH_TYPE_FLOAT
        SH_size = size(addr,kind=C_SIZE_T)
        call c_save_pointer2_float2d_CFI(addr, SH_type, SH_size)
        ! splicer end function.save_pointer2_float2d
    end subroutine save_pointer2_float2d

#if 0
    ! Only the interface is needed
    ! ----------------------------------------
    ! Function:  void GetPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  void **addr +intent(out)
    ! Statement: f_out_void**
    ! ----------------------------------------
    ! Argument:  int *type +intent(out)
    ! Statement: f_out_native*
    ! ----------------------------------------
    ! Argument:  size_t *size +intent(out)
    ! Statement: f_out_native*
    subroutine get_pointer(addr, type, size)
        use iso_c_binding, only : C_INT, C_PTR, C_SIZE_T
        type(C_PTR), intent(OUT) :: addr
        integer(C_INT), intent(OUT) :: type
        integer(C_SIZE_T), intent(OUT) :: size
        ! splicer begin function.get_pointer
        call c_get_pointer(addr, type, size)
        ! splicer end function.get_pointer
    end subroutine get_pointer
#endif

#if 0
    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void GetPointerAsPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float **addr +deref(pointer)+intent(out)+rank(1)
    ! Statement: f_out_native**_cfi_pointer
    subroutine get_pointer_as_pointer_float1d(addr)
        use iso_c_binding, only : C_FLOAT
        real(C_FLOAT), intent(OUT), pointer :: addr(:)
        ! splicer begin function.get_pointer_as_pointer_float1d
        call c_get_pointer_as_pointer_float1d_CFI(addr)
        ! splicer end function.get_pointer_as_pointer_float1d
    end subroutine get_pointer_as_pointer_float1d
#endif

#if 0
    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  void GetPointerAsPointer
    ! Statement: f_subroutine
    ! ----------------------------------------
    ! Argument:  float **addr +deref(pointer)+intent(out)+rank(2)
    ! Statement: f_out_native**_cfi_pointer
    subroutine get_pointer_as_pointer_float2d(addr)
        use iso_c_binding, only : C_FLOAT
        real(C_FLOAT), intent(OUT), pointer :: addr(:,:)
        ! splicer begin function.get_pointer_as_pointer_float2d
        call c_get_pointer_as_pointer_float2d_CFI(addr)
        ! splicer end function.get_pointer_as_pointer_float2d
    end subroutine get_pointer_as_pointer_float2d
#endif

    ! ----------------------------------------
    ! Function:  StructAsClass *CreateStructAsClass
    ! Statement: f_function_shadow*_capsule
    function create_struct_as_class() &
            result(SHT_rv)
        type(struct_as_class) :: SHT_rv
        ! splicer begin function.create_struct_as_class
        call c_create_struct_as_class_bufferify(SHT_rv%cxxmem)
        ! splicer end function.create_struct_as_class
    end function create_struct_as_class

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  long UpdateStructAsClass
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  StructAsClass *arg
    ! Statement: f_inout_shadow*
    ! ----------------------------------------
    ! Argument:  int inew
    ! Statement: f_in_native
    function update_struct_as_class_int(arg, inew) &
            result(SHT_rv)
        use iso_c_binding, only : C_INT, C_LONG
        type(struct_as_class), intent(INOUT) :: arg
        integer(C_INT), value, intent(IN) :: inew
        integer(C_LONG) :: SHT_rv
        ! splicer begin function.update_struct_as_class_int
        SHT_rv = c_update_struct_as_class_int_bufferify(arg%cxxmem, &
            inew)
        ! splicer end function.update_struct_as_class_int
    end function update_struct_as_class_int

    ! Generated by fortran_generic
    ! ----------------------------------------
    ! Function:  long UpdateStructAsClass
    ! Statement: f_function_native
    ! ----------------------------------------
    ! Argument:  StructAsClass *arg
    ! Statement: f_inout_shadow*
    ! ----------------------------------------
    ! Argument:  long inew
    ! Statement: f_in_native
    function update_struct_as_class_long(arg, inew) &
            result(SHT_rv)
        use iso_c_binding, only : C_LONG
        type(struct_as_class), intent(INOUT) :: arg
        integer(C_LONG), value, intent(IN) :: inew
        integer(C_LONG) :: SHT_rv
        ! splicer begin function.update_struct_as_class_long
        SHT_rv = c_update_struct_as_class_long_bufferify(arg%cxxmem, &
            inew)
        ! splicer end function.update_struct_as_class_long
    end function update_struct_as_class_long

    ! splicer begin additional_functions
    ! splicer end additional_functions

    function struct_as_class_eq(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(struct_as_class), intent(IN) ::a,b
        logical :: rv
        if (c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function struct_as_class_eq

    function struct_as_class_ne(a,b) result (rv)
        use iso_c_binding, only: c_associated
        type(struct_as_class), intent(IN) ::a,b
        logical :: rv
        if (.not. c_associated(a%cxxmem%addr, b%cxxmem%addr)) then
            rv = .true.
        else
            rv = .false.
        endif
    end function struct_as_class_ne

end module generic_mod
